SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";
SET foreign_key_checks = 0;

DROP TABLE IF EXISTS `wp_commentmeta`;
CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;

 
INSERT INTO `wp_commentmeta` VALUES (1, 2, 'akismet_result', 'false'),
 (2, 2, 'akismet_history', 'a:2:{s:4:"time";d:1502219548.3472121;s:5:"event";s:9:"check-ham";}'),
 (3, 2, 'akismet_history', 'a:3:{s:4:"time";d:1502226973.3429999;s:5:"event";s:15:"status-approved";s:4:"user";s:7:"mark014";}'),
 (4, 3, 'akismet_history', 'a:2:{s:4:"time";d:1501888595.7885201;s:5:"event";s:14:"cron-retry-ham";}'),
 (5, 3, 'akismet_history', 'a:3:{s:4:"time";d:1501798993.172996;s:5:"event";s:11:"check-error";s:4:"meta";a:1:{s:8:"response";s:7:"invalid";}}'),
 (6, 3, 'akismet_history', 'a:3:{s:4:"time";d:1501799279.444736;s:5:"event";s:15:"status-approved";s:4:"user";s:7:"mark014";}'),
 (7, 3, 'akismet_result', 'false'),
 (8, 4, 'akismet_result', 'false'),
 (9, 4, 'akismet_history', 'a:2:{s:4:"time";d:1502218670.0758581;s:5:"event";s:9:"check-ham";}'),
 (10, 4, 'akismet_history', 'a:3:{s:4:"time";d:1502226528.926929;s:5:"event";s:15:"status-approved";s:4:"user";s:7:"mark014";}'),
 (11, 5, 'akismet_result', 'false'),
 (12, 5, 'akismet_history', 'a:2:{s:4:"time";d:1502219047.782882;s:5:"event";s:9:"check-ham";}'),
 (13, 5, 'akismet_history', 'a:3:{s:4:"time";d:1502226541.9150181;s:5:"event";s:15:"status-approved";s:4:"user";s:7:"mark014";}'),
 (14, 6, 'akismet_result', 'false'),
 (15, 6, 'akismet_history', 'a:2:{s:4:"time";d:1503502927.1098781;s:5:"event";s:9:"check-ham";}'),
 (16, 7, 'akismet_result', 'false'),
 (17, 7, 'akismet_history', 'a:2:{s:4:"time";d:1503938518.0958331;s:5:"event";s:9:"check-ham";}'),
 (18, 8, 'akismet_result', 'false'),
 (19, 8, 'akismet_history', 'a:2:{s:4:"time";d:1505227832.103888;s:5:"event";s:9:"check-ham";}'),
 (20, 9, 'akismet_result', 'false'),
 (21, 9, 'akismet_history', 'a:2:{s:4:"time";d:1505227474.8520491;s:5:"event";s:9:"check-ham";}'),
 (22, 9, 'akismet_history', 'a:3:{s:4:"time";d:1505227687.729327;s:5:"event";s:15:"status-approved";s:4:"user";s:7:"mark014";}'),
 (23, 10, 'akismet_result', 'false'),
 (24, 10, 'akismet_history', 'a:2:{s:4:"time";d:1507658828.1226201;s:5:"event";s:9:"check-ham";}'),
 (25, 10, 'akismet_history', 'a:3:{s:4:"time";d:1507664652.6691949;s:5:"event";s:15:"status-approved";s:4:"user";s:7:"mark014";}');


DROP TABLE IF EXISTS `wp_comments`;
CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

 
INSERT INTO `wp_comments` VALUES (1, 1, 'Mr WordPress', '', 'https://wordpress.org/', '', '2017-10-23 13:58:06', '2017-10-23 13:58:06', 'Hi, this is a comment.\nTo delete a comment, just log in and view the post&#039;s comments. There you will have the option to edit or delete them.', 0, 'post-trashed', '', '', 0, 0),
 (2, 72, 'kibice26', 'ewel26@onet.pl', '', '188.146.104.43', '2017-08-08 21:12:28', '2017-08-08 19:12:28', 'Holendry-Osiedle Powstańców 6:5\nOsiedle Północ-Glebockie 8:6\nPiotrkowice-Ignacewo 17:5\nHonoratka-Szyszyn 1:11\nWasosze-Polwiosek Stary 6:10', 0, 'post-trashed', '', '', 0, 0),
 (3, 136, 'adnub', 'mark014@gazeta.pl', '', '83.20.37.143', '2017-08-03 20:23:13', '2017-08-03 22:23:13', 'test', 0, 'post-trashed', '', '', 0, 0),
 (4, 364, 'kibice26', 'ewel26@onet.pl', '', '188.146.104.43', '2017-08-08 20:57:50', '2017-08-08 18:57:50', 'Ignacewo-Wasosze 1:9', 0, 'post-trashed', '', '', 0, 0),
 (5, 364, 'kibice26', 'ewel26@onet.pl', '', '188.146.104.43', '2017-08-08 21:04:07', '2017-08-08 19:04:07', 'Ignacewo-Wasosze 1:9\nSzyszyn-Polwiosek Stary 9:3\nHonoratka-Holendry 3:6\nOsiedle Powstańców-Glebockie 7:5\nOsiedle Północ-Piotrkowice 5:4', 0, 'post-trashed', '', '', 0, 0),
 (6, 578, 'kibice26', 'ewel26@onet.pl', '', '188.146.162.227', '2017-08-23 17:42:07', '2017-08-23 15:42:07', 'Piotrkowice-Osiedle Powstańców 11:10\nOsiedle Północ-Wasosze 10:1\nHolendry-Szyszyn 4:4\nPolwiosek Stary-Ignacewo 7:3\nGlebockie-Honoratka 7:4', 0, 'post-trashed', '', '', 0, 0),
 (7, 639, 'kibice26', 'ewel26@onet.pl', '', '188.146.172.103', '2017-08-28 18:41:58', '2017-08-28 16:41:58', 'Holendry-Glebockie 3:6\nHonoratka-Piotrkowice 5:9\nOsiedle Północ-Polwiosek Stary 3:2\nOsiedle Powstańców-Wasosze 8:3\nIgnacewo-Szyszyn 5:4', 0, 'post-trashed', '', '', 0, 0),
 (8, 743, '1', '1@op.pl', '', '178.36.203.133', '2017-09-12 16:50:32', '2017-09-12 14:50:32', 'Pamiętajcie założyć taką plakietkę na szyję że niby jesteście ważni albo znani itp... Po to by wszyscy dawali wam wszystko ze straganów za darmo :)', 0, 'post-trashed', '', '', 0, 0),
 (9, 745, '1', '1@op.pl', '', '178.36.203.133', '2017-09-12 16:44:34', '2017-09-12 14:44:34', 'No to super! Piękna promocja naszej gminy.Napiszcie jak jest brudno w turystycznym mieście i na jeziorami!!!', 0, 'post-trashed', '', '', 0, 0),
 (10, 841, 'Zbys', 'Zbys@wp.pl', 'http://Wp', '37.248.164.58', '2017-10-10 20:07:08', '2017-10-10 18:07:08', 'Chyba DK25', 0, 'post-trashed', '', '', 0, 0),
 (11, 1169, 'rty', 'mark014@gazeta.pl', '', '95.108.116.212', '2017-10-26 09:41:22', '2017-10-26 07:41:22', 'testowy komentarz', 0, '1', 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/61.0.3163.100 Safari/537.36', '', 0, 0);


DROP TABLE IF EXISTS `wp_links`;
CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_options`;
CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=451 DEFAULT CHARSET=utf8;

 
INSERT INTO `wp_options` VALUES (1, 'siteurl', 'http://serwer1761710.home.pl/autoinstalator/wordpress', 'yes'),
 (2, 'home', 'http://serwer1761710.home.pl/autoinstalator/wordpress', 'yes'),
 (3, 'blogname', 'METEOprognoza', 'yes'),
 (4, 'blogdescription', 'Pogoda to nasz żywioł', 'yes'),
 (5, 'users_can_register', '1', 'yes'),
 (6, 'admin_email', 'mark014@gazeta.pl', 'yes'),
 (7, 'start_of_week', '1', 'yes'),
 (8, 'use_balanceTags', '0', 'yes'),
 (9, 'use_smilies', '1', 'yes'),
 (10, 'require_name_email', '1', 'yes'),
 (11, 'comments_notify', '1', 'yes'),
 (12, 'posts_per_rss', '10', 'yes'),
 (13, 'rss_use_excerpt', '0', 'yes'),
 (14, 'mailserver_url', 'mail.example.com', 'yes'),
 (15, 'mailserver_login', 'login@example.com', 'yes'),
 (16, 'mailserver_pass', 'password', 'yes'),
 (17, 'mailserver_port', '110', 'yes'),
 (18, 'default_category', '51', 'yes'),
 (19, 'default_comment_status', 'open', 'yes'),
 (20, 'default_ping_status', 'open', 'yes'),
 (21, 'default_pingback_flag', '1', 'yes'),
 (22, 'posts_per_page', '10', 'yes'),
 (23, 'date_format', 'F j, Y', 'yes'),
 (24, 'time_format', 'g:i a', 'yes'),
 (25, 'links_updated_date_format', 'F j, Y g:i a', 'yes'),
 (26, 'comment_moderation', '', 'yes'),
 (27, 'moderation_notify', '1', 'yes'),
 (28, 'permalink_structure', '/%year%/%monthnum%/%day%/%postname%/', 'yes'),
 (30, 'hack_file', '0', 'yes'),
 (31, 'blog_charset', 'UTF-8', 'yes'),
 (32, 'moderation_keys', '', 'no'),
 (33, 'active_plugins', 'a:4:{i:0;s:23:"backup-wd/backup-wd.php";i:1;s:44:"custom-twitter-feeds/custom-twitter-feed.php";i:2;s:37:"wd-facebook-feed/facebook-feed-wd.php";i:3;s:41:"wordpress-importer/wordpress-importer.php";}', 'yes'),
 (34, 'category_base', '', 'yes'),
 (35, 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'),
 (36, 'comment_max_links', '2', 'yes'),
 (37, 'gmt_offset', '2', 'yes'),
 (38, 'default_email_category', '1', 'yes'),
 (39, 'recently_edited', 'a:2:{i:0;s:82:"/autoinstalator/wordpress/wp-content/plugins/wd-facebook-feed/facebook-feed-wd.php";i:2;s:0:"";}', 'no'),
 (40, 'template', 'mesocolumn', 'yes'),
 (41, 'stylesheet', 'mesocolumn', 'yes'),
 (42, 'comment_whitelist', '1', 'yes'),
 (43, 'blacklist_keys', '', 'no'),
 (44, 'comment_registration', '', 'yes'),
 (45, 'html_type', 'text/html', 'yes'),
 (46, 'use_trackback', '0', 'yes'),
 (47, 'default_role', 'subscriber', 'yes'),
 (48, 'db_version', '38590', 'yes'),
 (49, 'uploads_use_yearmonth_folders', '1', 'yes'),
 (50, 'upload_path', '', 'yes'),
 (51, 'blog_public', '1', 'yes'),
 (52, 'default_link_category', '0', 'yes'),
 (53, 'show_on_front', 'posts', 'yes'),
 (54, 'tag_base', '', 'yes'),
 (55, 'show_avatars', '1', 'yes'),
 (56, 'avatar_rating', 'G', 'yes'),
 (57, 'upload_url_path', '', 'yes'),
 (58, 'thumbnail_size_w', '150', 'yes'),
 (59, 'thumbnail_size_h', '150', 'yes'),
 (60, 'thumbnail_crop', '1', 'yes'),
 (61, 'medium_size_w', '300', 'yes'),
 (62, 'medium_size_h', '300', 'yes'),
 (63, 'avatar_default', 'mystery', 'yes'),
 (64, 'large_size_w', '1024', 'yes'),
 (65, 'large_size_h', '1024', 'yes'),
 (66, 'image_default_link_type', '', 'yes'),
 (67, 'image_default_size', '', 'yes'),
 (68, 'image_default_align', '', 'yes'),
 (69, 'close_comments_for_old_posts', '', 'yes'),
 (70, 'close_comments_days_old', '14', 'yes'),
 (71, 'thread_comments', '1', 'yes'),
 (72, 'thread_comments_depth', '5', 'yes'),
 (73, 'page_comments', '', 'yes'),
 (74, 'comments_per_page', '50', 'yes'),
 (75, 'default_comments_page', 'newest', 'yes'),
 (76, 'comment_order', 'asc', 'yes'),
 (77, 'sticky_posts', 'a:0:{}', 'yes'),
 (78, 'widget_categories', 'a:2:{i:2;a:4:{s:5:"title";s:0:"";s:5:"count";i:0;s:12:"hierarchical";i:0;s:8:"dropdown";i:0;}s:12:"_multiwidget";i:1;}', 'yes'),
 (79, 'widget_text', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
 (80, 'widget_rss', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
 (81, 'uninstall_plugins', 'a:0:{}', 'no'),
 (82, 'timezone_string', '', 'yes'),
 (83, 'page_for_posts', '0', 'yes'),
 (84, 'page_on_front', '0', 'yes'),
 (85, 'default_post_format', '0', 'yes'),
 (86, 'link_manager_enabled', '0', 'yes'),
 (87, 'finished_splitting_shared_terms', '1', 'yes'),
 (88, 'site_icon', '902', 'yes'),
 (89, 'medium_large_size_w', '768', 'yes'),
 (90, 'medium_large_size_h', '0', 'yes'),
 (91, 'initial_db_version', '36686', 'yes'),
 (92, 'wp_user_roles', 'a:8:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:77:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;s:9:"buwd_edit";b:1;s:8:"buwd_job";b:1;s:13:"buwd_job_edit";b:1;s:15:"buwd_job_delete";b:1;s:12:"buwd_job_run";b:1;s:13:"buwd_api_keys";b:1;s:13:"buwd_settings";b:1;s:20:"buwd_settings_import";b:1;s:20:"buwd_settings_export";b:1;s:9:"buwd_logs";b:1;s:13:"buwd_log_view";b:1;s:15:"buwd_log_delete";b:1;s:17:"buwd_log_download";b:1;s:12:"buwd_backups";b:1;s:19:"buwd_backups_delete";b:1;s:21:"buwd_backups_download";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:34:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:10:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:5:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}s:10:"buwd_admin";a:2:{s:4:"name";s:15:"Backup WD Admin";s:12:"capabilities";a:17:{s:4:"read";b:1;s:9:"buwd_edit";b:1;s:8:"buwd_job";b:1;s:13:"buwd_job_edit";b:1;s:15:"buwd_job_delete";b:1;s:12:"buwd_job_run";b:1;s:13:"buwd_api_keys";b:1;s:9:"buwd_logs";b:1;s:13:"buwd_settings";b:1;s:20:"buwd_settings_import";b:1;s:20:"buwd_settings_export";b:1;s:13:"buwd_log_view";b:1;s:15:"buwd_log_delete";b:1;s:17:"buwd_log_download";b:1;s:12:"buwd_backups";b:1;s:19:"buwd_backups_delete";b:1;s:21:"buwd_backups_download";b:1;}}s:11:"buwd_helper";a:2:{s:4:"name";s:16:"Backup WD Helper";s:12:"capabilities";a:17:{s:4:"read";b:1;s:9:"buwd_edit";b:1;s:8:"buwd_job";b:1;s:13:"buwd_job_edit";b:0;s:15:"buwd_job_delete";b:0;s:12:"buwd_job_run";b:1;s:13:"buwd_api_keys";b:0;s:13:"buwd_settings";b:0;s:20:"buwd_settings_import";b:0;s:20:"buwd_settings_export";b:0;s:9:"buwd_logs";b:1;s:13:"buwd_log_view";b:1;s:15:"buwd_log_delete";b:0;s:17:"buwd_log_download";b:1;s:12:"buwd_backups";b:1;s:19:"buwd_backups_delete";b:0;s:21:"buwd_backups_download";b:1;}}s:12:"buwd_checker";a:2:{s:4:"name";s:17:"Backup WD Checker";s:12:"capabilities";a:17:{s:4:"read";b:1;s:9:"buwd_edit";b:1;s:8:"buwd_job";b:1;s:13:"buwd_job_edit";b:0;s:15:"buwd_job_delete";b:0;s:12:"buwd_job_run";b:0;s:13:"buwd_api_keys";b:0;s:13:"buwd_settings";b:0;s:20:"buwd_settings_import";b:0;s:20:"buwd_settings_export";b:0;s:9:"buwd_logs";b:1;s:13:"buwd_log_view";b:1;s:15:"buwd_log_delete";b:0;s:17:"buwd_log_download";b:0;s:12:"buwd_backups";b:1;s:19:"buwd_backups_delete";b:0;s:21:"buwd_backups_download";b:0;}}}', 'yes'),
 (93, 'widget_search', 'a:2:{i:2;a:1:{s:5:"title";s:0:"";}s:12:"_multiwidget";i:1;}', 'yes'),
 (94, 'widget_recent-posts', 'a:2:{i:2;a:3:{s:5:"title";s:15:"Najnowsze wpisy";s:6:"number";i:5;s:9:"show_date";b:1;}s:12:"_multiwidget";i:1;}', 'yes'),
 (95, 'widget_recent-comments', 'a:2:{i:2;a:2:{s:5:"title";s:0:"";s:6:"number";i:5;}s:12:"_multiwidget";i:1;}', 'yes'),
 (96, 'widget_archives', 'a:2:{i:2;a:3:{s:5:"title";s:0:"";s:5:"count";i:0;s:8:"dropdown";i:0;}s:12:"_multiwidget";i:1;}', 'yes'),
 (97, 'widget_meta', 'a:2:{i:2;a:1:{s:5:"title";s:0:"";}s:12:"_multiwidget";i:1;}', 'yes'),
 (98, 'sidebars_widgets', 'a:8:{s:19:"wp_inactive_widgets";a:0:{}s:14:"tabbed-sidebar";a:1:{i:0;s:12:"categories-2";}s:13:"right-sidebar";a:7:{i:0;s:29:"custom-twitter-feeds-widget-2";i:1;s:11:"ffwd_info-2";i:2;s:17:"recent-comments-2";i:3;s:14:"recent-posts-2";i:4;s:8:"search-2";i:5;s:10:"archives-2";i:6;s:6:"meta-2";}s:24:"first-footer-widget-area";a:0:{}s:25:"second-footer-widget-area";a:0:{}s:24:"third-footer-widget-area";a:0:{}s:25:"fourth-footer-widget-area";a:0:{}s:13:"array_version";i:3;}', 'yes'),
 (99, 'widget_pages', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (100, 'widget_calendar', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (101, 'widget_tag_cloud', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (102, 'widget_nav_menu', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (103, 'cron', 'a:5:{i:1509006019;a:1:{s:25:"wd_fb_schedule_event_hook";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:25:"wd_fb_autoupdate_interval";s:4:"args";a:0:{}s:8:"interval";i:1800;}}}i:1509026583;a:1:{s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1509032906;a:3:{s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1509033034;a:1:{s:30:"wp_scheduled_auto_draft_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}s:7:"version";i:2;}', 'yes'),
 (105, '_transient_twentysixteen_categories', '1', 'yes'),
 (106, 'WPLANG', 'pl_PL', 'yes'),
 (107, 'widget_media_audio', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (108, 'widget_media_image', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (109, 'widget_media_video', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (110, 'widget_custom_html', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (113, 'rewrite_rules', 'a:89:{s:11:"^wp-json/?$";s:22:"index.php?rest_route=/";s:14:"^wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:21:"^index.php/wp-json/?$";s:22:"index.php?rest_route=/";s:24:"^index.php/wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:47:"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:42:"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:23:"category/(.+?)/embed/?$";s:46:"index.php?category_name=$matches[1]&embed=true";s:35:"category/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:17:"category/(.+?)/?$";s:35:"index.php?category_name=$matches[1]";s:44:"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:39:"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:20:"tag/([^/]+)/embed/?$";s:36:"index.php?tag=$matches[1]&embed=true";s:32:"tag/([^/]+)/page/?([0-9]{1,})/?$";s:43:"index.php?tag=$matches[1]&paged=$matches[2]";s:14:"tag/([^/]+)/?$";s:25:"index.php?tag=$matches[1]";s:45:"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:40:"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:21:"type/([^/]+)/embed/?$";s:44:"index.php?post_format=$matches[1]&embed=true";s:33:"type/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?post_format=$matches[1]&paged=$matches[2]";s:15:"type/([^/]+)/?$";s:33:"index.php?post_format=$matches[1]";s:48:".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$";s:18:"index.php?feed=old";s:20:".*wp-app\\.php(/.*)?$";s:19:"index.php?error=403";s:18:".*wp-register.php$";s:23:"index.php?register=true";s:32:"feed/(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:27:"(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:8:"embed/?$";s:21:"index.php?&embed=true";s:20:"page/?([0-9]{1,})/?$";s:28:"index.php?&paged=$matches[1]";s:41:"comments/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:36:"comments/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:17:"comments/embed/?$";s:21:"index.php?&embed=true";s:44:"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:39:"search/(.+)/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:20:"search/(.+)/embed/?$";s:34:"index.php?s=$matches[1]&embed=true";s:32:"search/(.+)/page/?([0-9]{1,})/?$";s:41:"index.php?s=$matches[1]&paged=$matches[2]";s:14:"search/(.+)/?$";s:23:"index.php?s=$matches[1]";s:47:"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:42:"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:23:"author/([^/]+)/embed/?$";s:44:"index.php?author_name=$matches[1]&embed=true";s:35:"author/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?author_name=$matches[1]&paged=$matches[2]";s:17:"author/([^/]+)/?$";s:33:"index.php?author_name=$matches[1]";s:69:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:45:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$";s:74:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]";s:39:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$";s:63:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]";s:56:"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:51:"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:32:"([0-9]{4})/([0-9]{1,2})/embed/?$";s:58:"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true";s:44:"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]";s:26:"([0-9]{4})/([0-9]{1,2})/?$";s:47:"index.php?year=$matches[1]&monthnum=$matches[2]";s:43:"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:38:"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:19:"([0-9]{4})/embed/?$";s:37:"index.php?year=$matches[1]&embed=true";s:31:"([0-9]{4})/page/?([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&paged=$matches[2]";s:13:"([0-9]{4})/?$";s:26:"index.php?year=$matches[1]";s:58:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:68:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:88:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:83:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:83:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:64:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:53:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$";s:91:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$";s:85:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1";s:77:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]";s:72:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]";s:65:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$";s:98:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]";s:72:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$";s:98:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]";s:61:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]";s:47:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:57:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:77:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:72:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:72:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:53:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]";s:51:"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]";s:38:"([0-9]{4})/comment-page-([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&cpage=$matches[2]";s:27:".?.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:".?.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:".?.+?/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"(.?.+?)/embed/?$";s:41:"index.php?pagename=$matches[1]&embed=true";s:20:"(.?.+?)/trackback/?$";s:35:"index.php?pagename=$matches[1]&tb=1";s:40:"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:35:"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:28:"(.?.+?)/page/?([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&paged=$matches[2]";s:35:"(.?.+?)/comment-page-([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&cpage=$matches[2]";s:24:"(.?.+?)(?:/([0-9]+))?/?$";s:47:"index.php?pagename=$matches[1]&page=$matches[2]";}', 'yes'),
 (114, 'db_upgraded', '', 'yes'),
 (124, '_site_transient_timeout_browser_a8fa04da005937516d8bdfff00fdbe54', '1509372185', 'no'),
 (125, '_site_transient_browser_a8fa04da005937516d8bdfff00fdbe54', 'a:10:{s:4:"name";s:6:"Chrome";s:7:"version";s:13:"61.0.3163.100";s:8:"platform";s:7:"Windows";s:10:"update_url";s:29:"https://www.google.com/chrome";s:7:"img_src";s:43:"http://s.w.org/images/browsers/chrome.png?1";s:11:"img_src_ssl";s:44:"https://s.w.org/images/browsers/chrome.png?1";s:15:"current_version";s:2:"18";s:7:"upgrade";b:0;s:8:"insecure";b:0;s:6:"mobile";b:0;}', 'no'),
 (128, 'can_compress_scripts', '0', 'no'),
 (142, 'theme_mods_twentyseventeen', 'a:2:{s:18:"custom_css_post_id";i:-1;s:16:"sidebars_widgets";a:2:{s:4:"time";i:1508769689;s:4:"data";a:2:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:6:{i:0;s:8:"search-2";i:1;s:14:"recent-posts-2";i:2;s:17:"recent-comments-2";i:3;s:10:"archives-2";i:4;s:12:"categories-2";i:5;s:6:"meta-2";}}}}', 'yes'),
 (144, '_site_transient_timeout_wporg_theme_feature_list', '1508780447', 'no'),
 (145, '_site_transient_wporg_theme_feature_list', 'a:3:{s:6:"Layout";a:7:{i:0;s:11:"grid-layout";i:1;s:10:"one-column";i:2;s:11:"two-columns";i:3;s:13:"three-columns";i:4;s:12:"four-columns";i:5;s:12:"left-sidebar";i:6;s:13:"right-sidebar";}s:8:"Features";a:20:{i:0;s:19:"accessibility-ready";i:1;s:10:"buddypress";i:2;s:17:"custom-background";i:3;s:13:"custom-colors";i:4;s:13:"custom-header";i:5;s:11:"custom-menu";i:6;s:12:"editor-style";i:7;s:21:"featured-image-header";i:8;s:15:"featured-images";i:9;s:15:"flexible-header";i:10;s:14:"footer-widgets";i:11;s:20:"front-page-post-form";i:12;s:19:"full-width-template";i:13;s:12:"microformats";i:14;s:12:"post-formats";i:15;s:20:"rtl-language-support";i:16;s:11:"sticky-post";i:17;s:13:"theme-options";i:18;s:17:"threaded-comments";i:19;s:17:"translation-ready";}s:7:"Subject";a:9:{i:0;s:4:"blog";i:1;s:10:"e-commerce";i:2;s:9:"education";i:3;s:13:"entertainment";i:4;s:14:"food-and-drink";i:5;s:7:"holiday";i:6;s:4:"news";i:7;s:11:"photography";i:8;s:9:"portfolio";}}', 'no'),
 (146, '_site_transient_timeout_popular_importers_f512292365d452ee63ee3d740e188edc', '1508942148', 'no'),
 (147, '_site_transient_popular_importers_f512292365d452ee63ee3d740e188edc', 'a:2:{s:9:"importers";a:8:{s:7:"blogger";a:4:{s:4:"name";s:7:"Blogger";s:11:"description";s:54:"Import posts, comments, and users from a Blogger blog.";s:11:"plugin-slug";s:16:"blogger-importer";s:11:"importer-id";s:7:"blogger";}s:9:"wpcat2tag";a:4:{s:4:"name";s:29:"Categories and Tags Converter";s:11:"description";s:71:"Convert existing categories to tags or tags to categories, selectively.";s:11:"plugin-slug";s:18:"wpcat2tag-importer";s:11:"importer-id";s:10:"wp-cat2tag";}s:11:"livejournal";a:4:{s:4:"name";s:11:"LiveJournal";s:11:"description";s:46:"Import posts from LiveJournal using their API.";s:11:"plugin-slug";s:20:"livejournal-importer";s:11:"importer-id";s:11:"livejournal";}s:11:"movabletype";a:4:{s:4:"name";s:24:"Movable Type and TypePad";s:11:"description";s:62:"Import posts and comments from a Movable Type or TypePad blog.";s:11:"plugin-slug";s:20:"movabletype-importer";s:11:"importer-id";s:2:"mt";}s:4:"opml";a:4:{s:4:"name";s:8:"Blogroll";s:11:"description";s:28:"Import links in OPML format.";s:11:"plugin-slug";s:13:"opml-importer";s:11:"importer-id";s:4:"opml";}s:3:"rss";a:4:{s:4:"name";s:3:"RSS";s:11:"description";s:30:"Import posts from an RSS feed.";s:11:"plugin-slug";s:12:"rss-importer";s:11:"importer-id";s:3:"rss";}s:6:"tumblr";a:4:{s:4:"name";s:6:"Tumblr";s:11:"description";s:53:"Import posts &amp; media from Tumblr using their API.";s:11:"plugin-slug";s:15:"tumblr-importer";s:11:"importer-id";s:6:"tumblr";}s:9:"wordpress";a:4:{s:4:"name";s:9:"WordPress";s:11:"description";s:96:"Import posts, pages, comments, custom fields, categories, and tags from a WordPress export file.";s:11:"plugin-slug";s:18:"wordpress-importer";s:11:"importer-id";s:9:"wordpress";}}s:10:"translated";b:0;}', 'no'),
 (154, 'recently_activated', 'a:0:{}', 'yes'),
 (156, 'fresh_site', '0', 'yes'),
 (162, 'current_theme', 'MesoColumn', 'yes'),
 (163, 'theme_mods_mesocolumn', 'a:43:{i:0;b:0;s:18:"custom_css_post_id";i:-1;s:11:"header_logo";s:103:"http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/10/meteoprognoza-logo.png";s:8:"fav_icon";s:98:"http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/10/print-logo2pr.jpg";s:13:"feat_img_size";s:6:"medium";s:14:"blogpost_style";s:8:"magazine";s:21:"post_excerpt_moretext";s:12:"czytaj dalej";s:10:"related_on";s:6:"enable";s:9:"slider_on";s:6:"enable";s:8:"feat_cat";s:29:"Prognoza pogody, Podsumowania";s:14:"feat_cat_count";i:6;s:13:"footer_credit";s:6:"enable";s:9:"schema_on";s:6:"enable";s:20:"schema_breadcrumb_on";s:6:"enable";s:15:"responsive_mode";s:6:"enable";s:14:"side_feat_cat1";s:2:"51";s:20:"side_feat_cat1_count";s:1:"5";s:14:"side_feat_cat2";s:2:"52";s:20:"side_feat_cat2_count";s:1:"4";s:14:"side_feat_cat3";s:2:"53";s:20:"side_feat_cat3_count";s:1:"5";s:14:"side_feat_cat4";s:2:"54";s:20:"side_feat_cat4_count";s:1:"5";s:11:"feat_layout";s:7:"default";s:21:"custom_header_overlay";s:3:"yes";s:18:"nav_menu_locations";a:4:{s:7:"primary";i:49;s:3:"top";i:0;s:6:"footer";i:0;s:6:"mobile";i:0;}s:13:"slider_height";i:300;s:9:"feat_post";s:0:"";s:12:"cat_color_54";s:7:"#dd0000";s:12:"cat_color_52";s:7:"#16ad6e";s:12:"cat_color_51";s:7:"#ad278c";s:12:"cat_color_53";s:7:"#ffaa00";s:13:"author_bio_on";s:7:"disable";s:12:"allow_subcat";s:6:"enable";s:15:"page_color_1140";s:7:"#1e73be";s:15:"page_color_1145";s:7:"#3ba9bf";s:15:"page_color_1147";s:7:"#e033cc";s:15:"page_color_1150";s:7:"#acd642";s:15:"page_color_1153";s:7:"#3625ed";s:10:"main_color";s:0:"";s:12:"topnav_color";s:7:"#002191";s:15:"feat_text_count";s:3:"100";s:15:"page_color_1166";s:7:"#8224e3";}', 'yes'),
 (164, 'theme_switched', '', 'yes'),
 (165, 'widget_meso_most_commented_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (166, 'widget_meso_recent_comments_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (167, 'widget_meso_featured_multi_cpt_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (168, 'widget_meso_featured_multi_category_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (215, '_transient_timeout_oembed_18a8014cbd976796a4a1a24c69994066', '1508860975', 'no'),
 (216, '_transient_oembed_18a8014cbd976796a4a1a24c69994066', 'O:8:"stdClass":11:{s:11:"author_name";s:29:"The Weather Channel Originals";s:10:"author_url";s:49:"https://www.facebook.com/WeatherChannelOriginals/";s:12:"provider_url";s:24:"https://www.facebook.com";s:13:"provider_name";s:8:"Facebook";s:7:"success";b:1;s:6:"height";i:337;s:4:"html";s:1005:"<div id="fb-root"></div>\n<script>(function(d, s, id) {\n  var js, fjs = d.getElementsByTagName(s)[0];\n  if (d.getElementById(id)) return;\n  js = d.createElement(s); js.id = id;\n  js.src = \'https://connect.facebook.net/pl_PL/sdk.js#xfbml=1&version=v2.10\';\n  fjs.parentNode.insertBefore(js, fjs);\n}(document, \'script\', \'facebook-jssdk\'));</script><div class="fb-video" data-href="https://www.facebook.com/WeatherChannelOriginals/videos/1651628711524295/" data-width="600"><blockquote cite="https://www.facebook.com/WeatherChannelOriginals/videos/1651628711524295/" class="fb-xfbml-parse-ignore"><a href="https://www.facebook.com/WeatherChannelOriginals/videos/1651628711524295/"></a><p>Can you spot this woman trying to escape from a mudslide? We have a Weather Gone Viral marathon this Sunday starting at 1 pm and a brand new episode at 8 pm (ET)!</p>Opublikowany przez <a href="https://www.facebook.com/WeatherChannelOriginals/">The Weather Channel Originals</a> na 21 października 2017</blockquote></div>";s:4:"type";s:5:"video";s:7:"version";s:3:"1.0";s:3:"url";s:73:"https://www.facebook.com/WeatherChannelOriginals/videos/1651628711524295/";s:5:"width";i:600;}', 'no'),
 (258, 'ffwd_version', '1.0.28', 'yes'),
 (259, 'widget_ffwd_info', 'a:2:{i:2;a:5:{s:5:"title";s:26:"Meteoprognoza na Facebooku";s:2:"id";s:1:"1";s:5:"count";s:1:"5";s:5:"width";s:3:"500";s:6:"height";s:4:"1000";}s:12:"_multiwidget";i:1;}', 'yes'),
 (261, '_transient_timeout_plugin_slugs', '1509090611', 'no'),
 (262, '_transient_plugin_slugs', 'a:6:{i:0;s:19:"akismet/akismet.php";i:1;s:23:"backup-wd/backup-wd.php";i:2;s:44:"custom-twitter-feeds/custom-twitter-feed.php";i:3;s:37:"wd-facebook-feed/facebook-feed-wd.php";i:4;s:9:"hello.php";i:5;s:41:"wordpress-importer/wordpress-importer.php";}', 'no'),
 (263, 'ffwd_admin_notice', 'a:1:{s:15:"two_week_review";a:2:{s:5:"start";s:9:"11/7/2017";s:3:"int";i:14;}}', 'yes'),
 (264, 'ffwd_autoupdate_time', '1509012663', 'yes'),
 (269, 'ffwd_subscribe_done', '1', 'yes'),
 (271, 'wd_bk_notice_status', '1', 'no'),
 (273, 'buwd_version', '1.0.6', 'no'),
 (274, 'buwd_hash', '4a37ce', 'no'),
 (275, 'buwd_settings', 'a:14:{s:11:"show_on_bar";a:1:{i:0;s:1:"1";}s:10:"log_folder";s:44:"wp-content/uploads/backup-wd-logs-{hash_key}";s:12:"job_step_max";i:3;s:11:"auth_method";s:4:"none";s:13:"max_exec_time";i:300;s:13:"job_start_key";s:7:"167ea42";s:15:"red_server_load";s:8:"disabled";s:13:"max_log_files";i:15;s:9:"log_level";s:17:"normal_translated";s:8:"hash_key";s:6:"4a37ce";s:9:"recipient";s:17:"mark014@gazeta.pl";s:10:"email_from";s:17:"mark014@gazeta.pl";s:4:"from";s:13:"METEOprognoza";s:7:"subject";s:10:"Backup log";}', 'no'),
 (276, 'buwd_jobs', 'a:4:{i:1;a:96:{s:4:"name";s:15:"Database Backup";s:4:"type";a:1:{i:0;s:2:"db";}s:11:"destination";a:1:{i:0;s:6:"folder";}s:11:"backup_type";s:7:"archive";s:12:"archive_name";s:37:"backupwd_{hash_key}_%Y-%m-%d_%H-%i-%s";s:14:"archive_format";s:3:"zip";s:8:"schedule";s:8:"manually";s:12:"scheduletype";s:5:"basic";s:13:"schedulemonth";a:13:{i:0;s:3:"any";i:1;s:1:"1";i:2;s:1:"2";i:3;s:1:"3";i:4;s:1:"4";i:5;s:1:"5";i:6;s:1:"6";i:7;s:1:"7";i:8;s:1:"8";i:9;s:1:"9";i:10;s:2:"10";i:11;s:2:"11";i:12;s:2:"12";}s:12:"scheduleweek";a:1:{i:0;s:1:"1";}s:12:"dbtables_all";a:0:{}s:8:"dbtables";a:17:{s:14:"wp_commentmeta";s:14:"wp_commentmeta";s:11:"wp_comments";s:11:"wp_comments";s:8:"wp_links";s:8:"wp_links";s:10:"wp_options";s:10:"wp_options";s:11:"wp_postmeta";s:11:"wp_postmeta";s:8:"wp_posts";s:8:"wp_posts";s:21:"wp_term_relationships";s:21:"wp_term_relationships";s:16:"wp_term_taxonomy";s:16:"wp_term_taxonomy";s:11:"wp_termmeta";s:11:"wp_termmeta";s:8:"wp_terms";s:8:"wp_terms";s:11:"wp_usermeta";s:11:"wp_usermeta";s:8:"wp_users";s:8:"wp_users";s:13:"wp_wd_fb_data";s:13:"wp_wd_fb_data";s:13:"wp_wd_fb_info";s:13:"wp_wd_fb_info";s:15:"wp_wd_fb_option";s:15:"wp_wd_fb_option";s:18:"wp_wd_fb_shortcode";s:18:"wp_wd_fb_shortcode";s:14:"wp_wd_fb_theme";s:14:"wp_wd_fb_theme";}s:10:"dbfilename";s:16:"25703466_0000001";s:17:"use_wp_connection";s:1:"1";s:10:"dbfilecomp";s:4:"none";s:7:"db_host";s:0:"";s:7:"db_user";s:0:"";s:11:"db_password";s:0:"";s:7:"db_name";s:0:"";s:8:"bup_root";s:0:"";s:11:"bup_content";s:0:"";s:19:"bup_content_exclude";s:0:"";s:11:"bup_plugins";s:1:"1";s:19:"bup_plugins_exclude";a:1:{i:0;s:9:"backup-wd";}s:10:"bup_themes";s:1:"1";s:11:"bup_uploads";s:1:"1";s:17:"bup_extra_folders";s:0:"";s:19:"bup_uploads_exclude";a:3:{i:0;s:21:"backup-wd-logs-4a37ce";i:1;s:21:"backup-wd-temp-4a37ce";i:2;s:16:"backup-wd-4a37ce";}s:20:"bup_include_specials";s:1:"1";s:13:"exclude_types";s:51:".tmp,.svn,.git,desktop.ini,.DS_Store,/node_modules/";s:16:"use_folder_as_wp";s:1:"0";s:10:"folderpath";s:43:"wp-content/uploads/backup-wd-db-{hash_key}/";s:12:"folderdelete";i:15;s:16:"folderdeletesync";s:1:"1";s:12:"gdrivefolder";s:14:"METEOprognoza/";s:16:"gdrivefiledelete";i:15;s:20:"gdrivefiledeletesync";s:1:"1";s:9:"s3service";s:9:"us-east-1";s:11:"s3accesskey";s:0:"";s:12:"s3privatekey";s:0:"";s:8:"s3bucket";s:0:"";s:11:"s3newbucket";s:0:"";s:14:"s3bucketfolder";s:14:"METEOprognoza/";s:12:"s3filedelete";i:15;s:16:"s3filedeletesync";s:1:"1";s:13:"s3multiupload";s:1:"1";s:14:"s3storageclass";s:8:"standard";s:18:"s3serverencryption";s:1:"1";s:9:"dboxtoken";s:0:"";s:8:"dboxtype";s:7:"sandbox";s:10:"dboxfolder";s:14:"METEOprognoza/";s:14:"dboxfiledelete";i:15;s:18:"dboxfiledeletesync";s:1:"1";s:9:"azurename";s:0:"";s:8:"azurekey";s:0:"";s:12:"azurenewcont";s:0:"";s:11:"azurefolder";s:14:"METEOprognoza/";s:15:"azurefiledelete";i:15;s:19:"azurefiledeletesync";s:1:"1";s:7:"rscuser";s:0:"";s:6:"rsckey";s:0:"";s:9:"rscregion";s:3:"DFW";s:12:"rsccontainer";s:0:"";s:10:"rscnewcont";s:0:"";s:9:"rscfolder";s:14:"METEOprognoza/";s:13:"rscfiledelete";i:15;s:17:"rscfiledeletesync";s:1:"1";s:9:"ftpserver";s:0:"";s:7:"ftpport";i:21;s:7:"ftpuser";s:0:"";s:7:"ftppass";s:0:"";s:9:"ftpfolder";s:14:"METEOprognoza/";s:13:"ftpfiledelete";i:15;s:10:"ftptimeout";i:90;s:6:"ftpssl";s:0:"";s:8:"ftppmode";s:1:"1";s:10:"sugartoken";s:0:"";s:9:"sugaruser";s:0:"";s:15:"sugarsyncfolder";s:0:"";s:11:"sugarfolder";s:14:"METEOprognoza/";s:15:"sugarfiledelete";i:15;s:14:"glacier_region";s:9:"us-east-1";s:17:"glacier_accesskey";s:0:"";s:18:"glacier_privatekey";s:0:"";s:16:"glacier_newvault";s:0:"";s:18:"glacier_filedelete";i:15;s:10:"send_email";s:0:"";s:6:"job_id";i:6;s:15:"cron_expression";s:9:"0 0 * * *";s:12:"schedulelink";s:123:"http://serwer1761710.home.pl/autoinstalator/wordpress/wp-cron.php?jobid=1&amp;buwd_cron=1&amp;type=run&amp;_wpnonce=167ea42";s:3:"day";s:0:"";s:11:"scheduleday";s:0:"";s:12:"schedulehour";s:2:"00";s:14:"scheduleminute";s:2:"00";s:7:"lastrun";i:1509004365;s:13:"last_log_file";s:44:"backupwd_log_4a37ce_2017-10-26_09-52-45.html";}i:2;a:96:{s:4:"name";s:12:"Files Backup";s:4:"type";a:1:{i:0;s:5:"files";}s:11:"destination";a:1:{i:0;s:6:"folder";}s:11:"backup_type";s:7:"archive";s:12:"archive_name";s:37:"backupwd_{hash_key}_%Y-%m-%d_%H-%i-%s";s:14:"archive_format";s:3:"zip";s:8:"schedule";s:8:"manually";s:12:"scheduletype";s:5:"basic";s:13:"schedulemonth";a:13:{i:0;s:3:"any";i:1;s:1:"1";i:2;s:1:"2";i:3;s:1:"3";i:4;s:1:"4";i:5;s:1:"5";i:6;s:1:"6";i:7;s:1:"7";i:8;s:1:"8";i:9;s:1:"9";i:10;s:2:"10";i:11;s:2:"11";i:12;s:2:"12";}s:12:"scheduleweek";a:1:{i:0;s:1:"1";}s:12:"dbtables_all";a:0:{}s:8:"dbtables";a:17:{s:14:"wp_commentmeta";s:14:"wp_commentmeta";s:11:"wp_comments";s:11:"wp_comments";s:8:"wp_links";s:8:"wp_links";s:10:"wp_options";s:10:"wp_options";s:11:"wp_postmeta";s:11:"wp_postmeta";s:8:"wp_posts";s:8:"wp_posts";s:21:"wp_term_relationships";s:21:"wp_term_relationships";s:16:"wp_term_taxonomy";s:16:"wp_term_taxonomy";s:11:"wp_termmeta";s:11:"wp_termmeta";s:8:"wp_terms";s:8:"wp_terms";s:11:"wp_usermeta";s:11:"wp_usermeta";s:8:"wp_users";s:8:"wp_users";s:13:"wp_wd_fb_data";s:13:"wp_wd_fb_data";s:13:"wp_wd_fb_info";s:13:"wp_wd_fb_info";s:15:"wp_wd_fb_option";s:15:"wp_wd_fb_option";s:18:"wp_wd_fb_shortcode";s:18:"wp_wd_fb_shortcode";s:14:"wp_wd_fb_theme";s:14:"wp_wd_fb_theme";}s:10:"dbfilename";s:16:"25703466_0000001";s:17:"use_wp_connection";s:1:"1";s:10:"dbfilecomp";s:4:"none";s:7:"db_host";s:0:"";s:7:"db_user";s:0:"";s:11:"db_password";s:0:"";s:7:"db_name";s:0:"";s:8:"bup_root";a:1:{i:0;s:1:"1";}s:11:"bup_content";a:1:{i:0;s:1:"1";}s:19:"bup_content_exclude";s:0:"";s:11:"bup_plugins";a:1:{i:0;s:1:"1";}s:19:"bup_plugins_exclude";a:1:{i:0;s:9:"backup-wd";}s:10:"bup_themes";s:1:"1";s:11:"bup_uploads";s:1:"1";s:17:"bup_extra_folders";s:0:"";s:19:"bup_uploads_exclude";a:3:{i:0;s:21:"backup-wd-logs-4a37ce";i:1;s:21:"backup-wd-temp-4a37ce";i:2;s:16:"backup-wd-4a37ce";}s:20:"bup_include_specials";s:1:"1";s:13:"exclude_types";s:51:".tmp,.svn,.git,desktop.ini,.DS_Store,/node_modules/";s:16:"use_folder_as_wp";s:1:"0";s:10:"folderpath";s:46:"wp-content/uploads/backup-wd-files-{hash_key}/";s:12:"folderdelete";i:15;s:16:"folderdeletesync";s:1:"1";s:12:"gdrivefolder";s:14:"METEOprognoza/";s:16:"gdrivefiledelete";i:15;s:20:"gdrivefiledeletesync";s:1:"1";s:9:"s3service";s:9:"us-east-1";s:11:"s3accesskey";s:0:"";s:12:"s3privatekey";s:0:"";s:8:"s3bucket";s:0:"";s:11:"s3newbucket";s:0:"";s:14:"s3bucketfolder";s:14:"METEOprognoza/";s:12:"s3filedelete";i:15;s:16:"s3filedeletesync";s:1:"1";s:13:"s3multiupload";s:1:"1";s:14:"s3storageclass";s:8:"standard";s:18:"s3serverencryption";s:1:"1";s:9:"dboxtoken";s:0:"";s:8:"dboxtype";s:7:"sandbox";s:10:"dboxfolder";s:14:"METEOprognoza/";s:14:"dboxfiledelete";i:15;s:18:"dboxfiledeletesync";s:1:"1";s:9:"azurename";s:0:"";s:8:"azurekey";s:0:"";s:12:"azurenewcont";s:0:"";s:11:"azurefolder";s:14:"METEOprognoza/";s:15:"azurefiledelete";i:15;s:19:"azurefiledeletesync";s:1:"1";s:7:"rscuser";s:0:"";s:6:"rsckey";s:0:"";s:9:"rscregion";s:3:"DFW";s:12:"rsccontainer";s:0:"";s:10:"rscnewcont";s:0:"";s:9:"rscfolder";s:14:"METEOprognoza/";s:13:"rscfiledelete";i:15;s:17:"rscfiledeletesync";s:1:"1";s:9:"ftpserver";s:0:"";s:7:"ftpport";i:21;s:7:"ftpuser";s:0:"";s:7:"ftppass";s:0:"";s:9:"ftpfolder";s:14:"METEOprognoza/";s:13:"ftpfiledelete";i:15;s:10:"ftptimeout";i:90;s:6:"ftpssl";s:0:"";s:8:"ftppmode";s:1:"1";s:10:"sugartoken";s:0:"";s:9:"sugaruser";s:0:"";s:15:"sugarsyncfolder";s:0:"";s:11:"sugarfolder";s:14:"METEOprognoza/";s:15:"sugarfiledelete";i:15;s:14:"glacier_region";s:9:"us-east-1";s:17:"glacier_accesskey";s:0:"";s:18:"glacier_privatekey";s:0:"";s:16:"glacier_newvault";s:0:"";s:18:"glacier_filedelete";i:15;s:10:"send_email";s:0:"";s:6:"job_id";i:6;s:15:"cron_expression";s:9:"0 0 * * *";s:12:"schedulelink";s:123:"http://serwer1761710.home.pl/autoinstalator/wordpress/wp-cron.php?jobid=2&amp;buwd_cron=1&amp;type=run&amp;_wpnonce=167ea42";s:3:"day";s:0:"";s:11:"scheduleday";s:0:"";s:12:"schedulehour";s:2:"00";s:14:"scheduleminute";s:2:"00";s:7:"lastrun";i:1509004264;s:13:"last_log_file";s:44:"backupwd_log_4a37ce_2017-10-26_09-51-04.html";}i:3;a:96:{s:4:"name";s:25:"Plugins and Themes Backup";s:4:"type";a:1:{i:0;s:5:"files";}s:11:"destination";a:1:{i:0;s:6:"folder";}s:11:"backup_type";s:4:"sync";s:12:"archive_name";s:37:"backupwd_{hash_key}_%Y-%m-%d_%H-%i-%s";s:14:"archive_format";s:3:"zip";s:8:"schedule";s:8:"manually";s:12:"scheduletype";s:5:"basic";s:13:"schedulemonth";a:13:{i:0;s:3:"any";i:1;s:1:"1";i:2;s:1:"2";i:3;s:1:"3";i:4;s:1:"4";i:5;s:1:"5";i:6;s:1:"6";i:7;s:1:"7";i:8;s:1:"8";i:9;s:1:"9";i:10;s:2:"10";i:11;s:2:"11";i:12;s:2:"12";}s:12:"scheduleweek";a:1:{i:0;s:1:"1";}s:12:"dbtables_all";a:0:{}s:8:"dbtables";a:17:{s:14:"wp_commentmeta";s:14:"wp_commentmeta";s:11:"wp_comments";s:11:"wp_comments";s:8:"wp_links";s:8:"wp_links";s:10:"wp_options";s:10:"wp_options";s:11:"wp_postmeta";s:11:"wp_postmeta";s:8:"wp_posts";s:8:"wp_posts";s:21:"wp_term_relationships";s:21:"wp_term_relationships";s:16:"wp_term_taxonomy";s:16:"wp_term_taxonomy";s:11:"wp_termmeta";s:11:"wp_termmeta";s:8:"wp_terms";s:8:"wp_terms";s:11:"wp_usermeta";s:11:"wp_usermeta";s:8:"wp_users";s:8:"wp_users";s:13:"wp_wd_fb_data";s:13:"wp_wd_fb_data";s:13:"wp_wd_fb_info";s:13:"wp_wd_fb_info";s:15:"wp_wd_fb_option";s:15:"wp_wd_fb_option";s:18:"wp_wd_fb_shortcode";s:18:"wp_wd_fb_shortcode";s:14:"wp_wd_fb_theme";s:14:"wp_wd_fb_theme";}s:10:"dbfilename";s:16:"25703466_0000001";s:17:"use_wp_connection";s:1:"1";s:10:"dbfilecomp";s:4:"none";s:7:"db_host";s:0:"";s:7:"db_user";s:0:"";s:11:"db_password";s:0:"";s:7:"db_name";s:0:"";s:8:"bup_root";s:0:"";s:11:"bup_content";s:0:"";s:19:"bup_content_exclude";s:0:"";s:11:"bup_plugins";a:1:{i:0;s:1:"1";}s:19:"bup_plugins_exclude";a:1:{i:0;s:9:"backup-wd";}s:10:"bup_themes";s:1:"1";s:11:"bup_uploads";s:0:"";s:17:"bup_extra_folders";s:0:"";s:19:"bup_uploads_exclude";a:3:{i:0;s:21:"backup-wd-logs-4a37ce";i:1;s:21:"backup-wd-temp-4a37ce";i:2;s:16:"backup-wd-4a37ce";}s:20:"bup_include_specials";s:1:"1";s:13:"exclude_types";s:51:".tmp,.svn,.git,desktop.ini,.DS_Store,/node_modules/";s:16:"use_folder_as_wp";s:1:"0";s:10:"folderpath";s:55:"wp-content/uploads/backup-wd-plugins-themes-{hash_key}/";s:12:"folderdelete";i:15;s:16:"folderdeletesync";s:1:"1";s:12:"gdrivefolder";s:14:"METEOprognoza/";s:16:"gdrivefiledelete";i:15;s:20:"gdrivefiledeletesync";s:1:"1";s:9:"s3service";s:9:"us-east-1";s:11:"s3accesskey";s:0:"";s:12:"s3privatekey";s:0:"";s:8:"s3bucket";s:0:"";s:11:"s3newbucket";s:0:"";s:14:"s3bucketfolder";s:14:"METEOprognoza/";s:12:"s3filedelete";i:15;s:16:"s3filedeletesync";s:1:"1";s:13:"s3multiupload";s:1:"1";s:14:"s3storageclass";s:8:"standard";s:18:"s3serverencryption";s:1:"1";s:9:"dboxtoken";s:0:"";s:8:"dboxtype";s:7:"sandbox";s:10:"dboxfolder";s:14:"METEOprognoza/";s:14:"dboxfiledelete";i:15;s:18:"dboxfiledeletesync";s:1:"1";s:9:"azurename";s:0:"";s:8:"azurekey";s:0:"";s:12:"azurenewcont";s:0:"";s:11:"azurefolder";s:14:"METEOprognoza/";s:15:"azurefiledelete";i:15;s:19:"azurefiledeletesync";s:1:"1";s:7:"rscuser";s:0:"";s:6:"rsckey";s:0:"";s:9:"rscregion";s:3:"DFW";s:12:"rsccontainer";s:0:"";s:10:"rscnewcont";s:0:"";s:9:"rscfolder";s:14:"METEOprognoza/";s:13:"rscfiledelete";i:15;s:17:"rscfiledeletesync";s:1:"1";s:9:"ftpserver";s:0:"";s:7:"ftpport";i:21;s:7:"ftpuser";s:0:"";s:7:"ftppass";s:0:"";s:9:"ftpfolder";s:14:"METEOprognoza/";s:13:"ftpfiledelete";i:15;s:10:"ftptimeout";i:90;s:6:"ftpssl";s:0:"";s:8:"ftppmode";s:1:"1";s:10:"sugartoken";s:0:"";s:9:"sugaruser";s:0:"";s:15:"sugarsyncfolder";s:0:"";s:11:"sugarfolder";s:14:"METEOprognoza/";s:15:"sugarfiledelete";i:15;s:14:"glacier_region";s:9:"us-east-1";s:17:"glacier_accesskey";s:0:"";s:18:"glacier_privatekey";s:0:"";s:16:"glacier_newvault";s:0:"";s:18:"glacier_filedelete";i:15;s:10:"send_email";s:0:"";s:6:"job_id";i:6;s:15:"cron_expression";s:9:"0 0 * * *";s:12:"schedulelink";s:123:"http://serwer1761710.home.pl/autoinstalator/wordpress/wp-cron.php?jobid=3&amp;buwd_cron=1&amp;type=run&amp;_wpnonce=167ea42";s:3:"day";s:0:"";s:11:"scheduleday";s:0:"";s:12:"schedulehour";s:2:"00";s:14:"scheduleminute";s:2:"00";s:7:"lastrun";i:1509004355;s:13:"last_log_file";s:44:"backupwd_log_4a37ce_2017-10-26_09-52-36.html";}i:4;a:96:{s:4:"name";s:25:"Files and Database Backup";s:4:"type";a:2:{i:0;s:2:"db";i:1;s:5:"files";}s:11:"destination";a:1:{i:0;s:6:"folder";}s:11:"backup_type";s:4:"sync";s:12:"archive_name";s:37:"backupwd_{hash_key}_%Y-%m-%d_%H-%i-%s";s:14:"archive_format";s:3:"zip";s:8:"schedule";s:8:"manually";s:12:"scheduletype";s:5:"basic";s:13:"schedulemonth";a:13:{i:0;s:3:"any";i:1;s:1:"1";i:2;s:1:"2";i:3;s:1:"3";i:4;s:1:"4";i:5;s:1:"5";i:6;s:1:"6";i:7;s:1:"7";i:8;s:1:"8";i:9;s:1:"9";i:10;s:2:"10";i:11;s:2:"11";i:12;s:2:"12";}s:12:"scheduleweek";a:1:{i:0;s:1:"1";}s:12:"dbtables_all";a:0:{}s:8:"dbtables";a:17:{s:14:"wp_commentmeta";s:14:"wp_commentmeta";s:11:"wp_comments";s:11:"wp_comments";s:8:"wp_links";s:8:"wp_links";s:10:"wp_options";s:10:"wp_options";s:11:"wp_postmeta";s:11:"wp_postmeta";s:8:"wp_posts";s:8:"wp_posts";s:21:"wp_term_relationships";s:21:"wp_term_relationships";s:16:"wp_term_taxonomy";s:16:"wp_term_taxonomy";s:11:"wp_termmeta";s:11:"wp_termmeta";s:8:"wp_terms";s:8:"wp_terms";s:11:"wp_usermeta";s:11:"wp_usermeta";s:8:"wp_users";s:8:"wp_users";s:13:"wp_wd_fb_data";s:13:"wp_wd_fb_data";s:13:"wp_wd_fb_info";s:13:"wp_wd_fb_info";s:15:"wp_wd_fb_option";s:15:"wp_wd_fb_option";s:18:"wp_wd_fb_shortcode";s:18:"wp_wd_fb_shortcode";s:14:"wp_wd_fb_theme";s:14:"wp_wd_fb_theme";}s:10:"dbfilename";s:16:"25703466_0000001";s:17:"use_wp_connection";s:1:"1";s:10:"dbfilecomp";s:4:"none";s:7:"db_host";s:0:"";s:7:"db_user";s:0:"";s:11:"db_password";s:0:"";s:7:"db_name";s:0:"";s:8:"bup_root";s:0:"";s:11:"bup_content";s:1:"1";s:19:"bup_content_exclude";s:0:"";s:11:"bup_plugins";a:1:{i:0;s:1:"1";}s:19:"bup_plugins_exclude";a:1:{i:0;s:9:"backup-wd";}s:10:"bup_themes";s:1:"1";s:11:"bup_uploads";s:0:"";s:17:"bup_extra_folders";s:0:"";s:19:"bup_uploads_exclude";a:3:{i:0;s:21:"backup-wd-logs-4a37ce";i:1;s:21:"backup-wd-temp-4a37ce";i:2;s:16:"backup-wd-4a37ce";}s:20:"bup_include_specials";s:1:"1";s:13:"exclude_types";s:51:".tmp,.svn,.git,desktop.ini,.DS_Store,/node_modules/";s:16:"use_folder_as_wp";s:1:"0";s:10:"folderpath";s:49:"wp-content/uploads/backup-wd-files-db-{hash_key}/";s:12:"folderdelete";i:15;s:16:"folderdeletesync";s:1:"1";s:12:"gdrivefolder";s:14:"METEOprognoza/";s:16:"gdrivefiledelete";i:15;s:20:"gdrivefiledeletesync";s:1:"1";s:9:"s3service";s:9:"us-east-1";s:11:"s3accesskey";s:0:"";s:12:"s3privatekey";s:0:"";s:8:"s3bucket";s:0:"";s:11:"s3newbucket";s:0:"";s:14:"s3bucketfolder";s:14:"METEOprognoza/";s:12:"s3filedelete";i:15;s:16:"s3filedeletesync";s:1:"1";s:13:"s3multiupload";s:1:"1";s:14:"s3storageclass";s:8:"standard";s:18:"s3serverencryption";s:1:"1";s:9:"dboxtoken";s:0:"";s:8:"dboxtype";s:7:"sandbox";s:10:"dboxfolder";s:14:"METEOprognoza/";s:14:"dboxfiledelete";i:15;s:18:"dboxfiledeletesync";s:1:"1";s:9:"azurename";s:0:"";s:8:"azurekey";s:0:"";s:12:"azurenewcont";s:0:"";s:11:"azurefolder";s:14:"METEOprognoza/";s:15:"azurefiledelete";i:15;s:19:"azurefiledeletesync";s:1:"1";s:7:"rscuser";s:0:"";s:6:"rsckey";s:0:"";s:9:"rscregion";s:3:"DFW";s:12:"rsccontainer";s:0:"";s:10:"rscnewcont";s:0:"";s:9:"rscfolder";s:14:"METEOprognoza/";s:13:"rscfiledelete";i:15;s:17:"rscfiledeletesync";s:1:"1";s:9:"ftpserver";s:0:"";s:7:"ftpport";i:21;s:7:"ftpuser";s:0:"";s:7:"ftppass";s:0:"";s:9:"ftpfolder";s:14:"METEOprognoza/";s:13:"ftpfiledelete";i:15;s:10:"ftptimeout";i:90;s:6:"ftpssl";s:0:"";s:8:"ftppmode";s:1:"1";s:10:"sugartoken";s:0:"";s:9:"sugaruser";s:0:"";s:15:"sugarsyncfolder";s:0:"";s:11:"sugarfolder";s:14:"METEOprognoza/";s:15:"sugarfiledelete";i:15;s:14:"glacier_region";s:9:"us-east-1";s:17:"glacier_accesskey";s:0:"";s:18:"glacier_privatekey";s:0:"";s:16:"glacier_newvault";s:0:"";s:18:"glacier_filedelete";i:15;s:10:"send_email";s:0:"";s:6:"job_id";i:6;s:15:"cron_expression";s:9:"0 0 * * *";s:12:"schedulelink";s:123:"http://serwer1761710.home.pl/autoinstalator/wordpress/wp-cron.php?jobid=4&amp;buwd_cron=1&amp;type=run&amp;_wpnonce=167ea42";s:3:"day";s:0:"";s:11:"scheduleday";s:0:"";s:12:"schedulehour";s:2:"00";s:14:"scheduleminute";s:2:"00";s:7:"lastrun";i:1509004342;s:13:"last_log_file";s:44:"backupwd_log_4a37ce_2017-10-26_09-52-22.html";}}', 'no'),
 (277, 'buwd_job_maxid', '4', 'no'),
 (278, 'buwd_admin_notice', 'a:1:{s:15:"two_week_review";a:2:{s:5:"start";s:9:"11/7/2017";s:3:"int";i:14;}}', 'yes'),
 (297, '_site_transient_timeout_community-events-6040224880965902a601ec260adb9284', '1508973930', 'no'),
 (298, '_site_transient_community-events-6040224880965902a601ec260adb9284', 'a:2:{s:8:"location";a:1:{s:2:"ip";s:12:"95.108.116.0";}s:6:"events";a:0:{}}', 'no'),
 (299, '_transient_timeout_feed_a421d6f32723068ab074a40017a9e1f9', '1508973932', 'no'),
 (300, '_transient_feed_a421d6f32723068ab074a40017a9e1f9', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:49:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:3:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:6:"Polska";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:24:"https://pl.wordpress.org";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:13:"lastBuildDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 12 Oct 2017 07:03:53 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"pl-PL";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:40:"https://wordpress.org/?v=4.9-beta3-41966";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:10:{i:0;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:20:"WordPress 4.9 Beta 2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:57:"https://pl.wordpress.org/2017/10/12/wordpress-4-9-beta-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:66:"https://pl.wordpress.org/2017/10/12/wordpress-4-9-beta-2/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 12 Oct 2017 07:03:53 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:14:"Wersje testowe";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://pl.wordpress.org/?p=1235";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:433:"WordPress 4.9 Beta 2 jest już dostępny! Oprogramowanie jest wciąż w fazie tworzenia, dlatego nie zalecamy jego używania w witrynie produkcyjnej. Zastanów się nad środowiskiem testowym i tam sprawdzaj do woli. Aby przetestować WordPress 4.9, wypróbuj wtyczkę WordPress Beta Tester (regularnie aktualizuje one do  &#8222;krawych nocnych wydań&#8221;) albo pobierz wersję beta (zip). Więcej informacji na temat [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"Marcin Pietrzak";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:1781:"<p>WordPress 4.9 Beta 2 jest już dostępny!</p>\n<p><strong>Oprogramowanie jest wciąż w fazie tworzenia</strong>, dlatego nie zalecamy jego używania w witrynie produkcyjnej. Zastanów się nad środowiskiem testowym i tam sprawdzaj do woli. Aby przetestować WordPress 4.9, wypróbuj wtyczkę <a href="https://pl.wordpress.org/plugins/wordpress-beta-tester/">WordPress Beta Tester</a> (regularnie aktualizuje one do  &#8222;krawych nocnych wydań&#8221;) albo <a href="https://wordpress.org/wordpress-4.9-beta2.zip">pobierz wersję beta</a> (zip).</p>\n<p>Więcej informacji na temat tego, co nowego w wersji 4.9, znajdziesz w blogu we wpisie <a href="https://wordpress.org/news/2017/10/wordpress-4-9-beta-1/">Beta 1</a> (po angielsku). Od tego czasu dokonaliśmy <a href="https://core.trac.wordpress.org/log/trunk/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=41846&amp;stop_rev=41777&amp;limit=100&amp;sfp_email=&amp;sfph_mail=">70 zmian</a> w wersji Beta 2.</p>\n<p><a href="https://translate.wordpress.org/locale/pl/default/wp/dev">Pomóż nam przetłumaczyć WordPress na język polski</a>!</p>\n<p><strong>Jeśli widzisz błąd</strong>, napisz wiadomość na forum <a href="https://wordpress.org/support/forum/alphabeta">Alpha/Beta</a>. Jeżeli coś nie działa, to chcielibyśm się tego dowiedzieć właśnie do ciebie! Jeśli czujesz się na siłach, żeby napisać raport zawierający opis jak powtórzyć błąd to  skorzystaj z serwisu <a href="https://make.wordpress.org/core/reports/">WordPress Trac</a>. Na nim też znajdziesz <a href="https://core.trac.wordpress.org/tickets/major">listę znanych błędów</a>.</p>\n<p><em>Przetestujmy razem:</em><br />\n<em> edytowanie kodu, przełączniki tematyczne,</em><br />\n<em> widgety, harmonogramowanie.</em></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:62:"https://pl.wordpress.org/2017/10/12/wordpress-4-9-beta-2/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:45:"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:67:"WordPress 4.8.2 – Wydanie poprawiające bezpieczeństwo i błędy";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:96:"https://pl.wordpress.org/2017/09/22/wordpress-4-8-2-wydanie-poprawiajace-bezpieczenstwo-i-bledy/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:104:"https://pl.wordpress.org/2017/09/22/wordpress-4-8-2-wydanie-poprawiajace-bezpieczenstwo-i-bledy/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 22 Sep 2017 11:37:20 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:15:"Bezpieczeństwo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"Wydanie";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://pl.wordpress.org/?p=1213";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:476:"WordPress 4.8.2 jest już dostępny. Wersja poprawia bezpieczeństwo wszystkich poprzednich wersji i zdecydowanie zachęcamy do natychmiastowej aktualizacji witryn. WordPress w wersji 4.8.1 i starsze mają następujące problemy z bezpieczeństwem: $wpdb-&#62; prepare() mogło tworzyć nieoczekiwane i niebezpieczne zapytania prowadzące do potencjalnego wstrzyknięcia kod SQL (SQLi). Core WordPressa nie jest bezpośrednio narażony na ten problem, ale poprawiono [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"Marcin Pietrzak";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:3051:"<p>WordPress 4.8.2 jest już dostępny. Wersja <strong>poprawia bezpieczeństwo</strong> wszystkich poprzednich wersji i zdecydowanie zachęcamy do natychmiastowej aktualizacji witryn.</p>\n<p>WordPress w wersji 4.8.1 i starsze mają następujące problemy z bezpieczeństwem:</p>\n<ol>\n<li><strong>$wpdb-&gt; prepare()</strong> mogło tworzyć nieoczekiwane i niebezpieczne zapytania prowadzące do potencjalnego wstrzyknięcia kod SQL (SQLi). Core WordPressa nie jest bezpośrednio narażony na ten problem, ale poprawiono proces tworzenia zapytań aby zapobiegać podatności we wtyczkach i motywach. Zgłoszone przez <a href="https://hackerone.com/slavco">Slavco</a></li>\n<li>Wykryto podatność na cross-site scripting (XSS) w używaniu oEmbed. Zgłoszone przez xknown zespołu ds. Zabezpieczeń WordPress.</li>\n<li>W edytorze wizualnym wykryto lukę w zabezpieczeniach skryptów przed cross-site scripting (XSS) Zgłoszone przez <a href="https://twitter.com/brutelogic">Rodolfo Assis (@brutelogic)</a> Sucuri Security.</li>\n<li>W kodzie do rozpakowywania wykryto lukę w zabezpieczeniach ścieżki do pliku. Zgłoszone przez <a href="https://hackerone.com/noxrnet">Alex Chapman (noxrnet)</a>.</li>\n<li>W edytorze wtyczek wykryto luka w zabezpieczeniach cross-site scripting (XSS). Zgłoszone przez 陈瑞琦 (Chen Ruiqi).</li>\n<li>Na ekranie użytkownika i terminach edycji zostały wykryte otwarte przekierowanie. Zgłoszone przez <a href="https://hackerone.com/ysx">Yasin Soliman (ysx)</a>.</li>\n<li>Odkryto lukę w zabezpieczeniach ścieżki na ekranie personalizacji witryny. Zgłoszone przez Weston Ruter z zespołu ds. Bezpieczeństwa WordPress.</li>\n<li>Wykryto podatność na cross-site scripting (XSS)  w nazwach szablonów. Zgłoszone przez <a href="https://hackerone.com/sikic">Luka (sikic)</a>.</li>\n<li>Wykryto podatność na cross-site scripting (XSS) w linkach modalnych. Zgłoszone przez <a href="https://hackerone.com/qasuar">Anas Roubi (qasuar)</a>.</li>\n</ol>\n<p>Dziękujemy zgłaszającym za praktykowanie <a href="https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/">odpowiedzialnego ujawnienia (en)</a>.</p>\n<p>Oprócz powyższych kwestii związanych z bezpieczeństwem, WordPress 4.8.2 zawiera 6 poprawek utrzymaniowych serii 4.8. Więcej informacji można znaleźć w <a href="https://codex.wordpress.org/Version_4.8.2">notce wydania wersji (en)</a> oraz na <a href="https://core.trac.wordpress.org/query?status=closed&amp;milestone=4.8.2&amp;group=component&amp;col=id&amp;col=summary&amp;col=component&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=keywords&amp;order=priority">liście zmian</a>.</p>\n<p><a href="https://pl.wordpress.org/wordpress-4.8.2-pl_PL.zip">Pobierz WordPress 4.8.2</a> lub przejdź do Panel → Aktualizacje i kliknij przycisk &#8222;Aktualizuj teraz&#8221;. Strony obsługujące automatyczne aktualizacje w tle już zaczynają aktualizować się do wersji 4.8.2.</p>\n<p>Dziękujemy wszystkim, którzy przyczynili się do wydania 4.8.2.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:101:"https://pl.wordpress.org/2017/09/22/wordpress-4-8-2-wydanie-poprawiajace-bezpieczenstwo-i-bledy/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:51:"Zrób jedną rzecz i zmień przyszłość WordCampa";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:60:"https://pl.wordpress.org/2017/06/15/zrob-cos-dla-wordpressa/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:68:"https://pl.wordpress.org/2017/06/15/zrob-cos-dla-wordpressa/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 15 Jun 2017 04:11:28 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:10:"Wydarzenia";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:31:"https://pl.wordpress.org/?p=977";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:435:"Ósmy polski WordCamp już za nami. Polska społeczność rozrasta się z roku na rok, co bardzo cieszy, ale niejednokrotnie stanowi wyzwanie dla organizatorów spotkań. Chcemy lepiej odpowiadać na potrzeby polskich twórców i użytkowników WordPressa. Dlatego przygotowaliśmy krótką ankietę na temat WordCampa. Chcemy poznać Was lepiej, dowiedzieć się, kim jesteście i jakie macie oczekiwania względem kolejnych [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:18:"Katarzyna Gajewska";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:815:"<p>Ósmy polski WordCamp już za nami. Polska społeczność rozrasta się z roku na rok, co bardzo cieszy, ale niejednokrotnie stanowi wyzwanie dla organizatorów spotkań.</p>\n<p>Chcemy lepiej odpowiadać na potrzeby polskich twórców i użytkowników WordPressa. Dlatego przygotowaliśmy krótką ankietę na temat WordCampa. Chcemy poznać Was lepiej, dowiedzieć się, kim jesteście i jakie macie oczekiwania względem kolejnych edycji WordCampa w Polsce. Wypełnienie ankiety nie zajmie Wam więcej niż 5 minut.</p>\n<p><a href="https://goo.gl/forms/VPY4xtO9KF6fuDnm1" target="_blank" rel="noopener"><strong>Wypełnij ankietę na temat polskiej społeczności WordPressowej</strong></a>.</p>\n<p>Dziękujemy Wam za wypełnienie ankiety!</p>\n<p><em>Organizatorzy polskich WordUpów i WordCamp Polska</em></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:65:"https://pl.wordpress.org/2017/06/15/zrob-cos-dla-wordpressa/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:67:"WordPress 4.7.5 – Wydanie poprawiające bezpieczeństwo i błędy";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:96:"https://pl.wordpress.org/2017/05/17/wordpress-4-7-5-wydanie-poprawiajace-bezpieczenstwo-i-bledy/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:105:"https://pl.wordpress.org/2017/05/17/wordpress-4-7-5-wydanie-poprawiajace-bezpieczenstwo-i-bledy/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 17 May 2017 00:14:32 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:7:"Wydanie";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:31:"https://pl.wordpress.org/?p=907";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:490:"WordPress 4.7.5 jest już dostępny. To wydanie poprawia bezpieczeństwo we wszystkich poprzednich wersjach systemu. Zalecane jest natychmiastowe przeprowadzenie aktualizacji. WordPress w wersji 4.7.4 i wcześniejszych posiada sześć problemów z bezpieczeństwem: Niewystarczająca weryfikacja przekierowań w klasie HTTP. Zgłosił to Ronni Skansing. Niewłaściwa obsługa wartości danych meta wpisów w API XML-RPC. Zgłosił to Sam Thomas. Brak sprawdzania uprawnień dla [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:37:"Krzysztof Trynkiewicz (Sukces Strony)";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:2591:"<p>WordPress 4.7.5 jest już dostępny. <strong>To wydanie poprawia bezpieczeństwo</strong> we wszystkich poprzednich wersjach systemu. Zalecane jest natychmiastowe przeprowadzenie aktualizacji.</p>\n<p><span id="more-907"></span></p>\n<p>WordPress w wersji 4.7.4 i wcześniejszych posiada sześć problemów z bezpieczeństwem:</p>\n<ol>\n<li>Niewystarczająca weryfikacja przekierowań w klasie HTTP. Zgłosił to <a href="https://dk.linkedin.com/in/ronni-skansing-36143b65">Ronni Skansing</a>.</li>\n<li>Niewłaściwa obsługa wartości danych meta wpisów w API XML-RPC. Zgłosił to <a href="https://hackerone.com/jazzy2fives">Sam Thomas</a>.</li>\n<li>Brak sprawdzania uprawnień dla danych meta wpisów w API XML-RPC. Zgłosił to <a href="https://profiles.wordpress.org/vortfu">Ben Bidner</a> z Zespołu Bezpieczeństwa WordPressa.</li>\n<li>Podatność typu Cross Site Request Forgery (CRSF) została wykryta w formularzu zapytania o dane dostępu do systemu plików. Zgłosił to <a href="https://twitter.com/yorickkoster">Yorick Koster</a>.</li>\n<li>Wykryto podatność typu cross-site scripting (XSS). Objawia się podczas próby wgrania bardzo dużych plików. Zgłosił to <a href="https://dk.linkedin.com/in/ronni-skansing-36143b65">Ronni Skansing</a>.</li>\n<li>Wykryto podatność typu cross-site scripting (XSS). Ma ona związek z mechanizmem Personalizacji witryn. Zgłosił to <a href="https://profiles.wordpress.org/westonruter">Weston Ruter</a> z Zespołu Bezpieczeństwa WordPressa.</li>\n</ol>\n<p>Dziękujemy zgłaszającym za <a href="https://make.wordpress.org/core/handbook/reporting-security-vulnerabilities/">odpowiedzialne ujawnienie</a> problemów z bezpieczeństwem.</p>\n<p>Oprócz powyższych problemów z bezpieczeństwem, WordPress 4.7.5 naprawia także 3 błędy z wersji 4.7. Więcej informacji można znaleźć w <a href="https://codex.wordpress.org/Version_4.7.5">notatkach do wydania</a> oraz <a href="https://core.trac.wordpress.org/query?status=closed&amp;milestone=4.7.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=component&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=keywords&amp;order=priority">liście przeprowadzonych zmian</a>.</p>\n<p><a href="https://pl.wordpress.org/">Pobierz WordPressa 4.7.5</a> lub udaj się do sekcji Kokpit → Aktualizacje panelu administracyjnego i po prostu kliknij przycisk „Zaktualizuj teraz”. Witryny, które obsługują automatyczne aktualizacje, rozpoczęły już ich przeprowadzanie.</p>\n<p>Dziękujemy wszystkim, którzy przyczynili się do powstania wersji 4.7.5.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:101:"https://pl.wordpress.org/2017/05/17/wordpress-4-7-5-wydanie-poprawiajace-bezpieczenstwo-i-bledy/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"6";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:67:"WordPress 4.7.4 – Wydanie poprawiające bezpieczeństwo i błędy";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:96:"https://pl.wordpress.org/2017/04/20/wordpress-4-7-4-wydanie-poprawiajace-bezpieczenstwo-i-bledy/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:104:"https://pl.wordpress.org/2017/04/20/wordpress-4-7-4-wydanie-poprawiajace-bezpieczenstwo-i-bledy/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 20 Apr 2017 18:42:55 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:7:"Wydanie";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:31:"https://pl.wordpress.org/?p=858";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:490:"Po niemal 60 milionach pobrań WordPressa 4.7 z radością ogłaszamy dostępność wersji 4.7.4 &#8211; wydania poprawiającego błędy i bezpieczeństwo. Wydanie to zawiera 47 poprawek błędów oraz usprawnień. W szczególności naprawiony został brak kompatybilności między nadchodzącą wersją przeglądarki Chrome i edytorem wizualnym, jak również poprawiono braki w spójności obsługi mediów, a także wprowadzono dalsze ulepszenia API REST. Więcej informacji [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:37:"Krzysztof Trynkiewicz (Sukces Strony)";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4736:"<p>Po niemal 60 milionach pobrań WordPressa 4.7 z radością ogłaszamy dostępność wersji 4.7.4 &#8211; <strong>wydania poprawiającego błędy i bezpieczeństwo.</strong></p>\n<p><span id="more-858"></span></p>\n<p>Wydanie to zawiera 47 poprawek błędów oraz usprawnień. W szczególności naprawiony został brak kompatybilności między nadchodzącą wersją przeglądarki Chrome i edytorem wizualnym, jak również poprawiono braki w spójności obsługi mediów, a także wprowadzono dalsze ulepszenia API REST. Więcej informacji można znaleźć w <a href="https://codex.wordpress.org/Version_4.7.4">notatkach do wydania</a> oraz <a href="https://core.trac.wordpress.org/log/branches/4.7?rev=40487&amp;stop_rev=40224">liście przeprowadzonych zmian</a>.</p>\n<p><a href="https://pl.wordpress.org/">Pobierz WordPressa 4.7.4</a> lub udaj się do sekcji <strong>Kokpit → Aktualizacje</strong> panelu administracyjnego i po prostu kliknij przycisk „Zaktualizuj teraz”. Witryny, które obsługują automatyczne aktualizacje, rozpoczęły już ich przeprowadzanie.</p>\n<p>Dziękujemy wszystkim, którzy przyczynili się do powstania wersji 4.7.4:<br />\n<a href="https://profiles.wordpress.org/jorbin/">Aaron Jorbin</a>, <a href="https://profiles.wordpress.org/adamsilverstein/">Adam Silverstein</a>, <a href="https://profiles.wordpress.org/afercia/">Andrea Fercia</a>, <a href="https://profiles.wordpress.org/azaozz/">Andrew Ozz</a>, <a href="https://profiles.wordpress.org/aussieguy123/">aussieguy123</a>, <a href="https://profiles.wordpress.org/blobfolio/">Blobfolio</a>, <a href="https://profiles.wordpress.org/boldwater/">boldwater</a>, <a href="https://profiles.wordpress.org/boonebgorges/">Boone Gorges</a>, <a href="https://profiles.wordpress.org/bor0/">Boro Sitnikovski</a>, <a href="https://profiles.wordpress.org/chesio/">chesio</a>, <a href="https://profiles.wordpress.org/curdin/">Curdin Krummenacher</a>, <a href="https://profiles.wordpress.org/danielbachhuber/">Daniel Bachhuber</a>, <a href="https://profiles.wordpress.org/nerrad/">Darren Ethier (nerrad)</a>, <a href="https://profiles.wordpress.org/davidakennedy/">David A. Kennedy</a>, <a href="https://profiles.wordpress.org/davidbenton/">davidbenton</a>, <a href="https://profiles.wordpress.org/dlh/">David Herrera</a>, <a href="https://profiles.wordpress.org/dd32/">Dion Hulse</a>, <a href="https://profiles.wordpress.org/ocean90/">Dominik Schilling (ocean90)</a>, <a href="https://profiles.wordpress.org/eclev91/">eclev91</a>, <a href="https://profiles.wordpress.org/iseulde/">Ella Van Dorpe</a>, <a href="https://profiles.wordpress.org/ghosttoast/">Gustave F. Gerhardt</a>, <a href="https://profiles.wordpress.org/ig_communitysites/">ig_communitysites</a>, <a href="https://profiles.wordpress.org/jnylen0/">James Nylen</a>, <a href="https://profiles.wordpress.org/joedolson/">Joe Dolson</a>, <a href="https://profiles.wordpress.org/johnbillion/">John Blackbourn</a>, <a href="https://profiles.wordpress.org/karinedo/">karinedo</a>, <a href="https://profiles.wordpress.org/lukasbesch/">lukasbesch</a>, <a href="https://profiles.wordpress.org/maguiar/">maguiar</a>, <a href="https://profiles.wordpress.org/matheusgimenez/">MatheusGimenez</a>, <a href="https://profiles.wordpress.org/mboynes/">Matthew Boynes</a>, <a href="https://profiles.wordpress.org/mattwiebe/">Matt Wiebe</a>, <a href="https://profiles.wordpress.org/mayurk/">Mayur Keshwani</a>, <a href="https://profiles.wordpress.org/melchoyce/">Mel Choyce</a>, <a href="https://profiles.wordpress.org/celloexpressions/">Nick Halsey</a>, <a href="https://profiles.wordpress.org/swissspidy/">Pascal Birchler</a>, <a href="https://profiles.wordpress.org/peterwilsoncc/">Peter Wilson</a>, <a href="https://profiles.wordpress.org/delawski/">Piotr Delawski</a>, <a href="https://profiles.wordpress.org/pratikshrestha/">Pratik Shrestha</a>, <a href="https://profiles.wordpress.org/programmin/">programmin</a>, <a href="https://profiles.wordpress.org/rachelbaker/">Rachel Baker</a>, <a href="https://profiles.wordpress.org/sagarkbhatt/">sagarkbhatt</a>, <a href="https://profiles.wordpress.org/sagarprajapati/">Sagar Prajapati</a>, <a href="https://profiles.wordpress.org/sboisvert/">sboisvert</a>, <a href="https://profiles.wordpress.org/wonderboymusic/">Scott Taylor</a>, <a href="https://profiles.wordpress.org/sergeybiryukov/">Sergey Biryukov</a>, <a href="https://profiles.wordpress.org/netweb/">Stephen Edgar</a>, <a href="https://profiles.wordpress.org/cybr/">Sybre Waaijer</a>, <a href="https://profiles.wordpress.org/timmydcrawford/">Timmy Crawford</a>, <a href="https://profiles.wordpress.org/vortfu/">vortfu</a> oraz <a href="https://profiles.wordpress.org/westonruter/">Weston Ruter</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:101:"https://pl.wordpress.org/2017/04/20/wordpress-4-7-4-wydanie-poprawiajace-bezpieczenstwo-i-bledy/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:30:"WordCamp Lublin 2017 zaprasza!";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:66:"https://pl.wordpress.org/2017/03/22/wordcamp-lublin-2017-zaprasza/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:75:"https://pl.wordpress.org/2017/03/22/wordcamp-lublin-2017-zaprasza/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 22 Mar 2017 13:27:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:10:"Wydarzenia";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:31:"https://pl.wordpress.org/?p=760";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:423:"W dniach 2-4 czerwca br. odbędzie się kolejna edycja polskiego WordCampa &#8211; konferencji poświęconej WordPressowi. Tym razem programiści, koderzy, blogerzy i inne osoby korzystające na co dzień z WordPressa spotkają się w Lublinie. W ramach konferencji odbędą się: 2 czerwca: contributor day Contributor Day to specjalne spotkanie podczas którego każdy będzie miał możliwość dołączenia do [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"Marcin Pietrzak";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:1614:"<p>W dniach 2-4 czerwca br. odbędzie się kolejna edycja polskiego WordCampa &#8211; konferencji poświęconej WordPressowi. Tym razem programiści, koderzy, blogerzy i inne osoby korzystające na co dzień z WordPressa spotkają się w Lublinie.</p>\n<p>W ramach konferencji odbędą się:</p>\n<h2>2 czerwca: contributor day</h2>\n<p><a href="https://2017.lublin.wordcamp.org/czym-jest-contributor-day/">Contributor Day</a> to specjalne spotkanie podczas którego każdy będzie miał możliwość dołączenia do osób tworzących zarówno WordPressa jak i powiązanych z nim projektów. Oznacza to również, że będzie to świetna okazja do wspólnej pracy nad polskimi tłumaczeniami.</p>\n<h2>3-4 czerwca: prelekcje i warsztaty</h2>\n<p>Podczas prezentacji i warsztatów będzie można nabyć solidną porcję wiedzy od najlepszych ekspertów WordPressa z kraju i z zagranicy. Dodatkowo, uczestnicy będą mogli wziąć udział w specjalnie przygotowanej grze konferencyjnej oraz wieczornej imprezie integracyjnej.</p>\n<p>WordCamp organizowany jest przez społeczność WordPressa, w tym także przez Ciebie! Jeśli chciałbyś pomóc &#8211; wystąpić na scenie, poprowadzić warsztaty lub zostać sponsorem koniecznie daj znać:</p>\n<ul>\n<li><a href="https://2017.lublin.wordcamp.org/zostan-prelegentem/">zgłoszenia prelegentów i osób prowadzących warsztaty</a></li>\n<li><a href="https://2017.lublin.wordcamp.org/zostan-sponsorem/">zgłoszenia sponsorów</a></li>\n</ul>\n<p>Po więcej informacji zapraszamy na oficjalną stronę: <a href="https://2017.lublin.wordcamp.org/">WordCamp Lublin 2017</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:71:"https://pl.wordpress.org/2017/03/22/wordcamp-lublin-2017-zaprasza/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:45:"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:67:"WordPress 4.7.3 – Wydanie poprawiające bezpieczeństwo i błędy";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:60:"https://pl.wordpress.org/2017/03/07/wordpress-4-7-3-wydanie/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:68:"https://pl.wordpress.org/2017/03/07/wordpress-4-7-3-wydanie/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 07 Mar 2017 07:29:45 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:15:"Bezpieczeństwo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"Wydanie";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:31:"https://pl.wordpress.org/?p=753";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:474:"WordPress 4.7.3 jest już dostępny. Wersja poprawia bezpieczeństwo we wszystkich poprzednich wersjach, a my zachęcamy do niezwłocznej aktualizacji witryn. WordPress 4.7.2 oraz wcześniejsze posiadają sześć podatności: Cross-site scripting (XSS) za pomocą metadanych plików multimedialnych. Zgłoszone przez Chris Andrè Dale, Yorick Koster, and Simon P. Briggs. Znaki kontrolne mogą oszukać walidacji adresu URL przekierowania. Zgłoszone przez Daniel [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"Marcin Pietrzak";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:6307:"<p>WordPress 4.7.3 jest już dostępny. Wersja poprawia <strong>bezpieczeństwo</strong> we wszystkich poprzednich wersjach, a my zachęcamy do niezwłocznej aktualizacji witryn.</p>\n<p>WordPress 4.7.2 oraz wcześniejsze posiadają sześć podatności:</p>\n<ol>\n<li>Cross-site scripting (XSS) za pomocą metadanych plików multimedialnych. Zgłoszone przez <a href="https://www.securesolutions.no/">Chris Andrè Dale</a>, <a href="https://twitter.com/yorickkoster">Yorick Koster</a>, and Simon P. Briggs.</li>\n<li>Znaki kontrolne mogą oszukać walidacji adresu URL przekierowania. Zgłoszone przez <a href="http://www.danielchatfield.com/">Daniel Chatfield</a>.</li>\n<li>Pliki niezwiązane z wtyczką, mogą być usuwane korzystając z funkcjonalności usunięcia wtyczki. Zgłoszone przez <a href="http://b.360.cn/">xuliang</a>.</li>\n<li>Cross-site scripting (XSS) za pośrednictwem adresu URL YouTube. Zgłoszone przez <a href="https://twitter.com/marcs0h">Marc Montpas</a>.</li>\n<li>Cross-site scripting (XSS) poprzez nazwę taksonomii. Zgłoszone przez <a href="https://profiles.wordpress.org/deltamgm2">Delta</a>.</li>\n<li>Cross-site request forgery (CSRF) w Press This! co prowadzi do nadmiernego wykorzystania zasobów serwera. Zgłoszone przez Sipke Mellema.</li>\n</ol>\n<p>Dziękujemy raportującym za głoszenia zgodne z praktyką <a href="//make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/">odpowiedzialnego ujawniania</a> (tekst po angielsku).</p>\n<p>W uzupełnieniu do powyższych kwestii bezpieczeństwa, WordPress 4.7.3 zawiera 39 poprawek serwisowych dla serii 4.7. Aby uzyskać więcej informacji, zobacz <a href="https://codex.wordpress.org/Version_4.7.3">informacje o wydaniu</a> (tekst po angielsku) oraz zapoznaj się z <a href="https://core.trac.wordpress.org/query?status=closed&amp;milestone=4.7.3&amp;group=component&amp;col=id&amp;col=summary&amp;col=component&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=keywords&amp;order=priority">listą zmian</a>.</p>\n<p><a href="https://pl.wordpress.org/">Pobierz WordPress 4.7.3</a> lub przejdź do kokpitu → Aktualizacje i kliknij „Zaktualizuj teraz”. Witryny które obsługują automatyczne aktualizacje powinny już być uaktualnione do WordPressa 4.7.3.</p>\n<p>Dziekujemy wszystkim, którzy dołożyli się do wydania 4.7.3: <a href="https://profiles.wordpress.org/aaroncampbell/">Aaron D. Campbell</a>, <a href="https://profiles.wordpress.org/adamsilverstein/">Adam Silverstein</a>, <a href="https://profiles.wordpress.org/xknown/">Alex Concha</a>, <a href="https://profiles.wordpress.org/afercia/">Andrea Fercia</a>, <a href="https://profiles.wordpress.org/azaozz/">Andrew Ozz</a>, <a href="https://profiles.wordpress.org/asalce/">asalce</a>, <a href="https://profiles.wordpress.org/blobfolio/">blobfolio</a>, <a href="https://profiles.wordpress.org/gitlost/">bonger</a>, <a href="https://profiles.wordpress.org/boonebgorges/">Boone Gorges</a>, <a href="https://profiles.wordpress.org/bor0/">Boro Sitnikovski</a>, <a href="https://profiles.wordpress.org/bradyvercher/">Brady Vercher</a>, <a href="https://profiles.wordpress.org/drrobotnik/">Brandon Lavigne</a>, <a href="https://profiles.wordpress.org/bhargavbhandari90/">Bunty</a>, <a href="https://profiles.wordpress.org/ccprog/">ccprog</a>, <a href="https://profiles.wordpress.org/ketuchetan/">chetansatasiya</a>, <a href="https://profiles.wordpress.org/davidakennedy/">David A. Kennedy</a>, <a href="https://profiles.wordpress.org/dlh/">David Herrera</a>, <a href="https://profiles.wordpress.org/dhanendran/">Dhanendran</a>, <a href="https://profiles.wordpress.org/dd32/">Dion Hulse</a>, <a href="https://profiles.wordpress.org/ocean90/">Dominik Schilling (ocean90)</a>, <a href="https://profiles.wordpress.org/drivingralle/">Drivingralle</a>, <a href="https://profiles.wordpress.org/iseulde/">Ella Van Dorpe</a>, <a href="https://profiles.wordpress.org/pento/">Gary Pendergast</a>, <a href="https://profiles.wordpress.org/iandunn/">Ian Dunn</a>, <a href="https://profiles.wordpress.org/ipstenu/">Ipstenu (Mika Epstein)</a>, <a href="https://profiles.wordpress.org/jnylen0/">James Nylen</a>, <a href="https://profiles.wordpress.org/jazbek/">jazbek</a>, <a href="https://profiles.wordpress.org/jeremyfelt/">Jeremy Felt</a>, <a href="https://profiles.wordpress.org/jpry/">Jeremy Pry</a>, <a href="https://profiles.wordpress.org/joehoyle/">Joe Hoyle</a>, <a href="https://profiles.wordpress.org/joemcgill/">Joe McGill</a>, <a href="https://profiles.wordpress.org/johnbillion/">John Blackbourn</a>, <a href="https://profiles.wordpress.org/johnjamesjacoby/">John James Jacoby</a>, <a href="https://profiles.wordpress.org/desrosj/">Jonathan Desrosiers</a>, <a href="https://profiles.wordpress.org/ryelle/">Kelly Dwan</a>, <a href="https://profiles.wordpress.org/markoheijnen/">Marko Heijnen</a>, <a href="https://profiles.wordpress.org/matheusgimenez/">MatheusGimenez</a>, <a href="https://profiles.wordpress.org/mnelson4/">Mike Nelson</a>, <a href="https://profiles.wordpress.org/mikeschroder/">Mike Schroder</a>, <a href="https://profiles.wordpress.org/codegeass/">Muhammet Arslan</a>, <a href="https://profiles.wordpress.org/celloexpressions/">Nick Halsey</a>, <a href="https://profiles.wordpress.org/swissspidy/">Pascal Birchler</a>, <a href="https://profiles.wordpress.org/pbearne/">Paul Bearne</a>, <a href="https://profiles.wordpress.org/pavelevap/">pavelevap</a>, <a href="https://profiles.wordpress.org/peterwilsoncc/">Peter Wilson</a>, <a href="https://profiles.wordpress.org/rachelbaker/">Rachel Baker</a>, <a href="https://profiles.wordpress.org/reldev/">reldev</a>, <a href="https://profiles.wordpress.org/sanchothefat/">Robert O’Rourke</a>, <a href="https://profiles.wordpress.org/welcher/">Ryan Welcher</a>, <a href="https://profiles.wordpress.org/sanketparmar/">Sanket Parmar</a>, <a href="https://profiles.wordpress.org/seanchayes/">Sean Hayes</a>, <a href="https://profiles.wordpress.org/sergeybiryukov/">Sergey Biryukov</a>, <a href="https://profiles.wordpress.org/netweb/">Stephen Edgar</a>, <a href="https://profiles.wordpress.org/triplejumper12/">triplejumper12</a>, <a href="https://profiles.wordpress.org/westonruter/">Weston Ruter</a>, and <a href="https://profiles.wordpress.org/wpfo/">wpfo</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:65:"https://pl.wordpress.org/2017/03/07/wordpress-4-7-3-wydanie/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:45:"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:57:"WordPress 4.7.2 – Wydanie poprawiające bezpieczeństwo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:88:"https://pl.wordpress.org/2017/01/29/wordpress-4-7-2-wydanie-poprawiajace-bezpieczenstwo/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:97:"https://pl.wordpress.org/2017/01/29/wordpress-4-7-2-wydanie-poprawiajace-bezpieczenstwo/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 29 Jan 2017 08:46:25 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:15:"Bezpieczeństwo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"Wydanie";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:31:"https://pl.wordpress.org/?p=739";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:483:"WordPress 4.7.2 jest już dostępny. Wersja poprawia bezpieczeństwo we wszystkich poprzednich wersjach, a my zachęcamy do niezwłocznej aktualizacji witryn. WordPress 4.7.1 oraz wcześniejsze wersje posiadają następujące podaności: Interfejs użytkownika służący do przypisywania taksonomii w &#8222;Press This&#8221; jest widoczny dla użytkowników, którzy nie mają uprawnień, aby go używać. Zgłoszone przez Davida Herrera Alley Interactive. Klasa WP_Query [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"Marcin Pietrzak";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:1642:"<p>WordPress 4.7.2 jest już dostępny. Wersja <strong>poprawia bezpieczeństwo</strong> we wszystkich poprzednich wersjach, a my zachęcamy do niezwłocznej aktualizacji witryn.</p>\n<p>WordPress 4.7.1 oraz wcześniejsze wersje posiadają następujące podaności:</p>\n<ol>\n<li>Interfejs użytkownika służący do przypisywania taksonomii w &#8222;Press This&#8221; jest widoczny dla użytkowników, którzy nie mają uprawnień, aby go używać. Zgłoszone przez Davida Herrera <a href="https://www.alleyinteractive.com/">Alley Interactive</a>.</li>\n<li>Klasa <code>WP_Query</code> jest podatna na SQL injection (SQLi) podczas przetwarzania niebezpiecznych danych. Sam WordPress nie jest bezpośrednio narażony na ten problem, ale dodaliśmy zabezpieczenie, aby zapobiec przypadkowemu użycia podaności we wtyczkach i motywach. Zgłoszone przez <a href="https://github.com/mjangda">Mo Jangda</a> (batmoo).</li>\n<li>Podatność cross-site scripting (XSS) została odkryta w tabeli z listą wpisów. Zgłoszone przez <a href="https://iandunn.name/">Ian Dunn</a> z WordPress Security Team.</li>\n</ol>\n<p>Dziękujemy raportującym za głoszenia zgodne z praktyką <a href="https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/">odpowiedzialnego ujawniania</a> (tekst po angielsku).</p>\n<p><a href="https://pl.wordpress.org/">Pobierz WordPress 4.7.2</a> lub przejdź do kokpitu → Aktualizacje i kliknij &#8222;Zaktualizuj teraz&#8221;. Witryny które obsługują automatyczne aktualizacje powinny już być uaktualnione do WordPressa 4.7.2.</p>\n<p>Dziękujemy wszystkim, którzy przyczynili się do 4.7.2.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:93:"https://pl.wordpress.org/2017/01/29/wordpress-4-7-2-wydanie-poprawiajace-bezpieczenstwo/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:45:"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:57:"WordPress 4.5.2 – Wydanie poprawiające bezpieczeństwo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:88:"https://pl.wordpress.org/2016/05/12/wordpress-4-5-2-wydanie-poprawiajace-bezpieczenstwo/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:97:"https://pl.wordpress.org/2016/05/12/wordpress-4-5-2-wydanie-poprawiajace-bezpieczenstwo/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 12 May 2016 11:04:08 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:15:"Bezpieczeństwo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"Wydanie";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:31:"https://pl.wordpress.org/?p=718";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:435:"WordPress 4.5.2 jest już dostępny. To wydanie poprawia bezpieczeństwo we wszystkich poprzednich wersjach systemu. Zalecane jest natychmiastowe przeprowadzenie aktualizacji. WordPress w wersjach 4.5.1 i wcześniejszych jest podatny na atak metodą SOME przez błąd bezpieczeństwa w Plupload – zewnętrznej bibliotece, której WordPress używa do wgrywania plików. WordPress w wersjach 4.2 do 4.5.1 jest podatny na atak [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:37:"Krzysztof Trynkiewicz (Sukces Strony)";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:2085:"<p>WordPress 4.5.2 jest już dostępny. <strong>To wydanie poprawia bezpieczeństwo</strong> we wszystkich poprzednich wersjach systemu. Zalecane jest natychmiastowe przeprowadzenie aktualizacji.</p>\n<p><span id="more-718"></span></p>\n<p>WordPress w wersjach 4.5.1 i wcześniejszych jest podatny na atak metodą <abbr title="Same-Origin Method Execution">SOME</abbr> przez błąd bezpieczeństwa w Plupload – zewnętrznej bibliotece, której WordPress używa do wgrywania plików. WordPress w wersjach 4.2 do 4.5.1 jest podatny na atak metodą reflected XSS przez użycie specjalnie spreparowanych adresów URI dla MediaElement.js – zewnętrznej biblioteki, używanej przez odtwarzacze mediów. Biblioteki MediaElement.js i Plupload także zostały zaktualizowane przez ich autorów w celu poprawienia tych błędów bezpieczeństwa.</p>\n<p>Obydwa problemy zostały wykryli i zgłosili: Mario Heiderich, Masato Kinugawa i Filedescriptor z <a href="https://cure53.de/">Cure53</a>. Dziękujemy zespołowi za <a href="https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/">odpowiedzialne ujawnienie</a> tych problemów, a także zespołom bibliotek Plupload i MediaElement.js za ścisłą współpracę z nami w celu usunięcia tych błędów.</p>\n<p><a href="https://wordpress.org/download/">Pobierz WordPressa 4.5.2</a> lub udaj się do sekcji Kokpit → Aktualizacje panelu administracyjnego i po prostu kliknij przycisk „Zaktualizuj teraz”. Witryny, które obsługują automatyczne aktualizacje, rozpoczęły już ich przeprowadzanie.</p>\n<p>Informujemy także, że publiczny rozgłos uzyskały ostatnio problemy bezpieczeństwa wykryte w bibliotece przetwarzającej obrazy ImageMagick, używanej przez wielu dostawców hostingowych, którą może wykorzystywać również WordPress. Nasze aktualne stanowisko na temat tych problemów oraz zalecenia można poznać <a href="https://make.wordpress.org/core/2016/05/06/imagemagick-vulnerability-information/">czytając ten wpis na blogu o tworzeniu rdzenia systemu</a> (w języku angielskim).</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:93:"https://pl.wordpress.org/2016/05/12/wordpress-4-5-2-wydanie-poprawiajace-bezpieczenstwo/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"12";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:42:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:49:"WordPress 4.5.1 – Wydanie poprawiające błędy";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:79:"https://pl.wordpress.org/2016/04/26/wordpress-4-5-1-wydanie-poprawiajace-bledy/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:87:"https://pl.wordpress.org/2016/04/26/wordpress-4-5-1-wydanie-poprawiajace-bledy/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 26 Apr 2016 15:32:31 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:7:"Wydanie";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:31:"https://pl.wordpress.org/?p=726";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:457:"Po około sześciu milionach pobrań WordPressa 4.5 z przyjemnością oznajmiamy dostępność aktualizacji poprawiającej błędy &#8211; WordPressa w wersji 4.5.1. To wydanie naprawia 12 błędów, w tym: problem z klasą singular, który psuł witryny używające motywu Twenty Eleven, brak kompatybilności edytora wizualnego z pewnymi wersjami przeglądarki Chrome, a także błąd w Imagick, który mógł powodować niewłaściwe wgrywanie [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:37:"Krzysztof Trynkiewicz (Sukces Strony)";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:2252:"<p>Po około sześciu milionach pobrań WordPressa 4.5 z przyjemnością oznajmiamy dostępność aktualizacji poprawiającej błędy &#8211; WordPressa w wersji 4.5.1.</p>\n<p><span id="more-726"></span></p>\n<p>To wydanie naprawia 12 błędów, w tym: problem z klasą singular, który psuł witryny używające motywu Twenty Eleven, brak kompatybilności edytora wizualnego z pewnymi wersjami przeglądarki Chrome, a także błąd w Imagick, który mógł powodować niewłaściwe wgrywanie plików mediów. To wydanie poprawiające błędy naprawia łącznie 12 problemów występujących w wersji 4.5 WordPressa. <span style="line-height: 1.5">Więcej informacji można znaleźć w <a href="https://codex.wordpress.org/Version_4.5.1">notatkach do wydania</a> oraz <a href="https://core.trac.wordpress.org/log/branches/4.5?rev=37295&amp;stop_rev=37182">liście przeprowadzonych zmian</a>.</span></p>\n<p><a href="https://wordpress.org/download/">Pobierz WordPressa 4.5.1</a> lub udaj się do sekcji Kokpit → Aktualizacje panelu administracyjnego i po prostu kliknij przycisk „Zaktualizuj teraz”. Witryny, które obsługują automatyczne aktualizacje, rozpoczęły już ich przeprowadzanie.</p>\n<p>Dziękujemy wszystkim, którzy przyczynili się do powstania wersji 4.5.1:</p>\n<p><a href="https://profiles.wordpress.org/jorbin">Aaron Jorbin</a>, <a href="https://profiles.wordpress.org/afercia">Andrea Fercia</a>, <a href="https://profiles.wordpress.org/azaozz">Andrew Ozz</a>, <a href="https://profiles.wordpress.org/boonebgorges">Boone Gorges</a>, <a href="https://profiles.wordpress.org/ocean90">Dominik Schilling</a>, <a href="https://profiles.wordpress.org/flixos90">Felix Arntz</a>, <a href="https://profiles.wordpress.org/pento">Gary Pendergast</a>, <a href="https://profiles.wordpress.org/gblsm">gblsm</a>, <a href="https://profiles.wordpress.org/helen">Helen Hou-Sandi</a>, <a href="https://profiles.wordpress.org/joemcgill">Joe McGill</a>, <a href="https://profiles.wordpress.org/johnbillion">John Blackbourn</a>, <a href="https://profiles.wordpress.org/celloexpressions">Nick Halsey</a>, <a href="https://profiles.wordpress.org/swissspidy">Pascal Birchler</a> oraz <a href="https://profiles.wordpress.org/WiZZarD_">Pieter</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:84:"https://pl.wordpress.org/2016/04/26/wordpress-4-5-1-wydanie-poprawiajace-bledy/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:4:"href";s:30:"https://pl.wordpress.org/feed/";s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:44:"http://purl.org/rss/1.0/modules/syndication/";a:2:{s:12:"updatePeriod";a:1:{i:0;a:5:{s:4:"data";s:6:"hourly";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:15:"updateFrequency";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";O:42:"Requests_Utility_CaseInsensitiveDictionary":1:{s:7:"\0*\0data";a:8:{s:6:"server";s:5:"nginx";s:4:"date";s:29:"Wed, 25 Oct 2017 11:25:32 GMT";s:12:"content-type";s:34:"application/rss+xml; charset=UTF-8";s:6:"x-olaf";s:3:"⛄";s:13:"last-modified";s:29:"Thu, 12 Oct 2017 07:03:53 GMT";s:4:"link";s:61:"<https://pl.wordpress.org/wp-json/>; rel="https://api.w.org/"";s:15:"x-frame-options";s:10:"SAMEORIGIN";s:4:"x-nc";s:11:"HIT lax 250";}}s:5:"build";s:14:"20170802214252";}', 'no'),
 (301, '_transient_timeout_feed_mod_a421d6f32723068ab074a40017a9e1f9', '1508973932', 'no'),
 (302, '_transient_feed_mod_a421d6f32723068ab074a40017a9e1f9', '1508930732', 'no'),
 (303, '_transient_timeout_dash_v2_5ed7e1a5d79caaf375d35c33f6782653', '1508973932', 'no'),
 (304, '_transient_dash_v2_5ed7e1a5d79caaf375d35c33f6782653', '<div class="rss-widget"><ul><li><a class=\'rsswidget\' href=\'https://pl.wordpress.org/2017/10/12/wordpress-4-9-beta-2/\'>WordPress 4.9 Beta 2</a></li></ul></div><div class="rss-widget"><ul><li><a class=\'rsswidget\' href=\'https://pl.wordpress.org/2017/10/12/wordpress-4-9-beta-2/\'>WordPress 4.9 Beta 2</a></li><li><a class=\'rsswidget\' href=\'https://pl.wordpress.org/2017/09/22/wordpress-4-8-2-wydanie-poprawiajace-bezpieczenstwo-i-bledy/\'>WordPress 4.8.2 – Wydanie poprawiające bezpieczeństwo i błędy</a></li><li><a class=\'rsswidget\' href=\'https://pl.wordpress.org/2017/06/15/zrob-cos-dla-wordpressa/\'>Zrób jedną rzecz i zmień przyszłość WordCampa</a></li></ul></div>', 'no'),
 (305, '_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a', '1508942190', 'no'),
 (306, '_site_transient_poptags_40cd750bba9870f18aada2478b24840a', 'O:8:"stdClass":100:{s:6:"widget";a:3:{s:4:"name";s:6:"widget";s:4:"slug";s:6:"widget";s:5:"count";i:4390;}s:4:"post";a:3:{s:4:"name";s:4:"post";s:4:"slug";s:4:"post";s:5:"count";i:2515;}s:5:"admin";a:3:{s:4:"name";s:5:"admin";s:4:"slug";s:5:"admin";s:5:"count";i:2374;}s:11:"woocommerce";a:3:{s:4:"name";s:11:"woocommerce";s:4:"slug";s:11:"woocommerce";s:5:"count";i:2359;}s:5:"posts";a:3:{s:4:"name";s:5:"posts";s:4:"slug";s:5:"posts";s:5:"count";i:1839;}s:8:"comments";a:3:{s:4:"name";s:8:"comments";s:4:"slug";s:8:"comments";s:5:"count";i:1609;}s:9:"shortcode";a:3:{s:4:"name";s:9:"shortcode";s:4:"slug";s:9:"shortcode";s:5:"count";i:1601;}s:7:"twitter";a:3:{s:4:"name";s:7:"twitter";s:4:"slug";s:7:"twitter";s:5:"count";i:1437;}s:6:"google";a:3:{s:4:"name";s:6:"google";s:4:"slug";s:6:"google";s:5:"count";i:1361;}s:6:"images";a:3:{s:4:"name";s:6:"images";s:4:"slug";s:6:"images";s:5:"count";i:1357;}s:8:"facebook";a:3:{s:4:"name";s:8:"facebook";s:4:"slug";s:8:"facebook";s:5:"count";i:1347;}s:5:"image";a:3:{s:4:"name";s:5:"image";s:4:"slug";s:5:"image";s:5:"count";i:1281;}s:7:"sidebar";a:3:{s:4:"name";s:7:"sidebar";s:4:"slug";s:7:"sidebar";s:5:"count";i:1273;}s:3:"seo";a:3:{s:4:"name";s:3:"seo";s:4:"slug";s:3:"seo";s:5:"count";i:1147;}s:7:"gallery";a:3:{s:4:"name";s:7:"gallery";s:4:"slug";s:7:"gallery";s:5:"count";i:1064;}s:4:"page";a:3:{s:4:"name";s:4:"page";s:4:"slug";s:4:"page";s:5:"count";i:1054;}s:6:"social";a:3:{s:4:"name";s:6:"social";s:4:"slug";s:6:"social";s:5:"count";i:998;}s:5:"email";a:3:{s:4:"name";s:5:"email";s:4:"slug";s:5:"email";s:5:"count";i:961;}s:9:"ecommerce";a:3:{s:4:"name";s:9:"ecommerce";s:4:"slug";s:9:"ecommerce";s:5:"count";i:828;}s:5:"login";a:3:{s:4:"name";s:5:"login";s:4:"slug";s:5:"login";s:5:"count";i:827;}s:5:"links";a:3:{s:4:"name";s:5:"links";s:4:"slug";s:5:"links";s:5:"count";i:815;}s:7:"widgets";a:3:{s:4:"name";s:7:"widgets";s:4:"slug";s:7:"widgets";s:5:"count";i:779;}s:5:"video";a:3:{s:4:"name";s:5:"video";s:4:"slug";s:5:"video";s:5:"count";i:773;}s:7:"content";a:3:{s:4:"name";s:7:"content";s:4:"slug";s:7:"content";s:5:"count";i:675;}s:3:"rss";a:3:{s:4:"name";s:3:"rss";s:4:"slug";s:3:"rss";s:5:"count";i:672;}s:10:"buddypress";a:3:{s:4:"name";s:10:"buddypress";s:4:"slug";s:10:"buddypress";s:5:"count";i:666;}s:4:"spam";a:3:{s:4:"name";s:4:"spam";s:4:"slug";s:4:"spam";s:5:"count";i:656;}s:8:"security";a:3:{s:4:"name";s:8:"security";s:4:"slug";s:8:"security";s:5:"count";i:653;}s:5:"pages";a:3:{s:4:"name";s:5:"pages";s:4:"slug";s:5:"pages";s:5:"count";i:648;}s:6:"jquery";a:3:{s:4:"name";s:6:"jquery";s:4:"slug";s:6:"jquery";s:5:"count";i:638;}s:6:"slider";a:3:{s:4:"name";s:6:"slider";s:4:"slug";s:6:"slider";s:5:"count";i:634;}s:5:"media";a:3:{s:4:"name";s:5:"media";s:4:"slug";s:5:"media";s:5:"count";i:615;}s:9:"analytics";a:3:{s:4:"name";s:9:"analytics";s:4:"slug";s:9:"analytics";s:5:"count";i:603;}s:4:"feed";a:3:{s:4:"name";s:4:"feed";s:4:"slug";s:4:"feed";s:5:"count";i:595;}s:4:"ajax";a:3:{s:4:"name";s:4:"ajax";s:4:"slug";s:4:"ajax";s:5:"count";i:588;}s:6:"search";a:3:{s:4:"name";s:6:"search";s:4:"slug";s:6:"search";s:5:"count";i:587;}s:10:"e-commerce";a:3:{s:4:"name";s:10:"e-commerce";s:4:"slug";s:10:"e-commerce";s:5:"count";i:581;}s:8:"category";a:3:{s:4:"name";s:8:"category";s:4:"slug";s:8:"category";s:5:"count";i:579;}s:4:"menu";a:3:{s:4:"name";s:4:"menu";s:4:"slug";s:4:"menu";s:5:"count";i:564;}s:4:"form";a:3:{s:4:"name";s:4:"form";s:4:"slug";s:4:"form";s:5:"count";i:562;}s:5:"embed";a:3:{s:4:"name";s:5:"embed";s:4:"slug";s:5:"embed";s:5:"count";i:548;}s:10:"javascript";a:3:{s:4:"name";s:10:"javascript";s:4:"slug";s:10:"javascript";s:5:"count";i:538;}s:4:"link";a:3:{s:4:"name";s:4:"link";s:4:"slug";s:4:"link";s:5:"count";i:530;}s:3:"css";a:3:{s:4:"name";s:3:"css";s:4:"slug";s:3:"css";s:5:"count";i:524;}s:5:"share";a:3:{s:4:"name";s:5:"share";s:4:"slug";s:5:"share";s:5:"count";i:507;}s:7:"youtube";a:3:{s:4:"name";s:7:"youtube";s:4:"slug";s:7:"youtube";s:5:"count";i:503;}s:7:"comment";a:3:{s:4:"name";s:7:"comment";s:4:"slug";s:7:"comment";s:5:"count";i:500;}s:5:"theme";a:3:{s:4:"name";s:5:"theme";s:4:"slug";s:5:"theme";s:5:"count";i:492;}s:10:"responsive";a:3:{s:4:"name";s:10:"responsive";s:4:"slug";s:10:"responsive";s:5:"count";i:478;}s:9:"dashboard";a:3:{s:4:"name";s:9:"dashboard";s:4:"slug";s:9:"dashboard";s:5:"count";i:478;}s:6:"custom";a:3:{s:4:"name";s:6:"custom";s:4:"slug";s:6:"custom";s:5:"count";i:476;}s:10:"categories";a:3:{s:4:"name";s:10:"categories";s:4:"slug";s:10:"categories";s:5:"count";i:476;}s:3:"ads";a:3:{s:4:"name";s:3:"ads";s:4:"slug";s:3:"ads";s:5:"count";i:453;}s:6:"editor";a:3:{s:4:"name";s:6:"editor";s:4:"slug";s:6:"editor";s:5:"count";i:450;}s:9:"affiliate";a:3:{s:4:"name";s:9:"affiliate";s:4:"slug";s:9:"affiliate";s:5:"count";i:448;}s:6:"button";a:3:{s:4:"name";s:6:"button";s:4:"slug";s:6:"button";s:5:"count";i:443;}s:4:"tags";a:3:{s:4:"name";s:4:"tags";s:4:"slug";s:4:"tags";s:5:"count";i:441;}s:12:"contact-form";a:3:{s:4:"name";s:12:"contact form";s:4:"slug";s:12:"contact-form";s:5:"count";i:441;}s:4:"user";a:3:{s:4:"name";s:4:"user";s:4:"slug";s:4:"user";s:5:"count";i:425;}s:5:"photo";a:3:{s:4:"name";s:5:"photo";s:4:"slug";s:5:"photo";s:5:"count";i:417;}s:6:"mobile";a:3:{s:4:"name";s:6:"mobile";s:4:"slug";s:6:"mobile";s:5:"count";i:411;}s:5:"users";a:3:{s:4:"name";s:5:"users";s:4:"slug";s:5:"users";s:5:"count";i:411;}s:7:"contact";a:3:{s:4:"name";s:7:"contact";s:4:"slug";s:7:"contact";s:5:"count";i:408;}s:9:"slideshow";a:3:{s:4:"name";s:9:"slideshow";s:4:"slug";s:9:"slideshow";s:5:"count";i:405;}s:5:"stats";a:3:{s:4:"name";s:5:"stats";s:4:"slug";s:5:"stats";s:5:"count";i:404;}s:6:"photos";a:3:{s:4:"name";s:6:"photos";s:4:"slug";s:6:"photos";s:5:"count";i:398;}s:3:"api";a:3:{s:4:"name";s:3:"api";s:4:"slug";s:3:"api";s:5:"count";i:391;}s:10:"statistics";a:3:{s:4:"name";s:10:"statistics";s:4:"slug";s:10:"statistics";s:5:"count";i:383;}s:6:"events";a:3:{s:4:"name";s:6:"events";s:4:"slug";s:6:"events";s:5:"count";i:383;}s:10:"navigation";a:3:{s:4:"name";s:10:"navigation";s:4:"slug";s:10:"navigation";s:5:"count";i:373;}s:4:"news";a:3:{s:4:"name";s:4:"news";s:4:"slug";s:4:"news";s:5:"count";i:356;}s:8:"calendar";a:3:{s:4:"name";s:8:"calendar";s:4:"slug";s:8:"calendar";s:5:"count";i:347;}s:7:"payment";a:3:{s:4:"name";s:7:"payment";s:4:"slug";s:7:"payment";s:5:"count";i:342;}s:10:"shortcodes";a:3:{s:4:"name";s:10:"shortcodes";s:4:"slug";s:10:"shortcodes";s:5:"count";i:335;}s:9:"multisite";a:3:{s:4:"name";s:9:"multisite";s:4:"slug";s:9:"multisite";s:5:"count";i:333;}s:7:"plugins";a:3:{s:4:"name";s:7:"plugins";s:4:"slug";s:7:"plugins";s:5:"count";i:331;}s:12:"social-media";a:3:{s:4:"name";s:12:"social media";s:4:"slug";s:12:"social-media";s:5:"count";i:331;}s:5:"popup";a:3:{s:4:"name";s:5:"popup";s:4:"slug";s:5:"popup";s:5:"count";i:331;}s:10:"newsletter";a:3:{s:4:"name";s:10:"newsletter";s:4:"slug";s:10:"newsletter";s:5:"count";i:330;}s:4:"code";a:3:{s:4:"name";s:4:"code";s:4:"slug";s:4:"code";s:5:"count";i:327;}s:4:"list";a:3:{s:4:"name";s:4:"list";s:4:"slug";s:4:"list";s:5:"count";i:324;}s:3:"url";a:3:{s:4:"name";s:3:"url";s:4:"slug";s:3:"url";s:5:"count";i:323;}s:4:"meta";a:3:{s:4:"name";s:4:"meta";s:4:"slug";s:4:"meta";s:5:"count";i:323;}s:9:"marketing";a:3:{s:4:"name";s:9:"marketing";s:4:"slug";s:9:"marketing";s:5:"count";i:316;}s:4:"chat";a:3:{s:4:"name";s:4:"chat";s:4:"slug";s:4:"chat";s:5:"count";i:313;}s:8:"redirect";a:3:{s:4:"name";s:8:"redirect";s:4:"slug";s:8:"redirect";s:5:"count";i:301;}s:6:"simple";a:3:{s:4:"name";s:6:"simple";s:4:"slug";s:6:"simple";s:5:"count";i:300;}s:15:"payment-gateway";a:3:{s:4:"name";s:15:"payment gateway";s:4:"slug";s:15:"payment-gateway";s:5:"count";i:296;}s:16:"custom-post-type";a:3:{s:4:"name";s:16:"custom post type";s:4:"slug";s:16:"custom-post-type";s:5:"count";i:295;}s:3:"tag";a:3:{s:4:"name";s:3:"tag";s:4:"slug";s:3:"tag";s:5:"count";i:294;}s:5:"forms";a:3:{s:4:"name";s:5:"forms";s:4:"slug";s:5:"forms";s:5:"count";i:292;}s:11:"advertising";a:3:{s:4:"name";s:11:"advertising";s:4:"slug";s:11:"advertising";s:5:"count";i:287;}s:7:"adsense";a:3:{s:4:"name";s:7:"adsense";s:4:"slug";s:7:"adsense";s:5:"count";i:285;}s:6:"author";a:3:{s:4:"name";s:6:"author";s:4:"slug";s:6:"author";s:5:"count";i:283;}s:4:"html";a:3:{s:4:"name";s:4:"html";s:4:"slug";s:4:"html";s:5:"count";i:283;}s:8:"lightbox";a:3:{s:4:"name";s:8:"lightbox";s:4:"slug";s:8:"lightbox";s:5:"count";i:279;}s:8:"tracking";a:3:{s:4:"name";s:8:"tracking";s:4:"slug";s:8:"tracking";s:5:"count";i:276;}s:12:"notification";a:3:{s:4:"name";s:12:"notification";s:4:"slug";s:12:"notification";s:5:"count";i:276;}s:7:"tinymce";a:3:{s:4:"name";s:7:"tinyMCE";s:4:"slug";s:7:"tinymce";s:5:"count";i:273;}s:7:"captcha";a:3:{s:4:"name";s:7:"captcha";s:4:"slug";s:7:"captcha";s:5:"count";i:271;}}', 'no'),
 (311, 'ctf_version', '1.2.7', 'yes'),
 (312, '_transient_timeout_custom_twitter_feeds_rating_notice_waiting', '1510141038', 'no'),
 (313, '_transient_custom_twitter_feeds_rating_notice_waiting', 'waiting', 'no'),
 (314, 'ctf_rating_notice', 'pending', 'yes'),
 (315, 'widget_custom-twitter-feeds-widget', 'a:2:{i:2;a:2:{s:5:"title";s:12:"Na Twitterze";s:7:"content";s:22:"[custom-twitter-feeds]";}s:12:"_multiwidget";i:1;}', 'yes'),
 (317, 'ctf_options', 'a:74:{s:12:"access_token";s:50:"2651114600-nDSBmNNrgsAb4NER5rWxVgsQhgSDfll7obzly3t";s:19:"access_token_secret";s:45:"TI8nQ1epsDkJhDMhNDg834v6P96JG8KRaMszRWwIu7T7k";s:10:"ajax_theme";b:0;s:15:"have_own_tokens";b:0;s:16:"use_own_consumer";b:0;s:17:"preserve_settings";b:0;s:27:"usertimeline_includereplies";b:0;s:27:"hometimeline_includereplies";b:0;s:31:"mentionstimeline_includereplies";b:0;s:3:"tab";s:5:"style";s:12:"consumer_key";s:0:"";s:15:"consumer_secret";s:0:"";s:4:"type";s:12:"usertimeline";s:17:"usertimeline_text";s:15:"MeteoprognozaPL";s:11:"search_text";s:0:"";s:3:"num";s:1:"5";s:10:"cache_time";s:1:"1";s:15:"cache_time_unit";s:4:"3600";s:14:"includereplies";b:0;s:21:"width_mobile_no_fixed";i:0;s:17:"include_retweeter";b:1;s:14:"include_avatar";b:1;s:14:"include_author";b:1;s:12:"include_text";b:1;s:25:"include_media_placeholder";b:1;s:12:"include_date";b:1;s:15:"include_actions";b:1;s:19:"include_twitterlink";b:1;s:15:"include_linkbox";i:0;s:9:"creditctf";i:0;s:10:"showbutton";b:1;s:10:"showheader";b:1;s:15:"persistentcache";b:1;s:5:"width";s:3:"100";s:10:"width_unit";s:1:"%";s:6:"height";s:4:"1000";s:11:"height_unit";s:2:"px";s:5:"class";s:0:"";s:10:"custom_css";s:0:"";s:9:"custom_js";s:0:"";s:14:"request_method";s:4:"auto";s:16:"cron_cache_clear";s:5:"unset";s:10:"multiplier";s:4:"1.25";s:7:"showbio";b:1;s:12:"disablelinks";b:0;s:17:"linktexttotwitter";b:0;s:7:"bgcolor";s:1:"#";s:12:"tweetbgcolor";s:1:"#";s:13:"headerbgcolor";s:1:"#";s:15:"headertextcolor";s:1:"#";s:10:"headertext";s:13:"METEOprognoza";s:8:"timezone";s:7:"default";s:10:"dateformat";s:1:"1";s:10:"datecustom";s:0:"";s:5:"mtime";s:4:"min.";s:5:"htime";s:5:"godz.";s:7:"nowtime";s:5:"teraz";s:12:"datetextsize";s:7:"inherit";s:14:"datetextweight";s:7:"inherit";s:14:"authortextsize";s:7:"inherit";s:16:"authortextweight";s:7:"inherit";s:13:"tweettextsize";s:7:"inherit";s:15:"tweettextweight";s:7:"inherit";s:9:"textcolor";s:1:"#";s:13:"retweetedtext";s:13:"udostępnione";s:13:"linktextcolor";s:1:"#";s:16:"quotedauthorsize";s:7:"inherit";s:18:"quotedauthorweight";s:7:"inherit";s:8:"iconsize";s:7:"inherit";s:9:"iconcolor";s:1:"#";s:15:"twitterlinktext";s:13:"więcej na TT";s:11:"buttoncolor";s:1:"#";s:15:"buttontextcolor";s:1:"#";s:10:"buttontext";s:17:"pokaż więcej...";}', 'yes'),
 (329, 'nav_menu_options', 'a:2:{i:0;b:0;s:8:"auto_add";a:0:{}}', 'yes'),
 (339, 'category_children', 'a:0:{}', 'yes'),
 (386, '_transient_timeout_ctf__923210673580068864MeteoprognozaPL5', '1508955643', 'no'),
 (387, '_transient_ctf__923210673580068864MeteoprognozaPL5', '[{"user":{"name":"meteoprognoza.pl","screen_name":"MeteoprognozaPL","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/893016305426612225\\/bbYcRjum_normal.jpg","utc_offset":7200},"text":"Dzisiejsza przedpo\\u0142udniowa Kopa Kondracka.\\nZaspsy si\\u0119gaj\\u0105 ju\\u017c 60 cm. \\nby: https:\\/\\/t.co\\/HWJ7yUKBMl ","id_str":"923210673580068864","created_at":"Wed Oct 25 15:32:31 +0000 2017","retweet_count":3,"favorite_count":17,"extended_entities":{"media":[{"type":"photo"}]}},{"user":{"name":"meteoprognoza.pl","screen_name":"MeteoprognozaPL","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/893016305426612225\\/bbYcRjum_normal.jpg","utc_offset":7200},"text":"RT @KrzysztofBryk: @MeteoprognozaPL nad Gda\\u0144skiem cuda \\ud83d\\ude0d ","id_str":"923205691325771776","created_at":"Wed Oct 25 15:12:43 +0000 2017","retweet_count":1,"favorite_count":0,"retweeted_status":{"user":{"name":"Krzysztof Bryk \\ud83c\\uddf3\\ud83c\\uddec","screen_name":"KrzysztofBryk","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/916291311577325568\\/ZXpDOK_5_normal.jpg","utc_offset":7200},"text":"@MeteoprognozaPL nad Gda\\u0144skiem cuda \\ud83d\\ude0d ","id_str":"923198518491254787","created_at":"Wed Oct 25 14:44:13 +0000 2017","retweet_count":1,"favorite_count":8,"extended_entities":{"media":[{"type":"photo"}]}},"extended_entities":{"media":[{"type":"photo"}]}},{"user":{"name":"meteoprognoza.pl","screen_name":"MeteoprognozaPL","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/893016305426612225\\/bbYcRjum_normal.jpg","utc_offset":7200},"text":"#Babia G\\u00f3ra i widoki jakie si\\u0119 prezentowa\\u0142y dzisiaj oko\\u0142o po\\u0142udnia.\\nfot. Mariusz Wojtyczka\\/Fb\\/Aktualne warunki w g\\u00f3rach ","id_str":"923203747408433152","created_at":"Wed Oct 25 15:05:00 +0000 2017","retweet_count":4,"favorite_count":39,"extended_entities":{"media":[{"type":"photo"},{"type":"photo"},{"type":"photo"}]}},{"user":{"name":"meteoprognoza.pl","screen_name":"MeteoprognozaPL","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/893016305426612225\\/bbYcRjum_normal.jpg","utc_offset":7200},"text":"Tak wygl\\u0105da\\u0142o #Zakopane dzisiejszego po\\u0142udnia.\\nby Fb\\/Tatry latem ","id_str":"923198723856977921","created_at":"Wed Oct 25 14:45:02 +0000 2017","retweet_count":11,"favorite_count":38,"extended_entities":{"media":[{"type":"photo"}]}}]', 'no'),
 (388, '_transient_timeout_ctf__923186356125396992MeteoprognozaPL5', '1508955644', 'no'),
 (389, '_transient_ctf__923186356125396992MeteoprognozaPL5', '[{"user":{"name":"meteoprognoza.pl","screen_name":"MeteoprognozaPL","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/893016305426612225\\/bbYcRjum_normal.jpg","utc_offset":7200},"text":"Zanim dowiecie si\\u0119 z medi\\u00f3w:\\nJe\\u015bli kto\\u015b si\\u0119 z Was zastanawia czy warto ju\\u017c zmieni\\u0107 opony letnie na zimowe to podpowiadamy: WARTO ","id_str":"923186356125396992","created_at":"Wed Oct 25 13:55:53 +0000 2017","retweet_count":24,"favorite_count":29,"extended_entities":{"media":[{"type":"photo"},{"type":"photo"},{"type":"photo"},{"type":"photo"}]}},{"user":{"name":"meteoprognoza.pl","screen_name":"MeteoprognozaPL","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/893016305426612225\\/bbYcRjum_normal.jpg","utc_offset":7200},"text":"I strzeli\\u0142y korki od szampana\\ud83e\\udd2a\\ud83e\\udd23\\ud83d\\ude0d\\ud83c\\udf7e\\ud83d\\ude07\\ud83d\\ude4c\\nWszystkim Wam razem jak i osobno dzi\\u0119kujemy\\nNa tt, my szare myszki, jeste\\u015bmy pogodowo bezkonkurencyjni \\ud83d\\ude09 ","id_str":"923177376325910528","created_at":"Wed Oct 25 13:20:12 +0000 2017","retweet_count":2,"favorite_count":48,"extended_entities":{"media":[{"type":"photo"},{"type":"photo"}]}}]', 'no'),
 (400, '_transient_timeout_ctf__923286921954160640MeteoprognozaPL5', '1508970953', 'no'),
 (401, '_transient_ctf__923286921954160640MeteoprognozaPL5', '[{"user":{"name":"meteoprognoza.pl","screen_name":"MeteoprognozaPL","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/893016305426612225\\/bbYcRjum_normal.jpg","utc_offset":7200},"text":"Dzisiejszy widok z Zawratu.\\n#Tatry\\nFot. Bartek Konieczny\\/Fb Aktualne warunki w g\\u00f3rach ","id_str":"923286921954160640","created_at":"Wed Oct 25 20:35:30 +0000 2017","retweet_count":6,"favorite_count":28,"extended_entities":{"media":[{"type":"photo"}]}},{"user":{"name":"meteoprognoza.pl","screen_name":"MeteoprognozaPL","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/893016305426612225\\/bbYcRjum_normal.jpg","utc_offset":7200},"text":"Dzisiejszy poranek nad Morskim Okiem \\u2744\\ufe0f\\u26c4\\ufe0f\\ud83d\\ude00\\ud83d\\ude0d\\nby Kuba Witos Fotografia ","id_str":"923281828349448192","created_at":"Wed Oct 25 20:15:16 +0000 2017","retweet_count":7,"favorite_count":30,"extended_entities":{"media":[{"type":"photo"}]}},{"user":{"name":"meteoprognoza.pl","screen_name":"MeteoprognozaPL","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/893016305426612225\\/bbYcRjum_normal.jpg","utc_offset":7200},"text":"No i pojawi\\u0142 si\\u0119 wieczorem wysyp \\u015bwietnych fot z Tatr.\\nDzisiejszy poranek na Hali G\\u0105sienicowej w 2 wersjach\\nFot. Bogdan Bafia\\/Patryk Sarka ","id_str":"923278101114753024","created_at":"Wed Oct 25 20:00:27 +0000 2017","retweet_count":17,"favorite_count":48,"extended_entities":{"media":[{"type":"photo"},{"type":"photo"}]}}]', 'no'),
 (402, '_site_transient_timeout_available_translations', '1508978231', 'no'),
 (403, '_site_transient_available_translations', 'a:111:{s:2:"af";a:8:{s:8:"language";s:2:"af";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-02 13:13:49";s:12:"english_name";s:9:"Afrikaans";s:11:"native_name";s:9:"Afrikaans";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.8.2/af.zip";s:3:"iso";a:2:{i:1;s:2:"af";i:2;s:3:"afr";}s:7:"strings";a:1:{s:8:"continue";s:10:"Gaan voort";}}s:2:"ar";a:8:{s:8:"language";s:2:"ar";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-07-29 08:49:40";s:12:"english_name";s:6:"Arabic";s:11:"native_name";s:14:"العربية";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.8.2/ar.zip";s:3:"iso";a:2:{i:1;s:2:"ar";i:2;s:3:"ara";}s:7:"strings";a:1:{s:8:"continue";s:16:"المتابعة";}}s:3:"ary";a:8:{s:8:"language";s:3:"ary";s:7:"version";s:5:"4.7.6";s:7:"updated";s:19:"2017-01-26 15:42:35";s:12:"english_name";s:15:"Moroccan Arabic";s:11:"native_name";s:31:"العربية المغربية";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.6/ary.zip";s:3:"iso";a:2:{i:1;s:2:"ar";i:3;s:3:"ary";}s:7:"strings";a:1:{s:8:"continue";s:16:"المتابعة";}}s:2:"as";a:8:{s:8:"language";s:2:"as";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-22 18:59:07";s:12:"english_name";s:8:"Assamese";s:11:"native_name";s:21:"অসমীয়া";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/as.zip";s:3:"iso";a:3:{i:1;s:2:"as";i:2;s:3:"asm";i:3;s:3:"asm";}s:7:"strings";a:1:{s:8:"continue";s:0:"";}}s:2:"az";a:8:{s:8:"language";s:2:"az";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-06 00:09:27";s:12:"english_name";s:11:"Azerbaijani";s:11:"native_name";s:16:"Azərbaycan dili";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/az.zip";s:3:"iso";a:2:{i:1;s:2:"az";i:2;s:3:"aze";}s:7:"strings";a:1:{s:8:"continue";s:5:"Davam";}}s:3:"azb";a:8:{s:8:"language";s:3:"azb";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-09-12 20:34:31";s:12:"english_name";s:17:"South Azerbaijani";s:11:"native_name";s:29:"گؤنئی آذربایجان";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip";s:3:"iso";a:2:{i:1;s:2:"az";i:3;s:3:"azb";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:3:"bel";a:8:{s:8:"language";s:3:"bel";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-09-26 18:50:50";s:12:"english_name";s:10:"Belarusian";s:11:"native_name";s:29:"Беларуская мова";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.8.2/bel.zip";s:3:"iso";a:2:{i:1;s:2:"be";i:2;s:3:"bel";}s:7:"strings";a:1:{s:8:"continue";s:20:"Працягнуць";}}s:5:"bg_BG";a:8:{s:8:"language";s:5:"bg_BG";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-08-09 09:24:45";s:12:"english_name";s:9:"Bulgarian";s:11:"native_name";s:18:"Български";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/bg_BG.zip";s:3:"iso";a:2:{i:1;s:2:"bg";i:2;s:3:"bul";}s:7:"strings";a:1:{s:8:"continue";s:22:"Продължение";}}s:5:"bn_BD";a:8:{s:8:"language";s:5:"bn_BD";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-01 12:57:10";s:12:"english_name";s:7:"Bengali";s:11:"native_name";s:15:"বাংলা";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/bn_BD.zip";s:3:"iso";a:1:{i:1;s:2:"bn";}s:7:"strings";a:1:{s:8:"continue";s:23:"এগিয়ে চল.";}}s:2:"bo";a:8:{s:8:"language";s:2:"bo";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-09-05 09:44:12";s:12:"english_name";s:7:"Tibetan";s:11:"native_name";s:21:"བོད་ཡིག";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/bo.zip";s:3:"iso";a:2:{i:1;s:2:"bo";i:2;s:3:"tib";}s:7:"strings";a:1:{s:8:"continue";s:24:"མུ་མཐུད།";}}s:5:"bs_BA";a:8:{s:8:"language";s:5:"bs_BA";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-09-04 20:20:28";s:12:"english_name";s:7:"Bosnian";s:11:"native_name";s:8:"Bosanski";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/bs_BA.zip";s:3:"iso";a:2:{i:1;s:2:"bs";i:2;s:3:"bos";}s:7:"strings";a:1:{s:8:"continue";s:7:"Nastavi";}}s:2:"ca";a:8:{s:8:"language";s:2:"ca";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-08-08 21:01:45";s:12:"english_name";s:7:"Catalan";s:11:"native_name";s:7:"Català";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.8.2/ca.zip";s:3:"iso";a:2:{i:1;s:2:"ca";i:2;s:3:"cat";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continua";}}s:3:"ceb";a:8:{s:8:"language";s:3:"ceb";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-03-02 17:25:51";s:12:"english_name";s:7:"Cebuano";s:11:"native_name";s:7:"Cebuano";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip";s:3:"iso";a:2:{i:2;s:3:"ceb";i:3;s:3:"ceb";}s:7:"strings";a:1:{s:8:"continue";s:7:"Padayun";}}s:5:"cs_CZ";a:8:{s:8:"language";s:5:"cs_CZ";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-12 08:46:26";s:12:"english_name";s:5:"Czech";s:11:"native_name";s:12:"Čeština‎";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/cs_CZ.zip";s:3:"iso";a:2:{i:1;s:2:"cs";i:2;s:3:"ces";}s:7:"strings";a:1:{s:8:"continue";s:11:"Pokračovat";}}s:2:"cy";a:8:{s:8:"language";s:2:"cy";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-09-19 16:27:32";s:12:"english_name";s:5:"Welsh";s:11:"native_name";s:7:"Cymraeg";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.8.2/cy.zip";s:3:"iso";a:2:{i:1;s:2:"cy";i:2;s:3:"cym";}s:7:"strings";a:1:{s:8:"continue";s:6:"Parhau";}}s:5:"da_DK";a:8:{s:8:"language";s:5:"da_DK";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-03 23:25:51";s:12:"english_name";s:6:"Danish";s:11:"native_name";s:5:"Dansk";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/da_DK.zip";s:3:"iso";a:2:{i:1;s:2:"da";i:2;s:3:"dan";}s:7:"strings";a:1:{s:8:"continue";s:12:"Forts&#230;t";}}s:14:"de_CH_informal";a:8:{s:8:"language";s:14:"de_CH_informal";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-09-09 11:53:31";s:12:"english_name";s:30:"German (Switzerland, Informal)";s:11:"native_name";s:21:"Deutsch (Schweiz, Du)";s:7:"package";s:73:"https://downloads.wordpress.org/translation/core/4.8.2/de_CH_informal.zip";s:3:"iso";a:1:{i:1;s:2:"de";}s:7:"strings";a:1:{s:8:"continue";s:6:"Weiter";}}s:5:"de_DE";a:8:{s:8:"language";s:5:"de_DE";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-20 19:50:55";s:12:"english_name";s:6:"German";s:11:"native_name";s:7:"Deutsch";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/de_DE.zip";s:3:"iso";a:1:{i:1;s:2:"de";}s:7:"strings";a:1:{s:8:"continue";s:10:"Fortfahren";}}s:12:"de_DE_formal";a:8:{s:8:"language";s:12:"de_DE_formal";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-20 19:52:24";s:12:"english_name";s:15:"German (Formal)";s:11:"native_name";s:13:"Deutsch (Sie)";s:7:"package";s:71:"https://downloads.wordpress.org/translation/core/4.8.2/de_DE_formal.zip";s:3:"iso";a:1:{i:1;s:2:"de";}s:7:"strings";a:1:{s:8:"continue";s:10:"Fortfahren";}}s:5:"de_CH";a:8:{s:8:"language";s:5:"de_CH";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-09-09 11:51:58";s:12:"english_name";s:20:"German (Switzerland)";s:11:"native_name";s:17:"Deutsch (Schweiz)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/de_CH.zip";s:3:"iso";a:1:{i:1;s:2:"de";}s:7:"strings";a:1:{s:8:"continue";s:10:"Fortfahren";}}s:3:"dzo";a:8:{s:8:"language";s:3:"dzo";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-06-29 08:59:03";s:12:"english_name";s:8:"Dzongkha";s:11:"native_name";s:18:"རྫོང་ཁ";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip";s:3:"iso";a:2:{i:1;s:2:"dz";i:2;s:3:"dzo";}s:7:"strings";a:1:{s:8:"continue";s:0:"";}}s:2:"el";a:8:{s:8:"language";s:2:"el";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-25 16:30:54";s:12:"english_name";s:5:"Greek";s:11:"native_name";s:16:"Ελληνικά";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.8.2/el.zip";s:3:"iso";a:2:{i:1;s:2:"el";i:2;s:3:"ell";}s:7:"strings";a:1:{s:8:"continue";s:16:"Συνέχεια";}}s:5:"en_CA";a:8:{s:8:"language";s:5:"en_CA";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-07-25 19:47:01";s:12:"english_name";s:16:"English (Canada)";s:11:"native_name";s:16:"English (Canada)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/en_CA.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"en_GB";a:8:{s:8:"language";s:5:"en_GB";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-08 11:31:20";s:12:"english_name";s:12:"English (UK)";s:11:"native_name";s:12:"English (UK)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/en_GB.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"en_AU";a:8:{s:8:"language";s:5:"en_AU";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-07-25 10:03:08";s:12:"english_name";s:19:"English (Australia)";s:11:"native_name";s:19:"English (Australia)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/en_AU.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"en_ZA";a:8:{s:8:"language";s:5:"en_ZA";s:7:"version";s:5:"4.7.6";s:7:"updated";s:19:"2017-01-26 15:53:43";s:12:"english_name";s:22:"English (South Africa)";s:11:"native_name";s:22:"English (South Africa)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.6/en_ZA.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"en_NZ";a:8:{s:8:"language";s:5:"en_NZ";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-08-02 03:57:05";s:12:"english_name";s:21:"English (New Zealand)";s:11:"native_name";s:21:"English (New Zealand)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/en_NZ.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:2:"eo";a:8:{s:8:"language";s:2:"eo";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-07-26 10:38:53";s:12:"english_name";s:9:"Esperanto";s:11:"native_name";s:9:"Esperanto";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.8.2/eo.zip";s:3:"iso";a:2:{i:1;s:2:"eo";i:2;s:3:"epo";}s:7:"strings";a:1:{s:8:"continue";s:8:"Daŭrigi";}}s:5:"es_AR";a:8:{s:8:"language";s:5:"es_AR";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-08-01 04:48:11";s:12:"english_name";s:19:"Spanish (Argentina)";s:11:"native_name";s:21:"Español de Argentina";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/es_AR.zip";s:3:"iso";a:2:{i:1;s:2:"es";i:2;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_ES";a:8:{s:8:"language";s:5:"es_ES";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-04 05:23:56";s:12:"english_name";s:15:"Spanish (Spain)";s:11:"native_name";s:8:"Español";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/es_ES.zip";s:3:"iso";a:1:{i:1;s:2:"es";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_GT";a:8:{s:8:"language";s:5:"es_GT";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-05 17:50:24";s:12:"english_name";s:19:"Spanish (Guatemala)";s:11:"native_name";s:21:"Español de Guatemala";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/es_GT.zip";s:3:"iso";a:2:{i:1;s:2:"es";i:2;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_CR";a:8:{s:8:"language";s:5:"es_CR";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-01 17:54:52";s:12:"english_name";s:20:"Spanish (Costa Rica)";s:11:"native_name";s:8:"Español";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/es_CR.zip";s:3:"iso";a:2:{i:1;s:2:"es";i:2;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_PE";a:8:{s:8:"language";s:5:"es_PE";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-09-09 09:36:22";s:12:"english_name";s:14:"Spanish (Peru)";s:11:"native_name";s:17:"Español de Perú";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/es_PE.zip";s:3:"iso";a:2:{i:1;s:2:"es";i:2;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_CL";a:8:{s:8:"language";s:5:"es_CL";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-28 20:09:49";s:12:"english_name";s:15:"Spanish (Chile)";s:11:"native_name";s:17:"Español de Chile";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/es_CL.zip";s:3:"iso";a:2:{i:1;s:2:"es";i:2;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_CO";a:8:{s:8:"language";s:5:"es_CO";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-08-13 17:00:30";s:12:"english_name";s:18:"Spanish (Colombia)";s:11:"native_name";s:20:"Español de Colombia";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/es_CO.zip";s:3:"iso";a:2:{i:1;s:2:"es";i:2;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_VE";a:8:{s:8:"language";s:5:"es_VE";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-07-30 16:09:17";s:12:"english_name";s:19:"Spanish (Venezuela)";s:11:"native_name";s:21:"Español de Venezuela";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/es_VE.zip";s:3:"iso";a:2:{i:1;s:2:"es";i:2;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_MX";a:8:{s:8:"language";s:5:"es_MX";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-07-31 15:12:02";s:12:"english_name";s:16:"Spanish (Mexico)";s:11:"native_name";s:19:"Español de México";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/es_MX.zip";s:3:"iso";a:2:{i:1;s:2:"es";i:2;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:2:"et";a:8:{s:8:"language";s:2:"et";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-27 16:37:11";s:12:"english_name";s:8:"Estonian";s:11:"native_name";s:5:"Eesti";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/et.zip";s:3:"iso";a:2:{i:1;s:2:"et";i:2;s:3:"est";}s:7:"strings";a:1:{s:8:"continue";s:6:"Jätka";}}s:2:"eu";a:8:{s:8:"language";s:2:"eu";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-09-19 12:08:05";s:12:"english_name";s:6:"Basque";s:11:"native_name";s:7:"Euskara";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.8.2/eu.zip";s:3:"iso";a:2:{i:1;s:2:"eu";i:2;s:3:"eus";}s:7:"strings";a:1:{s:8:"continue";s:8:"Jarraitu";}}s:5:"fa_IR";a:8:{s:8:"language";s:5:"fa_IR";s:7:"version";s:3:"4.8";s:7:"updated";s:19:"2017-06-09 15:50:45";s:12:"english_name";s:7:"Persian";s:11:"native_name";s:10:"فارسی";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.8/fa_IR.zip";s:3:"iso";a:2:{i:1;s:2:"fa";i:2;s:3:"fas";}s:7:"strings";a:1:{s:8:"continue";s:10:"ادامه";}}s:2:"fi";a:8:{s:8:"language";s:2:"fi";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-07-28 11:00:29";s:12:"english_name";s:7:"Finnish";s:11:"native_name";s:5:"Suomi";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.8.2/fi.zip";s:3:"iso";a:2:{i:1;s:2:"fi";i:2;s:3:"fin";}s:7:"strings";a:1:{s:8:"continue";s:5:"Jatka";}}s:5:"fr_BE";a:8:{s:8:"language";s:5:"fr_BE";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-07-28 09:14:18";s:12:"english_name";s:16:"French (Belgium)";s:11:"native_name";s:21:"Français de Belgique";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/fr_BE.zip";s:3:"iso";a:2:{i:1;s:2:"fr";i:2;s:3:"fra";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuer";}}s:5:"fr_CA";a:8:{s:8:"language";s:5:"fr_CA";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-07-28 12:37:07";s:12:"english_name";s:15:"French (Canada)";s:11:"native_name";s:19:"Français du Canada";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/fr_CA.zip";s:3:"iso";a:2:{i:1;s:2:"fr";i:2;s:3:"fra";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuer";}}s:5:"fr_FR";a:8:{s:8:"language";s:5:"fr_FR";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-14 18:07:51";s:12:"english_name";s:15:"French (France)";s:11:"native_name";s:9:"Français";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/fr_FR.zip";s:3:"iso";a:1:{i:1;s:2:"fr";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuer";}}s:2:"gd";a:8:{s:8:"language";s:2:"gd";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-08-23 17:41:37";s:12:"english_name";s:15:"Scottish Gaelic";s:11:"native_name";s:9:"Gàidhlig";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip";s:3:"iso";a:3:{i:1;s:2:"gd";i:2;s:3:"gla";i:3;s:3:"gla";}s:7:"strings";a:1:{s:8:"continue";s:15:"Lean air adhart";}}s:5:"gl_ES";a:8:{s:8:"language";s:5:"gl_ES";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-07-26 12:45:35";s:12:"english_name";s:8:"Galician";s:11:"native_name";s:6:"Galego";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/gl_ES.zip";s:3:"iso";a:2:{i:1;s:2:"gl";i:2;s:3:"glg";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:2:"gu";a:8:{s:8:"language";s:2:"gu";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-17 14:23:13";s:12:"english_name";s:8:"Gujarati";s:11:"native_name";s:21:"ગુજરાતી";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.8.2/gu.zip";s:3:"iso";a:2:{i:1;s:2:"gu";i:2;s:3:"guj";}s:7:"strings";a:1:{s:8:"continue";s:31:"ચાલુ રાખવું";}}s:3:"haz";a:8:{s:8:"language";s:3:"haz";s:7:"version";s:5:"4.4.2";s:7:"updated";s:19:"2015-12-05 00:59:09";s:12:"english_name";s:8:"Hazaragi";s:11:"native_name";s:15:"هزاره گی";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.4.2/haz.zip";s:3:"iso";a:1:{i:3;s:3:"haz";}s:7:"strings";a:1:{s:8:"continue";s:10:"ادامه";}}s:5:"he_IL";a:8:{s:8:"language";s:5:"he_IL";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-09-12 21:37:24";s:12:"english_name";s:6:"Hebrew";s:11:"native_name";s:16:"עִבְרִית";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/he_IL.zip";s:3:"iso";a:1:{i:1;s:2:"he";}s:7:"strings";a:1:{s:8:"continue";s:12:"להמשיך";}}s:5:"hi_IN";a:8:{s:8:"language";s:5:"hi_IN";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-07-28 10:29:26";s:12:"english_name";s:5:"Hindi";s:11:"native_name";s:18:"हिन्दी";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/hi_IN.zip";s:3:"iso";a:2:{i:1;s:2:"hi";i:2;s:3:"hin";}s:7:"strings";a:1:{s:8:"continue";s:12:"जारी";}}s:2:"hr";a:8:{s:8:"language";s:2:"hr";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-09-22 14:47:25";s:12:"english_name";s:8:"Croatian";s:11:"native_name";s:8:"Hrvatski";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.8.2/hr.zip";s:3:"iso";a:2:{i:1;s:2:"hr";i:2;s:3:"hrv";}s:7:"strings";a:1:{s:8:"continue";s:7:"Nastavi";}}s:5:"hu_HU";a:8:{s:8:"language";s:5:"hu_HU";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-26 15:48:39";s:12:"english_name";s:9:"Hungarian";s:11:"native_name";s:6:"Magyar";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/hu_HU.zip";s:3:"iso";a:2:{i:1;s:2:"hu";i:2;s:3:"hun";}s:7:"strings";a:1:{s:8:"continue";s:7:"Tovább";}}s:2:"hy";a:8:{s:8:"language";s:2:"hy";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-12-03 16:21:10";s:12:"english_name";s:8:"Armenian";s:11:"native_name";s:14:"Հայերեն";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip";s:3:"iso";a:2:{i:1;s:2:"hy";i:2;s:3:"hye";}s:7:"strings";a:1:{s:8:"continue";s:20:"Շարունակել";}}s:5:"id_ID";a:8:{s:8:"language";s:5:"id_ID";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-07-28 12:45:08";s:12:"english_name";s:10:"Indonesian";s:11:"native_name";s:16:"Bahasa Indonesia";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/id_ID.zip";s:3:"iso";a:2:{i:1;s:2:"id";i:2;s:3:"ind";}s:7:"strings";a:1:{s:8:"continue";s:9:"Lanjutkan";}}s:5:"is_IS";a:8:{s:8:"language";s:5:"is_IS";s:7:"version";s:5:"4.7.6";s:7:"updated";s:19:"2017-04-13 13:55:54";s:12:"english_name";s:9:"Icelandic";s:11:"native_name";s:9:"Íslenska";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.6/is_IS.zip";s:3:"iso";a:2:{i:1;s:2:"is";i:2;s:3:"isl";}s:7:"strings";a:1:{s:8:"continue";s:6:"Áfram";}}s:5:"it_IT";a:8:{s:8:"language";s:5:"it_IT";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-09-30 11:12:28";s:12:"english_name";s:7:"Italian";s:11:"native_name";s:8:"Italiano";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/it_IT.zip";s:3:"iso";a:2:{i:1;s:2:"it";i:2;s:3:"ita";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continua";}}s:2:"ja";a:8:{s:8:"language";s:2:"ja";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-09 07:51:37";s:12:"english_name";s:8:"Japanese";s:11:"native_name";s:9:"日本語";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.8.2/ja.zip";s:3:"iso";a:1:{i:1;s:2:"ja";}s:7:"strings";a:1:{s:8:"continue";s:9:"続ける";}}s:5:"jv_ID";a:8:{s:8:"language";s:5:"jv_ID";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-24 05:19:00";s:12:"english_name";s:8:"Javanese";s:11:"native_name";s:9:"Basa Jawa";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/jv_ID.zip";s:3:"iso";a:2:{i:1;s:2:"jv";i:2;s:3:"jav";}s:7:"strings";a:1:{s:8:"continue";s:7:"Nutugne";}}s:5:"ka_GE";a:8:{s:8:"language";s:5:"ka_GE";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-09 06:06:41";s:12:"english_name";s:8:"Georgian";s:11:"native_name";s:21:"ქართული";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/ka_GE.zip";s:3:"iso";a:2:{i:1;s:2:"ka";i:2;s:3:"kat";}s:7:"strings";a:1:{s:8:"continue";s:30:"გაგრძელება";}}s:3:"kab";a:8:{s:8:"language";s:3:"kab";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-08-22 15:33:00";s:12:"english_name";s:6:"Kabyle";s:11:"native_name";s:9:"Taqbaylit";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.8.2/kab.zip";s:3:"iso";a:2:{i:2;s:3:"kab";i:3;s:3:"kab";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuer";}}s:2:"km";a:8:{s:8:"language";s:2:"km";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-12-07 02:07:59";s:12:"english_name";s:5:"Khmer";s:11:"native_name";s:27:"ភាសាខ្មែរ";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/km.zip";s:3:"iso";a:2:{i:1;s:2:"km";i:2;s:3:"khm";}s:7:"strings";a:1:{s:8:"continue";s:12:"បន្ត";}}s:5:"ko_KR";a:8:{s:8:"language";s:5:"ko_KR";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-07-28 10:48:16";s:12:"english_name";s:6:"Korean";s:11:"native_name";s:9:"한국어";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/ko_KR.zip";s:3:"iso";a:2:{i:1;s:2:"ko";i:2;s:3:"kor";}s:7:"strings";a:1:{s:8:"continue";s:6:"계속";}}s:3:"ckb";a:8:{s:8:"language";s:3:"ckb";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-26 15:48:25";s:12:"english_name";s:16:"Kurdish (Sorani)";s:11:"native_name";s:13:"كوردی‎";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/ckb.zip";s:3:"iso";a:2:{i:1;s:2:"ku";i:3;s:3:"ckb";}s:7:"strings";a:1:{s:8:"continue";s:30:"به‌رده‌وام به‌";}}s:2:"lo";a:8:{s:8:"language";s:2:"lo";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-12 09:59:23";s:12:"english_name";s:3:"Lao";s:11:"native_name";s:21:"ພາສາລາວ";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip";s:3:"iso";a:2:{i:1;s:2:"lo";i:2;s:3:"lao";}s:7:"strings";a:1:{s:8:"continue";s:9:"ຕໍ່";}}s:5:"lt_LT";a:8:{s:8:"language";s:5:"lt_LT";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-07-28 11:02:15";s:12:"english_name";s:10:"Lithuanian";s:11:"native_name";s:15:"Lietuvių kalba";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/lt_LT.zip";s:3:"iso";a:2:{i:1;s:2:"lt";i:2;s:3:"lit";}s:7:"strings";a:1:{s:8:"continue";s:6:"Tęsti";}}s:2:"lv";a:8:{s:8:"language";s:2:"lv";s:7:"version";s:5:"4.7.6";s:7:"updated";s:19:"2017-03-17 20:40:40";s:12:"english_name";s:7:"Latvian";s:11:"native_name";s:16:"Latviešu valoda";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.6/lv.zip";s:3:"iso";a:2:{i:1;s:2:"lv";i:2;s:3:"lav";}s:7:"strings";a:1:{s:8:"continue";s:9:"Turpināt";}}s:5:"mk_MK";a:8:{s:8:"language";s:5:"mk_MK";s:7:"version";s:5:"4.7.6";s:7:"updated";s:19:"2017-01-26 15:54:41";s:12:"english_name";s:10:"Macedonian";s:11:"native_name";s:31:"Македонски јазик";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.6/mk_MK.zip";s:3:"iso";a:2:{i:1;s:2:"mk";i:2;s:3:"mkd";}s:7:"strings";a:1:{s:8:"continue";s:16:"Продолжи";}}s:5:"ml_IN";a:8:{s:8:"language";s:5:"ml_IN";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-27 03:43:32";s:12:"english_name";s:9:"Malayalam";s:11:"native_name";s:18:"മലയാളം";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/ml_IN.zip";s:3:"iso";a:2:{i:1;s:2:"ml";i:2;s:3:"mal";}s:7:"strings";a:1:{s:8:"continue";s:18:"തുടരുക";}}s:2:"mn";a:8:{s:8:"language";s:2:"mn";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-12 07:29:35";s:12:"english_name";s:9:"Mongolian";s:11:"native_name";s:12:"Монгол";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/mn.zip";s:3:"iso";a:2:{i:1;s:2:"mn";i:2;s:3:"mon";}s:7:"strings";a:1:{s:8:"continue";s:24:"Үргэлжлүүлэх";}}s:2:"mr";a:8:{s:8:"language";s:2:"mr";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-09-30 06:25:41";s:12:"english_name";s:7:"Marathi";s:11:"native_name";s:15:"मराठी";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.8.2/mr.zip";s:3:"iso";a:2:{i:1;s:2:"mr";i:2;s:3:"mar";}s:7:"strings";a:1:{s:8:"continue";s:25:"सुरु ठेवा";}}s:5:"ms_MY";a:8:{s:8:"language";s:5:"ms_MY";s:7:"version";s:5:"4.7.6";s:7:"updated";s:19:"2017-03-05 09:45:10";s:12:"english_name";s:5:"Malay";s:11:"native_name";s:13:"Bahasa Melayu";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.6/ms_MY.zip";s:3:"iso";a:2:{i:1;s:2:"ms";i:2;s:3:"msa";}s:7:"strings";a:1:{s:8:"continue";s:8:"Teruskan";}}s:5:"my_MM";a:8:{s:8:"language";s:5:"my_MM";s:7:"version";s:6:"4.1.19";s:7:"updated";s:19:"2015-03-26 15:57:42";s:12:"english_name";s:17:"Myanmar (Burmese)";s:11:"native_name";s:15:"ဗမာစာ";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/4.1.19/my_MM.zip";s:3:"iso";a:2:{i:1;s:2:"my";i:2;s:3:"mya";}s:7:"strings";a:1:{s:8:"continue";s:54:"ဆက်လက်လုပ်ေဆာင်ပါ။";}}s:5:"nb_NO";a:8:{s:8:"language";s:5:"nb_NO";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-08-02 21:02:39";s:12:"english_name";s:19:"Norwegian (Bokmål)";s:11:"native_name";s:13:"Norsk bokmål";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/nb_NO.zip";s:3:"iso";a:2:{i:1;s:2:"nb";i:2;s:3:"nob";}s:7:"strings";a:1:{s:8:"continue";s:8:"Fortsett";}}s:5:"ne_NP";a:8:{s:8:"language";s:5:"ne_NP";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-07-31 08:47:10";s:12:"english_name";s:6:"Nepali";s:11:"native_name";s:18:"नेपाली";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/ne_NP.zip";s:3:"iso";a:2:{i:1;s:2:"ne";i:2;s:3:"nep";}s:7:"strings";a:1:{s:8:"continue";s:31:"जारीराख्नु ";}}s:12:"nl_NL_formal";a:8:{s:8:"language";s:12:"nl_NL_formal";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-08-30 07:58:32";s:12:"english_name";s:14:"Dutch (Formal)";s:11:"native_name";s:20:"Nederlands (Formeel)";s:7:"package";s:71:"https://downloads.wordpress.org/translation/core/4.8.2/nl_NL_formal.zip";s:3:"iso";a:2:{i:1;s:2:"nl";i:2;s:3:"nld";}s:7:"strings";a:1:{s:8:"continue";s:8:"Doorgaan";}}s:5:"nl_NL";a:8:{s:8:"language";s:5:"nl_NL";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-13 12:25:56";s:12:"english_name";s:5:"Dutch";s:11:"native_name";s:10:"Nederlands";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/nl_NL.zip";s:3:"iso";a:2:{i:1;s:2:"nl";i:2;s:3:"nld";}s:7:"strings";a:1:{s:8:"continue";s:8:"Doorgaan";}}s:5:"nl_BE";a:8:{s:8:"language";s:5:"nl_BE";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-02 15:25:12";s:12:"english_name";s:15:"Dutch (Belgium)";s:11:"native_name";s:20:"Nederlands (België)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/nl_BE.zip";s:3:"iso";a:2:{i:1;s:2:"nl";i:2;s:3:"nld";}s:7:"strings";a:1:{s:8:"continue";s:8:"Doorgaan";}}s:5:"nn_NO";a:8:{s:8:"language";s:5:"nn_NO";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-09-25 10:02:16";s:12:"english_name";s:19:"Norwegian (Nynorsk)";s:11:"native_name";s:13:"Norsk nynorsk";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/nn_NO.zip";s:3:"iso";a:2:{i:1;s:2:"nn";i:2;s:3:"nno";}s:7:"strings";a:1:{s:8:"continue";s:9:"Hald fram";}}s:3:"oci";a:8:{s:8:"language";s:3:"oci";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-08-25 10:03:08";s:12:"english_name";s:7:"Occitan";s:11:"native_name";s:7:"Occitan";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.8.2/oci.zip";s:3:"iso";a:2:{i:1;s:2:"oc";i:2;s:3:"oci";}s:7:"strings";a:1:{s:8:"continue";s:9:"Contunhar";}}s:5:"pa_IN";a:8:{s:8:"language";s:5:"pa_IN";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-16 05:19:43";s:12:"english_name";s:7:"Punjabi";s:11:"native_name";s:18:"ਪੰਜਾਬੀ";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip";s:3:"iso";a:2:{i:1;s:2:"pa";i:2;s:3:"pan";}s:7:"strings";a:1:{s:8:"continue";s:25:"ਜਾਰੀ ਰੱਖੋ";}}s:5:"pl_PL";a:8:{s:8:"language";s:5:"pl_PL";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-09-20 08:02:58";s:12:"english_name";s:6:"Polish";s:11:"native_name";s:6:"Polski";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/pl_PL.zip";s:3:"iso";a:2:{i:1;s:2:"pl";i:2;s:3:"pol";}s:7:"strings";a:1:{s:8:"continue";s:9:"Kontynuuj";}}s:2:"ps";a:8:{s:8:"language";s:2:"ps";s:7:"version";s:6:"4.1.19";s:7:"updated";s:19:"2015-03-29 22:19:48";s:12:"english_name";s:6:"Pashto";s:11:"native_name";s:8:"پښتو";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.1.19/ps.zip";s:3:"iso";a:2:{i:1;s:2:"ps";i:2;s:3:"pus";}s:7:"strings";a:1:{s:8:"continue";s:8:"دوام";}}s:10:"pt_PT_ao90";a:8:{s:8:"language";s:10:"pt_PT_ao90";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-09-29 08:57:23";s:12:"english_name";s:27:"Portuguese (Portugal, AO90)";s:11:"native_name";s:17:"Português (AO90)";s:7:"package";s:69:"https://downloads.wordpress.org/translation/core/4.8.2/pt_PT_ao90.zip";s:3:"iso";a:1:{i:1;s:2:"pt";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"pt_PT";a:8:{s:8:"language";s:5:"pt_PT";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-13 11:55:41";s:12:"english_name";s:21:"Portuguese (Portugal)";s:11:"native_name";s:10:"Português";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/pt_PT.zip";s:3:"iso";a:1:{i:1;s:2:"pt";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"pt_BR";a:8:{s:8:"language";s:5:"pt_BR";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-09-30 17:15:54";s:12:"english_name";s:19:"Portuguese (Brazil)";s:11:"native_name";s:20:"Português do Brasil";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/pt_BR.zip";s:3:"iso";a:2:{i:1;s:2:"pt";i:2;s:3:"por";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:3:"rhg";a:8:{s:8:"language";s:3:"rhg";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-03-16 13:03:18";s:12:"english_name";s:8:"Rohingya";s:11:"native_name";s:8:"Ruáinga";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip";s:3:"iso";a:1:{i:3;s:3:"rhg";}s:7:"strings";a:1:{s:8:"continue";s:0:"";}}s:5:"ro_RO";a:8:{s:8:"language";s:5:"ro_RO";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-17 12:16:26";s:12:"english_name";s:8:"Romanian";s:11:"native_name";s:8:"Română";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/ro_RO.zip";s:3:"iso";a:2:{i:1;s:2:"ro";i:2;s:3:"ron";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuă";}}s:5:"ru_RU";a:8:{s:8:"language";s:5:"ru_RU";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-09-23 11:17:01";s:12:"english_name";s:7:"Russian";s:11:"native_name";s:14:"Русский";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/ru_RU.zip";s:3:"iso";a:2:{i:1;s:2:"ru";i:2;s:3:"rus";}s:7:"strings";a:1:{s:8:"continue";s:20:"Продолжить";}}s:3:"sah";a:8:{s:8:"language";s:3:"sah";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-21 02:06:41";s:12:"english_name";s:5:"Sakha";s:11:"native_name";s:14:"Сахалыы";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip";s:3:"iso";a:2:{i:2;s:3:"sah";i:3;s:3:"sah";}s:7:"strings";a:1:{s:8:"continue";s:12:"Салҕаа";}}s:5:"si_LK";a:8:{s:8:"language";s:5:"si_LK";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-12 06:00:52";s:12:"english_name";s:7:"Sinhala";s:11:"native_name";s:15:"සිංහල";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip";s:3:"iso";a:2:{i:1;s:2:"si";i:2;s:3:"sin";}s:7:"strings";a:1:{s:8:"continue";s:44:"දිගටම කරගෙන යන්න";}}s:5:"sk_SK";a:8:{s:8:"language";s:5:"sk_SK";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-21 12:10:10";s:12:"english_name";s:6:"Slovak";s:11:"native_name";s:11:"Slovenčina";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/sk_SK.zip";s:3:"iso";a:2:{i:1;s:2:"sk";i:2;s:3:"slk";}s:7:"strings";a:1:{s:8:"continue";s:12:"Pokračovať";}}s:5:"sl_SI";a:8:{s:8:"language";s:5:"sl_SI";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-09-12 12:51:50";s:12:"english_name";s:9:"Slovenian";s:11:"native_name";s:13:"Slovenščina";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/sl_SI.zip";s:3:"iso";a:2:{i:1;s:2:"sl";i:2;s:3:"slv";}s:7:"strings";a:1:{s:8:"continue";s:10:"Nadaljujte";}}s:2:"sq";a:8:{s:8:"language";s:2:"sq";s:7:"version";s:5:"4.7.6";s:7:"updated";s:19:"2017-04-24 08:35:30";s:12:"english_name";s:8:"Albanian";s:11:"native_name";s:5:"Shqip";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.6/sq.zip";s:3:"iso";a:2:{i:1;s:2:"sq";i:2;s:3:"sqi";}s:7:"strings";a:1:{s:8:"continue";s:6:"Vazhdo";}}s:5:"sr_RS";a:8:{s:8:"language";s:5:"sr_RS";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-07-28 12:07:44";s:12:"english_name";s:7:"Serbian";s:11:"native_name";s:23:"Српски језик";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/sr_RS.zip";s:3:"iso";a:2:{i:1;s:2:"sr";i:2;s:3:"srp";}s:7:"strings";a:1:{s:8:"continue";s:14:"Настави";}}s:5:"sv_SE";a:8:{s:8:"language";s:5:"sv_SE";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-08 16:15:48";s:12:"english_name";s:7:"Swedish";s:11:"native_name";s:7:"Svenska";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/sv_SE.zip";s:3:"iso";a:2:{i:1;s:2:"sv";i:2;s:3:"swe";}s:7:"strings";a:1:{s:8:"continue";s:9:"Fortsätt";}}s:3:"szl";a:8:{s:8:"language";s:3:"szl";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-09-24 19:58:14";s:12:"english_name";s:8:"Silesian";s:11:"native_name";s:17:"Ślōnskŏ gŏdka";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip";s:3:"iso";a:1:{i:3;s:3:"szl";}s:7:"strings";a:1:{s:8:"continue";s:13:"Kōntynuować";}}s:5:"ta_IN";a:8:{s:8:"language";s:5:"ta_IN";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-27 03:22:47";s:12:"english_name";s:5:"Tamil";s:11:"native_name";s:15:"தமிழ்";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip";s:3:"iso";a:2:{i:1;s:2:"ta";i:2;s:3:"tam";}s:7:"strings";a:1:{s:8:"continue";s:24:"தொடரவும்";}}s:2:"te";a:8:{s:8:"language";s:2:"te";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-26 15:47:39";s:12:"english_name";s:6:"Telugu";s:11:"native_name";s:18:"తెలుగు";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/te.zip";s:3:"iso";a:2:{i:1;s:2:"te";i:2;s:3:"tel";}s:7:"strings";a:1:{s:8:"continue";s:30:"కొనసాగించు";}}s:2:"th";a:8:{s:8:"language";s:2:"th";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-07 02:08:56";s:12:"english_name";s:4:"Thai";s:11:"native_name";s:9:"ไทย";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.8.2/th.zip";s:3:"iso";a:2:{i:1;s:2:"th";i:2;s:3:"tha";}s:7:"strings";a:1:{s:8:"continue";s:15:"ต่อไป";}}s:2:"tl";a:8:{s:8:"language";s:2:"tl";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-12-30 02:38:08";s:12:"english_name";s:7:"Tagalog";s:11:"native_name";s:7:"Tagalog";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/tl.zip";s:3:"iso";a:2:{i:1;s:2:"tl";i:2;s:3:"tgl";}s:7:"strings";a:1:{s:8:"continue";s:10:"Magpatuloy";}}s:5:"tr_TR";a:8:{s:8:"language";s:5:"tr_TR";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-12 12:20:32";s:12:"english_name";s:7:"Turkish";s:11:"native_name";s:8:"Türkçe";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/tr_TR.zip";s:3:"iso";a:2:{i:1;s:2:"tr";i:2;s:3:"tur";}s:7:"strings";a:1:{s:8:"continue";s:5:"Devam";}}s:5:"tt_RU";a:8:{s:8:"language";s:5:"tt_RU";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-20 20:20:50";s:12:"english_name";s:5:"Tatar";s:11:"native_name";s:19:"Татар теле";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip";s:3:"iso";a:2:{i:1;s:2:"tt";i:2;s:3:"tat";}s:7:"strings";a:1:{s:8:"continue";s:17:"дәвам итү";}}s:3:"tah";a:8:{s:8:"language";s:3:"tah";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-03-06 18:39:39";s:12:"english_name";s:8:"Tahitian";s:11:"native_name";s:10:"Reo Tahiti";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip";s:3:"iso";a:3:{i:1;s:2:"ty";i:2;s:3:"tah";i:3;s:3:"tah";}s:7:"strings";a:1:{s:8:"continue";s:0:"";}}s:5:"ug_CN";a:8:{s:8:"language";s:5:"ug_CN";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-12-05 09:23:39";s:12:"english_name";s:6:"Uighur";s:11:"native_name";s:9:"Uyƣurqə";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/ug_CN.zip";s:3:"iso";a:2:{i:1;s:2:"ug";i:2;s:3:"uig";}s:7:"strings";a:1:{s:8:"continue";s:26:"داۋاملاشتۇرۇش";}}s:2:"uk";a:8:{s:8:"language";s:2:"uk";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-09-19 19:56:39";s:12:"english_name";s:9:"Ukrainian";s:11:"native_name";s:20:"Українська";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.8.2/uk.zip";s:3:"iso";a:2:{i:1;s:2:"uk";i:2;s:3:"ukr";}s:7:"strings";a:1:{s:8:"continue";s:20:"Продовжити";}}s:2:"ur";a:8:{s:8:"language";s:2:"ur";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-03 08:22:57";s:12:"english_name";s:4:"Urdu";s:11:"native_name";s:8:"اردو";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.8.2/ur.zip";s:3:"iso";a:2:{i:1;s:2:"ur";i:2;s:3:"urd";}s:7:"strings";a:1:{s:8:"continue";s:19:"جاری رکھیں";}}s:5:"uz_UZ";a:8:{s:8:"language";s:5:"uz_UZ";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-15 05:40:58";s:12:"english_name";s:5:"Uzbek";s:11:"native_name";s:11:"O‘zbekcha";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/uz_UZ.zip";s:3:"iso";a:2:{i:1;s:2:"uz";i:2;s:3:"uzb";}s:7:"strings";a:1:{s:8:"continue";s:20:"Продолжить";}}s:2:"vi";a:8:{s:8:"language";s:2:"vi";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-10-03 09:08:47";s:12:"english_name";s:10:"Vietnamese";s:11:"native_name";s:14:"Tiếng Việt";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.8.2/vi.zip";s:3:"iso";a:2:{i:1;s:2:"vi";i:2;s:3:"vie";}s:7:"strings";a:1:{s:8:"continue";s:12:"Tiếp tục";}}s:5:"zh_HK";a:8:{s:8:"language";s:5:"zh_HK";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-09-27 14:50:31";s:12:"english_name";s:19:"Chinese (Hong Kong)";s:11:"native_name";s:16:"香港中文版	";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/zh_HK.zip";s:3:"iso";a:2:{i:1;s:2:"zh";i:2;s:3:"zho";}s:7:"strings";a:1:{s:8:"continue";s:6:"繼續";}}s:5:"zh_TW";a:8:{s:8:"language";s:5:"zh_TW";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-09-12 11:35:05";s:12:"english_name";s:16:"Chinese (Taiwan)";s:11:"native_name";s:12:"繁體中文";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/zh_TW.zip";s:3:"iso";a:2:{i:1;s:2:"zh";i:2;s:3:"zho";}s:7:"strings";a:1:{s:8:"continue";s:6:"繼續";}}s:5:"zh_CN";a:8:{s:8:"language";s:5:"zh_CN";s:7:"version";s:5:"4.8.2";s:7:"updated";s:19:"2017-08-04 07:53:05";s:12:"english_name";s:15:"Chinese (China)";s:11:"native_name";s:12:"简体中文";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.2/zh_CN.zip";s:3:"iso";a:2:{i:1;s:2:"zh";i:2;s:3:"zho";}s:7:"strings";a:1:{s:8:"continue";s:6:"继续";}}}', 'no'),
 (407, '_transient_timeout_ctf__MeteoprognozaPL5', '1509005237', 'no'),
 (408, '_transient_ctf__MeteoprognozaPL5', '[{"user":{"name":"meteoprognoza.pl","screen_name":"MeteoprognozaPL","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/893016305426612225\\/bbYcRjum_normal.jpg","utc_offset":7200},"text":"W Tatrach bez zmian \\ud83d\\ude09 ","id_str":"923435211798581248","created_at":"Thu Oct 26 06:24:45 +0000 2017","retweet_count":0,"favorite_count":5,"quoted_status":{"user":{"name":"Andrzej Bargiel","screen_name":"JedrekBargiel","verified":false},"text":"Pozdrowienia z TATR \\u2744\\ufe0f ","id_str":"923310411314814976","extended_entities":{"media":[{"type":"photo"}]}}},{"user":{"name":"meteoprognoza.pl","screen_name":"MeteoprognozaPL","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/893016305426612225\\/bbYcRjum_normal.jpg","utc_offset":7200},"text":"RT @wladyslawowopl: @Corintianin @MeteoprognozaPL #Dzie\\u0144Dobry! We #W\\u0142adys\\u0142awowo r\\u00f3wnie pi\\u0119knie\\ud83d\\ude03 Mi\\u0142ego! #niebo #kolory #nadmorzem #Pomorze\\u2026","id_str":"923429674373603328","created_at":"Thu Oct 26 06:02:45 +0000 2017","retweet_count":1,"favorite_count":0,"retweeted_status":{"user":{"name":"Gmina W\\u0142adys\\u0142awowo","screen_name":"wladyslawowopl","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/881822034292035584\\/Hn2mG2qL_normal.jpg","utc_offset":-25200},"text":"@Corintianin @MeteoprognozaPL #Dzie\\u0144Dobry! We #W\\u0142adys\\u0142awowo r\\u00f3wnie pi\\u0119knie\\ud83d\\ude03 Mi\\u0142ego! #niebo #kolory #nadmorzem #Pomorze #wstajedzien #poranek ","id_str":"923425346241859584","created_at":"Thu Oct 26 05:45:33 +0000 2017","retweet_count":1,"favorite_count":7,"extended_entities":{"media":[{"type":"photo"}]}}},{"user":{"name":"meteoprognoza.pl","screen_name":"MeteoprognozaPL","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/893016305426612225\\/bbYcRjum_normal.jpg","utc_offset":7200},"text":"Przy czwartku taki film to regeneracja, kt\\u00f3\\u017c by nie skorzysta\\u0142?\\nDla nauczycieli fizyki pomys\\u0142 na lekcj\\u0119 \\ud83d\\ude09 ","id_str":"923421261518303232","created_at":"Thu Oct 26 05:29:19 +0000 2017","retweet_count":4,"favorite_count":7,"quoted_status":{"user":{"name":"World and Science","screen_name":"WorldAndScience","verified":false},"text":"Demonstration of the Physics of Inertia ","id_str":"923338139757932544","extended_entities":{"media":[{"type":"video"}]}}},{"user":{"name":"meteoprognoza.pl","screen_name":"MeteoprognozaPL","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/893016305426612225\\/bbYcRjum_normal.jpg","utc_offset":7200},"text":"RT @Karkonoski_PN: \\u015anie\\u017cka we mgle. Mg\\u0142a na najwy\\u017cszym szczycie Sudet\\u00f3w go\\u015bci najcz\\u0119\\u015bciej w Polsce. Cho\\u0107 na chwil\\u0119 pojawia si\\u0119 tam \\u015brednio\\u2026","id_str":"923418735561633792","created_at":"Thu Oct 26 05:19:17 +0000 2017","retweet_count":9,"favorite_count":0,"retweeted_status":{"user":{"name":"KPN","screen_name":"Karkonoski_PN","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/606544783729819650\\/I3ad1OXf_normal.jpg","utc_offset":-25200},"text":"\\u015anie\\u017cka we mgle. Mg\\u0142a na najwy\\u017cszym szczycie Sudet\\u00f3w go\\u015bci najcz\\u0119\\u015bciej w Polsce. Cho\\u0107 na chwil\\u0119 pojawia si\\u0119 tam \\u015brednio przez 306 dni w roku. ","id_str":"923391738236022786","created_at":"Thu Oct 26 03:32:00 +0000 2017","retweet_count":9,"favorite_count":33,"extended_entities":{"media":[{"type":"photo"}]}}},{"user":{"name":"meteoprognoza.pl","screen_name":"MeteoprognozaPL","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/893016305426612225\\/bbYcRjum_normal.jpg","utc_offset":7200},"text":"RT @eswinoujscie: Dobranoc https:\\/\\/t.co\\/rvvYvv3FaP ","id_str":"923306280151896064","created_at":"Wed Oct 25 21:52:26 +0000 2017","retweet_count":1,"favorite_count":0,"retweeted_status":{"user":{"name":"eswinoujscie.pl","screen_name":"eswinoujscie","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/631536425603887104\\/pDoz0lTY_normal.jpg","utc_offset":-7200},"text":"Dobranoc https:\\/\\/t.co\\/rvvYvv3FaP ","id_str":"923263682708148229","created_at":"Wed Oct 25 19:03:10 +0000 2017","retweet_count":1,"favorite_count":13,"extended_entities":{"media":[{"type":"photo"}]}},"extended_entities":{"media":[{"type":"photo"}]}}]', 'no'),
 (413, '_site_transient_update_core', 'O:8:"stdClass":4:{s:7:"updates";a:1:{i:0;O:8:"stdClass":10:{s:8:"response";s:6:"latest";s:8:"download";s:65:"https://downloads.wordpress.org/release/pl_PL/wordpress-4.8.2.zip";s:6:"locale";s:5:"pl_PL";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:65:"https://downloads.wordpress.org/release/pl_PL/wordpress-4.8.2.zip";s:10:"no_content";b:0;s:11:"new_bundled";b:0;s:7:"partial";b:0;s:8:"rollback";b:0;}s:7:"current";s:5:"4.8.2";s:7:"version";s:5:"4.8.2";s:11:"php_version";s:5:"5.2.4";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"4.7";s:15:"partial_version";s:0:"";}}s:12:"last_checked";i:1509004233;s:15:"version_checked";s:5:"4.8.2";s:12:"translations";a:0:{}}', 'no'),
 (414, '_site_transient_update_themes', 'O:8:"stdClass":4:{s:12:"last_checked";i:1509004237;s:7:"checked";a:4:{s:10:"mesocolumn";s:7:"1.6.5.1";s:13:"twentyfifteen";s:3:"1.8";s:15:"twentyseventeen";s:3:"1.3";s:13:"twentysixteen";s:3:"1.3";}s:8:"response";a:0:{}s:12:"translations";a:0:{}}', 'no'),
 (427, '_transient_timeout_ctf__923306280151896064MeteoprognozaPL5', '1509007781', 'no'),
 (428, '_transient_ctf__923306280151896064MeteoprognozaPL5', '[{"user":{"name":"meteoprognoza.pl","screen_name":"MeteoprognozaPL","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/893016305426612225\\/bbYcRjum_normal.jpg","utc_offset":7200},"text":"RT @eswinoujscie: Dobranoc https:\\/\\/t.co\\/rvvYvv3FaP ","id_str":"923306280151896064","created_at":"Wed Oct 25 21:52:26 +0000 2017","retweet_count":1,"favorite_count":0,"retweeted_status":{"user":{"name":"eswinoujscie.pl","screen_name":"eswinoujscie","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/631536425603887104\\/pDoz0lTY_normal.jpg","utc_offset":-7200},"text":"Dobranoc https:\\/\\/t.co\\/rvvYvv3FaP ","id_str":"923263682708148229","created_at":"Wed Oct 25 19:03:10 +0000 2017","retweet_count":1,"favorite_count":13,"extended_entities":{"media":[{"type":"photo"}]}},"extended_entities":{"media":[{"type":"photo"}]}},{"user":{"name":"meteoprognoza.pl","screen_name":"MeteoprognozaPL","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/893016305426612225\\/bbYcRjum_normal.jpg","utc_offset":7200},"text":"Zima dotar\\u0142a i w #Bieszczady.\\nPierwszy tej jesieni \\u015bnieg pod szczytem \\u0141opiennika... \\nFot. Marcin Scelina \\/ #Nadle\\u015bnictwo Baligr\\u00f3d ","id_str":"923297725986172928","created_at":"Wed Oct 25 21:18:26 +0000 2017","retweet_count":9,"favorite_count":31,"extended_entities":{"media":[{"type":"photo"}]}},{"user":{"name":"meteoprognoza.pl","screen_name":"MeteoprognozaPL","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/893016305426612225\\/bbYcRjum_normal.jpg","utc_offset":7200},"text":"Jeszcze inne dzisiejsze uj\\u0119cie okolic Morskiego Oka.\\nfot. https:\\/\\/t.co\\/PWzEScIBW9 ","id_str":"923292744545591297","created_at":"Wed Oct 25 20:58:38 +0000 2017","retweet_count":15,"favorite_count":77,"extended_entities":{"media":[{"type":"photo"}]}},{"user":{"name":"meteoprognoza.pl","screen_name":"MeteoprognozaPL","verified":false,"profile_image_url_https":"https:\\/\\/pbs.twimg.com\\/profile_images\\/893016305426612225\\/bbYcRjum_normal.jpg","utc_offset":7200},"text":"Dzisiejszy widok z Zawratu.\\n#Tatry\\nFot. Bartek Konieczny\\/Fb Aktualne warunki w g\\u00f3rach ","id_str":"923286921954160640","created_at":"Wed Oct 25 20:35:30 +0000 2017","retweet_count":7,"favorite_count":42,"extended_entities":{"media":[{"type":"photo"}]}}]', 'no'),
 (430, '_site_transient_update_plugins', 'O:8:"stdClass":4:{s:12:"last_checked";i:1509004233;s:8:"response";a:0:{}s:12:"translations";a:0:{}s:9:"no_update";a:6:{s:19:"akismet/akismet.php";O:8:"stdClass":9:{s:2:"id";s:21:"w.org/plugins/akismet";s:4:"slug";s:7:"akismet";s:6:"plugin";s:19:"akismet/akismet.php";s:11:"new_version";s:3:"4.0";s:3:"url";s:38:"https://wordpress.org/plugins/akismet/";s:7:"package";s:54:"https://downloads.wordpress.org/plugin/akismet.4.0.zip";s:5:"icons";a:3:{s:2:"1x";s:59:"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272";s:2:"2x";s:59:"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272";s:7:"default";s:59:"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272";}s:7:"banners";a:2:{s:2:"1x";s:61:"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904";s:7:"default";s:61:"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904";}s:11:"banners_rtl";a:0:{}}s:23:"backup-wd/backup-wd.php";O:8:"stdClass":9:{s:2:"id";s:23:"w.org/plugins/backup-wd";s:4:"slug";s:9:"backup-wd";s:6:"plugin";s:23:"backup-wd/backup-wd.php";s:11:"new_version";s:5:"1.0.7";s:3:"url";s:40:"https://wordpress.org/plugins/backup-wd/";s:7:"package";s:58:"https://downloads.wordpress.org/plugin/backup-wd.1.0.7.zip";s:5:"icons";a:2:{s:2:"1x";s:62:"https://ps.w.org/backup-wd/assets/icon-128x128.png?rev=1722460";s:7:"default";s:62:"https://ps.w.org/backup-wd/assets/icon-128x128.png?rev=1722460";}s:7:"banners";a:2:{s:2:"1x";s:64:"https://ps.w.org/backup-wd/assets/banner-772x250.png?rev=1722460";s:7:"default";s:64:"https://ps.w.org/backup-wd/assets/banner-772x250.png?rev=1722460";}s:11:"banners_rtl";a:0:{}}s:44:"custom-twitter-feeds/custom-twitter-feed.php";O:8:"stdClass":9:{s:2:"id";s:34:"w.org/plugins/custom-twitter-feeds";s:4:"slug";s:20:"custom-twitter-feeds";s:6:"plugin";s:44:"custom-twitter-feeds/custom-twitter-feed.php";s:11:"new_version";s:5:"1.2.7";s:3:"url";s:51:"https://wordpress.org/plugins/custom-twitter-feeds/";s:7:"package";s:69:"https://downloads.wordpress.org/plugin/custom-twitter-feeds.1.2.7.zip";s:5:"icons";a:2:{s:2:"1x";s:73:"https://ps.w.org/custom-twitter-feeds/assets/icon-128x128.png?rev=1414207";s:7:"default";s:73:"https://ps.w.org/custom-twitter-feeds/assets/icon-128x128.png?rev=1414207";}s:7:"banners";a:2:{s:2:"1x";s:75:"https://ps.w.org/custom-twitter-feeds/assets/banner-772x250.png?rev=1624166";s:7:"default";s:75:"https://ps.w.org/custom-twitter-feeds/assets/banner-772x250.png?rev=1624166";}s:11:"banners_rtl";a:0:{}}s:37:"wd-facebook-feed/facebook-feed-wd.php";O:8:"stdClass":9:{s:2:"id";s:30:"w.org/plugins/wd-facebook-feed";s:4:"slug";s:16:"wd-facebook-feed";s:6:"plugin";s:37:"wd-facebook-feed/facebook-feed-wd.php";s:11:"new_version";s:6:"1.0.28";s:3:"url";s:47:"https://wordpress.org/plugins/wd-facebook-feed/";s:7:"package";s:66:"https://downloads.wordpress.org/plugin/wd-facebook-feed.1.0.28.zip";s:5:"icons";a:2:{s:2:"1x";s:69:"https://ps.w.org/wd-facebook-feed/assets/icon-128x128.png?rev=1523981";s:7:"default";s:69:"https://ps.w.org/wd-facebook-feed/assets/icon-128x128.png?rev=1523981";}s:7:"banners";a:2:{s:2:"1x";s:71:"https://ps.w.org/wd-facebook-feed/assets/banner-772x250.jpg?rev=1523981";s:7:"default";s:71:"https://ps.w.org/wd-facebook-feed/assets/banner-772x250.jpg?rev=1523981";}s:11:"banners_rtl";a:0:{}}s:9:"hello.php";O:8:"stdClass":9:{s:2:"id";s:25:"w.org/plugins/hello-dolly";s:4:"slug";s:11:"hello-dolly";s:6:"plugin";s:9:"hello.php";s:11:"new_version";s:3:"1.6";s:3:"url";s:42:"https://wordpress.org/plugins/hello-dolly/";s:7:"package";s:58:"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip";s:5:"icons";a:3:{s:2:"1x";s:63:"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=969907";s:2:"2x";s:63:"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=969907";s:7:"default";s:63:"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=969907";}s:7:"banners";a:2:{s:2:"1x";s:65:"https://ps.w.org/hello-dolly/assets/banner-772x250.png?rev=478342";s:7:"default";s:65:"https://ps.w.org/hello-dolly/assets/banner-772x250.png?rev=478342";}s:11:"banners_rtl";a:0:{}}s:41:"wordpress-importer/wordpress-importer.php";O:8:"stdClass":9:{s:2:"id";s:32:"w.org/plugins/wordpress-importer";s:4:"slug";s:18:"wordpress-importer";s:6:"plugin";s:41:"wordpress-importer/wordpress-importer.php";s:11:"new_version";s:5:"0.6.3";s:3:"url";s:49:"https://wordpress.org/plugins/wordpress-importer/";s:7:"package";s:67:"https://downloads.wordpress.org/plugin/wordpress-importer.0.6.3.zip";s:5:"icons";a:0:{}s:7:"banners";a:2:{s:2:"1x";s:72:"https://ps.w.org/wordpress-importer/assets/banner-772x250.png?rev=547654";s:7:"default";s:72:"https://ps.w.org/wordpress-importer/assets/banner-772x250.png?rev=547654";}s:11:"banners_rtl";a:0:{}}}}', 'no'),
 (431, '_site_transient_timeout_theme_roots', '1509006034', 'no'),
 (432, '_site_transient_theme_roots', 'a:4:{s:10:"mesocolumn";s:7:"/themes";s:13:"twentyfifteen";s:7:"/themes";s:15:"twentyseventeen";s:7:"/themes";s:13:"twentysixteen";s:7:"/themes";}', 'no'),
 (433, 'buwd_subscribe_done', '1', 'yes'),
 (434, '_site_transient_jobs_per_page', '20', 'no'),
 (437, 'buwd_step_done', 'dest_sync_folder', 'no'),
 (439, 'buwd-dest-folder-2', 'a:1:{i:0;a:8:{s:4:"file";s:39:"backupwd_4a37ce_2017-10-26_09-51-04.zip";s:6:"folder";s:42:"wp-content/uploads/backup-wd-files-4a37ce/";s:11:"folder_path";s:68:"/autoinstalator/wordpress/wp-content/uploads/backup-wd-files-4a37ce/";s:4:"time";i:1509004309;s:4:"size";i:32871287;s:3:"jid";i:2;s:4:"dest";s:6:"folder";s:7:"logfile";s:44:"backupwd_log_4a37ce_2017-10-26_09-51-04.html";}}', 'no'),
 (443, 'buwd-dest-folder-sync-4', 'a:8:{s:4:"file";s:12:"Synchronized";s:6:"folder";s:45:"wp-content/uploads/backup-wd-files-db-4a37ce/";s:4:"time";i:1509004346;s:4:"size";i:58799545;s:3:"jid";i:4;s:4:"dest";s:6:"folder";s:7:"logfile";s:44:"backupwd_log_4a37ce_2017-10-26_09-52-22.html";s:4:"sync";i:1;}', 'no'),
 (446, 'buwd-dest-folder-sync-3', 'a:8:{s:4:"file";s:12:"Synchronized";s:6:"folder";s:51:"wp-content/uploads/backup-wd-plugins-themes-4a37ce/";s:4:"time";i:1509004357;s:4:"size";i:13113656;s:3:"jid";i:3;s:4:"dest";s:6:"folder";s:7:"logfile";s:44:"backupwd_log_4a37ce_2017-10-26_09-52-36.html";s:4:"sync";i:1;}', 'no'),
 (447, '_site_transient_buwd_jobs_updated', 'a:1:{i:0;s:16:"Job is completed";}', 'no'),
 (448, 'buwd_progress', 'a:6:{s:8:"progress";d:20;s:12:"current_step";s:22:"Creating database file";s:3:"log";s:84:"[26-Oct-2017 09:52:45] <span class="logline">1. Attempted to backup database.</span>";s:5:"error";b:0;s:4:"stop";b:0;s:3:"end";b:0;}', 'no'),
 (449, '_site_transient_buwd_message_show', '1', 'no'),
 (450, 'buwd_job_running', '1', 'no');


DROP TABLE IF EXISTS `wp_postmeta`;
CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1872 DEFAULT CHARSET=utf8;

 
INSERT INTO `wp_postmeta` VALUES (1, 2, '_wp_page_template', 'default'),
 (53, 268, '_wp_attached_file', '2017/08/IMG_1560.jpg'),
 (54, 268, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:4000;s:6:"height";i:2664;s:4:"file";s:20:"2017/08/IMG_1560.jpg";s:5:"sizes";a:6:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"IMG_1560-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"IMG_1560-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"IMG_1560-768x511.jpg";s:5:"width";i:768;s:6:"height";i:511;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"IMG_1560-1024x682.jpg";s:5:"width";i:1024;s:6:"height";i:682;s:9:"mime-type";s:10:"image/jpeg";}s:30:"twentyseventeen-featured-image";a:4:{s:4:"file";s:22:"IMG_1560-2000x1200.jpg";s:5:"width";i:2000;s:6:"height";i:1200;s:9:"mime-type";s:10:"image/jpeg";}s:32:"twentyseventeen-thumbnail-avatar";a:4:{s:4:"file";s:20:"IMG_1560-100x100.jpg";s:5:"width";i:100;s:6:"height";i:100;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"4";s:6:"credit";s:14:"Lewandowski J.";s:6:"camera";s:23:"Canon PowerShot SX50 HS";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1440351127";s:9:"copyright";s:55:"Wszelkie prawa zastrzezone - kontakt: mark014@gazeta.pl";s:12:"focal_length";s:3:"4.3";s:3:"iso";s:2:"80";s:13:"shutter_speed";s:7:"0.00125";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
 (55, 275, '_wp_attached_file', '2017/08/jezmiko.jpg'),
 (56, 275, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:320;s:6:"height";i:240;s:4:"file";s:19:"2017/08/jezmiko.jpg";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:19:"jezmiko-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:19:"jezmiko-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:32:"twentyseventeen-thumbnail-avatar";a:4:{s:4:"file";s:19:"jezmiko-100x100.jpg";s:5:"width";i:100;s:6:"height";i:100;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"5.6";s:6:"credit";s:0:"";s:6:"camera";s:11:"COOLPIX L10";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1198941535";s:9:"copyright";s:14:"Copyright 2006";s:12:"focal_length";s:3:"6.2";s:3:"iso";s:2:"64";s:13:"shutter_speed";s:18:"0.0036656891495601";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
 (57, 285, '_wp_attached_file', '2017/08/trzciniak.jpg'),
 (58, 285, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:4000;s:6:"height";i:3000;s:4:"file";s:21:"2017/08/trzciniak.jpg";s:5:"sizes";a:6:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"trzciniak-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"trzciniak-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:21:"trzciniak-768x576.jpg";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:22:"trzciniak-1024x768.jpg";s:5:"width";i:1024;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";}s:30:"twentyseventeen-featured-image";a:4:{s:4:"file";s:23:"trzciniak-2000x1200.jpg";s:5:"width";i:2000;s:6:"height";i:1200;s:9:"mime-type";s:10:"image/jpeg";}s:32:"twentyseventeen-thumbnail-avatar";a:4:{s:4:"file";s:21:"trzciniak-100x100.jpg";s:5:"width";i:100;s:6:"height";i:100;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"6.5";s:6:"credit";s:14:"Lewandowski J.";s:6:"camera";s:23:"Canon PowerShot SX50 HS";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1399825311";s:9:"copyright";s:55:"Wszelkie prawa zastrzezone - kontakt: mark014@gazeta.pl";s:12:"focal_length";s:3:"215";s:3:"iso";s:3:"500";s:13:"shutter_speed";s:8:"0.003125";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
 (59, 293, '_wp_attached_file', '2017/08/pole.jpg'),
 (60, 293, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:290;s:6:"height";i:218;s:4:"file";s:16:"2017/08/pole.jpg";s:5:"sizes";a:2:{s:9:"thumbnail";a:4:{s:4:"file";s:16:"pole-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:32:"twentyseventeen-thumbnail-avatar";a:4:{s:4:"file";s:16:"pole-100x100.jpg";s:5:"width";i:100;s:6:"height";i:100;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"6.3";s:6:"credit";s:0:"";s:6:"camera";s:11:"COOLPIX L10";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1209841474";s:9:"copyright";s:14:"Copyright 2006";s:12:"focal_length";s:3:"7.6";s:3:"iso";s:2:"64";s:13:"shutter_speed";s:5:"0.008";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
 (63, 300, '_wp_attached_file', '2017/08/dzczarny.jpg'),
 (64, 300, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1288;s:6:"height";i:1707;s:4:"file";s:20:"2017/08/dzczarny.jpg";s:5:"sizes";a:6:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"dzczarny-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"dzczarny-226x300.jpg";s:5:"width";i:226;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:21:"dzczarny-768x1018.jpg";s:5:"width";i:768;s:6:"height";i:1018;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"dzczarny-773x1024.jpg";s:5:"width";i:773;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:30:"twentyseventeen-featured-image";a:4:{s:4:"file";s:22:"dzczarny-1288x1200.jpg";s:5:"width";i:1288;s:6:"height";i:1200;s:9:"mime-type";s:10:"image/jpeg";}s:32:"twentyseventeen-thumbnail-avatar";a:4:{s:4:"file";s:20:"dzczarny-100x100.jpg";s:5:"width";i:100;s:6:"height";i:100;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"5.6";s:6:"credit";s:0:"";s:6:"camera";s:23:"Canon PowerShot SX50 HS";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1396104395";s:9:"copyright";s:0:"";s:12:"focal_length";s:7:"164.619";s:3:"iso";s:2:"80";s:13:"shutter_speed";s:5:"0.005";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
 (65, 301, '_wp_attached_file', '2017/08/dzierlatka.jpg'),
 (66, 301, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:999;s:6:"height";i:1149;s:4:"file";s:22:"2017/08/dzierlatka.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"dzierlatka-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:22:"dzierlatka-261x300.jpg";s:5:"width";i:261;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:22:"dzierlatka-768x883.jpg";s:5:"width";i:768;s:6:"height";i:883;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:23:"dzierlatka-890x1024.jpg";s:5:"width";i:890;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:32:"twentyseventeen-thumbnail-avatar";a:4:{s:4:"file";s:22:"dzierlatka-100x100.jpg";s:5:"width";i:100;s:6:"height";i:100;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"6.5";s:6:"credit";s:0:"";s:6:"camera";s:23:"Canon PowerShot SX50 HS";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1398103315";s:9:"copyright";s:0:"";s:12:"focal_length";s:3:"215";s:3:"iso";s:2:"80";s:13:"shutter_speed";s:8:"0.003125";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
 (67, 302, '_wp_attached_file', '2017/08/czapla-siwa2.jpg'),
 (68, 302, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1142;s:6:"height";i:1667;s:4:"file";s:24:"2017/08/czapla-siwa2.jpg";s:5:"sizes";a:6:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"czapla-siwa2-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:24:"czapla-siwa2-206x300.jpg";s:5:"width";i:206;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:25:"czapla-siwa2-768x1121.jpg";s:5:"width";i:768;s:6:"height";i:1121;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:25:"czapla-siwa2-702x1024.jpg";s:5:"width";i:702;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:30:"twentyseventeen-featured-image";a:4:{s:4:"file";s:26:"czapla-siwa2-1142x1200.jpg";s:5:"width";i:1142;s:6:"height";i:1200;s:9:"mime-type";s:10:"image/jpeg";}s:32:"twentyseventeen-thumbnail-avatar";a:4:{s:4:"file";s:24:"czapla-siwa2-100x100.jpg";s:5:"width";i:100;s:6:"height";i:100;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"6.5";s:6:"credit";s:14:"Lewandowski J.";s:6:"camera";s:23:"Canon PowerShot SX50 HS";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1399823214";s:9:"copyright";s:55:"Wszelkie prawa zastrzezone - kontakt: mark014@gazeta.pl";s:12:"focal_length";s:7:"183.527";s:3:"iso";s:3:"125";s:13:"shutter_speed";s:8:"0.003125";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
 (77, 342, '_wp_attached_file', '2017/08/wypocz.jpg'),
 (78, 342, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:40;s:6:"height";i:42;s:4:"file";s:18:"2017/08/wypocz.jpg";s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
 (93, 413, '_menu_item_type', 'custom'),
 (94, 413, '_menu_item_menu_item_parent', '0'),
 (95, 413, '_menu_item_object_id', '413'),
 (96, 413, '_menu_item_object', 'custom'),
 (97, 413, '_menu_item_target', ''),
 (98, 413, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
 (99, 413, '_menu_item_xfn', ''),
 (100, 413, '_menu_item_url', 'http://serwer1761710.home.pl/autoinstalator/wordpress/'),
 (194, 622, '_wp_page_template', 'page-templates/template-sitemap.php'),
 (195, 622, 'views', '19'),
 (196, 622, '_edit_last', '1'),
 (197, 622, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (198, 85, '_edit_last', '1'),
 (199, 85, '_wp_page_template', 'default'),
 (200, 85, 'views', '141'),
 (201, 87, '_edit_last', '1'),
 (202, 87, '_wp_page_template', 'default'),
 (203, 87, 'views', '23'),
 (204, 207, '_edit_last', '1'),
 (205, 207, '_wp_page_template', 'default'),
 (206, 207, 'views', '65'),
 (207, 213, '_edit_last', '1'),
 (208, 213, '_wp_page_template', 'default'),
 (209, 213, 'views', '37'),
 (210, 215, '_edit_last', '1'),
 (211, 215, '_wp_page_template', 'default'),
 (212, 215, 'views', '29'),
 (213, 217, 'views', '17'),
 (214, 217, '_edit_last', '1'),
 (215, 217, '_wp_page_template', 'default'),
 (216, 222, '_edit_last', '1'),
 (217, 222, '_wp_page_template', 'default'),
 (218, 222, 'views', '19'),
 (219, 224, '_edit_last', '1'),
 (220, 224, '_wp_page_template', 'default'),
 (221, 224, 'views', '18'),
 (222, 226, 'views', '14'),
 (223, 226, '_edit_last', '1'),
 (224, 226, '_wp_page_template', 'default'),
 (225, 228, '_edit_last', '1'),
 (226, 228, '_wp_page_template', 'default'),
 (227, 228, 'views', '15'),
 (228, 231, '_edit_last', '1'),
 (229, 231, '_wp_page_template', 'default'),
 (230, 231, 'views', '19'),
 (263, 233, '_edit_last', '1'),
 (264, 233, '_wp_page_template', 'default'),
 (265, 233, 'views', '13'),
 (266, 235, '_edit_last', '1'),
 (267, 235, '_wp_page_template', 'default'),
 (268, 235, 'views', '16'),
 (269, 237, 'views', '20'),
 (270, 237, '_edit_last', '1'),
 (271, 237, '_wp_page_template', 'default'),
 (272, 239, '_edit_last', '1'),
 (273, 239, '_wp_page_template', 'default'),
 (274, 239, 'views', '19'),
 (275, 241, '_edit_last', '1'),
 (276, 241, '_wp_page_template', 'default'),
 (277, 241, 'views', '13'),
 (278, 245, '_edit_last', '1'),
 (279, 245, '_wp_page_template', 'default'),
 (280, 245, 'views', '11'),
 (281, 248, '_edit_last', '1'),
 (282, 248, '_wp_page_template', 'default'),
 (283, 248, 'views', '29'),
 (284, 251, '_edit_last', '1'),
 (285, 251, '_wp_page_template', 'default'),
 (286, 251, 'views', '51'),
 (287, 253, '_edit_last', '1'),
 (288, 253, '_wp_page_template', 'default'),
 (289, 253, 'views', '39'),
 (290, 255, '_edit_last', '1'),
 (291, 255, '_wp_page_template', 'default'),
 (292, 255, 'views', '16'),
 (293, 259, 'views', '15'),
 (294, 259, '_edit_last', '1'),
 (295, 259, '_wp_page_template', 'default'),
 (296, 261, '_edit_last', '1'),
 (297, 261, '_wp_page_template', 'default'),
 (298, 261, 'views', '13'),
 (299, 263, '_edit_last', '1'),
 (300, 263, '_wp_page_template', 'default'),
 (301, 263, 'views', '17'),
 (302, 267, '_edit_last', '1'),
 (303, 267, '_wp_page_template', 'default'),
 (304, 267, 'views', '12'),
 (305, 270, 'views', '14'),
 (306, 270, '_edit_last', '1'),
 (307, 270, '_wp_page_template', 'default'),
 (308, 272, '_edit_last', '1'),
 (309, 272, '_wp_page_template', 'default'),
 (310, 272, 'views', '13'),
 (311, 274, '_edit_last', '1'),
 (312, 274, '_wp_page_template', 'default'),
 (313, 274, 'views', '23'),
 (314, 277, '_edit_last', '1'),
 (315, 277, '_wp_page_template', 'default'),
 (316, 277, 'views', '19'),
 (317, 282, 'views', '17'),
 (318, 282, '_edit_last', '1'),
 (319, 282, '_wp_page_template', 'default'),
 (320, 284, 'views', '16'),
 (321, 284, '_edit_last', '1'),
 (322, 284, '_wp_page_template', 'default'),
 (323, 288, '_edit_last', '1'),
 (324, 288, '_wp_page_template', 'default'),
 (325, 288, 'views', '18'),
 (326, 290, '_edit_last', '1'),
 (327, 290, '_wp_page_template', 'default'),
 (328, 290, 'views', '17'),
 (329, 292, 'views', '10'),
 (330, 292, '_edit_last', '1'),
 (331, 292, '_wp_page_template', 'default'),
 (332, 299, '_edit_last', '1'),
 (333, 299, '_wp_page_template', 'default'),
 (334, 299, 'views', '18'),
 (335, 305, '_edit_last', '1'),
 (336, 305, '_wp_page_template', 'default'),
 (337, 305, 'views', '14'),
 (338, 307, '_edit_last', '1'),
 (339, 307, '_wp_page_template', 'default'),
 (340, 307, 'views', '27'),
 (341, 310, '_edit_last', '1'),
 (342, 310, '_wp_page_template', 'default'),
 (343, 310, 'views', '18'),
 (344, 312, '_edit_last', '1'),
 (345, 312, '_wp_page_template', 'default'),
 (346, 312, 'views', '22'),
 (347, 314, '_edit_last', '1'),
 (348, 314, '_wp_page_template', 'default'),
 (349, 314, 'views', '10'),
 (350, 314, 'views', '10'),
 (351, 318, '_edit_last', '1'),
 (352, 318, '_wp_page_template', 'default'),
 (353, 318, 'views', '33'),
 (354, 320, '_edit_last', '1'),
 (355, 320, '_wp_page_template', 'default'),
 (356, 320, 'views', '22'),
 (357, 323, '_edit_last', '1'),
 (358, 323, '_wp_page_template', 'default'),
 (359, 323, 'views', '11'),
 (360, 326, 'views', '22'),
 (361, 326, '_edit_last', '1'),
 (362, 326, '_wp_page_template', 'default'),
 (363, 328, '_edit_last', '1'),
 (364, 328, '_wp_page_template', 'default'),
 (365, 328, 'views', '15'),
 (366, 330, '_edit_last', '1'),
 (367, 330, '_wp_page_template', 'default'),
 (368, 330, 'views', '32'),
 (369, 332, '_edit_last', '1'),
 (370, 332, '_wp_page_template', 'default'),
 (371, 332, 'views', '21'),
 (372, 337, '_edit_last', '1'),
 (373, 337, '_wp_page_template', 'default'),
 (374, 337, 'views', '21'),
 (375, 341, '_edit_last', '1'),
 (376, 341, '_wp_page_template', 'default'),
 (377, 341, 'views', '18'),
 (378, 344, '_edit_last', '1'),
 (379, 344, '_wp_page_template', 'default'),
 (380, 344, 'views', '12'),
 (381, 347, '_edit_last', '1'),
 (382, 347, '_wp_page_template', 'default'),
 (383, 347, 'views', '16'),
 (384, 25, '_edit_last', '1'),
 (385, 25, 'post_views_count', '12'),
 (386, 25, 'views', '3'),
 (387, 33, '_edit_last', '1'),
 (388, 33, 'post_views_count', '11'),
 (389, 33, 'views', '3'),
 (390, 35, '_edit_last', '1'),
 (391, 35, 'post_views_count', '26'),
 (392, 35, 'views', '12'),
 (393, 39, 'views', '8'),
 (394, 39, '_edit_last', '1'),
 (395, 39, 'post_views_count', '19'),
 (397, 46, '_edit_last', '1'),
 (398, 46, 'post_views_count', '11'),
 (399, 46, 'views', '3'),
 (400, 48, '_edit_last', '1'),
 (401, 48, 'post_views_count', '19'),
 (403, 48, 'views', '3'),
 (404, 52, '_edit_last', '1'),
 (405, 52, 'post_views_count', '48'),
 (406, 52, 'views', '36'),
 (407, 54, '_edit_last', '1'),
 (408, 54, 'post_views_count', '20'),
 (409, 54, 'views', '3'),
 (410, 57, '_edit_last', '1'),
 (411, 57, 'post_views_count', '27'),
 (412, 57, 'views', '8'),
 (413, 368, '_edit_last', '1'),
 (414, 368, '_wp_page_template', 'default'),
 (415, 368, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (416, 368, 'views', '488'),
 (417, 369, 'views', '411'),
 (418, 369, '_oembed_b3203bb1e686f5945c127225be4f8ebf', '{{unknown}}'),
 (419, 369, '_oembed_4e854be435de9285fa71fd9659a8f3e4', '{{unknown}}'),
 (420, 370, 'views', '6'),
 (421, 371, 'views', '27'),
 (422, 371, '_oembed_b3203bb1e686f5945c127225be4f8ebf', '{{unknown}}'),
 (423, 371, '_oembed_4e854be435de9285fa71fd9659a8f3e4', '{{unknown}}'),
 (424, 372, 'views', '70'),
 (425, 373, 'views', '0'),
 (426, 374, 'views', '177'),
 (427, 375, 'views', '34'),
 (428, 376, 'views', '0'),
 (429, 377, 'views', '0'),
 (430, 468, '_edit_last', '1'),
 (431, 468, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (432, 468, 'post_views_count', '35'),
 (433, 468, 'views', '28'),
 (434, 61, '_edit_last', '1'),
 (435, 61, 'post_views_count', '19'),
 (436, 61, 'views', '3'),
 (437, 64, 'views', '13'),
 (438, 64, '_edit_last', '1'),
 (439, 64, 'post_views_count', '31'),
 (440, 64, '_oembed_ae7548899800f9cde574e3477f9fa906', '<div id="fb-root"></div><script>(function(d, s, id) {  var js, fjs = d.getElementsByTagName(s)[0];  if (d.getElementById(id)) return;  js = d.createElement(s); js.id = id;  js.src = "//connect.facebook.net/pl_PL/sdk.js#xfbml=1&version=v2.10";  fjs.parentNode.insertBefore(js, fjs);}(document, \'script\', \'facebook-jssdk\'));</script><div class="fb-post" data-href="https://www.facebook.com/mgokslesin/photos/a.1487578004877629.1073741828.1487568454878584/1728076500827777/?type=3" data-width="500"><blockquote cite="https://www.facebook.com/mgokslesin/photos/a.1487578004877629.1073741828.1487568454878584/1728076500827777/?type=3" class="fb-xfbml-parse-ignore"><p>Kluby SenioraZapraszam do udzia&#x142;u w XX Wakacyjnym Pikniku Klub&#xf3;w Seniora, kt&#xf3;ry odb&#x119;dzie si&#x119; tradycyjnie w pierwszy...</p>Opublikowany przez <a href="https://www.facebook.com/mgokslesin/">Miejsko-Gminny Ośrodek Kultury w Ślesinie</a> na&nbsp;<a href="https://www.facebook.com/mgokslesin/photos/a.1487578004877629.1073741828.1487568454878584/1728076500827777/?type=3">21 lipca 2017</a></blockquote></div>'),
 (441, 64, '_oembed_time_ae7548899800f9cde574e3477f9fa906', '1501710141'),
 (442, 67, 'views', '6'),
 (443, 67, '_edit_last', '1'),
 (444, 67, 'post_views_count', '67'),
 (445, 67, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (446, 69, '_edit_last', '1'),
 (447, 69, 'post_views_count', '90'),
 (449, 69, 'views', '69'),
 (450, 72, '_edit_last', '1'),
 (451, 72, 'post_views_count', '65'),
 (452, 72, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (453, 72, 'views', '26'),
 (454, 74, '_edit_last', '1'),
 (455, 74, 'post_views_count', '45'),
 (457, 74, 'views', '9'),
 (458, 77, '_edit_last', '1'),
 (459, 77, 'post_views_count', '40'),
 (461, 77, 'views', '17'),
 (462, 79, '_edit_last', '1'),
 (463, 79, 'post_views_count', '38'),
 (465, 79, 'views', '19'),
 (466, 136, '_edit_last', '1'),
 (467, 136, '_oembed_e34161813d23b4fd86cd2253cc7d8ceb', '<iframe width="500" height="281" src="https://www.youtube.com/embed/UoIniGwTPOI?feature=oembed" frameborder="0" allowfullscreen></iframe>'),
 (468, 136, '_oembed_time_e34161813d23b4fd86cd2253cc7d8ceb', '1502202266'),
 (469, 136, 'post_views_count', '264'),
 (471, 136, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (472, 136, 'views', '176'),
 (473, 364, '_edit_last', '1'),
 (474, 364, 'post_views_count', '1109'),
 (475, 364, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (476, 364, 'views', '1118'),
 (477, 401, '_edit_last', '1'),
 (478, 401, 'post_views_count', '251'),
 (479, 401, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (480, 401, 'views', '110'),
 (481, 443, '_edit_last', '1'),
 (482, 443, 'post_views_count', '112'),
 (483, 443, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (484, 443, 'views', '48'),
 (485, 446, '_edit_last', '1'),
 (486, 446, 'post_views_count', '61'),
 (487, 446, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (488, 446, 'views', '16'),
 (489, 451, '_edit_last', '1'),
 (490, 451, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (491, 451, 'post_views_count', '215'),
 (492, 451, 'views', '128'),
 (493, 463, '_edit_last', '1'),
 (494, 463, 'post_views_count', '237'),
 (495, 463, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (496, 463, 'views', '121'),
 (497, 466, '_edit_last', '1'),
 (498, 466, 'post_views_count', '84'),
 (499, 466, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (500, 466, 'views', '42'),
 (501, 474, '_edit_last', '1'),
 (502, 474, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (503, 474, 'post_views_count', '84'),
 (504, 474, 'views', '39'),
 (505, 480, '_edit_last', '1'),
 (506, 480, 'post_views_count', '105'),
 (507, 480, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (508, 480, 'views', '40'),
 (509, 483, '_edit_last', '1'),
 (510, 483, 'post_views_count', '179'),
 (511, 483, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (512, 483, 'views', '67'),
 (513, 485, '_edit_last', '1'),
 (514, 485, 'post_views_count', '21'),
 (515, 485, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (516, 485, 'views', '6'),
 (517, 494, '_edit_last', '1'),
 (518, 494, 'post_views_count', '268'),
 (519, 494, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (520, 494, 'views', '243'),
 (521, 498, '_edit_last', '1'),
 (522, 498, 'views', '112'),
 (523, 498, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (524, 498, 'post_views_count', '137'),
 (525, 502, '_edit_last', '1'),
 (526, 502, 'post_views_count', '381'),
 (527, 502, 'views', '264'),
 (528, 502, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (529, 510, '_edit_last', '1'),
 (530, 510, 'post_views_count', '59'),
 (531, 510, 'views', '49'),
 (532, 510, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (533, 512, '_edit_last', '1'),
 (534, 512, 'post_views_count', '28'),
 (535, 512, 'views', '17'),
 (536, 512, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (537, 514, '_edit_last', '1'),
 (538, 514, 'post_views_count', '817'),
 (539, 514, 'views', '717'),
 (540, 514, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (541, 520, '_edit_last', '1'),
 (542, 520, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (543, 520, 'post_views_count', '200'),
 (544, 520, 'views', '109'),
 (545, 526, '_edit_last', '1'),
 (546, 526, 'post_views_count', '45'),
 (547, 526, 'views', '34'),
 (548, 526, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (549, 528, '_edit_last', '1'),
 (550, 528, 'post_views_count', '50'),
 (551, 528, 'views', '37'),
 (552, 528, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (553, 530, '_edit_last', '1'),
 (554, 530, 'views', '30'),
 (555, 530, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (556, 530, 'post_views_count', '40'),
 (557, 532, '_edit_last', '1'),
 (558, 532, 'post_views_count', '448'),
 (559, 532, 'views', '433'),
 (560, 532, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (561, 538, '_edit_last', '1'),
 (562, 538, 'post_views_count', '292'),
 (563, 538, 'views', '278'),
 (564, 538, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (565, 544, '_edit_last', '1'),
 (566, 544, 'views', '77'),
 (567, 544, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (568, 544, 'post_views_count', '99'),
 (569, 546, '_edit_last', '1'),
 (570, 546, 'views', '87'),
 (571, 546, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (572, 546, 'post_views_count', '140'),
 (573, 553, '_edit_last', '1'),
 (574, 553, 'post_views_count', '217'),
 (575, 553, 'views', '202'),
 (576, 553, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (577, 554, '_edit_last', '1'),
 (578, 554, 'post_views_count', '68'),
 (579, 554, 'views', '53'),
 (580, 554, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (581, 562, '_edit_last', '1'),
 (582, 562, 'views', '90'),
 (583, 562, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (584, 562, 'post_views_count', '97'),
 (585, 565, '_edit_last', '1'),
 (586, 565, 'views', '39'),
 (587, 565, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (588, 565, 'post_views_count', '52'),
 (589, 568, '_edit_last', '1'),
 (590, 568, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (591, 568, 'post_views_count', '75'),
 (592, 568, '_oembed_c546a9f6bee2d879bb13e7cbc3e6da1e', '{{unknown}}'),
 (593, 568, 'views', '64'),
 (594, 576, '_edit_last', '1'),
 (595, 576, 'post_views_count', '205'),
 (596, 576, 'views', '149'),
 (597, 576, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (598, 574, '_edit_last', '1'),
 (599, 574, 'views', '164'),
 (600, 574, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (601, 574, 'post_views_count', '201'),
 (602, 578, '_edit_last', '1'),
 (603, 578, 'post_views_count', '218'),
 (604, 578, 'views', '202'),
 (605, 578, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (606, 580, '_edit_last', '1'),
 (607, 580, 'views', '255'),
 (608, 580, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (609, 580, 'post_views_count', '297'),
 (610, 587, '_edit_last', '1'),
 (611, 587, 'views', '105'),
 (612, 587, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (613, 587, 'post_views_count', '122'),
 (614, 589, '_edit_last', '1'),
 (615, 589, 'views', '36'),
 (616, 589, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (617, 589, 'post_views_count', '53'),
 (618, 597, '_edit_last', '1'),
 (619, 597, 'post_views_count', '59'),
 (620, 597, 'views', '38'),
 (621, 597, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (622, 600, '_edit_last', '1'),
 (623, 600, 'views', '47'),
 (624, 600, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (625, 600, 'post_views_count', '72'),
 (626, 602, '_edit_last', '1'),
 (627, 602, 'views', '130'),
 (628, 602, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (629, 602, 'post_views_count', '200'),
 (630, 608, '_edit_last', '1'),
 (631, 608, 'views', '51'),
 (632, 608, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (633, 608, 'post_views_count', '76'),
 (634, 610, '_edit_last', '1'),
 (635, 610, 'post_views_count', '166'),
 (636, 610, 'views', '135'),
 (637, 610, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (638, 612, '_edit_last', '1'),
 (639, 612, 'views', '74'),
 (640, 612, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (641, 612, 'post_views_count', '102'),
 (642, 620, '_edit_last', '1'),
 (643, 620, 'post_views_count', '69'),
 (644, 620, 'views', '43'),
 (645, 620, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (646, 628, '_edit_last', '1'),
 (647, 628, 'post_views_count', '129'),
 (648, 628, 'views', '87'),
 (649, 628, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (650, 639, '_edit_last', '1'),
 (651, 639, 'post_views_count', '257'),
 (652, 639, 'views', '213'),
 (653, 639, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (654, 642, '_edit_last', '1'),
 (655, 642, 'views', '33'),
 (656, 642, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (657, 642, 'post_views_count', '51'),
 (658, 647, '_edit_last', '1'),
 (659, 647, 'views', '84'),
 (660, 647, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (661, 647, 'post_views_count', '102'),
 (662, 649, '_edit_last', '1'),
 (663, 649, 'post_views_count', '326'),
 (664, 649, 'views', '310'),
 (665, 649, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (666, 651, '_edit_last', '1'),
 (667, 651, 'post_views_count', '41'),
 (668, 651, 'views', '29'),
 (669, 651, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (670, 656, '_edit_last', '1'),
 (671, 656, 'views', '152'),
 (672, 656, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (673, 656, 'post_views_count', '173'),
 (674, 658, '_edit_last', '1'),
 (675, 658, 'views', '92'),
 (676, 658, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (677, 658, 'post_views_count', '101'),
 (678, 660, '_edit_last', '1'),
 (679, 660, 'post_views_count', '66'),
 (680, 660, 'views', '53'),
 (681, 660, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (682, 668, '_edit_last', '1'),
 (683, 668, 'views', '122'),
 (684, 668, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (685, 668, 'post_views_count', '171'),
 (686, 670, '_edit_last', '1'),
 (687, 670, 'views', '70'),
 (688, 670, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (689, 670, 'post_views_count', '79'),
 (690, 672, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (691, 672, 'views', '190'),
 (692, 672, 'post_views_count', '239'),
 (693, 672, '_edit_last', '1'),
 (694, 674, 'post_views_count', '81'),
 (695, 674, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (696, 674, 'views', '54'),
 (697, 674, '_edit_last', '1'),
 (698, 676, 'post_views_count', '136'),
 (699, 676, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (700, 676, 'views', '124'),
 (701, 676, '_oembed_0b7fd44689dcb3852dd475ca6d65def1', '{{unknown}}'),
 (702, 676, '_edit_last', '1'),
 (703, 680, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (704, 680, 'views', '48'),
 (705, 680, 'post_views_count', '59'),
 (706, 680, '_edit_last', '1'),
 (707, 682, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (708, 682, 'views', '115'),
 (709, 682, 'post_views_count', '125'),
 (710, 682, '_edit_last', '1'),
 (711, 686, 'post_views_count', '76'),
 (712, 686, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (713, 686, 'views', '63'),
 (714, 686, '_edit_last', '1'),
 (715, 688, 'views', '67'),
 (716, 688, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (717, 688, 'post_views_count', '83'),
 (718, 688, '_edit_last', '1'),
 (719, 690, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (720, 690, 'views', '132'),
 (721, 690, '_edit_last', '1'),
 (722, 690, 'post_views_count', '140'),
 (723, 692, '_edit_last', '1'),
 (724, 692, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (725, 692, 'views', '136'),
 (726, 692, 'post_views_count', '224'),
 (727, 697, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (728, 697, 'post_views_count', '373'),
 (729, 697, 'views', '316'),
 (730, 697, '_edit_last', '1'),
 (731, 702, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (732, 702, 'views', '152'),
 (733, 702, 'post_views_count', '169'),
 (734, 702, '_edit_last', '1'),
 (735, 704, '_wp_old_slug', '704'),
 (736, 704, 'post_views_count', '51'),
 (737, 704, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (738, 704, 'views', '38'),
 (739, 704, '_edit_last', '1'),
 (740, 708, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (741, 708, 'views', '48'),
 (742, 708, 'post_views_count', '65'),
 (743, 708, '_edit_last', '1'),
 (744, 710, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (745, 710, '_edit_last', '1'),
 (746, 710, 'views', '33'),
 (747, 710, 'post_views_count', '46'),
 (748, 713, 'views', '122'),
 (749, 713, 'post_views_count', '132'),
 (750, 713, '_edit_last', '1'),
 (751, 713, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (752, 718, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (753, 718, 'views', '77'),
 (754, 718, 'post_views_count', '84'),
 (755, 718, '_edit_last', '1'),
 (756, 720, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (757, 720, '_edit_last', '1'),
 (758, 720, 'views', '31'),
 (759, 720, 'post_views_count', '39'),
 (760, 722, '_edit_last', '1'),
 (761, 722, 'views', '44'),
 (762, 722, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (763, 722, 'post_views_count', '52'),
 (764, 724, '_edit_last', '1'),
 (765, 724, 'views', '89'),
 (766, 724, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (767, 724, 'post_views_count', '97'),
 (768, 726, '_edit_last', '1'),
 (769, 726, 'views', '237'),
 (770, 726, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (771, 726, 'post_views_count', '248'),
 (772, 729, '_edit_last', '1'),
 (773, 729, 'post_views_count', '86'),
 (774, 729, 'views', '76'),
 (775, 729, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (776, 736, '_edit_last', '1'),
 (777, 736, '_oembed_d3aa742a6cd8de3cc8e149de01f2f482', '{{unknown}}'),
 (778, 736, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (779, 736, 'post_views_count', '219'),
 (780, 736, 'views', '110'),
 (781, 743, '_edit_last', '1'),
 (782, 743, 'views', '149'),
 (783, 743, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (784, 743, 'post_views_count', '179'),
 (785, 745, '_edit_last', '1'),
 (786, 745, 'views', '83'),
 (787, 745, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (788, 745, 'post_views_count', '99'),
 (789, 747, '_edit_last', '1'),
 (790, 747, 'views', '177'),
 (791, 747, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (792, 747, 'post_views_count', '195'),
 (793, 751, '_edit_last', '1'),
 (794, 751, 'views', '259'),
 (795, 751, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (796, 751, 'post_views_count', '275'),
 (797, 753, '_edit_last', '1'),
 (798, 753, 'post_views_count', '76'),
 (799, 753, 'views', '65'),
 (800, 753, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (801, 755, '_edit_last', '1'),
 (802, 755, 'post_views_count', '63'),
 (803, 755, 'views', '54'),
 (804, 755, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (805, 757, '_edit_last', '1'),
 (806, 757, 'views', '64'),
 (807, 757, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (808, 757, 'post_views_count', '79'),
 (809, 759, '_edit_last', '1'),
 (810, 759, 'views', '28'),
 (811, 759, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (812, 759, 'post_views_count', '37'),
 (813, 761, '_edit_last', '1'),
 (814, 761, 'views', '89'),
 (815, 761, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (816, 761, 'post_views_count', '111'),
 (817, 763, '_edit_last', '1'),
 (818, 763, 'views', '272'),
 (819, 763, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (820, 763, 'post_views_count', '290'),
 (821, 765, '_edit_last', '1'),
 (822, 765, 'views', '107'),
 (823, 765, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (824, 765, 'post_views_count', '128'),
 (825, 771, '_edit_last', '1'),
 (826, 771, 'views', '218'),
 (827, 771, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (828, 771, 'post_views_count', '232'),
 (829, 773, '_edit_last', '1'),
 (830, 773, 'post_views_count', '99'),
 (831, 773, 'views', '89'),
 (832, 773, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (833, 775, '_edit_last', '1'),
 (834, 775, 'post_views_count', '352'),
 (835, 775, 'views', '343'),
 (836, 775, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (837, 780, '_edit_last', '1'),
 (838, 780, 'views', '330'),
 (839, 780, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (840, 780, 'post_views_count', '345'),
 (841, 634, '_edit_last', '1'),
 (842, 634, 'views', '172'),
 (843, 634, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (844, 634, 'post_views_count', '203'),
 (845, 784, '_edit_last', '1'),
 (846, 784, 'views', '186'),
 (847, 784, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (848, 784, 'post_views_count', '191'),
 (849, 788, '_edit_last', '1'),
 (850, 788, 'views', '105'),
 (851, 788, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (852, 788, 'post_views_count', '127'),
 (853, 790, '_edit_last', '1'),
 (854, 790, 'views', '99'),
 (855, 790, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (856, 790, 'post_views_count', '109'),
 (857, 792, '_edit_last', '1'),
 (858, 792, 'views', '50'),
 (859, 792, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (860, 792, 'post_views_count', '61'),
 (861, 795, '_edit_last', '1'),
 (862, 795, 'post_views_count', '170'),
 (863, 795, 'views', '161'),
 (864, 795, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (865, 800, '_edit_last', '1'),
 (866, 800, 'views', '41'),
 (867, 800, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (868, 800, 'post_views_count', '49'),
 (869, 802, '_edit_last', '1'),
 (870, 802, 'post_views_count', '237'),
 (871, 802, 'views', '225'),
 (872, 802, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (873, 808, '_edit_last', '1'),
 (874, 808, 'views', '36'),
 (875, 808, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (876, 808, 'post_views_count', '47'),
 (877, 810, '_edit_last', '1'),
 (878, 810, 'views', '55'),
 (879, 810, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (880, 810, 'post_views_count', '64'),
 (881, 812, '_edit_last', '1'),
 (882, 812, 'post_views_count', '109'),
 (883, 812, 'views', '100'),
 (884, 812, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (885, 815, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (886, 815, 'views', '42'),
 (887, 815, '_edit_last', '1'),
 (888, 815, 'post_views_count', '45'),
 (889, 817, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (890, 817, 'views', '89'),
 (891, 817, '_edit_last', '1'),
 (892, 817, 'post_views_count', '94'),
 (893, 821, '_edit_last', '1'),
 (894, 821, 'post_views_count', '143'),
 (895, 821, 'views', '136'),
 (896, 821, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (897, 823, '_edit_last', '1'),
 (898, 823, 'views', '56'),
 (899, 823, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (900, 823, 'post_views_count', '62'),
 (901, 825, '_edit_last', '1'),
 (902, 825, 'post_views_count', '87'),
 (903, 825, 'views', '80'),
 (904, 825, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (905, 827, '_edit_last', '1'),
 (906, 827, 'post_views_count', '52'),
 (907, 827, 'views', '46'),
 (908, 827, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (909, 830, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (910, 830, 'views', '22'),
 (911, 830, '_edit_last', '1'),
 (912, 830, 'post_views_count', '27'),
 (913, 832, '_edit_last', '1'),
 (914, 832, 'post_views_count', '185'),
 (915, 832, 'views', '176'),
 (916, 832, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (917, 834, '_edit_last', '1'),
 (918, 834, 'post_views_count', '93'),
 (919, 834, 'views', '89'),
 (920, 834, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (921, 837, '_edit_last', '1'),
 (922, 837, '_oembed_1b6f3de55f1c547a80f54f17b1336ad1', '<div id="fb-root"></div><script>(function(d, s, id) {  var js, fjs = d.getElementsByTagName(s)[0];  if (d.getElementById(id)) return;  js = d.createElement(s); js.id = id;  js.src = "//connect.facebook.net/pl_PL/sdk.js#xfbml=1&version=v2.10";  fjs.parentNode.insertBefore(js, fjs);}(document, \'script\', \'facebook-jssdk\'));</script><div class="fb-video" data-href="https://www.facebook.com/kalejdoskopwielkopolski/videos/1537337989661459/?hc_ref=ARTO4jiYqqOTv6x6aUImXJl_LEgcCbb4heO2T825YZPZhfqT2VvKFQFoRvTg-MyUgMc&amp;fref=nf" data-width="500"><blockquote cite="https://www.facebook.com/kalejdoskopwielkopolski/videos/1537337989661459/" class="fb-xfbml-parse-ignore"><a href="https://www.facebook.com/kalejdoskopwielkopolski/videos/1537337989661459/">Ślesin Jarmark Ochweśnicki 2017</a><p>W Ślesinie na tamtejszym rynku po raz czwarty odbył się Jarmark Ochweśnicki.  Na straganach pojawiły się lokalne przysmaki, wyroby rękodzieła, oraz sztuka ludowa. Zebranym czas umilały lokalne zespoły muzyczne.</p>Opublikowany przez <a href="https://www.facebook.com/kalejdoskopwielkopolski/">Kalejdoskop Wielkopolski Wschodniej</a> na 29 września 2017</blockquote></div>'),
 (923, 837, '_oembed_time_1b6f3de55f1c547a80f54f17b1336ad1', '1507018087'),
 (924, 837, 'post_views_count', '213'),
 (925, 837, 'views', '210'),
 (926, 837, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (927, 841, '_edit_last', '1'),
 (928, 841, 'post_views_count', '379'),
 (929, 841, 'views', '377'),
 (930, 841, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (931, 846, '_edit_last', '1'),
 (932, 846, 'views', '58'),
 (933, 846, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (934, 846, 'post_views_count', '63'),
 (935, 847, '_edit_last', '1'),
 (936, 847, 'views', '52'),
 (937, 847, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (938, 847, 'post_views_count', '57'),
 (939, 854, '_edit_last', '1'),
 (940, 854, 'views', '92'),
 (941, 854, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (942, 854, 'post_views_count', '96'),
 (943, 856, '_edit_last', '1'),
 (944, 856, 'views', '34'),
 (945, 856, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (946, 856, 'post_views_count', '38'),
 (947, 858, '_edit_last', '1'),
 (948, 858, 'post_views_count', '194'),
 (949, 858, 'views', '184'),
 (950, 858, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (951, 860, '_edit_last', '1'),
 (952, 860, 'views', '20'),
 (953, 860, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (954, 860, 'post_views_count', '24'),
 (955, 862, '_edit_last', '1'),
 (956, 862, 'views', '48'),
 (957, 862, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (958, 862, 'post_views_count', '55'),
 (959, 864, '_edit_last', '1'),
 (960, 864, 'post_views_count', '253'),
 (961, 864, 'views', '248'),
 (962, 864, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (963, 866, '_edit_last', '1'),
 (964, 866, 'views', '52'),
 (965, 866, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (966, 866, 'post_views_count', '58'),
 (967, 868, '_edit_last', '1'),
 (968, 868, 'views', '209'),
 (969, 868, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (970, 868, 'post_views_count', '217'),
 (971, 870, '_edit_last', '1'),
 (972, 870, 'post_views_count', '76'),
 (973, 870, 'views', '71'),
 (974, 870, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (975, 872, '_edit_last', '1'),
 (976, 872, 'post_views_count', '70'),
 (977, 872, 'views', '66'),
 (978, 872, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (979, 874, '_edit_last', '1'),
 (980, 874, 'views', '211'),
 (981, 874, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (982, 874, 'post_views_count', '213'),
 (983, 876, '_edit_last', '1'),
 (984, 876, 'views', '206'),
 (985, 876, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (986, 876, 'post_views_count', '209'),
 (987, 879, '_edit_last', '1'),
 (988, 879, 'views', '134'),
 (989, 879, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (990, 879, 'post_views_count', '139'),
 (991, 881, '_edit_last', '1'),
 (992, 881, 'views', '43'),
 (993, 881, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (994, 881, 'post_views_count', '47'),
 (995, 883, '_edit_last', '1'),
 (996, 883, 'views', '78'),
 (997, 883, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (998, 883, 'post_views_count', '82'),
 (999, 885, '_edit_last', '1'),
 (1000, 885, 'views', '85'),
 (1001, 885, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (1002, 885, 'post_views_count', '92'),
 (1003, 852, '_edit_last', '1'),
 (1004, 852, 'views', '0'),
 (1005, 852, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (1006, 852, '_wp_trash_meta_status', 'publish'),
 (1007, 852, '_wp_trash_meta_time', '1507325233'),
 (1008, 852, '_wp_desired_post_slug', 'spektakl-o-objawieniach-lichenskich'),
 (1009, 888, '_edit_last', '1'),
 (1010, 888, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (1011, 888, 'post_views_count', '49'),
 (1012, 888, 'views', '44'),
 (1013, 891, '_edit_last', '1'),
 (1014, 891, 'post_views_count', '26'),
 (1015, 891, 'views', '22'),
 (1016, 891, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (1017, 893, '_edit_last', '1'),
 (1018, 893, 'post_views_count', '31'),
 (1019, 893, 'views', '27'),
 (1020, 893, '_the_champ_meta', 'a:3:{s:25:"facebook_horizontal_count";i:0;s:24:"twitter_horizontal_count";i:0;s:25:"linkedin_horizontal_count";i:0;}'),
 (1055, 900, '_wp_attached_file', '2017/10/meteoprognoza-logo.png'),
 (1056, 900, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1917;s:6:"height";i:305;s:4:"file";s:30:"2017/10/meteoprognoza-logo.png";s:5:"sizes";a:6:{s:9:"thumbnail";a:4:{s:4:"file";s:30:"meteoprognoza-logo-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:29:"meteoprognoza-logo-300x48.png";s:5:"width";i:300;s:6:"height";i:48;s:9:"mime-type";s:9:"image/png";}s:12:"medium_large";a:4:{s:4:"file";s:30:"meteoprognoza-logo-768x122.png";s:5:"width";i:768;s:6:"height";i:122;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:31:"meteoprognoza-logo-1024x163.png";s:5:"width";i:1024;s:6:"height";i:163;s:9:"mime-type";s:9:"image/png";}s:19:"featured-slider-img";a:4:{s:4:"file";s:30:"meteoprognoza-logo-640x305.png";s:5:"width";i:640;s:6:"height";i:305;s:9:"mime-type";s:9:"image/png";}s:17:"featured-post-img";a:4:{s:4:"file";s:30:"meteoprognoza-logo-480x305.png";s:5:"width";i:480;s:6:"height";i:305;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
 (1057, 901, '_wp_attached_file', '2017/10/print-logo2pr.jpg'),
 (1058, 901, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:81;s:6:"height";i:82;s:4:"file";s:25:"2017/10/print-logo2pr.jpg";s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
 (1059, 902, '_wp_attached_file', '2017/10/cropped-print-logo2pr.jpg'),
 (1060, 902, '_wp_attachment_context', 'site-icon'),
 (1061, 902, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:512;s:6:"height";i:512;s:4:"file";s:33:"2017/10/cropped-print-logo2pr.jpg";s:5:"sizes";a:8:{s:9:"thumbnail";a:4:{s:4:"file";s:33:"cropped-print-logo2pr-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:33:"cropped-print-logo2pr-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:19:"featured-slider-img";a:4:{s:4:"file";s:33:"cropped-print-logo2pr-512x480.jpg";s:5:"width";i:512;s:6:"height";i:480;s:9:"mime-type";s:10:"image/jpeg";}s:17:"featured-post-img";a:4:{s:4:"file";s:33:"cropped-print-logo2pr-480x320.jpg";s:5:"width";i:480;s:6:"height";i:320;s:9:"mime-type";s:10:"image/jpeg";}s:13:"site_icon-270";a:4:{s:4:"file";s:33:"cropped-print-logo2pr-270x270.jpg";s:5:"width";i:270;s:6:"height";i:270;s:9:"mime-type";s:10:"image/jpeg";}s:13:"site_icon-192";a:4:{s:4:"file";s:33:"cropped-print-logo2pr-192x192.jpg";s:5:"width";i:192;s:6:"height";i:192;s:9:"mime-type";s:10:"image/jpeg";}s:13:"site_icon-180";a:4:{s:4:"file";s:33:"cropped-print-logo2pr-180x180.jpg";s:5:"width";i:180;s:6:"height";i:180;s:9:"mime-type";s:10:"image/jpeg";}s:12:"site_icon-32";a:4:{s:4:"file";s:31:"cropped-print-logo2pr-32x32.jpg";s:5:"width";i:32;s:6:"height";i:32;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
 (1062, 898, '_wp_trash_meta_status', 'publish'),
 (1063, 898, '_wp_trash_meta_time', '1508770891'),
 (1064, 903, '_wp_trash_meta_status', 'publish'),
 (1065, 903, '_wp_trash_meta_time', '1508771029'),
 (1066, 904, '_wp_trash_meta_status', 'publish'),
 (1067, 904, '_wp_trash_meta_time', '1508771074'),
 (1068, 905, '_wp_trash_meta_status', 'publish'),
 (1069, 905, '_wp_trash_meta_time', '1508771145'),
 (1070, 893, '_wp_trash_meta_status', 'publish'),
 (1071, 893, '_wp_trash_meta_time', '1508773244'),
 (1072, 893, '_wp_desired_post_slug', 'przed-nowym-wyzwaniem'),
 (1073, 891, '_wp_trash_meta_status', 'publish'),
 (1074, 891, '_wp_trash_meta_time', '1508773244'),
 (1075, 891, '_wp_desired_post_slug', 'mecz-z-krzymowem'),
 (1076, 888, '_wp_trash_meta_status', 'publish'),
 (1077, 888, '_wp_trash_meta_time', '1508773244'),
 (1078, 888, '_wp_desired_post_slug', 'warsztaty-filmowe-i-telewizyjne-nakrecona-gmina'),
 (1079, 885, '_wp_trash_meta_status', 'publish'),
 (1080, 885, '_wp_trash_meta_time', '1508773244'),
 (1081, 885, '_wp_desired_post_slug', 'koncert-operetkowy'),
 (1082, 883, '_wp_trash_meta_status', 'publish'),
 (1083, 883, '_wp_trash_meta_time', '1508773244'),
 (1084, 883, '_wp_desired_post_slug', 'wielki-sukces-podopiecznych-piotra-piechockiego'),
 (1085, 881, '_wp_trash_meta_status', 'publish'),
 (1086, 881, '_wp_trash_meta_time', '1508773244'),
 (1087, 881, '_wp_desired_post_slug', 'sukces-solistek-studia-piosenki'),
 (1088, 879, '_wp_trash_meta_status', 'publish'),
 (1089, 879, '_wp_trash_meta_time', '1508773244'),
 (1090, 879, '_wp_desired_post_slug', 'nowe-nazwy-ulic-w-slesinie'),
 (1091, 876, '_wp_trash_meta_status', 'publish'),
 (1092, 876, '_wp_trash_meta_time', '1508773244'),
 (1093, 876, '_wp_desired_post_slug', 'gdyby-nie-bariera-ochronna-wjechalby-w-dom'),
 (1094, 874, '_wp_trash_meta_status', 'publish'),
 (1095, 874, '_wp_trash_meta_time', '1508773244'),
 (1096, 874, '_wp_desired_post_slug', 'takiego-urzedu-nie-ma-w-calym-powiecie'),
 (1097, 872, '_wp_trash_meta_status', 'publish'),
 (1098, 872, '_wp_trash_meta_time', '1508773244'),
 (1099, 872, '_wp_desired_post_slug', 'spektakularny-sukces-ze-rzgowem'),
 (1100, 870, '_wp_trash_meta_status', 'publish'),
 (1101, 870, '_wp_trash_meta_time', '1508773244'),
 (1102, 870, '_wp_desired_post_slug', 'lks-zagra-ze-rzgowem'),
 (1103, 868, '_wp_trash_meta_status', 'publish'),
 (1104, 868, '_wp_trash_meta_time', '1508773244'),
 (1105, 868, '_wp_desired_post_slug', 'zlot-milosnikow-aut-z-prl-u'),
 (1106, 866, '_wp_trash_meta_status', 'publish'),
 (1107, 866, '_wp_trash_meta_time', '1508773244'),
 (1108, 866, '_wp_desired_post_slug', 'turniej-klasyfikacyjny'),
 (1109, 864, '_wp_trash_meta_status', 'publish'),
 (1110, 864, '_wp_trash_meta_time', '1508773244'),
 (1111, 864, '_wp_desired_post_slug', 'prawie-20-malzenstw-z-medalami-od-prezydenta-polski'),
 (1112, 862, '_wp_trash_meta_status', 'publish'),
 (1113, 862, '_wp_trash_meta_time', '1508773244'),
 (1114, 862, '_wp_desired_post_slug', 'aerobik'),
 (1115, 860, '_wp_trash_meta_status', 'publish'),
 (1116, 860, '_wp_trash_meta_time', '1508773244'),
 (1117, 860, '_wp_desired_post_slug', 'druzynowe-mistrzostwa-powiatu-koninskiego-w-szachach'),
 (1118, 854, '_wp_trash_meta_status', 'publish'),
 (1119, 854, '_wp_trash_meta_time', '1508773244'),
 (1120, 854, '_wp_desired_post_slug', 'wystawa-prac-artystow-gminy-slesin'),
 (1121, 846, '_wp_trash_meta_status', 'publish'),
 (1122, 846, '_wp_trash_meta_time', '1508773244'),
 (1123, 846, '_wp_desired_post_slug', 'lks-zagra-w-viii-rundzie-z-zks-zagorow'),
 (1124, 847, '_wp_trash_meta_status', 'publish'),
 (1125, 847, '_wp_trash_meta_time', '1508773244'),
 (1126, 847, '_wp_desired_post_slug', 'druzynowe-mistrzostwa-szkol-gminy-slesin'),
 (1127, 858, '_wp_trash_meta_status', 'publish'),
 (1128, 858, '_wp_trash_meta_time', '1508773244'),
 (1129, 858, '_wp_desired_post_slug', 'dzien-kukurydzy-w-firmie-szmidt'),
 (1130, 856, '_wp_trash_meta_status', 'publish'),
 (1131, 856, '_wp_trash_meta_time', '1508773666'),
 (1132, 856, '_wp_desired_post_slug', 'zakup-nowosci-wydawniczych-2017'),
 (1133, 841, '_wp_trash_meta_status', 'publish'),
 (1134, 841, '_wp_trash_meta_time', '1508773666'),
 (1135, 841, '_wp_desired_post_slug', 'dwa-wypadki-w-poniedzialkowy-poranek'),
 (1136, 841, '_wp_trash_meta_comments_status', 'a:1:{i:10;s:1:"1";}'),
 (1137, 837, '_wp_trash_meta_status', 'publish'),
 (1138, 837, '_wp_trash_meta_time', '1508773666'),
 (1139, 837, '_wp_desired_post_slug', 'relacja-z-jarmarku-ochwesnickiego'),
 (1140, 834, '_wp_trash_meta_status', 'publish'),
 (1141, 834, '_wp_trash_meta_time', '1508773666'),
 (1142, 834, '_wp_desired_post_slug', 'lks-slesin-wciaz-niepokonany'),
 (1143, 832, '_wp_trash_meta_status', 'publish'),
 (1144, 832, '_wp_trash_meta_time', '1508773666'),
 (1145, 832, '_wp_desired_post_slug', 'xv-swieto-pyrczoka'),
 (1146, 830, '_wp_trash_meta_status', 'publish'),
 (1147, 830, '_wp_trash_meta_time', '1508773666'),
 (1148, 830, '_wp_desired_post_slug', 'dzis-mecz-z-wrzesnia'),
 (1149, 827, '_wp_trash_meta_status', 'publish'),
 (1150, 827, '_wp_trash_meta_time', '1508773666'),
 (1151, 827, '_wp_desired_post_slug', 'debiut-najmlodszych-szachistow-na-mistrzostwach-miedzywojewodzkich'),
 (1152, 825, '_wp_trash_meta_status', 'publish'),
 (1153, 825, '_wp_trash_meta_time', '1508773666'),
 (1154, 825, '_wp_desired_post_slug', 'nakrecona-gmina'),
 (1155, 823, '_wp_trash_meta_status', 'publish'),
 (1156, 823, '_wp_trash_meta_time', '1508773666'),
 (1157, 823, '_wp_desired_post_slug', 'spektakl-o-objawieniach-lichenskich-i-historii-lichenia'),
 (1158, 821, '_wp_trash_meta_status', 'publish'),
 (1159, 821, '_wp_trash_meta_time', '1508773666'),
 (1160, 821, '_wp_desired_post_slug', 'pijany-kierowca-uciekal-policji'),
 (1161, 817, '_wp_trash_meta_status', 'publish'),
 (1162, 817, '_wp_trash_meta_time', '1508773666'),
 (1163, 817, '_wp_desired_post_slug', 'xxxiii-sesja-rady-miejskiej-gminy-slesin'),
 (1164, 815, '_wp_trash_meta_status', 'publish'),
 (1165, 815, '_wp_trash_meta_time', '1508773666'),
 (1166, 815, '_wp_desired_post_slug', 'moge-wiecej'),
 (1167, 812, '_wp_trash_meta_status', 'publish'),
 (1168, 812, '_wp_trash_meta_time', '1508773666'),
 (1169, 812, '_wp_desired_post_slug', 'konsultacje-dotyczace-programu-rewitalizacji-gminy'),
 (1170, 810, '_wp_trash_meta_status', 'publish'),
 (1171, 810, '_wp_trash_meta_time', '1508773666'),
 (1172, 810, '_wp_desired_post_slug', 'nabor-na-treningi-pilkarskie'),
 (1173, 808, '_wp_trash_meta_status', 'publish'),
 (1174, 808, '_wp_trash_meta_time', '1508773666'),
 (1175, 808, '_wp_desired_post_slug', 'lks-jedzie-na-mecz-do-kramska'),
 (1176, 802, '_wp_trash_meta_status', 'publish'),
 (1177, 802, '_wp_trash_meta_time', '1508773666'),
 (1178, 802, '_wp_desired_post_slug', 'rajd-rowerowy-wokol-jeziora-slesinskiego'),
 (1179, 800, '_wp_trash_meta_status', 'publish'),
 (1180, 800, '_wp_trash_meta_time', '1508773666'),
 (1181, 800, '_wp_desired_post_slug', 'zadbaj-o-bezpieczenstwo'),
 (1182, 634, '_wp_trash_meta_status', 'publish'),
 (1183, 634, '_wp_trash_meta_time', '1508773666'),
 (1184, 634, '_wp_desired_post_slug', 'juz-2-wrzesnia-ix-rajd-rowerowy-bursztynowym-szlakiem'),
 (1185, 795, '_wp_trash_meta_status', 'publish'),
 (1186, 795, '_wp_trash_meta_time', '1508773666'),
 (1187, 795, '_wp_desired_post_slug', 'sternik-katamaranu-byl-po-spozyciu-alkoholu'),
 (1188, 792, '_wp_trash_meta_status', 'publish'),
 (1189, 792, '_wp_trash_meta_time', '1508773666'),
 (1190, 792, '_wp_desired_post_slug', 'mecz-z-gornikiem-konin'),
 (1191, 790, '_wp_trash_meta_status', 'publish'),
 (1192, 790, '_wp_trash_meta_time', '1508773683'),
 (1193, 790, '_wp_desired_post_slug', 'przedpoludnie-z-sherlockiem-holmesem'),
 (1194, 788, '_wp_trash_meta_status', 'publish'),
 (1195, 788, '_wp_trash_meta_time', '1508773683'),
 (1196, 788, '_wp_desired_post_slug', 'mistrzowie-agro'),
 (1197, 784, '_wp_trash_meta_status', 'publish'),
 (1198, 784, '_wp_trash_meta_time', '1508773683'),
 (1199, 784, '_wp_desired_post_slug', 'kino-7d-zagosci-na-rynku-w-slesinie'),
 (1200, 780, '_wp_trash_meta_status', 'publish'),
 (1201, 780, '_wp_trash_meta_time', '1508773683'),
 (1202, 780, '_wp_desired_post_slug', 'wywoz-odpadow-wielkogabarytowych-i-sprzetu-elektrycznego'),
 (1203, 775, '_wp_trash_meta_status', 'publish'),
 (1204, 775, '_wp_trash_meta_time', '1508773683'),
 (1205, 775, '_wp_desired_post_slug', 'nie-udalo-sie-pozyskac-funduszy-mieszkancy-zawiedzeni'),
 (1206, 773, '_wp_trash_meta_status', 'publish'),
 (1207, 773, '_wp_trash_meta_time', '1508773683'),
 (1208, 773, '_wp_desired_post_slug', 'sportowasobota'),
 (1209, 771, '_wp_trash_meta_status', 'publish'),
 (1210, 771, '_wp_trash_meta_time', '1508773683'),
 (1211, 771, '_wp_desired_post_slug', 'kolejna-edycja-jarmarku-ochwesnickiego-juz-wkrotce'),
 (1212, 765, '_wp_trash_meta_status', 'publish'),
 (1213, 765, '_wp_trash_meta_time', '1508773683'),
 (1214, 765, '_wp_desired_post_slug', 'solecka-liga-pilki-noznej-solectwa-i-osiedli-gminy-slesin-2017-zakonczona'),
 (1215, 763, '_wp_trash_meta_status', 'publish'),
 (1216, 763, '_wp_trash_meta_time', '1508773683'),
 (1217, 763, '_wp_desired_post_slug', 'swieto-kapusty-w-honoratce-2'),
 (1218, 761, '_wp_trash_meta_status', 'publish'),
 (1219, 761, '_wp_trash_meta_time', '1508773683'),
 (1220, 761, '_wp_desired_post_slug', 'klub-seniora-pogodna-jesien-z-miejsko-gminnego-osrodka-kultury-w-slesinie-na-wakacjach'),
 (1221, 759, '_wp_trash_meta_status', 'publish'),
 (1222, 759, '_wp_trash_meta_time', '1508773683'),
 (1223, 759, '_wp_desired_post_slug', 'lichen-i-xiv-ogolnopolska-pielgrzymka-honorowych-dawcow-krwi'),
 (1224, 757, '_wp_trash_meta_status', 'publish'),
 (1225, 757, '_wp_trash_meta_time', '1508773683'),
 (1226, 757, '_wp_desired_post_slug', 'kilka-tysiecy-uczestniczek-na-zjezdzie-kol-gospodyn-wiejskich'),
 (1227, 755, '_wp_trash_meta_status', 'publish'),
 (1228, 755, '_wp_trash_meta_time', '1508773683'),
 (1229, 755, '_wp_desired_post_slug', 'szesciu-szachistow-na-podium-szach-strike-mat-w-poznaniu'),
 (1230, 753, '_wp_trash_meta_status', 'publish'),
 (1231, 753, '_wp_trash_meta_time', '1508773683'),
 (1232, 753, '_wp_desired_post_slug', 'wygrana-z-huta-lukomska'),
 (1233, 751, '_wp_trash_meta_status', 'publish'),
 (1234, 751, '_wp_trash_meta_time', '1508773683'),
 (1235, 751, '_wp_desired_post_slug', 'kto-zostal-rolnikiem-roku-a-kto-wykonal-najpiekniejszy-wieniec-dozynki-powiatowe'),
 (1236, 747, '_wp_trash_meta_status', 'publish'),
 (1237, 747, '_wp_trash_meta_time', '1508773683'),
 (1238, 747, '_wp_desired_post_slug', 'gospodynie-z-calej-polski-przyjechaly-do-lichenia'),
 (1239, 745, '_wp_trash_meta_status', 'publish'),
 (1240, 745, '_wp_trash_meta_time', '1508773683'),
 (1241, 745, '_wp_desired_post_slug', 'ahoj-przygodo-poplyneli-kajakami-z-mikorzyna-do-konina'),
 (1242, 745, '_wp_trash_meta_comments_status', 'a:1:{i:9;s:1:"1";}'),
 (1243, 743, '_wp_trash_meta_status', 'publish'),
 (1244, 743, '_wp_trash_meta_time', '1508773683'),
 (1245, 743, '_wp_desired_post_slug', 'zaproszenie-na-iv-jarmark-ochwesnicki'),
 (1246, 743, '_wp_trash_meta_comments_status', 'a:1:{i:8;s:1:"1";}'),
 (1247, 736, '_wp_trash_meta_status', 'publish'),
 (1248, 736, '_wp_trash_meta_time', '1508773683'),
 (1249, 736, '_wp_desired_post_slug', 'walczyli-w-powiatowych-zawodach'),
 (1250, 729, '_wp_trash_meta_status', 'publish'),
 (1251, 729, '_wp_trash_meta_time', '1508773683'),
 (1252, 729, '_wp_desired_post_slug', 'dzien-sportu-na-orliku'),
 (1253, 726, '_wp_trash_meta_status', 'publish'),
 (1254, 726, '_wp_trash_meta_time', '1508773696'),
 (1255, 726, '_wp_desired_post_slug', 'rusza-remont-ulicy-przemyslowej-i-slesinskiej-w-koninie'),
 (1256, 724, '_wp_trash_meta_status', 'publish'),
 (1257, 724, '_wp_trash_meta_time', '1508773696'),
 (1258, 724, '_wp_desired_post_slug', 'radni-powiatowi-wsparli-strazakow-ochotnikow'),
 (1259, 722, '_wp_trash_meta_status', 'publish'),
 (1260, 722, '_wp_trash_meta_time', '1508773696'),
 (1261, 722, '_wp_desired_post_slug', 'lks-zagra-z-huta-lukomska'),
 (1262, 720, '_wp_trash_meta_status', 'publish'),
 (1263, 720, '_wp_trash_meta_time', '1508773696'),
 (1264, 720, '_wp_desired_post_slug', 'slawomir-peszko-otwarcie-o-inspiracji-akademia-pilkarska-reissa'),
 (1265, 718, '_wp_trash_meta_status', 'publish'),
 (1266, 718, '_wp_trash_meta_time', '1508773696'),
 (1267, 718, '_wp_desired_post_slug', 'lks-slesin-wygral-ze-strazakiem-lichen'),
 (1268, 713, '_wp_trash_meta_status', 'publish'),
 (1269, 713, '_wp_trash_meta_time', '1508773696'),
 (1270, 713, '_wp_desired_post_slug', 'kolejna-akcja-za-nami'),
 (1271, 710, '_wp_trash_meta_status', 'publish'),
 (1272, 710, '_wp_trash_meta_time', '1508773696'),
 (1273, 710, '_wp_desired_post_slug', 'nabor-do-klubu-szachowego'),
 (1274, 708, '_wp_trash_meta_status', 'publish'),
 (1275, 708, '_wp_trash_meta_time', '1508773696'),
 (1276, 708, '_wp_desired_post_slug', 'zajecia-plastyczne'),
 (1277, 704, '_wp_trash_meta_status', 'publish'),
 (1278, 704, '_wp_trash_meta_time', '1508773696'),
 (1279, 704, '_wp_desired_post_slug', 'splywe-kajakowy-9-wrzesnia'),
 (1280, 702, '_wp_trash_meta_status', 'publish'),
 (1281, 702, '_wp_trash_meta_time', '1508773696'),
 (1282, 702, '_wp_desired_post_slug', 'vii-ogolnopolski-zjazd-kol-gospodyn'),
 (1283, 697, '_wp_trash_meta_status', 'publish'),
 (1284, 697, '_wp_trash_meta_time', '1508773696'),
 (1285, 697, '_wp_desired_post_slug', 'strazacy-ochotnicy-rywalizuja'),
 (1286, 692, '_wp_trash_meta_status', 'publish'),
 (1287, 692, '_wp_trash_meta_time', '1508773696'),
 (1288, 692, '_wp_desired_post_slug', 'swieto-kapusty-w-honoratce'),
 (1289, 690, '_wp_trash_meta_status', 'publish'),
 (1290, 690, '_wp_trash_meta_time', '1508773696'),
 (1291, 690, '_wp_desired_post_slug', 'runda-ix-w-niedziele-10-wrzesnia'),
 (1292, 688, '_wp_trash_meta_status', 'publish'),
 (1293, 688, '_wp_trash_meta_time', '1508773696'),
 (1294, 688, '_wp_desired_post_slug', 'piec-razy-podium'),
 (1295, 686, '_wp_trash_meta_status', 'publish'),
 (1296, 686, '_wp_trash_meta_time', '1508773696'),
 (1297, 686, '_wp_desired_post_slug', 'przyjacielska-polsko-japonska-wizyta-w-lichenskim-sanktuarium'),
 (1298, 682, '_wp_trash_meta_status', 'publish'),
 (1299, 682, '_wp_trash_meta_time', '1508773696'),
 (1300, 682, '_wp_desired_post_slug', 'tabela-soleckiej-ligi-pilki-noznej'),
 (1301, 680, '_wp_trash_meta_status', 'publish'),
 (1302, 680, '_wp_trash_meta_time', '1508773696'),
 (1303, 680, '_wp_desired_post_slug', '2-wrzesnia-akcja-poboru-krwi'),
 (1304, 676, '_wp_trash_meta_status', 'publish'),
 (1305, 676, '_wp_trash_meta_time', '1508773696'),
 (1306, 676, '_wp_desired_post_slug', 'pozegnanie-wakacji'),
 (1307, 674, '_wp_trash_meta_status', 'publish'),
 (1308, 674, '_wp_trash_meta_time', '1508773696'),
 (1309, 674, '_wp_desired_post_slug', 'viiprzeglad-zespolow-artstycznych'),
 (1310, 672, '_wp_trash_meta_status', 'publish'),
 (1311, 672, '_wp_trash_meta_time', '1508773696'),
 (1312, 672, '_wp_desired_post_slug', 'dozynki-ostrowaz'),
 (1313, 670, '_wp_trash_meta_status', 'publish'),
 (1314, 670, '_wp_trash_meta_time', '1508773703'),
 (1315, 670, '_wp_desired_post_slug', 'rozgrywka-miedzy-slesinem-a-licheniem'),
 (1316, 668, '_wp_trash_meta_status', 'publish'),
 (1317, 668, '_wp_trash_meta_time', '1508773703'),
 (1318, 668, '_wp_desired_post_slug', 'dozynki-chlebem-pachnace'),
 (1319, 660, '_wp_trash_meta_status', 'publish'),
 (1320, 660, '_wp_trash_meta_time', '1508773703'),
 (1321, 660, '_wp_desired_post_slug', 'piknik-z-mama-i-tata'),
 (1322, 658, '_wp_trash_meta_status', 'publish'),
 (1323, 658, '_wp_trash_meta_time', '1508773703'),
 (1324, 658, '_wp_desired_post_slug', 'udana-inauguracja-ligi'),
 (1325, 656, '_wp_trash_meta_status', 'publish'),
 (1326, 656, '_wp_trash_meta_time', '1508773703'),
 (1327, 656, '_wp_desired_post_slug', 'swieto-jablka-2017'),
 (1328, 649, '_wp_trash_meta_status', 'publish'),
 (1329, 649, '_wp_trash_meta_time', '1508773703'),
 (1330, 649, '_wp_desired_post_slug', 'dziewiec-wiencow-dozynkowych-walczylo-o-tytul-najpiekniejszego'),
 (1331, 651, '_wp_trash_meta_status', 'publish'),
 (1332, 651, '_wp_trash_meta_time', '1508773703'),
 (1333, 651, '_wp_desired_post_slug', 'plener-malarski-w-licheniu'),
 (1334, 647, '_wp_trash_meta_status', 'publish'),
 (1335, 647, '_wp_trash_meta_time', '1508773703'),
 (1336, 647, '_wp_desired_post_slug', 'zwyciestwo-z-wierzbinkiem'),
 (1337, 642, '_wp_trash_meta_status', 'publish'),
 (1338, 642, '_wp_trash_meta_time', '1508773703'),
 (1339, 642, '_wp_desired_post_slug', 'narodowe-czytanie-2017'),
 (1340, 639, '_wp_trash_meta_status', 'publish'),
 (1341, 639, '_wp_trash_meta_time', '1508773703'),
 (1342, 639, '_wp_desired_post_slug', '8-runda-ligi-soleckiej'),
 (1343, 639, '_wp_trash_meta_comments_status', 'a:1:{i:7;s:1:"1";}'),
 (1344, 628, '_wp_trash_meta_status', 'publish'),
 (1345, 628, '_wp_trash_meta_time', '1508773703'),
 (1346, 628, '_wp_desired_post_slug', 'lks-w-kolejnej-rundzie-pucharu'),
 (1347, 620, '_wp_trash_meta_status', 'publish'),
 (1348, 620, '_wp_trash_meta_time', '1508773703'),
 (1349, 620, '_wp_desired_post_slug', 'strzelcy-rekrutuja'),
 (1350, 612, '_wp_trash_meta_status', 'publish'),
 (1351, 612, '_wp_trash_meta_time', '1508773703'),
 (1352, 612, '_wp_desired_post_slug', 'piknik-z-mama-i-tata-przed-lichenska-bazylika'),
 (1353, 610, '_wp_trash_meta_status', 'publish'),
 (1354, 610, '_wp_trash_meta_time', '1508773703'),
 (1355, 610, '_wp_desired_post_slug', 'xxxii-sesja-rady-miejskiej-gminy-slesin'),
 (1356, 608, '_wp_trash_meta_status', 'publish'),
 (1357, 608, '_wp_trash_meta_time', '1508773703'),
 (1358, 608, '_wp_desired_post_slug', 'ocalic-od-zapomnienia-konkurs-fotograficzny-dla-seniorow'),
 (1359, 602, '_wp_trash_meta_status', 'publish'),
 (1360, 602, '_wp_trash_meta_time', '1508773703'),
 (1361, 602, '_wp_desired_post_slug', 'w-najblizszy-czwartek-festiwal-jakiego-jeszcze-nie-bylo'),
 (1362, 600, '_wp_trash_meta_status', 'publish'),
 (1363, 600, '_wp_trash_meta_time', '1508773703'),
 (1364, 600, '_wp_desired_post_slug', 'golina-pokonana'),
 (1365, 597, '_wp_trash_meta_status', 'publish'),
 (1366, 597, '_wp_trash_meta_time', '1508773703'),
 (1367, 597, '_wp_desired_post_slug', 'falstart-na-inauguracje-sezonu'),
 (1368, 587, '_wp_trash_meta_status', 'publish'),
 (1369, 587, '_wp_trash_meta_time', '1508773703'),
 (1370, 587, '_wp_desired_post_slug', 'spektakl-o-lichenskich-objawieniach'),
 (1371, 580, '_wp_trash_meta_status', 'publish'),
 (1372, 580, '_wp_trash_meta_time', '1508773703'),
 (1373, 580, '_wp_desired_post_slug', 'dozynki-gminno-parafialne'),
 (1374, 589, '_wp_trash_meta_status', 'publish'),
 (1375, 589, '_wp_trash_meta_time', '1508773711'),
 (1376, 589, '_wp_desired_post_slug', '589'),
 (1377, 578, '_wp_trash_meta_status', 'publish'),
 (1378, 578, '_wp_trash_meta_time', '1508773711'),
 (1379, 578, '_wp_desired_post_slug', 'runda-siodma-20-sierpnia'),
 (1380, 578, '_wp_trash_meta_comments_status', 'a:1:{i:6;s:1:"1";}'),
 (1381, 574, '_wp_trash_meta_status', 'publish'),
 (1382, 574, '_wp_trash_meta_time', '1508773711'),
 (1383, 574, '_wp_desired_post_slug', 'festyn-w-szyszynie-2'),
 (1384, 576, '_wp_trash_meta_status', 'publish'),
 (1385, 576, '_wp_trash_meta_time', '1508773711'),
 (1386, 576, '_wp_desired_post_slug', 'zajecia-w-m-gok-slesin-w-roku-kulturalnym-20172018'),
 (1387, 568, '_wp_trash_meta_status', 'publish'),
 (1388, 568, '_wp_trash_meta_time', '1508773711'),
 (1389, 568, '_wp_desired_post_slug', 'turystyczne-turnee-po-powiecie'),
 (1390, 565, '_wp_trash_meta_status', 'publish'),
 (1391, 565, '_wp_trash_meta_time', '1508773711'),
 (1392, 565, '_wp_desired_post_slug', '50-lecie-koronacji-cudownego-obrazu-matki-bozej-lichenskiej-na-kartce-pocztowej'),
 (1393, 562, '_wp_trash_meta_status', 'publish'),
 (1394, 562, '_wp_trash_meta_time', '1508773711'),
 (1395, 562, '_wp_desired_post_slug', 'policjanci-podsumowali-dlugi-weekend'),
 (1396, 553, '_wp_trash_meta_status', 'publish'),
 (1397, 553, '_wp_trash_meta_time', '1508773711'),
 (1398, 553, '_wp_desired_post_slug', 'wiecej-informacji-o-odkrywce-oscislowo'),
 (1399, 554, '_wp_trash_meta_status', 'publish'),
 (1400, 554, '_wp_trash_meta_time', '1508773711'),
 (1401, 554, '_wp_desired_post_slug', 'pomoc-dla-poszkodowanych'),
 (1402, 546, '_wp_trash_meta_status', 'publish'),
 (1403, 546, '_wp_trash_meta_time', '1508773711'),
 (1404, 546, '_wp_desired_post_slug', 'uroczystosc-wniebowziecia-najswietszej-maryi-panny-z-udzialem-kard-stanislawa-dziwisza'),
 (1405, 544, '_wp_trash_meta_status', 'publish'),
 (1406, 544, '_wp_trash_meta_time', '1508773711'),
 (1407, 544, '_wp_desired_post_slug', 'nieszpory-i-msza-sw-pod-przewodnictwem-abpa-wojciecha-polaka-prymasa-polski'),
 (1408, 538, '_wp_trash_meta_status', 'publish'),
 (1409, 538, '_wp_trash_meta_time', '1508773711'),
 (1410, 538, '_wp_desired_post_slug', 'soltysi-wymachiwali-pieczatka-i-ujezdzali-konie'),
 (1411, 532, '_wp_trash_meta_status', 'publish'),
 (1412, 532, '_wp_trash_meta_time', '1508773711'),
 (1413, 532, '_wp_desired_post_slug', 'jedna-z-najgrozniejszych-burz-ostatnich-lat-w-gminie-slesin'),
 (1414, 530, '_wp_trash_meta_status', 'publish'),
 (1415, 530, '_wp_trash_meta_time', '1508773711'),
 (1416, 530, '_wp_desired_post_slug', 'nuncjusz-apostolski-w-polsce-modlil-sie-w-licheniu'),
 (1417, 528, '_wp_trash_meta_status', 'publish'),
 (1418, 528, '_wp_trash_meta_time', '1508773711'),
 (1419, 528, '_wp_desired_post_slug', 'drugi-dzien-obchodow-zlotego-jubileuszu-koronacji'),
 (1420, 526, '_wp_trash_meta_status', 'publish'),
 (1421, 526, '_wp_trash_meta_time', '1508773711'),
 (1422, 526, '_wp_desired_post_slug', 'w-sobote-calodniowa-ewangelizacja-w-lichenskim-sanktuarium'),
 (1423, 520, '_wp_trash_meta_status', 'publish'),
 (1424, 520, '_wp_trash_meta_time', '1508773711'),
 (1425, 520, '_wp_desired_post_slug', 'uroczystosci-rocznicowe-w-licheniu-ta-msza-rozpoczynamy-swietowanie'),
 (1426, 514, '_wp_trash_meta_status', 'publish'),
 (1427, 514, '_wp_trash_meta_time', '1508773711'),
 (1428, 514, '_wp_desired_post_slug', 'po-nawalnicy-powalone-drzew-a-slesin-bez-pradu-i-wody'),
 (1429, 512, '_wp_trash_meta_status', 'publish'),
 (1430, 512, '_wp_trash_meta_time', '1508773712'),
 (1431, 512, '_wp_desired_post_slug', 'warsztaty-pisania-ikon'),
 (1432, 510, '_wp_trash_meta_status', 'publish'),
 (1433, 510, '_wp_trash_meta_time', '1508773712'),
 (1434, 510, '_wp_desired_post_slug', 'badania-statystyczne-w-wielkopolsce'),
 (1435, 502, '_wp_trash_meta_status', 'publish'),
 (1436, 502, '_wp_trash_meta_time', '1508773720'),
 (1437, 502, '_wp_desired_post_slug', 'trwa-usuwanie-skutkow-nawalnicy'),
 (1438, 498, '_wp_trash_meta_status', 'publish'),
 (1439, 498, '_wp_trash_meta_time', '1508773720'),
 (1440, 498, '_wp_desired_post_slug', 'czlowieczy-los'),
 (1441, 494, '_wp_trash_meta_status', 'publish'),
 (1442, 494, '_wp_trash_meta_time', '1508773720'),
 (1443, 494, '_wp_desired_post_slug', 'wypadek-na-kleczewskiej'),
 (1444, 483, '_wp_trash_meta_status', 'publish'),
 (1445, 483, '_wp_trash_meta_time', '1508773720'),
 (1446, 483, '_wp_desired_post_slug', 'transmisja-mszy-sw-z-lichenia'),
 (1447, 474, '_wp_trash_meta_status', 'publish'),
 (1448, 474, '_wp_trash_meta_time', '1508773720'),
 (1449, 474, '_wp_desired_post_slug', '50-rocznica-koronacji-cudownego-obrazu-mbl'),
 (1450, 466, '_wp_trash_meta_status', 'publish'),
 (1451, 466, '_wp_trash_meta_time', '1508773720'),
 (1452, 466, '_wp_desired_post_slug', 'w-przydomowym-warsztacie-odtwarza-latajacego-orlika'),
 (1453, 463, '_wp_trash_meta_status', 'publish'),
 (1454, 463, '_wp_trash_meta_time', '1508773720'),
 (1455, 463, '_wp_desired_post_slug', 'za-nami-xx-piknik-klubow-seniora'),
 (1456, 451, '_wp_trash_meta_status', 'publish'),
 (1457, 451, '_wp_trash_meta_time', '1508773720'),
 (1458, 451, '_wp_desired_post_slug', 'festyn-w-biskupiu'),
 (1459, 443, '_wp_trash_meta_status', 'publish'),
 (1460, 443, '_wp_trash_meta_time', '1508773720'),
 (1461, 443, '_wp_desired_post_slug', 'trwa-remont-urzedu-na-jakim-etapie-sa-prace'),
 (1462, 446, '_wp_trash_meta_status', 'publish'),
 (1463, 446, '_wp_trash_meta_time', '1508773720'),
 (1464, 446, '_wp_desired_post_slug', 'dj-wika-przyjechala-do-slesina'),
 (1465, 401, '_wp_trash_meta_status', 'publish'),
 (1466, 401, '_wp_trash_meta_time', '1508773720'),
 (1467, 401, '_wp_desired_post_slug', 'festyn-w-szyszynie'),
 (1468, 364, '_wp_trash_meta_status', 'publish'),
 (1469, 364, '_wp_trash_meta_time', '1508773720'),
 (1470, 364, '_wp_desired_post_slug', 'runda-szosta-bedzie-rozegrana-6-sierpnia'),
 (1471, 364, '_wp_trash_meta_comments_status', 'a:2:{i:4;s:1:"1";i:5;s:1:"1";}'),
 (1472, 136, '_wp_trash_meta_status', 'publish'),
 (1473, 136, '_wp_trash_meta_time', '1508773720'),
 (1474, 136, '_wp_desired_post_slug', 'slesinski-festiwal-piwa-2'),
 (1475, 136, '_wp_trash_meta_comments_status', 'a:1:{i:3;s:1:"1";}'),
 (1476, 480, '_wp_trash_meta_status', 'publish'),
 (1477, 480, '_wp_trash_meta_time', '1508773720'),
 (1478, 480, '_wp_desired_post_slug', 'smiertelny-wypadek-w-mikorzynie'),
 (1479, 485, '_wp_trash_meta_status', 'publish'),
 (1480, 485, '_wp_trash_meta_time', '1508773720'),
 (1481, 485, '_wp_desired_post_slug', 'wypadek-na-ulicy-koninskiej-w-licheniu-starym'),
 (1482, 79, '_wp_trash_meta_status', 'publish'),
 (1483, 79, '_wp_trash_meta_time', '1508773720'),
 (1484, 79, '_wp_desired_post_slug', 'turniej-siatkowki-plazowej-w-szyszynie'),
 (1485, 77, '_wp_trash_meta_status', 'publish'),
 (1486, 77, '_wp_trash_meta_time', '1508773720'),
 (1487, 77, '_wp_desired_post_slug', 'turniej-wykop-cukrzyce'),
 (1488, 74, '_wp_trash_meta_status', 'publish'),
 (1489, 74, '_wp_trash_meta_time', '1508773720'),
 (1490, 74, '_wp_desired_post_slug', 'pod-presja-i-bez-strachu'),
 (1491, 72, '_wp_trash_meta_status', 'publish'),
 (1492, 72, '_wp_trash_meta_time', '1508773720'),
 (1493, 72, '_wp_desired_post_slug', 'piata-runda-23-lipca'),
 (1494, 72, '_wp_trash_meta_comments_status', 'a:1:{i:2;s:1:"1";}'),
 (1495, 69, '_wp_trash_meta_status', 'publish'),
 (1496, 69, '_wp_trash_meta_time', '1508773720'),
 (1497, 69, '_wp_desired_post_slug', 'xxxi-sesja-rady-miejskiej-gminy-slesin'),
 (1498, 67, '_wp_trash_meta_status', 'publish'),
 (1499, 67, '_wp_trash_meta_time', '1508773816'),
 (1500, 67, '_wp_desired_post_slug', 'urzad-z-widokiem-na-plaze'),
 (1501, 64, '_wp_trash_meta_status', 'publish'),
 (1502, 64, '_wp_trash_meta_time', '1508773816'),
 (1503, 64, '_wp_desired_post_slug', 'xx-wakacyjny-piknik-klubow-seniora'),
 (1504, 61, '_wp_trash_meta_status', 'publish'),
 (1505, 61, '_wp_trash_meta_time', '1508773816'),
 (1506, 61, '_wp_desired_post_slug', 'jechali-przez-tydzien-pielgrzymka-rowerowa-w-sanktuarium'),
 (1507, 57, '_wp_trash_meta_status', 'publish'),
 (1508, 57, '_wp_trash_meta_time', '1508773816'),
 (1509, 57, '_wp_desired_post_slug', 'zjazd-kol-gospodyn-wiejskich-lichen-2017'),
 (1510, 54, '_wp_trash_meta_status', 'publish'),
 (1511, 54, '_wp_trash_meta_time', '1508773816'),
 (1512, 54, '_wp_desired_post_slug', 'trwa-przebudowa-drogi-prowadzacej-do-sanktuarium'),
 (1513, 52, '_wp_trash_meta_status', 'publish'),
 (1514, 52, '_wp_trash_meta_time', '1508773816'),
 (1515, 52, '_wp_desired_post_slug', 'wizyta-w-skansenie-w-klobce'),
 (1516, 48, '_wp_trash_meta_status', 'publish'),
 (1517, 48, '_wp_trash_meta_time', '1508773816'),
 (1518, 48, '_wp_desired_post_slug', 'jubileuszowa-pielgrzymka-soltysow-i-srodowisk-wiejskich'),
 (1519, 46, '_wp_trash_meta_status', 'publish'),
 (1520, 46, '_wp_trash_meta_time', '1508773816'),
 (1521, 46, '_wp_desired_post_slug', 'slesinski-festiwal-piwa'),
 (1522, 39, '_wp_trash_meta_status', 'publish'),
 (1523, 39, '_wp_trash_meta_time', '1508773816'),
 (1524, 39, '_wp_desired_post_slug', 'w-najblizsza-niedziele-iv-runda-ligi-soleckiej'),
 (1525, 35, '_wp_trash_meta_status', 'publish'),
 (1526, 35, '_wp_trash_meta_time', '1508773817'),
 (1527, 35, '_wp_desired_post_slug', 'podsumowanie-jubileuszu-30-lecia-klubu-szachowego-m-gok-gambit-slesin'),
 (1528, 33, '_wp_trash_meta_status', 'publish'),
 (1529, 33, '_wp_trash_meta_time', '1508773817'),
 (1530, 33, '_wp_desired_post_slug', 'wakacyjny-aerobik'),
 (1531, 25, '_wp_trash_meta_status', 'publish'),
 (1532, 25, '_wp_trash_meta_time', '1508773817'),
 (1533, 25, '_wp_desired_post_slug', 'wierni-przeszli-pod-brama-milosierdzia'),
 (1534, 468, '_wp_trash_meta_status', 'publish'),
 (1535, 468, '_wp_trash_meta_time', '1508773817'),
 (1536, 468, '_wp_desired_post_slug', 'lks-slesin-wciaz-atrakcyjny'),
 (1537, 1, '_wp_trash_meta_status', 'publish'),
 (1538, 1, '_wp_trash_meta_time', '1508773817'),
 (1539, 1, '_wp_desired_post_slug', 'hello-world'),
 (1540, 1, '_wp_trash_meta_comments_status', 'a:1:{i:1;s:1:"1";}'),
 (1541, 1060, '_edit_last', '1'),
 (1542, 1060, '_edit_lock', '1508774124:1'),
 (1547, 1064, '_edit_last', '1'),
 (1548, 1064, '_edit_lock', '1508774317:1'),
 (1551, 1066, '_edit_last', '1'),
 (1552, 1066, '_edit_lock', '1508774453:1'),
 (1553, 1066, '_oembed_d458da4133a1ca93881fc54959b74838', '<div id="fb-root"></div><script>(function(d, s, id) {  var js, fjs = d.getElementsByTagName(s)[0];  if (d.getElementById(id)) return;  js = d.createElement(s); js.id = id;  js.src = \'https://connect.facebook.net/pl_PL/sdk.js#xfbml=1&version=v2.10\';  fjs.parentNode.insertBefore(js, fjs);}(document, \'script\', \'facebook-jssdk\'));</script><div class="fb-video" data-href="https://www.facebook.com/WeatherChannelOriginals/videos/1651628711524295/" data-width="500"><blockquote cite="https://www.facebook.com/WeatherChannelOriginals/videos/1651628711524295/" class="fb-xfbml-parse-ignore"><a href="https://www.facebook.com/WeatherChannelOriginals/videos/1651628711524295/"></a><p>Can you spot this woman trying to escape from a mudslide? We have a Weather Gone Viral marathon this Sunday starting at 1 pm and a brand new episode at 8 pm (ET)!</p>Opublikowany przez <a href="https://www.facebook.com/WeatherChannelOriginals/">The Weather Channel Originals</a> na 21 października 2017</blockquote></div>'),
 (1554, 1066, '_oembed_time_d458da4133a1ca93881fc54959b74838', '1508774579'),
 (1557, 1068, '_edit_last', '1'),
 (1558, 1068, '_edit_lock', '1508952073:1'),
 (1561, 1070, '_wp_trash_meta_status', 'publish'),
 (1562, 1070, '_wp_trash_meta_time', '1508775158'),
 (1563, 1071, '_wp_trash_meta_status', 'publish'),
 (1564, 1071, '_wp_trash_meta_time', '1508775230'),
 (1565, 1072, '_wp_trash_meta_status', 'publish'),
 (1566, 1072, '_wp_trash_meta_time', '1508775433'),
 (1567, 1073, '_wp_trash_meta_status', 'publish'),
 (1568, 1073, '_wp_trash_meta_time', '1508775678'),
 (1569, 1074, '_wp_trash_meta_status', 'publish'),
 (1570, 1074, '_wp_trash_meta_time', '1508777943'),
 (1571, 1075, '_wp_trash_meta_status', 'publish'),
 (1572, 1075, '_wp_trash_meta_time', '1508778176'),
 (1573, 215, '_wp_trash_meta_status', 'publish'),
 (1574, 215, '_wp_trash_meta_time', '1508872275'),
 (1575, 215, '_wp_desired_post_slug', 'adresy'),
 (1576, 217, '_wp_trash_meta_status', 'publish'),
 (1577, 217, '_wp_trash_meta_time', '1508872275'),
 (1578, 217, '_wp_desired_post_slug', 'apteki'),
 (1579, 222, '_wp_trash_meta_status', 'publish'),
 (1580, 222, '_wp_trash_meta_time', '1508872275'),
 (1581, 222, '_wp_desired_post_slug', 'biblioteki'),
 (1582, 224, '_wp_trash_meta_status', 'publish'),
 (1583, 224, '_wp_trash_meta_time', '1508872275'),
 (1584, 224, '_wp_desired_post_slug', 'dom-kultury'),
 (1585, 226, '_wp_trash_meta_status', 'publish'),
 (1586, 226, '_wp_trash_meta_time', '1508872275'),
 (1587, 226, '_wp_desired_post_slug', 'dom-opieki-spolecznej'),
 (1588, 228, '_wp_trash_meta_status', 'publish'),
 (1589, 228, '_wp_trash_meta_time', '1508872275'),
 (1590, 228, '_wp_desired_post_slug', 'klinika-weterynaryjna'),
 (1591, 231, '_wp_trash_meta_status', 'publish'),
 (1592, 231, '_wp_trash_meta_time', '1508872275'),
 (1593, 231, '_wp_desired_post_slug', 'koscioly'),
 (1594, 241, '_wp_trash_meta_status', 'publish'),
 (1595, 241, '_wp_trash_meta_time', '1508872275'),
 (1596, 241, '_wp_desired_post_slug', 'osrodki-zdrowia'),
 (1597, 233, '_wp_trash_meta_status', 'publish'),
 (1598, 233, '_wp_trash_meta_time', '1508872275'),
 (1599, 233, '_wp_desired_post_slug', 'poczta'),
 (1600, 235, '_wp_trash_meta_status', 'publish'),
 (1601, 235, '_wp_trash_meta_time', '1508872275'),
 (1602, 235, '_wp_desired_post_slug', 'pogotowie-energetyczne'),
 (1603, 237, '_wp_trash_meta_status', 'publish'),
 (1604, 237, '_wp_trash_meta_time', '1508872276'),
 (1605, 237, '_wp_desired_post_slug', 'policja'),
 (1606, 239, '_wp_trash_meta_status', 'publish'),
 (1607, 239, '_wp_trash_meta_time', '1508872276'),
 (1608, 239, '_wp_desired_post_slug', 'pomoc-drogowa'),
 (1609, 245, '_wp_trash_meta_status', 'publish'),
 (1610, 245, '_wp_trash_meta_time', '1508872276'),
 (1611, 245, '_wp_desired_post_slug', 'straz-pozarna'),
 (1612, 248, '_wp_trash_meta_status', 'publish'),
 (1613, 248, '_wp_trash_meta_time', '1508872276'),
 (1614, 248, '_wp_desired_post_slug', 'urzad-miasta-i-gminy-slesin'),
 (1615, 251, '_wp_trash_meta_status', 'publish'),
 (1616, 251, '_wp_trash_meta_time', '1508872276'),
 (1617, 251, '_wp_desired_post_slug', 'archiwum'),
 (1618, 622, '_wp_trash_meta_status', 'publish'),
 (1619, 622, '_wp_trash_meta_time', '1508872276'),
 (1620, 622, '_wp_desired_post_slug', 'about'),
 (1621, 85, '_wp_trash_meta_status', 'publish'),
 (1622, 85, '_wp_trash_meta_time', '1508872276'),
 (1623, 85, '_wp_desired_post_slug', 'historia'),
 (1624, 207, '_wp_trash_meta_status', 'publish'),
 (1625, 207, '_wp_trash_meta_time', '1508872276'),
 (1626, 207, '_wp_desired_post_slug', 'komunikacja'),
 (1627, 318, '_wp_trash_meta_status', 'publish'),
 (1628, 318, '_wp_trash_meta_time', '1508872276'),
 (1629, 318, '_wp_desired_post_slug', 'lichen'),
 (1630, 320, '_wp_trash_meta_status', 'publish'),
 (1631, 320, '_wp_trash_meta_time', '1508872276'),
 (1632, 320, '_wp_desired_post_slug', 'bazylika'),
 (1633, 253, '_wp_trash_meta_status', 'publish'),
 (1634, 253, '_wp_trash_meta_time', '1508872283'),
 (1635, 253, '_wp_desired_post_slug', 'o-gminie'),
 (1636, 312, '_wp_trash_meta_status', 'publish'),
 (1637, 312, '_wp_trash_meta_time', '1508872283'),
 (1638, 312, '_wp_desired_post_slug', 'funkcje'),
 (1639, 213, '_wp_trash_meta_status', 'publish'),
 (1640, 213, '_wp_trash_meta_time', '1508872283'),
 (1641, 213, '_wp_desired_post_slug', 'galeria'),
 (1642, 290, '_wp_trash_meta_status', 'publish'),
 (1643, 290, '_wp_trash_meta_time', '1508872283'),
 (1644, 290, '_wp_desired_post_slug', 'gleby'),
 (1645, 270, '_wp_trash_meta_status', 'publish'),
 (1646, 270, '_wp_trash_meta_time', '1508872283'),
 (1647, 270, '_wp_desired_post_slug', 'jezioro-lichenskie'),
 (1648, 274, '_wp_trash_meta_status', 'publish'),
 (1649, 274, '_wp_trash_meta_time', '1508872283'),
 (1650, 274, '_wp_desired_post_slug', 'jezioro-mikorzynskie'),
 (1651, 272, '_wp_trash_meta_status', 'publish'),
 (1652, 272, '_wp_trash_meta_time', '1508872283'),
 (1653, 272, '_wp_desired_post_slug', 'jezioro-slesinskie'),
 (1654, 277, '_wp_trash_meta_status', 'publish'),
 (1655, 277, '_wp_trash_meta_time', '1508872283'),
 (1656, 277, '_wp_desired_post_slug', 'kanal-slesinski'),
 (1657, 284, '_wp_trash_meta_status', 'publish'),
 (1658, 284, '_wp_trash_meta_time', '1508872283'),
 (1659, 284, '_wp_desired_post_slug', '284-2'),
 (1660, 314, '_wp_trash_meta_status', 'publish'),
 (1661, 314, '_wp_trash_meta_time', '1508872283'),
 (1662, 314, '_wp_desired_post_slug', 'przeksztalcenia-antropologiczne'),
 (1663, 310, '_wp_trash_meta_status', 'publish'),
 (1664, 310, '_wp_trash_meta_time', '1508872283'),
 (1665, 310, '_wp_desired_post_slug', 'siec-komunikacyjna'),
 (1666, 305, '_wp_trash_meta_status', 'publish'),
 (1667, 305, '_wp_trash_meta_time', '1508872283'),
 (1668, 305, '_wp_desired_post_slug', 'srodowisko-geograficzne'),
 (1669, 307, '_wp_trash_meta_status', 'publish'),
 (1670, 307, '_wp_trash_meta_time', '1508872283'),
 (1671, 307, '_wp_desired_post_slug', 'srodowisko-przyrodnicze'),
 (1672, 288, '_wp_trash_meta_status', 'publish'),
 (1673, 288, '_wp_trash_meta_time', '1508872283'),
 (1674, 288, '_wp_desired_post_slug', 'surowce-mineralne'),
 (1675, 292, '_wp_trash_meta_status', 'publish'),
 (1676, 292, '_wp_trash_meta_time', '1508872283'),
 (1677, 292, '_wp_desired_post_slug', 'szata-roslinna'),
 (1678, 255, '_wp_trash_meta_status', 'publish'),
 (1679, 255, '_wp_trash_meta_time', '1508872283'),
 (1680, 255, '_wp_desired_post_slug', 'polozenie'),
 (1681, 259, '_wp_trash_meta_status', 'publish'),
 (1682, 259, '_wp_trash_meta_time', '1508872283'),
 (1683, 259, '_wp_desired_post_slug', 'kuchnia-ochwesnicka'),
 (1684, 261, '_wp_trash_meta_status', 'publish'),
 (1685, 261, '_wp_trash_meta_time', '1508872283'),
 (1686, 261, '_wp_desired_post_slug', 'rzezba-terenu'),
 (1687, 263, '_wp_trash_meta_status', 'publish'),
 (1688, 263, '_wp_trash_meta_time', '1508872283'),
 (1689, 263, '_wp_desired_post_slug', 'krajobraz'),
 (1690, 267, '_wp_trash_meta_status', 'publish'),
 (1691, 267, '_wp_trash_meta_time', '1508872283'),
 (1692, 267, '_wp_desired_post_slug', 'klimat'),
 (1693, 368, '_wp_trash_meta_status', 'publish'),
 (1694, 368, '_wp_trash_meta_time', '1508872288'),
 (1695, 368, '_wp_desired_post_slug', 'awpcp'),
 (1696, 377, '_wp_trash_meta_status', 'publish'),
 (1697, 377, '_wp_trash_meta_time', '1508872288'),
 (1698, 377, '_wp_desired_post_slug', 'anulowanie-platnosci'),
 (1699, 371, '_wp_trash_meta_status', 'publish'),
 (1700, 371, '_wp_trash_meta_time', '1508872288'),
 (1701, 371, '_wp_desired_post_slug', 'edytuj-ogloszenie'),
 (1702, 373, '_wp_trash_meta_status', 'publish'),
 (1703, 373, '_wp_trash_meta_time', '1508872288'),
 (1704, 373, '_wp_desired_post_slug', 'odnow-ogloszenie'),
 (1705, 370, '_wp_trash_meta_status', 'publish'),
 (1706, 370, '_wp_trash_meta_time', '1508872288'),
 (1707, 370, '_wp_desired_post_slug', 'odpowiedz-na-ogloszenie'),
 (1708, 376, '_wp_trash_meta_status', 'publish'),
 (1709, 376, '_wp_trash_meta_time', '1508872288'),
 (1710, 376, '_wp_desired_post_slug', 'podziekowania-za-platnosci'),
 (1711, 369, '_wp_trash_meta_status', 'publish'),
 (1712, 369, '_wp_trash_meta_time', '1508872288'),
 (1713, 369, '_wp_desired_post_slug', 'pokaz-ogloszenie'),
 (1714, 375, '_wp_trash_meta_status', 'publish'),
 (1715, 375, '_wp_trash_meta_time', '1508872288'),
 (1716, 375, '_wp_desired_post_slug', 'poszukaj-ogloszenia'),
 (1717, 372, '_wp_trash_meta_status', 'publish'),
 (1718, 372, '_wp_trash_meta_time', '1508872288'),
 (1719, 372, '_wp_desired_post_slug', 'umiesc-ogloszenie'),
 (1720, 374, '_wp_trash_meta_status', 'publish'),
 (1721, 374, '_wp_trash_meta_time', '1508872288'),
 (1722, 374, '_wp_desired_post_slug', 'zobacz-ogloszenia'),
 (1723, 2, '_wp_trash_meta_status', 'publish'),
 (1724, 2, '_wp_trash_meta_time', '1508872288'),
 (1725, 2, '_wp_desired_post_slug', 'sample-page'),
 (1726, 330, '_wp_trash_meta_status', 'publish'),
 (1727, 330, '_wp_trash_meta_time', '1508872289'),
 (1728, 330, '_wp_desired_post_slug', 'turystyka'),
 (1729, 332, '_wp_trash_meta_status', 'publish'),
 (1730, 332, '_wp_trash_meta_time', '1508872289'),
 (1731, 332, '_wp_desired_post_slug', 'noclegi'),
 (1732, 341, '_wp_trash_meta_status', 'publish'),
 (1733, 341, '_wp_trash_meta_time', '1508872289'),
 (1734, 341, '_wp_desired_post_slug', 'osrodki-wypoczynkowe'),
 (1735, 344, '_wp_trash_meta_status', 'publish'),
 (1736, 344, '_wp_trash_meta_time', '1508872289'),
 (1737, 344, '_wp_desired_post_slug', 'punkty-gastronomiczne'),
 (1738, 337, '_wp_trash_meta_status', 'publish'),
 (1739, 337, '_wp_trash_meta_time', '1508872289'),
 (1740, 337, '_wp_desired_post_slug', 'szlaki-rowerowe'),
 (1741, 87, '_wp_trash_meta_status', 'publish'),
 (1742, 87, '_wp_trash_meta_time', '1508872289'),
 (1743, 87, '_wp_desired_post_slug', 'zabytki'),
 (1744, 347, '_wp_trash_meta_status', 'publish'),
 (1745, 347, '_wp_trash_meta_time', '1508872289'),
 (1746, 347, '_wp_desired_post_slug', 'gospodarstwa-agroturystyczne'),
 (1747, 326, '_wp_trash_meta_status', 'publish'),
 (1748, 326, '_wp_trash_meta_time', '1508872289'),
 (1749, 326, '_wp_desired_post_slug', 'historia-lichenia'),
 (1750, 328, '_wp_trash_meta_status', 'publish'),
 (1751, 328, '_wp_trash_meta_time', '1508872289'),
 (1752, 328, '_wp_desired_post_slug', 'informacje-dla-pilegrzymow'),
 (1753, 323, '_wp_trash_meta_status', 'publish'),
 (1754, 323, '_wp_trash_meta_time', '1508872305'),
 (1755, 323, '_wp_desired_post_slug', 'obiekty'),
 (1756, 299, '_wp_trash_meta_status', 'publish'),
 (1757, 299, '_wp_trash_meta_time', '1508872305'),
 (1758, 299, '_wp_desired_post_slug', 'zwierzeta'),
 (1759, 282, '_wp_trash_meta_status', 'publish'),
 (1760, 282, '_wp_trash_meta_time', '1508872305'),
 (1761, 282, '_wp_desired_post_slug', 'wody-podziemne'),
 (1762, 1140, '_edit_last', '1'),
 (1763, 1140, '_edit_lock', '1508936773:1'),
 (1764, 1140, '_wp_page_template', 'default'),
 (1765, 1145, '_edit_last', '1'),
 (1766, 1145, '_edit_lock', '1508872401:1'),
 (1767, 1145, '_wp_page_template', 'default'),
 (1768, 1147, '_edit_last', '1'),
 (1769, 1147, '_edit_lock', '1508872531:1'),
 (1770, 1147, '_wp_page_template', 'default'),
 (1771, 1150, '_edit_last', '1'),
 (1772, 1150, '_edit_lock', '1508872549:1'),
 (1773, 1150, '_wp_page_template', 'default'),
 (1774, 1153, '_edit_last', '1'),
 (1775, 1153, '_edit_lock', '1508872689:1'),
 (1776, 1153, '_wp_page_template', 'default'),
 (1777, 1155, '_wp_trash_meta_status', 'publish'),
 (1778, 1155, '_wp_trash_meta_time', '1508873379'),
 (1779, 1156, '_wp_trash_meta_status', 'publish'),
 (1780, 1156, '_wp_trash_meta_time', '1508935425'),
 (1817, 1161, '_menu_item_type', 'taxonomy'),
 (1818, 1161, '_menu_item_menu_item_parent', '0'),
 (1819, 1161, '_menu_item_object_id', '51'),
 (1820, 1161, '_menu_item_object', 'category'),
 (1821, 1161, '_menu_item_target', ''),
 (1822, 1161, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
 (1823, 1161, '_menu_item_xfn', ''),
 (1824, 1161, '_menu_item_url', ''),
 (1826, 1162, '_menu_item_type', 'taxonomy'),
 (1827, 1162, '_menu_item_menu_item_parent', '0'),
 (1828, 1162, '_menu_item_object_id', '52'),
 (1829, 1162, '_menu_item_object', 'category'),
 (1830, 1162, '_menu_item_target', ''),
 (1831, 1162, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
 (1832, 1162, '_menu_item_xfn', ''),
 (1833, 1162, '_menu_item_url', ''),
 (1835, 1163, '_menu_item_type', 'taxonomy'),
 (1836, 1163, '_menu_item_menu_item_parent', '0'),
 (1837, 1163, '_menu_item_object_id', '53'),
 (1838, 1163, '_menu_item_object', 'category'),
 (1839, 1163, '_menu_item_target', ''),
 (1840, 1163, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
 (1841, 1163, '_menu_item_xfn', ''),
 (1842, 1163, '_menu_item_url', ''),
 (1844, 1164, '_menu_item_type', 'taxonomy'),
 (1845, 1164, '_menu_item_menu_item_parent', '0'),
 (1846, 1164, '_menu_item_object_id', '54'),
 (1847, 1164, '_menu_item_object', 'category'),
 (1848, 1164, '_menu_item_target', ''),
 (1849, 1164, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
 (1850, 1164, '_menu_item_xfn', ''),
 (1851, 1164, '_menu_item_url', ''),
 (1853, 1165, '_wp_trash_meta_status', 'publish'),
 (1854, 1165, '_wp_trash_meta_time', '1508936840'),
 (1855, 1166, '_edit_last', '1'),
 (1856, 1166, '_edit_lock', '1508936752:1'),
 (1857, 1166, '_wp_page_template', 'default'),
 (1858, 1060, 'post_views_count', '1'),
 (1859, 1064, 'post_views_count', '0'),
 (1860, 1066, 'post_views_count', '0'),
 (1861, 1169, '_edit_last', '1'),
 (1862, 1169, '_edit_lock', '1508951925:1'),
 (1865, 1172, '_edit_last', '1'),
 (1868, 1172, '_edit_lock', '1508967287:1'),
 (1869, 1172, 'post_views_count', '1'),
 (1870, 1169, 'post_views_count', '10'),
 (1871, 1068, 'post_views_count', '0');


DROP TABLE IF EXISTS `wp_posts`;
CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1174 DEFAULT CHARSET=utf8;

 
INSERT INTO `wp_posts` VALUES (1, 1, '2016-05-10 03:48:21', '2016-05-10 03:48:21', 'Welcome to WordPress. This is your first post. Edit or delete it, then start writing!', 'Hello world!', '', 'trash', 'open', 'open', '', 'hello-world__trashed', '', '', '2017-10-23 15:50:17', '2017-10-23 15:50:17', '', 0, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=1', 0, 'post', '', 1),
 (2, 1, '2016-05-10 03:48:21', '2016-05-10 03:48:21', 'This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:\n\n<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</blockquote>\n\n...or something like this:\n\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\n\nAs a new WordPress user, you should go to <a href="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-admin/">your dashboard</a> to delete this page and create new pages for your content. Have fun!', 'Sample Page', '', 'trash', 'closed', 'open', '', 'sample-page__trashed', '', '', '2017-10-24 19:11:29', '2017-10-24 19:11:29', '', 0, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?page_id=2', 0, 'page', '', 0),
 (3, 1, '2017-10-23 14:03:05', '0000-00-00 00:00:00', '', 'Automatycznie zapisany szkic', '', 'auto-draft', 'open', 'open', '', '', '', '', '2017-10-23 14:03:05', '0000-00-00 00:00:00', '', 0, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=3', 0, 'post', '', 0),
 (25, 1, '2017-07-21 21:05:30', '2017-07-21 21:05:30', '<strong><img class="alignleft  wp-image-189" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/IMG_1763.jpg" alt="" width="214" height="161" />Odpust ku czci Najświętszej Maryi Panny Licheńskiej odbył się wczoraj w bazylice. Uroczystej sumie przewodniczył bp Wojciech Osial, biskup pomocniczy diecezji łowickiej.</strong> <a href="https://www.lm.pl/aktualnosci/informacja/110520/lichen_odpust_w_bazylice_wierni_przeszli_pod_brama_milosierdzia" target="_blank" rel="noopener">Zdjęcia.</a>', 'Wierni przeszli pod Bramą Miłosierdzia', '', 'trash', 'open', 'open', '', 'wierni-przeszli-pod-brama-milosierdzia__trashed', '', '', '2017-10-23 15:50:17', '2017-10-23 15:50:17', '', 0, 'http://test20718.futurehost.pl/?p=25', 0, 'post', '', 0),
 (33, 1, '2017-07-31 11:52:51', '2017-07-31 11:52:51', '<center><a href=\'https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/19756768_1721336831501744_1232430468077662326_n.jpg?oh=a9a1acaa38bdc3814e7075ad1ccde40b&oe=59D7A9B0\' target=\'_blank\'><img src=\'https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/19756768_1721336831501744_1232430468077662326_n.jpg?oh=a9a1acaa38bdc3814e7075ad1ccde40b&oe=59D7A9B0\' style=\'margin:2px\' width=306 alt=\'\' align=\'left\' /></a></center>', 'Wakacyjny aerobik', '', 'trash', 'open', 'open', '', 'wakacyjny-aerobik__trashed', '', '', '2017-10-23 15:50:17', '2017-10-23 15:50:17', '', 0, 'http://test20718.futurehost.pl/?p=33', 0, 'post', '', 0),
 (35, 1, '2017-07-31 11:56:06', '2017-07-31 11:56:06', '<a href=\'https://www.facebook.com/mgokslesin/photos/ms.c.eJxFWNmRxTAI62gHDBjov7GdiIf8q8GcsnCiec6pK1GS5lV~;uoCni0YQ8LHoBfSqyy3VBY7CIg~_B~;iyy6dR8ACNQiHJ4xA0W5QTGR9JHjEXSIgphjZleG0AWyEnsRcmCD2ctNRY6FiZq6mlfBT~_LVMERzT3S~_aUud2tJMwBnLfK2p3X3NiinlstashWA3R9QguLu2eIq~_kvs2AIt9jmt2Ch1xoesj9YLC6ePxGyPbtiyAWKB9vx8eG3Heo7oHmmR~_wFSG7a7vih5zwPgYzv2JYojQUBtfMgCJ3BEDo~;0HHEeGadCH4FqLe8Cd6K8sJlfYrdsgRogF~;h4m9bRe0RVYBGbmDomd5faLX0A3KIPkP~;ctVDx8bGJ6QFhTHKBwOTuA3LyKOZRX9e~;jBdo~_DjGI40ocTfK0QH8AV8LP64xSsGpxlrkgcXZ1M~_kHkz9TAudLTyBMejdTA~_u2Km9Ym1DOl~;StTl66kfoA9RWJnYqYJFMbCjlS6m2g0wzlcBYGC0CqfuSv~_2iydbbsSpkepSZJnoqe4E64xtlXEZpTC6Cg6r79aNqZaurL4C7tSR4GkmeNihVRUq1y5eHxvpoNLny12QTk6~_48tji~_gYsehvU9rUwvDdsNwgjK7DdjVrcWEskgJRflLlzsXfORD7ZssqfbJmIn8~;CimH9InWnxYUPu~;SRSP0WgR4Le1HAQvmtky~;KAE5gMrWXKSTnrOR8Tj9qa~;~;KN1EsLe3f0jJR1QEo49pwKrQ4Dosfkz~_hzxH6HcMF6dR~;dDBRRy3nOQ3w4~_QmNmIQKwYmmoIodDqXUPcSmmiPhdCiP8mpoI8zdIjYsAfyqVXboHMwqCNBYHwYfUBPtcIJIGzdDXsc0w9NAj7AXSBkAIYNtLCsCUxYYdg7FocW2ITlTYv8ZDw0GCWnuMMohQXsSR~_FJqvTR6Gn9cof0ilJZwI6ZD8A~;djXhYlhq4eyfFNQap8bJnYugEuLg6suvYnZ9DTZU7M5EjziYxG08IPilFGm686uW2C2kkFgWsgm20Xq8hKbWym8laN0IS~_PxCithUAisRe2MYYUWjQ0yO7m4VgWZZycj9JZyAM~_H5fC5lhJenO77md8GH2ciWKMYl~;53v0A3AY7W5y7wILq4A7SXW8Cc4RvOg8bC2YK5ffmVfdrAC4zvfBxyCC~;DYvYyTmY7P36Mbp~_Xvk1Fk6Lwp17~_uE1qQtTr4lijIK9X~_euj0~_CPiCagOMIJSdGHIPiGDodI9dj5hKcSyjGcKjJcWQAIRDwwe0ReOJ7NaMM~_YOkCytYFDP1ccqrHj6ZOn3EtJDiGBcXOXizYwZVHFSMwigVJhIMKi6cGK4~;YYvR5KAmR6HJmrRoNFm5LKKxG57SxTwElHlcwc1W8uPKWFCC74yhOIarMcAWdw9GWfJW0iTG~_3JNBhACE~_UwCvatOsu~;03Vl1~_8o~;5O~_G7i37gwbSCzzPABHqLgXGuRPHO9QW~;IB48PpozCGfbGZ3J4jz0eDQfuE~_wAwKLlOcsgv8YAcCyEwR5QWislZKQE0yCiweUCpFCcAFooZAXD9kutpoOV7B6Vjck~;60pHH5RZLfFmUKPOIOZI8MqJ0KUp5oR~_Xdz9vDsBqoevZ~;QAHUDyCB1q~_h1HWWJDrOXMxecCMQXYM2bA4vRaFT9FsXvXCLwI9vOo1q~_BpYekc4VOyzliw~;Jrn12H5hUdNNh81hZ8IHs0jPuVz~_oVPDX~;CVtPTeE5j~_kEdm29kPdzIVaB2vEzrDBAEcgCGhUhncVCFB4k~;2ep5kCjXSU~_DlA3q4amSp40vCw~;uhoYmZzFsT8eUxTW2aRa3aRtauF98Jo3XhTvJ37Ma9Tm92A1PUBpfa5nvSPUAdIqPVfffx6qpzEryXUn6vb6~;I17~;XRS2Hw~-~-.bps.a.1722285898073504.1073741841.1487568454878584/1722286058073488/?type=3&theater\' target=\'_blank\'><img src=\'https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/19756508_1722286058073488_7854504430310623466_n.jpg?oh=ad4cc73fd330a7fe849b1fa28ca8f4d7&oe=59C49038\' style=\'margin:2px\' alt=\'\' width=136 align=\'right\' /></a><strong>W dniach 24-25 czerwca odbyły się obchody Jubileuszowe Klubu Szachowego M-GOK Gambit Ślesin. W ramach obchodów rozegrany został Festiwal Szachowy, podzielony na turniej OPEN i turnieje Jubileuszowe. W turnieju OPEN zagrało 78 zawodników najlepszy okazał się Kamil Szadkowski z klubu UKS Smecz Konin, drugie miejsce przypadło Andrzejowi Maciejewskiemu z NOK Nakło, na trzecim miejscu uplasował się Przemysław Dudek z Konina. </strong>\n\n<!--more-->\nDodatkowo w turnieju nagrodzeni zostali najlepsi w kategoriach szachowych oraz najlepsza zawodniczka i najlepszy zawodnik w kategoriach szachowy z klubu M-GOK Gambit Ślesin. Najlepszym z II kategorią szachową okazał się Ryszard Krupiński z klubu TS-R Hetman Konin, natomiast najlepszą zawodniczką z klubu Gambit Nikola Królak najlepszym zawodnikiem Tomasz Bruch. Pierwsze miejsce w kategorii III zajął Miłosz Świderski z klubu UKS Kiełbaska Kościelec. Natomiast najlepszą zawodniczką z klubu Gambit okazała się Iwona Rybacka, najlepszym zawodnikiem Krzysztof Kowalski. Następnie bardzo wysokie 22 miejsce w turnieju OPEN i pierwsze miejsce w kategorii IV zajął Adam Głąbiak z naszego klubu, najlepszą zawodniczką w tej samej kategorii okazała się jego siostra Aleksandra Głąbiak. \nŹródło: <a href=\'https://www.facebook.com/mgokslesin?ref=bookmarks\' target=\'_blank\'>Profil MGOK na portalu Facebook.</a>\n\n\n \n\nW kategorii V najlepsi okazali się zawodnicy Anna Przybylska i Piotr Paruszkiewicz z klubu M-GOK Gambit Ślesin. Najlepszy zawodnik bez kategorii szachowej Michał Nizgorski z klubu TS-R Hetman Konin, a najlepsi z klubu Gambit to Natalia Dorywalska i Michał Marcinkowski. Zwycięzcy otrzymali puchary, dyplomy oraz nagrody pieniężne które zostały zebrane z wpisowego natomiast najlepsi w kategoriach otrzymali nagrody rzeczowe. \n\nDrugi dzień to turnieje jubileuszowe przewidziane tylko dla zawodników Klubu M-GOK Gambit Ślesin, rodziców tych zawodników oraz zaproszonych gości. W turniejach jubileuszowych grało 105 zawodników z podziałem na grupy rankingowe. Dodatkowo stworzona została grupa rodziców oraz grupa VIP zaproszonych gości. \nW grupie A na podium znaleźli się Tomasz Bruch - pierwsze miejsce, Adam Naworski - drugie miejsce, Damian Mrówczyński - trzecie miejsce. \nW grupie B dziewcząt Małgorzata Nawrocka pierwsze miejsce, Anna Grabowska drugie miejsce, Dominika Królak trzecie miejsce, grupa B chłopców Norbert Nawrotek pierwsze miejsce, Kacper Majewski drugie miejsce, Karol Zając trzecie miejsce. \nW grupie C dziewcząt Agata Naworska pierwsze miejsce, Weronika Stolarska drugie miejsce, Iwona Rybacka trzecie miejsce. Grupa C chłopców: Dominik Długołencki - pierwsze miejsce, Adam Głąbiak - drugie miejsce, Tymoteusz Łachacz - trzecie miejsce. \nW grupie D dziewcząt Adrianna Badič pierwsze miejsce, Margarita Królak drugie miejsce, Małgorzata Wrońska trzecie miejsce. Grupa D chłopcy Marcin Badowski pierwsze miejsce, Piotr Paruszkiewicz drugie miejsce, Jakub Garczyński trzecie miejsce. \nW grupie E dziewczęta Anna Przybylska pierwsze miejsce, Aleksandra Zawieruszyńska drugie miejsce, Wiktoria Szwacińska trzecie miejsce. Grupa E chłopcy Dawid Kwieryng pierwsze miejsce, Artur Królak drugie miejsce, Michał Marcinkowski trzecie miejsce. \nW grupie F panie Aneta Długołencka pierwsze miejsce, Urszula Paruszkiewicz drugie miejsce, Justyna Czerniejewska, Patrycja Orzechowska, Lidia Chojnacka Ex aequo trzecie miejsce, grupa F panów Marcin Łachacz pierwsze miejsce, Dariusz Chojnacki drugie miejsce, Jarosława Paruszkiewicz trzecie miejsce. \nW grupie VIP Kamil Szadkowski z klubu UKS Smecz Konin pierwsze miejsce, Mirosław Sobczak z klubu LKS Chrobry Gniezno drugie miejsce, Szymon Pieczewski z klubu OTSz Ostrów Wielkopolski trzecie miejsce. \nGrupa VIP - panie Tatiana Zabłocka z Sompolna. \n\nNa zakończenie festiwalu medale i nagrody, które ufundowała Gminna Komisja Rozwiązywania Problemów Alkoholowych w Ślesinie, wręczali: asystent Burmistrza Miasta i Gminy Ślesin - Urszula Bachera, v-ce Prezes ds. młodzieży Wielkopolskiego Związku Szachowego Szymon Pieczewski i dyrektor Miejsko &#8211; Gminnego Ośrodka Kultury w Ślesinie Michał Chmielewski. Uhonorowano pamiątkowymi statuetkami szachistów i zaproszonych gości których wkład pracy przyczynił do rozwoju w propagowaniu i popularyzacji &#8222;królewskiej gry&#8222; w gminie Ślesin. \n\nW kolejnym punkcie obchodów Dyrektor Miejsko-Gminnego Ośrodka Kultury w Ślesinie przedstawił historię klubu od powstania po dzień dzisiejszy, w którym to za prekursorów i założycieli klubu wymienił Kazimierza Nowakowskiego i Piotra Gołębiewskiego, którzy zaproponowali działalność klubu pod patronatem Miejsko-Gminnego Ośrodka Kultury w Ślesinie. \n\nKlub został zarejestrowany w Polskim Związku Szachowym 20 kwietnia 1987 r. W rozgrywkach ligowych ślesińską drużynę reprezentowali: Kasprzak Kazimierz, Dębowski Bernard, Gołembiewski Piotr, Nowakowski Kazimierz, Szychowski Józef, Wadelski Stanisław, Zawada Janusz. Od 8 października dołączyli Kozikowski Bogumił, Świder Piotr, Zmiendak Piotr i Dranikowska Edyta ( obecnie Borkowska), a od maja następnego roku do szachistów dołączył Kryk Stefan i Wagner Piotr. Drużyna brała aktywny udział w rozgrywkach i treningach do 1990 r. \n\nNastępnie przez kolejne lata organizowane były systematycznie turnieje z okazji Święta 3 Maja i 11 Listopada. Po majowym turnieju w 1995 M-GOK rozpoczyna prowadzenie cyklicznych zajęć szachowych dla dzieci i młodzieży. Ślesińscy szachiści uczestniczą w różnego rodzaju turniejach, których także jest gospodarzem jest M-GOK.\n\nJesienią 1997 r. M-GOK zgłasza drużynę do rozgrywek ligowych Okręgowego Związku Szachowego w Koninie. Drużynę i szachistów prowadzi Krzysztof Kowalski. Systematycznie zwiększa się liczba szachistów klub w 1998 w rozgrywkach ligowych ma dwie drużyny. Przełomowym momentem w działalności klubu jest zatrudnienie w 1999 r. w M-GOK jako stażysty &#8211; aktywnego szachisty Roberta Majdeckiego, który przejmuje z czasem wszystkie obowiązki prowadzenia klubu do dnia dzisiejszego. Ważny wpływ na działalność Klubu miał Prezes i Wiceprezes Konińskiego Okręgowego Eugeniusz Ślesiński i Tomasz Pilarski stwarzając wszelkie najkorzystniejsze warunki i ułatwienia w działalności klubu i powszechności gry w szachy. \n\nTomasz Pilarski był pomysłodawcą niezliczonych imprez szachowych, które zachęcały do działania, a tym samym podnoszenia poziomu umiejętności zawodniczych. Turnieje i szkolenia szachowe organizowane w latach 2000 do 2005 przez Ryszarda Pycha, Prezesa Kaliskiego Okręgowego Związku Szachowego w Półwiosku Starym, były kolejną zachętą, ale także motywacją do pracy nad doskonaleniem formy szachistów ze Ślesina, które wzmocniły &#8222;korzenie&#8222; ślesińskich szachistów.\n\nNa dzień dzisiejszy klub zrzesza 141 szachistów zarejestrowanych w Polskim Związku Szachowym, a czynnie biorących udział w życiu, rozwoju i promocji klubu oraz Gminy Ślesin jest 62 szachistów. Obecnie w Domu Kultury prowadzone są cykliczne zajęcia dla szachistów w każdy piątek i sobotę z podziałem na grupy wiekowe i posiadane umiejętności. Nasi szachiści z sukcesami reprezentują Klub na turniejach o randze Gminy, Powiatu, Województwa i Polski. \nWyróżnić należy Tomasza Brucha, wielokrotnego finalistę Mistrzostw Polski, jak i Małgorzatę Bruch, Dominikę Królak, Nikolę Królak, Damiana Mrówczyńskiego, Eryka Brodzińskiego, Patrycję Jasińską, Arona Byrę, Nikolę Majdecką, Arkadiusza Łapota, Natalię Łapot, również finalistów Mistrzostw Polski, oraz wielu innych znakomitych szachistów, którzy zajmowali wysokie miejsca na turniejach o różnej randze, najlepiej obrazowała ogrom sukcesów naszych szachistów wystawa zdjęć, która stworzona została specjalnie na Jubileusz 30-lecia. \n\nPodczas uroczystości było wiele wspomnień, podziękowań, gratulacji pojawiły się również łzy radości, co na pewno pozwoli przetrwać klubowi do kolejnych jubileuszy. Uroczystości jubileuszowe zwieńczył szachowy tort urodzinowy i dalsze spotkanie &#8222;wielkiej rodziny szachowej&#8221; przy grilu.\n\nŹródło: <a href=\'https://www.facebook.com/mgokslesin?ref=bookmarks\' target=\'_blank\'>Profil MGOK na portalu Facebook.</a>', 'Podsumowanie jubileuszu 30-lecia Klubu Szachowego M-GOK Gambit Ślesin', '', 'trash', 'open', 'open', '', 'podsumowanie-jubileuszu-30-lecia-klubu-szachowego-m-gok-gambit-slesin__trashed', '', '', '2017-10-23 15:50:17', '2017-10-23 15:50:17', '', 0, 'http://test20718.futurehost.pl/?p=35', 0, 'post', '', 0),
 (39, 1, '2017-07-31 12:00:30', '2017-07-31 12:00:30', '<strong><img class="alignleft wp-image-167" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/pexels-photo-274506.jpeg" alt="" width="207" height="138" />RUNDA IV odbędzie się już w niedzielę 16. lipca 2017 na boisku ORLIK przy Osiedlu Północ.</strong>\nKolejność rozgrywanych meczy\n1mecz 8:30 Szyszyn <strong>1 - 2</strong> Wąsosze\n2 mecz 9:40 Półwiosek Stary <strong>2 - 13</strong> Piotrkowice\n3 mecz 10:50 Osiedle Powstańców Wielkopolskich <strong>2 – 1</strong> Honoratka\n4 mecz 12:00 Ignacewo <strong>0 – 12</strong> Głębockie / Mikorzyn\n5 mecz 13:10 Osiedle Północ <strong>8 – 4 </strong>Szyszyńskie Holendry\nGospodarzami rundy są drużyny Osiedle Północ – Szyszyńskie Holendry\nŹródło: M-GOK Ślesin', 'W najbliższą niedzielę IV runda Ligi Sołeckiej', '', 'trash', 'open', 'open', '', 'w-najblizsza-niedziele-iv-runda-ligi-soleckiej__trashed', '', '', '2017-10-23 15:50:16', '2017-10-23 15:50:16', '', 0, 'http://test20718.futurehost.pl/?p=39', 0, 'post', '', 0),
 (46, 1, '2017-07-31 12:08:27', '2017-07-31 12:08:27', '<center><a href=\'https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/19905131_1241033346024723_9083949534731835306_n.png?oh=741ce70fab4da2fcd418e10a7fa28608&oe=5A08F093\' target=\'_blank\'><img src=\'https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/19905131_1241033346024723_9083949534731835306_n.png?oh=741ce70fab4da2fcd418e10a7fa28608&oe=5A08F093\' style=\'margin:5px\' alt=\'\' align=\'center\' /></a></center><strong>Ślesiński Festiwal Piwa w dniach 28-29 lipca 2017 r. to kolejna propozycja na dobrą zabawę.\n28.07.2017 -  RasLuta, Naliah i CzarneStopy\n29.07.2017 - DJWika, Piwozaury  i TabChan</strong>\nZapraszamy. Wstęp wolny.\nŹródło: <a href=\'https://www.facebook.com/gminaslesin/\' target=\'_blank\'>Profil Gminy Ślesin na portalu Facebook.</a>', 'Ślesiński Festiwal Piwa', '', 'trash', 'open', 'open', '', 'slesinski-festiwal-piwa__trashed', '', '', '2017-10-23 15:50:16', '2017-10-23 15:50:16', '', 0, 'http://test20718.futurehost.pl/?p=46', 0, 'post', '', 0),
 (48, 1, '2017-07-31 12:10:49', '2017-07-31 12:10:49', '<strong><img class="alignleft wp-image-189" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/IMG_1763.jpg" alt="" width="188" height="141" />XXV Ogólnopolska Pielgrzymka Sołtysów i Środowisk Wiejskich w Licheniu. Tegoroczna pielgrzymka miała wyjątkowy charakter, gdyż obchodzono srebrny jubileusz jej powstania.</strong> <a href="https://www.lm.pl/aktualnosci/informacja/110603/lichen_jubileuszowa_pielgrzymka_soltysow_i_srodowisk_wiejskich" target="_blank" rel="noopener">Zdjęcia.</a>\n<!--more-->\n\nPrzed rozpoczęciem południowej sumy głos zabrał Ireneusz Niewiarowski, prezes Krajowego Stowarzyszenia Sołtysów, który przedstawił zgromadzonym dokonania organizacji zrzeszającej ludzi polskiej wsi na przełomie minionego ćwierćwiecza. Podziękował także wszystkim zgromadzonym za uczestnictwo w tegorocznym spotkaniu. Eucharystii przewodniczył wikariusz biskupi, ks. Wojciech Kochański z Konina, natomiast homilię wygłosił ks. Ireneusz Juszczyński z parafii w Brześciu Kujawskim.Po mszy poczty sztandarowe oraz uczestnicy pielgrzymki udali się do grobu biskupa Romana Andrzejewskiego, wieloletniego duszpasterza rolników i polskiej wsi, gdzie złożono kwiaty.\n\nKrajowe Stowarzyszenie Sołtysów powstało w maju 1994 roku w Licheniu. Do jego głównych zadań należy m.in. wspieranie i promocja inicjatyw pozarządowych oraz wspieranie rozwoju lokalnych społeczności.', 'Jubileuszowa pielgrzymka sołtysów i środowisk wiejskich', '', 'trash', 'open', 'open', '', 'jubileuszowa-pielgrzymka-soltysow-i-srodowisk-wiejskich__trashed', '', '', '2017-10-23 15:50:16', '2017-10-23 15:50:16', '', 0, 'http://test20718.futurehost.pl/?p=48', 0, 'post', '', 0),
 (52, 1, '2017-07-31 12:12:58', '2017-07-31 12:12:58', '<a href="https://www.facebook.com/mgokslesin/photos/pcb.1724274831207944/1724274237874670/?type=3&amp;theater" target="_blank" rel="noopener"><img style="margin: 2px;" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/19905053_1724274287874665_5701799762732587263_n.jpg?oh=90ee482f3cf9f7d61ee19625d1d66674&amp;oe=59C5632A" alt="" width="136" align="left" /></a><strong>12 lipca Miejsko-Gminny Ośrodek Kultury w Ślesinie w ramach wakacji zorganizował wycieczkę do Muzeum Ziemi Kujawsko-Dobrzyńskiej we Włocławku dla dzieci uczęszczających na zajęcia do M-GOK. Podczas wycieczki dzieci zwiedziły Skansen Etnograficzny oraz Dworek Państwa Orpiszewskich w Kłóbce.</strong>\n<!--more-->\n\nNie zabrakło także ciekawej lekcji muzealnej pt.: "Kto ma pszczoły ten ma miód", podczas której spotkali się z pszczelarzem opowiadającym o życiu pszczół i ich zwyczajach. Po degustacji różnorodnych miodów wykonali własnoręcznie świeczkę z pszczelego wosku. Po pracowitej lekcji na dzieci czekała niespodzianka w postaci „Kujawskich Racuchów”.', 'Wizyta w skansenie w Kłóbce', '', 'trash', 'open', 'open', '', 'wizyta-w-skansenie-w-klobce__trashed', '', '', '2017-10-23 15:50:16', '2017-10-23 15:50:16', '', 0, 'http://test20718.futurehost.pl/?p=52', 0, 'post', '', 0),
 (54, 1, '2017-07-31 12:15:47', '2017-07-31 12:15:47', '<strong>Na drodze dojazdowej do licheńskiego sanktuarium wylano asfalt.</strong>\nW Licheniu Starym przebudowywana jest ul. Toruńska. Na blisko 2 km odcinku wykonano przebudowę nawierzchni zatoki autobusowej i ronda, wykonano również odcinek chodnika i elementy odwodnienia, a także oznakowania pionowego i poziomego. Prace są już na ukończeniu.Inwestycja warta niespełna 2 mln zł.\nŹródło: Aleksandra Braciszewska - Benkahla - konin.LM.pl', 'Trwa przebudowa drogi prowadzącej do sanktuarium', '', 'trash', 'open', 'open', '', 'trwa-przebudowa-drogi-prowadzacej-do-sanktuarium__trashed', '', '', '2017-10-23 15:50:16', '2017-10-23 15:50:16', '', 0, 'http://test20718.futurehost.pl/?p=54', 0, 'post', '', 0),
 (57, 1, '2017-07-31 12:17:22', '2017-07-31 12:17:22', '<img class="" style="margin: 2px;" src="http://gminaslesin.hostpark.pl/info/LOGOPOLSKAGOSPODYNI-2017.jpg" alt="" width="139" height="138" align="left" /><strong>Tysiące kobiet w barwnych ludowych strojach, radość, emocje towarzyszyć będą zjazdowi organizacji kobiecych z terenów wiejskich. Podczas licheńskiego święta w dniach 9-10 września br. będzie można podziwiać artystyczny dorobek włościanek, a na straganach zagoszczą tradycyjne słodkości i dania regionalne. </strong>\n<!--more-->\n\nJak co roku, spotkanie skupione będzie wokół dwóch aspektów: kulturowego oraz duchowego. Pierwszego dnia Zjazdu odbędzie się Jarmark Kulturowy, gdzie gospodynie będą mogły zaprezentować swoje dokonania rękodzielnicze, muzyczne i kulinarne. Kulminacyjnym punktem programu będzie rozstrzygnięcie plebiscytu „Wieś jest kobietą”, w którym zostanie wybrana Gospodyni Roku.\n\nZ kolei niedziela, jak zwykle, minie pod hasłem refleksji i wiary. Odbędzie się uroczysta procesja zakończona Mszą Świętą w bazylice Licheńskiej. Po mszy świętej zaplanowano zwiedzanie Sanktuarium z przewodnikiem. Dzień zakończy Koronka do Miłosierdzia Bożego.\n\nTegoroczne spotkanie z tradycją i folklorem wzbogacone o duchowe i religijne doznania zostało objęte Honorowym Patronatem Prezydenta Rzeczypospolitej Polskiej Andrzeja Dudy oraz Małżonki Prezydenta Agaty Kornhauser-Dudy.\n\nOrganizatorem wydarzenia jest Stowarzyszenie Polska Gospodyni, które zachęca wszystkie organizacje do zgłoszenia udziału w Zjeździe. Szczegółowe informacje na stronie www.polskagospodyni.pl.', 'Zjazd Kół Gospodyń Wiejskich - Licheń 2017', '', 'trash', 'open', 'open', '', 'zjazd-kol-gospodyn-wiejskich-lichen-2017__trashed', '', '', '2017-10-23 15:50:16', '2017-10-23 15:50:16', '', 0, 'http://test20718.futurehost.pl/?p=57', 0, 'post', '', 0),
 (61, 1, '2017-07-31 12:19:46', '2017-07-31 12:19:46', '<strong><img class="alignleft" src="https://images.pexels.com/photos/163329/bicycles-cycle-bike-wheel-163329.jpeg?w=940&amp;h=650&amp;auto=compress&amp;cs=tinysrgb" width="229" height="102" />Ponad 40 osób przyjechało rowerami do licheńskiego sanktuarium. Pielgrzymka trwała tydzień, a cykliści w jej trakcie pokonali 644 km.</strong> <a href="https://www.lm.pl/aktualnosci/informacja/110699/lichen_jechali_przez_tydzien_pielgrzymka_rowerowa_w_sanktuarium" target="_blank" rel="noopener">Zobacz zdjęcia.</a>\n<!--more-->\n\nW miniony weekend pielgrzymi ze Słońska, Bogdańca, Ośna Lubuskiego, Kostrzyna nad Odrą, Pyrzyc i Gorzowa Wielkopolskiego dotarli do Lichenia. Wśród 41 uczestników znalazł się 9-letni Michał Wierzchowiecki z Gorzowa Wielkopolskiego. To najmłodszy pielgrzym cyklista, który pokonywał wszystkie etapy na równi z dorosłymi, w tym najdłuższy w historii, liczący 122 km odcinek z Górki Klasztornej do Gniezna.\nPielgrzymka trwała od 8 do 15 lipca. Rowerzyści podążali historycznymi szlakami: piastowskim i bursztynowym.\nŹródło: konin.LM.pl', 'Jechali przez tydzień. Pielgrzymka rowerowa w sanktuarium', '', 'trash', 'open', 'open', '', 'jechali-przez-tydzien-pielgrzymka-rowerowa-w-sanktuarium__trashed', '', '', '2017-10-23 15:50:16', '2017-10-23 15:50:16', '', 0, 'http://test20718.futurehost.pl/?p=61', 0, 'post', '', 0),
 (64, 1, '2017-07-31 12:22:59', '2017-07-31 12:22:59', '<strong><img class=" alignleft" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-0/s480x480/20229189_1728076500827777_8461772025129600288_n.jpg?oh=78da351d7881a955dca817686a892cdb&amp;oe=59FB8FDA" width="192" height="193" />Zapraszam do udziału w XX Wakacyjnym Pikniku Klubów Seniora, który odbędzie się tradycyjnie w pierwszy czwartek sierpnia 03.08.2017r. w Parku Miejskim w Ślesinie. Piknik rozpoczniemy tańcami od godziny 15:00, a zakończymy o godz. 20:00. Do tańca będzie przygrywał zespół Aplaus.</strong>\nAkredytacja udziału w pikniku wynosi 15 zł od osoby. W ramach opłaty przygotujemy 1 kiełbasę z grilla i 1 kiełbasę z wody, herbatę, chleb, musztardę i drożdżówkę. Do dnia 26.07.2017r. prosimy zgłosić udział na załączonej karcie. <a href="http://www.mgok.slesin.pl/asp/pliki/pobierz/wakacyjny_piknik_seniora_slesin_2017.doc" target="_blank" rel="noopener">Pobierz.</a>\nDo zobaczenia w Ślesinie.\n\n<!--more-->\n\nAkredytacja udziału w pikniku wynosi 15 zł od osoby. W ramach opłaty przygotujemy 1 kiełbasę z grilla i 1 kiełbasę z wody, herbatę, chleb, musztardę i drożdżówkę. Do dnia 26.07.2017r. prosimy zgłosić udział na załączonej karcie zgłoszenia na adres:\nMiejsko-Gminny Ośrodek Kultury w Ślesinie\nul. Młodzieżowa 11\n62-561 Ślesin', 'XX Wakacyjny Piknik Klubów Seniora', '', 'trash', 'open', 'open', '', 'xx-wakacyjny-piknik-klubow-seniora__trashed', '', '', '2017-10-23 15:50:16', '2017-10-23 15:50:16', '', 0, 'http://test20718.futurehost.pl/?p=64', 0, 'post', '', 0),
 (67, 1, '2017-07-31 12:23:48', '2017-07-31 12:23:48', '<img class="alignleft wp-image-180" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/IMG_1651.jpg" alt="plaża" width="270" height="172" /><strong>Jedyny taki urząd w Wielkopolsce i jeden z niewielu w kraju. Magistrat przy plaży? Tylko w Ślesinie!</strong>\n\n\nTakiego widoku można tylko pozazdrościć. Przez okno widać piękną plażę i jezioro. W takich warunkach od blisko roku pracują ślesińscy urzędnicy. Przeprowadzili się oni do budynku Ośrodka Sportu i Rekreacji na czas przebudowy siedziby magistratu w centrum miasta. Jak podkreśla burmistrz Mariusz Zaborowski, to pierwsze i prawdopodobnie ostatnie wakacje przy plaży. Jak się pracuje w takim miejscu i czy w związku z wakacyjnym klimatem zmienił się urzędowy dress code? <!--more--> Zobaczcie sami! <a href="https://www.lm.pl/aktualnosci/informacja/110665/slesin._urzad_z_widokiem_na_plaze._jedyny_taki_w_okolicy" target="_blank" rel="noopener">Zobacz materiał.</a>\nŹródło: Aleksandra Braciszewska - Benkahla - konin.LM.pl', 'Urząd z widokiem na plażę', '', 'trash', 'open', 'open', '', 'urzad-z-widokiem-na-plaze__trashed', '', '', '2017-10-23 15:50:16', '2017-10-23 15:50:16', '', 0, 'http://test20718.futurehost.pl/?p=67', 0, 'post', '', 0),
 (69, 1, '2017-07-31 12:25:25', '2017-07-31 12:25:25', '<strong><img class="alignleft wp-image-177" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/rocznice.jpg" alt="" width="263" height="178" />27 lipca (czwartek) 2017 roku o godz. 14.00 w sali posiedzeń Urzędu Miasta i Gminy w Ślesinie odbędzie się XXXI sesja Rady Miejskiej Gminy Ślesin</strong>\nW planach m. in. stwierdzenia przekształcenia dotychczasowej sześcioletniej Szkoły Podstawowej im. Tadeusza Kościuszki przy Zespole Szkolno- Przedszkolnym w Ślesinie w ośmioletnią Szkołę Podstawową im. Tadeusza Kościuszki przy Zespole Szkolno-Przedszkolnym w Ślesinie (jak i innych szkół podstawowych w gminie) oraz zmiana uchwały w sprawie uchwalenia Wieloletniej Prognozy Finansowej Miasta i Gminy Ślesin na lata 2017 – 2036.\nŹródło: umig.slesin.pl\n<!--more-->\n\n<center>OBWIESZCZENIE\nBURMISTRZA MIASTA I GMINY ŚLESIN\nZ 21 LIPCA 2017 ROKU</center><strong>Informuję, że 27 lipca (czwartek) 2017 roku o godz. 14.00 w sali posiedzeń Urzędu Miasta i Gminy w Ślesinie odbędzie się XXXI sesja Rady Miejskiej Gminy Ślesin.</strong>\n\nBurmistrz Miasta i Gminy\n/-/ <i>Mariusz Zaborowski</i>\n\nNa podstawie art. 20 ust. 1 ustawy z dnia 08 marca 1990 roku o samorządzie gminnym /Dz. U. z 2016 r., poz.446 ze zm./ z w o ł u j ę <strong>XXXI sesję Rady Miejskiej Gminy Ślesin na dzień 27 lipca ( czwartek ) 2017 roku na godz. 14.00 w sali posiedzeń Urzędu Miasta i Gminy w Ślesinie</strong> z następującym porządkiem obrad:\n\nOtwarcie sesji i stwierdzenie quorum.\n\nPrzyjęcie porządku obrad.\n\nPrzyjęcie protokołu z XXX sesji Rady Miejskiej Gminy Ślesin.\n\nInterpelacje i zapytania radnych .\n\nPodjęcie uchwał w sprawach:\nzmian budżetu,\no zmianie uchwały w sprawie uchwalenia Wieloletniej Prognozy Finansowej Miasta i Gminy Ślesin na lata 2017 – 2036,\nstwierdzenia przekształcenia dotychczasowej sześcioletniej Szkoły Podstawowej im. Tadeusza Kościuszki przy Zespole Szkolno- Przedszkolnym w Ślesinie w ośmioletnią Szkołę Podstawową im. Tadeusza Kościuszki przy Zespole Szkolno-Przedszkolnym w Ślesinie,\nstwierdzenia przekształcenia dotychczasowej sześcioletniej Szkoły Podstawowej im. mjr. Henryka Sucharskiego w Licheniu Starym w ośmioletnią Szkołę Podstawową im. mjr. Henryka Sucharskiego w Licheniu Starym,\nstwierdzenia przekształcenia dotychczasowej sześcioletniej Szkoły Podstawowej im. Adama Mickiewicza w Szyszyńskich Holendrach w ośmioletnią Szkołę Podstawową im. Adama Mickiewicza w Szyszyńskich Holendrach,\nstwierdzenia przekształcenia dotychczasowej sześcioletniej Szkoły Podstawowej im. Henryka Sienkiewicza w Wąsoszach w ośmioletnią Szkołę Podstawową im. Henryka Sienkiewicza w Wąsoszach,\nstwierdzenia przekształcenia dotychczasowej sześcioletniej Szkoły Podstawowej im. Kornela Makuszyńskiego w Ostrowążu w ośmioletnią Szkołę Podstawową im. Kornela Makuszyńskiego w Ostrowążu,\nstwierdzenia przekształcenia dotychczasowej sześcioletniej Szkoły Podstawowej im. Janiny Porazińskiej w Piotrkowicach w ośmioletnią Szkołę Podstawową im. Janiny Porazińskiej w Piotrkowicach,\npowołania doraźnej Komisji Inwentaryzacyjnej, ustalenia przedmiotu jej działania oraz składu osobowego,\nprzystąpienia do sporządzenia zmiany m.p.z.p. na terenie gminy Ślesin dla obszaru obejmującego część obrębu geodezyjnego Licheń Stary.\n\nWolne wnioski.\n\nZakończenie obrad.\n\nPrzewodniczący Rady\n/-/ <i>Stanisław Chrzanowski</i>', 'XXXI  sesja Rady Miejskiej Gminy Ślesin', '', 'trash', 'open', 'open', '', 'xxxi-sesja-rady-miejskiej-gminy-slesin__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://test20718.futurehost.pl/?p=69', 0, 'post', '', 0),
 (72, 1, '2017-07-31 12:26:51', '2017-07-31 12:26:51', '<a href="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/pilka.jpg"><img class="alignleft" src="https://images.pexels.com/photos/114296/pexels-photo-114296.jpeg?h=350&amp;auto=compress&amp;cs=tinysrgb" width="215" height="137" /></a><strong>RUNDA V odbędzie się 23. lipca 2017 - na boisku ORLIK przy Zespole Szkolno-Przedszkolnym w Ślesinie.\nKolejność rozgrywanych meczy</strong>\n1mecz 8:30 Szyszyńskie Holendry <strong>6 - 5</strong> Osiedle Powstańców Wielkopolskich\n2 mecz 9:40 Osiedle Północ <strong>8 – 6</strong> Głębockie/Mikorzyn\n3 mecz 10:50 Piotrkowice <strong>17 – 5</strong> Igancewo\n4 mecz 12:00 Honoratka <strong>1 - 11</strong> Szyszyn\n5 mecz 13:10 Wąsosze <strong>6 – 10</strong> Półwiosek Stary\nGospodarzami rundy są drużyny Wąsosze – Półwiosek Stary', 'Piąta runda 23 lipca', '', 'trash', 'open', 'open', '', 'piata-runda-23-lipca__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://test20718.futurehost.pl/?p=72', 0, 'post', '', 1),
 (74, 1, '2017-07-31 12:28:17', '2017-07-31 12:28:17', '<a href="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/fotogal.jpg"><img class="alignleft  wp-image-170" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/19959220_1237463673048357_2467358592219517314_n.jpg" alt="" width="376" height="532" /></a><strong>To była prawdziwie ekstremalna uczta. Tłumy miłośników hip-hopu przybyły na ślesińską plażę, żeby wziąć udział w drugiej edycji „Ekstremialiów”. Na scenie wystąpili Kękę i Paluch.</strong>\n<a href="http://wielkopolska.tv/slesin-pod-presja-i-bez-strachu/#/?playlistId=0&amp;videoId=0" target="_blank" rel="noopener">zobacz materiał </a>\nŹródło: wielkopolska.tv', 'POD "PRESJĄ" I "BEZ STRACHU"', '', 'trash', 'open', 'open', '', 'pod-presja-i-bez-strachu__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://test20718.futurehost.pl/?p=74', 0, 'post', '', 0),
 (77, 1, '2017-07-31 12:29:16', '2017-07-31 12:29:16', '<a href="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/pilka.jpg"><img class="alignleft" src="https://images.pexels.com/photos/274506/pexels-photo-274506.jpeg?h=350&amp;auto=compress&amp;cs=tinysrgb" alt="" width="215" height="143" /></a><strong>W najbliższą niedzielę nie odbędzie się Sołecka Liga Piłki Nożnej. Zamiast tego rozegrany zostanie turniej piłki nożnej „Wykop cukrzycę" na ORLIKU na Osiedlu Północ. Turniej rozpocznie się od 10:00 do14:00 godziny. </strong>\nZapisy drużyn od godz.9.30. Maksymalnie 10 osób w drużynie. Dla każdego upominek turniejowy.\nRozgrywki ligowe w następną niedzielę - runda V.\n<a href="https://www.facebook.com/photo.php?fbid=1399474570088201&amp;set=ms.c.eJxFkMENA0EIAzuKMJiF7b~_xKJDzfUdjDCDuZTHLrNsNHzwg6MjgH2ScnwH3xzh3jBfURvBG7qlkdcrYCBTpGGAtwAX1zOAYpIw7Q9s19GIjJsAxwjRjV1dt2lyLhAAWqNY2koqcaeE79PcbB~_sIYGoRAjZGq~_XMcXS1~_O4RMrDHWcrwBdojbH56~_QWXYFnZ.bps.a.1399474506754874.1073742133.100000770135924&amp;type=3&amp;theater" target="_blank" rel="noopener">Zdjęcia Henryka Zajferta z rozgrywek piłki nożnej 16 lipca.</a>', 'Turniej \'Wykop cukrzycę\'', '', 'trash', 'open', 'open', '', 'turniej-wykop-cukrzyce__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://test20718.futurehost.pl/?p=77', 0, 'post', '', 0),
 (79, 1, '2017-07-31 12:30:12', '2017-07-31 12:30:12', '<img class="alignleft size-full wp-image-164" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/plakatturniejsiatkowkiSzyszyn.png" alt="" width="1431" height="2024" />', 'Turniej Siatkówki Plażowej w Szyszynie', '', 'trash', 'open', 'open', '', 'turniej-siatkowki-plazowej-w-szyszynie__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://test20718.futurehost.pl/?p=79', 0, 'post', '', 0),
 (85, 1, '2017-07-31 12:47:29', '2017-07-31 12:47:29', '<span style="color: black;">Najważniejsze wydarzenia w historii miasta Ślesina:\n<img style="margin: 5px;" src="http://gminaslesin.futurehost.pl/wp-content/uploads/sleshistoria.jpg" width="300" align="right" /></span>\n\n* okres rzymski - przez tereny, gdzie obecnie leży gmina Ślesin wiódł niegdyś szlak bursztynowy, łączący imperium rzymskie z wybrzeżem Bałtyku,\n* V w. p.n.e. - według legendy prasłowiański ród Szleszy zakłada na terenie dzisiejszego Ślesina osadę,\n\n* 1231 rok - pierwsza wzmianka o miejscowości w dokumencie księcia Konrada Mazowieckiego, który w tymże roku nadał wieś Szleszyno biskupom poznańskim w zamian za zaciągnięte długi, w ich posiadaniu była do końca XVIII w.\n\n* 1358 rok - otrzymanie średzkich praw miejskich przez króla Kazimierza Wielkiego. Biskup poznański, Jan Teczyński, uhonorował wtedy miasto herbem Dulicz. Herb ten, w zielonym polu czerwona litera T na złotym półkolu, do dziś jest godłem gminy (obecne badania nad historią miasta dowodzą, że biskup Teczyński nie mógł nadać miastu herbu Dulicz). Prawa miejskie pozwoliły na gospodarczy rozwój młodego miasteczka, gdzie mieszkańcy prowadzili handel m.in.: owcami, wołami i trzodą chlewną z niemieckimi kupcami. Odbywały się tu 8 razy w roku jarmarki połączone ze spędem bydła.\n\n* od 1579 roku używana jest obecna nazwa miasta,\n\n* 1793 rok - miasto pod zaborem pruskim,\n\n* 1807 rok - miasto w Księstwie Warszawskim,\n\n* 1812 rok - wzniesienie przez mieszczan ślesińskich na cześć Napoleona I najoryginalniejszego zabytku miasta - Łuku Triumfalnego z orłem napoleońskim,\n\n* 1815 rok - miasto w Królestwie Polskim,\n\n* 1870 rok - utrata praw miejskich, po zrywach narodowowyzwoleńczych, w których mieszkańcy Ślesina czynnie uczestniczyli\n\n* 1913 rok - Ślesin liczy 2034 mieszkańców,\n\n* 1921 rok - odzyskanie praw miejskich, równocześnie z tworzeniem się nowego państwa polskiego - II Rzeczypospolitej. W chwili wybuchu II wojny światowej Ślesin liczył ponad 2500 mieszkańców.\n\n\n<b>Przed powstaniem polskiej państwowości</b>\nCzłowieka zawsze zastanawiały jego korzenie. Odpowiedź na pytanie "skąd pochodzimy" jest trudna i od dawna oparta na teoriach. Obecnie uważa się, że Słowianie Zachodni przybyli na tereny obecnej Polski z dorzecza Dniepru (dzisiejsza Ukraina) już w V wieku.\n\nNim przybyli na obecnie zajmowane ziemie, nasi praprzodkowie znajdowali się pod zwierzchnictwem władców państwa gockiego. Wyparły ich stamtąd jednak ludy turecko-mongolskie, przede wszystkim Hunowie uznawani za niepokonanych. Wielka wędrówka na zachód została zapoczątkowana pokonaniem przez ludy mongolskie gockiego króla Hermanaryka, co rozbiło jego państwo i dało Sklawenom, jak się dawniej określało Słowian, wolny wybór. Z tamtych odległych czasów w naszym języku pozostały takie gockie pozostałości, jak ocet, cesarz czy czasownik kupić.\n\nPraprzodkowie Polaków osiedlili się w dorzeczu Wisły i Odry. Po rozejściu się w różne miejsca tej części Europy tworzyli mniej lub bardziej powiązane ze sobą plemiona. Przodkowie Wielkopolan, czyli Polanie, osiedli nad dorzeczem Warty. Jednak nie były to już obszary wyludnione. Od II w p.n.e. do IV w. n.e. swoje osady miało tu germańskie plemię Wenedów (obszar ten wtedy należał do Germanii). Składało się ze spokojnych rolników, sprawnych rzemieślników i pośredników w handlu bursztynem, który przewożono z ujścia Wisły do rzymskich prowincji.\n\nZimą roku 406 n.e. część Wenedów z Alanami i Swebami przekroczyła Ren i wyruszyła do Galii, by szukać tam lepszego życia, nowych bogactw i miejsc do osiedlenia... Część jednak pozostała, uważając pewnie te tereny za swoje i korzystając ze szlaków handlowych łączących Skandynawię z Europą Południową. Pod koniec V wieku doszło wreszcie do pokojowego spotkania tych ludów germańskich z przybywającymi dopiero słowiańskimi. Tym samym nastał okres kiedy to obie nacje mieszkały obok siebie, wchodziły we wspólne związki małżeńskie, a nawet stworzyły słowiańsko - wandalską federację. To od German Słowianie nauczyli się wielu praktycznych umiejętności - ich sąsiedzi byli przecież dobrymi rolnikami i zręcznymi rzemieślnikami.\n\nO bliskiej współpracy obu ludów świadczy pewien interesujący fakt, który znany jest historykom. Otóż grupa Wanadów, która opuściła swoje ziemie nad Wartą utrzymywała ciągle ze swoimi braćmi kontakt. Król Wandalów po zdobyciu Rzymu w 455 r. n.e. wysłał do swoich krewnych cesarską chorągiew z orłem. To właśnie ten ptak pojawia się potem na monetach bitych przez Piastów i staje się godłem państwa polskiego.\nO tej wspólnej przeszłości pamiętały kolejne pokolenia o czym świadczy zapis w roczniku Kościoła Niemieckiego mówiący, że 25 maja 992 roku zmarł król Mieszko I, król Wandalów. Z racji swojego militarnego doświadczenia Wandalowie musieli pełnić więc funkcje wodzowskie. Po paruset latach różnice między Wandalami i Słowianami zanikły, połączone wspólną kulturą, krwią i językiem. Oczywiście większość tych plemion od początku stanowili Słowianie i to ich język wyparł z czasem wandalski, który był używany tylko przez elity rządzące i z czasem popadł w zapomnienie.\nI tu właśnie pewnym śladem po tych historycznych wydarzeniach są niesłowiańskie słowa ślesińskiej kminy ochweśnickiej: wardol – pole, gratka – brona, oks – las, bulšt - kowadło, hakal – siekiera, ho ot – koń, dola – część, olehy – pieniądze, part – spółka handlowa, šlir – handel, wasiela – duchowny, manki – ja, skić – dziecko, lepić – żyć, być, haza – dom, knajać – iść, chodzić, kelc – miasto, 1 – iomny, 4 – ćfira, 6 – skerot, 8 – ohtumera, 10 – dziakonos, 100 – kumat, 1000 – kulor.\n\n<b>Wschodnia Wielkopolska w czasach najdawniejszych</b>\nJak kształtowały się początki naszych okolic? Badania archeologiczne wskazują, że twórcami pierwszego ośrodka politycznego we wschodniej Wielkopolsce mogli być Wikingowie, normańscy wygnańcy szukający nowego domu dla siebie. Banitów nazywano ut-lach (słowo lach oznaczało prawo, choć również - towarzysz), czyli człowiek wyjęty spod prawa (ang. outlaw). Być może od tego określenia naszych przodków zwykło się nazywać Lachami. Natomiast Gall Anonim nazywał Lestkami Lechitów panujących we wschodniej Wielkopolsce przed Piastami. Ich ostatnim królem miał być Popiel. (Szajnocha 1876)\n\nSzlak Bursztynowy przebiegający przez obszar na którym obecnie leży Ślesin sprzyjał rozwojowi handlu. Możliwe, że już przed słowiańską osadą istniał tu niegdyś inny ośrodek. W I w. n. e. Ptolemeusz, uczony grecki, w Geografii wyrysował mapę ówczesnego świata, a na niej pod współrzędnymi 43°, 45’, 52°, 20’ umieścił miejscowość Setidawa, która po przeliczeniu błędów kartometrycznych położona była ok. 3 km od Ślesina. Leżała ona na wspomnianym wyżej szlaku bursztynowym i musiała być związana z wymianą dóbr. Być może nasze miasto kontynuuje osadnicze i handlowe tradycje tamtej osady.\n\n<b>Początki miasta</b>\n\nWedług legendy nazwę miastu Ślesin nadano od imienia rodu Szleszy, który zasiedlił we wczesnym średniowieczu okoliczne pola nad jeziorem. Przez wieki ulegała ona przekształceniom - Sleszyn, Slessyno, Szlyeszyno, Sliesin. Ostatecznie w 1889 roku ustalona została oficjalna, obowiązująca dzisiaj, wersja nazwy.\nNiemieckie określenie miasta to Schlüsselsee, które można odnieść do miasta położonego nad "kluczowym (znaczącym) jeziorem". Widnieje ona na mapach niemieckich z I połowy XX wieku. Obowiązywała w czasie niemieckiej okupacji.\n\nPierwsza wzmianka o Ślesinie pojawiła się w 1231 roku w dokumencie księcia Konrada I Mazowieckiego, który w tymże roku nadał wieś biskupom poznańskim w zamian za zaciągnięte długi (w ich posiadaniu była do końca XVIII w).\n\n20 stycznia 1358 roku miejscowość Szleszyno otrzymała średzkie prawa miejskie nadane przez króla Kazimierza Wielkiego. Biskup poznański Jan Teczyński miał uhonorować wtedy miasto herbem Dulicz. Wiele źródeł donosi, że to właśnie ten biskup stał się pierwszym właścicielem grodu i dlatego jego herb po dziś dzień jest godłem miasta. Czy rzeczywiście tak było? Bardziej wnikliwe spojrzenie na tamten okres średniowiecza wskazuje na to, że doszło tu do przekłamania. Na liście arcybiskupów i biskupów archidiecezji stworzonej w oparciu o podania Długosza nie ma takiego kapłana (<a href="http://www.archpoznan.pl/arcybiskupi_i_biskupi_od_968_roku.html" target="_blank" rel="noopener">zobacz wykaz biskupów poznańskich od 968 roku</a>). W omawianym czasie w Poznaniu piastował tę funkcję Jan V Doliwa z Lutogniewa. Wskazuje to zatem na wątpliwą wiarygodność przekazu, który utrwalił się w wielu charakterystykach miasta. Jan Doliwa nie mógł bowiem nadać herbu, którego nie był właścicielem (w czasie spotkania historycznego w Ślesinie na początku marca 2011 roku roku podkreślił ten fakt historyk dr Piotr Gołdyn).\n\nZ okresu lokacji miasta pochodzi układ urbanistyczny Ślesina opierający się na małomiasteczkowej zabudowie z murowanymi parterowymi domami. Jednym z przywilejów przysługujących miastu było prawo zakładania targów na 7 lat. Pozwoliło to na gospodarczy rozwój młodego miasteczka, gdzie mieszkańcy prowadzili handel z niemieckimi kupcami m.in.: owcami, wołami i trzodą chlewną. Odbywały się tu 8 razy w roku jarmarki połączone ze spędem bydła. Najważniejszy był ten związany z odpustem św. Walentego 14 lutego. Odprawiano wtedy mszę odpustową. Wierni przed obrazem św. Walentego składali wota jako podziękowanie za uzyskane łaski. Po liturgii udawali się na przykościelny plac z taszami, małymi stoiskami handlowymi.\n\nJuż wtedy zaznaczyły się korzyści z położenia miasta na szlaku handlowym łączącym Wielkopolskę z Mazowszem (później ożywione zwłaszcza pomiędzy Poznaniem a Warszawą). Nigdy jednak nie rozrosło się ono ani liczebnie, ani gospodarczo. O małym znaczeniu przekonuje fakt, że w 1458 roku w czasie "wojny trzynastoletniej" prowadzonej z Zakonem Krzyżackim osada była zobowiązana wyposażyć i wysłać tylko dwóch pieszych, zasilając w ten sposób królewską drużynę. Było to zobowiązanie ślesińskich mieszczan wobec króla polskiego Kazimierza Jagiellończyka.\n\nSzacuje się, że w Ślesinie stały drewniany most oddzielający dwa jeziora istniał przynajmniej od XIV w. Wspomina o nim Kodeks Dyplomatyczny Wielkopolski, gdzie pod rokiem 1314 widnieje informacja o przywileju ślesińskiego proboszcza do połowu ryb między Przewłoką, a mostem w Ślesinie.\n\nOd najdawniejszych czasów mieszkańcy Ślesina zajmowali się rolnictwem i handlem. Specjalnością ślesinian stal się jednak handel pierzem i hodowla gęsi, które jak mówi legenda - "podkuwano". Polegało ono na przegonieniu stada ptaków przez smołę i rozsypane pierze.\n\nW dokumentach archiwalnych można doszukać się ciekawych zapisków, które dobrze świadczą o rozwoju miasta. Kodeks Dyplomatyczny Wielkopolski tom V wspomina pod datą 1 czerwca 1414 roku o Jakuszu Sarnowskim, dziedzicu Sarnowa i Boguszu Szyszyńskim, dziedzicu Szyszyna, którzy pożyczyli od proboszcza ślesińskiego Przesława po 5 grzywien. Poświadcza to Adreas <i>rector et Scholae de Szleszyno </i>- Andrzej, rektor szkoły w Ślesinie. Świadczyć to może o tym, że już pod koniec średniowiecza w mieście mogła istnieć pewna zorganizowana forma nauczania.\nNatomiast w dziele Jana Długosza <i>Chorographia Regni Poloniae</i> z końca XV wieku natrafiamy na opis Jeziora Ślesińskiego i położonej na jego krańcu Góry Przewłoki na której jeszcze w XIV w. znajdował się gród warowny.\n\n<b>Kmina ochweśnicka</b>\nWraz z handlem w okolicach wytworzył się żargon zwany "kminą ochweśnicką", którym posługiwali się wysłannicy skulskich malarzy tworzących obrazy kultu maryjnego - ochweśnicy (od gwarnego "ochweśnik"- obraz religijny). Gwary tej używano także w Częstochowie. W Ślesinie używano jej między innymi wśród handlarzy i lekarzy (tak zwanych "medycyniarzy"). Wielu z nich było oszustami, którym gwara służyła dla zmylenia naiwnych klientów.\n\nŻargon ochweśnicki miał niewielką liczbę słów (ponad 800) różnego pochodzenia: były to wyrazy niemieckie, rosyjskie, łacińskie, żargon więzienny, złodziejski, zapożyczone z różnych gwar, a także wyrazy oryginalne, tworzone przez samych ślesinian, np. koryga -dziewczyna, jarus - ojciec, kimać - spać, agata - gęś. Gwara ochweśnicka zaczęła zanikać w okresie międzywojennym. jednak do dziś dzięki kultywowaniu tradycji przez rdzennych mieszkańców Ślesina utrzymuje się ona wśród niewielkich grup handlarzy.\n\nNie można jednak zapominać o etnicznej przynależności mieszkańców gminy do Wielkopolski. Podobnie jak w innych częściach regionu, tak i w gminie Ślesin, używa się gwary poznańskiej, która jest szerzej i powszechniej wykorzystywana w porównaniu z kminą ochweśnicką. Dlatego też nie obce są tu takie określenia jak:\nbamber (mieszkaniec wsi, rolnik), bryle (okulary), czarnina (w innych częściach kraju czernina), dynks ("coś" nieokreślonego), gapa (czarny ptak - kruk, wrona lub kawka), gira (noga), glizda (dżdżownica), guzdrać się (ociągać się), guzik ( wraz "nadusić g." zamiast "nacisnąć" - guzik to też określenie "przycisku"), gzik (twarożek ze śmietaną i szczypiorkiem), jucha (krew), knypek (mały człowiek), laczki, papcie (kapcie), lofer (jest często poza domem), lumpy (niechlujne ubrania), lufcik (małe dodatkowe okienko), cug (przeciąg), nicpoty (urwis), proszczak (prosiak), pyra (ziemniak i mieszkaniec Wielkopolski), pyzy (kluski na parze), szagówki (kopytka), iść na szagę (iść na skróty/skos), ryczka (stołek), siano (pieniądze), tytka (torebka papierowa), szneka (drożdżówka), ukrychać (rozdrobnić np. ziemniaki), wajcha (dźwignia), wihajster (rzecz bez nazwy), wuchta wiary (dużo ludzi), wuja (wujek), zimne nóżki - galart (mięso w żelatynie), żybura (brudna woda).\n\nWięcej o kminie ochweśnickiej można dowiedzieć się z książki Pawła Pachulskiego "Słowa nie pochodzą znikąd".\n\nRozwój miasta w I Rzeczpospolitej\nW XVI wieku Ślesin znajdował się na terenie województwa kaliskiego w ramach Prowincji Wielkopolskiej, powiatu konińskiego (o innym przebiegu granic niż obecnie).\n\nOd 1579 pojawia się obecna nazwa miasta. W tym roku w rejestrze podatkowym umieszczono adnotację o jego przynależności do biskupów poznańskich. Zgodnie też z kolejnym wpisem z 1618 roku, Ślesin określono jako wieś w której pracuje 4 rzemieślników i 2 rybaków. Pozostali mieszkańcy mieli zajmować się rolnictwem. W 1604 roku na miejscu zniszczonej świątyni postawiono murowany kościół w stylu gotyckim, pw. św Mikołaja i Dobrego Pasterza. W ołtarzu bocznym znajduje się pochodzący z końca XVIII w. późnobarokowe retabulum z obrazem przedstawiającym św. Mikołaja Biskupa. W 1900 roku na byłych fundamentach wzniesiono tam prezbiterium i 2 kaplice istniejące do dziś. W kruchcie zobaczyć można też kamienną kropielnicę z X wieku (sugerującą pierwszy obiekt sakralny w Ślesinie już za czasów Mieszka I). Znaki rylcowe na drugiej kropielnicy do tej pory mają swe niewyjaśnione znaczenie.\n\nHerb o którym zapomniano... Z XVII pochodzi najstarsza pieczęć związana z miastem - widnieje na niej blankowany mur obronny w którym umieszczono bramę, a w niej klucz Piotrowy. Mur miał symbolizować prawa miejskie osady, a klucz nawiązywał do własności kościoła poznańskiego.\n\nPotop szwedzki nie oszczędził Ślesina i rozpoczął niepomyślny okres w historii miasta. Kiedy to Karol Gustaw wraz ze swoimi wojskami liczącymi 25 tys. os., stacjonował w Koninie w sierpniu 1655 roku oddziały najeżdżały i plądrowały również okolice. Wtedy to w trakcie najazdu Szwedzi spalili zabytkowy drewniany kościół, który wprawdzie potem odbudowano, ale został on następnie zniszczony w pożarze.\nPoczątek XVIII w. przyniósł w Polsce epidemię dżumy, które trwała parę lat, 1708 - 1711 r. Choroba dotkliwie dotknęła też mieszkańców Ślesina. To wtedy wymarło wiele starych rodów, a chorzy przeczuwający nadejście śmierci sami sobie kopali groby i kładli się w nich, by tam skonać. Stawiano tam później dwuramienne drewniane krzyże. Jak donoszą rejestry ludności, zarazę przeżyło jedynie 179 mieszkańców miasta.\n\nZ kolejnym żywiołem, tym razem naturalnym, miasto musiało się zmierzyć w 1725 roku, kiedy to Polskę nawiedzały powodzie, które dotknęły też osady położone nad jeziorami ciągnącymi się od Warty do Gopła. Nabrzeżne domostwa zostały zalane, a ludzie zmuszeni byli je opuścić i szukać wyżej położonych terenów do osiedlenia, jakim była pobliska puszcza. Budowano tam szałasy czekając na opadnięcie poziomu wód, a gdy do tego doszło zaczęto odbudowę strat.\n\nOkoło 1770 roku Olch Gród, herszt zbójeckiej bandy ze ślesińskich borów zostaje osądzony i stracony przez powieszenie w Środzie Wielkopolskiej.\n\nOkres rozbiorów\nOd 1793 roku miasto, wraz z całą Wielkopolską, znalazło się pod zaborem pruskim. Ówczesne dane podają iż miasto zamieszkiwało w tym okresie 175 mieszkańców, z czego większość trudniła się rolnictwem, a na jego terenie znajdowało się 45 drewnianych domów. Właściciel miasta posiadał 2 wiatraki. Wzrostowi populacji sprzyjały ośmiokrotne jarmarki w ciągu roku połączone ze spędem bydła. Już w 1800 roku miasto liczyło 489 osób, co świadczy o rozwoju gospodarczym.\n\nW XVIII wieku ziemiami pruskimi władali Hohenzollernowie. Po włączeniu w wyniku II rozbioru, ziemie polskie utworzyły Prusy Południowe - Südpreussen. Związane są z tym wydarzeniem legendy pieczęci miejskich zredagowane w języku niemieckim wraz z położeniem miast w nowych granicach podziału politycznego i administracyjnego. Jedną z nich jest legenda pruskiej pieczęci Ślesina (Adamczewski 2010). Na terenach na których panował pruski król funkcjonowały albo miasta domeny królewskiej, albo miejscowości prywatne szlacheckich posesorów, tzw. Mediatstädte. Tym samym uniemożliwiono władzy kościelnej posiadanie władzy nad miastem. Jak wyżej wspomniano, przed rozbiorem Ślesin był własnością kościoła poznańskiego. Sekularyzacja dokonywana przez władze pruskie doprowadziła do przejęcia wtedy dóbr stołowych biskupów, w wyniku czego Ślesin oddano w ręce szlacheckich posesorów. Jednocześnie na przełomie XVIII i XIX wieku władze stworzyły nową pieczęć prywatną miasta, która zupełnie różniła się od przedrozbiorowego wyobrażenia znaku miasta. Wiązało się to ze zmianą właściciela z kościelnego na szlacheckiego. W czasie pruskiej podległości magistrat policji, który pełnił wówczas rolę władz miejskich posługiwał się pieczęcią z wizerunkiem kozła Walknowskich (Adamczewski 2010). Znak ten pojawiał się w dokumentach miejskich przez wiele kolejnych dekad (po prawo herb Wieruszew z motywem kozła).\n\nBrama Napoleona\nW 1807 roku miasto znalazło się w Księstwie Warszawskim utworzonym na mocy traktatów pokojowych Cesarstwa Francji, królestwa Prus i Cesarstwa Rosji. W 1812 roku mieszkańcy Ślesina budują Łuk Triumfalny, który do dziś jest najcenniejszym zabytkiem w mieście. Mają nadzieję nie tylko na odzyskanie przez ojczyznę niepodległości, ale i na uchronienie się od wysokich danin na rzecz armii napoleońskiej przechodzącej przez miasteczko. Brama składa się z głównej, półkoliście zamkniętej arkady i dwóch niższych, bocznych, które służą za przejścia dla pieszych i jest skromnym odpowiednikiem paryskich lub warszawskich łuków. Na niebieskiej elewacji można dostrzec 4 białe, płaskie pasy muru, które imitują kolumny o jońskich głowicach. W czasie w którym powstała była ważnym i reprezentacyjnym znakiem miasta, które posiadało wówczas prawie wyłącznie drewnianą zabudowę.\nZwieńczeniem bramy według niektórych źródeł miał być autentyczny Orzeł Napoleoński, choć bardziej wnikliwe badania wskazują na to, że dziedzic z Piotrkowic kazał tam umieścić orła pruskiego. Zmienia to utarte od lat pojmowanie tego zabytku.\n\nJak powszechnie się uważa sam cesarz nigdy jednak nie zobaczył budowli, choć przez miasteczko wiódł trakt, którym maszerowały cesarskie wojska. Czy jednak na pewno? Dorota Matyjaszczyk, były pracownik poznańskiego oddziału Narodowego Instytutu Dziedzictwa, przekonuje, że Napoleon faktycznie był w Ślesinie i to 2 razy (<a href="http://www.studiaperiegetica.pl/pub/7_2_2008.pdf" target="_blank" rel="noopener">przeczytaj)</a>! Pierwszy raz 16. grudnia 1806 roku w trakcie podróży do Warszawy, choć wówczas nie mógł zobaczyć łuku triumfalnego, bo jeszcze go nie zbudowano. Mógł go zobaczyć jednak, gdy wycofywał się po przegranej wojnie z Rosją 11. grudnia 1812 roku. Wtedy to przejeżdżał przez miasteczko drugi raz, ale ok. godz. 20:00 w ciemności mógł nie dostrzec Bramy.\nTo jedyny pomnik napoleoński, jaki pozostał z czasów Księstwa Warszawskiego. W czasach kolejnych zwycięstw Napoleona stawiano ku jego czci jednak wiele takich łuków. Nietrwałe materiały z jakich powstawały sprawiały, że dość szybko je rozbierano. Pomimo zawirowań historii i intencji upamiętnienia zwycięstw wojennych Napoleona walczącego z Prusakami i Rosjanami łuk przetrwał. Prawdopodobnie ze względu na niewielkie znaczenie miasta, a po powstaniu styczniowym nawet odebranie praw miejskich władze zaborcze nie zdecydowały się usunąć tego drogowego monumentu.\n<img style="margin: 5px;" src="http://upload.wikimedia.org/wikipedia/commons/f/f1/POL_COA_Wieruszowa.svg" width="107" align="right" />\nJak głosi tablica pamiątkowa budowlę wznieśli w 1812 roku ślesińscy mieszczanie na cześć Napoleona Bonaparte, który miał pod nią przejść po zwycięskiej kampanii rosyjskiej. Inne podania jednak głoszą, że fundatorem łuku był właściciel miasta i jednocześnie dziedzic z pobliskiej miejscowości Piotrkowice - Walknowski (Walichnowski) herbu Wieruszowa, a zbudował go ku czci księcia warszawskiego Fryderyka Augusta. Taką wersję podaje dziedziczka mikorzyńska, Anna Milewska, w opublikowanym artykule z 1880 r. w czasopiśmie "Wędrowiec".\n\nSam orzeł, który znajduje się na szczycie bramy budzi spory. Najczęściej uznaje się go za orła napoleońskiego. Część heraldyków widzi w nim jednak orła pruskiego, co może świadczyć o tym, że łuk triumfalny postawiono, by uczcić cesarza pruskiego Fryderyka II.\n\nWarto przy okazji dodać, że w samej kampanii napoleońskiej uczestniczyli również obywatele Ślesina. Jednym z nich był Marcin Fordon, żołnierz armii napoleońskiej, który po przegranej bitwie w 1812 roku osiadł w Ślesinie. Ożenił się tu z Rozalią Muzykiewicz i spolonizował swoje nazwisko na Fordoński. Rodzina o tym nazwisku nadal zamieszkuje miasto.\n\nPo Kongresie Wiedeńskim\nW 1815 roku miasto znalazło się w Królestwie Polskim. 10 lat później mieszkało w mieście w 107 domach 881 osób . W czasie zrywu niepodległościowego z 1863 roku walki toczyły się w pobliskim Ignacewie. Pamięć o tej krwawej bitwie i jej bohaterach obecna była w miejscowej społeczności, o czym świadczy pomnik wykonany z polnego kamienia z napisem "Poległym na chwałę - żywym na otuchę" postawiony w 1917 roku na mogile pochowanych powstańców. W starciach zginęło wówczas 180 polskich żołnierzy, w tym również mieszkańcy Ślesina czynnie uczestniczący w powstaniu. Znany polski malarz i ilustrator XIX wieku Juliusz Kossak upamiętnił to wydarzenie na obrazie "Bitwa pod Ignacewem" z 1965 r., który można obejrzeć w Muzeum Historycznym w Warszawie.\nW czerwcu 1863 r. personel Banku Polskiego w Warszawie przekazał powstańcom pod dow. Aleksandra Waszkowskiego depozyty kasy głównej Królestwa Polskiego - 3,6 mln zł, 5 tys. rubli i listy zastawne. Kasa powstańcza dla mniejszych oddziałów pochodziła jednak z zebranej biżuterii i innych wartościowych przedmiotów przekazywanych przez lokalną ludność. Stąd też pochodziła kasa powstańcza dla pułkownika E. Taczanowskiego w czasie I bitwy pod Ignacewem. To w tym czasie narodziła się legenda przekazywana przez mieszkańców Ślesina z pokolenia na pokolenie jakoby w obliczy przegranej zebrane datki i depozyty miały zostać ukryte. Miejscowi wielokrotnie próbowali odszukać te skarby powstańcze. Ich celem były pnie drzew, strychy wiejskich domów, niepewne grunty mokradeł i zakamarki leśne. Bez skutku...\n\nDo roku 1867 w Ślesinie istniał zarząd miejskim z burmistrzem Jan Nagajeckim na czele.Magistrat zajmował się wówczas sprawami gospodarki miejskiej - podatki, opłaty, prowadzenie księgi ludności miasta i obowiązek wykonywania zarządzeń władz zaborczych. Natomiast to policja carska zajmowała się edukacją, zdrowiem, bezpieczeństwem i porządkiem publicznym. Ten paraliżujący nadzór negatywnie wpływał na rozbudowę, rozwój gospodarczy i intelektualny miasta. W 1870 roku za czynne uczestnictwo obywateli w powstaniu doszło do utraty praw miejskich. 31 maja 1879 roku Ślesin znalazł się w gminie Sławoszewek należącej do powiatu konińskiego. Do znacznego ożywienia doszło dopiero na początku XX w.\n\nNa terenie obecnego rynku znajduje się Bank Spółdzielczy, który zaczął działalność w 1912 roku pod nazwą Kasa Stefczyka. Założycielem pierwszego ślesińskiego banku byli ks. Konstanty Iurgiłas, Maksymilian Kotłowski, Józef Lisiak, Józefa Targońska, Józef Ziółkowski. W takiej formie istniał do 1957 r, a później jako spółdzielnia oszczędnościowo-pożyczkowa. Bankiem spółdzielczym stał się w 1960 roku.\n\nW wyniku pokongresowych zmian granic Ślesin znalazł się około 30 kilometrów od granicy prusko-rosyjskiej. Lokalni handlarze gęsi wykorzystali ten potencjał. Skupowali ptaki nie tylko z Wielkopolski, ale i z bardziej odległych terenów, po czym sprzedawali je do Prus (niektóre źródła donoszą o milionach sztuk gęsi rocznie). Ze względu na dość znaczną odległość jaką trzeba było pokonać, aby dotrzeć do granicy gęsi "podkuwano", czyli przeganiano przez smołę i rozsypane pierze, aby w ten sposób lepiej zniosły trudy pieszej wędrówki. Wymiana handlowa dotyczyła również sacharyny i lnu. Aby zdobyć towar po jak najniższej cenie handlarze porozumiewali się między sobą lokalnym żargonem - gwarą ochweśnicką, niezrozumiałą dla osób postronnych.\n\nW XIX wieku powstają zespoły dworskie w Piotrkowicach (z dworem, parkiem o pow. 5,7 ha, czworakiem i spichlerzem), Mikorzynie i Biskupiu.\n\nPod koniec XIX wieku w Ślesinie pojawiają się pierwsze warsztaty krawieckie. Z czasem montowano tam pierwsze maszyny do szycia. Pracowała w nich głównie ludność napływowa, bo uważano, że trudniący się hodowlą gęsi ślesiniacy gardzą rzemiosłem i jedynie handel uważają za godne zajęcie. Amerykański wynalazek coraz częściej pojawiał się w wielu zwykłych domach. W połowie XX wieku były to już rodzima marka Łucznik, ale obecnie maszyna do szycia w dobie taniej i ogólnie dostępnej odzieży straciła na popularności w indywidualnych gospodarstwach domowych.\n\nJest to czas kiedy obok siebie w naszej gminie żyją w zgodzie wyznawcy różnych religii. Większość oczywiście stanowili katolicy, ale obok nich sporą część zajmowali Żydzi, niemieccy osadnicy należący do kościoła ewangelicko-augsburskiego i prawosławni. Swoją świątynię mieli w Ślesinie wyznawcy judaizmu, a protestanci przez 3 lata własną parafię. Do I wojny światowej o tolerancji religijnej świadczyło bezproblemowe tworzenie lokalnej wspólnoty. Dzieci różnych wyznań bawiły się razem i chodziły do tej samej szkoły. Nie odnotowano też w życiu politycznym żadnych przejawów dyskryminacji.\n\nW 1901 roku powstała Ochotnicza Straż Ogniowa, w 1908 założono kółko rolnicze, a w 1912 Towarzystwo Pożyczkowo-Oszczędnościowe, później Kasa Stefczyka.\nW latach 1910 - 1912 na terenie gosławickich dóbr, które należały do hrabiego Kwileckiego z Malińca przy okazji budowy cukrowni założono również bocznice i tory kolei wąskotorowej łączące tereny plantacyjne z miejscem odbioru buraków cukrowych. Ciągnęły się do punktu granicznego w Anastazewie. Jedna z popularnych ówczesnych tras kolejowych wiodła z Konina, przez Kleczew, Ślesin do Sompolna.\n\nZ inicjatywy ks. Jana Langiera w latach 1906 - 1907 w Ślesinie w parafialnym kościele dobudowano wieżę z dzwonnicą i nowym dzwonem. W dniu jego poświęcenia w uroczystej procesji przewieziono go wozem konnym przez miejskie ulice. Do korony dzwonu doczepiono kolorowe wstęgi, które z wolnej strony trzymało kilkunastu mieszkańców Ślesina - fundatorów daru dla parafii. Prawdopodobnie nazwano go imieniem św. Wojciecha. Niemcy w czasie okupacji wywieźli dzwon z miasta. Nigdy już do niego nie wrócił.\n\nTuż przed I wojną światową w Ślesinie pojawia się telegraf. Zaczął nadawać informacje w alfabecie Morse\'a w 1913 r.\n\n<b>Dwudziestolecie międzywojenne</b>\n\nNa przełomie lat 1918/1919 mieszkańcy Ślesina i okolic uczestniczyli w powstańcu wielkopolskim - zbrojnym wystąpieniu polskich mieszkańców Wielkopolski przeciwko państwu niemieckiemu domagających się powrotu ziem zaboru pruskiego do polskiej macierzy. Upamiętniając to wydarzenie jednemu z miejskich osiedli nadano nazwę na część walczących o wolność. Nowo odzyskanej niepodległości Polacy musieli bronić przed najazdem Armii Czerwonej ze wschodu. W 1920 roku wielu mieszkańców Ślesina brało czynny udział w wojnie polsko-rosyjskiej. Po zwycięskiej walce obywatele miasta wrócili wraz z grupą jeńców rosyjskich. Wykorzystano ich do budowy odcinka kolei wąskotorowej na trasie Kleczew - Ślesin i Ślesin - Sompolno.\n\nMieszkańcy miasta z dużą radością powitali odzyskanie przez Polskę niepodległości. Wtedy to powstał spontanicznie Obywatelski Komitet Straży Bezpieczeństwa. Rozpoczyna się okres znacznego rozwoju miasta. Odnawiano domy. brukowano ulice, budowano chodniki. Duże zasługi należy przypisać, działającemu od 1906 roku, ks. Janowi Lagierowi, który jako aktywny patriota i społecznik nawoływał w czasie mszy świętych do pomocy w brukowaniu ulic. Mieszkańcy odpowiadali czynem. Dochodziło nawet do sytuacji, że dzieci przynosiły na lekcje po jednym kamieniu. Gliniane domy zastępowano murowanymi, a drogi dotąd piaszczyste brukowano polnym kamieniem.\nDo lat 20. XX w. jedynym publicznym ujęciem wody pitnej była studnia czerpalna stojąca na ślesińskim rynku. Wtedy jednak rozebrano jej górną część i przykryto betonową płytą na której osadzono żeliwną pompę. Sprawna i używana była do końca lat 70. Obecnie po rewitalizacji rynku w 2010 r. i zasypaniu studni w jej miejscu stoi jedynie atrapa o znaczeniu czysto turystycznym.\n\nW latach 20. XX wieku ślesińskie władze zainicjowały projekt położenia nowych torów kolei wąskotorowej. Posiedzenie Rady Miejskiej 3. grudnia 1921 roku przyniosło uchwałę stanowiącą o potrzebie budowy nowej linii kolejowej łączącej Ślesin z Kramskiem. Pomysłodawcą przedsięwzięcia był inżynier Mierzyński. Pomimo to plany te nigdy nie zostały zrealizowane, a ich kres przyniósł ostatecznie wybuch II wojny światowej.\n\nZ inicjatywy Centralnego Towarzystwa Rolniczego w Warszawie we wrześniu 1926 roku w Ślesinie odbywa się Wystawa Przemysłu i Rolnictwa. Jest to dowód uznania dla powiatu konińskiego i słupeckiego, które uważano za czołówkę powiatów hodowlanych w Polsce. Biorą w niej udział 3 grupy wystawców. W pierwszej grupie swoimi dokonaniami chwalą się hodowcy koni, bydła, świń, owiec, drobiu i psów. Grupa druga to specjaliści w uprawie roślin, a trzecia - producenci i sprzedawcy maszyn rolniczych.\n\nWoda nierozłącznie związana była z historią miasta, choć odmęty jeziora w ludowej tradycji pełne były zwodniczych utopców (wodników), które odpowiedzialne były za liczne niegdyś utonięcia. Być może przez te wierzenia mieszkańcy Ślesina niedaleko mostu wybudowali pomnik św. Jana Nepomucena, patrona mostów i tonących. Niestety budowla nie przetrwała wojny.\n\nW 1921 roku Ślesin odzyskał prawa miejskie posiadając populację liczącą 2 078 osób i 209 domów. Ślesinianie w podzięce za wolną ojczyznę wybudowali w 1922 roku Pomnik Św. Rodziny, który potem w czasie II wojny światowej w 1940 r. zostanie zniszczony przez hitlerowców i odbudowany dopiero w 1991 roku. Trzeba pamiętać o mniejszościach jakie mieszkały dość licznie wtedy na tych terenach - byli to wspomniani wcześniej osadnicy niemieccy i Żydzi.\n\nW pierwszych latach II Rzeczpospolitej ślesiński magistrat próbował doszukać się wizerunku pieczęci miejskiej i herbu Ślesina. Zebrane wtedy dokumenty uwierzytelniały odciski pieczęci napisowej. Miasto posługiwało się w kolejnych latach nowym i nietypowych znakiem - w okresie 1922 - 1927 opracowano herb z wizerunkiem bramy Napoleona o trzech przejazdach i 4 kolumnach zwieńczonej koronowanym Orłem Białym (wyobrażenie trafiło potem na miejskie pieczęcie). W 1934 roku zarządowi miejskiego przydzielono owalną pieczęć z godłem państwa (z racji nieustalonego wówczas poprawnego herbu miasta). W międzywojniu magistrat dysponował też tłokiem pieczęci miejskiej z 1662 roku, który posłużył w 1868 roku ankiecie heraldycznej.\n\nOd 1922 do 1939 roku w budynku, gdzie mieściła się Kasa Stefczyka, działała biblioteka. W latach 1929 - 1934 zbudowano nowy budynek szkoły podstawowej. Niejednokrotnie odbywały się bale karnawałowe i charytatywne podczas których zbierano datki na rzecz Czerwonego Krzyża. Popularny wówczas teatr amatorski wystawiał przedstawienia.\n\nW grudniu 1934 roku ślesiński oddział Czerwonego Krzyża zainicjował dożywianie 80 dzieci w jednej ze szkolnych klas. Pożywienie wydawali starsi uczniowie, członkowie młodzieżowego PCK. Przy wejściu dziewczynki z białymi opaskami z czerwonym krzyżem sprawdzały czy dzieci mają czyste ręce. Gdy tak nie było odsyłano je do umywalni. Była to też okazja do uczenia dzieci dobrego zachowania przy stole.\n\nW latach 30. propagowaniem sportu zajmował się Związek Strzelecki. Była to forma przygotowania się do służby woskowej. W 1936 roku w ślesińskiej remizie strażackiej odbyły się eliminacje w zawodach bokserskich drużyn Akademii Wychowania Związków Strzeleckich. Ślesińskich zawodników trenował Walenty Andrzejewski. Przed walkami odbyły się pokazy ćwiczeń artystycznych, które były obowiązkowe dla ówczesnych bokserów. W wadze papierowej stanęli przed sobą Wiktor Sobierajski i Jerzy Sybirski, który zwyciężył na punkty. W wadze muszej Sybirski pokonał Franciszka Andrzejczaka. W wadze koguciej Kazimierz Wasicki pokonał Stanisława Sojatowskiego. Pojedynek w wadze lekkie zakończył się nokautem Stanisława Działakiewicza, który przegrał z Andrzejem Sobieralskim. Walka w wadze półśredniej zakończyła się zwycięstwem Marcina Mertkowskiego nad Henrykiem Cieślakiem.\n\nŚlesińskie Koło Rodzin Policyjnych w 1936 roku zainicjowano otwarcie ślesińskiej kuchni dla ubogich, która serwowała nie tylko potrawy, ale i rozdawała ciepłą odzież. W latach 30. działała Liga Morska i Kolonialna reprezentująca polskie aspiracje do tworzenia zamorskich kolonii podległych RP. Na terenie miasta znajdował się oddział tej instytucji. Z powodzeniem rozwijało się też harcerstwo. Działał Związek Strzelecki oraz oddział polskiej Ligi Obrony Przeciwlotniczej i Przeciwgazowej. Organizacje te w latach 1936 - 1939 aktywnie prowadziły zbiórki pieniężne na Fundusz Obrony Narodowej. Ślesińskie organizacje woskowe w 1939 roku przekazały na fundusz 2 205,17 zł, co pozwalało na sfinansowanie 10% wartości samolotu łącznikowego typu RWD-8.\n\nTuż przed wojną, od 25 czerwca do 2 lipca 1939 roku ślesiński oddział Ligi Morskiej i Kolonialnej zorganizował w Ślesinie obchody Ligi Morza. Sprzedawano wówczas specjalne broszury propagujące polskie aspiracje do stworzenia podległych Polsce zamorskich kolonii, wzorując się na tych angielskich, francuskich czy niemieckich. Na Dniach Morza zebrano ok. 90 zł, które przekazano do Głównego Komitetu Wykonawczego Ligi Morza w Warszawie. Uczestnicy święta złożyli uroczyste ślubowanie przekonując, że Polska od Bałtyku odepchnąć się nie da. Odśpiewano też pieśń <i>Boże coś Polskę</i>.\n\nPrzed wybuchem wojny miasto znajdowało się na terenie województwa poznańskiego, na obszarze powiatu konińskiego. Agresja III Rzeszy wydawała się nieunikniona, dlatego też w czerwcu 1939 r. nad brzegiem J. Ślesińskiego oraz kanału Warta - Gopło kompania z XVII Dywizji Piechoty, grupa junaków i 37 robotników rozpoczęła budowę umocnień obronnych, w tym 7 betonowych schronów.\n\n<b>Okres II wojny światowej</b>\n\nWe wrześniu 1939 roku nad brzegiem jezior Mikorzyńskiego i Ślesińskiego oraz kanału Warta - Gopło Batalion ON "OPALENICA" obsadza umocnienia obronne, co ma na celu osłonięcie odwrotu Armii Poznań. Po latach bunkry stały się jedną z atrakcji turystycznych.\nZajęcie przez wojska niemieckie terenów Konina i okolic nastąpiło około 13 września 1939r. Władze niemieckie, przy pomocy miejscowych Niemców, zorganizowały swoje pierwsze urzędy, początkowo wzywając wszystkich pozostałych na miejscu polskich urzędników do natychmiastowego powrotu do pracy. Kierownikami w nich zostawali Niemcy, którzy przybyli z terenu III Rzeszy lub dawni obywatele polscy narodowości niemieckiej, którzy zamieszkiwali te tereny przed wojną. Nowe władze zmieniły nazwę miasta na <i>Schlüsselsee</i> (\'klucz jezior\'), która obowiązywała w latach 1939 - 1945. Miasto w istocie stanowiło kluczowe miejsce w ciągu jezior nadgoplańskich nie tylko z militarnego punktu widzenia.\nOkupacja hitlerowska doprowadziła do zniszczeń pomników, kościołów i ich wyposażenia, ale też wtedy założono park miejski i zabłysła pierwsza żarówka w młynie napędzanym maszyną parową z wbudowaną prądnicą. Elektrycznością w tamtym trudnym okresie mogła cieszyć się poczta, restauracja i lampa na głównym skrzyżowaniu miasta.\n\nJuż na początku niemieckiej okupacji w Różopolu w odwecie za śmierć 4 Niemców po łapance (przypadkowych osób) wykonano egzekucję na 18 osobach. Zwłoki do dzisiaj znajdują się we wspólnej mogile na cmentarzu w Ślesinie, od 1969 roku stoi pomnik upamiętniających poległych. Na ścianie domu przy pl. Wolności 13 w Ślesinie (mieścił się tu posterunek żandarmerii hitlerowskiej i areszt) wmurowano tablicę ku czci osób pomordowanych jesienią 1939 r. oraz w latach 1942 i 1943. Rodzima ludność pochodzenia polskiego musiała opuszczać swoje domy i pracować w obozach pracy. Wysiedlono kilkadziesiąt rodzin ze Ślesina i okolic. Żydzi byli wywożeni i mordowani w lasach okolic Kazimierza Biskupiego. Miasteczko należało wtedy do Okręgu Rzeszy - Kraj Warty, w rejencji inowrocławskiej.\n\n8 marca 1940 roku opublikowano rozporządzenie gubernatora Hansa Franka o zakazie używania i pokazywania godła Rzeczpospolitej Polskiej. Jedynie hitlerowskie symbole władzy mogły być eksponowane publicznie. Gdy ogłoszono to rozporządzenie w Ślesinie nocą potajemnie z Łuku Triumfalnego zniknął "orzeł napoleoński" o którym ślad zaginął na kolejne parę lat. Po wojnie okazało się, że figurkę orła w marcu 1940 r. usunął mieszkaniec Ślesina - Władysław Kurzydłowski, który wyjawił swój sekret na łożu śmierci. Orzeł był ukryty pod schodami remizy ochotniczej straży pożarnej w Ślesinie. Mężczyzna obawiał się jednak reakcji na swój czyn władz komunistycznych dlatego tak długo czekał z jego ujawnieniem. W trakcie ceremonii pogrzebowej orzeł został ustawiony w zagłowiu trumny jako dowód wdzięczności mieszkańców Ślesina.\n\nW walkach o odzyskanie niepodległości uczestniczyli przedwojenni ślesińscy harcerze, których patronem przed wojną był książę Józef Poniatowski (do tej tradycji powrócono 30. czerwca 2006 roku, kiedy to Komenda Hufca Związku Harcerstwa Polskiego im. Szarych Szeregów w Koninie nadała harcerskiemu Kręgowi Seniorów w Ślesinie i Skulsku imię księcia wsławionego w walkach napoleońskich). W czasie wojny zaginął harcerski sztandar. Zrekonstruowany proporzec wykorzystywany jest obecnie przez druhów i druhny podczas oficjalnych uroczystości.\n\nJanusz Konstanty Zybert (ur. 1928 r. w Stawiszynie), który z rodzicami sprowadził się do Ślesina przy ul. Żwirki i Wigury. Jego ojciec był organistą w ślesińskim kościele. Sam należał do harcerstwa. W czasie wojny Janusz Zybert przedostał się przez zieloną granicę do Warszawy i dołączył do Szarych Szeregów, a później do Armii Krajowej. W powstaniu warszawskim uczestniczył prawdopodobnie w pułku "Baszta". W wieku 16 lat zmarł (8.XI.1944) po odniesieniu ran w walkach na ulicach stolicy w czasie Powstania Warszawskiego .\nWładysław Kamiński mieszkający przed wojną przy ul. Kościelnej 12 w Powstaniu Warszawskim walczył w batalionie "Parasol". Zginął w wieku 16 lat.\n\nPod koniec wojny, prawdopodobnie w 1944 roku, 2 rakiety typu V2 spadają w okolicach Ślesina. Pierwsza uderza w półwysep na J. Mikorzyńskim i całkowicie go niszczy. Od tej pory miejscowi wędkarze nazywają to miejsce "Miną". Druga trafia w las koło osady Tokary czego skutkiem jest lej o średnicy 50 metrów i głębokości 20 metrów.\nTuż po wojnie, 7. października 1945 r., na pocisk artyleryjski z II wojny światowej w Ślesinie niedaleko jeziora natrafiło kilkoro chłopców od 9 do 12 lat. Próbując rozbić pocisk doprowadzili do eksplozji. W wyniku wybuchu Adam Nowak stracił nogę, a Rachud Rafał - rękę. Tłumaczyli później, że chcieli pozyskać proch.\n\n18 stycznia 1945 roku w Ślesinie rozpoczęły się bitwy o odzyskanie miasta. Wjechały wówczas do niego 3 niemieckie czołgi, które miały zniszczyć most i zatrzymać radzieckie wojska na linii jezior ślesińskich. Rosyjski ostrzał zniszczył jednak 2 czołgi, a trzeci zdołał się wycofać w kierunku Kleczewa. Zdemolowany wówczas most opóźnił o jeden dzień wejście żołnierzy Armii Czerwonej do miasta. Ślesin został wyzwolony 20 stycznia 1945 roku.\n\n<strong>Czasy PRL-u </strong>\n\nOkres powojenny był trudny dla miasta ze względu na braki żywieniowe, odzieżowe i komunikacyjne. Na wiele produktów wprowadzano kartki. W dodatku 13 października 1948 roku wybuchł pożarł, który strawił 10 domów. W ogniu stanął Żabiniec i ul. Piaski. Ze względu na silny wiatr pożar szybko przenosił się na sąsiednie budynki. Skutki były poważne - stara część dawnej średniowiecznej zabudowy miasta przestała istnieć. Gdyby nie pomoc straży i wzajemna akcja mieszkańców straty mogły być jeszcze bardziej dotkliwe.\n\nPomimo to mieszkańcy starali się walczyć z niedostatkami w sferze kulturalnej i sportowej. Tuż po wojnie, w 1946 r., Józef Białek podejmuje pierwsze kroki w kierunku utworzenia Biblioteki Miejskiej w Ślesinie. Pierwszy księgozbiór zawierał około 300 woluminów, które udało się zebrać dzięki pomocy mieszkańców miasta. Oficjalnie Miejską Bibliotekę Publiczną w Ślesinie utworzono 18 września 1948 r. Mieściła się wówczas na Placu Wolności pod nr 13. W latach 50. przeniesiono ją na ul. Napoleona, po czym, ze względu na mały metraż, na ul. Kleczewską. Z czasem księgozbiór ślesińskiej książnicy nadal rośnie (w 1954 r. ma już prawie 4 tys. woluminów) i nie wystarczały już 2 pomieszczenia przeznaczone na ten cel od 1967 r. Toteż w 1982 roku przeniesiono bibliotekę po raz kolejny na ul. Krótką 10. Obecnie posiada 3 filie - w Szyszyńskich Holendrach, Piotrkowicach i Licheniu Starym (niegdyś funkcjonujące jako gromadzkie, w latach 70. przyłączone do ślesińskiej placówki). Dodatkowo posiadały one punkty biblioteczne w prywatnych domach (w 1977 r. 17 punktów na wsiach i 7 w ośrodkach wczasowo-wypoczynkowych). Z biegiem lat ich prowadzenie przestawało się opłacać i zostawały likwidowane. Ostatni przestał istnieć w 2006 r.\n\nJuż w 1946 roku w remizie ochotniczej straży pożarnej uczniowie Szkoły Podstawowej w Ślesinie z inicjatywy nauczyciela języka polskiego Ireneusza Sawczuka wystawili spektakl pt. "Karpaccy górale", a rok później "Ułana i młynarkę" (w rolach tytułowych Ireneusz Wiktor i Halina Olkiewicz). Teatr funkcjonował do końca lat 50. Dochody ze sprzedawanych biletów przeznaczano na wyposażenie dla ślesińskiej straży pożarnej.\nW 1947 roku powstał pierwszy ślesiński klub sportowy, który do tej pory nosi nazwę Ludowy Klub Sportowy Ślesin. Największym osiągnięciem zespołu są rozgrywki w ramach IV ligi.\nPo wojnie utworzony przez Niemców Park Miejski staje się miejscem kulturalnych spotkań mieszkańców. To tu powstaje pierwsza miejska plaża, kiosk gastronomiczny i tzw. grzybek - wybetonowany okrągły placyk na którym odbywały się liczne potańcówki.\n\n21 maja 1946 roku powstał Centralny Związek Spółdzielczy. W ramach państwowego ruchu spółdzielczego w Ślesinie utworzono spółdzielnię "Zgoda" i "Rolnik". W 1948 roku ulegają one połączeniu tworząc Gminną Spółdzielnię Samopomoc Chłopską w Ślesinie. Jej pierwszymi członkami byli Aleksander Olkiewicz, Czesław Targasiński, Kazimierz Rzeźnik, Stanisław Wagner, Władysław Wojtasik, Jan Zieliński, Kazimierz Kowalski i Tomasz Oleksiewicz. Jednak to w latach 70. doszło do największego rozwoju spółdzielni kiedy to zatrudniała ok. 270 pracowników stałych i 20 sezonowych.\n\nPod koniec lat 40. w Ślesinie przy ul. Ogrodowej powstała składnica lodu na terenie posesji Jana Działakiewicza - długa betonowa budowla jedynie ze sklepieniem na powierzchni. Wewnątrz były składowane bloki lodu, które wycinano zimą z pobliskich zamarzniętych jezior. Układano je w stertach i oddzielano trocinami, by nie przymarzały do siebie. Taki zapas lodu (gdy nie było jeszcze elektryczności, a więc i zamrażarek) służył przez cały rok.\n\nPo wojnie władze komunistyczne prowadziły szeroko zakrojone akcje zmierzające do utrwalenia nowego ustroju i likwidacji wszelkich niezależnych podmiotów. Jednym z nich byli prywatni przedsiębiorcy. Przeciwko nim skierowana była ustawa o nadzwyczajnych pełnomocnictwach dla rządu w bitwie o handel z 2. czerwca 1947 r. Komisja walcząca z tzw. "szkodnictwem gospodarczym" mogła bez drogi sądowej karać obywateli grzywną lub kierować do miejsc przymusowej pracy. Po wojnie w Ślesinie istniało kilka prywatnych podmiotów gospodarczych, głównie handlowych i gastronomicznych. Wiosną 1948 roku funkcjonariusze konińskiego Urzędu Bezpieczeństwa dokonali prowokacji. Nocą z pomnika żołnierzy radzieckich, znajdującego się na ślesińskim rynku, strącono gwiazdę. O świcie uzbrojeni milicjanci UB wtargnęli do mieszkań wybranych osób. Zatrzymanym zarzucono działalność wywrotową. Zostali aresztowani w siedzibie UB przy ul. Żwirki i Wigury w Koninie. Wprawdzie po dwóch tygodniach przesłuchań wszyscy zostali zwolnieni to proceder powtarzał się wielokrotnie. Dodatkowo urzędnicy skarbowi nakładali dotkliwe kary finansowe, np. za przekroczenie właściwej ilości piany w piwie. W efekcie tych zastraszeń do końca 1952 roku sektor prywatny w Ślesinie przestał istnieć.\nInnym przejawem nowego ładu politycznego były zmiany nazw ulic - Kościelnej na 1 Maja i Kleczewskiej na Juliana Marchlewskiego, czołowego działacza komunistycznego w dwudziestoleciu międzywojennym sprzeciwiającego się w 1918 roku odzyskaniu przez Polskę niepodległości. Swoje pierwotne nazwy odzyskały dopiero w 1989 roku.\n\nPo 1953 roku miasteczko zaczęło przeżywać coraz szybszy wzrost gospodarczy i kulturalny. Wtedy to je zradiofonizowano, powstała biblioteka i nastąpiła stopniowa elektryfikacja na bazie ustawy o powszechnej elektryfikacji wsi i osiedli z 28 czerwca 1950 r.\nW 1953 roku w Ślesinie powołano społeczny komitet elektryfikacji. Mieszkańcy miasta aktywnie uczestniczyli w tym procesie. Sami rozwozili materiały energetyczne, ustawiali słupy, pomagali przy instalacji słupów energetycznych. Do prac fizycznie włączyło się prezydium ówczesnej Rady Narodowej. Zwieńczeniem tej akcji był dzień 4 grudnia 1954 roku, kiedy to po raz pierwszy po wojnie zabłysło światło elektryczne. Wcześniej, od końca II połowy XIX wieku, na początku wnętrza kościołów, urzędów i dworów, a później i domostw rozświetlały, oprócz świec, lampy naftowe, wynalazek Ignacego Łukasiewicza.\n\nW 1951 roku rozpoczęło działalność kino "Gopło". Wcześniej z produkcjami filmowymi mieszkańcy mogli zapoznawać się, gdy do miasteczka przyjeżdżało kino objazdowe (w 1948 roku zaprezentowało w Ślesinie "Zakazane piosenki" - pierwszy pełnometrażowy film po wojnie). W 1954 roku swoją premierę w ślesińskim kinie miał pierwszy polski film w kolorze "Przygoda na Mariensztacie" w reż. L. Buczkowskiego, który cieszył swoimi melodiami przez całą dekadę.\nPod koniec lat 50. mieszkańcy Ślesina zaczęli chętnie jeździć do poznańskiej operetki. Przy różnych okazjach rodzinnych przywoływano niekiedy melodie z "Wesołej Wdówki", "Cygańskiego Barona", "Zemsty Nietoperza" czy "My Fair Lady". Ponad 50 lat później aktorzy operetki z Poznania zawitają do ślesińskiego Domu Kultury, gdzie spotkają się z dużym zainteresowaniem.\n\nNie bez znaczenie było utworzenie 4. lutego 1949 roku Funduszu Wczasów Pracowniczych. Instytucja ta, której celem było zapewnienie możliwości wypoczynku pracownikom państwowych i uspołecznionych zakładów pracy, dała początek licznym ośrodkom wypoczynkowym na terenie gminy Ślesin do których przez wiele lat ściągali pracownicy kopalni, elektrowni, zakładów włókienniczych i odzieżowych oraz wytwórni sprzętu komunikacyjnego.\n\nW tym samym roku ruszyła budowa żelbetowego mostu w Ślesinie. Zrealizowała ją firma Hydrokres w ramach budowy kanału Warta - Gopło. Kierował inwestycją inż. Stanisław Rawa, ale w skład zespołu weszli również technicy Tadeusz i Mieczysław Marcinkowscy, pochodzący ze Ślesina, inż. Iwanicki (jego żona była nauczycielką matematyki w Szkole Podstawowej w Ślesinie) oraz Krystyna Lewandowska, ślesinianka, i technik Gerard Łukaszewski z Lichenia. Biura firmy znajdowały się przy ul. Napoleona (kamienica p. Pawłowskiego) i ul. Kleczewskiej (kamienica p. Szuberskich). Budowa mostu, zakończona w 1950 r., połączyła ze sobą dwoje ludzi, którzy uczestniczyli w tworzeniu tego projektu - pani Krystyna i pan Gerard zakochali się w sobie i resztę życia spędzili razem.\nSam pomysł budowy kanału węglowego i połączenia Warty oraz Wisły zrodziła się dużo wcześniej, bo w 1918 roku kiedy to planowano połączyć drogą wodną Wielkopolskę z Gdańskiem. Obecnie kanał jest jedynie w znikomym stopniu wykorzystywany do przewozu towarów. To turystyczna droga żeglugowa drugiej klasy o długości 32 km, dostępna dla barek o nośności do 600 ton, a w najpłytszym fragmencie ma 2,5 metra.\n\n15. maja 1959 roku na wniosek ślesińskiego koła Polskiego Związku Wędkarskiego Miejska Rada Narodowa w Ślesinie podjęła uchwałę o zagospodarowaniu i zelektryfikowaniu ośrodka rozrywkowego w Parku Miejskim. Efektem tej decyzji było zbudowanie betonowego podium tanecznego - tzw. grzybka, oświetlanego przez jedną lampę.\n\nHeraldyk, Marian Gumowski, w 1960 roku w książce "Herby miast polskich" umieścił współczesny herb Ślesina. Stworzył go w oparciu o nieczytelny odcisk z dokumentu datowanego na 1776 rok, skąd wzięła się błędna opinia o jego pochodzeniu. Klucz w bramie skojarzył niewłaściwie z herbem Dulicz.\nW 1963 roku Prezydium Miasta Ślesina przekazało Marianowi Gumowskiemu dokładny rysunek pieczęci miejskiej odtworzonej dzięki tłokowi pieczęci z 1662 roku. Pole pieczęci z XVII wieku posiadało wizerunek wieńca roślinnego w którym umieszczono tarczę herbową nakrytą otwartą koroną. Na tarczy położono blankowany mur miejski z przejazdem - w którym widniała opuszczona do połowy krata - i kluczem Piotrowym, który symbolizował poznańską kapitułę kościelną. Herb zawierał w sobie zatem elementy związane z władzą posesorką, jak i staropolskim samorządem, czerpał swe motywy z historycznych przekazów i różnił się jednocześnie od powstałego wcześniej wizerunku bramy triumfalnej pochodzącego z zachowanej pieczęci (odnoszącej się do samorządu międzywojennego). Po dziś dzień jednak symbolem miasta jest herb Dulicz.\n\n<a href="http://nph.uni.lodz.pl/adamczewski/pieczecie_3.pdf" target="_blank" rel="noopener">Więcej o herbie Ślesina w książce Marka Adamczewskiego "Pieczęcie urzędowe władz lokalnych z obszaru Polski centralnej" i w artykule "Kręte ścieżki współczesnej heraldyki miejskiej w Polsce centralnej, czyli o niektórych herbach naznaczonych skazą" (w Roczniku Polskiego Towarzystwa Heraldycznego nowej serii t. VII (XVIII)).</a>\n\nOkoło dziesięć lat po rozpoczęciu nadawania stałego programu telewizyjnego, na początku lat 60. pierwsze telewizory pojawiają się również w Ślesinie. Nie było ich wiele, dlatego też w trakcie najpopularniejszych audycji, jak Wyścig Pokoju, właściciele odbiorników wystawiali je w swoich oknach tak by z ulicy można było obejrzeć program. Sąsiedzi, znajomi i okoliczni mieszkańcy stanowili widownię, która wspólnie mogła korzystać z tego nowego wówczas sposobu na spędzenie wolnego czasu. Na kolorową telewizję trzeba jednak było jeszcze czekać jedną dekadę, gdy w Polsce upowszechniły się odbiorniki produkowane na radzieckiej licencji telewizora "Rubin" (od 1972 r.). W Ślesinie programy w kolorze pierwsi mieszkańcy zaczęli oglądać pod koniec lat 70.\n\n28. listopada 1965 roku w Ślesinie Jan Działakiewicz założył w Ślesinie prywatną Wytwórnię Wód Mineralnych, Gazowanych, Lemoniady i Oranżady. W latach 80. firma działała w ramach Gminnej Spółdzielni w Ślesinie.\n\nKolejna dekada XX w. to okres znacznego rozwoju miasta, który towarzyszy szybkiemu rozrastaniu się Konina - w drugiej połowie dziesięciolecia jest już miastem wojewódzkim. Latem do Ślesina przybywa coraz więcej wczasowiczów. Na obleganej plaży miejskiej przy Ośrodku Sportu i Rekreacji w latach 70. zainstalowano nawet megafony, aby można było wysłuchać popularnej wówczas audycji "Lata z Radiem", która codziennie startowała o 9:00. W przyplażowym kiosku można było kupić bułkę z parówką, oranżadę o smaku malinowym i artykuły plażowe. Wiele lat później, 29 czerwca 2008 roku, "Lato z Radiem" emituje na żywo swój program właśnie ze Ślesina.\n\nW 1970 roku rozpoczęto budowę Stadionu Miejskiego w Ślesinie wraz z zapleczem. Stał się siedzibą Ludowego Klubu Sportowego w Ślesinie. Do tej pory mecze rozgrywano na boisku sportowym przy Szkole Podstawowej w Ślesinie. Sam obiekt z biegiem lat był wielokrotnie remontowany - wymieniano murawę, zainstalowano sztuczne nawadnianie. Niedawno powstało dodatkowe boisko treningowe, odnowiono zaplecze socjalne i szatnie dla zawodników. Obecnie niewielkie trybuny mieszczą około 600 kibiców.\n\nW 1942 roku w jednej z niemieckich stoczni zbudowano statek "Pawełek". Od 1973 roku zaczął pływać po wodach jezior ślesińskich. 2-pokładowy stateczek posiada pokład słoneczny i mały salonik pod pokładem. W trasę zabiera 40 pasażerów. Co ciekawe, jest najstarszym statkiem pasażerskim pływającym na wodach śródlądowych w Polsce.\n\nPrzez wiele lat środkowa arkada Bramy Napoleona służyła mieszkańcom i przyjezdnym za główny wschodni wjazd do miasta. Jednak 14 sierpnia 1972 roku pijany kierowca dźwigu przejeżdżając barakowozem pod łukiem uszkadza jego konstrukcję i brama obala się na ziemię. Mieszkańcy Ślesina, którzy nie wyobrażali sobie swojego miasta bez charakterystycznego łuku postanowili go odbudować. Doszło do tego w 1977 roku kiedy to zrekonstruowano obiekt w oparciu o fotografie wykorzystując technologię żelbetową. Ozdoby, w tym woluty kolumn odtwarzał macedoński artysta Gioto Dymitrow. Upamiętniono to wydarzenie na zdjęciach. Przy okazji zdecydowano się na przeorganizowanie ruchu komunikacyjnego, tak by nie doszło do powtórzenia wypadku - przez główną arkadę pojazdy jedynie opuszczają miasto.\n\nW PRL zastąpiono prywatne przedsiębiorstwa handlowe państwowymi powszechnymi Domami Towarowymi, prowadzącymi handel detaliczny, które zaczęły powstawać od 1949 r. Również w Ślesinie latach 1973 - 1975 zbudowano Dom Handlowy "Jubilat". Architektonicznie budynek ten nie zachwyca swą estetyką i konstrukcją. Oddaje socjalistyczną myśl konstrukcyjną minionej epoki. W latach 90. monopol państwa został zniesiony, a sama działalność "Jubilatu" straciła swoje dotychczasowe znaczenie. Powierzchnię użytkową wydzierżawiono wówczas podmiotom zewnętrznym, m.in. powstał tam supermarket.\n\nRównież w latach 70. (w 1978 r.) jeden z mieszkańców Ślesina wyróżnił się budową zupełnie innej konstrukcji. W swoim małym przydomowym warsztacie na terenie miasta przy ulicy Żwirki i Wigury, <i>nomen omen</i> znanych międzywojennych lotników, swój pierwszy samolot "Polonez" buduje Jerzy Gruchalski . Był to jednomiejscowy pojazd powietrzny o konstrukcji drewnianej pokrytej płótnem o napędzie trabanta. W jego pracowni powstały jeszcze 3 tego typu maszyny. Fundacja Polskie Zabytki Lotnicze zleciła Panu Jerzemu niedawno kolejny projekt do zrealizowania - motoszybowiec "Bąk" o konstrukcji A. Kocjana z 1935 r .\n\nJeszcze w latach 70. utrzymywała się w Ślesinie tradycja jarmarku urządzanego przy kościele parafialnym z okazji odpustu na św. Walentego. Wierni mogli z tej okazji kupić tam religijne dewocjonalia oraz zabawki dla dzieci - wiatraczki, piłki na gumce, drewniane ptaszki, trąbki, piszczałki, korkowce i kapiszony. Korzystający z tego święta zajadali się śledziem z beczki, kiszonymi ogórkami, chlebem ze smalcem, obwarzankami i innymi regionalnymi przysmakami. Odbywała się też loteria z nagrodami.\n\nPod koniec dekady w Ślesinie zamontowano pierwsze budki telefoniczne obsługiwane przez ręczne centrale telefoniczne, co wiązało się z zamawianiem każdej rozmowy telefonicznej. Aby wykonać jednak rozmowę międzynarodową realizacja zamówienia trwała nawet parę dni.\n\nOd 1 stycznia 1973 roku w wyniku reorganizacji rad narodowych rozpoczyna działalność Urząd Miasta i Gminy Ślesin, po zniesieniu istniejących od 1952 roku 16 gromad tworzących gminę: Biskupie, Cegielnia, Dąbrowa, Goranin, Makarowo Sławenckie, Marianowo, Mikorzyn, Ostrowąż, Roztoka, Różnowa, Sławęncin, Sławoszewek, Sławoszewo, Szyszyn, Szyszyńskie Holendry i Żółwieniec. Znaczenie Ślesina rośnie, bo i zwiększa się obszar przez nie administrowany - obejmuje on dawną gminę Ślesin, Piotrkowice i miasto Ślesin, poza tym część gminy Gosławice i sołectwa Licheń Stary, Kępa, Bylew i Honoratka. Do 1975 roku miasto Ślesin należało administracyjnie do województwa poznańskiego, powiatu konińskiego. Według stanu na rok 1967 w Ślesinie mieszkało 2,1 tys mieszkańców.\n\nW latach 70. XX wieku powstały osiedla domków jednorodzinnych - na południu Osiedle Powstańców Wielkopolskich, a na północy Osiedle Północ. Istniejącą już część miasta nazwano osiedlem "Stare Miasto". 22 czerwca 1977 roku w Ślesinie Miejska Rada Narodowa podjęła bowiem uchwałę dotyczącą nadania nazw ulic dla nowo powstałego osiedla Lubomyśle, które zostało włączone w granice terytorialne miasta Ślesina. To wtedy zaczęły funkcjonować nazwy ulic 30-lecia PRL, Akacjowa, Klonowa, Topolowa, Brzozowa, Wierzbowa, Bukowa i Dębowa. Pomimo tego, że ich brzmienie nie kojarzy się z przedwojenną historią, całe osiedle miało od tej pory upamiętniać Powstanie Wielkopolskie.\nRównież w tej dekadzie, w 1971 r. Szkole Podstawowej w Ślesinie nadano imię Tadeusza Kościuszki. Kolejnym wydarzeniem dekady było utworzenie w 1972 r. filii w Ślesinie przez Bokserski Klub Sportowy w Zagłębiu Konin. Kierownikiem ślesińskiego oddziału został Władysław Słowiński. Pomagali mu Józef Walczak, Wojciech Szuman, Zdzisław Ejma i Lech Pyrzyński (spiker). Pierwszym klubowym trenerem został Zbyszko Sobkowiak, po którym objął tę funkcję Adam Banasiak. Działaniu klubu towarzyszyły liczne sukcesy, jak spotkanie bokserskie z 1974 r. w remizie OSP Ślesin z Cottbus Liberał z ówczesnej NRD. Pierwsza walka przyniosła porażkę ślesińskich pięściarzy 0:2, ale w rewanżu zwyciężyli 4:2. Klub funkcjonował do 1977 r.\nNatomiast inicjatorem powstania Klubu Podnoszenia Ciężarów w Ślesinie w 1972 r. był Jan Gruchalski. Zajęcia odbywały się w pomieszczeniach Centralnego Ośrodka Sportu i Turystyki (obecnie Termy Ślesińskie) na terenie miasta. W skład klubu wchodzili Jan Gruchalski, Longin Kościesza, Ryszard Bonier, Władysław Zaborowicz, Jan Rogowski, Ryszard Sobkiewicz i Sylwester Ślesiński. W trakcie kilku spotkań sportowych ślesińskim sztangistom udało się parokrotnie wygrać zawody.\n\nPrzez cały okres Polski Ludowej obchodom 1. maja towarzysza bogata oprawa propagandowa. Nie inaczej było na ulicach Ślesina. Ulicami miasta przy akompaniamencie orkiestry dętej maszerował barwny, długi szpaler reprezentacji zakładów pracy, robotników, rolników, szkół, licznych organizacji i stowarzyszeń. Mimo swego politycznego wydźwięku uczestniczący w tym wydarzeniu mieszkańcy dobrze bawili się na imprezie, która odbywała się po pochodzie.\n\nPrzez miasto kilkadziesiąt lat kursowała Sompolińska Kolej Dojazdowa w kierunku Koła lub Jabłonki i dalej Gniezna.\n\nLata 80. były czasami kryzysu w Polsce. Zapotrzebowanie na większość produktów przewyższało ich produkcję. Ten problem dotyczył też motoryzacji. Dla większości osób kwestia posiadania własnego auta pozostawała w sferze marzeń. Jednak bardziej pomysłowi potrafili stworzyć coś samemu. W prywatnych warsztatach budowano wówczas tzw. składaki. Tak też było w Ślesinie, gdzie przedmiotami pożądania były polonezy, fiaty 125p i 126p. Wojciech Pachulski, mieszkaniec miasta, zaradził temu i sam od podstaw zbudował parę polonezów, kilkanaście fiatów 125p i kilkadziesiąt "maluchów". Fiaty 126p produkowano w ten sposób również w Stacji Obsługi Samochodów należącej do Gminnej Spółdzielni w Ślesinie. Szacunkowo powstało wówczas nawet 70 pojazdów.\n\n16. marca 1987 roku oficjalnie zarejestrowano w Polskim Związku Szachowym Klub Szachowy GAMBIT działający przy Miejsko-Gminnym Ośrodku Kultury w Ślesinie. Ruch szachowy zainicjowali Józef Szychowski i Piotr Gołębiewski. Obecna reprezentacja klubu liczy sobie 56 graczy, ale związanych z nim jest 100 szachistów (najmłodszy 7 lat, najstarszy - 78).\n\n<strong>Czasy najnowsze </strong>\n\nNa fali zbliżających się wyborów parlamentarnych 4 czerwca 1989 roku wiosną w całym kraju powstają lokalne komitety obywatelskie. 27. maja 1990 roku odbyły się pierwsze wybory do Rad Gmin. Frekwencja w Ślesinie wyniosła 38% komitety obywatelskie i kandydaci niezwiązani z poprzednimi władzami osiągnęli zdecydowane zwycięstwo uzyskując 21 mandatów na 26 możliwych. Jednocześnie przywrócono urząd burmistrza, którego nie było od 1950 roku. Pierwszym został Zbigniew Bogdan.\n\nPo odzyskaniu suwerenności możliwe stało się utworzenie samorządów i modernizacja miasta. W 1990 roku do rąk mieszkańców gminy trafia pierwszy numer Gazety Ślesińskiej - "W Ślesinie".\nW 1990 roku pojawiła się Inicjatywa odbudowy Pomnika Świetej Rodziny. To wtedy utworzono Społeczny Komitet Odbudowy Pomnika z Janem Radzimskim na czele. Przy rekonstrukcji kierowano się przedwojennymi fotografiami. W 1991 roku na ślesińskim rynku ukończono jego budowę.\nW 1996 roku w Ślesinie pojawił się internet. Dopiero jednak po paru latach ten wynalazek ery informacji upowszechnił się i znalazł swoje praktyczne zastosowanie. Inną ciekawostką może być rok założenia pierwszej ulicznej sygnalizacji świetlnej na terenie miasta - 2001.\nW 1999 roku papież Jan Paweł II erygował na Białorusi diecezję witebską, której pierwszym biskupem został pochodzący ze Ślesina Władysław Blin. Jest ordynariuszem tej diecezji do chwili obecnej. W tym samym roku odwiedził gminę Ślesin - w Licheniu odprawił Mszę św. w trakcie której poświęcił budującą się właśnie bazylikę.\n\nPierwsza siedziba Domu Kultury w Ślesinie mieściła się na Placu Wolności. W 2001 roku ośrodek przeniósł się na ul. Kleczewską do pałacyku obok Urzędu Miasta i Gminy. Była to jednak lokalizacja przejściowa o pow. 120 m<span class="small2">2</span>. Korzystano też z bazy, którą dysponowali strażacy i szkoły. Nadal jednak w planach pozostawała budowa osobnej i nowoczesnej siedziby ze sceną i dobrą akustyką, gdzie mogłoby rozwijać się gminne życie kulturalne. Z działalnością tej placówki jest związana organizacja wielu imprez, wydarzeń w mieście i okolicznych wsiach, powstawanie licznych zespołów (między innymi zespołu kół gospodyń w Licheniu i Półwiosku Starym), orkiestry dętej i kół zainteresowań, klubów seniora, np. w Szyszyńskich Holendrach, Licheniu i Ślesinie, organizacja wystaw plastycznych chętnie odwiedzanych przez szkoły. Wreszcie w 2008 roku Miejsko-Gminny Ośrodek Kultury ostatecznie objął swoją własną siedzibę przy ul. Młodzieżowej. Od tego też roku odbywa się tam Festiwal Ogólnopolski Piosenki Artystycznej FOPA, gdzie pokazują swoje umiejętności artyści młodego pokolenia.\n\nReforma edukacji z 1999 r. przyniosła ze sobą dodatkowy szczebel edukacji, co sprawiło potrzebę budowy nowego budynku na młodzieży z gminy Ślesin. Nowo powstałe gimnazjum w Ślesinie przy ul. Młodzieżowej 24 maja 2002 roku zostało nazwane imieniem Mikołaja Kopernika. Tego samego roku rusza Klub Astronomiczny "Alfa", dzięki pomysłowi Agnieszki Gruchalskiej, nauczycielki fizyki. Cyklicznie organizowaną przez szkołę imprezą jest Piknik Europejski.\n\nPrężnie działa również Biblioteka Publiczna w Ślesinie. Posiada 26 500 woluminów, a filie 33 530. Od 2010 roku opracowywana jest komputerowa baza danych. Na miejscu można skorzystać też z internetu. W ostatnich latach czytelnicy chętnie odwiedzają swoją książnicę, a ich liczba nadal rośnie - w Ślesinie jest ich ponad 1000 (tę liczbę przekroczono dopiero w 2011 roku). Liczba wypożyczeń w miejskiej bibliotece od 2007 roku wzrosła o ponad 70% (do 2012 r.). Panie bibliotekarki w przedszkolach i szkołach popularyzują nawyk spędzania wolnego czasu z książką. Do biblioteki zapraszani są znani pisarze literatury dziecięcej, np. Grzegorz Kasdebke, Kalina Jeżykowska, Marcin Pałasz, Ewa Nowak czy prof. J. Papuzińska. Na jubileuszu pojawił się nawet prof. Jerzy Bralczyk. Od 5 lat dyrektorem biblioteki jest Agnieszka Niedźwiedzińska.\n\nOd 1998 roku przy okazji Dni Ślesina organizowane są Regaty o Błękitną Wstęgę Jeziora Ślesińskiego. To najstarsze, cyklicznie organizowane i największe regaty żeglarskie organizowane w Ślesinie.\n\n9 maja 2002 roku doszło do jednego z największych pożarów ostatnich dekad na terenie gminy Ślesin. W okolicy Tokar w płomieniach stanęło 2,5 ha lasu składającego się głównie z 15-letnich sosen. Ogień pojawił się w środku drzewostanu i zaczął się rozprzestrzeniać. W 9 godzinnym gaszeniu brało udział 13 jednostek strażackich, w tym samolot. Straty wyszacowano na 55 tys. zł. Pojawiły się dowody na celowe podpalenie.\n\nW 2003 roku Ślesińskie Towarzystwo "Feniks" rozszerzyło swoją działalność o sekcję żeglarską. 2 lata później rozpoczęły się regularne szkolenia żeglarskie dla dzieci i młodzieży z gminy Ślesin. W ramach sekcji w ciągu 7 lat 300 młodych ludzi miało okazję zapoznać się z żeglarstwem i podstawami jego etyki na wodzie.\nSportowym wydarzeniem, które nie ominęło Ślesina w 2004 roku był 61. wyścig Tour de Pologne i jego odcinek Inowrocław - Kalisz (183 km). Kolarze przejeżdżający przez Bramę Napoleona otrzymywali lotną premię w wys. 5 000 zł i dodatkowych punktów. Sportowcy zawitali też wtedy do Lichenia kierując się na Konin.\n\n9 czerwca 2006 roku założono w Ślesinie Lokalną Grupę Działania - Towarzystwo Społeczno - Gospodarcze "Dwa Mosty". Walne zgromadzenie członków przyjęło statut i wybrało władze - 4-osobowy zarząd stanowili Bogdan Boroński (prezes), Arleta Jaśkiewicz, Mariusz Zaborowski i Sławomira Mąka. Pozyskane środki unijne pozwoliło na podjęcie wielu inicjatyw gospodarczych, kulturalnych i promocyjnych na rzecz rozwoju miasta i gminy Ślesin.\nJednym z akcentów 650. rocznicy nadania Ślesinowi praw miejskich było wprowadzenie do obiegu okolicznościowych lokalnych monet. "Ćwire hoby" miały równowartość 4zł, a ich nazwa wzięła się z kminy ochweśnickiej (hobki - pieniądze). Ostatnie lata przyniosły zbudowanie nowego budynku gimnazjum, Miejsko-Gminnego Ośrodka Kultury, w 2009 roku kompleksu boisk sportowych typu „ORLIK 2012”, a w 2010 roku przystani żeglarskiej "Marina". Ta ostatnia cieszy się dużą popularnością nie tylko wśród polskich żeglarzy, ale również cumują tu jednostki pod niemiecką, holenderską czy nawet irlandzką banderą.\n\n5. marca 1927 r. w mieście rozpoczyna swą działalność Koło Łowieckie "Cyranka". Obecnie liczy 43 członków i obejmuje pow. 9 731 ha. Prezesem koła jest Ryszard Bartczak, łowczym Jan Szmidt. Ślesińscy myśliwi uczestniczą w wielu akcjach związanych z ochroną przyrody i środowiska naturalnego, w tym zagrożonych zwierząt - łosi, danieli, bobrów, kuropatw i orłów bielików.\n\nParę lat temu odnowiono też Park Miejski - wycięto zakrzaczenia, usunięto tory po kolei wąskotorowej, umieszczono nad brzegiem J. Ślesińskiego fontannę ze smokiem. Trwa ciągła przebudowa zabudować mieszkalnych. Wzdłuż dróg ciągną się one do miejscowości Szyszyn i Żółwieniec na północy gminy i na południu przez Wąsosze lub Mikorzyn łączą się z układem miejskim pobliskiego Konina.\nW 2011 roku zakończyła się renowacja rynku na Placu Wolności,a w 2012 r. budowa bulwaru nad Jeziorem Mikorzyńskim. 20 stycznia 2012 roku rozpoczęło nadawanie pierwsze ślesińskie radio - audycja "Klawe Radio" w ramach ramówki Radia Konin. Prowadzącym audycję jest Paweł Pikun Pachulski, który przedstawiając historię i bieżące sprawy z życia gminy Ślesin nie zapomina o promowaniu kminy ochweśnickiej.\n\n15. maja 2012 roku w sali widowiskowej Miejsko-Gminnego Ośrodka Kultury w Ślesinie obradowała Młodzieżowa Rada Gminy Ślesin w ramach obchodów roku korczakowskiego. W dyskusji na temat prawa do radości i szczęścia brali udział uczniowie ślesińskiego gimnazjum. Inicjatorem przypomnienia modelu wychowawczego proponowanego przez Janusza Korczaka było Towarzystwo Przyjaciół Dzieci w Ślesinie i ślesiński Miejsko-Gminny Ośrodek Pomocy Społecznej.\n\nOstatni spis powszechny z roku 2011 podaje liczbę mieszkańców Ślesina na poziomie 3 126 osób, a w gminie Ślesin - 13 962 mieszkańców.\n\n<i>Niektóre informacje zaczerpnięto z audycji "Klawe Radio" Pawła Pachulskiego nadawanej w Radiu Konin.</i>\n\n<b>Historia okolic Ślesina</b>\n\n<i>Legenda o św. Klarze</i>\n\nNa kartach historii nie zapisały się jedynie losy Ślesina. Również jego okolice posiadają swoje ciekawe opowieści.\nJedna z legend wiąże się ze średniowieczem, kiedy to dziedzic Mikorzyna ruszył na wyprawę krzyżową. Po wyjeździe rycerza jego żona urodziła córkę, po czym wkrótce zmarła. Małą dziewczynką zajmowali się dalsi krewni. Lata mijały, a ojciec nie wracał.\nTymczasem Klara wyrosła na piękną pannę. Jej uroda i majątek zwabiały licznych konkurentów. Klara jednak odrzucała każde oświadczyny. Nie myślała o małżeństwie. Więcej interesowała ją jazda konna, strzelanie z łuku, polowanie w okolicznych lasach a więc zajęcia zgoła nie kobiece.\nO jej rękę oświadczył się w końcu pierwszy rycerz królestwa, słynący z cnót rycerskich — Janusz, zwany Białym (przydomek pochodził od jasnych jak len włosów, srebrnej zbroi i białego płaszcza jaki nosił). Klara odrzuciła oświadczyny, twierdząc, że nigdy nie wyjdzie za mąż. Janusz dowiedziawszy się, że serce Klary jest wolne, zostawił jej swój pierścień, prosząc, aby przysłała mu ten klejnot, gdy zmieni zdanie, bądź zapragnie jego pomocy. Klara nie chcąc robić przykrości rycerzowi, wyraziła zgodę.\n\nTymczasem na wyspie leżącej na północnym brzegu Jeziora Ślesińskiego mieszkał inny rycerz, imieniem Garca. W przeciwieństwie do Janusza Białego cieszył się on złą sławą. Uciskał poddanych i napadał na przejeżdżających kupców. Żył Garca wesoło w gronie podobnych jemu zabijaków.\nKiedyś zapędził się dalej na południe, a równocześnie Klara polując, zapędziła się bardziej niż zwykle na północ. Ujrzeli się na polanie. Garca zobaczywszy Klarę zakochał się w niej od pierwszego wejrzenia. Wkrótce przebrał się w piękne, rozbojem zdobyte szaty, udał się do Mikorzyna i oświadczył się jej o rękę. Klara oczywiście nie tylko odmówiła mu ręki, ale jeszcze na dodatek powiedziała mu, co myśli o rycerzach trudniących się rozbojem. Była ona w gniewie tak piękna, że Garca zakochał się jeszcze bardziej. Odszedł, aby powrócić ze swoją drużyną i porwać Klarę siłą. Klara zdążyła jeszcze dać pierścień wiernemu słudze i posłać go po Janusza.\nPrzywiódłszy Klarę do swego zamku, Garca umieścił ją w najpiękniejszej komnacie, ściany wybił najdroższymi kobiercami, otoczył Klarę zbytkiem, ofiarował jej wspaniałe klejnoty, sprowadzał rybałtów i gęślarzy, którzy sławili jej urodę i miłość Garcy. To wszystko nie zdobyło jednak serca Klary.\nUwięziona, nie mogąc doczekać się Janusza, widząc narastającą natarczywość Garcy, złożyła w końcu ślub dziewictwa, jeśli uda się jej cało wyjść z rąk rabusia. Tymczasem Janusz spieszył z odległych stron na czele dzielnych rycerzy. Dotarł wreszcie pod zamek. Oba wojska stanęły naprzeciw siebie. Zamiast bitwy przeciwnicy postanowili stoczyć turniej. Bój odbył się pod starym dębem, który do dziś istnieje. Walka była zacięta. Z jednej strony walczył Janusz w srebrnej zbroi na białym koniu, z drugiej Garca z kruczym włosem na czarnym koniu. Skruszono kopie, połamano miecze, padły konie. W końcu Garca padł pokonany. Janusz pobiegł do zamku, uwolnił Klarę i ponownie oświadczył się o jej rękę.\n\nNiestety, Klara złożyła już ślub dziewictwa. Janusz - wzór cnót rycerskich - uszanował ślub i odprowadził Klarę do Mikorzyna. Pożegnał się i poprosił, aby wyszła na ganek, powiała chustką i wrzuciła pierścień do wody, gdy on już będzie po drugiej stronie jeziora.\nKlara spełniła życzenie, a wtedy Janusz w ciężkiej zbroi wraz z koniem rzucił się do wody. Klara zemdlała; powstała wielka burza, spadły obfite deszcze, wezbrały wody. Gdy powódź w końcu ustąpiła, z dna jeziora wynurzyła się niewielka wyspa, na której Klara spędziła resztę życia. Grób jej opisywano jeszcze na początku XIX w. Janusz zaś do dziś jeszcze pokutuje nad jeziorami: widać go w księżycowe noce, jak smutny przechadza się nad jeziorem. Widok jego zwiastuje podobno nieszczęście. Legenda o Klarze Mikorzyńskiej należy do najpopularniejszych w okolicach Konina.\n\n<i>Powyższy tekst pochodzi z przewodnika wycieczkowego: "Konin, Koło, Turek" pod redakcją Zygmunta Pęcherskiego</i>\n\nO Jeziorze Mikorzyńskim O. Kolberg pisał: "Jezioro ujęte w wysokie, lesiste wybrzeża, rozszerza się wspaniale, a prawy brzeg zakręcony w śmiałą, łukowatą linię tworzy półwysep, który łączy prawie oba brzegi. Miejscowość ta ładna nad wyraz, zwana Białym - brzegiem, zachowuje znowu romantyczną legendę. Środ wody jest wysepka maleńka, zarosła drzewami, rogożą i trzciną. Lud zowie tę kępę: Wyspą Klary, i opowia, że na wzgórzu wśród bagien i lasów stał tu kiedyś zameczek w którym mieszkała niegdyś Klara z Mikorzyna, sierota."\nDo legendy nawiązywał w 1839 roku artykuł, który ukazał się w czasopiśmie "Przyjaciel Ludu": "Tam, gdzie teraz Jezioro Mikorzyńskie, leżała przed r. 1416 wieś Lubomyśl z gruntami swymi w dolinie, której punkt najwyższy błyszczał zamkiem wspaniałym. W nim mieszkała Klara Mikorzyńska, pani dziedziczka Lubomyśla, słynna z piękności, równie jak z rozumu. Dziś jeszcze sterczy ten punkt ponad wodami i tworzy małą wysepkę, ale zamku i wsi, i ludzi, którzy w niej zamieszkali, darmo byś szukał. [...] O północy słyszeć się daje tętent podkowy po lesie, z którego jeździec wypada, ku najwyższemu brzegowi konia białego zapędza, spina go srebrną ostrogą i skacze w przepaść bezdenną! Wyspa sitowiem porosła, na niej wierzb kilka płaczących, letnie mieszkanie słowika. [...] Dawniej jeszcze można było dojrzeć szczyt chaty w której Klara pustelnicze zakończyła życie.. [...] Najgłębsza toń jeziora znajduje się przy kościele Św. Krzyża w Wąsoszach i wynosi przeszło 30 sążni; zwykle też lody najprędzej pękają w tym miejscu, a pęknąwszy, tak silnie ścierają się ze sobą, jakąś tajemną siłą przygniecione, że formują skały kryształowe, tysiącem promieni błyszczące, najrozmaitszą grą kolorów drgające w słońcu. Latem zaś wody jeziora są tak czyste, zwłaszcza na głębinie, że nie ledwo dna by dostrzec można; w jesieni i z wiosny służą do picia; w niektórych zaś miejscach naśladują kolor wód morskich, również ich wzburzanie się i opadanie. [...] Zaraz z gaju Krzyszki albo z Ostrowa można się w lecie przypatrzeć kąpielom jeleni. Z wysokich brzegów skaczą one stadami gwałtownie w głębie jeziora, a podniósłwszy rogi rosochate, pływają rączo, podobne morskim potworom. Łanie uważać by można za syreny, albo za wodne boginie, które z pianki rodzą [..] To samo jezioro, które jeleniom latem za ochłodę służy, staje się w ziemie ich zgubą; wilki bowiem napędzają je w tej porze na gołolody, gdzie ślizgając się, padają ofiarą ich podstępu."\n\nUważa się, że ludowa legenda przypisywała Klarze wydarzenia, które były udziałem św. Barbary dla której w parafii Gosławice wzniesiono kaplicę. Ojciec nakłaniał ją do zamążpójścia. Ta jednak w ukryciu przeszła na chrześcijaństwo i złożyła dozgonny ślub czystości jako oblubienicy Chrystusa. Ojciec by nie stracić pozycji zamknął ją w wieży swojego zamku i głodził.. Historię tę upamiętnia obraz św. Barbary z 1684 roku przeniesiony z kaplicy do kościoła Wszystkich Świętych w Wąsoszach.\n\n<i>Legenda słynącego łaskami krzyża i o Siemku i Marsze</i>\nW 1890 roku Oskar Kolberg w swej książce Lud. Jego zwyczaje, sposób życia, mowa, podania, przysłowia, obrzędy, gusła, zabawy, pieśni, muzyka i tańce przywołuje legendę związaną z Jeziorem Wąsosko-Mikorzyńskim:\n\nW czasach odległej przeszłości, gdy jeszcze poganie znajdowali się między ludem chrześcijańskim, nastąpiła razu jednego powódź (...) okoliczne pola zostały zalane wodą, lud chronił się wzgórza. Na wodach pływały porozrywane chaty i różne sprzęty, a miedzy niemy spostrzeżono krzyż drewniany, może z jakiego grobu zerwany unoszony na falach. Przerażony lud zgromadzony na wzgórku klęknął z modlitwą na ustach. Śród tłumów znajdował się stary, ślepy, a zatwardziały w starej wierze poganin; w chwili ogólnej trwogi klęknął na kolana, a modląc się przejrzał. Na wzgórku owym zbudowano kapliczkę, w której zawieszono krzyż cudowny. Kapliczka, wciąż odbudowywana, stała do ostatnich czasów, a z wzrostem ludności zamienioną została w kościół parafialny i powiększoną różnemi ze wszystkich boków przystawkami\nOpowieść ta miała odnosić się do powstania kościoła w Wąsoszach.\n\nO. Kolberg przytacza też inną legendę według której o zachodzie słońca refleksy światła na powierzchni jeziora pozwalają dotrzec krzyż ukryty w jego głębi. Na wyspie Siemko miał się wznosić drewniany krzyż "z wyobrażeniem Syna Boga, a tuż obok niego ukazuje się z darni wzniesiony wzgórek, na którym stoi drugi krzyż z kamienia ciosanego, mchem zupełnie porosły. Mówią, że na jego ramieniu pionowem daje sie czytać rok 1338".\n\nNa wyspę z okazji majowych świąt przybywali mieszkańcy. Zaraz po dopłynięciu do brzegu całowali oba krzyże, by potem bawić się przy muzyce, śpiewach i tańcach. Przyśpiewywano sobie przy tym: "Niech żyje w pokoju Siemko", a dziewczęta dodawały: "a z nim wspołem Marcha". Wspólnie krzyczeli: "Z Biesem spólnie srogi Krzok". Po ponownym ucałowaniu krzyży dziewczęta rzucały na wzgórek kwiatek i wszyscy wracali do swych domostw.\n\nSkąd wzięły się te ludowy zwyczaje? Ludowe podania głosiły, że dawno temu w miejscu dzisiejszego basenu jeziora znajdowała się wioska, którą zamieszkiwał Siemko ujęty wdziękami Marchy. Po zaręczynach doszła do nich złowroga wieść o najeździe nieprzyjaciół. Lokalny dziedzic zebrał młodych włościan, aby razem dołączyli się do sił obrony kraju. Walki były długie, ale zwieńczone zwycięstwem. Pan włości został jednak ciężko ranny. Z tej przyczyny wyprawił Siemka do swej żony, by ten powiadomił ją o swym stanie. Tymczasem wioskę napadły obcy najeźdźcy. Boje nie były równe. Gdy jeszcze trwały nadjechał Siemko, które zginął w walce z agresorem. Gdy Marcha zauważyła śmierć narzeczonego wykrzyknęła: "Tom Siemko zginął" i rzuciła się n a nieprzyjaciela "i tym samym ciosem przeszyta upada". Pomimo dzielnej obrony mieszkańców wioski czekała ich zguba. Jednak nagle "łuna palących się domów pokazała plebana z kielichem w ręku. Na ten widok stanęli najeźdźcy, spuścili oręże, odkryli głowy, skłonili się Panu". Choć kapłan przekonał wrogów do odejścia w zamian na dostarczenie żywności to mieszkańcy pogrążyli się w smutku po śmierci narzeczonych. Pochowali ich we wspólnym grobie, a pleban wzniósł na nim krzyż kamienny. Nadeszła powódź, która zniszczyła wioskę, ale z wodnej toni ocalał na wzgórzu krzyż.\n\nOpowieść ta na tyle była żywa w pamięci okolicznej ludności, że długo kultywowano zwyczaj przeprawy na wyspę nowożeńców przed przyjazdem do kościoła. Na krzyżu kamiennym składali 2 wianki z ruty. Tradycja jednak skończyła się tragicznie - przepełniony gośćmi weselnymi prom przewrócił się zatapiając pasażerów.\n\n<b>Żółwieniec</b>\nMiejscowość kojarzona jest w okolicy z lokalizacji jednego z najwyższych nadajników radiowo-telewizyjnych. Postawiono go w 1992 r. i jest jedynie 4 metry niższy od wieży Eiffla - ma 320 m. Wysyłany sygnał dociera na odległość prawie 100 km. Dzięki niemu widzowie mogą oglądać programy Telewizji Polskiej, ale od niedawna również kanałów komercyjnych w cyfrowej jakości, w sumie 19 kanałów TV i 6 programów radiowych.\nMniej znaną tamtejszą ciekawostką jeden z niewielu odsłoniętych fragmentów rurociągu naftowego "Przyjaźń", który na tutejszym odcinku kanału Warta-Gopło przechodzi 5 metrów na wodą.\n\n<b>Honoratka</b>\nMiejscowość znajdowała się na pograniczu dwóch gmin. Obecnie graniczy bezpośrednio z Koninem i jest związana historycznie z jedną z jego najbardziej północnych dzielnic - Gosławicami.\n\nWieś Honoratka związana jest z parafią św. Andrzeja w Gosławicach, a były to dobra rodu Łodziów i Godziembów. Z tego to rodu wywodził się Andrzej Łaskarz- biskup poznański, który około 1420 roku ufundował zamek i kościół w Gosławicach wraz z parafią. Zasięg tej parafii obejmował dobra wsi Gosławice i Pątnów, istniejących od 1280 roku. Na przełomie XVIII/XIX wieku ziemie Godziembów zostały przejęte przez ród Kwileckich, będących właścicielami do 1945 roku.\n\nNa mocy ukazu cara Aleksandra II majątek Kwileckich został rozparcelowany i dzieci Kwileckich- Jan, Mieczysław, Honorata otrzymali z majątku Pątnów swoje dobra, które zostały podzielone między osadników. Dobra Honoraty zostały około 1880 roku rozparcelowane między takie rodziny, jak Gajewscy, Grabowscy, Szatkowscy i Wiśniewscy i od imienia Honoraty powstała nazwa Honoratka, następnie roku Janów, Mieczysławów i Beniów. W1976 zlikwidowano gminę Gosławice, w związku z powyższym wieś Honoratka została włączona do gminy Ślesin.\nTekst pochodzi ze strony honoratka.ovh.org\n\nŹródło: wikipedia.pl, Słowa nie pochodzą znikąd Paweł Pachulski, 2007, "Jedyny taki łuk" - Anna Borsukiewicz, "Pieczęcie urzędowe władz lokalnych z obszaru Polski centralnej, część 3, Pieczęcie władz miejskich do 1950 roku - Marek Adamczewski.\n\n<b>Wąsosze</b>\n\nObszar na którym leżą Wąsosze w początkach swojego istnienia związany był z diecezją poznańską trwającą od chrztu Mieszka I. Synod gnieźnieński z 1000 roku powołał archidiecezję gnieźnieńską w ramach której znajdowała się wieś aż do 1818 roku, kiedy to zaborcy nakazali rozgraniczenie diecezji (znajdowała się na obszarze dwóch zaborów). W ten sposób parafia Wąsosze wchodziła najpierw w skład diecezji kujawsko-kaliskiej, a od 1925 roku we włocławskiej.\n\nSkąd pochodzi nazwa tej wsi? W staropolskim słowniku słowo to oznacza miejsce, gdzie coś się schodzi, zbiega. W odniesieniu do miejscowości , która zawsze leżała nad brzegami jeziora brać się może od schodzenia się odnóg 3 zbiorników: J. Licheńskiego, Pątnowskiego i Wąsosko-Mikorzyńskiego w jej pobliżu. Dawniej prawdopodobnie Wąsosze były otoczone ciekami wodnymi, a jeszcze dawniej jeziora były połączone z wodami Gopła (są dowody na to, że piaskowic z którego została zbudowana "katedra" w Kruszwicy" był sprowadzony drogą wodną z Gopło i J. Ślesińskie.\n\nObecna nazwa miejscowości to efekt jej wielowiekowej ewolucji. W najwcześniejszych zapisach z 1406 i 1416 roku pojawia się wieś Vansosche, w 1412 roku Vąsosse, 1475 - Vanszosche, 1774 - Wanzoz, Wąsosz. Początkowo widać więc wpływy niemieckiego zapisu. Z XV wieku pochodzi zarazem pierwsza pewna wzmianka o powstaniu parafii Wąsosze - księgi konsystorza gnieźnieńskiego posiadają zapis z 1434 roku, gdzie proboszcz Jakub spiera się o dziesięciny sprzedane mu we wsi Piotrkowice (ocenia się jednak, że mogła powstać już w latach 1325-1327). Pierwsze akty dotyczące jej działalności pochodzą jednak z XVI wieku. Prymas Jan Łaski nakazał opisać parafię w ramach spisu instytucji archidiecezji gnieźnieńskiej, co dokonano w latach 1511-1527. Teren parafii obejmował dobra Godziębów, czyli oprócz Wąsoszy również Kępę, Piotrkowice i Półwiosek, choć pleban pobierał też dziesięcinę również z Bylewa z parafii Licheń i Pątnowa, które.należały do Godziębów. Jak się można domyślać ród ten, posiadający liczne ziemie na pograniczu wielkopolsko-kujawskim w XIII i XIV wieku (z największym kompleksem w Lichiniu (obecnie Licheniu), był fundatorem kościoła i właścicielem Wąsoszy.\n\nZ pewnością pod koniec XIV wieku Maciej (Mathias) de Wansosche był właścicielem wsi (być może nawet wojewodą kaliskim). Potem, na początku XV w., byli nimi jego synowie - bracia Emrych i Dziersław Godziębowie z dobrami w Kępie. Emrych poślubił Elżbietę (Heleszkę), posiadali orpócz Wąsosz dobra w Morzyczynie i Lubomyślu. Spierali się z Piotrem z Kępy w roku 1425 o rodzielenie obu wsi. Ich synem był Jan (Jamrych) Wąsoski, którego żoną była Anna Starąska. Zapisał się jako testator w 1427 r. w trakcie sprzedaży przez Jarosława z Kępy działu w Półwiosku. W 1456 roku wieś miała dwóch właścicieli - Andrzeja i Piotra. W historii Wąsosz zachowały się informacje o kolejnych właścicielach ich dóbr:\n- Ambroży, syn Jana, ożeniony z Dorotą Dziewierzowską z którą miał córkę Anną;\n- Barbara Wąsoska, wdowa po Stanisławie Wyszakowskim;\n- Wojciech Brudziński, dworzanin królewski, burgrabia gnieźnieński, który ożenił się w 1521 r. z Anną Wąsoską, która potem jako wdowa zarządzała wsią;\n- synowie Anny: Wojciech (ur. w 1529 r. znany dignitarz i osoba duchowna na dworach cesarzy Karola V i Ferdynanda I), Marcin (ze swym bratem uczestnik wojny inflandzkiej w latach 1561 - 1563 za co stał się burgrabią kcyńskim) i Maciej przejęli wieś w 1558 r.\n\nOsada powstała pod koniec XIII wieku. Prawdopodobnie w pierwszej połowie XIV wieku założono parafię i zbudowano pierwszy kościół. Można się domyślać, że był on jeszcze drewniany. Dokładnej daty nie znamy, ale w XV wieku określano go jako dawno istniejący i z dwoma ołtarzami. Mógł zatem dotrać do drugiej połowy XVI wieku. Na początku kolejnego wieku, 6 grudnia 1602 roku konsekrowany już nowy, murowany kościół. Dokonał tego biskup gnieźnieński Jan Gniazdowski. Świątynia nie wyglądała jednak tak jak obecnie.\nW 1849 roku spłonęła, ogień oszczędził jedynie prezbiterium. W kolejnych dekadach rozbudowywano kościół - 1863 roku zbudowano nawę, w latach 1867-1917 wieżę, a w 1873 kaplicę Matki Bożej.\n\nKroniki kościelne pozwalają nam zrekonstruować mapę tej części gminy Ślesin. W 1579 roku, kiedy to parafia należała do dekanatu konińskiego w jej skład wchodziły:\nWąsosze, Kępa (wówczas zapisywana jako Kęmpa, Półwiosek (Pollwiesko) i Piotrkowice (Piotrkowicze). W czasie zaborów przynależała do dekanatu sompoleńskiego w ramach województwa kaliskiego. W 1792 roku składała się z Wąsosz i Piotrkowic. Obejmowała też opustoszałe wioski - Kępę, Półwiosek WIelki i Mały. Kolejne lata przyniosły następne zmiany. W 1810 roku wieś należała do departamentu poznańskiego, a dokładniej powiatu pyzdrskiego (wcześniej była w konińskim).\nWiadomo też, że w 1819 roku Wąsosze były częścią powiatu pyzdrskiego, obwodu konińskiego województwa kaliskiego, ale należały, nie tak jak obecnie, do gminy Piotrkowice. W latach 1845 - 1863 jej wójtem był Michał Wasielewski mieszkający w Niedźwiadach. Ówczesny skład parafii Wąsosze to: Wąsosze, Piotrkowice, Półwiosek Wielki i Mały, Holendry i Ustraszki (tak nazywano kiedyś obecną Wygodę).\n\nJakie miejscowości znajdowały się na terenie parafii w połowie XIX wieku? Akt metrykalny podaje listę miejscowości w latach 1853-1864: Budy Piotrkowskie, Budy Wąsowskie, Frąsin, Julianowo, Kolebki, Kolonia Julia, Kolonia Kolebki, , Kolonia Ustraszki, Ługi, Niedźwiady Małe, Niedźwiady, Olędry Wąsowskie, Otnoga, Piotrkowice, Półwiosek Mały, Nowy Półwiosek, Półwiosek Stary, Różopole, Samotnia Wąsosze, Smolarnia, Ustraszki, Wąsosze Piaski, Wygoda. Wiele nazw tych miejscowości już nie istnieje oficjalnie. Wówczas wskazywały one również na charakter wsi.\n\nPrzed pierwszą wojną światową, w 1912 roku, w parafii znajdowały się: Budy Wąsowskie, Frąsin, Kolebki Małe, Kolebki Wielkie, Niedźwiady, Olendry, Piotrkowice, Półwiosek Nowy, Półwiosek Stary, Różopole, Wąsosze, Wrząca Wielka i Wygoda. Wówczas znajdowały się one na terenie dekanatu kolskiego, po 1931 konińskiego, od 1972 r. kleczewskiego, a od 1995 r. ślesińskiego.\nTekst powstał w oparciu o treści zawarte w książce ks. Mariusza Budkiewicza i Jarosława Kołtuniaka "Kościół i parafia Wszystkich Świętych w Wąsoszach".\n\n<strong>Półwiosek Stary i Nowy</strong>\nW historii zapisał się podział z końca XV wieku na Półwiosek Wielki i Mały (Polagroszek Wielki i Mały). Ten drugi w 1849 roku uznano za nowo erygowaną (zaludnioną_ wieś, która sprzeciwiła się włączeniu jej do parafii Lubstów i pozostała przy wąsoskiej (pismo z dnia 24 lutego 1848 roku). Mieszkańcy tłumaczyli, że przez decyzję właściciela dóbr lubstowskich będą mieli 2 mile do kościoła, co uniemożliwi regularne przyjmowanie posług religijnych.\n\nGodziębów reprezentował tu Bogusław de Poluwesky (1394) i Niełaskarz vel Łaskarz (Nelascar de Polewek). Jak często bywało z nadawaniem nazw i tu widać ślady po dawnym właścicielu. Abraham Godzięba z Kozarzewa dobył w 1423 roku od Mikołaja z Ostrowąsu (Ostrowąża) Wielki Półwiosek. Dziedzice z tej wsi powoli wykupywali dobra Godziębów. Jarosław z Kępy w 1427 roku sprzedał dział w Półwiosku Mikołajowi. Jego syn, Tomasz nadał swojej drugiej żonie zapis wiano-posagowy 800 grzywien na wsi Piotrkowice i Półwiosek.\nW połowie XVI wieku właścicielem Półwioska (Poliwesko) Wielkiego (Maior) i Małego (Minor) oraz Piotrkowic (Pyothrkowycze) był ród Zagórskich herbu Ostoja. Kiedy był nim Stanisław Zagórski nie było tu ani upraw, ani osadników. Jego następcą był syn Szymon, któregoy oprócz Półwioska Wielkiego i Małego posiadał też Kijowiec w pow. gnieźnieńskim. Wiadomo, że w 1545 roku winien był Stanisławowi Półwieskiemu, bratu stryjecznemu, 10 zł. W 1582 roku właścicielem Półwioska i Piotrkowic był syn Szymona - Jan.\n\nW zapisach z 1887 roku Półwiosek Nowy widnieje jako kolonia położona w gminie Piotrkowice i parafii Wąsosze. Wtedy znajdowało się tu 12 domów i 100 mieszkańców.\nPółwiosek Stary funkcjonował jako wieś i dwór leżący nad Jeziorem Wąsosko-Mikorzyńskim. W XVI wieku uznawano go za niezamieszkałe pustkowie <i>haereditas deserta</i>. Dziesięcina była kierowana do parafii Ostrowąż, choć ze względu na charakter pustkowia kapłani otrzymywali jedynie drobne ofiary podczas kolędy. W 1887 roku miejscowość należała do powiatu kolskiego w gminie Piotrkowice, choć sam dwór należał do parafii Ślesin. We wsi znajdowało się wówczas 38 domów i 333 mieszkańców. Sam dwór stanowił 1 dom zamieszkiwany przez 8 mieszkańców.\n\nGdy we wrześniu 1939 roku rozbił się samolot z żołnierzami niemieckimi w okolicach Piotrowic pochowano ich na cmentarzu ewangelickim, jaki istniał już wcześniej na przyjeziornym pagórku w Półwiosku Starym. Po II wojnie światowej Półwiosek należał do gminy Piotrkowice w której był jedną z 12 gromad. Po zmianie podziału administracyjnego znalazł się w gminie Ślesin. Obecnie (stan na 29 kwietnia 2010) w Półwiosku Starym i Nowym mieszka 333 osób.\n\n<b>Wygoda </b>\nPo drugim rozbiorze Polski Wygoda należała do Królestwa Pruskiego, tworzącego Prusy Południowe. Po III rozbiorze, gdy Prusy Południowe podzielono na departamenty wieś była częścią departamentu kaliskiego. Po zawarciu 7 lipca i 9 lipca 1807 roku traktatów w Tylży cały powiat Koniński znalazł się w Księstwie Warszawskim. Po kongresie wiedeńskim obszary te weszły w obszar Królestwa Polskiego zwanego Kongresówką (złączonego unią personalną z cesarstwem rosyjskim). Od 1815 do 1837 roku Wygoda była w województwie kaliskim, potem do 1844 zwanego gubernią kaliską. Od 1844 do 1866 roku stało się częścią guberni warszawskiej, po czym wróciło do guberni kaliskiej aż do początku I wojny światowej.\n\nW 1827 roku w Słowniku geograficznym Królestwa Polskiego i innych krajów słowiańskich pojawia się pierwsze wspomnienie o Wygodzie jako kolonii. Wtedy jednak miejscowość wchodziła w skład powiatu kolskiego w ramach gminy Piotrkowice, parafii Wąsosze. Wtedy we wsi znajdowało się 20 domu i 117 mieszkańców. Pod koniec XIX wieku, w 1895 roku, mieszkało tu 203 osoby w 28 domach.\nW połowie XIX wieku niemieccy osadnicy założyli cmentarz, którego ślady są widoczne do dziś. Osiadli tu Niemcy zajmowali się karczowaniem licznych wówczas lasów. Choć mieszkali tu oczywiście Polacy to kolości stanowili tutaj większość. Pod koniec tamtego stulecia wielu z nich opuściło jednak wieś. Ciężka praca na roli nie przynosiła bowiem spodziewanych wyników przynosząc niskie plony.\n\nI wojna światowa przyniosła okupację niemiecką. Niemcy wrócili ponownie w czasie kolejnej wojny światowej, tworząc z Wielkopolski Kraj Warty. O aktywnej formie na tym obszarze walki świadczy incydent z 5 września 1939 roku, kiedy to zestrzelono pomiędzy Wygodą, a Piotrkowicami niemiecki samolot. Niemcy oskarżyli 5 mieszkańców o rzekome dobicie rannego hitlerowskiego żołnierza. Z tego powodu rozstrzelano ich. W całej gminie sytuacja Polaków wyglądała podobnie - mieszkańców wsi wysiedlano i wywożono na roboty przymusowe do Niemiec. 20 stycznia 1945 roku Armia Czerwona dokonała pozornego wyzwolenia wsi z totalitaryzmu.\n\nPo niemieckich mieszkańcach pozostały do dziś 3 mogiły. Jedna z nich ma nawet krzyż. Najmłodsza pochodzi z lat siedemdziesiątych. Miejsce to, jak wiele w Wielkopolsce, zostało zaniedbane. Na tamtejszej łące w wolnej części cmentarza przy północnej jego granicy znajduje się niewidoczna mogiła zbiorowa niemieckich żołnierzy, którzy zginęli w okolicy w 1945 roku. Być może ta wolna część jest najstarsza, a miejsce, gdzie znajdują się mogiły pochodzą z czasów wcześniejszych niż obecnie się uważa, czyli z połowy XIX wieku.\n\nPo II wojnie światowej żołnierze Armii Krajowej nie mogli pogodzić się z nieuniknioną perspektywą wprowadzenia komunistycznych rządów. Nie zaprzestali walki zbrojnej za co zostali nazwali "wyklętymi żołnierzami. Stawiali zbrojny opór walcząc z oddziałami UB i milicji obywatelskiej. W lasach otaczających Wygodę znajdował się obszar działalności oddziału Konspiracyjnego Wojska Polskiego – „Bury” – „Ogień”/ „Ryś”/ „Mściciel”, gdzie dowództwo od kwietnia 1947 roku objął Gabriel Fejcho oraz oddziału Kierownictwa Walki z Bezprawiem o kryptonimie „Pociąg”, gdzie dowódcą był ppor. Feliks Gruberski „Artur” – mieszkaniec Kramska. Pod koniec 1947 roku bezpieka rozbiła grupy podziemia antykomunistycznego.\n\nW latach 1975-1999 Wygoda znajdowała się w województwie konińskim. Pod koniec lat 70. rozpoczął się nowy, przemysłowy rozdział jej historii. W 1979 roku Kopalnia Węgla Brunatnego utworzyła odkrywkę Lubstów. Aby umożliwić transport węgla brunatnego do elektrowni "Pątnów" poprowadzono linię kolejową łączącą te dwa miejsca. Przebiega ona przez Wygodę. W 1980 roku prowadzono tu prace związane z budową torów i mostu żelbetonowego nad J. Licheńskim. Od tego czasu regularnie kursują nimi kopalniane składy EL2 (elektryczne lokomotywy towarowe) wożące do elektrowni węgiel.\n\nO możliwości wprowadzenia przewozów osobowych może świadczyć wyjątkowe wydarzenie. Wspomnianą trasą kolejową przyjeżdżali do pobliskiego Lichenia pielgrzymi w trakcie VII pielgrzymki Jana Pawła II do Polski 6-8 czerwca 1999 r. Wierni dojeżdżali do Wygody pociągami osobowymi, a w miejscowości utworzono wówczas jeden z większych sektorów parkingowych.\n\nTekst w oparciu o materiały ze strony nasza_wygoda.republika.pl\n\n<strong>Głębockie</strong>\nWarto wspomnieć o heroizmie ludzi, który z biegiem lat odchodzi coraz bardziej w zapomnienie. Otóż jedna z rodzin mieszkających w tej wsi, Państwo Lewińscy, do końca II wojny światowej ryzykując własnym życiem w specjalnych tunelach w sąsiekach stodoły ukrywała czteroosobową rodzinę żydowską.\n\n<strong>Biskupie</strong>\n4 lipca 1988 roku we wsi Biskupie założono Koło Związku Młodzieży Wiejskiej. Liczyło 31 członków i było jednym z najliczniejszych w ówczesnym woj. konińskim, choć jedyne działające na terenie gminy Ślesin. Przewodniczym jemu Sławomir Królak, który jednocześnie był członkiem wojewódzkiego zarządu. Z kolei na jego czele stał Marek Nowicki, późniejszy burmistrz miasta i gminy Ślesin. Koło w Biskupiu promowało kulturę na wsi na początku lat 90. Jego członkowie brali czynnie udział w zebraniach, szkoleniach i wyjazdach do zaprzyjaźnionych kół w Czechosłowacji i wschodnich Niemiec.\n\n<b>Ignacewo</b>\nTa podślesińska wieś stała się znana za sprawą bitwy jaka miała tu miejsce w czasie powstania styczniowego. Stoczone 8 maja 1863 roku starcie było jednym z największych w tamtym zrywie. Przeciwko 2 tysiącom dobrze uzbrojonym żołnierzom rosyjskim stanęło 1100 powstańców, z czego połowę stanowili kosynierzy. Przewagę Rosjan dodatkowo wzmacniały armaty, których Polacy nie posiadali. Walka rozpoczęła się około 10:30, po zimnej nocy w trakcie której spadł śnieg. W przegranej bitwie zginęło 180 powstańców. Ku ich czci postawiono pomnik.\n9 czerwca 1963 roku rozegrała się druga bitwa pod Ignacewem. Oddział pułkownika Kaliera składał się z oddziałów Raczkowskiego, Skrzyńskiego i Lipińskiego. Liczył 2 kompanie piechoty po 110 ludzi, 2 oddziały kosynierów po 148 os. i 2 plutony kawalerii. Tego dnia ruszył w okolice Ruszkowa. W kolonii Ruda pikiety zaalarmowały o obecności wojsk rosyjskich, które podążały z Konina. Oddział wroga złożony był z 2 rotami piechoty i 120 huzarów z Kozakami. Polacy nie czekali na rosyjski atak. Powstańcami dowodził Kalier i Taczkowski. Ich natarcie było tak mocne i niespodziewane, że Rosjanie musieli się cofnąć. Moskali ścigano aż do Igancewa, gdzie rozegrano decydujące starcie. Rosyjscy żołnierze zabarykadowali się w chatach, które wcześniej zdobyli lub spalili. Straty po stronie powstańców: 10 rannych i 4 zabitych, po stronie rosyjskiej: 70 zabitych, rannych i spalonych.\n\n<b><i>Masz materiały lub informacje dotyczące historii Twojej miejscowości? Podziel się nimi! Odtwórzmy wspólnie historię naszej gminy.</i></b>', 'Historia', '', 'trash', 'closed', 'closed', '', 'historia__trashed', '', '', '2017-10-24 19:11:16', '2017-10-24 19:11:16', '', 0, 'http://test20718.futurehost.pl/?page_id=85', 0, 'page', '', 0),
 (87, 1, '2017-07-31 12:49:48', '2017-07-31 12:49:48', '<a href=\'http://www.albumslesina.cba.pl/\' target=\'_blank\'>Fotograficzny spacer po Ślesinie. </a>\n\nOryginalnym zabytkiem miasta jest <b>łuk triumfalny zwany "Bramą Napoleona"</b> z orłem Księstwa Warszawskiego wzniesiony w roku 1812 przez właściciela miasta - dziedzica z Piotrkowic - Walkanowskiego (Walichnowskiego) herbu Wieruszowa na cześć Fryderyka Augusta. W 1972 roku łuk został zniszczony. Odbudowano go w latach 1976 &#8211; 1977. <img src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/luknapoleona.jpg" alt="" width="300" class="alignright wp-image-197" />\n<br><br>Z innych zabytków należy wymienić jeszcze neogotycki <b>kościół p.w. św. Mikołaja i Dobrego Pasterza</b> w Ślesinie rozbudowany w latach 1889-1907 na fundamentach gotyckiej świątyni z 1604 r. z późnobarokowymi obrazami sw. Mikołaja i Walentego w ołtarzach bocznych. Wewnątrz znajduje się zabytek architektoniczny godny obejrzenia - kropielnica kamienna z X wieku. \n<br>W centrum rynku usytuowany jest <b>pomnik Świętej Rodziny</b> zbudowany w 1922 roku\nprzez mieszkańców Ślesina w dowód wdzięczności za odzyskanie niepodległości.\nZniszczony podczas drugiej wojny światowej został odbudowany w 1991 r .\n<br><br>\nNie można zapomnieć o sanktuarium maryjnym w Licheniu z <b>Kościołem św. Doroty</b> - to neogotycki kościół z 1854 r. w którym od 29 września 1852 roku do 2 lipca 2006 r. znajdował się cudowny obraz Matki Bożej Licheńskiej, bazyliką i Golgotą.<img src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/IMG_1763.jpg" alt="" width="400" height="300" class="alignright size-full wp-image-189" /> <b>Bazylika Licheńska</b> to Sanktuarium Matki Bożej Bolesnej Królowej Polski -  największa świątynia w Polsce, 7 w Europie, 11 na świecie, ze słynącym z łask cudownym obrazem Matki Bożej Licheńskiej. Licheń w 1458 r. uzyskał prawa miejskie, które utracił - podobnie jak Ślesin - w okresie zaborów.<br><br>\nNa terenie gminy kompania z 17 DP, junaków i 37 robotników zbudowało <b>7 schronów</b>, które były obsadzone we wrześniu 1939 przez Batalion ON "OPALENICA", który miał osłaniać odwrót ARMII POZNAŃ. Schrony zlokalizowane są nad brzegiem jezior Mikorzyńskiego i Ślesińskiego oraz kanału Warta - Gopło.<br>\nW Biskupiu zlokalizowany jest <b>zespół pałacowy</b> obejmujący pałac murowany z 1905 r. oraz park z połowy XIX wieku, który obecnie jest własnością prywatną.<br><br>\n[caption id="attachment_204" align="alignleft" width="150"]<img src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/palacmikorzyn.jpg" alt="" width="150" height="104" class="size-full wp-image-204" /> Pałac w Mikorzynie[/caption]Również w Mikorzynie znajduje się <b>zespół pałacowy</b> z drugiej połowy XIX wieku obejmujący pałac, park o powierzchni 8,65 ha i owczarnię, gdzie obecnie działa <u>Ośrodek Wypoczynkowy Wityng</u>.<br> <br>\nNatomiast w Piotrkowicach można znaleźć <b>zespół dworski </b> z XIX wieku obejmujący dwór, park o powierzchni 5,7 ha, czworak i spichlerz. To <b>dwór Mielrzyńskich </b> z czwartego ćwierćwiecza XIX w., rozbudowany na początku XX wieku. Obecnie mieści się tam szkoła podstawowa.<br>\nW Wąsoszach mieści się <b>kościół parafialny pw. Wszystkich Świętych</b> z 1863 roku oraz plebania z połowy XIX wieku, w kościele znajduje się pasja z około 1700 roku w głównym ołtarzu i obraz św. Barbary z 1684 roku, który przeniesiono z rozebranego w II połowie XIX w. kościoła św. Barbary, który stał na przeciwległym brzegu jeziora i należał do klasztoru bernardynów z Kazimierza Biskupiego. Jest tu też rzeźba Chrystusa Ukrzyżowanego,  pozostałość krucyfiksu z ok. 1750 r; 3 epitafia z XIX w. - Rafała Mierzyńskiego, jego syna i Henryka Mierzyńskiego; monstrancja z XIX w; 9 blach wotywnych pochodzących z XVIII i XIX w. Otynkowany w latach 50-tych XXw., polichromia z lat 70-tych. W XV w. kościół wspomniano jako dawno istniejący. Murowana świątynię wybudowano w końcu XVI w., ale uroczystej konsekracji dokonał sufragan gnieźnieński - ks. bp Jan Gniazdowski 6 grudnia 1662 r. Kościół spłonął w 1849 r. W 1863 r. do ocalałego prezbiterium dobudowano nawę, którą powiększono o jedno przęsło w latach 1865 - 1917. W 1865 r. dobudowano od południa zakrystię, a w 1873 r. od północy kaplicę Najświętszej Marii Panny fundacji Mierzyńskich z Piotrkowic. <br>\nW Półwiosku Starym znajduje się <b>cmentarz ewangelicko-augsburski zboru ewangelicko-augsburskiego</b> z 1883 r. Założony został dla dokonania pochówku zmarłej 5 lutego Fanny Hess - rezydentki dworu w Wąsoszach, która dożywotnio zarządzała folwarkiem w Półwiosku Starym. W okresie międzywojennym dokywano tam pochówku okolicznej ludności wyznania ewangelickiego. We wrześniu 1939r. pochowano tutaj załogę zestrzelonego samolotu niemieckiego.<br>\n\n<u><b>Wykaz ważniejszych zabytków:</b></u>\n\n<span style=\'color:navy;\'><b>Ślesin:</b></span>\n- Układ urbanistyczny: XIV-XIX w.\n- Zespół kościoła par. p.w. św. Mikołaja bpa i Dobrego Pasterza\n- Cmentarz par. rzym.-kat., ul. Kościelna: pocz. XX w.\n- Cmentarz żydowski, ul. Różopole, XIX w. \n- Pomnik rozstrzelanych w  1939 r., ul. Różopole,\n- Łuk triumfalny (na cześć Napoleona I): mur., 1812; zniszczony 1972, odbudowany 1976-1977.\nWiększość zabytków pochodzi z okresu pełnego średniowiecza kiedy to król Kazimierz Wielki nadał prawa miejskie biskupom poznańskim, właścicielom miasta i z czasów kiedy to w wyniku zaborów Ślesin stał się własnością dziedziców z Piotrkowic oraz po odzyskaniu niepodległości w 1918 r. kiedy przywrócono samorząd. Okupacja hitlerowska doprowadziła do zniszczeń pomników, kościołów i ich wyposażenia, ale też wtedy założono park miejski. Po 1945 r. budowano liczne pomniki, od lat 60-tych dzięki marianom zaczęło rosnąć znaczenie Sanktuarium Maryjnego w Licheniu. Jednak to po przełomie w 1989r. i zmianie ustroju zaczęto uświadamiać sobie wagę ochrony zabytków i dokonań kulturalnych naszych przodków dlatego też można znaleźć np. nowe pozycje książkowe o naszej gminie czy wytycza się ścieżki rowerowe wspierające lokalną turystykę.\n<b>Układ urbanistyczny Ślesina</b> wywodzi się z czasów lokacji miasta w 1358 r. Zachowała się też małomiasteczkowa zabudowa z murowanymi parterowymi domami, dwutraktowymi z centralnie umieszczoną sienią przelotową, krytymi dwuspadowymi dachami ustawionymi kalenicowo do osi drogi oraz bardziej okazałe piętrowe domy z przełomu XIX w. i XX w. Zachowanymi obiektami przemysłowymi są nieczynne już młyn zbożowy i olejamia. Znaczny rozwój terytorialny jest zauważalny od lat 70-tych XX w. i to wtedy powstały osiedla domków jednorodzinnych.\n\n<span style=\'color:navy;\'><b>Licheń Stary:</b></span>\n[caption width="310" align="alignright"]<img src="http://regionwielkopolska.pl/pub/gallery/katalog_obiektow_2291/lichen-kosciol-sw-doroty-galeria-aw.jpg" width="300"  /> Kościół św. Doroty w Licheniu <br>Źródło: regionwielkopolska.pl[/caption]- Kościół par. p.w. św.Doroty: mur., 1854; dobud. prezbiterium 1872; dobud. zakrystii i kruchty 1903; przebud. i rozbud. 1978\n- Pozostałości zespołu folwarcznego, ul. Klasztorna: spichlerz, mur. 2. poł. XIX w.; gorzelnia, mur., 2 poł. XIX w.\n- Wiatrak koźlak: drewn., 1 poł. XIX w.\n- Cmentarz par. rzym.-kat. XIX\n- Pomnik powstańców 1863 r.: kamień, beton, 1967 r.\n\n<span style=\'color:navy;\'><b>Biskupie:</b></span>\n- Zespół pałacowy\n<span style=\'color:navy;\'><b>\nIgnacewo:</b></span>\n- Pomnik Powstańców 1863 r., kamień, 1918 r., odbud. 1957 r.\n\n<span style=\'color:navy;\'><b>Kijowiec</b></span>\n- Dwór: glin.-mur., 2 poł. XIX w., przebud. Ok. 1940 r.\n- Relikty megalitowe: neolit\n\n<span style=\'color:navy;\'><b>Kolebki:</b></span>\n- Pastorówka: ob. dom nr 1, mur., ok. poł. XIX w., przebud. 1892 r.\n\n<span style=\'color:navy;\'><b>Makarowo i Lizawy:</b></span>\n- Cmentarz ewangelicko-augsburski, XIX w.\n\n<span style=\'color:navy;\'><b>Mikorzyn:</b></span>\n- Zespół pałacowy\n\n<span style=\'color:navy;\'><b>Ostrowąż:</b></span>\n- Kościół par. p.w. Niepokalanego Serca NMP i Św. Jakuba Ap., drewn., 1946-1948\n- Cmentarz rzym.-kat., XIX w\n\n<span style=\'color:navy;\'><b>Piotrkowice:</b></span>\n- Zespół dworski na który składa się dwór wraz z parkiem i pozostałościami zabudowań gospodarczych.\nDwór należał do właściciela folwarku Władysława Mierzyńskiego, który go wybudował w latach 80-tych XIX w. Podczas II wojny św. majątek przejęli Niemcy, a po wojnie dobra rozparcelowano i od 1948 r. mieści się tam szkoła podstawowa. Dwór jest zbudowany z cegły, otynkowany, oparty na planie wydłużonego prostokąta z piętrową częścią środkową ze skrzydłami. To przykład klasycznej siedziby szlacheckiej usytuowanej między dziedzińcem a parkiemw stylu angielskim.\n\n<span style=\'color:navy;\'><b>Pogorzele: </b></span>\n- Cmentarz ewangelicko-augsburski, 2 poł. XIX w.\n\n<span style=\'color:navy;\'><b>Półwiosek Stary</b></span>\n- Cmentarz ewangelicko-augsburski, 1883 r. \n<span style=\'color:navy;\'><b>\nRóżnowa:</b></span>\n- Pomnik powstańców 1863 r\n\n<span style=\'color:navy;\'><b>Szyszyńskie Holendry:</b></span>\n- Cmentarz ewangelicko-augsburski, XIX w. \nKolonię osadników niemieckich w Szyszyńskich Holendrach założono w 1764 r. i wtedy też powstał cmentarz. \nSama wieś była znaczącym ośrodkiem, gdyż istniał tu kantorat czynny jeszcze o II wojnie światowej. Najstarszy zachowany nagrobek Juliusa Stewina pochodzi z 1934 r. Na cmentarzu grzebano ewangelików ze Ślesina, Szyszynka i oczywiście z Szyszyńskich Holendrów. \n\n<span style=\'color:navy;\'><b>Tokary:</b></span>\n- Pomnik na miejscu pochowania pomordowanych Niemców uciekających przed nadchodzącą armią sowiecką 20 stycznia 1945 r. Większość z nich stanowiła cywilna ludność, byli to koloniści niemieccy z Besarabii. Do połowy lat 90-tych XX w. o miejscu tym świadczył tylko krąg grochodrzewów zasadzonych przez okoliczną ludność.\n\n<span style=\'color:navy;\'><b>Wąsosze:</b></span>\n- Zespół kościoła par. p.w. Wszystkich Św.\n- Zespół dworski\n- Cmentarz par. rzym.-kat., 1 poł. XIX w.  \n\n<span style=\'color:navy;\'><b>Wierzelin: </b></span>\n- Cmentarz ewangelicko-augsburski, 2 poł. XIX w. \n- Kapliczka, mur., 1946 r.\n\n<span style=\'color:navy;\'><b>Wygoda:</b></span>\n- Cmentarz ewangelicko-augsburski, 4 ćw. XIX w. \n<br>Źródło: <a href=\'www.slesin.pl\' target=\'_blank\'>dane ze strony www UM w Ślesinie</a>\nŹródło: <a href=\'www.topmapa.pl\' target=\'_blank\'>"Ślesin i okolice - szlaki rowerowe", Wydawnictwo i Bank Geoinformacji w Poznaniu.</a> \nŹródło: Studium uwarunkowań i kierunków zagospodarowania przestrzennego. Ślesin 2003, 2005.', 'Zabytki', '', 'trash', 'closed', 'closed', '', 'zabytki__trashed', '', '', '2017-10-24 19:11:29', '2017-10-24 19:11:29', '', 330, 'http://test20718.futurehost.pl/?page_id=87', 1, 'page', '', 0),
 (136, 1, '2017-08-02 17:38:02', '2017-08-02 19:38:02', '<strong>Ponad sto rodzajów piwa, głównie z niewielkich browarów rzemieślniczych można było spróbować podczas tegorocznego Trzeciego Ślesińskiego Festiwalu Piwa. W ciągu trzech dni stoiska z piwami odwiedziło kilka tysięcy osób. W większości to wczasowicze, którzy do Ślesina przyjechali wypocząć.</strong>\n\n<a href="https://www.youtube.com/watch?v=UoIniGwTPOI" target="_blank" rel="noopener">Zobacz materiał Kalejdoskopu Wielkopolski Wschodniej</a>\n\n<a href="http://wielkopolska.tv/slesin-festiwal-piwa/#/?playlistId=0&amp;videoId=0">Materiał TV Wielkopolska.</a>\n\nŹródło: Kalejdoskop Wielkopolski Wschodniej\n\n[embed]https://www.youtube.com/watch?v=UoIniGwTPOI[/embed]', 'Ślesiński Festiwal Piwa', '', 'trash', 'open', 'open', '', 'slesinski-festiwal-piwa-2__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://gminaslesin.futurehost.pl/?p=136', 0, 'post', '', 1),
 (207, 1, '2017-08-03 06:49:04', '2017-08-03 08:49:04', '<img style="margin: 2px;" src="http://mykk.pl/img_ext/logotypy/pkskonin_v1.png" width="150" align="left" /><strong>Komunikacja publiczna w gminie Ślesin realizowana jest przez PKS Konin. Rozkład wszystkich przystanków na terenie gminy Ślesin można znaleźć za pomocą: <a href="http://web.pkskonin.pl/" target="_blank" rel="noopener">wyszukiwarki połączeń PKS Konin</a>.</strong>\n\nGmina Ślesin podzielona jest na dwie strefy: <strong>krótsza (I) </strong>dojeżdżających do Konina z przystanków miasta Ślesina po byłych trasach MZK oraz <strong>dłuższa (II) </strong>dojeżdżających do Konina z przystanków przed Ślesinem.\n\n<strong>Na podstawie decyzji Prezydenta Konia został zamknięty most przy ul. Bernardynka w Koninie. W związku z tym zaszły zmiany w rozkładach jazdy autobusów PKS. Nowe rozkłady umieszczone są na przystankach. Zmienione rozkłady do pobrania także poniżej:</strong>\n<a href="http://umig.slesin.pl/media/file/836_pl_lichen---grablin---izabelin.pdf" target="_blank" rel="noopener">Rozkład jazdy - LICHEŃ</a>\n<a href="http://umig.slesin.pl/media/file/837_pl_slesin---mikorzyn.pdf" target="_blank" rel="noopener">Rozkład jazdy - ŚLESIN, MIKORZYN</a>\n<a href="http://umig.slesin.pl/media/file/838_pl_wygoda---piotrkowice---rozopole---polwiosek---wasosze---julia---niedzwiady.pdf" target="_blank" rel="noopener">Rozkład jazdy - WYGODA, PIOTRKOWICE, RÓŻOPOLE, PÓŁWIOSEK STARY, WĄSOSZE, KĘPA, NIEDŹWIADY DUŻE.</a>\n\nObowiązujące ceny przejazdów:\n\n<strong><span style="color: navy;">STREFA I</span></strong>\n\ncena biletu jednorazowego normalnego - <strong>3,20 zł</strong>\n\ncena biletu jednorazowego dla dzieci i młodzieży szkolnej ( dzieci od 4 lat, młodzież szkolna do 24 roku szkolnego i studencka do 26 roku życia za okazaniem legitymacji) - <strong>1,60 zł</strong>\n\ncena biletu jednorazowego dla emerytów i rencistów - <strong>1,60 zł\n</strong>\ncena biletu miesięcznego normalnego - <strong>110, 00 zł</strong>\n\ncena biletu miesięcznego ulgowego - <strong>56,10 zł.</strong>\n\n<strong><span style="color: navy;">STREFA II</span></strong>\n\ncena biletu jednorazowego normalnego - <strong>3,50 zł</strong>\n\ncena biletu jednorazowego dla dzieci i młodzieży szkolnej ( dzieci od 4 lat, młodzież szkolna do 24 roku szkolnego i studencka do 26 roku życia za okazaniem legitymacji) - <strong>1,80 zł</strong>\n\ncena biletu jednorazowego dla emerytów i rencistów - <strong>1,80 zł</strong>\n\ncena biletu miesięcznego normalnego - <strong>120, 00 zł</strong>\n\ncena biletu miesięcznego ulgowego - <strong>61,20 zł.</strong>', 'Komunikacja', '', 'trash', 'closed', 'closed', '', 'komunikacja__trashed', '', '', '2017-10-24 19:11:16', '2017-10-24 19:11:16', '', 0, 'http://gminaslesin.futurehost.pl/?page_id=207', 0, 'page', '', 0),
 (213, 1, '2017-08-03 06:56:52', '2017-08-03 08:56:52', '<a href="http://www.albumslesina.cba.pl/index.html" target="_blank" rel="noopener"><strong>Galeria zdjęć Ślesina</strong></a>', 'Galeria', '', 'trash', 'closed', 'closed', '', 'galeria__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=213', 0, 'page', '', 0),
 (215, 1, '2017-08-03 06:59:06', '2017-08-03 08:59:06', 'W celu aktualizacji danych prosimy o kontakt: mark014@gazeta.pl', 'Adresy', '', 'trash', 'closed', 'closed', '', 'adresy__trashed', '', '', '2017-10-24 19:11:15', '2017-10-24 19:11:15', '', 0, 'http://gminaslesin.futurehost.pl/?page_id=215', 0, 'page', '', 0),
 (217, 1, '2017-08-03 07:00:54', '2017-08-03 09:00:54', '<img src=\'https://encrypted-tbn1.gstatic.com/images?q=tbn:ANd9GcT28LlSkOaWI7rp9xzEHYi4XV8p83GQlbZlDywOXmS1eRSbNh7_2g\' style=\'margin:5px\' alt=\'\' align=\'left\' /><span style=\'color:navy;\'><span style=\'color:navy;\'><b> "Dars" Apteka</b><br>\n62-561 Ślesin<br>\nul. Targowa 23/1<br>\nTEL (63) 2704954<br>\nemail: aptekadars@onet.pl</span><br><br>\n\n____________________<br><br>\n<span style=\'color:navy;\'>\n<b>"Dars" Apteka</b><br>\n62-563 Stary Licheń<br>\nul. Konińska 56<br>\nTEL (63) 2707927</span><br><br>\n____________________\n<br><br><strong>Apteka Rodzinna</strong><br>\n ul. Żwirki i Wigury 3<br>\n62-561 Ślesin<br>\n\nTel. 063 270-40-06<br>\nemail: apteka.rodzinna5@wp.pl\n<br><br>\n____________________\n<br><br>\n<span style=\'color:navy;\'>\n<b>"Eskulap" Apteka M. Szadkowska</b><br>\n62-561 Ślesin<br>\nul. Krótka 10<br>\nTEL (63) 2704002</span><br><br>\n____________________\n<br><br>\n<span style=\'color:navy;\'><b>APTEKA Medica</b><br>\nul. Żwirki i Wigury 18<br>\nTEL 063 2704096<br>\nemail: apteka.medica@wp.pl</span>\n<br><br>\n____________________\n<br><br>\n<strong>Apteka "Medica"</strong><br>\nŻwirki i Wigury 18<br>\n 62-561 Ślesin<br>Godziny otwarcia: <br>	PN-PT: 08:00-20:00<br>\nSOB: 08:00-16:00\n<br><br>\n____________________\n<br><br>\n<span style=\'color:navy;\'>\n<b>Apteka Św. Idziego</b><br>\nMikorzyn 55A<br>\n62-561 Ślesin<br>\nTEL 62 726 17 74<br>\nemail: aptekaidziego@wp.pl</span><br><br>\n____________________\n\nW celu aktualizacji danych prosimy o kontakt: mark014@gazeta.pl', 'Apteki', '', 'trash', 'closed', 'closed', '', 'apteki__trashed', '', '', '2017-10-24 19:11:15', '2017-10-24 19:11:15', '', 215, 'http://gminaslesin.futurehost.pl/?page_id=217', 0, 'page', '', 0),
 (222, 1, '2017-08-03 07:05:27', '2017-08-03 09:05:27', '<span style=\'color:navy;\'><strong>Biblioteka Publiczna<br>\nMiasta i Gminy Ślesin<br></strong>\nul. Kleczewska 15,<br> 62-561 Ślesin<br>\ntel./fax 63 270 40 64<br>\nbiblioteka@slesin.pl</span>\n\nW celu aktualizacji danych prosimy o kontakt: mark014@gazeta.pl', 'Biblioteki', '', 'trash', 'closed', 'closed', '', 'biblioteki__trashed', '', '', '2017-10-24 19:11:15', '2017-10-24 19:11:15', '', 215, 'http://gminaslesin.futurehost.pl/?page_id=222', 0, 'page', '', 0),
 (224, 1, '2017-08-03 07:07:10', '2017-08-03 09:07:10', '<span style=\'color:navy;\'><b>Miejsko-Gminny Ośrodek Kultury</b><br>\n62-561 Ślesin<br>\n ul. Kleczewska 15<br>\ntel. 063 270 41 96<br>\nfax. 063 270 41 96<br>\ne-mail: mgok@slesin.pl</span>\n\nW celu aktualizacji danych prosimy o kontakt: mark014@gazeta.pl', 'Dom Kultury', '', 'trash', 'closed', 'closed', '', 'dom-kultury__trashed', '', '', '2017-10-24 19:11:15', '2017-10-24 19:11:15', '', 215, 'http://gminaslesin.futurehost.pl/?page_id=224', 0, 'page', '', 0),
 (226, 1, '2017-08-03 07:08:22', '2017-08-03 09:08:22', '<span style=\'color:navy;\'><b>Dom Pomocy Społecznej</b><br>\n62-561 Ślesin<br>\nul. Kościelna 46\ntel. 063 270 41 37<br>\nfax. 063 270 41 37</span>\n\nW celu aktualizacji danych prosimy o kontakt: mark014@gazeta.pl', 'Dom Opieki Społecznej', '', 'trash', 'closed', 'closed', '', 'dom-opieki-spolecznej__trashed', '', '', '2017-10-24 19:11:15', '2017-10-24 19:11:15', '', 215, 'http://gminaslesin.futurehost.pl/?page_id=226', 0, 'page', '', 0),
 (228, 1, '2017-08-03 07:09:19', '2017-08-03 09:09:19', '<span style=\'color:navy;\'><b>Lecznica dla zwierząt</b><br>\nul. Kleczewska 40<br>\n0-63 270-40-35</span>\n\nW celu aktualizacji danych prosimy o kontakt: mark014@gazeta.pl', 'Klinika weterynaryjna', '', 'trash', 'closed', 'closed', '', 'klinika-weterynaryjna__trashed', '', '', '2017-10-24 19:11:15', '2017-10-24 19:11:15', '', 215, 'http://gminaslesin.futurehost.pl/?page_id=228', 0, 'page', '', 0),
 (231, 1, '2017-08-03 07:11:15', '2017-08-03 09:11:15', '<span style=\'color:navy;\'><b>Parafia Rzymskokatolicka w Ślesinie</b><br>\nul. Kościelna 22<br>\n62-561 Ślesin<br>\ntel.: (063) 270-40-25<br><br>\n_______________________\n<br><br>\n<b>Parafia Księży Marianów w Licheniu Starym</b><br>\nul. Klasztorna 4,<br>\n62-563 Licheń Stary <br>\ntel.: (063) 270-79-13</span>\n\nW celu aktualizacji danych prosimy o kontakt: mark014@gazeta.pl', 'Kościoły', '', 'trash', 'closed', 'closed', '', 'koscioly__trashed', '', '', '2017-10-24 19:11:15', '2017-10-24 19:11:15', '', 215, 'http://gminaslesin.futurehost.pl/?page_id=231', 0, 'page', '', 0),
 (233, 1, '2017-08-03 07:12:29', '2017-08-03 09:12:29', '<span style=\'color:navy;\'><b>Urząd Poczty</b><br>\nul. Kleczewska 14<br>\n62-561 Ślesin<br>\ntel. (0 63) 270 40 34</span>\n\nW celu aktualizacji danych prosimy o kontakt: mark014@gazeta.pl', 'Poczta', '', 'trash', 'closed', 'closed', '', 'poczta__trashed', '', '', '2017-10-24 19:11:15', '2017-10-24 19:11:15', '', 215, 'http://gminaslesin.futurehost.pl/?page_id=233', 0, 'page', '', 0),
 (235, 1, '2017-08-03 07:13:52', '2017-08-03 09:13:52', '<span style=\'color:navy;\'>ul. Gorańska 22<br>\n62-561 Ślesin<br>\ntel. (0 63) 270 42 36</span>\n\nW celu aktualizacji danych prosimy o kontakt: mark014@gazeta.pl', 'Pogotowie energetyczne', '', 'trash', 'closed', 'closed', '', 'pogotowie-energetyczne__trashed', '', '', '2017-10-24 19:11:15', '2017-10-24 19:11:15', '', 215, 'http://gminaslesin.futurehost.pl/?page_id=235', 0, 'page', '', 0),
 (237, 1, '2017-08-03 07:14:42', '2017-08-03 09:14:42', '<b>Komisariat Policji w Ślesinie</b><br>\nul. Polna 1<br>\n62-561 Ślesin<br>\ntel.  63 270 40 07\n\nW celu aktualizacji danych prosimy o kontakt: mark014@gazeta.pl', 'Policja', '', 'trash', 'closed', 'closed', '', 'policja__trashed', '', '', '2017-10-24 19:11:16', '2017-10-24 19:11:16', '', 215, 'http://gminaslesin.futurehost.pl/?page_id=237', 0, 'page', '', 0),
 (239, 1, '2017-08-03 07:15:37', '2017-08-03 09:15:37', '<span style=\'color:navy;\'>ul. Lubomyśle 52<br>\n62-561 Ślesin<br>\ntel. 609-617-640</span>\n\n_________\n\n<b>Zakład Gospodarki Komunalnej</b><br>\ntel. (0 63) 270 45 13\n\nW celu aktualizacji danych prosimy o kontakt: mark014@gazeta.pl', 'Pomoc drogowa', '', 'trash', 'closed', 'closed', '', 'pomoc-drogowa__trashed', '', '', '2017-10-24 19:11:16', '2017-10-24 19:11:16', '', 215, 'http://gminaslesin.futurehost.pl/?page_id=239', 0, 'page', '', 0),
 (241, 1, '2017-08-03 07:16:27', '2017-08-03 09:16:27', '<span style=\'color:navy;\'><b>Przychodnia Zdrowia</b><br>\nul. Targowa 23<br>\n62-561 Ślesin<br>\ntel.: 63 27 04 949</span><br><br>\n______________________\n<br><br>\n<b><span style=\'color:navy;\'>Wiejski Ośrodek Zdrowia w Licheniu</b><br>\nul. Konińska 56<br>\n62-563 Licheń<br>\ntel. 63 270 79 17</span>\n\nW celu aktualizacji danych prosimy o kontakt: mark014@gazeta.pl', 'Ośrodki zdrowia', '', 'trash', 'closed', 'closed', '', 'osrodki-zdrowia__trashed', '', '', '2017-10-24 19:11:15', '2017-10-24 19:11:15', '', 215, 'http://gminaslesin.futurehost.pl/?page_id=241', 0, 'page', '', 0),
 (245, 1, '2017-08-03 07:18:12', '2017-08-03 09:18:12', '<span style=\'color:navy;\'><b>Ochotnicza Straż Pożarna w Ślesinie</b><br>\nul. XXX-lecia 34	<br>\n62-561 Ślesin<br>\ntel. 607 602 847<br>\n<a href=\'http://www.ospslesin.org/\' target=\'_blank\'>strona www</a>\n<br><br>\n_______________________\n<br><br>\n<b>Ochotnicza Straż Pożarna</b><br>\npl.Wolności 3<br>\n62-561 Ślesin<br>\ntel.: (063) 270-40-96</span>\n\nW celu aktualizacji danych prosimy o kontakt: mark014@gazeta.pl', 'Straż Pożarna', '', 'trash', 'closed', 'closed', '', 'straz-pozarna__trashed', '', '', '2017-10-24 19:11:16', '2017-10-24 19:11:16', '', 215, 'http://gminaslesin.futurehost.pl/?page_id=245', 0, 'page', '', 0),
 (248, 1, '2017-08-03 07:20:38', '2017-08-03 09:20:38', '<span style=\'color:navy;\'><b>Urząd Miasta i Gminy w Ślesinie</b><br>\nul. Kleczewska 15<br>\n62-561 Ślesin<br>\n<br>\nGodziny pracy:<br>\nPoniedziałek -Piątek  od 7:30 do 15:30<br>\nTel.:+48 63 2704011   Fax.:+48 63 2 704 198<br>\nhttp://www.slesin.pl<br>\ne-mail ogólny: umslesin@pro.onet.pl<br>\n ksiegowosc@slesin.pl   - Dział Księgowości<br>\nkadry@slesin.pl           - Dział Kadr<br>\noswiata@slesin.pl        - Dział Oświaty UMiG</span>\n\n________________\n\n<strong>Urząd Stanu Cywilnego</strong>\n\ntel. 63 270 40 91', 'Urząd Miasta i Gminy Ślesin', '', 'trash', 'closed', 'closed', '', 'urzad-miasta-i-gminy-slesin__trashed', '', '', '2017-10-24 19:11:16', '2017-10-24 19:11:16', '', 215, 'http://gminaslesin.futurehost.pl/?page_id=248', 0, 'page', '', 0),
 (251, 1, '2017-08-03 07:23:07', '2017-08-03 09:23:07', 'Poprzednia wersja Serwisu Gminy Ślesin wraz z jego zawartością do lipca 2017 roku znajduje się pod adresem:\n\n...', 'Archiwum', '', 'trash', 'closed', 'closed', '', 'archiwum__trashed', '', '', '2017-10-24 19:11:16', '2017-10-24 19:11:16', '', 0, 'http://gminaslesin.futurehost.pl/?page_id=251', 0, 'page', '', 0),
 (253, 1, '2017-08-03 07:25:34', '2017-08-03 09:25:34', '', 'O gminie...', '', 'trash', 'closed', 'closed', '', 'o-gminie__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 0, 'http://gminaslesin.futurehost.pl/?page_id=253', 0, 'page', '', 0),
 (255, 1, '2017-08-03 07:31:14', '2017-08-03 09:31:14', '<span style=\'color:blue;\'><b>Położenie</b></span>\nŚlesin jest miastem ulokowanym we wschodniej Wielkopolsce w powiecie konińskim. To siedziba gminy miejsko - wiejskiej liczącej sobie 14 028 mieszkańców (stan na 2015 rok). Burmistrzem jest sprawujący drugą kadencję Mariusz Zaborowski. \n\n<a href="http://stat.gov.pl/vademecum/vademecum_wielkopolskie/portrety_gmin/powiat_koninski/gm_slesin.pdf" target="_blank">Statystyczny portret gminy Ślesin (2016)</a>\n\nW mieście znajdują się 3 osiedla: \n1) Osiedle Powstańców Wielkopolskich,\n2) Osiedle &#8222;Stare Miasto&#8221;,\n3) Osiedle &#8222;Północ&#8221;.\nOprócz tego sieć osadniczą tworzy 51 miejscowości wiejskich. W skład gminy wchodzi 26 sołectw: Biskupie, Bylew, Głębockie, Goranin, Honoratka, Ignacewo, Julia, Kępa, Kijowiec, Kolebki, Leśnictwo, Licheń Stary, Lubomyśle, Marianowo, Mikorzyn, Niedźwiady, Ostrowąż, Piotrkowice, Pogoń Gosławicka, Półwiosek Lubstowski, Półwiosek Stary, Różnowa, Szyszyn, Szyszyńskie Holendry, Wąsosze, Wygoda. \n<a href=\'http://slesin.pl/liczby.htm\' target=\'_blank\'>Zobacz rozkład ludności i powierzchni według poszczególnych miejscowości. </a>\nPowierzchnia gminy wynosi 146 km2.  \n<a href=\'https://mapa.polskieszlaki.pl/slesin/\' target=\'_blank\'>Zobacz mapę miasta i gminy.</a>\n<img src=\'https://gminaslesin.futurehost.pl/wp-content/uploads/wielkopolskie_slesin.gif\' style=\'margin:5px;\' align=\'left\'>\nPod względem wielkości obszaru i liczby ludności sytuacja gminy w powiecie i województwie przedstawia się następująco:\n\n    * pod względem powierzchni gmina należy do dwóch największych wśród 14 gmin powiatu konińskiego a w województwie wielkopolskim zajmuje 72 miejsce wśród wszystkich 226 gmin i 46 miejsce wśród gmin miejsko-wiejskich;\n    * pod względem liczby ludności gmina jest największą w powiecie, w województwie zajmuje 57 miejsce wśród wszystkich gmin i 38 wśród gmin miejsko- wiejskich.\n\nŚlesin położony jest od południa nad Jeziorem Mikorzyńskim i w większości nad Jeziorem Ślesińskim. Oba jeziora łączą się ze sobą i tworzą kanał Warta - Gopło. Od południa graniczy z gminą Kramsk i miastem Konin; od zachodu &#8211; z gminami Kazimierz Biskupi i Kleczew; od północy &#8211; z gminami Wilczyn, Skulsk i Wierzbinek; od wschodu &#8211; z gminą Sompolno.\n\nPrzez miasto wiedzie droga krajowa nr 25 do Bydgoszczy, łączy ona też gminę ze stolicą regionu  - Koninem. Oprócz tego można dojechać do Słupcy, a dalej do stolicy województwa - Poznania oraz do Sompolna położonego na wschód.\n\nŚlesin jest największą gminą w powiecie konińskim oraz przekracza wielkość średniej gminy w województwie wielkopolskim.\n\nW systemie osadniczym województwa gmina Ślesin znajduje się w strefie bezpośredniego wpływu ośrodka subregionalnego o znaczeniu krajowym &#8211; Konina. Stanowi ośrodek gminny o znaczeniu lokalnym.\n\nŹródło: Studium uwarunkowań i kierunków zagospodarowania przestrzennego. Ślesin 2003, 2005.', 'Położenie', '', 'trash', 'closed', 'closed', '', 'polozenie__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=255', 2, 'page', '', 0),
 (259, 1, '2017-08-03 07:38:02', '2017-08-03 09:38:02', 'Każdy region Polski cieszy się swoimi charakterystycznymi kulinarnymi specjałami. Również Wielkopolska oprócz swojej długiej historii zachowała odrębność w kwestii spożywanych potraw. Dieta opierała się tu na ziemniakach i mące, a w mniejszym stopniu na mięsie (przeważnie drobiowym) i rybach. Mieszkańcy gminy Ślesin mogą pochwalić się wykształceniem lokalnych dań, które wpisują się w regionalny koloryt naszego województwa. Związane są one z <strong>kuchnią ochweśnicką</strong>, współtworzoną również z gminą Skulsk z którą łączyła nas nie tylko wspólna historia, ale pewne odizolowanie jeziorami i lasami. \n\nWojewództwo wielkopolskie najbardziej chyba znane jest z zamiłowania do ziemniaków. Te zaczęły w tutejszej kuchni odgrywać coraz większe znaczenie w XIX wieku. Popularne tutaj <strong>pyry </strong>stały się składnikiem wielu dań, a sam region leżący nad Wartą żartobliwie określa się mianem <strong>Pyrlandii</strong>. Smacznym posiłkiem z dodatkiem tego warzywa są tu <strong>pyry z gzikiem</strong>, czyli z białym serem (twarogiem) przyrządzonym ze śmietaną, cebulą, szczypiorkiem lub koprem, placki ziemniaczane, zwane po poznańsku <strong>plyndzami</strong> oraz <strong>szare kluski</strong> okraszane skwarkami. Tutejszym gospodyniom nie obce są też <strong>szagówki</strong>, czyli kluski z ziemniaków i mąki krojone na ukos.\nTutaj należy wspomnieć też o lokalnej <strong>obsypunce</strong>, która jest charakterystycznym daniem <strong>kuchni ochweśnickiej</strong>. Przyrządza się ją z ziemniaków, boczku, cebuli, soli i pieprzu, a serwuje albo z wody w wersji gotowanej, albo z grilla. W kraju znana jest jako kiszka ziemniaczana. I choć pochodzi z Podlasia to jej ślesińska odmiana jest chwalona za swój unikalny smak. Z pewnością zawdzięcza go po części majerankowi, który dodaje się do niej dla aromatu. Innym gminnym specjałem jest <strong>pyrczok</strong>.\n\nCzasem zamiast ziemniaków do mięsa i sosów podaje się <strong>pyzy drożdżowe</strong> (określane niekiedy kluchami na łachu). Świętnie nadają się do <strong>pieczonej gęsi</strong>, która w Ślesinie zajmuje podstawowe miejsce na świątecznym stole. Inną odmianą dań, które w całej Wielkopolsce przyrządza się zwykle na obiad z pieczonych kaczek lub gęsi, są <strong>kaczka w śmietanie z pyrzokami</strong> oraz <strong>faszerowane udka z gęsi </strong>podawane z pyzami.\n\nW porze obiadowej w regionie jada się<strong> rosół z kury</strong>, <strong>czerninę</strong>, <strong>krupnik </strong>lub <strong>zupę z dyni</strong> (zwłaszcza jesienią). Można też tu spróbować <strong>białego barszczu</strong> na zakwasie z kapustą podawanego z szarymi kluskami.\nNatomiast przekąską z galaretą i mięsem, którą zajadą się Wielkopolanie są <strong>zimne nóżki</strong> - <strong>galart</strong>. Bardziej lokalnym wiktuałem są <strong>ochweśnickie żeberka w piwie z zasmażaną kapustą</strong>.\n\nObecność jezior odgrywa dużą rolę w kuchni ochweśnickiej toteż ryby są jej nieodzowną częścią. Za jedne z najlepszych są uważane sumy i sandacze. Specjałem okolic jest też <strong>szczupak po żydowsku</strong> faszerowany w galarecie. Podaje się też <strong>ślesińskie ryby wędzone</strong>, <strong>zupę rybną</strong>,  <strong>suma w galarecie</strong> lub <strong>z warzywami</strong>, <strong>rybne kotlety mielone</strong>.\n\nGdy nabierzemy apetytu na coś słodkiego chętnie sięgamy po <strong>rogaliki</strong>, które jada się tu nie tylko z okazji dnia św. Marcina - 11 listopada (<strong>rogaliki świętomarcińskie</strong> z nadzieniem migndałowo - orzechowym). Nie można zapomnieć też o babkach, drożdżówkach (szneki z glancem), plackach na sodzie i faworkach (chruścikach).\n\nJak więc widać na stołach gminy Ślesin obecne są zarówno typowo wielkopolskie dania, jak i te mniej znane, a związane z kuchnią ochweśnicką. Aby ta nie uległa zapomnieniu lokalne ugrupowania, głównie Koła Gospodyń Wiejskich, Dom Kultury, lokalne restauracje i ośrodki wypoczynkowe serwujące tutejsze potrawy, organizują festiwale kulinarne z degustacją. Cieszą się one coraz większym zainteresowaniem.\n\nŹródło: http://www.poznan.pl/kuchnia_wielkopolska | tvkonin.pl\n\n<b><i>Masz przepisy, zdjęcia wielkopolskich lub ochweśnickich dań, które według Ciebie powinny być lepiej znane? Podziel się nimi! Odtwórzmy wspólnie przysmaki  naszej gminy i regionu.</i></b>\n</span>', 'Kuchnia Ochweśnicka', '', 'trash', 'closed', 'closed', '', 'kuchnia-ochwesnicka__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=259', 3, 'page', '', 0),
 (261, 1, '2017-08-03 07:40:34', '2017-08-03 09:40:34', '<img src=\'http://gminaslesin.futurehost.pl/wp-content/uploads/jezioro.jpg\' style=\'margin:5px;\' align=\'left\'>Teren gminy jest urozmaicony. Różnica wysokości w jego granicach wynosi ponad <b>25 m</b>, wynika ona jednak głównie z różnorodności form. Najwyższy punkt terenu <b>108,9 m n.p.m.</b> znajduje się w rejonie Lichenia.\n\nCharakterystyczną dla gminy formą jest przebiegająca południkowo <u>rynna jezior Wąsowskiego, Mikorzyńskiego i Ślesińskiego</u>, odznaczająca się niedużą, 200 &#8211; 600 metrową szerokością i stromymi 5 &#8211; 17 metrowymi zboczami (o spadkach ponad 10%).\n\nRynna ta rozszerza się ku południowi gdzie łączy się ze znacznie obszerniejszą rynną jezior Gosławskiego i Pątnowskiego.\n\nW południowo &#8211; wschodniej części gminy ciągnie się mniejsza i płytsza rynna jeziora Licheńskiego.\n\nCały system jezior łączy się na południowym wschodzie z doliną Warty, a na północy z doliną Noteci.\n\nW granicach gminy, po jej wschodniej stronie, znajduje się fragment <b>doliny Kanału Grójeckiego</b>. Dolina ta posiada blisko kilometrowej szerokości podmokłe płaskie dno oraz łagodne zbocza. Na odcinku Bylew &#8211; Ignacewo znajduje się zwałowisko zewnętrzne odkrywki &#8222;Lubstów&#8221;.\n\nNiemal cały obszar położony na zachód od rynny jeziornej zajmuje rozległa równina denno &#8211; morenowa będąca fragmentem <b>Równiny Kleczewskiej</b>.\n\nZnacznie bardziej urozmaicona jest powierzchnia równiny sandrowej wypełniającej obszar położony pomiędzy ślesińsko-pątnowskim systemem jezior, Kanałem Grójeckim i doliną Noteci. Występują tu liczne <b>zagłębienia bezodpływowe</b> tworzące długie i wąskie ciągi rynien roztopowych.\n\nŹródło: Studium uwarunkowań i kierunków zagospodarowania przestrzennego. Ślesin 2003, 2005.', 'Rzeźba terenu', '', 'trash', 'closed', 'closed', '', 'rzezba-terenu__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=261', 4, 'page', '', 0),
 (263, 1, '2017-08-03 07:43:52', '2017-08-03 09:43:52', 'Najważniejszym pod względem przyrodniczym elementem krajobrazu gminy Ślesin są <b>rynny polodowcowe</b> zajęte przez ciąg tzw. jezior konińskich. Ważne znaczenie ma także stosunkowo duży<b> kompleks leśny</b> we wschodniej części gminy rozciągający się pomiędzy miejscowościami Stara Ruda i Licheń Stary. Istotnym uzupełnieniem obszarów leśnych oraz cennym elementem ekofizjograficznym obszaru gminy są <b>zadrzewienia śródpolne i przydrożne</b>.\n\nPozostały obszar zajmowany jest przez <u>tereny rolnicze, głównie łąki i pastwiska, obszary zurbanizowane oraz tereny eksploatacji węgla brunatnego</u> (okolice Goranina i Pogoni Lubstowskiej).<img src=\'http://gminaslesin.futurehost.pl/wp-content/uploads/sleswidok.jpg\' style=\'margin:5px;\' align=\'right\' higth=210 width=270>\n\nDawniej bardzo ważnym elementem lokalnego układu przyrodniczego była <b>północna część Bagien Kramskich</b> (tzw. Kompleks B), jednakże w wyniku działalności górnictwa odkrywkowego uległ on przerwaniu w miejscu planowanego rezerwatu &#8222;Pogorzele&#8221; (zwałowisko zewnętrzne odkrywki &#8222;Lubstów&#8221;). W lokalnym ujęciu, istotne znaczenie ma także <b>dolina górnej Noteci</b>, łącząca się z <b>Rynną Ślesińską i jez. Gopłem</b>, <b>zbiorowiska hydrogeniczne</b> zlokalizowane w północno-wschodniej części byłego województwa konińskiego (gminy Sompolno, Babiak, Przedecz, Kłodawa). Jest to teren zawierający jeszcze stosunkowo dobrze zachowane liczne kompleksy podmokłych terenów otwartych z mało zniekształconymi powiązaniami ekologicznymi.\n\nStwierdzane obecnie bogactwo florystyczne i faunistyczne gminy Ślesin jest konsekwencją panujących tutaj warunków siedliskowych (w szczególności <u>dobrze wykształconej sieci hydrograficznej</u>) oraz jeszcze do niedawna stosowanych powszechnie metod gospodarki rolniczej (szczególnie Łąkowo-pastwiskowej) charakteryzujących się <u>niskim poziomem mechanizacji i chemizacji</u> oraz <u>dużym rozdrobnieniem uprawianych powierzchni</u>. Stwarzało to bardzo dogodne warunki dla bytowania grup gatunków związanych z otwartymi (lub częściowo otwartymi) terenami przynajmniej okresowo silnie podtapianymi i powstrzymywało naturalne procesy sukcesyjne zmierzające do wykształcenia <b>klimaksowych zbiorowisk leśnych (grądy, olsy i łęgi w dolinach rzecznych)</b>.\n\nDodatkowym czynnikiem zwiększającym różnorodność biologiczną tych obszarów jest prowadzone <u>dawniej wydobycie torfu na niezbyt dużą skalę</u>. W konsekwencji powstały w miejscach dawnych torfowisk wyrobiska zalane wodą i rozpoczął się proces ich zarastania, co stworzyło warunki dla bytowania gatunków zwierząt i zbiorowisk roślinnych związanych z otwartym lustrem wody a w późniejszym okresie także typowych dla <b>zwartych łanów trzcin i oczeretów</b>. Przykładem takich terenów są <b>planowane rezerwaty &#8222;Pogorzele&#8221; i &#8222;Stefanowo&#8221;</b>, gdzie ochronie podlegać miały rozległe płaty wilgotnych łąk i torfowisk niskich wraz z zarastającymi wyrobiskami torfu.\n\nPozostałe obszary, zlokalizowane przede wszystkim na terenach wyżej położonych, zajmowane były pierwotnie przez tereny rolnicze, głównie pola uprawne i osadnictwo. Rejony o najsłabszych glebach (kompleks żytnio-ziemniaczany) częściowo zostały zalesione i aktualnie porastają je przeważnie <u>jednogatunkowe i jednowiekowe drzewostany sosnowe</u> rosnące w pierwszym pokoleniu na gruntach porolnych. Inwentaryzacja użytkowania obszaru gminy wykazała na tych terenach znaczny udział odłogów, porośniętych samoistnie luźnym drzewostanem sosnowym.\n<img src=\'info/pole.jpg\' style=\'margin:5px;\' align=\'left\'>\nTereny najwyżej położone, głównie w zachodniej i centralnej części gminy, użytkowane są jako gruntu orne, choć obecnie coraz częściej przeznaczane są pod działalność gospodarczą i budownictwo mieszkaniowe. Same agrocenozy są słabo zróżnicowane i stanowią miejsce bytowania przede wszystkim dla gatunków pospolitych i dobrze znoszących uprawę i sąsiedztwo człowieka. Występują tu także <u>gatunki rzadkie lub zagrożone wyginięciem</u> (np. <b>ortolan, trznadel, skowronek oraz dzierzby: srokosz i gąsiorek</b>).\n\n<u>Wschodnia część </u>gminy jest bardziej zróżnicowana, przede wszystkim za sprawą <b>znacznej lesistości oraz koegzystencji rozproszonej zabudowy mieszkaniowej (jednorodzinnej) i terenów rolniczych</b>. Wynikiem tego jest mozaikowa struktura siedliskowa ze znacznie rozbudowaną linią pole-las, stanowiącą miejsce licznego bytowania zbiorowisk i gatunków nie występujących w ogóle (lub w zdecydowanie mniejszym udziale) w krajobrazie rolniczym i leśnym traktowanym oddzielnie.\n\nZnaczne obszary w gminie Ślesin stanowią <u>tereny przemysłowe o bardzo silnie zaznaczonych wpływach antropogenicznych</u>. W ich skład wchodzą przede wszystkim <b>wyrobiska pokopalniane</b>. Dominują tu gatunki roślin i zwierząt zaliczane do grup ruderalnych i synurbijnych, tolerujących silnie niekorzystne przekształcenia środowiska przyrodniczego oraz gatunki obce (najczęściej ozdobne) wprowadzone w celu poprawy estetyki w sąsiedztwie obiektów kubaturowych.\n\nŹródło: Studium uwarunkowań i kierunków zagospodarowania przestrzennego. Ślesin 2003, 2005.', 'Krajobraz', '', 'trash', 'closed', 'closed', '', 'krajobraz__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=263', 5, 'page', '', 0),
 (267, 1, '2017-08-03 07:52:27', '2017-08-03 09:52:27', '<img style="margin: 5px;" src="http://gminaslesin.futurehost.pl/info/chmury.jpg" align="right" />Gmina Ślesin leży w strefie <b>klimatu umiarkowanego przejściowego ciepłego</b>. Nad obszarem gminy ścierają się różne masy powietrza, co jest wynikiem położenia w centrum Europy, ogólnie oceaniczne i kontynetealne. Średnia temperatura w lecie waha się pomiędzy <b>16,5°C a 20°C</b>, w zimie - między <b>-6°C a 0°C</b>.\n\n[caption id="attachment_268" align="alignleft" width="249"]<img class=" wp-image-268" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/IMG_1560.jpg" alt="" width="249" height="166" /> Gmina Ślesin należy do lokalnej odmiany klimatu Środkowej Wielkopolski.[/caption]\n\nŚrednia roczna temperatura powietrza wynosi obecnie <b>8.2°C</b> z widocznym w ciągu ostatnich lat ocieplaniem.\nNajwiększy wpływ na klimat mają masy <b>powietrza polarno-morskiego i polarno-kontynentalnego</b>, decydujące o przejściowości klimatu polskiego. Nad Polskę napływają również masy powietrza, arktycznego, zwrotnikowego-morskiego i kontynentalnego, mające mniejszy wpływ na kształtowanie klimatu naszego kraju. Masy powietrza polarno-morskiego powodują latem zachmurzenie, ochłodzenie i wzrost wilgotności, zimą zaś przynoszą ocieplenie, odwilż i mgły. Masy powietrza polarno-kontynentalnego latem przynoszą piękną, suchą i upalną pogodę, zimą-pogodę słoneczną, suchą i duże mrozy. Masy powietrza zwrotnikowo-kontynentalnego napływają bardzo rzadko, przeważnie latem i wczesną jesienią. Przynoszą piękną, suchą pogodę ("złota polska jesień").\nWiatry wieją przeważnie z kierunku <b>zachodniego</b>, wschodnie wieją głównie zimą, rzadsze są natomiast wiatry wiejące z południa i północy.\nDługość okresu wegetacyjnego osiąga <b>do 228 dni</b>, co jest jest jednym z wyższych wyników w Polsce.\nŚrednio data ostatniego wiosennego przymrozku przypada na ok. <b>13 kwietnia</b>. W okresie letnim, od kwietnia do października, zdarza się przeciętnie do <b>11 dni</b> z przymrozkiem. Zazwyczaj pierwsze jesienne przymrozki nadchodzą ok. <b>20 października</b>.\nRoczne sumy opadów poniżej średniej krajowej. W większej części gminy (zwłaszcza w północnej) pada <b>poniżej 500 mm na rok</b>, co jest jednym z niższych wartości w kraju. W okresie wegetacyjnym od kwietnia do października pada zaledwie <b>ok. 350 mm</b>.\nŹródło: <a href="http://www.imgw.pl/wl/internet/zz/oddzialy/poznan/prognoza/prognoza.html#" target="_blank" rel="noopener">Dane klimatyczne z IMGW, Oddział w Poznaniu</a>', 'Klimat', '', 'trash', 'closed', 'closed', '', 'klimat__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=267', 6, 'page', '', 0),
 (268, 1, '2017-08-03 07:51:35', '2017-08-03 09:51:35', '', 'IMG_1560', 'Gmina Ślesin należy do lokalnej odmiany klimatu Środkowej Wielkopolski.', 'inherit', 'open', 'closed', '', 'img_1560', '', '', '2017-08-03 07:51:35', '2017-08-03 09:51:35', '', 267, 'http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/IMG_1560.jpg', 0, 'attachment', 'image/jpeg', 0),
 (270, 1, '2017-08-03 08:01:51', '2017-08-03 10:01:51', '<span style=\'color:navy;\'><u>Dane o jeziorze</u>\nPowierzchnia zwierciadła wody: 147,6 ha\nGłębokość maksymalna: 12,6 m\nGłębokość średnia:  4,5 m\nDługość maksymalna: 4 280 m\nSzerokość maksymalna: 510 m\nLinia brzegowa: 12 650 m 	</span>  	  	  	  	 	\n\nJezioro Licheńskie jest jednym z wielu jezior rynnowych, należących do <b>rynny Jeziora Gopło</b>. System rynnowy, do którego zalicza się Jezioro Licheńskie, włączony jest do Pradoliny Warszawsko &#8211; Berlińskiej. Jezioro to graniczy od zachodu z Jeziorem Pątnowskim, a od północy poprzez kanał zrzutowy z Jeziorem Ślesińskim.\n\nDopływ jeziora stanowi kanał zrzutowy wpadający do jeziora w południowej części.\n\nPodgrzanie wód jeziora spowodowało zaburzenie naturalnego cyklu wymiany ciepła. Zamarzanie wód jeziora następuje jedynie w przypadku wyjątkowo mroźnych zim.\n<img src=\'info/jezlich2.jpg\' style=\'margin:5px;\' align=\'left\' width=300 hight=210> Podwyższone temperatury wody spowodowały zmiany w biocenozie jeziora, a więc i zmianę dotychczasowego charakteru gospodarki rybackiej. Zmianie uległ skład gatunkowy ryb. Gospodarczo jezioro to jest wykorzystywane do hodowli amura i tołpygi. Jezioro należy do typu jezior leszczowych.\n\nZe względu na podwyższone temperatury wody jezioro jest wykorzystywane dość intensywnie w celach rekreacyjnych.\n\nGleby po stronie zachodniej jeziora to <b>gleby płowe, zakwaszone kl. IV</b>, po stronie wschodniej występują urodzajne <b>gleby brunatne kl. II &#8211; III</b>. Od południa przylegają <b>gleby torfowe</b>. Lasy iglaste zajmują 23,4 % powierzchni zlewni jeziora.\n\nŹródło: Studium uwarunkowań i kierunków zagospodarowania przestrzennego. Ślesin 2003, 2005.', 'Jezioro Licheńskie', '', 'trash', 'closed', 'closed', '', 'jezioro-lichenskie__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=270', 0, 'page', '', 0),
 (272, 1, '2017-08-03 08:06:03', '2017-08-03 10:06:03', '<span style="color: navy;"><u>Dane o jeziorze</u></span>\n\nPowierzchnia zwierciadła wody: 152,3 ha<a href="http://gminaslesin.futurehost.pl//wp-content/uploads/jezsle2.jpg" target="_blank" rel="noopener"><img style="margin: 5px;" src="http://gminaslesin.futurehost.pl//wp-content/uploads/jezsle2.jpg" width="300" align="right" /></a>\nGłębokość maksymalna: 24,5 m\nGłębokość średnia: 7,6 m\nDługość maksymalna: 4 520 m\nSzerokość maksymalna: 540 m\nLinia brzegowa: 11 500 m\n\n<a href="http://www.albumslesina.cba.pl/" target="_blank" rel="noopener">Fotograficzny spacer po Ślesinie. </a>\nOd północy z jeziora wypływa Kanał Ślesiński (Warta – Gopło), a od południa jezioro połączone jest z jeziorem Mikorzyńsko – Wąsoskim. Po wschodniej stronie jest zrzut kanału ciepłego wypływającego z jeziora Licheńskiego.\nPo stronie zachodniej do jeziora dopływa Kanał Szyszyński oraz rów okresowy.\n\n<u>Jezioro udostępnione jest do połowów rybackich.</u> Występują w nim ryby: leszcz, krąp, ukleja, okoń, sandacz, płoć, jazgarz, ciernik , lin, wzdręga i kleń. Jest to jezioro typu leszczowego.\n\nGospodarka rybacka opiera się o rozwój naturalny.\n\nOtoczenie jeziora stanowią <b>gleby płowe</b>, należące do tzw. gleb brunatnoziemnych <b>kl. IV</b>, <b>gleby brunatne II – III klasy</b> (występują w okolicach Ślesina i na północ od jeziora).\n\nPo wschodniej stronie jeziora znajdują się <b>gleby rdzawe</b> należące do gleb bielicoziemnych zasobnych w glinokrzemiany. Są to gleby kwaśne.\n\n\nObszar po zachodniej stronie jeziora zajmują pola uprawne i łąki, reszta przyległych terenów pokryta jest borem świeżym i borem mieszanym. Lasy mieszane zajmują duże powierzchnie wokół jeziora, zwłaszcza po wschodniej stronie jeziora.\n\nLasy zajmują 46.7 % powierzchni zlewni. Strome skarpy nad brzegiem pokryte są zadrzewieniami ubarwiając malowniczy krajobraz.\n\nJezioro Ślesińskie to miejsce związane z wieloma imprezami i zawodami przez cały rok. Nad jego brzegami zlokalizowane są ośrodki rekreacyjne z największym OSiR Ślesin na którego plaży mieszkańcy gminy i regionu bawią się na Dniach Ślesina, regatach, zlotach, koncertach i okolicznościowych festynach. Parę lat temu przy południowym brzegu jeziora wyremontowano Park Miejski, a w planach jest stworzenie nowej Przystani Wodnej.\n\nPrzez jezioro przebiega szlak kajakarski, choć można na nim zobaczyć też jachty, motorówki czy rowerki wodne i łowiących na przybrzeżnych pomostach wędkarzy. Tutejsze okolice z perspektywy jeziora można też zwiedzać na stateczku turystycznym „Pawełek”. Akwen ten wchodzi w skład tzw. pętli Wielkopolskiej co znaczy, że płynąc np. jachtem można dopłynąć kanałami do Warty lub Gopła. Jezioro jest dobrze widoczne z drogi wojewódzkiej 263, zatem może warto zatrzymać się tu na dłużej...?\n\nŹródło: Studium uwarunkowań i kierunków zagospodarowania przestrzennego. Ślesin 2003, 2005.', 'Jezioro Ślesińskie', '', 'trash', 'closed', 'closed', '', 'jezioro-slesinskie__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=272', 0, 'page', '', 0),
 (274, 1, '2017-08-03 08:14:47', '2017-08-03 10:14:47', 'Największe jezioro w gminie Ślesin.\n<img class="alignleft wp-image-275" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/jezmiko.jpg" alt="" width="293" height="220" />\nPowierzchnia zwierciadła wody: 251,8 ha\nGłębokość maksymalna: 36,5 m\nGłębokość średnia: 11,5 m\nDługość maksymalna: 6 100 m\nSzerokość maksymalna: 650 m\nLinia brzegowa: 15 300 m\n\n<span style="color: black;">Wszystkie jeziora gminy Ślesin są włączone w <u>obieg chłodniczy elektrowni „Konin” i „Pątnów”</u>. Obieg chłodzenia funkcjonuje niejednakowo w różnych sezonach roku. W okresie występowania niższych temperatur – od października do kwietnia w tzw. bliskim obiegu znajdują się Jezioro Licheńskie i południowa część jeziora Wąsosko – Mikorzyńskiego. W sezonie letnim uruchomiany jest daleki obieg chłodzenia, w który dodatkowo włączone jest jezioro Ślesińskie.\nPoziom wód w jeziorach obiegu chłodniczego powinien być utrzymywany na stałym poziomie, dlatego deficyty wody w jeziorach uzupełniane są poprzez uruchomienie pompowni przerzucającej wodę z rzeki Warty.</span>\n\n<u>Wszystkie jeziora użytkowane są w celach rekreacyjno – turystycznych</u>, zarówno przez wypoczynek sobotnio niedzielny jak i okresowy. Nad jeziorami usytuowane są liczne tereny zabudowy rekreacyjnej i ośrodki wczasowe. Po jeziorach Wąsosko – Mikorzyńskim i Ślesińskim kursują <b>statki wycieczkowe</b> np. Pawełek.\n<b>Jezioro Mikorzyńsko – Wąsoskie</b> od południa połączone jest z Jeziorem Pątnowskim a od północy z Jeziorem Ślesińskim.\n\nDopływami jeziora są: kanał zrzutowy z elektrowni, „Rów Główny” odprowadzający wody kopalniane „czyste” i rów dopływowy od strony północno zachodniej – okresowo suchy. Wiosną 1998 r. zakończono pompowanie wód czystych.\n\nWchodzi w skład <b>ciągu jezior rynnowych (tzw. rynna goplańska) </b>stanowiących ślad cyrkulacji wód w podłożu lodowca. Nad jego brzegami znajdują się Ślesin, Mikorzyn, Wąsosze, Półwiosek Stary, Lubomyśle. Od lat 50. jezioro to jest częścią 32-kilometrowego kanału Ślesińskiego. Jezioro stało się główną atrakcją turystyczną tego obszaru z licznymi ośrodkami wypoczynkowymi. Do wód akwenu dostają się wody ciepłownicze z niedalekich elektrowni w Koninie co sprawia, że temperatura wody jest podwyższona, latem często oscyluje wokół <b>25 </b>stopni Celsjusza.\n\nNa podstawie badań przeprowadzonych w 2003 roku,<u> jezioro zakwalifikowano do III klasy czystości pod względem bakteriologicznym i II klasy pod względem fizykochemicznym</u>. W południowo-wschodniej części na odcinku 1750 m znajduje się grobla oraz żelbetonowa ściana. Umocnienia te są końcowymi elementami kanału zrzutowego elektrowni konińskich. Dno opada stromą skarpą tworząc 5 wyraźnych zagłębień w akwenie, w środkowej części osiągając największe głębokości. Jest to <u>najgłębsze jezioro spośród jezior konińskich</u>.\n\nJezioro udostępnione jest dla <b>celów rybołówstwa</b>. Występują w nim ryby: leszcz, krąp, ukleja, okoń, sandacz, płoć, jazgarz, ciernik, lin i węgorz.\nJest to jezioro typu leszczowego. Ogólnie w jeziorze są dobre warunki do tarła, żerowania i wzrostu ryb ze względu na obfitość zanurzonej roślinności.\n\nOtoczenie jeziora stanowią <b>gleby płowe</b>, zakwaszone <b>kl. IV</b>, <b>gleby brunatne II – III klasy</b> (występują w okolicach Ślesina). Lasy mieszane zajmują duże powierzchnie wokół jeziora, zwłaszcza po wschodniej stronie jeziora. Atrakcję turystyczną stanowią tu stare parki podworskie między innymi w Wąsoszach i Piotrkowicach.\nŹródło: Studium uwarunkowań i kierunków zagospodarowania przestrzennego. Ślesin 2003, 2005.\nwikipedia.pl - Wolna Encyklopedia', 'Jezioro Mikorzyńskie', '', 'trash', 'closed', 'closed', '', 'jezioro-mikorzynskie__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=274', 0, 'page', '', 0),
 (275, 1, '2017-08-03 08:12:16', '2017-08-03 10:12:16', '', 'Zachód słońca nad brzegiem J. Mikorzyńskiego', '', 'inherit', 'open', 'closed', '', 'jezmiko', '', '', '2017-08-03 08:12:16', '2017-08-03 10:12:16', '', 274, 'http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/jezmiko.jpg', 0, 'attachment', 'image/jpeg', 0),
 (277, 1, '2017-08-03 08:19:10', '2017-08-03 10:19:10', 'Na terenie gminy Ślesin znajduje się niewielki odcinek <b>kanału Warta &#8211; Gopło</b>.\n\n<a href=\'http://www.albumslesina.cba.pl/\' target=\'_blank\'>Fotograficzny spacer po Ślesinie. </a>\nSieć rzeczna gminy jest uboga, charakteryzuje się dużą ilością drobnych cieków, należących do <u>dorzecza Strugi Biskupiej</u> lub uchodzących bezpośrednio do jezior Ślesińskiego, Mikorzyńskiego lub Licheńskiego.\n\nKanał Ślesiński stanowi drogę żeglowną <b>II klasy</b>, jest dostępny dla barek o nośności <b>do 600 ton</b>. Jego głębokość w najpłytszym miejscu wynosi 2,5 m. Obecnie w znikomym stopniu jest wykorzystywany do transportu towarów, jedynie w sezonie letnim staje się coraz bardziej atrakcyjnym szlakiem turystycznym. Walory rekreacyjne kanału podnosi pozwolenie na poruszanie się po nim łodziami motorowymi.\n\nW sytuacji ujemnego bilansu wodnego na stanowisku szczytowym zachodzi konieczność przerzutów wody z Warty do jeziora Pątnowskiego dla uzupełnienia okresowego deficytu wody w jeziorach. Na wielkość ubytku wody ma wpływ:\n\n    * wysokość opadów atmosferycznych i wielkość spływu powierzchniowego ze zlewni, intensywność parowania z powierzchni podgrzanych jezior koni niskich, stawów hodowlanych i powierzchni terenu,\n    * ilość i stopień podgrzania wód chłodniczych z ZE PAK, kształtujących termikę jezior,\n    * stopień infiltracji wód z jezior do leja depresyjnego wokół czynnych odkrywek węgla brunatnego w dorzeczu Strugi Biskupiej,\n    * ilość wód pokopalnianych i opadowych dopływających Strugą Biskupią,\n    * bezzwrotne pobory wody dla potrzeb technologicznych Cukrowni Gosławice S.A., Huty Aluminium Konin S.A., Elektrowni Konin i Pątnów,\n    * odpływ części wód poprodukcyjnych z kompleksu stawów hodowlanych Gospodarstwa Rybackiego Gosławice sp. z o.o. na dolne stanowisko Kanału Ślesińskiego (poniżej śluzy Pątnów).\n\nPoziom wody w jeziorach stanowiska szczytowego jest kontrolowany i sterowalny. <u>Przepływ wody odbywa się w dwóch kierunkach</u> w zależności od potrzeb, na południe do Warty lub na północ do Noteci. \n\nŹródło: Studium uwarunkowań i kierunków zagospodarowania przestrzennego. Ślesin 2003, 2005.', 'Kanał Ślesiński', '', 'trash', 'closed', 'closed', '', 'kanal-slesinski__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=277', 0, 'page', '', 0),
 (282, 1, '2017-08-03 18:18:05', '2017-08-03 20:18:05', 'Południowo-wschodnia część obszaru gminy leży w zasięgu <b>Głównego Zbiornika Wód Podziemnych Nr 151 (Turek-Konin-Koło)</b>. Utworami wodonośnymi zbiornika są szczelinowe margle, wapienie, opoki, gezy i piaskowce, lokalnie również piaski w utworach kredowych. Najkorzystniejsze parametry hydrologiczne utwory kredowe posiadają w obrębie współczesnych i kopalnych dolin rzecznych. Cały teren w zasięgu zbiornika stanowi obszar wysokiej ochrony (OWO &#8211; o czasie migracji zanieczyszczeń mniejszym od 100 lat).\n\nNa terenie gminy wody podziemne występują w trzech poziomach stratygraficznych:\n    * kredowym,\n    * trzeciorzędowym (podwęglowym),\n    * czwartorzędowym.\n\n<b>Kredowo-trzeciorzędowy poziom wodonośny</b>\n\nKompleksy wodonośne: kredowy i trzeciorzędowy (podwęglowy) połączone są przez liczne kontakty hydrauliczne w jeden wspólny poziom wodonośny. Jest to podstawowy poziom wodonośny, którego rozprzestrzenienie regionalne decydowało o zawodnieniu odkrywek KWB Konin. Z tym poziomem wodonośnym związany jest trzeciorzędowy lej depresji. Miąższość utworów piaszczystych trzeciorzędu wynosi od 30 do 50 m, w zależności od ukształtowania powierzchni stropowej kredy a strefę aktywną kredy określa się na ok. 60 do 80 m.\n\nUtwory kredy, margle i drobnoziarniste piaskowce o zmiennej wodonośności, zależnej  od systemu szczelin i spękań stanowią w strefach kontaktów hydraulicznych rejony zasilania poziomu trzeciorzędowego. Średni współczynnik filtracji utworów poziomu podwęglowego określony został na ok. 4 m/d.\nWspółczynnik filtracji utworów trzeciorzędowych waha się od 1 do 12 m/d a utworów kredy ca 3 do 4 m/d.\n\nUtwory piaszczyste trzeciorzędu nawęglowego o miąższości 0,5 do 5,0 m na terenie złoża węgla brunatnego, poza złożem połączone są w jeden wspólny kompleks trzeciorzędowo-kredowy. Omawiany poziom kredowo-trzeciorzędowy jest poziomem naporowym o pierwotnym poziomie stabilizacji 92,0 do 97,0 m npm,  generalnym kierunkiem spływu w części południowej ku wschodowi i w części północnej ku północy.\n\nOmawiany kompleks wodonośny w strefach rynnowych w rejonie jezior oraz w rejonach wymyć erozyjnych kontaktuje się z wyżej leżącymi horyzontami wodonośnymi czwartorzędu.\n\n<b>Czwartorzędowy poziom wodonośny</b>\n\nJest on podzielony na dwa horyzonty wodonośne: w utworach piaszczystych w obrębie glin morenowych, nad i pod glinami, o miąższości 1 &#8211; 20 m oraz horyzont przypowierzchniowy o miąższości 2 &#8211; 5 m, lokalnie wyżej.\n\nWspółczynniki filtracji obu horyzontów są w granicach 10 do 15 m/d. Wody horyzontu w serii piaszczystej w glinach zwałowych mają zwierciadło napięte o pierwotnym poziomie stabilizacji ca 92 &#8211; 97 m npm.\n\nOmawiany horyzont na terenie złoża węgla brunatnego i w rejonie poza złożem posiada kontakty hydrauliczne z wodami pozostałych horyzontów wodonośnych. Strefami hydraulicznymi są głównie rejony wymyć erozyjnych.\n\nHoryzont przypowierzchniowy o zwierciadle swobodnym lokalnie napiętym stabilizuje się na rzędnych ok. 92,0 m do 106,0 m npm. Jest to nieciągły, lokalnie izolowany horyzont wodonośny.\n\nGłówne zasilanie tego poziomu pochodzi z opadów atmosferycznych. Powierzchnia piezometryczna tego poziomu powtarza ukształtowanie powierzchni terenu. Generalnie horyzonty czwartorzędowe z uwagi na nieciągły charakter występowania oraz miąższość warstw wodonośnych, drenowane są w minimalnym stopniu przez istniejące odkrywki.\n\nZ jeziorami związane są strefy rynnowe biegnące równolegle do wymienionych jezior (Licheńskie, Wąsoskie, Mikorzyńskie, Ślesińskie). Rejony te stanowią obszary kontaktów hydraulicznych wód powierzchniowych. Przez strefy rynnowe następuje zasilanie podstawowych poziomów wodonośnych.\n\n<b>Wody geotermalne</b>\n\nWedług podziału na jednostki geologiczne, rejon Gminy Ślesin  należy do <b>niecki mogileńsko-łódzkiej</b>, w której obecność wód słonych i termalnych znana była od wieków. Przeprowadzone prace geologiczno-wiertnicze pozwoliły na uznanie poziomu dolnokredowego za perspektywiczny dla uzyskania wód termalnych o znaczeniu praktycznym. Temperatura wody na wypływie waha się w zakresie <b>35oC do 69oC</b>, zależnie od stopnia geotermicznego  i wydajności. Na podstawie oznaczeń chemicznych stwierdzono, że woda termalna pochodząca z otworu w Ślesinie (Głębockie) jest <b>solanką 10% chlorkowo-sodową</b> z zawartością jodu i bromu oraz potasu, żelaza i innych, co decyduje o jej korzystnych własnościach leczniczych. Wysoka naturalna temperatura wody umożliwia jej wykorzystanie do celów rekreacyjno-balneologicznych i grzewczych. Podobny zakres wykorzystania wód  termalnych o wysokiej mineralizacji można spotkać w miejscowości Besenova na Słowacji.\n\nŹródło: Studium uwarunkowań i kierunków zagospodarowania przestrzennego. Ślesin 2003, 2005.', 'Wody podziemne', '', 'trash', 'closed', 'closed', '', 'wody-podziemne__trashed', '', '', '2017-10-24 19:11:45', '2017-10-24 19:11:45', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=282', 8, 'page', '', 0),
 (284, 1, '2017-08-03 18:23:06', '2017-08-03 20:23:06', '[caption id="attachment_285" align="alignleft" width="216"]<img class="wp-image-285" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/trzciniak.jpg" alt="" width="216" height="162" /> Trzciniak pospolity nad J. Mikorzyńskim - pospolity gatunek zamieszkujący latem okoliczne szuwary[/caption]\n\n<b>Różnorodność biologiczna</b>\nGmina Ślesin jest dość zróżnicowana pod względem struktury przyrodniczej i bioróżnorodności. Najwyższą wartość pod tym względem przedstawia centralna część gminy w obrębie rynien glacjalnych obecnie zajętych przez wody jezior konińskich, które pełnią rolę <u>naturalnych refugiów dla rodzimych przedstawicieli dzikiej fauny w odniesieniu do gatunków ptaków wodnych</u> oraz stosunkowo duży kompleks leśny we wschodniej części gminy w odniesieniu do gatunków związanych z dużymi i zróżnicowanymi wiekowo kompleksami leśnymi.\n\nBardzo bogate walory i zasoby przyrodnicze na terenie gminy występują w centralnej i wschodniej części.\n\nWykonana w 1985 r. przez Instytut Kształtowania Środowiska w Warszawie kompleksowa waloryzacja przyrodnicza województwa konińskiego wskazała miejsca największej koncentracji wysokich walorów przyrodniczo-krajobrazowych uzasadniających wprowadzenia na tych obszarach różnych form ochrony przyrody. W wyniku tych prac zaplanowano utworzenie <u>2 parków krajobrazowych i sieć rezerwatów przyrody</u>, które miały zabezpieczyć poprawne funkcjonowanie krajowych powiązań ekologicznych oraz konserwować miejsca licznego występowania gatunków roślin i zwierząt chronionych oraz ginących lub zagrożonych wyginięciem.\n\nW skali regionalnej wyżej wymienione planowane rezerwaty przyrody miały być częścią składową sieci ekologicznej składającej się z <u>2 parków krajobrazowych (Powidzki i Nadwarciański), 5 obszarów chronionego krajobrazu i 7 dalszych rezerwatów przyrody</u>. W latach późniejszych projekt ten uzupełniono o kolejne formy indywidualnej ochrony prawnej – użytki ekologiczne, które miały przestrzennie łączyć te jednostki.\n<img style="margin: 5px;" src="info/kormoran.jpg" align="right" />\n<b>Obszar chronionego krajobrazu</b>\n\nZnaczna część gminy Ślesin znajduje się w obrębie <b>Goplańsko-Kujawskiego Obszaru Chronionego Krajobrazu</b>, ustanowionego dnia 26. stycznia 1986 r. Obejmuje on swoim zasięgiem okolice jez. Pątnowskiego oraz tereny położone po wschodniej stronie drogi Konin – Skulsk, zatem rynnę jeziorną ślesińsko-goplańską oraz fragment Pojezierza Kujawskiego. Jest to <u>rozległy obszar o urozmaiconej rzeźbie terenu, z licznymi jeziorami, dolinami rzecznymi i zadrzewieniami, o niezbyt intensywnym rolnictwie</u>. Dodatkową cechą jest stosunkowo duże zróżnicowanie pod względem typów potencjalnej roślinności naturalnej.\n\nObok walorów przyrodniczych, na szczególną uwagę zasługują walory kulturowe, w tym przede wszystkim <b>Sanktuarium Licheńskie</b>, odwiedzane corocznie przez ok. 2 mln osób. Liczne jeziora stwarzają dogodne warunki do rozwijania funkcji rekreacyjno-wypoczynkowej. Całkowita powierzchnia Goplańsko-Kujawskiego Obszaru Chronionego Krajobrazu wynosi <b>61.496 ha</b>, z czego lasy zajmują 15 tys. ha, użytki rolne 40 tys. ha, wody 3 tys. ha, rezerwaty przyrody i inne formy ochrony przyrody 2.946 ha. Na teren gminy Ślesin przypada 7.900 ha (przy 14.600 ha powierzchni gminy).\n<img style="margin: 5px;" src="info/pustolka.jpg" align="right" />\n<b>Rezerwaty przyrody</b>\n\nW granicach gminy Ślesin nie występują obecnie rezerwaty przyrody. Autorzy „Koncepcji ochrony krajobrazu woj. konińskiego” postulowali utworzenie w obrębie Doliny Grójeckiej Północnej, przez którą przebiega wschodnia granica gminy, dwóch rezerwatów awifaunistycznych (ornitologicznych):\n\n* „Stefanowo” o pow. ok. 180 ha. Obejmuje łąki silnie przesuszone w wyniku melioracji i pastwiska oraz liczne wyrobiska potorfowe i obniżenia terenu zajęte przez turzycowiska.\nStwierdzono tu kilkadziesiąt gatunków ptaków wodnych i błotnych (m.in. podróżniczek, remiz, błotniak stawowy, krwawodziób, czajka).\n* „Pogorzele” o pow. ok. 150 ha. Obejmuje łąki i pastwiska z licznymi otwartymi\ni wypełnionymi wodą torfiankami.\n\nStwierdzono tu gniazdowanie kilkudziesięciu gatunków ptaków zaliczonych do grupy wodno-błotnych (m.in. gęgawa, czajka, ksztyk, rycyk, krwawodziób, żuraw). Niestety, znaczna część planowanego rezerwatu zajęta została pod zwałowisko zewnętrzne odkrywki węgla brunatnego „Lubstów”, czego wynikiem jest przerwanie ważnego lokalnie korytarza ekologicznego i fizyczna likwidacja siedlisk planowanych do objęcia ochroną.\n\n<b>Pomniki przyrody</b>\n\nNa obszarze gminy Ślesin istnieją 2 pomniki przyrody:\n- <b>dąb szypułkowy</b> w leśnictwie Tokary w Nadleśnictwie Konin o obwodzie pierśnicy 470 cm i wysokości 26 m,\n- <b>modrzew europejski</b> w leśnictwie Tokary w Nadleśnictwie Konin o obwodzie pierśnicy 200 cm i wysokości 26 m.\n\nUżytki ekologiczne nie występują. Brak jest także stanowisk dokumentacyjnych i zespołów przyrodniczo-krajobrazowych. Istnieje jednakże przynajmniej kilka obiektów kwalifikujących się do takiej ochrony, które – zgodnie z przyjętymi regulacjami prawnymi – powinny być objęte, m.in. kępy drzew i krzewów oraz płaty nie użytkowanej roślinności.\n\n<b>Oczyszczalnie ścieków</b>\nZapobiegają zanieczyszczeniu wód powierzchniowych i gruntowych. Aktualnie, problem ścieków jest częściowo rozwiązany w oparciu o zbiorniki bezodpływowe oraz <u>skanalizowanie większych miejscowości</u>. Na obszarze gminy działają dwie <b>oczyszczalnie ścieków, w Licheniu Nowym i w Lubomyślu</b>. Oczyszczalnie te przyjmują także ścieki ze zbiorników bezodpływowych.\nOczyszczalnia w Lubomyślu o przepustowości 1800 m3/d zaspokaja aktualne potrzeby.\nOczyszczalnia w Licheniu ma przepustowość 760 m3/d, co pozwala aktualnie przyjmować ścieki z Helenowa na terenie gminy Kramsk.\nIstniejąca sieć kanalizacji sanitarnej będzie rozbudowywana, przede wszystkim na terenach otaczających jeziora.\n<b>\nGeotermia</b>\nW dalszej perspektywie, istnieją możliwości wykorzystania energii geotermalnej jako źródła ciepła dla miasta Ślesina i jego najbliższego sąsiedztwa. <u>System, z ciepłownią geotermalną w Półwiosku Lubstowskim, obejmowałby miejscowości: Ślesin z ośrodkami wypoczynkowymi, Lubomyśle, Mikorzyn, Różopole, Półwiosek Lubstowski i Półwiosek Stary.</u> Dodatkowym efektem inwestycji może stać się ośrodek rekreacyjno-balneologiczny wzbogacający ofertę wypoczynkową miasta. Wariantowe lokalizacje przewidziano w Głębockiem i Półwiosku Starym.\nMożliwe i celowe jest również wykorzystanie wód geotermalnych w podobnych celach w Licheniu Starym.\nDodatkowym kierunkiem wykorzystania ciepła w okresie wiosennym i jesiennym, może stać się jego sprzedaż do gospodarstw rolnych i ogrodniczych. Ze względu na nieznaną skalę zainteresowania, ma ona charakter perspektywiczny.\n\n<b>Odpady</b>\nGmina należy do Związku Międzygminnego „Koniński Region Komunalny”. W ramach tego Związku prowadzona jest na terenie gminy zbiórka selektywna odpadów. W miejscowych planach zagospodarowania przestrzennego należy przewidzieć lokalizację pojemników do <b>selektywnej zbiórki odpadów</b>.\nPrzewiduje się utrzymanie istniejącego <b>składowiska odpadów w Goraninie</b> do zakończenia jego eksploatacji. Niezbędne jest jednak wzmocnienie nadzoru nad eksploatacją obiektu i egzekwowanie działań minimalizujących jego negatywny wpływ na środowisko. Dopuszczalne są inwestycje związane z rekultywacją składowiska oraz zmniejszeniem jego negatywnego oddziaływania.\n\nŹródło: Studium uwarunkowań i kierunków zagospodarowania przestrzennego. Ślesin 2003, 2005.', 'Ochrona środowiska', '', 'trash', 'closed', 'closed', '', '284-2__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=284', 0, 'page', '', 0),
 (285, 1, '2017-08-03 18:21:38', '2017-08-03 20:21:38', '', 'trzciniak', '', 'inherit', 'open', 'closed', '', 'trzciniak', '', '', '2017-08-03 18:21:38', '2017-08-03 20:21:38', '', 284, 'http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/trzciniak.jpg', 0, 'attachment', 'image/jpeg', 0),
 (288, 1, '2017-08-03 18:26:22', '2017-08-03 20:26:22', 'Na obszarze gminy udokumentowano &lt;b&gt;złoża węgla brunatnego&lt;/b&gt; Pątnów II, Pątnów V &amp;#8211; Pole Ościsłowo, &lt;b&gt;surowce ilaste&lt;/b&gt; Wygoda i Sarnowa oraz &lt;b&gt;złoże kruszywa naturalnego&lt;/b&gt; Wygoda.\n\nW granicach obszaru górniczego Pątnów II prowadzona była eksploatacja złoża węgla brunatnego, zakończona w 2001 r. Obecnie dobiegają końca prace rekultywacyjne.\n\nZłoże węgla brunatnego &lt;b&gt;Pątnów V &amp;#8211; Pole Ościsłowo&lt;/b&gt; zostało udokumentowane jako jedna z soczewek złoża Pątnów V. Rozpoznano je w kat. C2 o zasobach bilansowych 40,5 mln ton. Średnia grubość nadkładu wynosi &lt;b&gt;50,5&lt;/b&gt; m i tworzą go: gleba , piasek, glina i ił. Średnia miąższość złoża węgla brunatnego wynosi &lt;b&gt;5,8 m&lt;/b&gt; a jego wartość opałowa &lt;b&gt;2092 kcal/kg&lt;/b&gt;. Obecnie trwają prace geologiczne na rozpoznanie złoża do kat. C1.\n&lt;b&gt;\nZłoże iłów warwowych Wygoda&lt;/b&gt; udokumentowano na powierzchni &lt;b&gt;6,0 ha&lt;/b&gt; a jego zasoby wynosiły &lt;b&gt;210 tys. m3&lt;/b&gt;. Nadkład o miąższości średnio &lt;b&gt;1,0 m&lt;/b&gt; stanowi gleba i piaski zaglinione. Średnia miąższość złoża wynosi &lt;b&gt;6,0 m&lt;/b&gt;. Złoże jest zawodnione, woda średnio występuje na głębokości &lt;b&gt;0,7 m ppt&lt;/b&gt;. Eksploatacji nie podjęto.\n\n&lt;b&gt;Złoże surowców ilastych Sarnowa&lt;/b&gt; udokumentowano na powierzchni &lt;b&gt;25,5 ha&lt;/b&gt; a jego zasoby wynosiły &lt;b&gt;1 555 tys. m3&lt;/b&gt;. Miąższość złoża waha się od &lt;b&gt;4,2 do 8,0 m&lt;/b&gt;, średnio &lt;b&gt;6,1 m&lt;/b&gt;. Nadkład stanowi gleba i piaski zaglinione. Grubość nadkładu wynosi &lt;b&gt;od 0,3 do 3,6 m, średnio 1,1 m&lt;/b&gt;. Kopalinę złoża stanowi glina, przydatna do produkcji cegły pełnej.\n\n&lt;b&gt;Złoże kruszywa naturalnego Wygoda&lt;/b&gt; udokumentowano na powierzchni &lt;b&gt;1,7 ha&lt;/b&gt;. Zasoby wynoszą &lt;b&gt;166 tys. t&lt;/b&gt;. Średnia miąższość złoża wynosi &lt;b&gt;5,98 m&lt;/b&gt;. Zalega ono pod nadkładem o grubości &lt;b&gt;0,5 m&lt;/b&gt;, który stanowi gleba. Punkt średni piaskowy wynosi 99,91%. Zwierciadło swobodne wody stwierdzono na głębokości &lt;b&gt;5,5 do 5,6 m ppt&lt;/b&gt;. Prowadzona jest eksploatacja złoża.\n\nŹródło: Studium uwarunkowań i kierunków zagospodarowania przestrzennego. Ślesin 2003, 2005.', 'Surowce mineralne', '', 'trash', 'closed', 'closed', '', 'surowce-mineralne__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=288', 0, 'page', '', 0),
 (290, 1, '2017-08-03 18:27:31', '2017-08-03 20:27:31', 'Gmina Ślesin odznacza się dobrymi warunkami glebowymi, dotyczy to zwłaszcza zachodniej części gminy, gdzie duże powierzchnie &lt;b&gt;gleby kl. III i IV, lokalnie nawet II&lt;/b&gt;, zaliczane do &lt;b&gt;kompleksu pszennego dobrego i pszenno &amp;#8211; żytniego&lt;/b&gt;. Są to na ogół &lt;b&gt;gleby brunatne lub bielicowe&lt;/b&gt; wytworzone z gleb i piasków gliniastych na glinie, a na terenach wilgotniejszych także &lt;b&gt;czarne ziemie&lt;/b&gt;.\n\nStruktura użytkowania gruntów w gminie Ślesin przedstawia się następująco:\n\nOgólna powierzchnia gminy - 14 544 ha, w tym:\n\n* użytki rolne - 8 600 ha, w tym gleby kl. II&amp;#8211;IV zajmują 61% powierzchni,\n* sady - 720 ha (5%),\n* użytki zielone - 916,3 ha (6,3%)\n* lasy - 2 300 ha (20%)\n\n&nbsp;\n\nŹródło: Studium uwarunkowań i kierunków zagospodarowania przestrzennego. Ślesin 2003, 2005.', 'Gleby', '', 'trash', 'closed', 'closed', '', 'gleby__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=290', 0, 'page', '', 0),
 (292, 1, '2017-08-03 18:33:32', '2017-08-03 20:33:32', 'Obszar gminy porasta roślinność typowa dla terenów silnie przekształconych antropogenicznie, obejmująca pospolite eurywalentne i kosmopolityczne gatunki, przynajmniej częściowo neolityczne. Tereny silnie przekształcone w wyniku działalności kopalni odkrywkowej (skarpy zwałowisk) obsadzone są częściowo <b>grochodrzewem i różanecznikiem żółtym</b> (nasadzenia przeciwerozyjne) oraz <b>pionierską roślinnością zieloną</b>, zdominowaną przez zbiorowiska z udziałem podbiału pospolitego, stanowiącą wstępne stadia sukcesji rekreatywnej w miejscach, gdzie całkowicie została zniszczona roślinność poprzednio tu występująca.\n\n[caption id="attachment_297" align="alignleft" width="268"]<img class="wp-image-297" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/koplekslichen.jpg" alt="" width="268" height="201" /> W okolicach Lichenia znajduje sie jeden z największych kompleksów leśnych w gminie Ślesin.[/caption]\n\nPowiat koniński należy do grupy regionów o stosunkowo niskim wskaźniku lesistości. Powierzchnia leśna zajmuje 25.013 ha i stanowi 15,8% ogólnej powierzchni powiatu. (Lesistość Polski wynosi 29% a europejski wskaźnik lesistości kształtuje się na poziomie 32%). Bardzo niski wskaźnik lesistości wynika z warunków jakie ukształtowały się na przestrzeni długiego okresu osiedleńczego i zajęcia stosunkowo dużych obszarów pod uprawy rolne. <u>W powiecie konińskim lesistość gminy Ślesin należy do najwyższych (21,12%)</u>. Ogólna powierzchnia lasów, wg stanu na 01.01.2001 r., wynosiła 3.077 ha, w tym lasów nie stanowiących własności Skarbu Państwa – 270 ha. Opracowana w Instytucie Ochrony Przyrody PAN w Warszawie mapa dolesień przewiduje <u>dalsze zalesienie ok. 450 ha gruntów porolnych</u>. Część z tych powierzchni zapewne stanowić będą obszary zrekultywowane po zakończeniu eksploatacji węgla brunatnego.\n\nDrzewostany w zarządzie Nadleśnictwa Konin stanowią pozostałości dawnych rozległych kompleksów leśnych ciągnących się od jez. Gopło do Warty. Teren ten obejmuje drzewostany w zróżnicowanym wieku, głównie <b>sosnowe</b> (proces pinetyzacji). Podszyt i warstwa zielna składają się z podrostu gatunków domieszkowych oraz roślinności krzewiastej i zielnej charakterystycznej dla l<b>asów borów mieszanych</b> i <b>świeżych</b> a miejscami także <b>grądów</b>. Wszystkie wyżej wymienione drzewostany znajdują się w <u>strefie lasów ochronnych dla m. Konina</u> i stanowią zaplecze turystyczno-rekreacyjne dla jego mieszkańców.\n\n[caption id="attachment_293" align="alignleft" width="290"]<img class="size-full wp-image-293" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/pole.jpg" alt="" width="290" height="218" /> Głównym typem zagospodarowania terenu gminy są pola uprawne.[/caption]\n\nUzupełnieniem istniejących zalesień są atrakcyjne zadrzewienia, stanowiące najczęściej obramowanie zbiorników wód powierzchniowych, występujące w postaci rozrzuconych w przestrzeni grup w dnie Doliny Grójeckiej, gdzie trwale i okresowo <b>podmokłe łąki</b> sąsiadują ze <b>zbiorowiskami roślin szuwarowych</b>.\n\nPonadto na uwagę zasługują zachowane <b>stare parki podworskie w Biskupim, Mikorzynie, Szyszynku, Wąsoszach i Piotrkowicach</b>, a także zasobne w <b>stary drzewostan</b> cmentarze w <b>Ślesinie</b> i w <b>Licheniu</b>.\nW okolicach Tokar w uroczysku "Sarni dołek" rośnie prawie 300-letni dąb chroniony jako pomnik przyrody.\n\nNależy też wyróżnić bogatą i różnorodną roślinność na terenie Sanktuarium Maryjnego w Licheniu.\n\nWzajemne przenikanie się dużych powierzchni wodnych i leśnych przy zróżnicowanej rzeźbie terenu wybitnie podnosi walory przyrodniczo – krajobrazowe terenu.\n\nW strefach objętych zabudową występuje zieleń urządzona (parki i skwery, zieleń przydomowa).\n\nDługotrwałe i intensywne oddziaływanie człowieka wywiera na całym obszarze swe piętno na elementach fauny i flory. Przejawia się to w ich synantropizacji, wprowadzaniu lub samodzielnym wkraczaniu gatunków nie występujących wcześniej w środowisku naturalnym tych terenów oraz eliminacji gatunków niezdolnych do przystosowania się do zmienionych warunków. Coraz powszechniej obserwowanym zjawiskiem jest synantropizacja gatunków dotychczas dziko żyjących, zwłaszcza ptactwa wodnego. Kurczenie się ich terenów lęgowych i naturalnych żerowisk, a także polowanie na nie (np. dzikie kaczki) zmusza je do przebywania w bliskim sąsiedztwie terenów zabudowanych.\n\nPotencjalna roślinność naturalna obszaru gminy Ślesin to przede wszystkim <b>siedliska grądów ubogich</b> (Galio-Carpinetum); stosunkowo niewielkie obszary zlokalizowane we wschodniej części gminy zajmują także <b>siedliska borowe kontynentalnego boru mieszanego</b> (Pino-Quercetum) i <b>suboceanicznego boru sosnowego</b> (Leucobryo-Pinetum).\n\nGłównym typem zagospodarowania terenu gminy są pola uprawne.\nRoślinność rzeczywista omawianego obszaru jest stosunkowo mało urozmaicona i determinowana różnym stopniem uwilgotnienia podłoża oraz intensywnością antropopresji. Tereny z wodami otwartymi to naturalne jeziora oraz dawne wyrobiska potorfowe z przeważnie dobrze wykształconym procesem ich wtórnego zarastania. Są one miejscem występowania gatunków roślin związanych ze strefą szuwarów i oczeretów, na które składają się m.in. <b>zespół „lilii wodnych” z grążelem żółtym i grzybieniem białym oraz zbiorowisko z osoką aloesowatą –</b> gatunkami rzadkimi i chronionymi, <u>wpisanymi na europejską i krajową „czerwoną listę”</u>.\n\nW bezpośrednim sąsiedztwie otwartego lustra wody, w miejscach ze stale stagnującą wodą, występują leśne <b>zbiorowiska olsowe</b> lub wstępne stadia sukcesyjne <b>łęgów wierzbowych</b>, a na terenach otwartych <b>łąki turzycowe</b> (z dominującymi <b>turzycami wysokimi</b>) lub sitowe. Na wilgotnych łąkach zachowały się dość liczne jeszcze populacje rzadkich już i chronionych gatunków roślin, jak <b>storczyki: błotny, szerokolistny i plamisty, osoka aloesowata i kosaciec żółty</b>. Tereny z okresowo stagnującą wodą (pochodzenia podskórnego) charakteryzujące się ekstensywną gospodarką łąkowo-pastwiskową zajmowane są przez <b>półnaturalne zbiorowiska łąk wilgotnych z siedliskami trzęślicy, manny mielec, wyczyńca i rajgrasów</b>. Rejony bardziej przesuszone, z co najwyżej krótkookresowym stanem podwyższonego uwilgocenia, zajmowane są przez zbiorowiska typowe dla krajobrazu rolniczego o niskiej intensywności. Partie najwyższe wykorzystywane były pod osadnictwo i tereny orne, zazwyczaj o niskiej bonitacji (kompleks żytnio-ziemniaczany).\n\nŹródło: Studium uwarunkowań i kierunków zagospodarowania przestrzennego. Ślesin 2003, 2005.', 'Szata roślinna', '', 'trash', 'closed', 'closed', '', 'szata-roslinna__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=292', 0, 'page', '', 0),
 (293, 1, '2017-08-03 18:32:20', '2017-08-03 20:32:20', '', 'pole', 'Głównym typem zagospodarowania terenu gminy są pola uprawne.', 'inherit', 'open', 'closed', '', 'pole', '', '', '2017-08-03 18:32:20', '2017-08-03 20:32:20', '', 292, 'http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/pole.jpg', 0, 'attachment', 'image/jpeg', 0),
 (299, 1, '2017-08-03 18:50:58', '2017-08-03 20:50:58', '[caption id="attachment_300" align="alignleft" width="187"]<img class=" wp-image-300" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/dzczarny.jpg" alt="" width="187" height="248" /> Nierzadkim gościem w podślesińskich lasach jest dzięcioł czarny, który swoją obecność zdrasza głośnym nawoływaniem.[/caption]\n\nŚwiat zwierząt reprezentowany jest głównie przez pospolite gatunki ekologicznie <u>przystosowane do występowania w silnie przekształconym antropogenicznie środowisku</u> (z których najliczniej występują stosunkowo jednorodne agrocenozy), choć są wśród nich także gatunki chronione oraz uznane za zagrożone wyginięciem w skali Europy. Fauna kręgowców tego terenu, podobnie jak roślinność, obejmuje gatunki przystosowane do życia w sąsiedztwie człowieka. Główny trzon stanowią populacje synurbijnych gatunków powszechnie występujące w miastach i na obszarach segetalnych. Są to m.in. <b>wróbel domowy, sterówka, potrzeszcz, kopciszek, pliszka siwa, nornik zwyczajny, mysz polna, kuna domowa</b> itp.</div>\nKonsekwencją zróżnicowania siedliskowego jest znaczna różnorodność faunistyczna najsilniej przejawiająca się w bogactwie ptaków, które reprezentowane są przez ok. <b>150 gatunków</b>, w tym także z grupy wodno-błotnych.\n\n[caption id="attachment_301" align="alignright" width="169"]<img class=" wp-image-301" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/dzierlatka.jpg" alt="" width="169" height="195" /> Dzierlatka jest ginącym gatunkiem obszarów wiejskich, który w gminie Ślesin nadal daje się obserwować.[/caption]\n\nW obrębie jezior i zarastających wyrobisk torfowych występują m.in. <b>bąk, bączek, perkozy: dwuczuby, zausznik, perkozek rdzawo szyi oraz kokoszka, kropiatka i zielonka</b>. Ponadto z otwartymi wodami stojącymi związane są także <b>rybitwy rzeczne i czarne</b> a w okresie przelotów i migracji również <b>białoczelne i białoskrzydłe</b>. Stwierdzono także próby kolonijnego gnieżdżenia się <b>śmieszki</b>. Zarośla i szuwary są miejscem występowania <b>ptaków wróblowych (trzciniak, wąsatka, trzcinniczek, brzęczka, rokitniczka, świreszczak łozówka)</b>. Pobrzeża zadrzewień i starszych zakrzewień są miejscem występowania <b>żurawia, remiza i ortolana</b>. Natomiast tereny otwarte, w szczególności turzycowiska i łąki wilgotne, są siedliskami dla <b>derkacza, kszyka, rycyka, brodźca krwawodziobego i kulika wielkiego –</b> gatunków ptaków zaliczanych do najbardziej zagrożonych wyginięciem w skali Europy. Istotnym elementem lokalnej awifauny są gatunki pojawiające się tutaj już po okresie lęgowym, w trakcie migracji jesiennych i wiosennych, a także zimujące. Szczególnie istotną rolę odgrywają jeziora konińskie, których sztucznie podgrzewana woda jest bardzo dogodnym miejscem żerowania i odpoczynku dla licznych stad ptaków wodnych. Publikowane dane wskazują, że <u>jeziora konińskie są jedną z najważniejszych ostoi ptaków wodnych na śródlądziu</u> w okresie zimowania i przelotów.\n\n[caption id="attachment_302" align="alignleft" width="222"]<img class=" wp-image-302" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/czapla-siwa2.jpg" alt="" width="222" height="324" /> Czaplę siwą można obserwować nad wodami ślesińskich jezior cały rok.[/caption]\n\nNajwiększe znaczenie obszar ten ma dla<b> łyski</b> (co najmniej kilkanaście tysięcy osobników), <b>czernicy, krzyżówki i świstuna</b>. W sumie odnotowano to ok. 50 gatunków ptaków wodnych.\n\nSsaki tego obszaru także reprezentują w pełni faunę niżowej części Polski. Na uwagę zasługuje fakt pojawiania się tutaj <b>łosi</b>, dla których jednakże obszar gminy Ślesin nie stanowi stałej ostoi. Płazy reprezentowane są przez wszystkie gatunki występujące na niżu Polski, z <b>ropuchą paskówką i traszką grzebieniastą</b> włącznie. Najliczniejszym przedstawicielem gadów jest <b>zaskroniec oraz jaszczurka zwyczajna</b>. Fauna ryb poza typowymi przedstawicielami krajowych gatunków została wzbogacona gatunkami egzotycznymi – <b>amurem białym i tołpygą pstrą</b>, które zostały sztucznie wprowadzone do jezior konińskich w celu spowolnienia procesu ich zarastania, będącego wynikiem zmiany warunków termicznych spowodowanych włączeniem tych akwenów do systemu chłodzenia elektrowni Konin i Pątnów.\n\nBezkręgowce są najsłabiej poznaną grupą zwierząt, tym niemniej z całą pewnością występują tutaj m.in. <b>tygrzyki paskowane –</b> bodaj najpiękniejsze krajowe pająki oraz kilka gatunków <b>ważek</b> i obie <b>świtezianki</b> – związane ze strefą brzegową zbiorników wodnych i terenami otwartymi. Wraz z obcymi rybami przywędrowały liczne bezkręgowce (m.in. <b>wirki i skąposzczety</b>) oraz ciepłolubne <b>małże</b> należące do rodzaju Anodonta sp. (Unionidae), których egzystencja w wodach jezior konińskich jest ściśle związana z podwyższoną temperaturą wody w tych akwenach. W wyniku prowadzonych na tym terenie od wielu lat systematycznych badań hydrobiologicznych udało się nawet stwierdzić i opisać <b>dotychczas nieznany nauce gatunek skąposzczeta Chaetogaster zdanowski sp nov.</b> Obecnie panująca w jeziorach konińskich swoista równowaga ekologiczna jest bardzo nietrwała i podatna na wielorakie antropogeniczne zakłócenia, których źródłem są lub mogą być rekreacja, urbanizacja zlewni, rolnictwo wraz z rybactwem i przemysł.\n\nŹródło: Studium uwarunkowań i kierunków zagospodarowania przestrzennego. Ślesin 2003, 2005.', 'Zwierzęta', '', 'trash', 'closed', 'closed', '', 'zwierzeta__trashed', '', '', '2017-10-24 19:11:45', '2017-10-24 19:11:45', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=299', 6, 'page', '', 0),
 (300, 1, '2017-08-03 18:46:21', '2017-08-03 20:46:21', '', 'dzczarny', 'Nierzadkim gościem w podślesińskich lasach jest dzięcioł czarny, który swoją obecność zdrasza głośnym nawoływaniem.', 'inherit', 'open', 'closed', '', 'dzczarny', '', '', '2017-08-03 18:46:21', '2017-08-03 20:46:21', '', 299, 'http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/dzczarny.jpg', 0, 'attachment', 'image/jpeg', 0),
 (301, 1, '2017-08-03 18:48:15', '2017-08-03 20:48:15', '', 'dzierlatka', 'Dzierlatka jest ginącym gatunkiem obszarów wiejskich, który w gminie Ślesin nadal daje się obserwować.', 'inherit', 'open', 'closed', '', 'dzierlatka', '', '', '2017-08-03 18:48:15', '2017-08-03 20:48:15', '', 299, 'http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/dzierlatka.jpg', 0, 'attachment', 'image/jpeg', 0),
 (302, 1, '2017-08-03 18:50:04', '2017-08-03 20:50:04', '', 'czapla siwa2', 'Czaplę siwą można obserwować nad wodami ślesińskich jezior cały rok.', 'inherit', 'open', 'closed', '', 'czapla-siwa2', '', '', '2017-08-03 18:50:04', '2017-08-03 20:50:04', '', 299, 'http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/czapla-siwa2.jpg', 0, 'attachment', 'image/jpeg', 0),
 (305, 1, '2017-08-03 18:54:00', '2017-08-03 20:54:00', 'Według podziału Niziny Wielkopolskiej na regiony B. Krygowskiego, teren gminy należy do <b>Wysoczyzny Gnieźnieńskiej</b>, w obrębie  której w tym rejonie wyróżniono następujące subregiony:\n\n    * Pagórki Ślesińskie\n    * Obniżenie Mikorzyńskie\n    * Równina Ignacewska\n    * Pagórki Wilczyńsko-Skulskie\n    * Obniżenie Goplańskie\n\nOd południa obszar gminy ogranicza <b>Pradolina Warszawsko-Berlińska</b>.\n\n<b>Równina Kleczewska</b> zajmuje północno-zachodnią i południowo-zachodnią część gminy. W części środkowej rozdzielają ją <b>Pagórki Ślesińskie</b>. Wznosi się ona na wysokość od około <b>90</b> m npm w części południowej, do około <b>100</b> m npm w części północnej.\n\nPagórki Ślesińskie zajmują środkową część gminy. Rozcina je z północy na południe rynna polodowcowa &#8211; <b>Obniżenie Mikorzyńskie</b>.\n\nWschodnią część gminy Ślesin zajmuje <b>Obniżenie Goplańskie</b>. Stanowią je podmokłe tereny, zalegające na wysokości około <b>85</b> m npm.\n\nMiędzy Pagórkami  Skulskimi i Obniżeniem Mikorzyńskim a Obniżeniem Goplańskim na wschodzie rozpościera się <b>Równina Ignacewska</b>. Leży ona na wysokości około <b>90</b> m npm.', 'Środowisko geograficzne', '', 'trash', 'closed', 'closed', '', 'srodowisko-geograficzne__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=305', 0, 'page', '', 0),
 (307, 1, '2017-08-03 18:57:30', '2017-08-03 20:57:30', '[caption id="attachment_308" align="alignleft" width="240"]<img class=" wp-image-308" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/mewyjezlato.jpg" alt="" width="240" height="180" /> Nad brzegami jezior chętnie przesiadują różne gatunki mew.[/caption]\n\n<u>Środkowa część gminy</u> Ślesin, <u>w obrębie ciągu jezior konińskich wraz z kanałem Warta-Gopło, pełni w sieci <b>ECONET-Polska</b> funkcje korytarza ekologicznego łączącego obszary o znaczeniu międzynarodowym: doliny rzeczne Warty i Wisły, poprzez jez. Gopło, rz. Noteć i kanał Bydgoski</u>, należące do najistotniejszych elementów systemu w niżowej części kraju. Obszar ten zapewnia przestrzenną i ekologiczną łączność pomiędzy zlewniami dwóch największych rzek Polski – Wisły i Odry. Gwarantuje to zachowanie spójnej przestrzennie struktury obszarów najmniej przekształconych pod względem przyrodniczym zarówno na poziomie regionalnym jak i międzynarodowym.\n\nW skali lokalnej, przez teren gminy przebiegają <u>korytarze ekologiczne łączące system jezior konińskich z doliną górnej Noteci</u> (aż po jez. Przedeckie) oraz poprzez jeziora Głodowskie, Wściekłe, Skąpe, Mielno i Koziegłowskie <u>z jeziorami wilczyńskimi na terenie Powidzkiego Parku Krajobrazowego</u>. Stosunkowo wysoka wartość przyrodnicza tego korytarza przejawia się w znacznej stałości występowania poszczególnych typów krajobrazu oraz zbliżonym stopniem i rodzajem jego przekształcenia, co przy wiodącym udziale podmokłych siedlisk stwarza bardzo dogodne warunki do swobodnej dyspersji gatunków wymagających przynajmniej okresowych zalewów lub podtopień. Ponadto rangę korytarza podnosi fakt braku alternatywnych istniejących i potencjalnych połączeń.\n\nWzdłuż <u>wschodniej granicy</u> gminy rozciąga się <b>fragment rozległej Doliny Grójeckiej, wiążącej dolinę Noteci z Wartą</b>. Dolina ta posiada blisko kilometrowej szerokości podmokłe płaskie dno oraz łagodne zbocza. Na odcinku Bylew – Ignacewo w jej obszarze znajduje się zwałowisko zewnętrzne odkrywki „Lubstów”.\n\nNiemal cały obszar położony na zachód od rynny jeziornej zajmuje <b>równina denno – morenowa</b> będąca fragmentem Równiny Kleczewskiej.\n\nŹródło: Studium uwarunkowań i kierunków zagospodarowania przestrzennego. Ślesin 2003, 2005.', 'Środowisko przyrodnicze', '', 'trash', 'closed', 'closed', '', 'srodowisko-przyrodnicze__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=307', 0, 'page', '', 0),
 (310, 1, '2017-08-03 19:01:36', '2017-08-03 21:01:36', '<b>Komunikacja samochodowa</b></span>\nGmina Ślesin leży na przecięciu szlaków drogowych o istotnym znaczeniu w skali kraju \ni regionu. Na kierunku północ &#8211; południe przebiega centralnie <b>droga krajowa nr 25</b>, łącząca województwa zachodnio-pomorskie, pomorskie, kujawsko-pomorskie i dolnośląskie. \nNa kierunku wschód &#8211; zachód również centralnie biegnie <b>droga wojewódzka nr 263</b>, krzyżując się z drogą krajową w rejonie przeprawy przez rynnę jeziorną w mieście Ślesinie.\n\nUkład ten, wraz z uzupełniającymi go drogami powiatowymi i gminnymi, tworzy <b>system gwiaździsty</b>, z którym przenika się w południowo-wschodniej części gminy lokalny, również <b>promienisty</b>, węzeł dróg powiatowych w Licheniu Starym.\nPrzez obszar gminy przebiega droga krajowa nr 25 relacji Kalisz &#8211; Inowrocław oraz krzyżująca się z nią w Ślesinie droga wojewódzka nr 263 Słupca &#8211; Sompolno. Droga nr 25 wiąże miasto Ślesin z Koninem i autostradą A2.\n\nŚrodkiem obszaru gminy przebiega <b>rynna żeglownego kanału Warta &#8211; Gopło</b>, wykorzystującego ciąg jezior Pątnowskiego, Wąsoskiego, Mikorzyńskiego i Ślesińskiego.\n\nFunkcjonalnie gmina ciąży do <b>Konina</b> jako regionalnego ośrodka usługowego. W zasięgu oddziaływania funkcji rekreacyjnej leżą: Poznań, Kalisz, Łódź, Inowrocław.\n\n<a href="http://gminaslesin.futurehost.pl/wp-content/uploads/Mapaslesina.jpg">Zobacz mapę gminy Ślesin</a>\n\n<span style=\'color:navy;\'><b>Transport kolejowy</b></span>\nIstniejące na obszarze gminy linie kolejowe związane są z obsługą odkrywek węgla brunatnego i transportem węgla. Wiążą one odkrywki Pątnów, Lubstów i Drzewce pomiędzy sobą oraz z elektrowniami. W związku z planowaną realizacją w okresie kierunkowym kolejnej odkrywki Tomisławice w gminie Wierzbinek, <u>kolej będzie trwałym elementem zagospodarowania gminy</u>.\n\nLinia do odkrywki Lubstów, z racji niewielkiego oddalenia od Lichenia Starego, stwarza możliwość wykorzystania jej w ruchu turystycznym.\n\nW najbliższym czasie nastąpi budowa bocznego odcinka trasy węglowej do Lubstowa, włączającego budowaną odkrywkę Drzewce w gminie Kramsk, do systemu transportu węgla.\n\nJeszcze niedawno przez gminę przechodziły tory Sompolińskiej Kolei Dojazdowej, która świetnie prosperowała przez kilkadziesiąt lat. <img src=\'http://www.klimaty.wask.pl/smpkd/02042131a.jpg\' style=\'margin:5px;\' align=\'right\'>Z Sompolna można było wąskotorówką dojechać do Koła i dalej do Krośniewic, a w innych kierunkach do Nieszawy lub do Jabłonki, a stąd do Gniezna. Wagonikami ciągniętymi przez parowozy, a potem lokomotywki spalinowe wożono towary dla miejscowych GS-ów, węgiel, buraki cukrowe, a także sporo pasażerów. Transport przestał być opłacalny już kilkanaście lat temu, ale ostateczny krach wąskotorówki z Sompolna nastąpił na początku obecnego stulecia. PKP zaczęły pozbywać się majątku wąskotorowych bankrutów, a samorządy nie chciały przejąć kolejki. \nNiedawno podjęto starania by odbudować <b>kolejkę wąskotorową</b> w relacji Ślesin - Koło. Ze względu na bardzo zniszczoną trakcję, zerwane tory i nowe obiekty na trasie, nie nastąpi to szybko, jeśli wogóle. Gdyby powstała byłaby dużą atrakcją turystyczną. \n\n<span style=\'color:navy;\'><b>Komunikacja rowerowa</b></span>\nSystem dróg rowerowych w gminie tworzą <b>układy pętlowe</b>:\n\n* Ślesin &#8211; Wąsosze &#8211; Kępa &#8211; Licheń Stary &#8211; Bylew &#8211; Ignacewo &#8211; Głębockie - Półwiosek Lubstowski,\n* Półwiosek Lubstowski &#8211; Kolebki &#8211; Piotrkowice &#8211; Wygoda &#8211; Licheń Stary,\n* Ślesin &#8211; Głębockie &#8211; Nowa Ruda - Żółwieniec &#8211; Ślesin,\n* Ślesin &#8211; Sarnowa &#8211; Biskupie &#8211; Ostrowąż &#8211; Szyszyn &#8211; Teodorowo - Ślesin.\n\nSystem ten jest związany z istniejącymi szlakami rowerowymi prowadzącymi <b>z Konina do Lichenia Starego oraz z Sopolna do Ignacewa</b>.\n\n<span style=\'color:navy;\'><b>Komunikacja wodna</b></span>\nPołączenie polskich śródlądowych dróg wodnych z systemem dróg wodnych Unii Europejskiej, m.in. poprzez szlak Odra &#8211; Wisła, sprzyjać powinno rozwojowi żeglugi na drogach wodnych niższych klas, z których przez gminę Ślesin przebiega <b>droga wodna Warta &#8211; Kanał Bydgoski</b>.\nWzrost znaczenia żeglugi dotyczy zarówno transportu towarowego jak i pasażerskiego. Na drodze Warta &#8211; Kanał Bydgoski dominować powinna żegluga pasażerska rozbudowana o szlak turystyczny w kierunku Lichenia.\n\n\n\nŹródło: Studium uwarunkowań i kierunków zagospodarowania przestrzennego. Ślesin 2003, 2005.', 'Sieć komunikacyjna', '', 'trash', 'closed', 'closed', '', 'siec-komunikacyjna__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=310', 0, 'page', '', 0),
 (312, 1, '2017-08-03 19:02:59', '2017-08-03 21:02:59', 'Podstawowymi funkcjami gminy są: rekreacja, wykorzystująca obszar rynien jeziornych i rolnictwo z leśnictwem, rozwinięte w oparciu  o dość korzystne warunki glebowe.\n\nBardzo przejrzysta struktura przyrodnicza przyczyniła się do wysokiego stopnia niezależności obu głównych funkcji gminy, skoncentrowanych w obszarach o jednolitym charakterze. O ile jednak obszary rolnicze rozwijają się w sposób zgodny ze środowiskiem, o tyle w obszarach rekreacji zagospodarowanie osiągnęło już stan przekroczenia pojemności środowiska i powoduje konieczność podjęcia działań kompensacyjnych.\n\nGłównym ośrodkiem administracyjnym i gospodarczym gminy jest centralnie położone miasto Ślesin. Skoncentrowane tu są usługi o charakterze ogólnogminnym.\n\nOśrodkiem wspomagającym jest Licheń Stary, gdzie w związku z kultem M.B.Bolesnej Królowej Polski, rozwinęły się funkcje obsługi ruchu pielgrzymkowego. Pod względem ilości odwiedzających, Sanktuarium Licheńskie pełni rolę drugiego po Częstochowie ośrodka kultu religijnego w Polsce.    \n\nPodstawową, charakterystyczną cechą struktury funkcjonalnej gminy jest widoczna &#8222;dwudzielność&#8221; układu spowodowana warunkami przyrodniczymi. Obie części gminy związane są układem komunikacyjnym jedynie w  trzech punktach, oddalonych od siebie o ok. 6 km.\n\nW obu częściach obszaru gminy zaznaczają się różnice w zakresie cech środowiska przyrodniczego oraz funkcji jednostek osadniczych.\n\n    * Zachodnia część gminy zdominowana jest przez wpływ nieczynnej już odkrywki Pątnów II i związanego z nią przemysłu energetycznego. Przejawami jego jest lej depresyjny w utworach trzeciorzędowych,  rekultywacja wyrobiska i ciągi tranzytowych linii elektroenergetycznych wysokiego napięcia obniżające walory przestrzeni.\n\nPodstawową funkcją jest rolnictwo na glebach o wysokich i średnich klasach bonitacyjnych, a w północnych rejonach rekreacja oraz, wkraczające na nieużytkowane słabe gleby, leśnictwo.\n\n    * Wschodnia część gminy ma bardziej zróżnicowane środowisko przyrodnicze &#8211; ukształtowanie terenu i szatę roślinną, co wpłynęło na silniejszy rozwój funkcji rekreacyjnych i co za tym idzie &#8211; postępującą degradację naturalnych walorów.\n\nPod względem funkcjonalnym, coraz bardziej zaznacza się w tej części oddziaływanie intensywnie rozwijającego się Lichenia Starego.\n\nNa podstawie uwarunkowań oraz istniejącej struktury przestrzennej, obszar gminy podzielono umownie na strefy funkcjonalno-krajobrazowe o zróżnicowanych zasadach polityki zagospodarowania, celem uporządkowania funkcji, określenia zasad rozwoju oraz wprowadzenia ładu przestrzennego dla poszczególnych, posiadających swoiste cechy, części gminy. \n\nNa podstawie przyjętych kryteriów w przestrzeni gminy Ślesin wyznaczono cztery główne strefy funkcjonalno-krajobrazowe, mianowicie:\n\n<b>    * Strefa U  &#8211; strefa przyspieszonego rozwoju społeczno-gospodarczego,</b>\nW granicach strefy U znajduje się miasto Ślesin, tereny przylegające do miasta w paśmie rozciągającym się wzdłuż drogi krajowej nr 25, Szyszyńskie Holendry i Kijowiec. Strefa obejmuje krajobraz w znacznym stopniu już zurbanizowany, dzieląc strefę turystyczno-mieszkaniową rozciągającą się w centrum gminy. Od zachodu ograniczona jest terenami rolnymi. Największymi jednostkami osadniczymi w strefie są: miasto Ślesin i Szyszyńskie Holendry.\nStrefa U ukształtowana została wskutek obudowy ważnych szlaków komunikacyjnych, które stanowią droga krajowa nr 25 relacji Ostrów Wlkp.-Inowrocław i droga wojewódzka nr 263. Uwzględniono także przebieg projektowanej obwodnicy Ślesina w ciągu drogi krajowej nr 25, biegnącej od węzła w Lubomyślu, wzdłuż zachodniej granicy miasta Ślesina i łączącej się z drogą krajową nr 25 w Szyszyńskich Holendrach. Tereny bezpośrednio przylegające do szlaków komunikacyjnych przeznaczono na cele zabudowy przemysłowej i działalności gospodarczej. Funkcje te zlokalizowano przede wszystkim na zachodnim i północnym obrzeżu miasta Ślesina, we wsi Szyszyńskie  Holendry i w Lubomyślu. Zdecydowanie największe skupiska zabudowy przemysłowej znajdują się w zachodniej części miasta Ślesina. \n<b>    * Strefa TW  &#8211; strefa turystyczno-mieszkaniowa,</b>\nObejmuje teren o dużych walorach przyrodniczo-krajobrazowych położony w centralnej części gminy Ślesin. W granicach strefy znajdują się tereny rekreacyjne i mieszkaniowe wsi Żółwieniec, Głębockie, Półwiosek Lubstowski, Półwiosek Stary, Wąsoskie Holendry, Wąsosze, Kępa, Niedźwiady, Wygoda, Dąbrowa, Mikorzyn, Honoratka.\n\nAtrakcyjny krajobrazowo obszar obejmuje tereny otaczające rynny jeziorne z sąsiadującymi zespołami łąkowymi i połaciami leśnymi.\nTereny turystyczno-wypoczynkowe o znacznych powierzchniach wyznaczono we wsiach: Głębockie, Półwiosek Lubstowski, Półwiosek Stary, Wąsoskie Holendry, Żółwieniec i Mikorzyn. Z uwagi na uwarunkowania przyrodnicze i krajobrazowe są to tereny przeznaczone przede wszystkim na cele lokalizacji kubaturowych urządzeń sportu, turystyki, rekreacji i wypoczynku oraz terenów powierzchniowych urządzeń sportu i turystyki. W pozostałych miejscowościach wyznaczono tereny zabudowy rezydencjonalnej przede wszystkim o charakterze rekreacyjnym. Największe tereny przeznaczono we wsiach: Niedźwiady, Mikorzyn, a także Półwiosek Stary i Wąsoskie Holendry.\n<b>    * Strefa R  &#8211; strefa rolniczo-mieszkaniowa,</b>\nObejmuje dwa obszary, z których pierwszy jest położony w północno-wschodniej, a drugi w części centralnej gminy. Obszary R są rozdzielone przez  strefy U i TW.\nW skład strefy R wchodzą następujące jednostki wiejskie: Ostrowąż, Biskupie, Szyszyn, Kijowiec, Sarnowa, Rożnowa, Goranin oraz drugi obszar, który obejmuje następujące miejscowości: Piotrkowice, Półwiosek Stary, Półwiosek Nowy, Wąsosze, Kolebki, Niedźwiady, Julia, Kępa.\nStrefy te stanowią ukształtowaną przestrzeń zachowującą użytkowanie rolnicze. Konieczne jest utrzymanie istniejących powiązań produkcji rolnej ze środowiskiem  przyrodniczym. \nW obrębie stref wydzielono powierzchnie terenów przeznaczonych na zabudowę zagrodową i mieszkaniową jednorodzinną z możliwością lokalizacji towarzyszących usług, a także na zabudowę rezydencjonalną. Największe kompleksy zabudowy mieszkaniowej wyznaczono we wsiach Szyszyn, Piotrkowice, Kępa, Biskupie i Sarnowa. Z uwagi na uwarunkowania przyrodnicze, atrakcyjny krajobraz i dogodne połączenia komunikacyjne wyznaczone tereny stanowią korzystną ofertę terenów zabudowy mieszkaniowej.\n<b>    * Strefa E   &#8211; strefa ochrony zasobów przyrodniczych,</b>\nObejmuje teren położony w południowej i wschodniej  części gminy.\nW skład strefy E wchodzą następujące jednostki wiejskie: Ignacewo, Pogorzele, Smólniki, Wierzelin, Pogoń Lubstowska, Pogoń Gosławicka, Bylew, Wygoda.\nW obrębie strefy znajdują się znaczne powierzchnie terenów leśnych i łąkowych oraz tereny rolne. Z uwagi na uwarunkowania przyrodnicze, atrakcyjny krajobraz i dogodne połączenia komunikacyjne wyznaczone tereny stanowią korzystną ofertę dla rozwoju różnych form rekreacji. Szczególnie korzystne warunki występują we wsiach: Wierzelin, Leśnictwo, Wygoda, Ignacew\n  <b>  * Strefa ZG  &#8211; zagospodarowania terenów pogórniczych,\n</b>Obejmuje teren o głębokich przekształceniach krajobrazowych i przyrodniczych będących rezultatem wydobycia węgla brunatnego. W obrębie obszaru górniczego zamkniętej w 2003 r. odkrywki Pątnów II znajdują się obecnie:\n\n    * wyrobisko końcowe odkrywki &#8211; rekultywowane w kierunku wodnym, z brzegami zbiornika obsadzonymi lasem,\n    * zwałowisko wewnętrzne &#8211; rekultywowane w docelowym kierunku rolno-leśnym, na terenie którego deponowane są odpady paleniskowe Elektrowni &#8222;Patnów&#8221; Zespołu Elektrowni Pątnów-Adamów-Konin S.A. oraz eksploatowane są składowisko odpadów stałych ZE PAK S.A. i składowisko odpadów innych niż niebezpieczne i obojętne z kwatera na odpady &#8222;azbestowe&#8221; .\n\nDla obszaru wodnego przewidywana jest funkcja rekreacyjna, której udostępnienie uzależnione jest od stanu sanitarnego wody. Przewiduje się lokalizację 3 ośrodków rekreacyjno-sportowych, z możliwością dalszego zagospodarowania w kierunku budownictwa rekreacyjnego.\n\nDla terenu zwałowiska wewnętrznego ustala się rolno - leśny kierunek rekultywacji z możliwością lokalizacji terenów przemysłowych. W obszarze tym przewiduje się lokalizacje obiektów przetwarzania i unieszkodliwiania odpadów, prowadzenia działalności w zakresie odnawialnych źródeł energii (OZE) oraz upraw roślin przemysłowych i energetycznych. \n\nŹródło: Studium uwarunkowań i kierunków zagospodarowania przestrzennego. Ślesin 2003, 2005.', 'Funkcje', '', 'trash', 'closed', 'closed', '', 'funkcje__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=312', 0, 'page', '', 0),
 (314, 1, '2017-08-03 19:04:08', '2017-08-03 21:04:08', 'Prowadzona w ciągu  ostatnich kilkudziesięciu lat działalność kopalni odkrywkowych spowodowała znaczną degradację środowiska przyrodniczego poprzez fizyczne zajęcie znacznych obszarów. Wywołało to istotne zmiany w charakterze flory i fauny.\n\nNa pozostałych terenach izolowanych przez zwałowiska i odkrywki odnotowano w zdecydowanej większości pogorszenie warunków wilgotnościowych i ograniczenie dyspersji, przez co utraciły one swoje pierwotne funkcje oraz charakteryzujące je florę i faunę.\n\nIntensywna eksploatacja złóż węgla brunatnego spowodowała <b>zachwianie równowagi hydrogeologicznej</b>. Duża część gminy znalazła się w zasięgu leja depresyjnego kopalni a ciąg jezior Gosławskiego &#8211; Pątnowskiego &#8211; Mikorzyńskiego &#8211; Ślesińskiego oraz Licheńskiego znalazł się w systemie chłodzenia zespołu elektrowni.\n\nJako rekompensatę za ubytki wody w studniach gospodarczych gmina i Kopalnia Węgla brunatnego wybudowała studnie wody pitnej z podwęglowych pokładów wodonośnych oraz sieć wodociągów wiejskich. <u>Cała gmina jest zwodociągowana</u> i w pełni zaspokaja zapotrzebowanie na wodę pitną i cele gospodarcze.\n\nPraktycznie cała gmina znajduje się w zasięgu potencjalnego oddziaływania negatywnych skutków powierzchniowej eksploatacji złóż węgla brunatnego. Ponadto teren gminy jest dobrym przykładem występowania całokształtu procesów charakterystycznych dla krajobrazu rolniczego niżowej części kraju, gdzie uwidaczniają się skutki forsowanych w przeszłości koncepcji w zakresie zagospodarowania przestrzennego oraz struktury agrarne, co w konsekwencji doprowadziło do nadmiernej defragmentacji poszczególnych typów krajobrazów i środowisk.\n\nKolejnym negatywnym czynnikiem jest rozdrobniona zabudowa jednorodzinna o charakterze zagrodowym oraz zabudowa letniskowa koncentrująca się wzdłuż granic kompleksów leśnych oraz wzdłuż brzegów jezior konińskich. Procesy defragmentacji poszczególnych komponentów lokalnego środowiska przyrodniczego uległy nasileniu w wyniku rozbudowy istniejącej infrastruktury komunikacyjnej, która nie jest wyposażona w urządzenia umożliwiające w miarę swobodne bezpieczne przemieszczanie się zwierząt.\n\nGmina Ślesin jest dość zróżnicowana pod względem struktury przyrodniczej, a co za tym idzie, także bioróżnorodności. Najwyższą wartość pod tym względem przedstawia centralna część gminy w obrębie rynien glacjalnych wypełnionych wodami jezior, która znalazła odzwierciedlenie we wszystkich wielkoprzestrzennych waloryzacjach przyrody i krajobrazu realizowanych w Polsce w ostatnich 30 latach (ESOCh, ECONET-Polska) uznających ten obszar za korytarz ekologiczny o znaczeniu krajowym. Drugim pod względem zróżnicowania biologicznego obszarem jest wschodnia część gminy obejmująca zwarty kompleks leśny, będący następstwem systematycznego zalesiania najmniej przydatnych rolniczo terenów, co skutkuje występowaniem mozaiki pól i lasów. Pewne znaczenia ma także zwarty kompleks agrocenoz występujący w północno-zachodniej części gminy. Niezbyt urozmaicona lokalna sieć hydrograficzna pełni funkcje korytarzy ekologicznych, rozumianych jako przestrzenne struktury, które umożliwiają rozprzestrzenianie się gatunków pomiędzy obszarami o takiej samej lub zbliżonej charakterystyce przyrodniczej.\n\nNajmniej zróżnicowaną pod względem bogactwa przyrodniczego jest zwarta zabudowa miejska Ślesina oraz powierzchnie poeksploatacyjne. Rolę enklaw i refugiów dla rodzimej flory i fauny pełnią na tych obszarach zadrzewienia i zakrzaczenia wprowadzane jako forma rekultywacji terenu i próba ustabilizowania skarp zwałowiska. Mimo stosowania do nasadzeń gatunków drzew i krzewów o różnej proweniencji, miejscami wykształciły się na tych terenach bardzo specyficzne warunki, interesujące z naukowego punktu widzenia. Są one obiektem dalszych badań i obserwacji, które w szczególności dotyczą spontanicznej sukcesji zbiorowisk roślinnych na tych terenach. Same zwałowiska oferują niekiedy dogodne warunki bytowania rodzimej flory i fauny w wyniku pojawiania się niewielkich zbiorników powierzchniowych w miejscach o utrudnionym odpływie wód opadowych.\n\nTe enklawy stanowią bardzo dobre miejsce rozmnażania dla lokalnych populacji płazów i owadów związanych z wodami stojącymi.\n\nKolejnym istotnym elementem zmieniającym dotychczasowy charakter gminy są modyfikacje ekosystemu jezior konińskich, stanowiących ważną część obiegu chłodzenia wody elektrowni Konin i Pątnów. Specyficzne zmiany w środowisku jezior wywołane m.in. zanieczyszczeniami termicznymi, spowodowały wytworzenie się w ich obrębie unikatowego w skali ogólnoświatowej układu ekologicznego. Układ ten okazał się być bardzo atrakcyjny dla wielu grup wodnych roślin i zwierząt, m.in. dla ptaków wodnych i błotnych jako miejsce odpoczynku w trakcie migracji oraz zimowisko &#8211; jedno z najważniejszych w śródlądowej części Polski.\n\nNa obszarze gminy Ślesin wyróżnia kilka stref zróżnicowanej polityki przestrzennej:\n    * strefę rolno-leśną z wielofunkcyjnym rozwojem wsi,\n    * strefę leśno-rekreacyjną z rolnictwem ekologicznym,\n    * strefę przyspieszonego rozwoju społecznego i gospodarczego,\n    * strefę Konińsko-Tureckiego Zagłębia Węglowego.\n\n\nŹródło: Studium uwarunkowań i kierunków zagospodarowania przestrzennego. Ślesin 2003, 2005.', 'Przekształcenia antropologiczne', '', 'trash', 'closed', 'closed', '', 'przeksztalcenia-antropologiczne__trashed', '', '', '2017-10-24 19:11:23', '2017-10-24 19:11:23', '', 253, 'http://gminaslesin.futurehost.pl/?page_id=314', 0, 'page', '', 0),
 (318, 1, '2017-08-03 19:11:08', '2017-08-03 21:11:08', '', 'Licheń', '', 'trash', 'closed', 'closed', '', 'lichen__trashed', '', '', '2017-10-24 19:11:16', '2017-10-24 19:11:16', '', 0, 'http://gminaslesin.futurehost.pl/?page_id=318', 0, 'page', '', 0),
 (320, 1, '2017-08-03 19:16:29', '2017-08-03 21:16:29', '[caption id="attachment_189" align="alignleft" width="278"]<img class="wp-image-189" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/IMG_1763.jpg" alt="" width="278" height="209" /> Licheńską bazylikę odwiedza rocznie prawie milion osób.[/caption]\n\n<span style="color: blue;"><b>O bazylice licheńskiej</b></span>\n\nBazylika Matki Boskiej Bolesnej Królowej Polski w Licheniu to największy kościół w Polsce. W 2004 roku, po dziesięciu latach prac, oddano do użytku monumentalną pięcionawową bazylikę z centralną kopułą, wg projektu Barbary Bieleckiej z Gdyni. Jest to obecnie największa świątynia w Polsce, ósma w Europie i dwunasta na świecie – długość 139 m, szerokość 77 m (szerokość elewacji frontowej – 162 m), wysokość części centralnej 64,8 m (wysokość krzyża wieży – 141,5 m). Kubatura budowli wynosi ponad 300 tys. m³, powierzchnia 23 tys. m². Światło wpada do wnętrza przez tyle okien, ile jest dni w roku – 365, a wejść do środka można przez tyle drzwi, ile rok ma tygodni – 52. Do kościoła prowadzą 33 stopnie nawiązujące do lat życia Jezusa Chrystusa na ziemi. Na placu przed bazyliką może zgromadzić się ok. 250 tys. wiernych.\n\nŚwiątynia zbudowana jest na planie krzyża. Składa się z części głównej, dzwonnicy, wieży oraz trzech okazałych portyków. Nad portykiem głównym góruje Królowa Archaniołów z Dzieciątkiem, której towarzyszy sześć postaci anielskich. Portyk wschodni poświęcony jest czterem Ewangelistom. Portyk zachodni zdobi okazała Pietà.\n\nZgodnie z zamysłem architektonicznym bazylika przypomina falujący złoty łan zboża. Przejawia się to w dekoracji roślinnej placu przed świątynią oraz w architekturze samej świątyni. Zauważalne jest to m.in. w oknach wypełnionych szkłem o odcieniu złotawo-bursztynowym, ze ślusarką anodowanego aluminium w formie kłosów oraz kolumnach w portykach i we wnętrzu świątyni.\n\nInicjatorem budowy był ks. Eugeniusz Makulski, a generalnym wykonawcą robót budowlanych firma Budimex S.A. Głównymi konstruktorami byli Ryszard Wojdak i Marek Kin. Powstanie świątyni zostało sfinansowane z datków pielgrzymów.\n\nKonsekrowanie bazyliki miało miejsce 12 czerwca 2004, jako Wotum Kościoła Katolickiego na Wielki Jubileusz Narodzenia Chrystusa. Pierwszym kustoszem Sanktuarium i proboszczem tamtejszej parafii został ks. Eugeniusz Makulski MIC. Obecnie posługę kustosza pełni ks. Wiktor Gumienny MIC, zaś proboszczem jest ks. Stanisław Kosiorowski MIC.\n\nArchitektura kościoła wywołuje kontrowersje, zwłaszcza w środowiskach architektów. Przez wielu ludzi budynek jest uważany za przykład kiczu i tandety, wielu innych wskazuje jednak na klasyczność i wysoką estetykę jej architektury. Na szczycie 141 metrowej wieży znajdują się dwa tarasy widokowe – górny na wysokości 130 m i dolny na wysokości 120 m, z których rozciąga się widok przy dobrej pogodzie na odległość nawet do 30 km od Lichenia.\n\nObok kościoła wznosi się 25-metrowej wysokości kamienna góra (tzw. Golgota), na której szczycie widoczny jest krzyż oraz postacie Matki Bożej i św. Jana. Zbudowano ją w okresie 1976 - 1985, m.in. z wielkiej ilości głazów narzutowych. Na Golgocie rozmieszczono stacje drogi krzyżowej oraz szereg sztucznych grot, w których urządzono kaplice.\n<span style="color: blue;"><b>Organy</b></span>\n<img class="size-full wp-image-321 alignright" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/organy.jpg" alt="" width="200" height="267" />\nW sanktuarium znajduje się największy w kraju zespół organów. Instrumenty mają łącznie 157 głosów i ok. 20 tys. piszczałek. Zespół instrumentów jest pod względem wielkości trzeci w Europie i trzynasty na świecie. Składa się z pięciu części rozmieszczonych w nawach głównej i bocznych. Wyposażony jest w dwa stoły gry o mechanicznej trakturze oraz stół główny elektronicznie połączony z wszystkimi częściami. Organy zostały poświęcone i oficjalnie oddane do użytku na początku lipca 2007 roku. Organy uzyskały pozytywną ocenę komisji, złożonej z organistów, dyrygenta, organmistrza i księży-muzykologów z Polski, Niemiec i Włoch. Komisja przyznała, że pomimo dużej kubatury świątyni i kilkunastosekundowego pogłosu, instrument brzmi bardzo czytelnie. Projektantem architektury i wykonawcą organów jest Dariusz Zych z Wołomina. Współprojektantem instrumentu jest prof. Andrzej Chorosiński z Warszawskiej Akademii Muzycznej. Główna część organów, znajdująca się nad wejściem do bazyliki, waży 50 ton, a składa się na nią ok. 7 tys. piszczałek. Największa z nich mierzy 10 metrów. Piszczałki licheńskich organów wykonano w Polsce, Portugalii i Holandii.\n<span style="color: blue;"><b>Dzwony</b></span>\n* Dzwon Maryja Bogurodzica\nW dzwonnicy (mierzącej 68 m) umieszczono dzwon Maryja Bogurodzica ważący prawie 15 ton. Jest to największy dzwon w Polsce i trzeci pod względem wielkości wśród działających dzwonów Europy. Odlany został w ludwisarni Enriko Campanniego pod Mediolanem. Ma ton uderzeniowy c°, średnicę 3,12 m, wysokość 4,40 m. Wykonany został ze spiżu, a jego 400-kilogramowe serce każdego dnia oznajmia zbliżające się południe.\n\n* Dzwon Józef\nWażący 11,6 ton dzwon "Józef" o tonie e° (serce 270 kg), jest największym wykonanym dotąd w Polsce, w ludwisarni Janusza Felczyńskiego w Przemyślu i zarazem drugim co do wielkości dzwonem w Polsce.\n\n* Dzwon Piotr\nWaży 5,6 ton. Został wykonany w ludwisarni Felczyńskich w Przemyślu.\n\n* Dzwon Paweł\nWaży 2,5 ton. Podobnie jak dzwony Józef i Piotr został wykonany w ludwisarni Felczyńskich w Przemyślu.\n<span style="color: blue;"><b>Trzy kaplice</b></span>\nW dolnej części świątyni znajdują się kaplice:\n\n* Kaplica św. Trójcy\nNajstarsza z kaplic i zarazem pierwsze w całym kościele miejsce, w którym odbywały się nabożeństwa. Została oddana do użytku w czerwcu 1996 r.\n\n* Kaplica bł. 108 Męczenników\nDuża kaplica z obrazem Pana Jezusa wśród bł. 108 Męczenników w głównym ołtarzu, który był zawieszony w centralnym miejscu podczas beatyfikacji ofiar II wojny światowej 13 czerwca 1999 r. w Warszawie. Została uroczyście poświęcona 9 czerwca 2001 r. przez biskupa włocławskiego Bronisława Dembowskiego.\n\n* Kaplica Piety\nWe wnętrzu centralne miejsce zajmuje rzeźba bolejącej Matki, trzymającą na kolanach swego syna Jezusa Chrystusa.\n\nŹródło: wikipedia.pl - Wolna Encyklopedia', 'Bazylika', '', 'trash', 'closed', 'closed', '', 'bazylika__trashed', '', '', '2017-10-24 19:11:16', '2017-10-24 19:11:16', '', 318, 'http://gminaslesin.futurehost.pl/?page_id=320', 0, 'page', '', 0),
 (323, 1, '2017-08-03 19:19:32', '2017-08-03 21:19:32', '<span style="color: maroon;"><b>Golgota</b></span>\n\n[caption id="attachment_324" align="alignleft" width="250"]<img class="size-full wp-image-324" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/golgota.jpg" alt="" width="250" height="171" /> Golgota[/caption]\n\nW starej części sanktuarium parędziesiąt metrów od kościoła św. Doroty wznosi się, wysoka na 25 m, kamienna góra. Golgota jest wzniesieniem zbudowanym z betonu i kamieni mająca formę labiryntu korytarzy, grot, kapliczek, figur i płaskorzeźb prowadząca na szczyt, gdzie znajduje się krzyż oraz postaci Matki Bożej i św. Jana.\nWejście na Golgotę ma symbolizować mękę Jezusa.\nGóra powstała jako dzieło pokuty i przebłagania. Jej autorem jest ks. Eugeniusz Makulski. Jak sam opowiada: „Golgota jest wynagrodzeniem Panu Jezusowi za świętokradztwo dokonane przez Bertę Bauer i za świętokradztwo dokonane polskimi rękoma w czasach, kiedy wyrzucano krzyże ze szkół, urzędów wojska, a nawet szpitali”. Budowa rozpoczęła się w 1976 r. Duchowny musiał pokonać wiele trudności. Miał problemy ze zdobyciem materiałów budowlanych, do tego doszły jeszcze interwencje władz, które nie chciały zalegalizować budowy.\nA jednak udało się. Kopalnia węgla brunatnego podarowała ogromne głazy. Całość uzupełniają małe górskie kamienie, bryły kolorowego szkła hutniczego oraz kamyczki z Ziemi Świętej. Ale Golgota to nie tylko kamienie. Masywną bryłę okalają krzewy, pnącza. Co kawałek umieszczono stacje Drogi Krzyżowej i rzeźby nawiązujące do treści biblijnych. Golgota to ludowe przedstawienie drogi krzyżowej Chrystusa. Mijając groty Ogrójca, Zdrady, Sądu, Nawrócenia Marii Magdaleny, Grotę Zaparcia się Piotra, nawiązujemy do Męki Chrystusa opisanej w Ewangelii. Schodząc z góry wchodzimy do Groty Kryształowej, gdzie jest grób Pana Jezusa, następnie Grota Wniebowzięcia Matki Bożej, a dalej scena Zmartwychwstania. Są też "schody pokutne", które trzeba przebyć na kolanach.\nKamienna góra to nie wyzwanie dla miłośników górskich wspinaczek czy krytyków sztuki. Nie należy oceniać jej pod względem artystycznej spójności. Powstała po to, by przekazać prawdę o grzechu, odkupieniu, o zdradzie i miłości.\n\n<span style="color: maroon;"><b>Źródełko</b></span>\nWarto udać się do kaplicy Cudownego Źródełka. Pielgrzymi darzą to miejsce wielkim pietyzmem. Wychodząc główną bramą, kierując się w stronę jeziora dojdziemy do kaplic znajdujących się blisko siebie. W jednej jest studnia z odkrytą przez ks. Makulskiego wodę, przy drugiej są krany do nabierania wody oraz mały betonowy basenik do umycia nóg. Woda z Cudownego Źródełka jest wymownym symbolicznym darem. Już w starym Testamencie uzdrowienia fizyczne dokonywały się za sprawą wody np. w sadzawce Owczej w Jerozolimie.\n\n<span style="color: maroon;"><b>Kaplica św. Krzyża</b></span>\nKaplica położona jest w dolnej części kościoła Matki Boskiej Częstochowskiej. Można do niej wejść od strony Golgoty. W ołtarzu znajduje się krucyfiks, z którego losami związana jest niezwykła historia.\nPodczas II wojny światowej w parafialnym kościele św. Doroty hitlerowcy urządzili szkołę dla chłopców z Hitlerjugend. Młodych Niemców zaprawiano -\nw okrucieństwie. Ci, którzy pamiętają tamte czasy mówią, że szczególnie celowała w tym Berta Bauer – wychowawczyni chłopców. Kiedy w lipcu 1944 roku chłopcy zaczęli się skarżyć, że w kościele ,,coś ich straszy’’ wymierzyła z pistoletu i strzeliła do krucyfiksu. „Gdyby Bóg istniał, powinien natychmiast mnie ukarać” – powiedziała. Kilka godzin później, kiedy jechała na stację kolejową do Konina, przelatujący samolot - prawdopodobnie niemiecki, ostrzelał jej wóz. Berta Bauer zginęła na miejscu.\nWiele lat po wojnie znieważony krzyż, z wyraźnymi śladami po kulach, zawisł w ołtarzu Kaplicy św. Krzyża. Krucyfiks cieszy się ogromną czcią wiernych.\nW ołtarzach bocznych znajdują się dwa, zasługujące na szczególną uwagę, obrazy pędzla Olgi Bajkowskiej: Pieta i Powstanie Warszawskie.\n\nŹródło: <a href="www.lichen.pl" target="_blank" rel="noopener">Sanktuarium Maryjne w Licheniu</a>', 'Obiekty', '', 'trash', 'closed', 'closed', '', 'obiekty__trashed', '', '', '2017-10-24 19:11:45', '2017-10-24 19:11:45', '', 318, 'http://gminaslesin.futurehost.pl/?page_id=323', 0, 'page', '', 0),
 (326, 1, '2017-08-03 19:21:59', '2017-08-03 21:21:59', 'Licheń położony nad jeziorem Licheńskim był zamieszkany już w epoce kamienia łupanego z której to pochodzą narzędzia bytowania człowieka. Przez te obszary w czasach rzymskich wiódł <b>szlak bursztynowy</b>. Według legendy na wzgórzu, tuż nad jeziorem, znajdowała się wówczas pogańska świątynia, w której czczono słowiańskie bóstwo zwane <b>Lichem</b> &#8211; od którego z kolei wywodzić się miała nazwa miejscowości. Od co najmniej 1458 roku Licheń miał prawa miejskie, jednak brak rozwoju oraz zniszczenia z czasów potopu szwedzkiego spowodowały utratę tych praw w 1655. Od połowy XIX wieku wieś stała się ośrodkiem pielgrzymkowym o znaczeniu ogólnopolskim.<br>\nObecnie jest to jedno z większych sanktuariów maryjnych w Polsce, które rocznie odwiedza około 1,5 mln pielgrzymów i turystów. Prowadzone przez księży marianów przybyłych do tutejszej parafii w 1949 roku. To miejsce kultu religijnego <b>Matki Boskiej Bolesnej</b>.\n\n<br><span style=\'color:navy blue;\'><b>Historia sanktuarium</b></span><br>\nNa rynku w Licheniu znajduje się <b>kapliczka z granitowym krzyżem</b>, z którym wiąże się pierwsza historyczna wzmianka o tej miejscowości. W 1151 roku Piotr Dunin w połowie drogi między Kaliszem a Kruszwicą, znacząc w ten sposób starożytny szlak, postawił ten właśnie krzyż. Według legendy, został on wykuty z jednego z głazów ze ściany rozebranej świątyni pogańskiej lub z posągu pogańskiego bóstwa.\n<img src=\'images/articles/sanktuarium_klosowski.jpg\' style=\'margin:5px;\' align=\'right\'>\nHistoria sanktuarium sięga 1813 roku, kiedy pod Lipskiem miała miejsce bitwa narodów. W bitwie tej poważne rany odniósł <b>Tomasz Kłossowski</b>, kowal z okolic Lichenia, walczący po stronie wojsk napoleońskich. Jak podaje tradycja, konający żołnierz modlił się o śmierć w rodzinnych stronach. Wtedy ukazała mu się Matka Boska z Orłem Białym i w zamian za obietnicę szczęśliwego powrotu do domu poleciła, by poszukał jej wizerunku i zaniósł w rodzinne strony. Po 23 latach uratowany żołnierz znalazł na przydrożnym drzewie stary obraz, najbardziej podobny do zapamiętanego oblicza z wizji. Wziął go ze sobą i umieścił w kapliczce na sośnie w <b>lesie grąblińskim</b>, nieopodal Lichenia. Namalowany przez nieznanego malarza obraz na modrzewiowej desce przedstawia Najświętszą Maryję Pannę spoglądającą na rozpostartego na jej piersiach orła białego w koronie.\n\nPo śmierci Tomasza obrazem zaopiekował się miejscowy pasterz &#8211; Mikołaj Sikatka, mający kilkakrotnie wizję Matki Boskiej. Przekazała mu ona różne wskazówki, w tym zalecenie przeniesienia obrazu z lasu do kościoła. Władze kościelne po zbadaniu tych wydarzeń poleciły przenieść obraz do kościoła w Licheniu, co nastąpiło uroczyście 29 września 1852 roku.\n\nW 1949 roku parafię licheńską objęło <b>Zgromadzenie Księży Marianów Niepokalanego Poczęcia Najświętszej Maryi Panny</b> (łac. Congregatio Clericorum Regularium Marianorum sub titulo Immaculatae Conceptionis Beatissimae Virginis Mariae, skr. MIC), zakon katolicki założony w 1673 roku przez Stanisława Papczyńskiego.\n\n<u>15 sierpnia 1967 roku</u> Kardynał Prymas Polski &#8211; Stefan Wyszyński, w święto Wniebowzięcia Matki Bożej, przy udziale ordynariusza diecezji włocławskiej biskupa Antoniego Pawłowskiego, wielu innych biskupów, kilkuset księży, zakonników i zakonnic oraz 150 tys. wiernych, dokonał <b>aktu koronacji obrazu Matki Bożej Licheńskiej</b>. Korona została przysłana przez papieża Pawła VI, który nadał obrazowi tytuł: Maryja &#8211; Bolesna Królowa Polski. Obecnie obraz znajduje się w głównym ołtarzu nowej Bazyliki.\n\nOprócz kościoła znajdują się w Licheniu także inne obiekty cenne dla pielgrzymów. W lesie grąblińskim została zbudowana <b>droga krzyżowa</b> oraz <b>dwie kapliczki</b>: duża i mała. W małej jest umieszczony kamień przyniesiony z głębi lasu grąblińskiego, mający według wierzeń przedstawiać wypalone stopy Matki Bożej.\n\nW centralnej części sanktuarium, znajduje się <b>kościół pw. św. Doroty</b>. Pierwotny, parafialny drewniany kościół z 1415 zastąpiono murowanym zbudowanym w okresie 1844 - 1855. Budowa nowego kościoła wiązała się głównie z decyzją o przekazaniu do Lichenia słynnego już wówczas obrazu Matki Bożej powstałego w drugiej połowie XVIII wieku jako kopia szesnastowiecznego obrazu ołtarzowego z kościoła w Rokitnie. Obraz ten był w kościele aż do 2006, gdy przeniesiono go do bazyliki. Kościół został gruntownie przebudowany w 1977, gdy wymieniono prawie całe wyposażenie wnetrza oraz strop i dach świątyni.<br>\nŹródło: <a href=\'www.wikipedia.pl\' target=\'_blank\'>Wolna Encyklopedia</a>  ', 'Historia Lichenia', '', 'trash', 'closed', 'closed', '', 'historia-lichenia__trashed', '', '', '2017-10-24 19:11:29', '2017-10-24 19:11:29', '', 318, 'http://gminaslesin.futurehost.pl/?page_id=326', 0, 'page', '', 0),
 (328, 1, '2017-08-03 19:24:22', '2017-08-03 21:24:22', '<strong><a href="http://www.lichen.pl/pl/304/informacje_dla_pielgrzymow">Informacje dla pielgrzymów na stronie internetowej Sanktuarium Maryjnego w Licheniu</a></strong>', 'Informacje dla pilegrzymów', '', 'trash', 'closed', 'closed', '', 'informacje-dla-pilegrzymow__trashed', '', '', '2017-10-24 19:11:29', '2017-10-24 19:11:29', '', 318, 'http://gminaslesin.futurehost.pl/?page_id=328', 0, 'page', '', 0),
 (330, 1, '2017-08-03 19:27:51', '2017-08-03 21:27:51', '', 'Turystyka', '', 'trash', 'closed', 'closed', '', 'turystyka__trashed', '', '', '2017-10-24 19:11:29', '2017-10-24 19:11:29', '', 0, 'http://gminaslesin.futurehost.pl/?page_id=330', 0, 'page', '', 0),
 (332, 1, '2017-08-03 19:35:59', '2017-08-03 21:35:59', '<a href="http://lotmarina.pl/media_file/file/5582_pl_slesin_tu_wypoczniesz.pdf" target="_blank" rel="noopener"><b>Zobacz folder promujący bazę noclegową Miasta i Gminy Ślesin.<b></b></b></a>\n\n<img class="size-full wp-image-335 alignright" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/nocleg.jpg" alt="" width="89" height="88" /><span style="color: navy;"><u><b>Ślesin</b></u></span>\n\n<b>1. Ślesin - Hotel i Restauracja Marina</b>\nul. Napoleona 15 B\n62-561 Ślesin\n<a href="http://www.termy-slesinskie.com.pl" target="_blank" rel="noopener">www.termy-slesinskie.com.pl</a>\nrecepcja@termy-slesinskie.com.pl\ntel. 63 270 40 48, kom: 782 486 332\n\n<b>2. Ośrodek Szkoleniowo – Wypoczynkowy Gwarek</b>\nul. Leśna\n62-561 Ślesin\ntel. (063) 2704132\n<a href="http://www.gwarek.kwbkonin.pl" target="_blank" rel="noopener">www: www.gwarek.kwbkonin.pl</a>\n\n<b>3. Ośrodek Szkoleniowo – Wypoczynkowy Hotel Energetyk</b>\n<a href="http://www.hotel-energetyk.pl" target="_blank" rel="noopener">www.hotel-energetyk.pl</a>\nul. Leśna tel. 63 2704810\ne-mail: hotel@energetyk-slesin.ta.pl\n\n<b>4. Ośrodek Szkoleniowo – Wypoczynkowy</b>\nLeśna Polana - <a href="http://www.lesna-polana.com.pl" target="_blank" rel="noopener">www.lesna-polana.com.pl</a>\nTokary tel. 63 2704127\n\n<b>5. Restauracja „U Stacha”</b>\nul. Napoleona 15 tel. 63 2704311tel.\n\n<b>6. Ośrodek Wczasowy "Justyna"</b>\n<a href="http://www.osrodekjustyna.republika.pl" target="_blank" rel="noopener">www.osrodekjustyna.republika.pl</a>\ntel. 62 760-3000 603-944-153\n\n<b>7. Ośrodek Rekreacyjno-Wypoczynkowy "Przystań Gosławice" </b>\n<a href="http://www.przystan.aspak.pl" target="_blank" rel="noopener">www.przystan.aspak.pl</a>\nTel./fax 063 247-14-49; 63-247-12-19\n\n<b>8. Ośrodek Wypoczynkowy KWB "Adamów" SA w Ślesinie</b>\n<a href="www.ow-slesin.kwbadamow.com.pl" target="_blank" rel="noopener">www.ow-slesin.kwbadamow.com.pl</a>\nul. Kościelna 52, 62-561 Ślesin\nTel. 063 270-42-20\n\n<b>9. Noclegi - Iwona Nurzyńska</b>\nŚlesin ul. Słoneczna 1 tel. 63 2704109\n\n<b>10. M. Bryl - KWATERY NAD JEZIOREM, WYNAJEM POKOI </b>\nŚlesin ul. Sadowa 5 tel. 63 27 04 166\n<a href="http://www.slesinbryl.pl " target="_blank" rel="noopener">www.slesinbryl.pl </a>\n\n<b>11. Domki Letniskowe U Anny</b>\n30-lecia PRL 24,\n62-561 Ślesin\ntelefon: 63 270-48-43,\ntelefon komórkowy: 609-822-400,\n\n<span style="color: navy;"><u><b>Mikorzyn</b></u></span>\n\n<b>1. Ośrodek Szkoleniowo – Wypoczynkowy Hotel Mikorzyn*** </b><a href="http://www.hutnik.konin.pl/hotel_central/" target="_blank" rel="noopener">http://www.hutnik.konin.pl/hotel_central/</a>\ntel. 63 2 704 074\n\n<b>2. Ośrodek Szkoleniowo – Wypoczynkowy Wityng – <a href="http://www.wityng.pl" target="_blank" rel="noopener">www.wityng.pl</a></b>\nTel. 63 2 706 060\n\n<span style="color: navy;"><u><b>Półwiosek Stary</b></u></span>\n\n<b>1. DELFIN Ośrodek Wczasowo Wypoczynkowy <a href="http://www.delfin1.pl" target="_blank" rel="noopener">www.delfin1.pl</a> | e-mail: marketing@delfin1.pl</b>\nPółwiosek Stary tel. +48 666 109 666\n\n<b>2. Miejsca noclegowe Ewa Donderowicz</b>\nPółwiosek Stary 18 tel. 63 2704429\n\n<span style="color: navy;"><u><b>Wąsosze</b></u></span>\n\n<b>1. Ośrodek Szkoleniowy w Wąsoszach – <a href="http://www.wasosze.szkolenie.ta.pl" target="_blank" rel="noopener">www.wasosze.szkolenie.ta.pl</a></b>\nWąsosze tel. 63 2706194\n\n<b> 2. Agroturystyka Renata Piotrowska</b>\nWąsosze 75, 62-561 Ślesin\nTel. 63 0 609 141 131\n<a href="www.wasosze-agro.prv.pl" target="_blank" rel="noopener">www.wasosze-agro.prv.pl</a> marika131@poczta.fm\n\n<b> 3. Ośrodek Wypoczynkowo-Żeglarski "Bernardynka" </b>\nWąsosze tel. 63 242-77-96\nBiuro Usług Turystycznych "AQUA TUR s.c."\nZygmunt Jóźwiak, Irena Karolak-Jóźwiak\nwww.bernardynkaport.pl aqvatur@hot.pl\nPort jachtowy - tel. 509960810 Recepcja - tel. 512259946 Biuro-Dalmacja - tel. 510154442\n\n<u><b>Licheń Stary\n</b></u>\n<b>1. Hotel Atut - Wielkopolskie Centrum Konferencyjne**** – <a href="http://hotelatut.pl/" target="_blank" rel="noopener">www.hotelatut.pl</a></b>\nul. Toruńska 27 tel. (63) 270 87 00\n\n<strong>2. Hotel Stara Gorzelnia</strong>\n62-563 Licheń Stary\nul. Klasztorna 1\ntel. 63 27 07 380\n<a href="http://www.staragorzelnia.pl/" target="_blank" rel="noopener">staragorzelnia.pl</a>\n\n<b>3. Dom Pielgrzyma Arka – <a href="http://www.lichen.home.pl/arka" target="_blank" rel="noopener">www.lichen.home.pl/arka</a></b>\nul. Klasztorna 4 tel. 63 2708162\n\n<b>4. Dom Wycieczkowy Turysta –<a href=" http://www.lichennoclegi.pl" target="_blank" rel="noopener"> www.lichennoclegi.pl</a></b>\nul. Gosławicka 4 tel. 63 2707996\n\n<b>5. Noclegi K. Lewandowska – <a href="http://www.lichen.com.pl" target="_blank" rel="noopener">www.lichen.com.pl</a></b>\nul. Toruńska 13 tel. 63 2707556\n\n<b>6. Dom Noclegowy K. i M. Ługowscy</b>\nul. Wesoła 19 tel. 63 2468167; 63 2707914\n<b>\n7. Pensjonat Margit - <a href="http://www.margit.konin.lm.pl/" target="_blank" rel="noopener">www.margit.konin.lm.pl</a></b>\nul. Wesoła 15 tel. 63 2707777\n\n<b>8. Pensjonat Przystań - <a href="http://www.starzynscy.pl/" target="_blank" rel="noopener">http://www.starzynscy.pl/</a></b>\nul. Toruńska 7 tel. 63 2707946\n\n<b>9. Dom Noclegowy ABC - Zofia i Grzegorz Staszakowie</b>\nul. Wesoła 22 62-563 Licheń Stary\ntel./fax 63 270 76 29\n<a href="http://www.abcnoclegi.pl/kontakt,lichen,noclegi" target="_blank" rel="noopener">http://www.abcnoclegi.pl/kontakt,lichen,noclegi</a>\ne-mail: info@abcnoclegi.pl\n\n<b>10. Noclegi w Licheniu - Bożena i Krzysztof Grzeszczak</b>\nul. Wesoła 7\n62-563 Licheń\ntel. (63) 246 70 95\ntel. (63) 270 76 19\ne-mail: grzeszczak@noclegi-lichen.pl\nwww: <a href="http://www.noclegi-lichen.pl/" target="_blank" rel="noopener">http://www.noclegi-lichen.pl/</a>\n\n<b>11. Nocleg - Dariusz Szczepaniak</b>\nul.Toruńska 8\n62-563 Licheń Stary\ntel. (63) 270-76-40\ntel. (63) 270-76-41\ntel. kom. 693 383-276\n<b>\n12. AGRO - Noclegi u Jaśka</b>\nKlasztorna 6\n62-563 Licheń Stary\ntelefon: 63 270-74-32, 63 270-75-33,\nTelefon komórkowy: 601-747-876,\nadres strony: <a href="http://www.lichenstary.pl " target="_blank" rel="noopener">www.lichenstary.pl </a>\ne-mail: jasiek@lichenstary.pl\n\n<b>13. ABAK Justyna i Marek Wiśniewscy</b>\n62-563 Licheń Stary, ul. Wesoła 10\ntel. 63 2707625 tel. 504 921 150\njustynawisniewska101@wp.pl\n\n<b>14. ABBA Teresa Wardęcka</b>\n62-563 Licheń Stary, ul. Konińska 25\ntel. 63 2707978\n<a href="www.lichen-noclegi.prv.pl " target="_blank" rel="noopener">www.lichen-noclegi.prv.pl </a>\n\n<b>15. Anna Jasińska</b>\n62-563 Licheń Stary, ul. Wyszyńskiego 34\ntel. 63 2707876 tel. 605 945466\n<a href="www.annajasinska.yoyo.pl " target="_blank" rel="noopener">www.annajasinska.yoyo.pl </a>\n\n<b>16. Dom Noclegowy "Aga"</b>\n62-563 Licheń Stary, ul. Graniczna 8\ntel. 63 2707507 tel. 603 350 039\n<a href="www.noclegiaga.lichen.biz" target="_blank" rel="noopener">www.noclegiaga.lichen.biz</a> <a href="noclegiaga@lichen.biz " target="_blank" rel="noopener">noclegiaga@lichen.biz</a>\n\n<b>17. Dom noclegowy "Eugenia"</b>\n62-563 Licheń Stary, ul. Konińska 45\ntel. 63 2707871 tel. 602 379935\n<a href="www.republika.pl/enawrocka" target="_blank" rel="noopener">www.republika.pl/enawrocka</a> enawrocka@op.pl\n\n<b>18. Lew, pokoje gościnne</b>\n62-563 Licheń Stary, ul. Gosławicka 19\ntel. 063 2707674\n\n<b>19. Noclegi Zygmunt Markowski</b>\n62-563 Licheń Stary, ul. Wyszyńskiego 12\ntel. 63 2707650\nmicrosoft1984@op.pl\n\n<b>20. Wolne Pokoje Błażej Nowakowski</b>\n62-563 Licheń Stary, ul. Konińska 16\ntel. 63 2707314\n\n<b>21. Dom Noclegowy Tomasz Kuznowicz</b>\n62-563 Licheń Stary, ul. Wyszyńskiego 16\ntel. 63 2707651 tel. 691 319 024\n\nW celu aktualizacji danych prosimy o kontakt: mark014@gazeta.pl', 'Noclegi', '', 'trash', 'closed', 'closed', '', 'noclegi__trashed', '', '', '2017-10-24 19:11:29', '2017-10-24 19:11:29', '', 330, 'http://gminaslesin.futurehost.pl/?page_id=332', 0, 'page', '', 0),
 (337, 1, '2017-08-03 19:46:23', '2017-08-03 21:46:23', '<img class=" alignright" src="https://images.pexels.com/photos/100582/pexels-photo-100582.jpeg?w=940&amp;h=650&amp;auto=compress&amp;cs=tinysrgb" width="255" height="170" />System znakowanych dróg rowerowych w regionie ślesińskim tworzą <b>układy pętlowe</b>:\n* <b>SZLAK CZARNY -&gt; </b>Ślesin – Leśnictwo – Ignacewo – Pogorzele – Licheń – Kępa – Wąsosze – Półwiosek Stary – Różopole – Ślesin &lt;32 km&gt;;\n<span style="color: red;">* <b>SZLAK CZERWONY -&gt;</b> Gawrony – Młynek – Przyłubie – Lisewo Kolonia – Skulsk – Buszkowo Parcele – Ościsłowo – Marianowo –Ostrowąż – Biskupie – Florentynowo – Lizawy –Mikorzyn –Dąbrowa Duża – Honoratka – Łężyn – Niedźwiady – Wygoda (Hotel Magda) – Leśnictwo – Kolebki – Ślesin &lt;63 km&gt;</span>\n<span style="color: orange;"> * <b>SZLAK ŻÓŁTY -&gt; </b>Ślesin – Półwiosek Lubstowski – Głębockie Pierwsze – Głębockie Drugie – Ignacewo – Wilcza Kłoda – Ruszkowo – Sadlno – Stefanowo – Racięcin – Talarkowo – Nowa Wieś – Przewóz – Mielnica Duża – Skulsk &lt;50 km&gt;</span>\n<span style="color: blue;">* <b>SZLAK NIEBIESKI -&gt;</b> Ślesin – Półwiosek Lubstowski – Tokary – Leśnictwo – Ignacewo – Wierzelin – Police – Lubstów – Młynek – Lubstówek – Stefanowo – Helenów Pierwszy – Stary Licheń – Wygoda – Piotrkowice – Kolebki – Ślesin &lt;40 km&gt;</span>\n<span style="color: green;"> * <b>SZLAK ZIELONY "WOKÓŁ JEZIOR" -&gt;</b> Ślesin – Głębockie Pierwsze – Witalisów – Obory – Mielno – Noć – Kalina – Broniszewo – Przewóz – Mielnica Duża – Goplana – Warzymowo – Kolonia Warzymowska – Koszewo – Gawrony – Żółwieniec – Ostrowy – Ślesin &lt;33 km&gt;</span>\n\n<a href="http://www.gmina.slesin.pl/szlaki_rowerowe/index.html" target="_blank" rel="noopener">Zobacz mapę szlaków rowerowych w regionie. </a>\n\nSystem ten jest związany z istniejącymi szlakami rowerowymi prowadzącymi <b>z Konina do Lichenia Starego oraz z Sopolna do Ignacewa</b>.\n\nGłówna ścieżka przebiega przez miejscowości:\nŚlesin, Półwiosek Lubstowski, Tokary, Leśnictwo, Ignacewo, Pogorzele, Smolniki, Pogoń Gosławicka, Bylew, Licheń Stary, Kępy, Wąsosze, Wąsoskie Holendry, Półwiosek Stary, Różopole, Ślesin.\n\nW sumie można pokonać dystans 32 km. Ścieżka w wielu miejscach stanowi utwardzoną asfaltową drogę, choć na krótkich odcinkach są to drogi polne. Nie jest trudna, bo na naszym terenie dominuje równinny, płaski teren.\n\nTrasa od Ślesina do Lichenia zajmuje 19,5 km, a droga powrotna do Ślesina inną ścieżką 12,5 km.\n\n<u>Stanowisko Nr 1</u>\n\n<b>Ślesin- pomnik Świętej Rodziny</b>\nW centrum rynku usytuowany jest pomnik Świętej Rodziny zbudowany w 1922 roku przez mieszkańców Ślesina w dowód wdzięczności za odzyskanie niepodległości. Zniszczony podczas 2 wojny światowej został odbudowany w 1991 r .\n\n<u>Stanowisko Nr 2</u>\n\n<b>Żółwieniec maszt radiowo-telewizyjny</b>\nMaszt został wybudowany w 1995 roku. Jest to najwyższy w Polsce i w Europie telewizyjny przekaźnik(wysokości 320 m).Udając się w kierunku wschodnim ( około 250m ) możemy podziwiać panoramę Jeziora Ślesińskiego.\n\n<u>Stanowisko Nr 3</u>\n\n<b>Żółwieniec Kanał Ślesiński</b>\nNa moście obserwujemy fragment kanału łączącego ciąg jezior od Warty do Gopła. Niedaleko mostu znajdują się betonowe bunkry wybudowane przed 2 wojną światową. Były one częścią umocnienia ciągnącej się wzdłuż Gopła i jezior ślesińskich polskiej obronnej rubieży. W myśl strategicznych planów miała to być ostateczna linia obrony armii „Poznań’’. Wokoło kanału obserwujemy niezbyt gęsty las mieszany. Udając się w kierunku śluzy w Koszewie mijamy w lesie niewielkie jeziorko polodowcowe „Kociołek’’.\n\n<u>Stanowisko Nr 4</u>\n\n<b>Koszewo śluza</b>\nJedna ze śluz umożliwiająca przepłynięcie przez Kanał Ślesiński. Około 200 metrów od drugiego mostu znajduje się ujście Noteci do Kanału Ślesińskiego.\n\n<u>Stanowisko Nr 5</u>\n\n<b>Ignacewo pomnik powstańców z 1863</b>\nPomnik upamiętnia walki powstańców z wojskami carskimi w 1863 r. W Ignacewie stoczono dwie bitwy. W starciu 8.V.1863 r zwyciężyli Rosjanie pokonując oddziały generała Edmunda Taczanowskiego. Miesiąc później - 9 czerwca - zwycięską bitwę z Moskalami stoczył oddział powstańczy dowodzony przez Edmunda Calliera i Wincentego Raczkowskiego. Pomnik wzniesiono w 1918 r. , a po zniszczeniu w czasie okupacji hitlerowskiej ponownie odsłonięty w 1957r.\n\n<u>Stanowisko Nr 6</u>\n\n<b>Tokary pomnik pojednania polsko - niemieckiego</b>\nUdając się do pomnika w Tokarach poruszamy się duktem leśnym ( fragment szlaku czerwonego Sompolno - Ślesin ) . Jest to zwarty kompleks leśny pełniący przede wszystkim funkcje ochronne, społeczne i produkcyjne. Po przebyciu około 5 km odbijamy na południe docierając do pomnika. Pomnik postawiono w 1998 r w lesie, miejscu upamiętniającym śmierć ludności niemieckiej na przełomie stycznia i lutego 1945.\n\n<u>Stanowisko Nr 7</u>\n\n<b>Głębocki wylot kanału zrzutowego dużego obiegu chłodniczego konińskich elektrowni</b>\nCiąg jezior włączony jest w obieg chłodniczy elektrowni. Obserwowane miejsce jest wylotem dużego obiegu. Spiętrzenie wody tworzy niewielki wodospad, który w lokalnej gwarze kminie ochweśnickiej nosi nazwę „ Posa Dylka’’ ( tzw. Wielka Woda ). Zwracając się na południe obserwujemy polodowcowe rynnowe Jezioro Ślesińskie z ciekawą linią brzegową - wysoką lewą skarpą porośniętą lasem iglastym i niski prawy brzeg.\n\n<u>Stanowisko Nr 8</u>\n\n<b>Różopole pomnik pomordowanych Polaków w 1939 r.</b>\nW 1939 w Różopolu zginęły 4 osoby niemieckiego pochodzenia. W odwecie Niemcy urządzili łapankę rozstrzeliwując wszystkich aresztowanych. W egzekucji zginęło 19 Polaków. W późniejszym czasie zwłoki ich zostały przeniesione na cmentarz w Ślesinie. Pomnik odsłonięto w 1969 r.\n\n<u>Stanowisko Nr 9</u>\n\n<b>Ślesin Brama Napoleona</b>\nZabytek nazwany również łukiem triumfalnym został wzniesiony w 1812 roku przez ślesińskich mieszczan na cześć Napoleona 1. cesarz Francuski nigdy go jednak nie oglądał. W 1972 roku łuk został zniszczony. Odbudowano go w latach 1976 - 1977.\n\nSystem dróg rowerowych w gminie tworzą układy pętlowe:\n* Ślesin – Wąsosze – Kępa – Licheń Stary – Bylew – Ignacewo – Głębockie - Półwiosek Lubstowski,\n* Półwiosek Lubstowski – Kolebki – Piotrkowice – Wygoda – Licheń Stary,\n* Ślesin – Głębockie – Nowa Ruda - Żółwieniec – Ślesin,\n* Ślesin – Sarnowa – Biskupie – Ostrowąż – Szyszyn – Teodorowo - Ślesin.', 'Szlaki rowerowe', '', 'trash', 'closed', 'closed', '', 'szlaki-rowerowe__trashed', '', '', '2017-10-24 19:11:29', '2017-10-24 19:11:29', '', 330, 'http://gminaslesin.futurehost.pl/?page_id=337', 0, 'page', '', 0),
 (341, 1, '2017-08-03 20:00:24', '2017-08-03 22:00:24', '<i><span style="color: purple;">Dla tysięcy turystów niezwykle istotna jest możliwość połączenia wakacyjnego wypoczynku z aktywnym udziałem w szerokiej propozycji sportów letnich. Wybór atrakcji w gminie Ślesin jest przebogaty: szeroka gama sportów wodnych (windsurfing, żeglarstwo, rejsy po jeziorach statkami wypoczynkowymi, pływanie na nartach wodnych, skuterach), wczasy „w siodle”, szlaki turystyki pieszej, ścieżki rowerowe, basen, siłownie, kluby fitness, korty tenisowe, korty tenisowe, centra odnowy biologicznej, sauny, solaria oraz gabinety kosmetyczne, a wszystko na światowym poziomie. Nie zapomniano także o propozycjach spędzania wolnego czasu przez dzieci, np.: w dużych placach zabaw, pola do minigolfa. Odpoczywać mogą więc całe rodziny - dzieci, biorąc udział w grach i zabawach oraz rodzice, spokojni o bezpieczeństwo swoich pociech.<i><span style="color: purple;">Dla tysięcy turystów niezwykle istotna jest możliwość połączenia wakacyjnego wypoczynku z aktywnym udziałem w szerokiej propozycji sportów letnich. Wybór atrakcji w gminie Ślesin jest przebogaty: szeroka gama sportów wodnych (windsurfing, żeglarstwo, rejsy po jeziorach statkami wypoczynkowymi, pływanie na nartach wodnych, skuterach), wczasy „w siodle”, szlaki turystyki pieszej, ścieżki rowerowe, basen, siłownie, kluby fitness, korty tenisowe, korty tenisowe, centra odnowy biologicznej, sauny, solaria oraz gabinety kosmetyczne, a wszystko na światowym poziomie. Nie zapomniano także o propozycjach spędzania wolnego czasu przez dzieci, np.: w dużych placach zabaw, pola do minigolfa. Odpoczywać mogą więc całe rodziny - dzieci, biorąc udział w grach i zabawach oraz rodzice, spokojni o bezpieczeństwo swoich pociech.Doskonale zagospodarowane są plaże, z wieloma strzeżonymi kąpieliskami. Odpoczywający na gorącym piasku plażowicze mogą skorzystać z wielu atrakcji, jak np. ogródki zabaw dla dzieci, turnieje piłki siatkowej i nożnej, zabawy i wiele innych. Wszystko przygotowane z myślą o odwiedzających turystach.</span><a href="www.slesin.pl " target="_blank" rel="noopener">slesin.pl</a></i></span></i>\n\n<i><span style="color: purple;"><i></i>\n<img class="alignleft size-full wp-image-342" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/wypocz.jpg" alt="" width="40" height="42" /><span style="color: navy;"><u><b>Ślesin</b></u></span>\n<b>1. Ślesin - Hotel i Restauracja Marina</b></span></i>\n\n<i><span style="color: purple;">ul.</span></i><i><span style="color: purple;">Napoleona 15 B, 62-561 Ślesin</span></i>\n\n<i><span style="color: purple;">tel. 63 270 40 48, kom: 782 486 332</span></i>\n\n<i><span style="color: purple;"><a href="http://www.termy-slesinskie.com.pl" target="_blank" rel="noopener">www.termy-slesinskie.com.pl</a></span></i>\n\n<i><span style="color: purple;">recepcja@termy-slesinskie.com.pl<b> </b></span></i>\n\n&nbsp;\n\n<i><span style="color: purple;"><b>2.Ośrodek Szkoleniowo-Wypoczynkowy Gwarek</b></span></i>\n\n<i><span style="color: purple;">Ośrodek Szkoleniowo-Wypoczynkowy KWB KONIN S.A</span></i>\n\n<i><span style="color: purple;">Ślesin-Tokary, 62-561 Ślesin</span></i>\n\n<i><span style="color: purple;">telefon:   0-63 270-41-32, faks: 0-63 270-41-32</span></i>\n\n<i><span style="color: purple;">www:   <a href="http://www.gwarek.kwbkonin.pl" target="_blank" rel="noopener">www.gwarek.kwbkonin.pl</a></span></i>\n\n&nbsp;\n\n<i><span style="color: purple;"> <b>3. Ośrodek Wypoczynkowy Krasnal</b></span></i>\n\n<i><span style="color: purple;">62-561 Ślesintelefon:   63 270-42-50, telefon komórkowy: 889-848-367,\n</span></i>\n\n&nbsp;\n\n<i><span style="color: purple;"><b>4. Ośrodek szkoleniowo - wypoczynkowy "Leśna Polana"</b></span></i>\n\n<i><span style="color: purple;">Ślesin - Tokary</span></i>\n\n<i><span style="color: purple;">Telefon(y): 0048 63 2704127</span></i>\n\n<i><span style="color: purple;">Fax(y): 0048 63 2704127</span></i>\n\n<i><span style="color: purple;">WWW: <a href="http://www.lesna-polana.com.pl" target="_blank" rel="noopener">www.lesna-polana.com.pl</a>\n</span></i>\n\n&nbsp;\n\n<i><span style="color: purple;"><span style="color: navy;"><u><b>Mikorzyn</b></u></span>\n<b>1.Ośrodek Szkoleniowo-Wypoczynkowy, </b></span></i>\n\n<i><span style="color: purple;"><b>Hotel Mikorzyn</b></span></i>\n\n<i><span style="color: purple;">Ośrodek Szkoleniowo-Wypoczynkowy "Huty Aluminium "Konin" SA w Mikorzynie</span></i>\n\n<i><span style="color: purple;">Mikorzyn, 62-561 Ślesin</span></i>\n\n<i><span style="color: purple;">telefon:   63 270-40-74, faks: 63 270-56-70</span></i>\n\n<i><span style="color: purple;">www:   <a href="http://www.hutnik.konin.pl" target="_blank" rel="noopener">www.hutnik.konin.pl</a></span></i>\n\n&nbsp;\n\n<i><span style="color: purple;"><b>2. Ośrodek Szkoleniowo-Wypoczynkowy Wityng</b></span></i>\n\n<i><span style="color: purple;">Mikorzyn, 62-561 Ślesin</span></i>\n\n<i><span style="color: purple;">telefon:   69 678-58-21\n</span></i>\n\n&nbsp;\n\n<i><span style="color: purple;"><span style="color: navy;"><u><b>Półwiosek Stary</b></u></span>\n<b>1. DELFIN Ośrodek Wczasowo Wypoczynkowy <a href="http://www.delfin1.pl" target="_blank" rel="noopener">www.delfin1.pl</a> </b></span></i>\n\n<i><span style="color: purple;"><b>e-mail: marketing@delfin1.pl</b>  </span></i>\n\n<i><span style="color: purple;">tel. +48 666 109 666\nPółwiosek Stary 30 B, 62-561 Ślesin\n</span></i>\n\n&nbsp;\n\n<i><span style="color: purple;"><span style="color: navy;"><u><b>Wąsosze</b></u></span>\n<b>1. Ośrodek Szkoleniowy ODN</b></span></i>\n\n<i><span style="color: purple;">Wąsosze 73, 62-561 Ślesin</span></i>\n\n<i><span style="color: purple;">telefon:   63 270-61-94, faks: 63 270-48-61</span></i>\n\n<i><span style="color: purple;">www:   <a href="http://www.odnkonin.inc.pl" target="_blank" rel="noopener">http://www.odnkonin.inc.pl</a>\n</span></i>\n\n&nbsp;\n\n<i><span style="color: purple;"><span style="color: navy;"><u><b>Konstatynówek</b></u></span>\n<b>Stajnia RETINA</b></span></i>\n\n<i><span style="color: purple;">Konstantynówek 6, </span></i>\n\n<i><span style="color: purple;">62-561 Ślesin </span></i>\n\n<i><span style="color: purple;">tel. 603-132-205</span></i>\n\n<i><span style="color: purple;">Nauka jazdy konnej, wyjazdy w teren, skoki, hipoterapia pod okiem wykwalifikowanego instruktora jeździectwa. Miła i fachowa obsługa w pięknej okolicy leśnej.</span></i>\n\n&nbsp;\n\nW celu aktualizacji danych prosimy o kontakt: mark014@gazeta.pl', 'Ośrodki wypoczynkowe', '', 'trash', 'closed', 'closed', '', 'osrodki-wypoczynkowe__trashed', '', '', '2017-10-24 19:11:29', '2017-10-24 19:11:29', '', 330, 'http://gminaslesin.futurehost.pl/?page_id=341', 0, 'page', '', 0),
 (342, 1, '2017-08-03 19:55:42', '2017-08-03 21:55:42', '', 'wypocz', '', 'inherit', 'open', 'closed', '', 'wypocz', '', '', '2017-08-03 19:55:42', '2017-08-03 21:55:42', '', 341, 'http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/wypocz.jpg', 0, 'attachment', 'image/jpeg', 0),
 (344, 1, '2017-08-03 20:05:06', '2017-08-03 22:05:06', '<img class="alignright size-full wp-image-345" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/gastron.jpg" alt="" width="50" height="50" /><span style="color: navy;"><u><b>Ślesin</b></u></span>\n\n<b>1. Restauracja „U Stacha”</b>\nŚlesin ul. Napoleona 15 tel. (63) 2704311\n<b>2. Oberża Pod Kulawą Gęsią</b>\nŚlesin ul. Napoleona\n\n<b>3. Bar "Ewa"</b>\nŚlesin ul. Napoleona tel. (63) 2704401\n\n<strong>4. Ślesin - Hotel i Restauracja Marina</strong>\nul. Napoleona 15 B\n62-561 Ślesin\n<a href="http://www.termy-slesinskie.com.pl" target="_blank" rel="noopener">www.termy-slesinskie.com.pl</a>\nrecepcja@termy-slesinskie.com.pl\ntel. 63 270 40 48, kom: 782 486 332\n\n<span style="color: navy;"><u><b>Licheń</b></u></span>\n\n<b>1. Restauracja licheńska</b>\ntel. 63 270 79 18\nLicheń Stary, Konińska 46\n\n<span style="color: navy;"><u><b>Lubomyśle</b></u></span>\n<b>1. Restauracja „Ochweśnicka”</b>\nLubomyśle 4c tel. (63) 2705801\n\n&nbsp;\n\nW celu aktualizacji danych prosimy o kontakt: mark014@gazeta.pl', 'Punkty gastronomiczne', '', 'trash', 'closed', 'closed', '', 'punkty-gastronomiczne__trashed', '', '', '2017-10-24 19:11:29', '2017-10-24 19:11:29', '', 330, 'http://gminaslesin.futurehost.pl/?page_id=344', 0, 'page', '', 0),
 (347, 1, '2017-08-03 20:08:58', '2017-08-03 22:08:58', '<img src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/agrotur.jpg" alt="" width="50" height="50" class="alignright size-full wp-image-348" /><span style=\'color:navy;\'><u><b>Ślesin</b></u></span>\n\n<b> 1.     Gospodarstwo agroturystyczne Anna Gralak</b>\n        Ślesin ul. Kościelna 32  tel. (63) 2704996,  660 873 836\n        <a href=\'http://www.wielkopolska.com.pl/index.php/action/tur/tur/1/z/2/a/9/nr/20060619144027\' target=\'_blank\'>www.wielkopolska.com.pl/index.php/action/tur/</a>\n\n<b>2.     Noclegi - Iwona Nurzyńska</b>\n        Ślesin ul. Słoneczna 1 tel. (63) 2704109\n\n<b>3.   M. Bryl - KWATERY NAD JEZIOREM, WYNAJEM POKOI </b>\n        Ślesin  ul. Sadowa 5    tel. (63) 27 04 166 \n        <a href=\'http://www.slesinbryl.pl \' target=\'_blank\'>www.slesinbryl.pl </a>\n\n<b>4.     Gospodarstwo agroturystyczne Bogdan Gralak</b>\n        Konstantynowo 17 tel. (63) 2705321; 0692695848\n        <a href=\'http://www.wielkopolska.com.pl/index.php/action/tur/tur/1/z/2/a/6/nr/20060620125820\' target=\'_blank\'>www.wielkopolska.com.pl/index.php/action/tur/</a>\n\n<span style=\'color:navy;\'><u><b>Półwiosek Stary</b></u></span>\n\n<b>1.     Gospodarstwo agroturystyczne Danuta Moczulska</b>\n        Półwiosek Stary 45A tel. (63) 2704677\n        <a href=\'http://www.wielkopolska.com.pl/index.php/action/tur/tur/1/z/2/a/6/nr/20030322212027\' target=\'_blank\'>www.wielkopolska.com.pl/index.php/action/tur/</a>\n\n<b>2.   Miejsca noclegowe Ewa Donderowicz</b>\n        Półwiosek Stary 18  \ntel. (63) 2704429\n\n<b><span style=\'color:navy;\'><b>Leśnictwo</b></span></b>\n\n<b>1.     Gospodarstwo agroturystyczne Helena Paliwoda</b>\n        Leśnictwo 12 tel. (63)2704414\n       <a href=\'http://www.wielkopolska.com.pl/index.php/action/tur/tur/1/z/2/a/6/nr/20030324210001\n\' target=\'_blank\'>www.wielkopolska.com.pl/index.php/action/tur/</a>\n\n<b>2.     Gospodarstwo agroturystyczne GOŚCINIEC</b>\n        Leśnictwo 4  tel. (63) 2705571, \ne-mail: ostrowska22@op.pl\n       <a href=\' http://www.agrogosciniec.republika.pl\' target=\'_blank\'> www.agrogosciniec.republika.pl</a>\n\n<u><span style=\'color:navy;\'><b>Wygoda</b></span></u>\n\n<b>1.     Gospodarstwo agroturystyczne Małgorzata Lepa</b>\n        Wygoda 24A tel. (63)2707571; 0601987195\n        <a href=\'http://www.wielkopolska.com.pl/index.php/action/tur/tur/1/z/2/a/6/nr/20030321132511\' target=\'_blank\'>www.wielkopolska.com.pl/index.php/action/tur/</a>\n<b>\n<u><span style=\'color:navy;\'><b>Licheń Stary</b></span></u>\n\n1.     Gospodarstwo agroturystyczne Stanisław Michalski</b>\n        Licheń Stary ul. Konińska 42  tel. (63)2707916\n        <a href=\'http://www.wielkopolska.com.pl/index.php/action/tur/tur/1/z/2/a/6/nr/20030324212139\' target=\'_blank\'>www.wielkopolska.com.pl/index.php/action/tur/</a>\n\n<u><span style=\'color:navy;\'><b>Szyszyńskie Holendry</b></span></u>\n\n<b>1.     Gospodarstwo agroturystyczne Ryszard Gajewski</b>\n        Szyszyńskie Holendry 4  tel. (63) 2704636; 607149158  \n        <a href=\'http://www.letnik.republika.pl\' target=\'_blank\'>www.letnik.republika.pl</a>\n\n<span style=\'color:navy;\'><u><b>Wąsosze</b></u></span>\n\n<b>1. Agroturystyka</b>\nWąsosze 75, 62-561 Ślesin\ntel.: 	0 609 141 131\ne-mail: 	marika131@poczta.fm\nwww: 	<a href=\'http://www.wasoszeagro.prv.pl\' target=\'_blank\'>http://www.wasoszeagro.prv.pl</a>\n\n\nW celu aktualizacji danych prosimy o kontakt: mark014@gazeta.pl', 'Agroturystyka', '', 'trash', 'closed', 'closed', '', 'gospodarstwa-agroturystyczne__trashed', '', '', '2017-10-24 19:11:29', '2017-10-24 19:11:29', '', 330, 'http://gminaslesin.futurehost.pl/?page_id=347', 4, 'page', '', 0),
 (364, 1, '2017-08-04 15:15:01', '2017-08-04 17:15:01', '<img class="alignleft" src="https://images.pexels.com/photos/51971/football-the-ball-sport-game-51971.jpeg?w=940&amp;h=650&amp;auto=compress&amp;cs=tinysrgb" width="203" height="135" /><strong>Runda VI zostanie rozegrana 6. sierpnia 2017 roku na boisku ORLIK na Osiedlu Północ w Ślesinie.</strong><!--more-->\n<p style="text-align: left;">Kolejność rozgrywanych meczy\n1 mecz 8:30 Ignacewo <strong>1 – 9</strong> Wąsosze\n2 mecz 9:40 Szyszyn <strong>9 – 3</strong> Półwiosek Stary\n3 mecz 10:50 Honoratka <strong>3 – 6</strong> Szyszyńskie Holendry\n4 mecz 12:00 Osiedle Powstańców Wielkopolskich <strong>7 – 5 </strong>Głębockie/Mikorzyn\n5 mecz 13:10 Osiedle Północ <strong>5 – 4 </strong>Piotrkowice\nGospodarzami Rundy są drużyny Osiedle Północ - Piotrkowice</p>', 'Runda szósta będzie rozegrana 6 sierpnia', '', 'trash', 'open', 'open', '', 'runda-szosta-bedzie-rozegrana-6-sierpnia__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://gminaslesin.futurehost.pl/?p=364', 0, 'post', '', 2),
 (368, 1, '2017-08-04 00:00:00', '2017-08-04 00:00:00', '[AWPCPCLASSIFIEDSUI]', 'Ogłoszenia', '', 'trash', 'closed', 'closed', '', 'awpcp__trashed', '', '', '2017-10-24 19:11:28', '2017-10-24 19:11:28', '', 0, 'http://gminaslesin.futurehost.pl/awpcp/', 0, 'page', '', 0),
 (369, 1, '2017-08-04 00:00:00', '2017-08-04 00:00:00', '[AWPCPSHOWAD]', 'Pokaż ogłoszenie', '', 'trash', 'closed', 'closed', '', 'pokaz-ogloszenie__trashed', '', '', '2017-10-24 19:11:28', '2017-10-24 19:11:28', '', 368, 'http://gminaslesin.futurehost.pl/awpcp/show-ad/', 0, 'page', '', 0),
 (370, 1, '2017-08-04 00:00:00', '2017-08-04 00:00:00', '[AWPCPREPLYTOAD]', 'Odpowiedz na ogłoszenie', '', 'trash', 'closed', 'closed', '', 'odpowiedz-na-ogloszenie__trashed', '', '', '2017-10-24 19:11:28', '2017-10-24 19:11:28', '', 368, 'http://gminaslesin.futurehost.pl/awpcp/reply-to-ad/', 0, 'page', '', 0),
 (371, 1, '2017-08-04 00:00:00', '2017-08-04 00:00:00', '[AWPCPEDITAD]', 'Edytuj ogłoszenie', '', 'trash', 'closed', 'closed', '', 'edytuj-ogloszenie__trashed', '', '', '2017-10-24 19:11:28', '2017-10-24 19:11:28', '', 368, 'http://gminaslesin.futurehost.pl/awpcp/edit-ad/', 0, 'page', '', 0),
 (372, 1, '2017-08-04 00:00:00', '2017-08-04 00:00:00', '[AWPCPPLACEAD]', 'Umieść ogłoszenie', '', 'trash', 'closed', 'closed', '', 'umiesc-ogloszenie__trashed', '', '', '2017-10-24 19:11:28', '2017-10-24 19:11:28', '', 368, 'http://gminaslesin.futurehost.pl/awpcp/place-ad/', 0, 'page', '', 0),
 (373, 1, '2017-08-04 00:00:00', '2017-08-04 00:00:00', '[AWPCP-RENEW-AD]', 'Odnów ogłoszenie', '', 'trash', 'closed', 'closed', '', 'odnow-ogloszenie__trashed', '', '', '2017-10-24 19:11:28', '2017-10-24 19:11:28', '', 368, 'http://gminaslesin.futurehost.pl/awpcp/renew-ad/', 0, 'page', '', 0),
 (374, 1, '2017-08-04 00:00:00', '2017-08-04 00:00:00', '[AWPCPBROWSEADS]', 'Zobacz ogłoszenia', '', 'trash', 'closed', 'closed', '', 'zobacz-ogloszenia__trashed', '', '', '2017-10-24 19:11:28', '2017-10-24 19:11:28', '', 368, 'http://gminaslesin.futurehost.pl/awpcp/browse-ads/', 0, 'page', '', 0),
 (375, 1, '2017-08-04 00:00:00', '2017-08-04 00:00:00', '[AWPCPSEARCHADS]', 'Poszukaj ogłoszenia', '', 'trash', 'closed', 'closed', '', 'poszukaj-ogloszenia__trashed', '', '', '2017-10-24 19:11:28', '2017-10-24 19:11:28', '', 368, 'http://gminaslesin.futurehost.pl/awpcp/search-ads/', 0, 'page', '', 0),
 (376, 1, '2017-08-04 00:00:00', '2017-08-04 00:00:00', '[AWPCPPAYMENTTHANKYOU]', 'Podziękowania za płatności', '', 'trash', 'closed', 'closed', '', 'podziekowania-za-platnosci__trashed', '', '', '2017-10-24 19:11:28', '2017-10-24 19:11:28', '', 368, 'http://gminaslesin.futurehost.pl/awpcp/payment-thank-you/', 0, 'page', '', 0),
 (377, 1, '2017-08-04 00:00:00', '2017-08-04 00:00:00', '[AWPCPCANCELPAYMENT]', 'Anulowanie płatności', '', 'trash', 'closed', 'closed', '', 'anulowanie-platnosci__trashed', '', '', '2017-10-24 19:11:28', '2017-10-24 19:11:28', '', 368, 'http://gminaslesin.futurehost.pl/awpcp/cancel-payment/', 0, 'page', '', 0),
 (401, 1, '2017-08-05 11:38:06', '2017-08-05 13:38:06', '<img src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/FestynSzyszyn2-724x1024.jpg" alt="" width="724" height="1024" class="aligncenter size-large wp-image-402" />', 'Festyn w Szyszynie', '', 'trash', 'open', 'open', '', 'festyn-w-szyszynie__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://gminaslesin.futurehost.pl/?p=401', 0, 'post', '', 0),
 (413, 1, '2017-10-23 14:39:04', '2017-10-23 14:39:04', '', 'Główna', '', 'publish', 'closed', 'closed', '', 'glowna', '', '', '2017-10-25 14:03:24', '2017-10-25 14:03:24', '', 0, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=413', 1, 'nav_menu_item', '', 0),
 (443, 1, '2017-08-07 00:36:51', '2017-08-06 22:36:51', '<img class="alignleft " src="http://www.przegladkoninski.pl/images/przegladkoninski3_03.png" width="187" height="49" /><strong>Trwa gruntowna przebudowa Urzędu Miasta i Gminy w Ślesinie przy ulicy Kleczewskiej.</strong>\n<a href="http://www.przegladkoninski.pl/PL-H5/3/4282/trwa-remont-urzedu-na-jakim-etapie-sa-prace-bylismy-i-widzielismy-film.html" target="_blank" rel="noopener">Zobacz zdjęcia i materiał TV.</a>\n\n– Remont idzie bardzo dobrze – mówi burmistrz Mariusz Zaborowski. Montowane są szyby w klatce schodowej, kładzione są płytki na korytarzach i w biurach. – Jeszcze pracy trochę zostało – dodaje burmistrz Zaborowski. – Z końcem sierpnia mija termin zakończenia prac, ale myślę, że we wrześniu pewnie jeszcze nie damy rady się przenieść. Nie umiem jeszcze określić, kiedy się to stanie.\n\n// Źródło: Marcin Szafrański - Przegląd Koniński', 'Trwa remont urzędu. Na jakim etapie są prace?', '', 'trash', 'open', 'open', '', 'trwa-remont-urzedu-na-jakim-etapie-sa-prace__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://gminaslesin.futurehost.pl/?p=443', 0, 'post', '', 0),
 (446, 1, '2017-08-06 00:40:19', '2017-08-05 22:40:19', '<img class=" alignleft" src="http://www.przegladkoninski.pl/data/catalogue/StLS01MDI3NzctRFNDMDIyNjMuSlBH.jpg" width="208" height="117" /><strong>Jedna z muzycznych gwiazd Ślesińskiego Festiwalu Piwa to DJ Wika, czyli najstarsza w Polsce DJ-ka, b<a href="http://www.przegladkoninski.pl/PL-H5/3/4295/dj-wika-przyjechala-do-slesina-gram-23-lata-to-jest-moja-pasja-a-nie-zawod.html">o tak jest nazywana. Pełna energii i dobrego humoru.</a></strong>\n<!--more-->\n\n<img class="alignright" src="http://www.przegladkoninski.pl/images/przegladkoninski3_03.png" width="260" height="68" />– To jest moja pasja, a nie zawód. Ludzie z pasją żyją dłużej, szczęśliwiej radośniej i się nie starzeją. Radzę wam – miejcie swoją pasję, to wtedy będziecie długo młodzi, szczęśliwi i zdrowi – mówiła ze sceny przy ślesińskiej plaży DJ Wika, czyli Wirginia Szmyt, nazywana najstarszą w Polsce DJ-ką. – Mam 79 lat, a gram 23 lata – zdradziła. <a href="http://www.przegladkoninski.pl/PL-H5/3/4356/jak-to-sie-stalo-ze-emerytka-zostala-dj-ka-ja-sie-zbuntowalam-film.html" target="_blank">Wywiad wideo.</a>\n\nNa scenie pojawiła się z DJ-em Krisem, który gra prawie 30 lat. – Promujemy nasz wiek, radość i szacunek do starości. Jak to mówią, starość się Panu Bogu nie udała. Na moim przykładzie widać, że się udała – dodała DJ Wika.', 'DJ Wika przyjechała do Ślesina', '', 'trash', 'open', 'open', '', 'dj-wika-przyjechala-do-slesina__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://gminaslesin.futurehost.pl/?p=446', 0, 'post', '', 0),
 (451, 1, '2017-08-07 00:50:18', '2017-08-06 22:50:18', '<img class="alignnone size-large" src="https://scontent-bru2-1.xx.fbcdn.net/v/t31.0-8/p720x720/20544008_1733370756965018_7779745501322154198_o.jpg?oh=2d098d15fb91c876949d8dd51c6c8065&amp;oe=59F94444" width="720" height="1019" />', 'Festyn w Biskupiu', '', 'trash', 'open', 'open', '', 'festyn-w-biskupiu__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://gminaslesin.futurehost.pl/?p=451', 0, 'post', '', 0),
 (463, 1, '2017-08-07 01:12:38', '2017-08-06 23:12:38', '[caption id="" align="alignleft" width="204"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1733709323597828/1733708583597902/?type=3&amp;theater" target="_blank" rel="noopener"><img src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/20604298_1733708583597902_6239995203869643904_n.jpg?oh=8a4468e95c73984b56dcca4ae22c288f&amp;oe=59EB49C5" alt="" width="204" height="136" /></a> Zdjęcia: Henryk Zajfert[/caption]\n\n<strong>W ślesińskim Parku już po raz 20 odbył się Wakacyjny piknik Klubów Seniora orgaznizowany nieprzerwanie od 20 lat przez Miejsko-Gminny Ośrodek Kultury w Ślesinie<span class="text_exposed_show">. Przed 20 laty na Ślesińskiej plaży wakacyjne wojaże seniorów zapoczątkował Klub Seniora ze Ślesina, Tuliszkowa i Władysławowa.</span></strong>\n\n<!--more-->\n\n<span class="text_exposed_show"> Seniorzy corocznie spędzają pierwszy czwartek sierpnia w towarzystwie seniorów z zaprzyjaźnionych Klubów. Z roku na rok zwiększa się liczba uczestników pikniku w tym roku w ślesińskim parku bawiło się ponad 700 osób z 24 Klubów. W tegorocznej edycji pikniku w spotkaniu uczestniczyły kluby z: Koła, Wilczyna, Przykony, Starego Miasta, Skulska, Malanowa, Kościelca, Kazimierza Biskupiego, Władzimirowa, Wierzbinka, Sompolna, Cienina Kościelnego, Słodkowa, Orchowa, Ślesina, Władysławowa, Jezior Wielkich, Krzymowa, Tuliszkowa, Goliny, Dobrej , Lichenia i Szyszyńskich Holendrów. </span>\n\n<span class="text_exposed_show">Organizatorzy przygotowali wiele atrakcji najważniejsza była zabawa taneczna\nz zespołem Aplaus, piknikowiczów odwiedzili piraci z Karaibów, można było popłynąć stateczkiem po jeziorach ślesińskich, oraz posilić się przygotowanym grillem. Wszyscy zapowiedzieli, że będą za rok.</span>\n\nŹródło: https://www.facebook.com/mgokslesin', 'Za nami XX piknik Klubów Seniora', '', 'trash', 'open', 'open', '', 'za-nami-xx-piknik-klubow-seniora__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://gminaslesin.futurehost.pl/?p=463', 0, 'post', '', 0),
 (466, 1, '2017-08-07 09:43:53', '2017-08-07 07:43:53', '<a href="https://www.lm.pl/aktualnosci/informacja/110929/w_przydomowym_warsztacie_odtwarza_latajacego_orlika"><img class=" alignleft" src="https://m.lm.pl/media/foto/240915_logo_standard.png" width="165" height="66" /></a><strong>Jerzy Gruchalski ze Ślesina odbudowuje model przedwojennego Orlika olimpijskiego. Ma to być jego wkład w obchody 100-lecia lotnictwa polskiego.</strong> <a href="https://www.lm.pl/aktualnosci/informacja/110929/w_przydomowym_warsztacie_odtwarza_latajacego_orlika" target="_blank" rel="noopener">Zobacz zdjęcia i materiał TV.</a>\n<!--more-->\n\nOdtwarzanie modeli samolotów to hobby mieszkańca Ślesina. Zrekonstruował już przedwojenny motoszybowiec „Bąk”, którego oryginalny plan odkupił w latach 70-tych od żony projektanta Antoniego Kocjana. Pracuje samodzielnie. Budowa statków pływających i latających to jego hobby. Buduje na zapleczu swojego domu w Ślesinie, gdzie ma warsztat. Obecnie skupia się na odwzorowaniu latającego „Orlika”. Chce zdążyć do 28 sierpnia 2018 r. na obchody 100-lecia lotnictwa polskiego.\n\nOrlik olimpijski, oparty na zachowanym z 1938 r. opracowaniu Antoniego Kocjana, mający uczestniczyć w 1940 r. w igrzyskach olimpijskich w Helsinkach, które nie odbyły się z powodu wojny. Ma rozpiętość skrzydeł 15 m, długość to 6.45 m, a ciężar własny wynosi 168 kg. W całości wykonany z drewna. Jedyny zachowany egzemplarz znajduje się obecnie w muzeum lotnictwa w USA i jest to jeden z kilku przedwojennych modeli wyprodukowanych w Polsce.\n\n// Źródło: Anna Pilarska - LM.pl', 'W przydomowym warsztacie odtwarza latającego Orlika', '', 'trash', 'open', 'open', '', 'w-przydomowym-warsztacie-odtwarza-latajacego-orlika__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://gminaslesin.futurehost.pl/?p=466', 0, 'post', '', 0),
 (468, 1, '2017-07-07 09:53:28', '2017-07-07 07:53:28', '<img class=" alignleft" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/205846_200154286715257_1182245_n.jpg?oh=58a43af40bf9d376b05310f53d1e08b0&amp;oe=59EF53D8" width="134" height="170" /><strong>Takiej frekwencji na pierwszym treningu mógłby LKS Ślesin pozazdrościć niejeden klub z IV ligi. W odbudowującej się drużynie seniorów chęć gry zgłasza około 30 zawodników. <a href="https://www.lm.pl/aktualnosci/informacja/110539/lks_slesin_wciaz_atrakcyjny_23_pilkarzy_na_pierwszym_treningu" target="_blank" rel="noopener">Zobacz galerię zdjęć.</a></strong><!--more-->\n\nW poniedziałek ślesiński klub zorganizował trening otwarty dla wszystkich. Na pierwsze zajęcia stawiło się aż 23 zawodników. Byli piłkarze, którzy już kiedyś grali w LKS Ślesin – Michał Kwiatkowski, Bartosz Nowak, czy Krystian Robak (choć ten ostatni akurat deklaruje, że na treningu był tylko gościnnie). Byli również młodzi zawodnicy i piłkarze związani z Dynamo Quatro Konin występującym w konińskiej Playarenie. Trening prowadził Maciej Bieniaszczyk, który ma objąć posadę pierwszego szkoleniowca LKS Ślesin.\n\n- <em>To pozytywna liczba, a jeszcze około dziesięciu zawodników wyrażających chęć gry nie mogło być dzisiaj na treningu</em> – oceniał trener powstającej drużyny. - <em>Była to mała niewiadoma. Jest dużo chętnych, młodych zawodników, kilku doświadczonych. To dopiero początek, więc spodziewam się rotacji.</em>\n\nPoniedziałkowe zajęcia od samego początku polegały na ćwiczeniach z piłkami. Zakończone natomiast zostały wewnętrzną gierką, w której trener mógł obejrzeć zawodników w trakcie gry.\n\nSeniorzy LKS Ślesin przygotowują się do startu w A-klasie. Po wycofaniu zespołu zimą z rozgrywek IV ligi drużyna została automatycznie relegowana o dwie klasy rozgrywkowe. Czy LKS Ślesin będzie walczył od razu o mistrzostwo? - <em>Głównym celem jest odbudowanie drużyny i wystartowanie w lidze. Jest za wcześnie, by mówić o celach, na pewno będziemy się starali wypaść jak najlepiej</em> – deklaruje trener Bieniaszczyk.\n\nDla szkoleniowca będzie to debiut w roli trenera pierwszego zespołu. Do tej pory prowadził wyłącznie drużyny młodzieżowe. Sukcesów jednak nie brakowało – z juniorami młodszymi LKS Ślesin Maciej Bieniaszczyk wywalczył w tym roku wicemistrzostwo ligi okręgowej, a z juniorami starszymi Polonusa Kazimierz Biskupi – trzecie miejsce.\n\n- <em>Mam jedenastoletnie doświadczenie w trenowaniu młodzieży, od czterolatków do osiemnastolatków. Trenowałem już trzy drużyny juniorów starszych, to grupa zbliżona do seniorów. Jestem przygotowany merytorycznie. Lubię wyzwania, jestem człowiekiem ambitnym </em>– opisuje sam siebie nowy trener LKS Ślesin.\n\nTeraz przed szkoleniowcem ślesińskiej drużyny niemal dwa miesiące na zbudowanie zespołu i wystartowanie w rozgrywkach A-klasy.\n\n// Źródło: <strong>Bartosz Skonieczny - LM.pl</strong>', 'LKS Ślesin wciąż atrakcyjny', '', 'trash', 'open', 'open', '', 'lks-slesin-wciaz-atrakcyjny__trashed', '', '', '2017-10-23 15:50:17', '2017-10-23 15:50:17', '', 0, 'http://gminaslesin.futurehost.pl/?p=468', 0, 'post', '', 0),
 (474, 1, '2017-08-07 12:34:32', '2017-08-07 10:34:32', '<img class="aligncenter size-large" src="http://www.lichen.pl/userfiles/images/uroczystosci%2050%20rocznica.jpg" width="853" height="1200" />\n\n<strong>Plan głównych uroczystości 50. rocznicy koronacji Cudonwgo Obrazu Matki Bożej Licheńskiej (od 11 do 15 sierpnia).</strong>', '50. rocznica koronacji Cudownego Obrazu MBL', '', 'trash', 'open', 'open', '', '50-rocznica-koronacji-cudownego-obrazu-mbl__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://gminaslesin.futurehost.pl/?p=474', 0, 'post', '', 0),
 (480, 1, '2017-08-01 15:09:12', '2017-08-01 13:09:12', '<strong><a href="http://ttr24.pl/2017/07/25/smiertelny-wypadek-w-mikorzynie/"><img class="alignleft" src="http://ttr24.pl/wp-content/uploads/2017/07/Wypadek-Mikorzyn-3.jpg" alt="" width="232" height="162" /></a>Niedziela 23 lipca okazała się być tragiczna w skutkach dla kierującego motocyklem Honda 23-letniego mężczyzny.</strong><!--more-->\n\nOkoło godziny 17.30 w Mikorzynie przy drodze K – 25, gdzie kierujący motocyklem kierujący motocyklem Honda CBR mężczyzna lat 23 jadący wraz z 19 letnim pasażerem uderzył w pieszego przechodzącego przez jezdnię. Na skutek uderzenia i poniesionych obrażeń 49 letni pieszy (mieszkaniec Konina) zmarł po przewiezieniu do szpitala – informuje oficer prasowy konińskiej policji.\n\nZarówno kierujący jak i pasażer byli trzeźwi. Trwają czynności zmierzające do ustalenia przyczyn wypadku.\n\n&nbsp;\n\n// Źródło: ttr24.pl', 'Śmiertelny wypadek w Mikorzynie', '', 'trash', 'open', 'open', '', 'smiertelny-wypadek-w-mikorzynie__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://gminaslesin.futurehost.pl/?p=480', 0, 'post', '', 0),
 (483, 1, '2017-08-08 12:31:06', '2017-08-08 10:31:06', '<strong><img class="wp-image-189 alignleft" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/IMG_1763-1024x768.jpg" alt="" width="341" height="256" />W związku z przypadającą w tym roku 50. rocznicą koronacji Cudownego Obrazu Matki Bożej Licheńskiej, w niedzielę 13 sierpnia Radio Maryja i TV TRWAM przeprowadzą transmisję Mszy św. z Sanktuarium Matki Bożej Licheńskiej. Mszy św. przewodniczyć będzie Nuncjusz Apostolski w Polsce Abp Salvatore PENNACCHIO. Początek transmisji o godz. 11: 55.</strong><!--more-->\nRównież 13 sierpnia w Programie 1 Polskiego Radia poranna audycja „Familijna Jedynka” poświęcona będzie Sanktuarium Matki Bożej Licheńskiej. Początek audycji o godz. 6:00', 'Transmisja Mszy św. z Lichenia', '', 'trash', 'open', 'open', '', 'transmisja-mszy-sw-z-lichenia__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://gminaslesin.futurehost.pl/?p=483', 0, 'post', '', 0),
 (485, 1, '2017-08-01 12:34:11', '2017-08-01 10:34:11', '<div class="opis">\n\n[caption id="" align="alignleft" width="151"]<img class="" src="http://wkonin.pl/data/news/29443s.jpg" width="151" height="85" /> Źródło: wkonin.pl[/caption]\n\n<strong>Jedna osoba została poszkodowana w wypadku, do którego doszło wczoraj tuż przed godz. 16.00 na ulicy Konińskiej w Licheniu Starym.</strong>\n\n</div>\n<!--more-->\n<div class="opis">\n\nPo przybyciu na miejsce zdarzenia stwierdzono, że w wypadku brały udział dwa samochody osobowe. Na miejscu obecny był Zespół Ratownictwa Medycznego oraz Policja. Kierujący i pasażerka pojazdu Mitsubishi oraz kierowca VW znajdowali się na zewnątrz pojazdów, natomiast pasażer VW był uwieziony. Droga na jednym pasie w kierunku Konina była zablokowana. Działania ratowników polegały na zabezpieczeniu miejsca zdarzenia, wykonaniu dostępu do uwięzionej osoby przy pomocy urządzeń hydraulicznych oraz odłączeniu zasilania w pojazdach. W wyniku wypadku pasażer VW został przetransportowany do szpitala przez Zespół Ratownictwa Medycznego.  W zdarzeniu brali udział strażacy z Jednostki Ratowniczo – Gaśniczej Nr 1 i 2 w Koninie oraz druhowie z OSP Licheń Stary - mówi kpt. Sebastian Andrzejewski\n\n// Źródło: wkonin.pl\n\n</div>', 'Wypadek na ulicy Konińskiej w Licheniu Starym', '', 'trash', 'open', 'open', '', 'wypadek-na-ulicy-koninskiej-w-licheniu-starym__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://gminaslesin.futurehost.pl/?p=485', 0, 'post', '', 0),
 (494, 1, '2017-08-09 15:56:34', '2017-08-09 13:56:34', '[caption id="" align="alignleft" width="200"]<img class="" src="http://przegladkoninski.pl/data/catalogue/StNDM5NC0yNDIwMTQtRFNDXzAyNTAuSlBH.jpg" width="200" height="133" /> Źródło: Przegląd Koniński[/caption]\n\n<img class=" alignright" src="http://przegladkoninski.pl/images/przegladkoninski3_03.png" width="176" height="46" />\n\n<strong>Przed południem  doszło do wypadku w Ślesinie na ulicy Kleczewskiej. 57-letnia kobieta kierująca fiatem uno, podczas skrętu w lewo nie ustąpiła pierwszeństwa 62-letniemu motocykliście. Mężczyzna z urazem brzucha i złamaniem ręki trafił do szpitala. </strong>Oboje kierujący byli trzeźwi.', 'Wypadek na Kleczewskiej', '', 'trash', 'open', 'open', '', 'wypadek-na-kleczewskiej__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://gminaslesin.futurehost.pl/?p=494', 0, 'post', '', 0),
 (498, 1, '2017-08-10 15:05:51', '2017-08-10 13:05:51', '<strong><a href="http://www.lichen.pl/pl/24/n_1763/czlowieczy_los._koncert_z_okazji_50._rocznicy_koronacji_cudownego_obrazu_matki_bozej_lichenskiej"><img class="alignleft" src="http://www.lichen.pl/userfiles/images/Czlowieczy%20los-koncert.jpg" width="279" height="393" /></a>W najbliższą niedzielę, 13. sierpnia, w bazylice Najświętszej Maryi Panny Licheńskiej odbędzie się koncert zatytułowany „Człowieczy los”.</strong>\n<!--more-->\nWydarzenie jest organizowane w związku z przypadającymi w tym roku obchodami 50. rocznicy koronacji Cudownego Obrazu Matki Bożej Licheńskiej. Studenci i absolwenci Akademii Muzycznej im. Ignacego Jana Paderewskiego w Poznaniu zaprezentują teksty Janusza Kofty oraz Agnieszki Osieckiej. Muzycy zaśpiewają także piosenki z repertuaru m.in. Edyty Gepert oraz zespołu „Raz Dwa Trzy”.\n\nArtystom towarzyszyć będzie orkiestra poznańskiej Akademii Muzycznej im. Ignacego Jana Paderewskiego.\nPoczątek koncertu o godz. 20.00 w nawie głównej licheńskiej bazyliki. Wstęp wolny.', 'Człowieczy los', '', 'trash', 'open', 'open', '', 'czlowieczy-los__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://gminaslesin.futurehost.pl/?p=498', 0, 'post', '', 0),
 (502, 1, '2017-08-10 16:02:05', '2017-08-10 14:02:05', '[caption id="attachment_506" align="alignleft" width="150"]<a href="https://www.facebook.com/osp.slesin/photos/pcb.861579307325203/861579223991878/?type=3&amp;theater"><img class="size-thumbnail wp-image-506" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/Schowek-12-150x150.jpg" alt="" width="150" height="150" /></a> Zdjęcie: OSP Ślesin // Zalana droga w Honoratce po porannej nawałnicy[/caption]\n\n<strong><img class=" wp-image-503 alignright" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/240915_logo_standard.png" alt="" width="148" height="59" />Konińscy strażacy mają pełne ręce roboty po porannej burzy, która przeszła nad regionem. Wichura zerwała dach z budynku mieszkalnego w Witnicy, w gminie Rzgów.</strong>\n\n<!--more-->\n\nPo burzy i ulewach pozostały zalane piwnice, połamane gałęzie. Strażacy do takich zdarzeń wyjeżdżali 16 razy. Cały czas usuwają skutki burzy, wichury i deszczu.\n- Najpoważniejsze skutki to zerwany dach budynku mieszkalnego w miejscowości Witnica, w gminie Rzgów. Na szczęście nic nikomu się nie stało. Dach zerwał lokalną linię energetyczną i spadł na jezdnię. Strażacy zabezpieczyli budynek foliami i sprzątnęli to co zostało na drodze - mówi Michał Karczewski z konińskiej straży pożarnej.\n\nWiększość zgłoszeń dotyczyła zalanych posesji prywatnych. Woda dostała się też do biblioteki w Kleczewie i Szkoły Podstawowej nr 1 w Koninie. Zalana została również droga krajowa nr 25 w miejscowości Honoratka, która przez jakiś czas była nieprzejezdna. Poza tym strażacy zmagali się z kilkoma połamanymi drzewami i konarami na jezdni.\n\n&nbsp;\n\nŹródło: LM.pl', 'Trwa usuwanie skutków nawałnicy', '', 'trash', 'open', 'open', '', 'trwa-usuwanie-skutkow-nawalnicy__trashed', '', '', '2017-10-23 15:48:40', '2017-10-23 15:48:40', '', 0, 'http://gminaslesin.futurehost.pl/?p=502', 0, 'post', '', 0),
 (510, 1, '2017-08-11 08:52:15', '2017-08-11 06:52:15', '<strong><img class="alignleft size-thumbnail" src="http://umig.slesin.pl/panel/image.php/580_logo_gus_for_tw.jpg?width=90&amp;height=70&amp;image=/media/news_foto/580_logo_gus_for_tw.jpg" width="72" height="70" />Urząd Statystyczny w Poznaniu prowadzi badania ankietowe na terenie całego województwa wielkopolskiego. Dane statystyczne są wykorzystywane do analiz i opracowań zbiorczych dotyczących sytuacji społecznej i gospodarczej województwa, stanowią również podstawę do podejmowania strategicznych decyzji ekonomicznych, społecznych i administracyjnych na wszystkich szczeblach zarządzania.</strong><!--more-->\n\nZwracamy się do Państwa z prośbą o udział w badaniach statystyki publicznej. Państwa przychylność wobec ankieterów statystycznych oraz czas im poświęcony zapewnia wysoką jakość uzyskanych danych statystycznych.\n\n<a href="http://umig.slesin.pl/aktualnosci/580/statystyczne-badania-rolne" target="_blank" rel="noopener">Zobacz szczegóły statystycznych badań rolnych.</a>', 'Badania statystyczne w Wielkopolsce', '', 'trash', 'open', 'open', '', 'badania-statystyczne-w-wielkopolsce__trashed', '', '', '2017-10-23 15:48:32', '2017-10-23 15:48:32', '', 0, 'http://gminaslesin.futurehost.pl/?p=510', 0, 'post', '', 0),
 (512, 1, '2017-08-11 12:30:19', '2017-08-11 10:30:19', '[caption id="" align="alignleft" width="268"]<a href="http://www.lichen.pl/pl/24/n_1764/warsztaty_pisania_ikon"><img class="" src="http://www.lichen.pl/media/foto/21829_dsc00073.jpg" width="268" height="150" /></a> lichen.pl[/caption]\n\n<strong>Autorską ikonę mogli napisać uczestnicy warsztatów, jakie w dniach 3-6 sierpnia br. trwały w Sanktuarium Maryjnym w Licheniu Starym.</strong>\n\n<a href="http://www.lichen.pl/pl/24/n_1764/warsztaty_pisania_ikon" target="_blank" rel="noopener">Zobacz zdjęcia.</a><!--more-->\n\nW drugich tegorocznym warsztatach wzięło udział 11 osób z całej Polski (niektórzy z uczestników wzięli w nich udział po raz drugi). Spotkanie było połączone z rekolekcjami, gdyż ikona nie jest zwykłym obrazem religijnym, a pisanie ikon nie jest tylko zwykłym malowaniem, ale - zgodnie z tradycją ikonopisania - czynnością świętą. Dlatego też każdego dnia uczestnicy wprowadzani byli w wybrane zagadnienia z teologii ikon, poznając ich historię i ucząc się je czytać. Każdego też dnia spędzali czas na medytacji przed wybraną ikoną. Praktyczne wykorzystanie otrzymanych informacji rozpoczęło się wraz z wybraniem przez początkujących ikonopisarzy konkretnej ikony (bądź też jej detalu), którą zamierzali napisać. Większość uczestników warsztatów zdecydowała się na przedstawienia maryjne, część na przygotowanie tzw. Mandylionu - „ikony ikon” przedstawiającej oblicze Chrystusa wpisane w nimb krzyżowy, ukazane na białej chuście.\n\nProwadząca warsztaty ikonopisarka Janina Krauze z Bieszczad, wyjaśniła, iż napisanie ikony jest trudne, pracochłonne i wymagające, jednak uzyskany efekt jest wart zaangażowania włożonego w pracę twórczą: „Trzeba panować nad ręką, nad kreską. Ważne jest, aby w trakcie pracy z pędzlem ręka nie drżała. W przeciwnym razie efekt będzie inny od oczekiwanego. Potrzebne jest skupienie, koncentracja i cierpliwość”.\n\nUczestnicy licheńskich warsztatów pracowali na bazie kanonu pisania ikon ustalonego już w pierwszych wiekach istnienia chrześcijaństwa.\n\nSłowo „ikona” pochodzi z języka greckiego („eikon”). Ikona jest obrazem sakralnym powstałym w kręgu kultury bizantyńskiej, wyobrażającym przede wszystkim postać Chrystusa i Maryi. Może także przedstawiać apostołów, świętych, sceny biblijne lub też liturgiczno-symboliczne.\n\nNastępna edycja warsztatów, w której  mogą wziąć udział osoby nie mające wcześniej doświadczenia w malarstwie, planowana jest w Sanktuarium na 19-22 października br.<!--more-->', 'Warsztaty pisania ikon', '', 'trash', 'open', 'open', '', 'warsztaty-pisania-ikon__trashed', '', '', '2017-10-23 15:48:32', '2017-10-23 15:48:32', '', 0, 'http://gminaslesin.futurehost.pl/?p=512', 0, 'post', '', 0),
 (514, 1, '2017-08-12 00:24:04', '2017-08-11 22:24:04', '[caption id="" align="alignleft" width="239"]<a href="http://www.przegladkoninski.pl/PL-H5/3/4431/nawalnica-nad-koninem-i-regionem-strazacy-usuwaja-powalone-drzewa-wiatr-zrywa-dachy.html"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StNDQzMS0zNjAwNDMtUEFSVF8xNTAyNDg0NDY0MDcwLmpwZw==.jpg" width="239" height="179" /></a> Źródło: Przegląd Koniński[/caption]\n\n<img class=" alignright" src="http://www.przegladkoninski.pl/images/przegladkoninski3_03.png" width="157" height="41" />\n\n<strong>To na pewno będzie ciężka noc dla strażaków. Nad Koninem i regionem wieczorem szalała burza. Niedawno usuwali powalone drzewo przy Alejach 1 Maja. Wezwań jest dużo, co potwierdził Michał Karczewski z Komendy Miejskiej Państwowej Straży Pożarnej w Koninie. Dużo pracy mają również strażacy ochotnicy z powiatu konińskiego. Druhowie z OSP w Licheniu Starym jeżdżą do powalonych drzew.</strong><!--more-->\n\nW Szczerkowie (gmina Sompolno) powalone drzewo przewróciło się na BMW.\n\nJak się dowiedzieliśmy, część Ślesina i Niesłusz są bez prądu. W gminie Ślesin brakuje przez to bieżącej wody.\n\nZ konińskiej straży otrzymaliśmy informacje o uszkodzonych dachach w Ślesinie, w Popielewie (w gminie Skulsk), wiatr zerwał również dach na domu w Koszarach (w gminie Sompolno).\n\nKonińscy strażacy otrzymali sygnał, że na Jeziorze Gosławskim osoby znajdujące się na katamaranie (tramwaju wodnym) nie mogą dopłynąć do brzegu. Zostali odholowani.\n\n- Nie ma osób poszkodowanych - informuje Michał Karczewski.\n\nW tej chwili na jeziorze w Skorzęcinie trwa akcja poszukiwania łodzi, która przewróciła się podczas burzy. Na pokładzie znajdowało się kilka osób. W działaniach uczestniczą również strażacy z Konina.\n\n&nbsp;\n\nŹródło: Przegląd Koniński', 'Po nawałnicy powalone drzewa, a Ślesin bez prądu i wody', '', 'trash', 'open', 'open', '', 'po-nawalnicy-powalone-drzew-a-slesin-bez-pradu-i-wody__trashed', '', '', '2017-10-23 15:48:31', '2017-10-23 15:48:31', '', 0, 'http://gminaslesin.futurehost.pl/?p=514', 0, 'post', '', 0),
 (520, 1, '2017-08-12 08:58:26', '2017-08-12 06:58:26', '[caption id="" align="alignleft" width="195"]<a href="http://www.przegladkoninski.pl/PL-H5/3/4430/uroczystosci-rocznicowe-w-licheniu-ta-msza-rozpoczynamy-swietowanie.html?poll_show=36"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StLS0yMTYyNDEtRFNDMDAxNTAuSlBH.jpg" width="195" height="130" /></a> Źródlo: Przegląd Koniński[/caption]\n\n<strong><img class=" wp-image-522 alignright" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="146" height="38" />Przełożony generalny Zgromadzenia Księży Marianów przewodniczył mszy świętej, którą rozpoczęto wczoraj uroczystości 50-lecia koronacji Cudownego Obrazu Matki Bożej Licheńskiej.</strong><!--more-->\n\nJak przypomniał na początku mszy świętej ksiądz Wiktor Gumienny, kustosz Sanktuarium Maryjnego w Licheniu, przy ołtarzu koronacyjnym, to właśnie tutaj 15 sierpnia 1967 roku odbyła się koronacja Cudownego Obrazu Matki Bożej Licheńskiej.\n\n– Sanktuarium do tamtej pory było znane w całej diecezji włocławskiej. Od tamtej chwili zaczął się dynamiczny jego rozwój. Tą mszą świętą rozpoczynamy świętowanie 50. rocznicy koronacji Cudownego Obrazu Matki Bożej Licheńskiej – mówił ks. kustosz. – Trzeba sobie uświadomić bardzo ważny fakt, że ta koronacja była swego rodzaju pieczęcią na objawieniach, które tutaj były w 1850 roku. Wiemy, że w Polsce tylko te, które miały miejsce w Gietrzwałdzie zostały oficjalnie potwierdzone przez Kościół.\n\nMszy świętej przewodniczył ks. Andrzej Pakuła, przełożony generalny Zgromadzenia Księży Marianów, który do Lichenia przyjechał z Rzymu.\n\n– Jezus ciągle do nas przemawia. I możemy powiedzieć, że w sposób szczególny przemawia do nas dzisiaj, kiedy rozpoczynamy tą mszą jubileusz 50-lecia koronacji Cudownego Obrazu Matki Bożej Licheńskiej – mówił w homilii.\n\nCo jeszcze w Licheniu?\n\nUroczystości 50-lecia koronacji Cudownego Obrazu Matki Bożej Licheńskiej potrwają przez kilka najbliższych dni. Jutro o godzinie 19.00 eucharystię odprawi biskup pomocniczy włocławski Stanisław Gębicki. W niedzielę, 13 sierpnia, o 12.00 mszy świętej w bazylice przewodniczyć będzie arcybiskup Salvatore Pennacchio, nuncjusz apostolski w Polsce. O 15.30 natomiast w auli Domu Pielgrzyma Betlejem zostanie pokazany spektakl o historii objawień Matki Bożej Licheńskiej, a o 20.00 odbędzie się w bazylice koncert poezji śpiewanej „Człowieczy los”.\n\nW poniedziałek, w południe, na placu koronacyjnym mszę świętą odprawi ks. biskup senior Bronisław Dembowski, a o 18.00 w bazylice arcybiskup Wojciech Polak, prymas Polski.\n\nPunktem kulminacyjnym uroczystości będzie msza w święto Wniebowzięcia Najświętszej Maryi Panny, czyli Matki Boskiej Zielnej, czyli 15 sierpnia, pod przewodnictwem kardynała Stanisława Dziwisza. To właśnie wtedy zostanie poświęcona i nałożona na obraz złota sukienka dla Maryi, ufundowana przez ofiarodawców i dobroczyńców Sanktuarium Maryjnego w Licheniu.', 'Uroczystości rocznicowe w Licheniu. „Tą mszą rozpoczynamy świętowanie”', '', 'trash', 'open', 'open', '', 'uroczystosci-rocznicowe-w-licheniu-ta-msza-rozpoczynamy-swietowanie__trashed', '', '', '2017-10-23 15:48:31', '2017-10-23 15:48:31', '', 0, 'http://gminaslesin.futurehost.pl/?p=520', 0, 'post', '', 0),
 (526, 1, '2017-08-12 10:31:00', '2017-08-12 08:31:00', '<div class="opis">\n\n<strong><a href="http://wkonin.pl/go.live.php/PL-H167/aktualnosci/29477/w-sobote-calodniowa-ewangelizacja-w-lichenskim-sanktuarium.html"><img class="alignleft " src="http://wkonin.pl/data/news/29477s.jpg" width="186" height="266" /></a>Wspólnoty i ruchy kościelne działające na terenie diecezji włocławskiej w sobotę, 12. sierpnia, od godziny 9:30 do 17:00 prowadzić będą na terenie Sanktuarium Maryjnego w Licheniu ewangelizację. W ten sposób diecezja włocławska włącza się w obchody 50. rocznicy koronacji cudownego Obrazu Matki Bożej Licheńskiej.</strong>\n\n</div>\n<!--more-->\n<div class="opis">\n\nDziałania ewangelizacyjne koordynować będzie licheńska wspólnota charyzmatyczna „Ekipa dla Jezusa” posługująca podczas comiesięcznych wieczorów uwielbienia w Licheniu.\n\n„W różnych punktach na terenie licheńskiego Sanktuarium zostaną zlokalizowane punkty, w których będą ewangelizowały konkretne wspólnoty. Zespoły, składające się z dwóch lub trzech osób, będą prowadziły rozmowy z napotkanymi ludźmi doprowadzając ich do spotkania z Jezusem. Będą to rozmowy bezpośrednie bądź inicjowane z wykorzystaniem różnorodnych form artystycznych, np. heppeningu, flash mobu, żywej rzeźby itp.” – powiedział ks. Rafał Krauze MIC, opiekun duchowy wspólnoty „Ekipa dla Jezusa”.\n\nPoszczególne punkty ewangelizacyjne zostaną zlokalizowane w różnych miejscach, m.in. na schodach prowadzących do kościoła parafialnego pw. św. Doroty, przy źródełku, przy wejściu na teren Sanktuarium od ul. Toruńskiej, na placu przed bazyliką, przy fontannie, przed Golgotą. Ewangelizacja będzie także prowadzona poza murami Sanktuarium, na licheńskiej plaży.\n\nPrzy dzwonnicy naprzeciw domu pielgrzyma „Betlejem” w trakcie dnia ewangelizacji będzie możliwość wysłuchania koncertu ewangelizacyjnego, świadectw i katechez prowadzonych przez wspólnoty z diecezji włocławskiej.\n\nPrzy dzwonnicy także organizatorzy zapraszają na tzw. "krzesło cudów” - pod specjalnym namiotem i w pobliżu niego wolontariusze będą się modlili wstawienniczo z pielgrzymami o doświadczenie cudu Bożej miłości.\n\nOrganizatorzy przygotowali także kącik dla dzieci. Wolontariusze będą prowadzić z najmłodszymi zabawy w oparciu o kerygmat. Dwukrotnie, o godz. 11.45 oraz 13.45, odbędzie się także specjalnie przygotowany teatrzyk kukiełkowy dla dzieci. Ta część ewangelizacji odbywać się będzie na placu zabaw w parku nieopodal domu pielgrzyma „Arka”.\n\nW razie niepogody program zostanie przeniesiony ze sceny pod dzwonnicą do bazyliki, do kaplicy Całunu Turyńskiego.\n\n</div>\n<a href="http://wkonin.pl/go.live.php/PL-H167/aktualnosci/29477/w-sobote-calodniowa-ewangelizacja-w-lichenskim-sanktuarium.html">\n\n</a>', 'W sobotę całodniowa ewangelizacja w licheńskim Sanktuarium', '', 'trash', 'open', 'open', '', 'w-sobote-calodniowa-ewangelizacja-w-lichenskim-sanktuarium__trashed', '', '', '2017-10-23 15:48:31', '2017-10-23 15:48:31', '', 0, 'http://gminaslesin.futurehost.pl/?p=526', 0, 'post', '', 0),
 (528, 1, '2017-08-13 13:14:04', '2017-08-13 11:14:04', '<div>\n\n[caption id="" align="alignleft" width="120"]<a href="http://www.lichen.pl/pl/24/n_1771/drugi_dzien_uroczystosci"><img class="size-medium" src="http://www.lichen.pl/panel/image.php/21915_img_7174.jpg?width=120&amp;image=/media/foto/21915_img_7174.jpg" width="120" height="180" /></a> Źródło: lichen.pl[/caption]\n\n<strong>Drugiego dnia obchodów jubileuszu  50. rocznicy koronacji Cudownego Obrazu Matki Bożej Licheńskiej wspólnoty i ruchy kościelne z diecezji włocławskiej prowadziły ewangelizację na terenie licheńskiego Sanktuarium. Dzień ewangelizacyjny zwieńczyły nieszpory przy ołtarzu koronacyjnym oraz Msza św. przed Cudownym Obrazem Matki Bożej Licheńskiej w bazylice pod przewodnictwem biskupa pomocniczego włocławskiego, Stanisława Gębickiego. </strong></div>\n<!--more-->\n<div></div>\n<div>Przez cały dzień na terenie Sanktuarium wierni mogli modlić się z wolontariuszami prowadzącymi ewangelizację. Modlitwę wstawienniczą w kilkuosobowej grupie przeprowadzano z użyciem tzw. „krzesła cudów”. Z kolei przy dzwonnicy naprzeciw domu pielgrzyma „Betlejem” w trakcie całego dnia istniała możliwość wysłuchania świadectw i katechez prowadzonych przez wspólnoty z diecezji włocławskiej.</div>\n<div></div>\n<div>Działania ewangelizacyjne koordynowała licheńska wspólnota charyzmatyczna „Ekipa dla Jezusa”, posługująca podczas comiesięcznych wieczorów uwielbienia w Licheniu. Ponadto ewangelizację powadziły wspólnoty z Koła, Aleksandrowa Kujawskiego, Lubicza, Włocławka, Dębów Szlacheckich, Zduńskiej Woli, Izbicy Kujawskiej oraz Ochla.</div>\n<div></div>\n<div>O godz. 18.00 przy ołtarzu koronacyjnym odprawione zostały nieszpory, którym przewodniczył bp Stanisław Gębicki z Włocławka. Po wspólnej modlitwie wierni procesyjnie udali się do licheńskiej bazyliki, aby przed Cudownym Obrazem Matki Bożej uczestniczyć w wieczornej Mszy św., której przewodniczył bp Gębicki, natomiast słowo Boże wygłosił ks. Paweł Naumowicz MIC. Mówił: „Przeszliśmy w procesji do bazyliki. Ta pielgrzymka ma trwać dalej, gdyż Maryja chce nas prowadzić. Nawet, gdy pójdziemy do naszej codzienności, Ona chce nas prowadzić do Boga”.</div>\n<div></div>\n<div>Kaznodzieja zachęcał także wiernych do czytania i rozważania słowa Bożego w myśl słów ze starotestamentowej Księgi Powtórzonego Prawa – „Słuchaj Izraelu, Pan jest jedyny”.</div>\n<div></div>\n<div>Jutro kolejny dzień uroczystości z okazji złotego jubileuszu koronacji Cudownego Obrazu Matki Bożej Licheńskiej. Mszy św. o godz. 12.00 przewodniczył będzie abp Salvatore Pennacchio, Nuncjusz Apostolski w Polsce.</div>', 'Drugi dzień obchodów złotego jubileuszu koronacji', '', 'trash', 'open', 'open', '', 'drugi-dzien-obchodow-zlotego-jubileuszu-koronacji__trashed', '', '', '2017-10-23 15:48:31', '2017-10-23 15:48:31', '', 0, 'http://gminaslesin.futurehost.pl/?p=528', 0, 'post', '', 0),
 (530, 1, '2017-08-13 22:37:54', '2017-08-13 20:37:54', '[caption id="" align="alignleft" width="194"]<a href="http://www.lichen.pl/pl/577/n_1772/nuncjusz_apostolski_w_polsce_modlil_sie_w_licheniu"><img class="" src="http://www.lichen.pl/media/foto/21951_img_7615.jpg" width="194" height="291" /></a> Źródło: lichen.pl[/caption]\n\n<strong>Abp Salvatore Pennacchio, Nuncjusz Apostolski w Polsce, przewodniczył dzisiejszej południowej Mszy św. przed Cudownym Obrazem Matki Bożej. <a href="http://www.przegladkoninski.pl/PL-H5/3/4441/nuncjusz-apostolski-w-polsce-poswiecil-pomnik-przed-lichenska-bazylika.html">Materiał TV i zdjęcia Przeglądu Konińskiego.</a></strong><!--more-->\n<div>Mszy św. o godz. 12. w licheńskiej bazylice przewodniczył abp Salvatore Pennacchio, Nuncjusz Apostolski w Polsce. O godz. 11: 30 abpa Pennacchio w Licheniu powitał bp Wiesław Alojzy Mering, ordynariusz diecezji włocławskiej, któremu towarzyszyli: bp Stanisław Gębicki, biskup pomocniczy włocławski oraz przedstawiciele Zgromadzenia Księży Marianów, na czele z ks. Andrzejem Pakułą MIC, Przełożonym Generalnym.</div>\n<div></div>\n<div>W homilii, którą w imieniu Nuncjusza odczytał ks. Sławomir Homoncik MIC, wiceprowincjał Zgromadzenia Księży Marianów, hierarcha odwołał się do roli i znaczenia modlitwy w życiu człowieka ochrzczonego:  „Nie wystarczy Boga spotkać, trzeba z Nim także utrzymywać kontakt. Dla nas, którzy tu jesteśmy, to oczywiste. Bo przecież przyszliśmy tu się modlić. A czym jest modlitwa, jak nie właśnie utrzymywaniem kontaktu z Bogiem, często przy wsparciu różnych dobrych pośredników, orędowników, wśród których Matkę Bożą trzeba wymienić na pierwszym miejscu. Forma nie jest taka istotna; ważne, aby ta modlitwa była”.</div>\n<div></div>\n<div>Po zakończonej Eucharystii służba liturgiczna oraz wierni udali się na zewnątrz świątyni, gdzie abp Pennacchio poświęcił nowy pomnik przedstawiający ukazanie się Matki Bożej żołnierzowi Tomaszowi Kłossowskiemu na polu bitwy pod Lipskiem w 1813 roku.</div>', 'Nuncjusz Apostolski w Polsce modlił się w Licheniu', '', 'trash', 'open', 'open', '', 'nuncjusz-apostolski-w-polsce-modlil-sie-w-licheniu__trashed', '', '', '2017-10-23 15:48:31', '2017-10-23 15:48:31', '', 0, 'http://gminaslesin.futurehost.pl/?p=530', 0, 'post', '', 0),
 (532, 1, '2017-08-13 23:00:59', '2017-08-13 21:00:59', '[caption id="" align="alignleft" width="200"]<a href="https://www.facebook.com/osp.slesin/"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t31.0-0/q84/p180x540/20746359_863521240464343_3047151173018203819_o.jpg?oh=b6593d8bdd1c795b8c25dcd36b389070&amp;oe=5A22EB7E" width="200" height="150" /></a> Zdjęcie: facebook.com/osp.slesin[/caption]\n\n<strong>Pod wieczór w piątek od południa Wielkopolski zmierzał na północ tzw. mezoskalowy układ konwekcyjny, który w środkowej części regionu przybrał na linii szkwałowej kształt wygiętego łuku (tzw. sygnatura <em>bow echo</em>). Oznaczało to niszczycielskie porywy huraganowego wiatru zstępującego, które pokazały swoją siłę w niedalekiej Wrześni i Gnieźnie, gdzie wiało ponad 120 km/h. Jednak zniszczenia w gminie Ślesin również wskazują na przekroczenie prędkości wiatru w porywach ponad 100 km/h.</strong>\n\n<a href="http://wielkopolska.tv/kataklizm-zniszczyl-dobytek-wielu-wielkopolan/#/?playlistId=0&amp;videoId=0" target="_blank" rel="noopener">Zniszczenia w Wielkopolsce.</a><!--more-->\n\nŚwiadczą o tym raporty strażaków OSP Ślesin, którzy interweniowali do szkód wywołanych przez żywioł. Wiatr powalił drzewa w Wąsoszach, Ślesinie przy ul. Witosa, Kotarbińskiego, Świerczewskiego, Schillera, Kliny oraz w Żółwieńcu. W Ślesinie na ul. Kościelnej i w Szyszynku drzewa spadły na linie elektryczne,  przy ul. Kościelnej również na łódź. Zwisający konar zagrażał też przechadzającym się po Parku Miejskim. Nawałnica zerwała dachy w Ślesinie przy ul. Iwaszkiewicza i 20 stycznia. Ślesińscy druhowie pomagali też 12 sierpnia przy zerwanym dachu w Buszkowie w gminie Skulsk. Interweniowano do zalanej piwnicy przy ul. XXX-lecia PRL.\n\nZdjęcia z interwencji można przejrzeć na profilu Facebookowym OSP Ślesin <a href="https://www.facebook.com/osp.slesin/" target="_blank" rel="noopener">tutaj</a>\n\n&nbsp;', 'Jedna z najgroźniejszych burz ostatnich lat w gminie Ślesin', '', 'trash', 'open', 'open', '', 'jedna-z-najgrozniejszych-burz-ostatnich-lat-w-gminie-slesin__trashed', '', '', '2017-10-23 15:48:31', '2017-10-23 15:48:31', '', 0, 'http://gminaslesin.futurehost.pl/?p=532', 0, 'post', '', 0),
 (538, 1, '2017-08-14 13:37:24', '2017-08-14 11:37:24', '[caption id="" align="alignleft" width="248"]<a href="http://www.przegladkoninski.pl/PL-H5/3/4447/soltysi-wymachiwali-pieczatka-i-ujezdzali-konie-zmierzyli-sie-w-turnieju-film.html"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StLS0zNzgwNzEtRFNDMDI1MzQuSlBH.jpg" width="248" height="140" /></a> Źródło: Przegląd Koniński[/caption]\n\n<strong>Sołtyski i sołtysi z gminy Ślesin musieli zmierzyć się z nie lada konkurencjami. Zorganizowano je dla nich podczas festynu w Biskupiu. <a href="http://www.przegladkoninski.pl/PL-H5/3/4447/soltysi-wymachiwali-pieczatka-i-ujezdzali-konie-zmierzyli-sie-w-turnieju-film.html" target="_blank" rel="noopener">Zobacz zdjęcia i materiał TV.</a></strong><!--more-->\n\nByło wesoło, a szefowie wsi na pewno mogli liczyć na doping mieszkańców. Sołtyski i sołtysi musieli między innymi w pół minuty ostemplować kartki, a wygrywała ta osoba, która w tym czasie zrobiła najwięcej stempli .\n\nSporo emocji wywołała rywalizacja z udziałem kolorowego konia, na którego szefowie wsi musieli wsiąść i pokonać wyznaczony dystans. Trzeba było się wykazać sporą kondycją, a śmiechu było co niemiara.\n\n<img class=" wp-image-522 alignright" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="238" height="62" />\n\nPodczas festynu odbył się również wyścig bolidów– drużyna sołtysów kontra uczestnicy imprezy. Wygrali ci pierwsi. Z kolei w konkursie zatytułowanym „spacer farmera” (należało przenieść dwie walizki po 50 kilogramów jak najdalej) wystartowało 15 zawodników. Najlepszy był Sławomir Hofman, który pokonał dystans 120 metrów. Drugie miejsce zajął Janusz Zajferdt (100 metrów), a trzecie Krzysztof Kańcurzewski oraz Daniel Golonka (po 80 metrów).\n\n&nbsp;\n\nA tak wygląda ostateczna klasyfikacja w Turnieju Sołtysów:\n\n<span style="text-decoration: underline;">Panie:</span>\n\n1. Małgorzata Kuligowska – Półwiosek Stary\n\n2. Zofia Brzozowska – Głębockie oraz\n\nMilena Jesiołowska – Ignacewo\n\n3. Aurelia Lepsza – Kępa\n\n4. Irena Jabłońska – Julia\n\n&nbsp;\n\n<span style="text-decoration: underline;">Panowie</span>\n\n1. Sławomir Królak – Biskupie\n\n2. Andrzej Donderowicz – Szyszyńskie Holendry\n\n3. Janusz Jąkalski – Kolebki\n\n4. Piotr Czarnkowski – Lubomyśle\n\n5. Henryk Cegielski – Goranin\n\n6. Henryk Chmurski – Mikorzyn\n\n7. Wojciech Chmielewski – Ostrowąż\n\n&nbsp;\n\nŹródło: Przegląd Koniński\n\n&nbsp;\n\n__________\n\n&nbsp;\n<div class="aktualnosci_tresc">\n<div class="tresc">\n\n<strong>12 sierpnia na boiskach sportowych w Biskupiu odbył się Festyn Sołecki. Dla uczestników przygotowano szereg atrakcji. Najmłodsi mogli skorzystać z darmowych dmuchanych zjeżdżalni. Dzieci, młodzież oraz dorośli mieli możliwość uczestnictwa w przygotowanych grach, konkursach i zabawach. Dla siłaczy przeprowadzono konkurs „ Spacer Farmera „.W konkursie wystartowało 15 zawodników zajmując kolejne miejsca w zależności odległości na jaką zostały przeniesione dwie walizki ważące po 50 kilogramów każda.</strong>\n\nPierwsze miejsce zdobył Hofman Sławomir Biskupie 120 metrów;\ndrugie Zajferdt Janusz Biskupie 100 metrów i trzecie równorzędne Kańcurzewski Krzysztof Szyszyn, Golonka Daniel Biskupie po 80 metrów.\nDla wszystkich z koncertem na plenerowej scenie wystąpił zespól Venus wykonując największe muzyczne przeboje.\n\nPodczas Festynu Sołeckiego Sołectwa Biskupie został zorganizowany Turniej Sołtysów.\nSołtysi rywalizowali w konkurencjach sportowo – zręcznościowych: stemplowanie dokumentów, jazda konna, łowienie ryb, spacer trapera. W wyniku przeprowadzonych konkurencji sołtysi zajęli kolejno miejsca:\n<div class="text_exposed_show">\n\nPanie\n1.Kuligowska Małgorzata Półwiosek Stary\n2. Brzozowska Zofia Głębockie\nJesiołowska Milena Ignacewo\n3.Lepsza Aurelia Kępa\n4.Jabłońska Irena Julia\n\nPanowie\n1.Królak Sławomir Biskupie\n2.Donderowicz Andrzej Szyszyńskie Holendry\n3.Jąkalski Janusz Kolebki\n4.Czarnkowski Piotr Lubomyśle\n5.Cegielski Henryk Goranin\n6.Chmurski Henryk Mikorzyn\n7.Chmielewski Wojciech\n\nOdbył się wyścig bolidów drużyna sołtysów kontra drużyna uczestnicy festynu, wyścig wygrali sołtysi. Sołeckie świętowanie podsumował pokaz sztucznych ogni ufundowany przez Wioletę\ni Jana Szmidt z Biskupia, który zaprezentowano podczas zabawy tanecznej z zespołem muzycznym Aplaus. Organizatorzy składają również podziękowanie dla Firmy Polfarma za wsparcie finansowe festynu.\n\nPanie z Koła Gospodyń Biskupie przygotowały festynowe przysmaki: chleb ze smalcem i kiszonym ogórkiem, ciasto domowego wypieku i pyr czoka, były również kiełbaski z grilla. Festyn zorganizowany został ze środków funduszu sołeckiego\na turniej sołtysów ze środków domu kultury. Organizatorami festynu byli: Sołtys i Rada Sołecka Sołectwa Biskupie, Koło Gospodyń Wiejskich w Biskupiu i Miejsko Gminny Ośrodek Kultury w Ślesinie.\n\n</div>\n&nbsp;\n\n</div>\n</div>\n<div class="aktualnosci_podpis">Robert Majdecki - M-GOK Ślesin</div>', 'Sołtysi wymachiwali pieczątką i ujeżdżali konie', '', 'trash', 'open', 'open', '', 'soltysi-wymachiwali-pieczatka-i-ujezdzali-konie__trashed', '', '', '2017-10-23 15:48:31', '2017-10-23 15:48:31', '', 0, 'http://gminaslesin.futurehost.pl/?p=538', 0, 'post', '', 0),
 (544, 1, '2017-08-15 22:54:34', '2017-08-15 20:54:34', '<div>\n\n[caption id="" align="alignleft" width="257"]<a href="http://www.lichen.pl/pl/24/n_1773/nieszpory_i_msza_sw._pod_przewodnictwem_abpa_wojciecha_polaka"><img class="" src="http://www.lichen.pl/media/foto/21986_img_7914.jpg" width="257" height="172" /></a> Źródło: lichen.pl[/caption]\n\n<strong>W wigilię uroczystości Wniebowzięcia Najświętszej Maryi Panny, Mszy św. połączonej z I Nieszporami z Uroczystości Wniebowzięcia NMP w licheńskiej bazylice przewodniczył abp Wojciech Polak, Prymas Polski. </strong>\n\n</div>\n<div> <a href="http://wielkopolska.tv/lichen-cudowna-koronacja/#/?playlistId=0&amp;videoId=0" target="_blank" rel="noopener">Materiał TV.</a></div>\n<!--more-->\n<div>W słowie skierowanym do wiernych, ks. Prymas przypomniał o istocie jubileuszu licheńskiego Sanktuarium: „Podobnie jak 50. lat temu, Kościół w Polsce przychodzi dziś do Maryi obecnej pośród nas w tym Cudownym Wizerunku Matki Bożej Licheńskiej. Zgromadziliśmy się bowiem, aby świętować 50.lecie koronacji licheńskiego Obrazu. Dzisiaj przychodzimy z różnych stron naszej Ojczyzny, aby w wigilię uroczystości Wniebowzięcia Maryi uwielbić Boga i z nadzieją wpatrywać się w Tę, którą błogosławią wszystkie pokolenia – Wniebowziętą Patronkę Świętego Kościoła, która jest dla nas znakiem otuchy i niezawodnej nadziei”.</div>\n<div></div>\n<div>Wraz z abpem Polakiem wieczorną Eucharystię, która zgromadziła kilka tysięcy wiernych, koncelebrowali: bp Artur Miziński, sekretarz generalny Konferencji Episkopatu Polski, bp Wiesław Alojzy Mering i bp Stanisław Gębicki, ordynariusz oraz biskup pomocniczy diecezji włocławskiej, bp Paweł Socha, biskup senior diecezji zielonogórsko-gorzowskiej, bp Adam Bałabuch, biskup pomocniczy świdnicki, abp Stanisław Nowak, arcybiskup senior archidiecezji częstochowskiej.</div>\n<div></div>\n<div>Specjalne podziękowania i pozdrowienia dla pielgrzymów uczestniczących w uroczystościach 50. rocznicy koronacji Cudownego Obrazu Matki Bożej Licheńskiej w imieniu prezydenta RP, pana Andrzej Dudy, przekazał obecny dziś w Licheniu prezydencki kapelan, ks. Zbigniew Kras.</div>\n<div></div>\n<div>Wcześniej, bo o godz. 12.00, Mszy św. na ołtarzu koronacyjnym przewodniczył bp Bronisław Dembowski, biskup senior diecezji włocławskiej, natomiast homilię wygłosił ks. Tomasz Nowaczek MIC, Przełożony Prowincji Polskiej Zgromadzenia Księży Marianów. W słowie skierowanym do wiernych ks. Nowaczek ukazał licheńskie Sanktuarium jako miejsce, gdzie Maryja podobnie jak na weselu w Kanie Galilejskie kieruje do każdego przybywającego tutaj pielgrzyma te same słowa: „Zróbcie wszystko, cokolwiek wam powie”. Jednocześnie zaznaczył, że „człowiek nie jest w stanie zrozumieć samego siebie bez Chrystusa”.</div>\n<div></div>\n<div>Po Mszy św. bp Dembowski zasadził i poświęcił dąb jubileuszowy na placu koronacyjnym, gdzie 15 sierpnia 1967 roku kard. Stefan Wyszyński ukoronował Cudowny Obraz Matki Bożej Licheńskiej koroną papieską.</div>\n<div></div>\n<div>Licheń Stary, 15 sierpnia 2017</div>', 'Nieszpory i Msza św. pod przewodnictwem abpa Wojciecha Polaka, Prymasa Polski', '', 'trash', 'open', 'open', '', 'nieszpory-i-msza-sw-pod-przewodnictwem-abpa-wojciecha-polaka-prymasa-polski__trashed', '', '', '2017-10-23 15:48:31', '2017-10-23 15:48:31', '', 0, 'http://gminaslesin.futurehost.pl/?p=544', 0, 'post', '', 0),
 (546, 1, '2017-08-15 22:57:11', '2017-08-15 20:57:11', '<div>\n\n[caption id="" align="alignleft" width="260"]<a href="http://www.lichen.pl/pl/24/n_1774/wniebowziecie_najswiswietszej_maryi_panny"><img class="" src="http://www.lichen.pl/media/foto/22029_img_8402.jpg" width="260" height="174" /></a> Źródło: lichen.pl[/caption]\n\n<strong>Kard. Stanisław Dziwisz, arcybiskup senior archidiecezji krakowskiej, przewodniczył uroczystej Mszy św. w uroczystość Wniebowzięcia Najświętszej Maryi Panny w licheńskiej bazylice (15.08).  <a href="https://www.lm.pl/aktualnosci/informacja/111008/jubileusz_w_licheniu_50_lat_od_koronacji_obrazu_matki_bozej" target="_blank" rel="noopener">Materiał TV.</a></strong>\n\n</div>\n<!--more-->\n<div> <a href="http://wielkopolska.tv/lichen-specjalne-wydanie-ekspresu-wielkopolski/" target="_blank" rel="noopener">Specjalne wydanie "Ekspresu Wielkopolski"</a></div>\n<div>Mszę św. poprzedziła procesja po licheńskiej świątyni, w której niesiony był Cudowny Obraz Matki Bożej Licheńskiej kolejno przez poszczególne delegacje: strażaków, matek, ojców, młodzieży oraz księży marianów. Następnie kard. Dziwisz poświęcił nową sukienkę, która została nałożona na Cudowny Obraz Pani Licheńskiej. Sukienka ufundowana przez ofiarodawców i darczyńców licheńskiego Sanktuarium z Polski i zagranicy nosi miano szafirowej.</div>\n<div></div>\n<div>Po umieszczeniu Cudownego Obrazu w prezbiterium rozpoczęła się Msza św., którą wraz z kadr. Dziwiszem koncelebrowali: bp Wiesław Alojzy Mering, ordynariusz włocławski, bp Stanisław Gębicki, biskup pomocniczy włocławski, bp Bronisław Dembowski, biskup senior włocławski, bp Andrzej Suski, ordynariusz toruński, bp Józef Szamocki, biskup pomocniczy toruński, bp Andrzej Dziuba, biskup diecezjalny łowicki oraz kapłani uczestniczący w uroczystościach.</div>\n<div></div>\n<div>W homilii kard. Dziwisz skupił się na osobie Maryi, podkreślając, iż Wniebowzięcie było ukoronowaniem Jej ziemskiej drogi i służby, która w sposób szczególny rozpoczęła się podczas Zwiastowania i wypowiedzianych przez Maryję słowach Oto ja, służebnica Pańska, niech mi się stanie według Twego słowa: „W tym momencie w Jej przeczystym łonie zamieszkał Syn Boży, a Ona na Jego służbę  oddała całą swoją egzystencję, oddała Mu Swoje serce. Wniebowzięcie kończyło ziemski etap Jej służby, a jednocześnie było początkiem Jej nowego posłannictwa jako Królowej Nieba i Ziemi oraz Matki Kościoła. Odtąd towarzyszy nam nieustannie na naszych drogach prowadzących do wieczności; odtąd, jak dobra matka, jest obecna w naszych troskach, smutkach, radościach i nadziejach”.</div>\n<div></div>\n<div>Zdaniem ks. kardynała Maryja rzadko wypowiadała się na kartach Ewangelii, jednak Jej postawa, miłość i służba, mówiły znacznie więcej, aniżeli słowa. Wyjątek stanowi hymn „Magnificat”, w którym do głosu doszło Jej serce: „W naszym dzisiejszym zbiorowym Magnificat  dziękujemy Maryi za to, że została Królową naszego narodu i że nasza polska ziemia została pokryta siecią Jej sanktuariów, do których zdąża wierny lud powierzając Najlepszej Matce swoje bóle, utrapienia, pragnienia i nadzieje. Tu, w Licheniu, dziękujemy Jej, że wybrała sobie tę piękną krainę, by spotkać się ze swymi dziećmi, by wsłuchiwać się uważnie w ich prośby, by umacniać ich swoją macierzyńską miłością” – mówił kardynał.</div>\n<div></div>\n<div>W odniesieniu do licheńskiego wizerunku Matki Bożej kard. Dziwisz zwrócił uwagę na dwa szczegóły: symbole męki Chrystusa znajdujące się na obrzeżach Jej szaty oraz białego orła w koronie znajdującego się na piersi Maryi.</div>\n<div></div>\n<div>W dalszej części homilii hierarcha wskazywał na naukę jaka płynie dziś z Cudownego wizerunku Matki Bożej Licheńskiej. Mówił: „Zachęca nas, abyśmy byli mądrzy i czujni, byśmy nie ulegali potrzebom złego ducha, strzegli skarbów wiary w naszych sercach. Bolesna Królowa, zatroskana o nasz los, znając nasze słabości i wady, zachęca nas, byśmy stale się nawracali, uwalniali od tego wszystkiego, co deformuje w nas obraz dzieci Bożych. Ona zachęca nas, byśmy szli odważnie za Jej Synem i trwali wiernie we wspólnocie Kościoła, który jest jego dziełem”.</div>\n<div></div>\n<div>Na zakończenie dzisiejszej liturgii zostały poświęcone kwiaty i zioła przyniesione do świątyni przez wiernych, gdyż święto Matki Bożej Wniebowziętej to także  uroczystość Matki Bożej Zielnej.</div>\n<div></div>\n<div>Od minionego piątku, 11 sierpnia, w licheńskim Sanktuarium wierni modlili się i przygotowywali, aby podziękować Bogu za dar koronacji wizerunku Pani Licheńskiej, której pół wieku temu, 15 sierpnia 1967 roku, dokonał w Licheniu kard. Stefan Wyszyński, Prymas Tysiąclecia.</div>', 'Uroczystość Wniebowzięcia Najświętszej Maryi Panny z udziałem kard. Stanisława Dziwisza', '', 'trash', 'open', 'open', '', 'uroczystosc-wniebowziecia-najswietszej-maryi-panny-z-udzialem-kard-stanislawa-dziwisza__trashed', '', '', '2017-10-23 15:48:31', '2017-10-23 15:48:31', '', 0, 'http://gminaslesin.futurehost.pl/?p=546', 0, 'post', '', 0),
 (553, 1, '2017-08-16 00:06:17', '2017-08-15 22:06:17', '[caption id="" align="alignleft" width="257"]<a href="http://umig.slesin.pl/aktualnosci/583/odkrywka-oscislowo"><img class="" src="http://umig.slesin.pl/userfiles/images/galeria.png" width="257" height="198" /></a> Źródło: slesin.pl[/caption]\n\n<strong>Ponad 70 lat temu zaczęło się wielkie kopanie brunatnego paliwa w regionie konińskim. Kopalnia Węgla Brunatnego „Konin” otwierała w tym czasie kolejne odkrywki – Morzysław,  Gosławice, Pątnów, Kazimierz, Jóźwin, Lubstów, Jóźwin IIB, Drzewce, Tomisławice.</strong>\n\n<!--more-->\n\nMiejscowi górnicy wraz z tutejszą ludnością świętowali kolejne Barbórki i kolejne „okrągłe” miliony wydobytego węgla.\nPAK KWB Konin S.A.  czyni starania o pozyskanie koncesji na budowę kolejnej odkrywki – „Ościsłowo”.  W związku z tym Spółka  uruchomiła w Internecie stronę  <strong>www.oscislowo.pl. </strong>\nPowody i cele związane z nową stroną opierają się głównie na prowadzeniu nowoczesnej\ni funkcjonalnej formy kontaktu ze społeczeństwem. Kopalnia chce w ten sposób dotrzeć\nz szeroką informacją  do osób, rodzin, grup społecznych, władz samorządowych itp. zainteresowanych problematyką związaną z budową nowej odkrywki węgla brunatnego „Ościsłowo”.  Ma ona powstać na terenie trzech gmin - Ślesin, Skulsk i Wilczyn, a więc zasięg terytorialny i społeczny tego przedsięwzięcia jest  znaczny.\n\n<strong>Co internauta znajdzie na w<a href="http://www.oscislowo.pl/">ww.oscislowo.pl</a>? </strong>\n<a href="http://www.oscislowo.pl/">Strona główna www.oscislowo.pl</a>\n\nPAK KWB Konin S.A. jest częścią Grupy Kapitałowej ZE PAK S.A. i z tego powodu na stronie internetowej znajduje się m.in. informacja i na temat spółki wiodącej, czyli ZE PAK S.A., jaki samej kopalni.\nChcemy w sposób profesjonalny ukazać ponad 70. letnią historię pozyskiwania węgla brunatnego         w okolicach Konina. Z tym bezpośrednio wiąże się prezentacja wszystkich eksploatowanych na tym terenie odkrywek, ich lokalizacja, zasięg, czas funkcjonowania. Wszystko okraszone oczywiście archiwalnymi, unikalnymi zdjęciami.\nWiele ciekawych wiadomości zainteresowani znajdą na podstronie „FAKTY”. To część naszej strony internetowej, która precyzyjnie, szczegółowo i wiarygodnie wyjaśnia  zasady funkcjonowania kopalni węgla brunatnego, ale również zadaje kłam wszelkiego rodzaju nieprawdziwym, fałszywym informacjom, demaskuje plotki i kłamstwa propagowane przez przeciwników budowy odkrywki i tzw. „pseudoekologów”.\nZ kolei na wszystkich sympatyków fotografii czeka na stronie www.oscislowo.pl „GALERIA” - dobrze, fachowo opisana seria zdjęć ukazujących zarówno samą odkrywkę z jej urządzeniami, jak i piękno zrekultywowanych terenów pokopalnianych, które są przywracane człowiekowi po wyczerpaniu się złóż węglowych.\n\n&nbsp;\n\n<a href="http://oscislowo.pl/?page_id=2247" target="_blank" rel="noopener">Podstrona www.oscislowo.pl zawierająca galerię zdjęć</a>\n\nWażną częścią nowej strony internetowej jest podstrona zatytułowana „OCHRONA ŚRODOWISKA”. Ważną, bo tematu tego nie da się ani uniknąć, ani pominąć. Odkrywka funkcjonuje bowiem\nw środowisku naturalnym, jest nim otoczona i po okresie eksploatacji w pełnym wymiarze do tego środowiska powraca. Cykl ten można by w skrócie opisać jako: okres przygotowawczy - budowa odkrywki - eksploatacja - zakończenie wydobycia - rekultywacja - nowa rzeczywistość.                     Nowa rzeczywistość to powrót terenu pokopalnianego do ponownego użytkowania  przez człowieka       w formie zasobów rekreacyjnych, leśnych lub rolniczych.\nKolejną, istotną aplikacją strony będzie „ANKIETA”, która pozwoli wypowiadać się zainteresowanym internautom w sprawach, które ich nurtują lub które wymagają upublicznienia i uregulowania. Ankiety będą się zmieniać i dotyczyć będą różnych tematów i problemów, z którymi spotykają się lokalne społeczności gmin Skulsk, Wilczyn czy Ślesin. Ta aplikacja, wspólnie z podstroną „AKTUALNOŚCI” umożliwi systematyczne odnawianie strony i informowanie o  bieżących sprawach dotyczących samej odkrywki, jak i otoczenia, w którym  będzie funkcjonowała.\nZachęcamy do dzielenia się uwagami na temat strony oraz propozycjami zmian. Wszelkiego typu komentarze, nawet te najbardziej krytyczne będą mile widziane. Czekamy pod adresem <a href="mailto:oscislowo@kwbkonin.pl">oscislowo@kwbkonin.pl</a>\n\n[caption id="" align="alignleft" width="1068"]<a href="http://umig.slesin.pl/aktualnosci/583/odkrywka-oscislowo"><img class="size-medium" src="http://umig.slesin.pl/userfiles/images/galeria.png" width="1068" height="823" /></a> Źródło: slesin.pl[/caption]\n\n&nbsp;', 'Więcej informacji o odkrywce Ościsłowo', '', 'trash', 'open', 'open', '', 'wiecej-informacji-o-odkrywce-oscislowo__trashed', '', '', '2017-10-23 15:48:31', '2017-10-23 15:48:31', '', 0, 'http://gminaslesin.futurehost.pl/?p=553', 0, 'post', '', 0),
 (554, 1, '2017-08-15 23:28:46', '2017-08-15 21:28:46', '<a href="http://umig.slesin.pl/"><img class="alignleft size-medium wp-image-555" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/IMG_1837-300x198.jpg" alt="" width="300" height="198" /></a>Uprzejmie informuję, że została uruchomiona procedura ubiegania się o środki finansowe  m.in. na wypłatę zasiłków celowych dla poszkodowanych rodzin i osób samotnie gospodarujących, które poniosły straty w gospodarstwach domowych (budynkach mieszkalnych, podstawowym wyposażeniu gospodarstw domowych) i znalazły się w szczególnie trudnej sytuacji życiowej, w której nie mogą zaspokoić niezbędnych potrzeb bytowych w oparciu o posiadane środki własne.\nPomoc taka udzielana jest w formie zasiłku celowego przyznawanego na podstawie art. 39 ust. 1 i 2 oraz art. 40 ust. 2 i 3 ustawy z dnia 12 marca 2004 r. o pomocy społecznej (Dz.U z 2016 r. poz.930 z późn. zm.).\n\n<strong>Pomoc jest udzielana na wniosek osoby uprawnionej. </strong>\n<strong>W Gminie Ślesin realizacją tego zadania zajmuje się Miejsko - Gminny Ośrodek Pomocy Społecznej w Ślesinie ul. Kleczewska 15; 62-561 Ślesin ( tel. 63 270-40-87).</strong>\n\nProszę wszystkich poszkodowanych o jak najszybsze zgłoszenie zaistniałych strat  w gospodarstwach domowych (budynkach mieszkalnych, podstawowym wyposażeniu gospodarstw domowych) i złożenie wniosku o udzielenie pomocy.\n\n&nbsp;\n\nŹródło: Urząd Miasta i Gminy Ślesin', 'Pomoc dla poszkodowanych', '', 'trash', 'open', 'open', '', 'pomoc-dla-poszkodowanych__trashed', '', '', '2017-10-23 15:48:31', '2017-10-23 15:48:31', '', 0, 'http://gminaslesin.futurehost.pl/?p=554', 0, 'post', '', 0),
 (562, 1, '2017-08-16 15:42:08', '2017-08-16 13:42:08', '<strong><a href="http://www.przegladkoninski.pl/PL-H5/3/4461/policjanci-podsumowali-dlugi-weekend-29-latek-zatrzymany-za-zniewazenie-funkcjonariuszy.html"><img class="alignleft " src="http://www.przegladkoninski.pl/data/catalogue/StLS03NDU3My1EU0NfOTAxOS5KUEc=.jpg" width="204" height="126" /></a>– W Licheniu Starym złodziej wszedł na teren działki budowlanej i przeciął łańcuch od garażu, z którego wyniósł agregat prądotwórczy, tynkowo-malarski oraz wiertarkę</strong> – wymienia Zbigniew Janusz, rzecznik prasowy Komendy Miejskiej Policji w Koninie. – Straty oszacowane zostały na 9,5 tysiąca złotych.<!--more-->\n\n<img class="size-medium wp-image-522 alignright" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="300" height="78" />Bez ofiar śmiertelnych na drogach oraz poważnych zdarzeń upłynął długi weekend w Koninie i regionie. W ciągu czterech dni doszło do jednego wypadku, w którym ranny został 18-letni motorowerzysta. Policjanci zatrzymali 10 praw jazdy i nałożyli na kierowców prawie 300 mandatów. Do izby zatrzymań trafił 29-letni mężczyzna, który miał znieważyć i kopnąć funkcjonariuszy.\n\nWypadek, w którym ranny został 18-latek, wydarzył się w Budzisławiu Kościelnym. 37-letni kierowca peugeota podczas skrętu w lewo uderzył w młodego mieszkańca gminy Kleczew. Poszkodowany został przewieziony do szpitala ze zwichniętym obojczykiem i złamaną nogą.\n\nW ciągu pięciu dni doszło także do ponad 40 kolizji. Policjanci namierzyli pięciu pijanych kierowców samochodów i 11 nietrzeźwych rowerzystów.\n\nNiestety, znać o sobie dali złodzieje. Najbardziej zuchwałą kradzież odnotowano 15 sierpnia na przystanku PKS przy ulicy Dworcowej w Koninie. Nieznany sprawca okradł emeryta wyjmując mu z kieszeni koszuli portfel dokumentami i pieniędzmi (ponad 500 złotych).\n\nNieznani sprawcy włamali się też do domku letniskowego przy ulicy Gajowej, do którego dostali się przez lufcik. Skradli elektronarzędzia warte ponad 2 tysiące złotych.\n\nWczoraj około godziny 23.20 na ulicy Dworcowej 29-letni mężczyzna znieważył umundurowanych policjantów .\n\n– Jednego z nich miał kopnąć. Jeśli ten zarzut się potwierdzi, odpowie także za naruszenie nietykalności cielesnej funkcjonariuszy – dodaje rzecznik.\n\nŹródło: Przegląd Koniński', 'Policjanci podsumowali długi weekend', '', 'trash', 'open', 'open', '', 'policjanci-podsumowali-dlugi-weekend__trashed', '', '', '2017-10-23 15:48:31', '2017-10-23 15:48:31', '', 0, 'http://gminaslesin.futurehost.pl/?p=562', 0, 'post', '', 0),
 (565, 1, '2017-08-16 15:48:35', '2017-08-16 13:48:35', '<strong><a href="http://www.przegladkoninski.pl/PL-H5/3/4450/50-lecie-koronacji-cudownego-obrazu-matki-bozej-lichenskiej-na-kartce-pocztowej.html"><img class="alignleft " src="http://www.przegladkoninski.pl/data/catalogue/StLS03NTk5OTMta2FydGthLW9rb2xpY3pub8WbY2lvd2EtMjNQb3puYcWELTEuanBn.jpg" width="247" height="175" /></a>Uroczystości poświęcone 50-leciu koronacji Cudownego Obrazu Matki Bożej Licheńskiej właśnie się skończył. Dokonał tego 15 sierpnia 1967 roku prymas Polski Stefan Wyszyński.</strong>\n\nW związku z tą rocznicą, Poczta Polska wydawała i wprowadziła do obrotu 12 sierpnia kartki okolicznościowe w nakładzie 500 sztuk. Jak czytamy na stronie internetowej Poczty Polskiej, sprzedawane są w Urzędach Pocztowych w Ślesinie, Koninie oraz Poznaniu.\n\nŹródło: Marcin Szafrański - Przegląd Koniński', '50-lecie koronacji Cudownego Obrazu Matki Bożej Licheńskiej na kartce pocztowej', '', 'trash', 'open', 'open', '', '50-lecie-koronacji-cudownego-obrazu-matki-bozej-lichenskiej-na-kartce-pocztowej__trashed', '', '', '2017-10-23 15:48:31', '2017-10-23 15:48:31', '', 0, 'http://gminaslesin.futurehost.pl/?p=565', 0, 'post', '', 0),
 (568, 1, '2017-08-16 16:04:28', '2017-08-16 14:04:28', '<strong> </strong>\n\n<img class="alignleft wp-image-570" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/jlichenskie-300x200.jpg" alt="" width="257" height="171" />\n\n<strong>Kilkanaście jezior, piaszczyste plaże, a także malownicze tereny leśne i zabytkowe obiekty sakralno-kulturalne. Powiat Koniński zróżnicowany obszarowo, położony w centrum Polski nad rzeką Wartą obfituje w bogactwo walorów turystycznych.</strong> W okresie letnim, ze względu na szeroko rozwiniętą bazę turystyczną, odwiedzany jest przez gości z całego województwa.\n\n<a href="http://wielkopolska.tv/powiat-koninski-turystyczne-tournee-po-powiecie/#/?playlistId=0&amp;videoId=0" target="_blank" rel="noopener">Zobacz materiał promocyjny powiatu TV Wielkopolska.</a>\n\n&nbsp;', 'Turystyczne turnee po powiecie', '', 'trash', 'open', 'open', '', 'turystyczne-turnee-po-powiecie__trashed', '', '', '2017-10-23 15:48:31', '2017-10-23 15:48:31', '', 0, 'http://gminaslesin.futurehost.pl/?p=568', 0, 'post', '', 0),
 (574, 1, '2017-08-16 23:36:12', '2017-08-16 21:36:12', '[caption id="" align="alignleft" width="297"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1737757133193047/1737756056526488/?type=3&amp;theater"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/20799507_1737756056526488_8593412658432290827_n.jpg?oh=0669b8ff33db5829c12ce64a673b965e&amp;oe=5A30B242" width="297" height="198" /></a> facebook.com/mgokslesin/[/caption]\n\n<strong>Tegoroczny Festyn w Szyszynie odbył się pod Patronatem Burmistrza Miasta i Gminy Ślesin 13.08.2017 roku. Od godzin porannych rozpoczęli siatkarze uczestnicząc w III Turnieju Siatkówki Plażowej Sołectw i Osiedli Gminy Ślesin.</strong> Do rozgrywek na świeżo zrekultywowanym boisku stanęło 8 drużyn. <a href="https://www.facebook.com/mgokslesin/photos/pcb.1737757133193047/1737756056526488/?type=3&amp;theater" target="_blank" rel="noopener">Galeria zdjęć.</a><!--more-->W trakcie rywalizacji 4 drużyny zajęły kolejno :\nI miejsce Mateusz Waleriańczyk, Adam Chojnacki\n\nII miejsce Bartosz Nawrocki, Bartłomiej Łukaszewski\n\nIII miejsce Przemysł<span class="text_exposed_show">aw Nowakowski, Łukasz Nowakowski </span>\n\n<span class="text_exposed_show">IV miejsce Wojciech Fryza, Jonasz Dryjer\n</span>\n\n<span class="text_exposed_show">Organizatorzy przygotowali szereg atrakcji: podchody dla dzieci i młodzieży, dmuchane zjeżdżalnie, gry i zabawy dla dzieci, zumbę oraz konkurs „Spacer farmera”. </span><span class="text_exposed_show">W spacerze farmera wygrał:\nI miejsce Rafał Marcinkowski </span>\n\n<span class="text_exposed_show">II miejsce Rafał Szymczak </span>\n\n<span class="text_exposed_show">III miejsce Kamil Kieliszewski </span>\n\n<span class="text_exposed_show">\nNa scenie zaprezentowały się zespoły <em>Pogodna jesień</em> i <em>Stokrotka</em> oraz Tadeusz Działak. </span>\n\n&nbsp;\n\n<span class="text_exposed_show">Festyn został zorganizowany z funduszu Sołeckiego Sołectwa Szyszyn oraz dzięki wsparciu finansowemu: Gasto-Music Justyna i Radosław Witkowcy, Zdzisław Łukaszewski, Paweł Bielicki, Anna i Zbigniew Bieliccy, Dominik i Arleta Niedźwiedzińscy, Andrzej Elerowski, Sławomir i Wioletta Kowalscy, Anna i Marian Ciesielscy, Magdalena i Cezary Kostanscy, Magdalena i Michał Śliwińscy, Justyna Bladziak, Żan-Pol Skup Złomu i Metali Kolorowych w Szyszynie, KGW Szyszyn, OSP Szyszyn. </span>\n\n<span class="text_exposed_show">Organizatorzy: Sołtys, Rada Sołecka Sołectwa Szyszyn, Radny Paweł Bielicki, Koło Gospodyń Wiejskich Szyszyn, Ochotnicza Straż Pożarna Szyszyn.\nWspółpraca: Miejsko-Gminny Ośrodek Kultury w Ślesinie.</span>', 'Festyn w Szyszynie', '', 'trash', 'open', 'open', '', 'festyn-w-szyszynie-2__trashed', '', '', '2017-10-23 15:48:31', '2017-10-23 15:48:31', '', 0, 'http://gminaslesin.futurehost.pl/?p=574', 0, 'post', '', 0),
 (576, 1, '2017-08-16 21:37:39', '2017-08-16 19:37:39', '[caption id="" align="aligncenter" width="720"]<a href="https://scontent-bru2-1.xx.fbcdn.net/v/t31.0-8/p720x720/20819316_1737755373193223_2870100676309769367_o.jpg?oh=cbab35ce0410a8018f8d8c9c8b766759&amp;oe=5A1EF652"><img src="https://scontent-bru2-1.xx.fbcdn.net/v/t31.0-8/p720x720/20819316_1737755373193223_2870100676309769367_o.jpg?oh=cbab35ce0410a8018f8d8c9c8b766759&amp;oe=5A1EF652" alt="" width="720" height="1028" /></a> facebook.com/mgokslesin/[/caption]\n\n&nbsp;', 'Zajęcia w M-GOK Ślesin w roku kulturalnym 2017/2018', '', 'trash', 'open', 'open', '', 'zajecia-w-m-gok-slesin-w-roku-kulturalnym-20172018__trashed', '', '', '2017-10-23 15:48:31', '2017-10-23 15:48:31', '', 0, 'http://gminaslesin.futurehost.pl/?p=576', 0, 'post', '', 0),
 (578, 1, '2017-08-17 17:53:06', '2017-08-17 15:53:06', '<strong><img class="alignleft wp-image-167" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/pexels-photo-274506-300x200.jpeg" alt="" width="143" height="95" />RUNDA VII Sołeckiej Ligi Piłki Nożnej odbędzie się 20. sierpnia 2017 r. na boisku ORLIK  Zespołu Szkolno-Przedszkolnego w Ślesinie.</strong><!--more-->\n\n<u>Kolejność rozgrywanych meczy</u>\n\n1 mecz  8:30 Piotrkowice <strong>11 – 10</strong> Osiedle Powstańców Wielkopolskich\n\n2 mecz 9:40 Osiedle Północ <strong>10 - 1</strong> Wąsosze\n\n3 mecz 10:50 Szyszyńskie Holendry <strong>4 - 4</strong> Szyszyn\n\n4 mecz 12:00 Półwiosek Stary  <strong>7 - 3</strong> Ignacewo\n\n5 mecz 13:10 Głębockie/Mikorzyn <strong>7 – 4</strong> Honoratka\n\n&nbsp;\n\nGospodarzami rundy są drużyny  Głębockie/Mikorzyn – Honoratka.', 'Runda siódma 20 sierpnia', '', 'trash', 'open', 'open', '', 'runda-siodma-20-sierpnia__trashed', '', '', '2017-10-23 15:48:31', '2017-10-23 15:48:31', '', 0, 'http://gminaslesin.futurehost.pl/?p=578', 0, 'post', '', 1),
 (580, 1, '2017-08-18 12:36:49', '2017-08-18 10:36:49', '<a href="http://umig.slesin.pl/userfiles/images/dozynki2017.jpg"><img class="aligncenter size-medium" src="http://umig.slesin.pl/userfiles/images/dozynki2017.jpg" width="724" height="1024" /></a>', 'Dożynki gminno-parafialne', '', 'trash', 'open', 'open', '', 'dozynki-gminno-parafialne__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=580', 0, 'post', '', 0),
 (587, 1, '2017-08-18 20:13:32', '2017-08-18 18:13:32', '[caption id="" align="alignleft" width="282"]<a href="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/20841111_1506028312817477_7684546546643129329_n.jpg?oh=9058e7ddd12d6c8f61595e561124db6d&amp;oe=5A1DA97B"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/20841111_1506028312817477_7684546546643129329_n.jpg?oh=9058e7ddd12d6c8f61595e561124db6d&amp;oe=5A1DA97B" width="282" height="188" /></a> Źródło: facebook.com/SanktuariumLichen/[/caption]\n\n<strong>W najbliższą sobotę 19 sierpnia oraz 27 sierpnia (sobota) o godz 17.30 w auli Domu Pielgrzyma Betlejem zostanie przedstawiony spektakl, w którym będzie zaprezentowana artystyczna wizja objawień Matki Bożej zarówno Tomaszowi Kłosowskiemu, jak i Mikołajowi Sikatce. </strong>\nZapraszamy serdecznie', 'Spektakl o licheńskich objawieniach', '', 'trash', 'open', 'open', '', 'spektakl-o-lichenskich-objawieniach__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=587', 0, 'post', '', 0),
 (589, 1, '2017-08-18 11:15:39', '2017-08-18 09:15:39', '<img class="wp-image-293 alignleft" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/pole.jpg" alt="" width="263" height="198" />\n\n<strong>Każdy rolnik, który chce odzyskać część pieniędzy wydanych na olej napędowy używany do produkcji rolnej, powinien w terminie od 1 sierpnia 2017 r. do 31 sierpnia 2017 r. złożyć odpowiedni wniosek do wójta, burmistrza lub prezydenta miasta, w zależności od miejsca położenia gruntów rolnych wraz z fakturami VAT stanowiącymi dowód zakupu oleju napędowego w okresie od 1 lutego 2017 r. do 31 lipca 2017 r. w ramach limitu zwrotu podatku określonego na 2017 r.</strong>\n<!--more-->Pieniądze wypłacane będą w terminie 1-31 października 2017 r. gotówką w kasie urzędu gminy, albo na rachunek bankowy podany we wniosku.\n\nŹródło: Gazeta  Ślesińska nr 7/78 2017', 'Zwrot podatku akcyzowego', '', 'trash', 'open', 'open', '', '589__trashed', '', '', '2017-10-23 15:48:31', '2017-10-23 15:48:31', '', 0, 'http://gminaslesin.futurehost.pl/?p=589', 0, 'post', '', 0),
 (597, 1, '2017-08-20 22:41:40', '2017-08-20 20:41:40', '[caption id="" align="alignleft" width="210"]<a href="https://www.facebook.com/strazaklichenstary/photos/pcb.937883196349515/937883066349528/?type=3&amp;theater"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t31.0-0/q84/p180x540/20861767_937883066349528_5759102988976671023_o.jpg?oh=df8cbeecb248b80751a6146f76fd7e3c&amp;oe=5A2A7978" width="210" height="157" /></a> facebook.com/strazaklichenstary/[/caption]\n\n<strong>W sobotę 12.08.2017 Strażacy rozegrali pierwszy mecz rundy 2017/2018. Na własnym boisku podejmowali Polanina Strzałkowo.</strong> <!--more-->Niestety nasz zespół przegrał (1:2). B<span class="ffwd_blog_style_object_description_hide">ramkę dla naszej drużyny zdobył w 86 minucie Patryk Kosmowski, nowy nabytek drużyny, który przyszedł z GKS Lisewo. Warto zaznaczyć, że od 34 minuty nasza drużyna musiała grać w osłabieniu po czerwonej kartce dla Łukasza Łajdeckiego.\n\nSkład: WOJCIECHOWSKI MARCIN. ŁAJDECKI ŁUKASZ.(34 CK). KRYGIER PRZEMYSŁAW. LENARTOWSKI KAMIL.WOLINOWSKI ERYK.KRYGIER PAWEŁ. SIEDLECKI KRZYSZTOF .ANDRZEJCZAK KRYSTIAN. JANIAK HUBERT. ŻELICHOWSKI ADRIAN( 60 KOSMOWSKI PATRYK). KŁAS MARCIN.\nRezerwa: PAWLAK ADRIAN. ADAMCZYK SZYMON. JAKUBOWSKI PAWEŁ.</span>', 'Falstart na inaugurację sezonu', '', 'trash', 'open', 'open', '', 'falstart-na-inauguracje-sezonu__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=597', 0, 'post', '', 0),
 (600, 1, '2017-08-21 19:53:57', '2017-08-21 17:53:57', '[caption id="" align="alignleft" width="253"]<a href="https://www.facebook.com/strazaklichenstary/photos/pcb.937884493016052/937884206349414/?type=3&amp;theater"><img class="" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/20954070_937884206349414_564847001231156061_n.jpg?oh=fc18d37642e178fabe9a1322838938d6&amp;oe=5A2D51DF" width="253" height="190" /></a> facebook.com/strazaklichenstary/[/caption]\n\n<strong>STRAŻAK LICHEŃ STARY 3 - 1 POLONIA GOLINA </strong>\n<strong>Siedlecki K.4\'88. Lenartowski K. 40\'.</strong>\n<div class="text_exposed_show"><!--more--><strong>W Odpust Licheński 15.08.2017 przyszło grać naszej drużynie kolejny mecz na własnym boisku, tym razem przeciwnikiem Strażaków była Polonia Golina. Rywal zawsze niewygodny dla naszej drużyny. Tym razem Strażacy wygrali (3:1). </strong>\n\n<strong>B</strong>ramki dla naszej drużyny zdobywali Siedlecki Krzysztof w 4 oraz 88 minucie, który tym samym sprawił sobie prezent urodzinowy - właśnie w tym dniu obchodził swoje 33 urodziny. Kolejne trafienie zaliczył w 40 minucie Kamil Lenartowski, kolejny nowy (stary grał już w drużynie Strażaka ) zawodnik który przyszedł z GKS Sompolno. Licznie zebrani kibice nie mogli narzekać na występ naszej drużyny.\n\nSkład: WOJCIECHOWSKI MARCIN; ŁAJDECKI ŁUKASZ; KRYGIER PRZEMYSŁAW; LENARTOWSKI KAMIL;(80\' ADAMCZYK SZYMON); JAKUBOWSKI PAWEŁ; ŻELICHOWSKI ADRIAN; JANIAK HUBERT; ANDRZEJCZAK KRYSTIAN; SIEDLECKI KRZYSZTOF; ( 89 PAWLAK ADRIAN);  PAWEŁ KRYGIER; (65\' KŁOS MARCIN); KOSMOWSKI PATRYK.\n\nRezerwa: ADAMCZEWSKI WIKTOR.ADAMCZYK SZYMON.KAŻMIERCZAK WALDEMAR.PAWLAK ADRIAN.KŁOS MARCIN.\n\n</div>\n&nbsp;\n\n&nbsp;', 'Golina pokonana', '', 'trash', 'open', 'open', '', 'golina-pokonana__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=600', 0, 'post', '', 0),
 (602, 1, '2017-08-21 20:51:36', '2017-08-21 18:51:36', '[caption id="" align="alignleft" width="736"]<a href="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/20228235_1362630847148775_4663021259118455899_n.jpg?oh=3ad4150eb543fcc0c9ee81b65e87c4e6&amp;oe=5A28AD34"><img class="" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/20228235_1362630847148775_4663021259118455899_n.jpg?oh=3ad4150eb543fcc0c9ee81b65e87c4e6&amp;oe=5A28AD34" width="736" height="385" /></a> facebook.com/QsummerStage[/caption]\n\n<strong>Już 24 sierpnia (czwartek) w Mikorzynie K/Konina (Ośrodek Wityng) będzie miało miejsce wyjątkowe wydarzenie dla miłośników polskiej sceny klubowej. Impreza nosi nazwę Q-Summer Stage i będzie to debiut tej imprezy - organizator (Q-club) zapowiada kontynuowanie i rozwój wydarzenia w przyszłych latach.</strong><!--more-->\n\n<a href="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/20140070_1362757773802749_6705495590813255551_n.png?oh=be9059930ecdcb9fd86903034ef95eaa&amp;oe=5A1E6C5D"><img class="alignright" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/20140070_1362757773802749_6705495590813255551_n.png?oh=be9059930ecdcb9fd86903034ef95eaa&amp;oe=5A1E6C5D" alt="" width="109" height="164" /></a>Cały Ośrodek Wityng w Mikorzynie już 24.08 zamieni się w wielka scenę muzyki klubowej. Organizator na debiut wydarzenia zaprosił takich artystów jak : Hazel, Quiz, Majlo, Mercus, Mavi, Hakan, Arusha, Kulterman, Kumin oraz Power Base. Na terenie ośrodka powstanie małe festiwalowe miasteczko podzielone na różne strefy ( Główna, VIP, foodtruck, grill oraz bary). Scena Główna zostanie umieszczona w hali namiotowej o powierzchni 1000mkw. Całość wyposażona w profesjonalne nagłośnienie i oświetlenie, nie zabraknie też potężnych laserów i wyrzutni CO2. Na placu przed halą namiotową pod wielkimi parasolami będą ustawione foodtrucki, grille i stanowiska z napojami. Na strefie VIP efektowny bar i profesjonalny catering z restauracji Hotelu Wityng. Otwarcie bramy głównej nastąpi o godzinie 16.30 natomiast impreza rozpocznie się o godzinie 18.00 i potrwa do wczesnych godzin porannych. Organizator zapowiada show jakiego jeszcze nie było w Naszym regionie\n\nO oprawę muzyczną zadba grupa aż 10 dj-ów, na której czele stanie DJ Hazel. Najpopularniejszy polski dj i prawdziwa legenda polskiej sceny klubowej, często reklamowanego jako "najszybsze ręce Europy". Rezydent legendarnego klubu Ekwador w Manieczkach. Twórca kultowej "Sprężynki" i takich mega-hitów jak: "Let\'s do This", "I Love Poland", "Get Down", "Sunshine" czy najnowszego "Let Me Hear The DJ"\n\n"Obserwując rynek oraz imprezy, które towarzyszą Naszemu regionowi stwierdziliśmy, że tego typu impreza będzie się cieszyła dużym zainteresowaniem. Biorąc pod uwagę Nasze doświadczenia i kontakty z artystami w świecie muzyki klubowej zdecydowaliśmy się na organizacje imprezy, która zaskoczy świetnymi artystami oraz wieloma niespodziankami, które wywołają pozytywne emocje wśród wszystkich uczestników imprezy. Chciałbym też podziękować za pomoc i profesjonalne wsparcie w organizacji wydarzenia Naszemu partnerowi strategicznemu - Agencji Marketingowej\nJB Grupa jak i również Hotelowi Wityng”- informuje organizator imprezy Jacek Błaszczak (Q-club)\n\nBilety dostępne w przedsprzedaży do dnia imprezy pod numerem telefonu: 796 977 790 oraz w kasach biletowych od 16.30 w dniu imprezy (na terenie Hotelu Wityng) czyli 24.08.2017 (czwartek).\n\nBilety w cenie: 25zł\n\nBilety na strefę VIP: 80zł\n\nWięcej informacji:\nfacebook.com/QsummerStage\n\n&nbsp;\n\nŹródło: konin.LM.pl\n\n&nbsp;', 'W najbliższy czwartek festiwal jakiego jeszcze nie było!', '', 'trash', 'open', 'open', '', 'w-najblizszy-czwartek-festiwal-jakiego-jeszcze-nie-bylo__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=602', 0, 'post', '', 0),
 (608, 1, '2017-08-22 22:07:25', '2017-08-22 20:07:25', '<img class=" alignleft" src="https://images.pexels.com/photos/120243/pexels-photo-120243.jpeg?w=940&amp;h=650&amp;auto=compress&amp;cs=tinysrgb" width="200" height="134" />\n\n<strong>"Ocalić od zapomnienia - zabytki powiatu konińskiego" - to hasło konkrusu dla seniorów organizowanego przez Starostę Konińskiego i Radę Seniorów Powiatu Konińskiego.</strong>\n\n<a href="http://umig.slesin.pl/userfiles/files/Regulamin_Konkursu_Fotograficznego.pdf" target="_blank" rel="noopener">Regulamin Konkursu Fotograficznego</a>\n\n<a href="http://umig.slesin.pl/userfiles/files/Formularz_zgloszeniowy_Konkurs_Fotograficzny.pdf" target="_blank" rel="noopener">Formularz zgłoszeniowy Konkurs Fotograficzny</a>\n\nWykonane zdjęcia można przesyłac do 31 października 2017 r.', 'Ocalić od zapomnienia - konkurs fotograficzny dla seniorów', '', 'trash', 'open', 'open', '', 'ocalic-od-zapomnienia-konkurs-fotograficzny-dla-seniorow__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=608', 0, 'post', '', 0),
 (610, 1, '2017-08-22 22:08:54', '2017-08-22 20:08:54', '<div style="text-align: center;"><strong><img class="alignleft wp-image-555" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/IMG_1837-300x198.jpg" alt="" width="349" height="230" />OBWIESZCZENIE</strong>\n<strong>BURMISTRZA  MIASTA I GMINY ŚLESIN Z 22 SIERPNIA  2017 ROKU</strong></div>\n<strong>Informuję, że <u> 25 sierpnia  2017 roku (piątek) o godz. 10.30 w sali posiedzeń Urzędu Miasta i Gminy w Ślesinie odbędzie  się  XXXII  sesja Rady Miejskiej Gminy Ślesin</u>.</strong>\n<div>Burmistrz Miasta i Gminy\n/-/ <em>Mariusz Zaborowski  </em></div>\n<!--more-->\n\nNa podstawie art. 20 ust. 1 ustawy z dnia 08 marca 1990 roku o samorządzie gminnym (Dz. U. z 2016 r., poz.446 ze zm.)  z w o ł u j ę  <strong><u>XXXII sesję Rady Miejskiej Gminy Ślesin  na 25 sierpnia 2017 roku (piątek) na godz. 10.30 w  sali posiedzeń Urzędu Miasta  i Gminy w Ślesinie,</u></strong>  z następującym porządkiem obrad:\n<ol>\n 	<li>Otwarcie sesji  i stwierdzenie quorum.</li>\n 	<li>Przyjęcie  porządku obrad.</li>\n 	<li>Przyjęcie protokołu XXXI sesji Rady Miejskiej Gminy Ślesin.</li>\n 	<li>Interpelacje i zapytania radnych.</li>\n 	<li>Zaopiniowanie projektów uchwał RM w sprawie:</li>\n</ol>\n<div>1) zmian budżetu na 2017 r.,\n2) o zmianie uchwały w sprawie uchwalenia Wieloletniej Prognozy Finansowej Miasta i Gminy Ślesin na lata 2017-2036,\n3) zmiany nazw ulic położonych na terenie miasta Ślesina,\n4) zatwierdzenia wyników kontroli kwot rekompensaty całkowitej wypłaconej MZGOK Sp. z o.o. w Koninie w roku 2016,\n5) nadania nazwy ulicy,\n6) zatwierdzenia i przyjęcia do realizacji Partnerskiego projektu pt.  „Kopalnia kompetencji – rozwój edukacji gimnazjalnej na terenie K OSI”, nr RPWP.08.01.02-30-0052/16 w ramach Wielkopolskiego Regionalnego Programu Operacyjnego na lata 2014-2020, Oś Priorytetowa 8 Edukacja, Działanie 8.1, Ograniczenie i zapobieganie przedwczesnemu kończeniu nauki szkolnej oraz wyrównanie dostępu do edukacji przedszkolnej i szkolnej,  Poddziałanie 8.1.2 Kształcenie ogólne – projekty konkursowe, współfinansowanego  ze środków Unii Europejskiej, w ramach Europejskiego Funduszu Społecznego,\n7) nabycia prawa użytkowania wieczystego oraz prawa własności nieruchomości położonej w obrębie Bylew.</div>\n<ol>\n 	<li value="6">Wolne wnioski.</li>\n 	<li>Zakończenie obrad.</li>\n</ol>\n&nbsp;\n<div>Przewodniczący Rady\n/-/ <em>Stanisław Chrzanowski</em></div>', 'XXXII  sesja Rady Miejskiej Gminy Ślesin', '', 'trash', 'open', 'open', '', 'xxxii-sesja-rady-miejskiej-gminy-slesin__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=610', 0, 'post', '', 0),
 (612, 1, '2017-08-22 22:16:16', '2017-08-22 20:16:16', '[caption id="" align="alignleft" width="300"]<a href="http://www.lichen.pl/userfiles/images/PLAKAT%20LICHEn.jpg"><img class="" src="http://www.lichen.pl/userfiles/images/PLAKAT%20LICHEn.jpg" width="300" height="424" /></a> lichen.pl[/caption]\n\n<strong>Piknik z mamą i tatą przed licheńską bazyliką</strong>\n\n<strong>Do udziału w Pikniku z mamą i tatą, który w ostatnią niedzielę wakacji odbędzie się przed licheńską bazyliką, zapraszają księża marianie. (27.08).  </strong>\n\nPrzed rozpoczęciem zabawy, dzieci wraz ze swoimi rodzicami i dziadkami zaproszone są do udziału w niedzielnej Mszy św. o godz. 12.00, podczas której otrzymają indywidualne błogosławieństwo przed rozpoczęciem nowego roku szkolnego.\n\nW trakcie pikniku, który rozpocznie się po Mszy św., dzieci będą mogły skorzystać z licznych atrakcji, przygotowanych dla nich z tej okazji. Do wyboru będzie m.in.: basen z kulami wodnymi, zamki, dmuchańce, mega-dart, bramka celnościowa, kącik plastyczny, malowanie buziek, rzut obręczą, rzut workiem na odległość, strzał do bramki unihokeja, przeciąganie liny, slalom w alko-goglach, mega-skakanka oraz podchody rodzinne pod hasłem „Rodzina z katechezą za pan brat”.\n\nW trakcie pikniku na scenie zaprezentują się także wokaliści z Konińskiego Domu Kultury. Z kolei dla maluchów przygotowano dziecięce tańce, tor przeszkód, bujaki oraz specjalną strefę malucha.\n\nPiknik potrwa do godz. 16.30. Jego organizatorem jest Licheńskie Centrum Pomocy Rodzinie i Osobom Uzależnionym.\n\nLicheń Stary, 22 sierpnia 2017 r.', 'Piknik z mamą i tatą przed licheńską bazyliką', '', 'trash', 'open', 'open', '', 'piknik-z-mama-i-tata-przed-lichenska-bazylika__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=612', 0, 'post', '', 0),
 (620, 1, '2017-08-23 15:03:10', '2017-08-23 13:03:10', '<strong><img class="alignleft size-medium wp-image-621" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/Plakat-212x300.jpg" alt="" width="212" height="300" />Jednostka Strzelecka 4057 w Koninie, Związku Strzeleckiego "Strzelec" Józefa Piłsudskiego działa aktywnie w naszym mieście już ponad rok! W tym czasie można było nas spotkać na niemal każdym święcie, na festynach, na WOŚPie, podczas kwest, w szkołach i przedszkolach, na Pikniku Patriotycznym i wielu innych.</strong><!--more-->\n\nPrzez ten rok członkowie naszej Jednostki Strzeleckiej:\n-Przechodzili szkolenia z pierwszej pomocy\n-Uzyskiwali certyfikaty\n-Wyjeżdżali na kursy doskonalące\n-Odwiedzali i odbywali zajęcia na terenie Jednostek Wojskowych\n-Nauczyli się odpowiedzialności i braterstwa\n-Spędzali wspólnie czas zawierając nowe przyjaźnie i przeżywając przygody\n\nKim jesteśmy? - Jesteśmy ogólnopolską apolityczną pozarządową organizacją proobronną przygotowującą młodzież do służby w formacjach mundurowych. Kontynuujemy tradycje przedwojennego Związku Strzeleckiego działającego również na terenie Konina do 1939 roku.\n\nWspółpracujemy m.in. z Ochotniczą Strażą Pożarną w Koninie, Klubem Strzelectwa Sportowego.\n\nJeśli:\n-masz minimum 15 lat\n-jesteś niekarany\n-chcesz założyć mundur\n-poznać ciekawych ludzi\n-przeżyć przygodę\n-przygotować się do przyszłej służby w mundurze\n-chcesz ciekawie spędzać weekendy w gronie zgranych ludzi\n\nNapisz do nas: <a>js4057konin@gmail.com</a> i odwiedź naszą stronę internetową: <a href="http://js4057.konin.pl/" target="_blank" rel="noopener">js4057.konin.pl</a>\n\nNabór trwa do końca września\n\nNie czekaj, zostań jednym z Nas... Zostań Strzelcem...', 'Strzelcy Rekrutują!', '', 'trash', 'open', 'open', '', 'strzelcy-rekrutuja__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=620', 0, 'post', '', 0),
 (622, 1, '2017-07-21 21:59:35', '2017-07-21 21:59:35', '<strong> <center>Regulamin Portalu Gminy Ślesin</center></strong>\n\n<strong>Umieszczając swój komentarz prosimy pamiętać, aby w dyskusji nie zapominać o kulturze wypowiedzi, przestrzeganiu prawa oraz szacunku do innych użytkowników serwisu.</strong>\n\n<strong><span style=\'color:red\'>Każdy użytkownik serwisu publikuje swoje komentarze i opinie wyłącznie na własną odpowiedzialność. Portal Gminy Ślesin nie ponosi jakiejkolwiek odpowiedzialności za treści zamieszczane przez Użytkowników na łamach serwisu.</span></strong>\n\n<strong>§ 1 Zasady ogólne</strong>\n\n* Niniejszy regulamin jest udostępniany w celu zapoznania się z ogólnymi zasadami działania serwisu.\n* Każdy użytkownik serwisu gminaslesin.hostpark.pl udzielający wypowiedzi lub zakładający konto w serwisie zgadza się na warunki oraz akceptuje niniejszy regulamin.\n* Redakcja Serwisu Gminy Ślesin gminaslesin.hostpark.pl ma prawo do usuwania wybranych materiałów, postów użytkowników, bądź ich kont jeśli będą one naruszały niniejszy regulamin, m.in. w przypadku:\n- wzywania do popełnienia przestępstw, treści sprzecznych z zasadami współżycia społecznego, naruszania dobrego imienia, wzywania do nienawiści rasowej, wyznaniowej czy etnicznej, propagowania przemocy,\n- używania słów powszechnie uznawanych za wulgarne, bądź nieprzyzwoite lub zawierające analogiczne treści niewerbalne (zdjęcia, grafiki etc.),\n- pisania postów z kont o tym samym adresie IP, czyli dopuszczania się tzw. "dyskusji samego ze sobą",\n- zamieszczania danych osobowych lub adresowych osób trzecich oraz publicznego kierowania w ich stronę pomówień lub obraźliwych treści,\n- niezgodności wpisu z tematem komentowanego artykułu,\n- umieszczania treści obscenicznych i obraźliwych wobec osób trzecich, naruszania zasad Netykiety.\n* Jeśli dana wypowiedź łamie obowiązujące zasady prosimy o poinformowanie o tym Administratora. Wypowiedź zgłoszona do Administratora może zostać usunięta. \n* Wpisy niezalogowanych użytkowników są zamieszczane po uprzedniej akceptacji administratora portalu.\n* Każdy użytkownik serwisu ma prawo zgłosić do Administratora post/komentarz, który jego zdaniem narusza wyżej wymienione zasady oraz w jakikolwiek inny sposób narusza dobra osobiste osób trzecich.\n* Decyzja usunięcia bądź zablokowania konta użytkownika jest komunikowana danemu użytkownikowi za pomocą adresu e-mail podanego przy rejestracji.\n\n<strong>§ 2 Treść strony</strong>\n\n* Serwis gminaslesin.hostpark.pl ma charakter informacyjny..\n* Administracja serwisu ma prawo do zmiany, bądź usunięcia ze strony materiałów, łamiących zasady użytkowania serwisu kont użytkowników lub umieszczonych przez nich treści.\n\n<strong>§ 3 Zasady użytkownika</strong>\n\n* Użytkownik powinien odpowiednio zabezpieczyć swoje konto przed włamaniem. Użytkownik zobowiązuje się do ustawienia bezpiecznego, trudnego do odgadnięcia dla osób niepowołanych hasła.\n* W razie podejrzenia niepowołanego korzystania z konta użytkownika powinno się niezwłocznie zgłosić ten fakt administratorowi serwisu gminaslesin.hostpark.pl\n* Treści publikowane przez użytkowników Portalu Gminy Ślesin gminaslesin.hostpark.pl w komentarzach i profilu muszą być zgodne z ogólnie przyjętymi zasadami etykiety i dobrego wychowania. Używanie przekleństw, pomówień, ubliżanie lub zamieszczanie ewidentnie niestosownych do profilu serwisu informacji będzie podlegało stosownym działaniom ze strony administratora serwisu gminaslesin.hostpark.pl\n* Zabrania się działań mogących zakłócić pracę serwisu lub utrudnić do niego dostęp przez innych użytkowników.\n* Zabrania się wykorzystywania serwisu gminaslesin.hostpark.pl do rozpowszechniania lub rozsyłania niepożądanych informacji handlowych (spam).\n* Zabrania się umieszczania odnośników (linków) lub adresów stron internetowych zawierających treści pornograficzne, obsceniczne, wulgarne, zawierające nielegalne oprogramowanie, stron z torrentami powiązanymi z nielegalnym oprogramowaniem lub muzyką i filmami, i wszystkie inne naruszające prawa serwisu.\n* Posiadając profil użytkownik wyraża zgodę na przetwarzanie danych zawartych w profilu zgodnie z ustawą o ochronie danych osobowych w celach utrzymania konta.\n\n<strong>§ 4 Prawa użytkownika</strong>\n\n* Użytkownik ma prawo do swobodnego korzystania z serwisu gminaslesin.hostpark.pl, tj. jego publicznych zasobów.\n* Użytkownik ma prawo do swobodnego korzystania z własnego konta nie łamiąc jednocześnie zasad oraz regulaminu użytkowania serwisu gminaslesin.hostpark.pl.\n* Użytkownik ma prawo do umieszczania komentarzy do materiałów zamieszczonych w serwisie gminaslesin.hostpark.pl.\n* Użytkownik ma prawo do likwidacji swego konta w dowolnym dla siebie momencie.\n\n<strong>§ 5 Prawa serwisu gminaslesin.hostpark.pl</strong>\n\n* Serwis ma prawo do zmiany parametrów konta użytkownika.\n* Serwis ma prawo zmiany swojej funkcjonalności oraz swojego wyglądu.\n* Serwis ma prawo do okresowego wyłączenia lub zawieszenia strony gminaslesin.hostpark.pl bez wcześniejszego powiadomienia użytkowników.\n* Serwis ma prawo usuwania konta łamiących niniejszy regulamin użytkowników.\n* Serwis ma prawo do własnego redagowania treści i zawartości serwisu lub treści zamieszczanych przez użytkowników serwisu. \n* Serwis ma prawo do zmiany lub modyfikacji niniejszego regulaminu.\n\n<strong>§ 6 Odpowiedzialność Serwisu</strong>\n\n* Serwis nie ponosi odpowiedzialności za umieszczane przez użytkowników treści na stronie gminaslesin.hostpark.pl\n* Serwis nie ponosi odpowiedzialności za wykorzystywanie zawartych w nim materiałów bądź treści przez użytkowników lub osoby trzecie.\n* Serwis nie ponosi odpowiedzialności za treści reklamowe i usługi z nimi związane, które nie są wykonywane przez serwis gminaslesin.hostpark.pl\n* Serwis nie ponosi odpowiedzialności za spowodowaną czynnikami zewnętrznymi utratę danych zamieszczonych przez użytkownika na serwisie gminaslesin.hostpark.pl\n* Serwis nie ponosi odpowiedzialności za wykorzystanie przez osoby trzecie utraconych danych użytkownika serwisu gminaslesin.hostpark.pl spowodowanych słabym lub niestarannym zabezpieczeniem dostępu do swojego profilu.\n* Wszystkie treści oraz materiały umieszczane przez użytkowników serwisu gminaslesin.hostpark.pl są rejestrowane: numery IP z których umieszczane są dane osobowe i wpisy, mogą w świetle obowiązującego prawa być przekazane organom państwowym w celach zapobiegania lub ścigania przestępstw.\n', 'Regulamin', '', 'trash', 'open', 'open', '', 'about__trashed', '', '', '2017-10-24 19:11:16', '2017-10-24 19:11:16', '', 251, 'http://test20718.futurehost.pl/?page_id=2', 0, 'page', '', 0),
 (628, 1, '2017-08-23 18:23:53', '2017-08-23 16:23:53', '[caption id="" align="alignleft" width="283"]<a href="https://www.facebook.com/lksslesin/photos/a.131120317484474.1073741829.123946521535187/144807022782470/?type=3&amp;theater"><img class="" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/20953151_144807022782470_2234156396086789806_n.jpg?oh=8d7845796c55a0fc1d37285297d2fd1f&amp;oe=5A2BE2C3" width="283" height="166" /></a> Źródło: Anna Wesołowska / facebook.com/lksslesin[/caption]\n\n<strong>Wczoraj odbył się w Ślesinie mecz 1. rundy Pucharu Polski, w którym to nasi zawodnicy podejmowali drużynę Wilków Wilczyn.</strong>\n\n<!--more-->\nPierwsza bramka pada niestety dla gości, walcząc o "głowę" Arkadiusz Jańczak pechowo uderza piłkę ręką, przez co sędzia wskazuje na wapno a "Wilki" pewnym strzałem wychodzą na prowadzenie. Chwilę przed końcem pierwszej połowy do wyrównania pięknym technicznym strzałem doprowadza kapitan Skicioków - Micha<span class="text_exposed_show">ł Kwiatkowski. Na drugą połowę nasi zawodnicy wychodzą mocno zmotywowani, widać po m.in po rajdach Bartka Nowaka czy Marcina Marciszaka, którzy to kilkukrotnie ośmieszali obrońców rywali w walce 1 na 1, jednak ciągle brakowało tego najważniejszego - zwycięskiego gola. Około 80 minuty zrehabilitował się Arek Jańczak, który trafia bramkę na 2:1, która później okazała się bramką na wagę awansu Ślesinian do kolejnej rundy!</span>\n<div class="text_exposed_show">\n\nLKS Ślesin wystąpił w spotkaniu w następującym składzie:\nDawid Siwek - Kornel Broniszewski, Kacper Gotowała, Bartłomiej Siek, Sebastian Szczeciński (81\' Sebastian Laskowski) - Filip Jasiecki, Michał Kwiatkowski (C) - Bartek Nowak (89\' Wojciech Imbiorowicz), Arkadiusz Jańczak, Marcin Marciszak (70\' Artur Marciniak) - Rafał Czapski (45\' Adrian Górecki) .\n\nBramki trafiali:\n- Michał Kwiatkowski <span class="_5mfr _47e3"><img class="img" role="presentation" src="https://www.facebook.com/images/emoji.php/v9/f36/1.5/16/26bd.png" alt="" width="16" height="16" /><span class="_7oe">⚽</span></span>\n- Arkadiusz Jańczak <span class="_5mfr _47e3"><img class="img" role="presentation" src="https://www.facebook.com/images/emoji.php/v9/f36/1.5/16/26bd.png" alt="" width="16" height="16" /><span class="_7oe">⚽</span></span>\n\nLKS ŚLESIN 2:1 WILKI WILCZYN\n\nŹródło: facebook.com/lksslesin/\n\n</div>', 'LKS w kolejnej rundzie pucharu', '', 'trash', 'open', 'open', '', 'lks-w-kolejnej-rundzie-pucharu__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=628', 0, 'post', '', 0),
 (634, 1, '2017-09-19 23:26:07', '2017-09-19 21:26:07', '[caption id="" align="aligncenter" width="684"]<a href="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/21743392_1748983282070432_8699405484316105951_n.jpg?oh=a153edd67ff28e571ef87a5d3e3b2242&amp;oe=5A5A5DDE"><img class="size-medium" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/21743392_1748983282070432_8699405484316105951_n.jpg?oh=a153edd67ff28e571ef87a5d3e3b2242&amp;oe=5A5A5DDE" width="684" height="960" /></a> facebook.com/mgokslesin/[/caption]', 'XI Rajd Rowerowy "Bursztynowym szlakiem"', '', 'trash', 'open', 'open', '', 'juz-2-wrzesnia-ix-rajd-rowerowy-bursztynowym-szlakiem__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=634', 0, 'post', '', 0),
 (639, 1, '2017-08-24 15:29:42', '2017-08-24 13:29:42', '<strong><img class="alignleft " src="https://images.pexels.com/photos/51971/football-the-ball-sport-game-51971.jpeg?w=940&amp;h=650&amp;auto=compress&amp;cs=tinysrgb" width="185" height="123" />RUNDA VIII odbędzie się 27. sierpnia 2017 r. na boisku ORLIK przy Osiedlu Północ.</strong><!--more-->\n\n<u>Kolejność rozgrywanych meczy</u>\n\n1mecz  8:30 Szyszyńskie Holendry <strong>3 – 6</strong> Głębockie/Mikorzyn\n\n2 mecz 9:40 Honoratka <strong>5 - 9</strong> Piotrkowice\n\n3 mecz 10:50 Osiedle Północ <strong>3 – 2</strong> Półwiosek Stary\n\n4 mecz 12:00 Osiedle Powstańców Wielkopolskich <strong>8 - 3</strong> Wąsosze\n\n5 mecz 13:10 Ignacewo <strong>5 – 4</strong> Szyszyn\n\n&nbsp;\n\nGospodarzami Rundy są drużyny  Ignacewo – Szyszyn', '8. runda Ligi Sołeckiej', '', 'trash', 'open', 'open', '', '8-runda-ligi-soleckiej__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=639', 0, 'post', '', 1),
 (642, 1, '2017-08-24 22:26:59', '2017-08-24 20:26:59', '[caption id="" align="alignleft" width="300"]<img class="" src="data:image/png;base64,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" width="300" height="154" /> Źródło: slesin.naszabiblioteka.com[/caption]\n\n<strong>Zapraszamy wszystkich chętnych do wzięcia udziału w Narodowym Czytaniu dramatu „Wesele” autorstwa Stanisława Wyspiańskiego. Akcja będzie miała miejsce w sobotę 2 września 2017 r. w godzinach 10:00-12:00 w lokalu Biblioteki Publicznej Miasta i Gminy Ślesin.</strong> <!--more-->\n\nWydarzeniu towarzyszyć będzie wystawa poświęcona Stanisławowi Wyspiańskiemu. Dodatkowo, jak w każdym roku, w tym dniu można zgłosić się po pamiątkowy stempel.', 'Narodowe Czytanie 2017', '', 'trash', 'open', 'open', '', 'narodowe-czytanie-2017__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=642', 0, 'post', '', 0),
 (647, 1, '2017-08-24 22:42:30', '2017-08-24 20:42:30', '[caption id="" align="alignleft" width="275"]<img class="" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/21034193_940342619436906_7122595473309501137_n.jpg?oh=0a21dfa97ce21afc1db91ab10a3e22aa&amp;oe=5A1FF50E" width="275" height="206" /> facebook.com/strazaklichenstary/[/caption]\n\n<strong>Środa 22. sierpnia 2017 była dniem pucharowym na szczeblu OZPN KONIN. Nasza drużyna grała na wyjeździe z występującym w A-Klasie Górnikiem Wierzbinek.</strong> <!--more-->Po bramkach Pawła Krygra (44 i 88 minuta), Łajdeckiego Łukasza (14 minuta), Siedleckiego Krzysztofa (65 minuta) oraz Patryka Kosmowskiego (55 minuta) wygrywamy 5:2, choć od 25 sekundy (...tak sekundy) przegrywaliśmy 0:1. Pomimo tego nasza drużyna pokazała charakter i odniosła zwycięstwo.\n\nskład.WOJCIECHOWSKI M. ŁAJDECKI Ł. LENARTOWSKI K. KRYGIER PRZEMYSŁAW. ADAMCZYK S. ANDRZEJCZAK K.KRYGIER PAWEŁ. SIEDLECKI K. ŻELICHOWSKI A( 65 KAŻMIERCZAK W).KŁOS M( 70 JANIAK H). KOSMOWSKI P( 75 PAWLAK A).', 'Zwycięstwo z Wierzbinkiem', '', 'trash', 'open', 'open', '', 'zwyciestwo-z-wierzbinkiem__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=647', 0, 'post', '', 0),
 (649, 1, '2017-08-28 00:25:22', '2017-08-27 22:25:22', '[caption id="" align="alignleft" width="194"]<a href="http://www.przegladkoninski.pl/PL-H5/3/4578/dziewiec-wiencow-dozynkowych-walczylo-o-tytul-najpiekniejszego-ktory-wygral.html"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StLS0yOTIyODMtRFNDMDA0ODEuSlBH.jpg" width="194" height="129" /></a> Źródło: przegladkoninski.pl[/caption]\n\n<strong>Dziewięć wieńców dożynkowych walczyło o tytuł tego najpiękniejszego podczas dożynek gminno-parafialnych w Ostrowążu. Wygrał ten przygotowany przez Koło Gospodyń Wiejskich z Półwioska Starego. <a href="http://www.przegladkoninski.pl/PL-H5/3/4578/dziewiec-wiencow-dozynkowych-walczylo-o-tytul-najpiekniejszego-ktory-wygral.html" target="_blank" rel="noopener">Zobacz zdjęcia i materiał TV.</a></strong><!--more-->\n\n<img class=" wp-image-522 alignright" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="238" height="62" />\n\n– Dożynki to czas dziękczynienia za plony. Wszyscy z szacunkiem i uznaniem myślimy o naszych rolnikach, bowiem chleb produkowany od wieków przez mieszkańców polskich wsi jest dla nas wszystkich podstawą egzystencji – mówił Mariusz Zaborowski, burmistrz miasta i gminy Ślesin. Dodając, że to piękne święto pokazuje, iż rolnictwo to jest coś więcej niż żywność.\n– Jest ono ważne nie tylko dla gospodarki, lecz również skarbnicą cennych wartości społecznych i kulturowych. Dzisiejsza wieś kultywując tradycje otwiera się na współczesność, bo tego wymaga od nas świat – stwierdził. Rolnikom dziękował za trud i zaangażowanie w rozwój wsi.\n\nStarostami tegorocznego święta plonów byli Emilia Walczak z Teodorowa oraz Marcin Przybylski z Ostrowąża. Na ręce burmistrza przekazali bochen chleba wypieczony z tegorocznych, jako symbol pracy wszystkich rolników gminy Ślesin.\n\nW tym roku gminę odwiedził Zespół Folklorystyczny „Smólnik”. Na scenie można było podziwiać także młodych lokalnych wykonawców, czyli uczniów Szkoły Podstawowej w Ostrowążu, którzy przygotowali bogaty program. Z podziwem wszyscy patrzyli także na wykonane wieńce dożynkowe, startujące w konkursie o miano tego najpiękniejszego. Wygrał ten przygotowany przez Koło Gospodyń Wiejskich z Półwioska Starego. Jak mówiła jego przewodnicząca Halina Biesiada, prace nad nim trwały około miesiąca.\n\n&nbsp;', 'Dziewięć wieńców dożynkowych walczyło o tytuł najpiękniejszego', '', 'trash', 'open', 'open', '', 'dziewiec-wiencow-dozynkowych-walczylo-o-tytul-najpiekniejszego__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=649', 0, 'post', '', 0),
 (651, 1, '2017-08-27 21:31:01', '2017-08-27 19:31:01', '<div class="text_full" align="justify">\n\n<strong><img class="alignleft  wp-image-189" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/IMG_1763-300x225.jpg" alt="" width="207" height="155" />12 artystów z Polski bierze udział w kolejnej edycji pleneru malarskiego „Licheń na sztalugach”, którego tematem wiodącym jest hasło: „Pielgrzym nie równa się turysta”.</strong>\n\n<!--more-->\n\nW trakcie tegorocznej edycji pleneru, który rozpoczął się 21 sierpnia i potrwa do 29 sierpnia, głównym zadaniem artystów jest próba zaprezentowania człowieka w przestrzeni licheńskiego Sanktuarium.<strong><img class="wp-image-522 alignright" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="227" height="59" /></strong>\n\n<b>\n</b> – Staraliśmy się zaprosić do udziału w plenerze różne osoby z różnych środowisk artystycznych po to, aby skonfrontowali oni swoje myślenie o sztuce, swój język sztuki z innymi spojrzeniami i perspektywami. Jest to bardzo zróżnicowana grupa ludzi. Mamy sześć kobiet i sześciu mężczyzn. Koncentrujemy się na bardzo istotnym elemencie Sanktuarium, którym są osoby je odwiedzające. Z jednej strony przyjeżdżają tu osoby, które wykonują tzw. gesty wotywne. Z drugiej zaś, dostrzec można tych, którzy chcą to miejsce zobaczyć, gdyż powoduje nimi ciekawość. Koncentrujemy się nad religijnością ekstrawertyczną – powiedział Robert Brzęcki, kurator licheńskiego pleneru.\n\nW poszukiwaniu inspiracji artyści udadzą się m.in. do Muzeum im. ks. Józefa Jarzębowskiego i klasztoru sióstr anuncjatek w lesie grąblińskim. Wysłuchają także koncertów organowych w wykonaniu licheńskich organistów: Barbary Kaczor oraz Michała Szostaka. Udadzą się także do Konina, aby w kościele pw. Ducha Świętego wysłuchać koncertu gitarowego Judicael Perroy w ramach Akademii Gitary.\n\nWernisaż poplenerowej wystawy prac zaplanowano na połowę grudnia. Prace będzie można oglądać w Centrum Kultury i Sztuki „Wieża Ciśnień” w Koninie przy ul. Kolejowej.\n\n</div>\n&nbsp;\n<div class="clearfix">Źródło: Marcin Szafrański - przegladkoninski.pl</div>', 'Plener malarski w Licheniu', '', 'trash', 'open', 'open', '', 'plener-malarski-w-licheniu__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=651', 0, 'post', '', 0),
 (656, 1, '2017-08-29 00:09:58', '2017-08-28 22:09:58', '<div id="js_hw" class="_5pbx userContent" data-ft="{&quot;tn&quot;:&quot;K&quot;}">\n<div id="id_59a493a802f5f6508173956" class="text_exposed_root text_exposed">\n\n[caption id="" align="alignleft" width="237"]<a href="https://www.facebook.com/KGWMikorzyn/photos/pcb.1945982995650154/1945980242317096/?type=3&amp;theater"><img class="" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/21106761_1945980242317096_4736214649243433848_n.jpg?oh=125810e2f8ca252fbb1a6d61b32ba920&amp;oe=5A1DBDDB" width="237" height="178" /></a> Źródło: facebook.com/KGWMikorzyn/[/caption]\n\n<strong>Podczas imprezy można było zobaczyć występ "Artystycznej Ferajny" w reżyserii p. Agnieszki Kopczyńskiej i Agaty Chmurskiej oraz posłuchać piosenek w wykonaniu Klaudii Hejman i Katarzyny Pietrzak. </strong><!--more-->\n\nSerdeczne podziękowania składam:\nBurmistrzowi Miasta i Gminy Ślesin p. Mariuszowi Zaborowskiemu.\nDyrektorowi Domu Kultury w Ślesinie p. Michałowi Chmielewskiemu<span class="text_exposed_show">\nKomisji do spraw Rozwiązywania Problemów Alkoholowych\nPrzewodniczącej Stowarzyszenia Polska Gospodyni p. Wandzie Waleriańczyk\nFirmie Hevea p. Małgorzacie i Cezaremu Martynowicz\nRadnej p. Małgorzacie Chmurskiej\nOSP Mikorzyn\npanu Maciejowi Adamczewskiemu\npanu Krzysztofowi Hejmanowi\nWszystkim paniom z Koła Gospodyń Wiejskich za działalność, która ma duży udział w życiu sołectwa</span>\n\nŹródło: facebook.com/KGWMikorzyn/\n\n</div>\n</div>\n<div class="_3x-2"></div>', 'Święto Jabłka 2017', '', 'trash', 'open', 'open', '', 'swieto-jablka-2017__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=656', 0, 'post', '', 0),
 (658, 1, '2017-08-29 00:16:15', '2017-08-28 22:16:15', '<strong>Piłkarze LKS-u Ślesin pokonali 26 sierpnia w Ślesinie Orlik Miłosław aż 9:3! Bramki trafili:</strong><!--more-->\n\n[caption width="960" align="alignleft"]<a href="https://www.facebook.com/lksslesin/photos/ms.c.eJw9kNsRRDEIQjva8YEa~_29s52rI5xkQSBSR5eaWHQf902GV9rSwQ0aKtbZe9hq~;B3VfP9ll8~_yyrR~;Usfz8ocvMj8nDeXk1~;ck91sOV1HP6hX0ho8e9h~_XHUvd9cF3GZeC79yZbTL86Gd~_~_wqHf1p~;Mm36wH9DVi3qtrs8~;~;fn2zP~_X9x9t2VEw.bps.a.145673042695868.1073741834.123946521535187/145673232695849/?type=3&theater"><img src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/21032612_145673232695849_1290679545110249977_n.jpg?oh=2f08ad6bc1d06ff04ac6fb04e08d97ab&oe=5A215DEF" width="960" height="585" class="size-medium" /></a> Źródło: facebook.com/lksslesin/[/caption]\n- Bartłomiej Siek \n- Michał Kwiatkowski ⚽️⚽️\n- Bartek Nowak ⚽️\n- Arkadiusz Jańczak ⚽️⚽️\n- Rafał Czapski ⚽️⚽️\n- Kornel Broniszewski ⚽️\nWynik LKS ŚLESIN 9:3 ORLIK MIŁOSŁAW', 'Udana inauguracja Ligi', '', 'trash', 'open', 'open', '', 'udana-inauguracja-ligi__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=658', 0, 'post', '', 0),
 (660, 1, '2017-08-29 00:22:23', '2017-08-28 22:22:23', '[caption id="" align="alignleft" width="236"]<a href="http://www.lichen.pl/pl/24/n_1778/piknik_z_mama_i_tata"><img class="" src="http://www.lichen.pl/media/foto/22154_dsc00212.jpg" width="236" height="132" /></a> Źródło: lichen.pl/[/caption]\n\n<strong>Dzieci wraz ze swoimi rodzicami spędzały wakacyjne niedzielne popołudnie w licheńskim Sanktuarium w ramach dorocznego Pikniku z mamą i tatą organizowanego przez Licheńskie Centrum Pomocy Rodzinie i Osobom Uzależnionym (LCPRiOU). <a href="https://www.lm.pl/aktualnosci/informacja/111156/lichen_cale_rodziny_integrowaly_sie_na_pikniku_przed_bazylika" target="_blank" rel="noopener">Zobacz zdjęcia.</a></strong><!--more-->\n\n\n\nOd 9 lat w ostatnią wakacyjną niedzielę do Sanktuarium Maryjnego w Licheniu przyjeżdżają całe rodziny, aby spędzić razem czas na grach i zabawach integracyjnych. Zdaniem ks. Roberta Krzywickiego MIC, dyrektora LCPRiOU, jest to czas w pełni poświęcony integracji całych rodzin, którego tak bardzo brakuje w dzisiejszych czasach: „Spotykamy się po to, aby przed rozpoczęciem nowego roku szkolnego modlić się razem, otrzymać Boże błogosławieństwo i aby spędzić wspólnie czas. Ten piknik jest pomyślany tak, aby całe rodziny mogły spędzać razem czas i w ten sposób nabierać siły do codziennego życia, aby zobaczyć, iż prawdziwe życie polega na pielęgnowaniu więzi”.\n\nZdaniem marianina, na tegorocznym pikniku pojawiło się kolejne pokolenie. Pewne osoby, które brały udział w pierwszym pikniku jako nastolatkowie, dziś przybyli do Lichenia wraz ze swoimi dziećmi.\n\nTradycyjnie Piknik z mamą i tatą rozpoczął się od Mszy św. przed Cudownym Obrazem Matki Bożej Licheńskiej o godz. 12.00. Eucharystii przewodniczył ks. Krzysztof Jędrzejewski MIC. Zwieńczeniem nabożeństwa było udzielenie dzieciom zgromadzonym w licheńskiej świątyni przez kapłanów indywidualnego błogosławieństwa przed rozpoczęciem nowego roku szkolnego i akademickiego.\n\nOd godz. 13 na placu przed bazyliką rozpoczął się piknik, w trakcie którego dzieci mogły korzystać z przygotowanych atrakcji: dmuchanych zamków, basenu z kulami wodnymi, mega-darta czy kącika plastycznego.\n\nPoza tym druhowie z Ochotniczej Straży Pożarnej z Lichenia Starego uczyli jak prawidłowo wykonać resuscytację krążeniowo-oddechową osoby poszkodowanej w wypadku drogowym.\n\nPrzez cały czas trwania pikniku na scenie swoje zdolności wokalne prezentowali wychowankowie Konińskiego Domu Kultury.\n\nLicheń Stary, 27 sierpnia 2017 r.', 'Piknik z mamą i tatą', '', 'trash', 'open', 'open', '', 'piknik-z-mama-i-tata__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=660', 0, 'post', '', 0),
 (668, 1, '2017-08-29 23:33:17', '2017-08-29 21:33:17', '<strong><a href="http://wielkopolska.tv/slesin-dozynki-chlebem-pachnace/#/?playlistId=0&amp;videoId=0"><img class="alignleft " src="http://wielkopolska.tv/wp-content/themes/tense-theme-master/assets/images/logo.png" width="280" height="37" /></a>Dożynki, to ludowe święto połączone z obrzędami dziękczynnymi za ukończenie żniw i prac polowych. Uroczystości przeprowadzono w wielu gminach Województwa Wielkopolskiego.Do obchodów należy również zaliczyć gminę Ślesin, która tradycyjnie rozpoczęła świętowanie mszą świętą w Kościele Parafialnym w Ostrowążu. <a href="http://wielkopolska.tv/slesin-dozynki-chlebem-pachnace/#/?playlistId=0&amp;videoId=0">Zobacz materiał TV Wielkopolska</a></strong>\n\n<!--more-->\n\nPo niej barwny korowód dożynkowy przemaszerował na boisko sportowe przy Szkole Podstawowej, gdzie odbyła się część rozrywkowa dożynek. W programie artystycznym znalazł się Zespół Folklorystyczny „Smólnik”. Na scenie zagościli także młodzi i lokalni wykonawcy ze Szkoły Podstawowej w Ostrowążu. Starostami tegorocznego święta plonów byli Emilia Walczak z Teodorowa oraz Marcin Przybylski z Ostrowąża. Na ręce burmistrza przekazali bochen chleba wypieczony z tegorocznych zbiorów, którym podzielili się z okolicznymi mieszkańcami.', 'Dożynki chlebem pachnące...', '', 'trash', 'open', 'open', '', 'dozynki-chlebem-pachnace__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=668', 0, 'post', '', 0),
 (670, 1, '2017-08-29 23:44:44', '2017-08-29 21:44:44', '<strong> </strong>\n\n<img class="alignleft size-medium wp-image-167" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/pexels-photo-274506-300x200.jpeg" alt="" width="300" height="200" />\n\n<strong>W drugiej rundzie Pucharu Polski los przydzielił LKSowi Ślesin drużynę Strażaka Licheń! Mecz odbędzie się 6 września w środę o godzinie 17:30 na Stadionie Miejskim w Ślesinie.</strong>\nSerdecznie zapraszamy wszystkich kibiców na to spotkanie.\nŹródło: facebook.com/lksslesin/', 'Rozgrywka między Ślesinem a Licheniem', '', 'trash', 'open', 'open', '', 'rozgrywka-miedzy-slesinem-a-licheniem__trashed', '', '', '2017-10-23 15:48:23', '2017-10-23 15:48:23', '', 0, 'http://gminaslesin.futurehost.pl/?p=670', 0, 'post', '', 0),
 (672, 1, '2017-08-30 23:59:45', '2017-08-30 21:59:45', '<div id="js_1e" class="_5pbx userContent" data-ft="{&quot;tn&quot;:&quot;K&quot;}">\n\n[caption id="" align="alignleft" width="374"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1742186652750095/1742186269416800/?type=3&amp;theater"><img class="" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/21192793_1742186269416800_107687528457597935_n.jpg?oh=0ca2d56f0a44adad5d565a66c8c0f2a5&amp;oe=5A254F67" width="374" height="249" /></a> Źródło: facebook.com/mgokslesin/[/caption]\n\n<strong>Msza, tradycyjna prezentacja wieńców, barwny korowód, występy zespołów ludowych oraz przemówienia. Tych elementów nie zabrakło podczas tegorocznych dożynek , które w tym roku odbyły się w Ostrowążu w niedzielę, 27 sierpnia. Gościło tam mnóstwo przedstawicieli władz samorządowych, ale i mieszkańców gminy Ślesin.</strong>\n\n<!--more-->\n\nGminno-Parafialne Dożynki w Ślesinie w tym roku odbyły się w Ostrowążu przy boisku sportowym tamtejszej Szkoły Podstawowej. Dożynki rozpoczęła Msza Święta dziękczynna, którą odprawił ks. Prałat Ryszard Felisiak – Proboszcz Parafii Ostrowąż.\n\nPo Mszy Świętej barwny korowód złożony z Orkiestry Dętej M-GOK, wieńców dożynkowych, władz samorządowych oraz uczestników Mszy udał się na boisko sportowe gdzie odbyła się rozrywkowa cześć dożynek. Starości dożynek przekazali chleb Burmistrzowi Miasta i Gminy Ślesin – Mariuszowi Zaborowskiego.\n\nTegorocznymi starostami dożynek była Pani Emilia Walczak z Teodorowa i Marcin Przybylski z Ostrowąża. Pani Emilia Walczak prowadzi 40 hektarowe gospodarstwo rolne wspólnie z mężem Marcinem od 2001r. Gospodarstwo Państwa Walczaków specjalizuje się w hodowli bydła mlecznego. Obecnie w gospodarstwie hodowanych jest 87 sztuk bydła w tym 50 krów mlecznych. W gospodarstwie uprawiane są zboża, kukurydza, lucerna. Państwo Walczakowie w 2015 roku zostali wyróżnienie w Powiatowym Konkursie ROLNIK 2015. Wychowują 7-letniego syna i 3-letnią córkę.\n\nStarosta dożynek Pan Marcin Przybylski prowadzi z żoną Mileną 15 hektarowe gospodarstwo rolne od 2000 roku. W gospodarstwie uprawiana jest pszenica, rzepak, facelie. Pan Marcin jest członkiem Rady Sołeckiej i Sołectwa Ostrowąż. Państwo Przybylscy wychowują 15-letnia córkę i 5-letniego syna.\n\nPo przekazaniu chleba odbyła się cześć artystyczna. Zespół folklorystyczny „SMÓLNIK” rozpoczął swój występ od obrządku dożynkowego. Z dożynkowym repertuarem na scenie zaprezentowały się również dzieci ze Szkoły Podstawowej w Ostrowążu. Pomiędzy występami rozstrzygnięto konkurs na najpiękniejszy Wieniec Dożynkowy. Podczas oceny wieńców komisja zwracała uwagę na ilość użytych zbóż, pomysłowość wykorzystania zbóż, estetykę wykonania i tradycyjność wykonania wieńca.\n\nKomisja w składzie Michał Chmielewski, Magdalena Niedżwiedzińska , Karolina Kołodziejczak, Aleksandra Podlaska i Katarzyna Kołakowska-Frontczak po obejrzeniu 9 wieńców dożynkowych postanowiła przyznać następujące miejsca:\n\n<strong>I miejsce dla:</strong>\n<strong> KGW Półwiosek Stary</strong>,\n\nII miejsce równorzędne:\nSołectwo Ostrowąż, KGW Lubomyśle\n\nIII miejsce dla:\nKGW Ignacewo\n\nIV miejscem dla:\nSołectwo Szyszynek\n\nV miejsce równorzędne dla:\nKGW Mikorzyn, Sołectwo i KGW Szyszyn\n\nVI miejsce równorzędne dla:\nSołectwo Nowa Wieś, Sołectwo Kobylanki\n\nPo ogłoszeniu wyników na scenie pojawiła się gwiazda dożynek zespół Disco Polo „DANIELO”. Podczas dożynek odbył się także słynny spacer farmera w którym wystartowało 14 zawodników, których zadaniem było przenieść jak najdalej dwie 50 kg walizki. Najdalej – bo na odległość 145 m walizkę przeniósł Pan Andrzej Chwalny, jako drugi Pan Jakub Słupicki -136 m i trzeci Pan Mirek Lisiecki – 120m. Zabawę taneczną rozkręcił zespół APLUZ.\n\nOrganizatorzy dziękują Burmistrzowi Miasta i Gminy Ślesin Panu Mariuszowi Zaborowskiemu, Dyrektorowi Miejsko-Gminnego Ośrodka Kultury w Ślesinie Panu Michałowi Chmielewskiemu, sponsorom:\n\nZakład Masarski Grzegorz Kostrzewa\nFirmie Szmidt i Syn Biskupie\nPOLFARMER Rafał Król, Przemysław Murawiak\nSołtys Wojciech Chmielewski\nGminna Spółdzielnia „Samopomoc Chłopska”\nRadny Andrzej Dąbek.\n\nW tym miejscu organizatorzy składają serdeczne podziękowania wszystkim mieszkańcom Ostrowąża za upiększenie swoich posesji. Wzdłuż całego Ostrowąża możną było oglądać piękne „Arcydzieła Dożynkowe”.\n\n</div>\n&nbsp;\n<div class="_3x-2"></div>', 'Relacja z dożynek w Ostrowążu', '', 'trash', 'open', 'open', '', 'dozynki-ostrowaz__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=672', 0, 'post', '', 0),
 (674, 1, '2017-08-31 00:06:04', '2017-08-30 22:06:04', '<strong><a href="https://www.facebook.com/mgokslesin/?hc_ref=ARSh5wVQl_nAktV6ZcmqItXec4v5nzr8o3h6v1DxhXIWjgc5GGKNa3-myrv6FxyyZHc"><img class="alignleft " src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/12043165_1487575074877922_1776478986692669327_n.jpg?oh=7ecca72fd2982bfce9f084daededfef0&amp;oe=5A2A1901" width="255" height="201" /></a>Przegląd odbędzie się 9 września w Licheniu Starym przy ul. Konińskiej.  Zaprezentowany zostanie dorobek amatorski ruchu artystycznego kół gospodyń wiejskich i innych organizacji z terenów wiejskich.</strong>\n\n<!--more-->\n<p style="text-align: center;">Regulamin VII Ogólnopolskiego Przeglądu Zespołów Artystycznych\nz Terenów Wiejskich - Licheń 2017</p>\n&nbsp;\n\nOrganizator:\nStowarzyszenie Polska Gospodyni\n<div class="text_exposed_show">\n\nTermin i miejsce:\n09.09.2017 godz. 11:00 Parking przy Plaży,\nLicheń Stary, ul. Konińska\n\nCele:\n- Prezentacje dorobku amatorskiego ruchu artystycznego kół gospodyń wiejskich i innych organizacji z terenów wiejskich\n- Integracja środowisk twórczych\n- Promocja twórczości artystycznej mieszkańców wsi\n\nWarunki uczestnictwa:\n\n- Przegląd jest konkursem otwartym o charakterze ogólnopolskim organizowanym w ramach VII Ogólnopolskiego Zjazdu Kół Gospodyń Wiejskich i Innych Organizacji Kobiecych z Terenów Wiejskich\n- Przegląd kierowany jest do zespołów śpiewaczych, kapel , zespołów wokalno-instrumentalnych z terenów wiejskich\n- Tematyka prezentacji jest dowolna\n- Zespoły prezentują dwa utwory o łącznym czasie trwania do 8 minut\n-Rekwizyty potrzebne do prezentacji uczestnicy zapewniają we własnym zakresie\n- Koszty dojazdu i ubezpieczenia uczestników pokrywa instytucja delegująca\n- Organizatorzy zapewniają nagłośnienie zgodne z kartą uczestnictwa\n- Do konkursu zakwalifikowanych zostanie 20 zespołów na podstawie przesłuchanych nagrań\n\nPatronat:\n\nStarosta Powiatu Konińskiego\n\nTermin zgłoszenia:\n\nKartę zgłoszenia należy przesłać do dnia 31.08.2017 na adres\nWanda Waleriańczyk\nPiotrkowice 22B, 62-561 Ślesin\n\nlub drogą elektroniczna na adres\nzgłoszenia.lichen@wp.pl\n\nUwagi końcowe:\n- Organizator przeglądu powoła Jury którego werdykt jest ostateczny\ni niepodważalny\n- Interpretacja niniejszego regulaminu należy do organizatora\n- Zgłoszenie zespołu do przeglądu jest równoznaczne z akceptacją\nniniejszego regulaminu\n- Nagrody zostaną wręczone podczas koncertu galowego laureatów o godz.: 17:00\n\nSzczegółowych informacji o przeglądzie udziela\nJoanna Waleriańczyk\nTel: 605 031 130\n\n</div>', 'VII Ogólnopolskiego Przeglądu Zespołów Artystycznych  z Terenów Wiejskich - Licheń 2017', '', 'trash', 'open', 'open', '', 'viiprzeglad-zespolow-artstycznych__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=674', 0, 'post', '', 0),
 (676, 1, '2017-08-31 00:07:52', '2017-08-30 22:07:52', '[caption id="" align="aligncenter" width="675"]<a href="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/21271105_1742246159410811_4842019982697074551_n.jpg?oh=525a8e798dcbf9abb3d09c192954389f&amp;oe=5A264480"><img class="size-medium" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/21271105_1742246159410811_4842019982697074551_n.jpg?oh=525a8e798dcbf9abb3d09c192954389f&amp;oe=5A264480" width="675" height="960" /></a> Źródło: facebook.com/mgokslesin/[/caption]', 'Pożegnanie wakacji', '', 'trash', 'open', 'open', '', 'pozegnanie-wakacji__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=676', 0, 'post', '', 0),
 (680, 1, '2017-08-31 22:49:47', '2017-08-31 20:49:47', '[caption id="" align="aligncenter" width="960"]<a href="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/20526009_1612283788829004_2542061140795565845_n.jpg?oh=028a96ab5b11c10e8b5e77e48af26afc&amp;oe=5A29A813"><img class="size-medium" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/20526009_1612283788829004_2542061140795565845_n.jpg?oh=028a96ab5b11c10e8b5e77e48af26afc&amp;oe=5A29A813" width="960" height="678" /></a> Źródło: facebook.com/Honorowi-Dawcy-Krwi-Ślesin[/caption]', '2 września akcja poboru krwi', '', 'trash', 'open', 'open', '', '2-wrzesnia-akcja-poboru-krwi__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=680', 0, 'post', '', 0),
 (682, 1, '2017-08-31 22:54:58', '2017-08-31 20:54:58', '<strong><img class="alignleft wp-image-167 size-medium" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/pexels-photo-274506-300x200.jpeg" alt="" width="300" height="200" />TABELA  PO 8 RUNDACH  SOŁECKIEJ  LIGII PIŁKI NOŻNEJ SOŁECTW 2017</strong>\n<!--more-->\n\n\n&nbsp;\n<table width="747">\n<tbody>\n<tr>\n<td colspan="2" rowspan="2" width="81"><strong>Miejsce</strong></td>\n<td rowspan="2" width="180"><strong>Drużyna</strong></td>\n<td rowspan="2" width="77"><strong>Ilość </strong>\n\n<strong>meczy</strong></td>\n<td colspan="2" rowspan="2" width="43"><strong>Pkt.</strong></td>\n<td colspan="4" width="150"><strong>Bramki</strong></td>\n<td colspan="4" width="171"><strong>Mecz</strong></td>\n<td rowspan="2" width="45"><strong>Bilans</strong>\n\n<strong>Bram.</strong></td>\n</tr>\n<tr>\n<td width="73"><strong>zdobyte</strong></td>\n<td colspan="3" width="78"><strong>stracone</strong></td>\n<td width="58"><strong>Zwyc.</strong></td>\n<td colspan="2" width="52"><strong>Rem.</strong></td>\n<td width="60"><strong>Przeg.</strong></td>\n</tr>\n<tr>\n<td width="80"><strong>1</strong></td>\n<td colspan="2" width="180"><strong>Osiedle Północ</strong>\n\n<strong> </strong></td>\n<td colspan="2" width="78">8</td>\n<td width="42">24</td>\n<td colspan="2" width="74">62</td>\n<td width="75">24</td>\n<td colspan="3" width="60">8</td>\n<td width="51">0</td>\n<td width="60">0</td>\n<td width="45">+38</td>\n</tr>\n<tr>\n<td width="80"><strong>2</strong></td>\n<td colspan="2" width="180"><strong>Piotrkowice</strong></td>\n<td colspan="2" width="78">8</td>\n<td width="42">21</td>\n<td colspan="2" width="74">93</td>\n<td width="75">41</td>\n<td colspan="3" width="60">   7</td>\n<td width="51">0</td>\n<td width="60">1</td>\n<td width="45">+52</td>\n</tr>\n<tr>\n<td width="80"><strong>3</strong></td>\n<td colspan="2" width="180"><strong>Osiedle Pow. Wielkop.</strong>\n\n<strong> </strong></td>\n<td colspan="2" width="78">8</td>\n<td width="42">15</td>\n<td colspan="2" width="74">41</td>\n<td width="75">40</td>\n<td colspan="3" width="60">   5</td>\n<td width="51">   0</td>\n<td width="60">3</td>\n<td width="45">+1</td>\n</tr>\n<tr>\n<td width="80"><strong>4</strong></td>\n<td colspan="2" width="180"><strong>Wąsosze</strong>\n\n<strong> </strong></td>\n<td colspan="2" width="78">8</td>\n<td width="42">12</td>\n<td colspan="2" width="74">39</td>\n<td width="75">55</td>\n<td colspan="3" width="60">  4</td>\n<td width="51">0</td>\n<td width="60">4</td>\n<td width="45">-16</td>\n</tr>\n<tr>\n<td width="80"><strong>5</strong></td>\n<td colspan="2" width="180"><strong>Głębockie/Mikorzyn</strong>\n\n<strong> </strong>\n\n<strong> </strong></td>\n<td colspan="2" width="78">8</td>\n<td width="42">12</td>\n<td colspan="2" width="74">58</td>\n<td width="75">    38</td>\n<td colspan="3" width="60">4</td>\n<td width="51">0</td>\n<td width="60">4</td>\n<td width="45">+20</td>\n</tr>\n<tr>\n<td width="80"><strong>6</strong></td>\n<td colspan="2" width="180"><strong>Szyszyńskie Holendry</strong></td>\n<td colspan="2" width="78">8</td>\n<td width="42">10</td>\n<td colspan="2" width="74">     40</td>\n<td width="75">45</td>\n<td colspan="3" width="60">3</td>\n<td width="51">1</td>\n<td width="60">4</td>\n<td width="45">-5</td>\n</tr>\n<tr>\n<td width="80"><strong>7</strong></td>\n<td colspan="2" width="180"><strong>Półwiosek Stary</strong></td>\n<td colspan="2" width="78">8</td>\n<td width="42">9</td>\n<td colspan="2" width="74">36</td>\n<td width="75">59</td>\n<td colspan="3" width="60">3</td>\n<td width="51">0</td>\n<td width="60">5</td>\n<td width="45">-23</td>\n</tr>\n<tr>\n<td width="80"><strong>8</strong></td>\n<td colspan="2" width="180"><strong>Szyszyn</strong>\n\n<strong> </strong></td>\n<td colspan="2" width="78">8</td>\n<td width="42">7</td>\n<td colspan="2" width="74">36</td>\n<td width="75">36</td>\n<td colspan="3" width="60">2</td>\n<td width="51">1</td>\n<td width="60">5</td>\n<td width="45">  0</td>\n</tr>\n<tr>\n<td width="80"><strong>9</strong></td>\n<td colspan="2" width="180"><strong>Ignacewo</strong></td>\n<td colspan="2" width="78">8</td>\n<td width="42">6</td>\n<td colspan="2" width="74">    22</td>\n<td width="75">65</td>\n<td colspan="3" width="60">2</td>\n<td width="51">0</td>\n<td width="60">7</td>\n<td width="45">-43</td>\n</tr>\n<tr>\n<td width="80"><strong>10</strong></td>\n<td colspan="2" width="180"><strong>Honoratka</strong></td>\n<td colspan="2" width="78">8</td>\n<td width="42">3</td>\n<td colspan="2" width="74">     27</td>\n<td width="75">51</td>\n<td colspan="3" width="60">1</td>\n<td width="51">0</td>\n<td width="60">7</td>\n<td width="45">-24</td>\n</tr>\n</tbody>\n</table>', 'Tabela Sołeckiej Ligi Piłki Nożnej', '', 'trash', 'open', 'open', '', 'tabela-soleckiej-ligi-pilki-noznej__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=682', 0, 'post', '', 0),
 (686, 1, '2017-09-01 22:12:36', '2017-09-01 20:12:36', '[caption id="" align="alignleft" width="135"]<a href="https://m.lm.pl/media/foto/291094_6105_350.jpg"><img class="" src="https://m.lm.pl/media/foto/291094_6105_350.jpg" width="135" height="240" /></a> Źródło: LM.pl[/caption]\n\n<strong>Mieszkanki Tokio, stolicy Japonii, przybyły do licheńskiego sanktuarium. Podczas wakacji zwiedzają Polskę, poznają kulturę, historię oraz najciekawsze zakątki.</strong>\n\n<!--more-->\n<img class="size-full wp-image-503 alignright" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/240915_logo_standard.png" alt="" width="175" height="70" />Yuriko Nishikawa przyleciała do Polski na zaproszenie swojej przyjaciółki, Marysi Gałat, z którą studiowała na Imperial College w Londynie. Dwa miesiące temu Polka poleciała do Japonii, a dziś gości azjatycką przyjaciółkę w Polsce.\n\n- To jest moja druga wizyta w waszym kraju. Ludzie są bardzo mili i przyjaźnie nastawieni. Pomimo trudnej historii Polacy są dumnym narodem i to bardzo mi imponuje – powiedziała Yuriko Nishikawa.\n\n&nbsp;\n\nW trakcie zwiedzania Polski, Marysia Gałat postanowiła zabrać przyjaciółkę do licheńskiego sanktuarium, w którym była jako dziecko.\n\n-<em> Pamiętam, że byłam w Licheniu, gdy była mała. Dlatego podróżując po Polsce postanowiłam, że warto pokazać jej to miejsce </em>- wyjaśniła Polka, która na co dzień mieszka i pracuje w Londynie.\n\nW planach mają także zwiedzenie Poznania, Wrocławia, Krakowa oraz Kielc.', 'Przyjacielska polsko - japońska wizyta w licheńskim sanktuarium', '', 'trash', 'open', 'open', '', 'przyjacielska-polsko-japonska-wizyta-w-lichenskim-sanktuarium__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=686', 0, 'post', '', 0),
 (688, 1, '2017-09-01 22:24:54', '2017-09-01 20:24:54', '[caption id="" align="alignleft" width="268"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1742731876028906/1742731289362298/?type=3&amp;theater"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/21272518_1742731289362298_6303515867535397517_n.jpg?oh=183e6a31730549bd1d7944395d93cef8&amp;oe=5A13DF90" width="268" height="178" /></a> Źródło: facebook.com/mgokslesin[/caption]\n\n<strong>Już po raz czwarty szachiści z Klubu M-GOK Gambit Ślesin brali udział w XVII Ogólnopolskich Indywidualnych Mistrzostwach Szkół, które odbywały się w dniach 20-29 sierpnia w Dąbkach. <a href="https://www.facebook.com/mgokslesin/photos/pcb.1742731876028906/1742731289362298/?type=3&amp;theater">Zobacz zdjęcia.</a></strong>\n\n<!--more-->\n\nW tym roku, aż pięciu naszych szachistów znalazło się na podium. Na najwyższym stopniu stanął Arkadiusz Łapot zajmując pierwsze miejsce w grupie szkół ponadgimnazjalnych, tuż za nim uplasował się Adam Naworski w tej samej grupie.\n\nW grupie gimnazjalistów wśród dziewcząt trzecie miejsce zajęła Nikola Majdecka, a wśród chłopców również trzecie miejsce zajął Aron Byra. Trecie miejsc zajęła też nasza najmłodsza reprezentantka Ada Chojnacka grał ona w grupie klas I-II szkół podstawowych. Ada uzyskał także normę na III kategorię szachową. Normą na IV kategorię szachową wyrobił Mateusz Łukasik.', 'Pięć razy podium!', '', 'trash', 'open', 'open', '', 'piec-razy-podium__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=688', 0, 'post', '', 0),
 (690, 1, '2017-09-01 22:27:22', '2017-09-01 20:27:22', '<strong><img class="alignleft" src="https://images.pexels.com/photos/51971/football-the-ball-sport-game-51971.jpeg?h=350&amp;auto=compress&amp;cs=tinysrgb" width="173" height="115" />Runda IX odbędzie się 10. wrzeeśnia 2017 roku na boisku ORLIK na Osiedlu Północ w Ślesinie.</strong>\n\n<!--more-->\n\nKolejność rozgrywanych meczy\n\n1 mecz 8:30 Ignacewo – Osiedle Północ\n<div class="text_exposed_show">\n\n2 mecz 9:40 Wąsosze - Honoratka\n\n3 mecz 10:50 Głębockie/Mikorzyn - Szyszyn\n\n4 mecz 12:00 Piotrkowice – Szyszyńskie Holendry\n\n5 mecz 13:10 Osiedle Powstańców Wielkopolskich – Półwiosek Stary\n\nGodz. 14:15 Podsumowanie Ligi wręczenie nagród\n\nGospodarzami Rundy są drużyny Osiedle Powstańców Wielkopolskich – Półwiosek Stary\n\n</div>', 'Runda IX w niedzielę 10 września', '', 'trash', 'open', 'open', '', 'runda-ix-w-niedziele-10-wrzesnia__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=690', 0, 'post', '', 0),
 (692, 1, '2017-09-01 22:28:55', '2017-09-01 20:28:55', '[caption id="" align="aligncenter" width="663"]<a href="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/21151271_1742918736010220_4074313050904285375_n.jpg?oh=a9f1c7af8735da872a5cf13db405cbee&amp;oe=5A5E196D"><img class="size-medium" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/21151271_1742918736010220_4074313050904285375_n.jpg?oh=a9f1c7af8735da872a5cf13db405cbee&amp;oe=5A5E196D" width="663" height="960" /></a> Źródło: facebook.com/mgokslesin[/caption]', 'Święto Kapusty w Honoratce', '', 'trash', 'open', 'open', '', 'swieto-kapusty-w-honoratce__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=692', 0, 'post', '', 0),
 (697, 1, '2017-09-02 22:19:25', '2017-09-02 20:19:25', '[caption id="" align="alignleft" width="242"]<a href="http://www.przegladkoninski.pl/PL-H5/3/4643/rywalizuja-strazacy-ochotnicy-trwaja-zawody-w-slesinie.html"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StNDY0My0zMDkzMzAtMjEzMjI4ODBfMTQ5MDcwNTkyNzY2MzI4MF8xNDM2OTA5MzA2X24uanBn.jpg" width="242" height="182" /></a> Źródło: przegladkoninski.pl[/caption]\n\n<strong>Czternaście drużyn OSP wzięło dziś udział w X Powiatowych Zawodach Sportowo – Pożarniczych na Stadionie Miejskim w Ślesinie. <a href="http://www.przegladkoninski.pl/PL-H5/3/4643/rywalizuja-strazacy-ochotnicy-trwaja-zawody-w-slesinie.html">Zobacz zdjęcia.</a>-zawody<a href="http://www.przegladkoninski.pl/PL-H5/3/4643/rywalizuja-strazacy-ochotnicy-trwaja-zawody-w-slesinie.html">-w-slesinie.html</a></strong>\n\n<!--more-->\n\nDruhowie rywalizowali w ćwiczeniach bojowych, startowali w sztafecie pożarniczej z przeszkodami oraz prezentowali się w mustrze.\n\n<img class=" wp-image-522 alignright" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="227" height="59" />W zawodach uczestniczyło 14 drużyn męskich OSP (Ostrowąż, Sompolno, Zarzew, Głodno, Kobylanki, Kraśnica, Zastruże, Kleczew, Kuchary Kościelne, Żdżary, Szyszyńskie Holendry, Wilcza Kłoda, Patrzykowo oraz Kazimierz Biskupi) oraz 6 kobiecych (Bochlewo, Patrzyków, Kałek, Spławie, Brzeźno, Czyżew).\n\nŹródło: Anna Chadaj - Przegląd Koniński', 'Strażacy-ochotnicy rywalizowali w Ślesinie', '', 'trash', 'open', 'open', '', 'strazacy-ochotnicy-rywalizuja__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=697', 0, 'post', '', 0),
 (702, 1, '2017-09-04 00:17:04', '2017-09-03 22:17:04', '[caption id="" align="alignleft" width="466"]<a href="https://scontent-bru2-1.xx.fbcdn.net/v/t31.0-8/s960x960/21272869_1742911292677631_3817993498745642441_o.jpg?oh=f40c7415813e077a7443bd3a120f488d&amp;oe=5A53FF1D"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t31.0-8/s960x960/21272869_1742911292677631_3817993498745642441_o.jpg?oh=f40c7415813e077a7443bd3a120f488d&amp;oe=5A53FF1D" width="466" height="660" /></a> Źródło: facebook.com/mgokslesin[/caption]\n\n<strong>VII Ogólnopolski Zjazd Kół Gospodyń Wiejskich i Innych Organizacji Kobiecych z Terenów Wiejskich odbędzie się w dniach 9-10 września w Licheniu.</strong>\n\nW sobotę, 9. września, gospodynie zapraszają na jarmark kulturowy na parkingu nad jeziorem Licheńskim. W tym czasie nastąpi rozstrzygnięcie konkursów: kulinarnego oraz twórczości artystycznej. Z kolei na scenie zespoły folklorystyczne zaprezentują swój repertuar. W niedzielę gospodynie przemaszerują w barwnym korowodzie do bazyliki na mszę o godz. 12.00. Przy pomniku św. Jana Pawła II odśpiewana zostanie „Barka”.\n\n<!--more-->\n\n\n\nVII Ogólnopolski Zjazd Kół Gospodyń Wiejskich i Innych Organizacji Kobiecych z Terenów Wiejskich organizuje Stowarzyszenie Polska Gospodyni z Piotrkowic w gminie Ślesin.\n\nTekst: LM.pl', 'VII Ogólnopolski Zjazd Kół Gospodyń', '', 'trash', 'open', 'open', '', 'vii-ogolnopolski-zjazd-kol-gospodyn__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=702', 0, 'post', '', 0),
 (704, 1, '2017-09-05 23:39:57', '2017-09-05 21:39:57', '<div>\n\n[caption id="" align="alignleft" width="242"]<a href="http://umig.slesin.pl/userfiles/images/16527_splyw-9-wrzesnia.jpg"><img class="" src="http://umig.slesin.pl/userfiles/images/16527_splyw-9-wrzesnia.jpg" width="242" height="341" /></a> Źródło: http://umig.slesin.pl[/caption]\n\n<strong>W  najbliższą sobotę, </strong><strong>9 września</strong>\nspotkamy się jednej z największych imprez kajakarskich w Wielkopolsce Wschodniej. <strong>Wodna przygoda </strong>rozpocznie się z Ośrodka Szkoleniowo-Wypoczynkowego „Wityng” w Mikorzynie i powiedzie uczestników na Bulwar Nadwarciański w Koninie.\n\n</div>\n<div>\n\n<!--more-->\n\n<strong>Trasa spływu</strong><strong> „Wodna przygoda na szlaku Wielkiej Pętli Wielkopolski” </strong><strong>poprowadzi nas przez jeziora Mikorzyńskie, Wąsoskie, Pątnowskie, przez kanał Ślesiński oraz Rzekę Wartę. Zbiórka uczestników odbędzie się na Bulwarze Nadwarciańskim, skąd planowany jest wyjazd do Ośrodka Szkoleniowo-Wypoczynkowego „Wityng” w Mikorzynie. Spływ poprowadzi nas 18-kilometrowym odcinkiem Wielkiej Pętli Wielkopolski do Bulwaru Nadwarciańskiego w Koninie.  Na końcu trasy na uczestników czekać będzie ciepły posiłek oraz moc atrakcji w tym konkursy z nagrodami, zabawa w stylu szanty a także namiot Lokalnej Organizacji Turystycznej „Marina”. Spływ zorganizowany zostanie z okazji Światowego Dnia Turystyki.</strong>\n\n</div>\n<!--more-->\n<div></div>\n<div><strong>Harmonogram spływu (może ulec zmianie)</strong>\n<strong>8:00</strong>                <strong>ZBIÓRKA</strong> / Bulwar Nadwarciański (Miasto Konin)\n<strong>8:00-8:30</strong>        przejazd autokarami na miejsce rozpoczęcia spływu – Ośrodek Szkoleniowo-Wypoczynkowy „Wityng” w Mikorzynie\n<strong>8:30-9:30</strong>        rejestracja uczestników, przydzielenie sprzętu pływającego oraz zapoznanie z podstawowymi zasadami       bezpieczeństwa na wodzie (odczytanie regulaminu)\n<strong>9:30</strong>                <strong>START /</strong> rozpoczęcie spływu / Ośrodek Szkoleniowo-Wypoczynkowy „Wityng” w Mikorzynie\n<strong>11:30-12:00</strong>    Śluzowanie Pątnów – 30 minut\n<strong>12:00-14:00</strong>    Śluza Pątnów – Śluza Morzysław (8 km trasy)\n<strong>14:00-14:30</strong>    Śluzowanie Morzysław – 30 minut\n<strong>14:30- 16:00</strong>   Śluza Morzysław – Bulwar Nadwarciański (5 km trasy)\n<strong>16:00</strong>              <strong>META</strong> / zakończenie spływu / Bulwar Nadwarciański – grill, konkursy z nagrodami, zabawy w stylu szanty<strong>Organizator:</strong> Lokalna Organizacja Turystyczna „Marina”\n<strong>Współorganizatorzy: </strong>Miasto Konin, Centrum Informacji Miejskiej w Koninie\n<strong>Partner: </strong>Ośrodek Szkoleniowo-Wypoczynkowy „Wityng” w Mikorzynie\n<strong>Patronat medialny:</strong> LM Lokalne Media, Przegląd Koniński, Radio Zet Gold</div>\n<strong>Organizatorem Spływu kajakowego „Wodna przygoda na szlaku Wielkiej Pętli Wielkopolski” jest Lokalna Organizacja Turystyczna „Marina”.</strong>\n\nWydarzenie pn. Spływ kajakowy „Wodna przygoda na szlaku Wielkiej Pętli Wielkopolski”\nwspółfinansowane jest przez Miasto Konin.\n<div></div>\n<div><strong>Impreza została objęta Patronatem Honorowym Prezydenta Miasta Konina.</strong></div>', 'Spływ kajakowy', '', 'trash', 'open', 'open', '', 'splywe-kajakowy-9-wrzesnia__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=704', 0, 'post', '', 0),
 (708, 1, '2017-09-05 23:44:06', '2017-09-05 21:44:06', '[caption id="" align="aligncenter" width="362"]<a href="http://www.mgok.slesin.pl/asp/pliki/plakaty/plastyczne.jpg"><img class="size-medium" src="http://www.mgok.slesin.pl/asp/pliki/plakaty/plastyczne.jpg" width="362" height="500" /></a> M-GOK Ślesin[/caption]', 'Zajęcia plastyczne', '', 'trash', 'open', 'open', '', 'zajecia-plastyczne__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=708', 0, 'post', '', 0),
 (710, 1, '2017-09-05 23:45:08', '2017-09-05 21:45:08', '[caption id="" align="aligncenter" width="2480"]<a href="http://www.mgok.slesin.pl/asp/pliki/grafika/plakat.jpg"><img class="size-medium" src="http://www.mgok.slesin.pl/asp/pliki/grafika/plakat.jpg" width="2480" height="3508" /></a> M-GOK Ślesin[/caption]', 'Nabór do Klubu Szachowego', '', 'trash', 'open', 'open', '', 'nabor-do-klubu-szachowego__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=710', 0, 'post', '', 0),
 (713, 1, '2017-09-06 00:01:55', '2017-09-05 22:01:55', '[caption id="" align="alignleft" width="301"]<a href="https://www.facebook.com/856073014450089/photos/pcb.1643936488997067/1643934722330577/?type=3&amp;theater"><img class="" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/21272471_1643934722330577_4047757672083137305_n.jpg?oh=8d09282cf35b2bd3384965bb3b30361c&amp;oe=5A599093" width="301" height="226" /></a> Źródło: facebook.com/Honorowi-Dawcy-Krwi-Ślesin[/caption]\n\n<strong>2. września 2017 odbyła się akcja krwiodawstwa na której zgromadziło się mnóstwo osób chcących oddać krew. Przyszli klubowicze oraz osoby, które pierwszy raz oddały krew i chciały dołączyć do klubu...</strong>\n\n<!--more-->\n\nJak zawsze cieszyliśmy się dobrymi ciastami i dużą ilością oddanej krwi. Tego dnia zarejestrowało się 61 osób, z czego 60 oddało krew dając wynik 27.000 ml. Warto wspomnieć iż Prezes Mirosław Wesołowski w tym dniu oddał 60 litrów krwi - jest to dla Naszego klubu wielka duma i każdy krwiodawca chce dogonić tę ilość.\n\nTekst: facebook.com/Honorowi-Dawcy-Krwi-Ślesin-856073014450089/', 'Kolejna akcja za nami...', '', 'trash', 'open', 'open', '', 'kolejna-akcja-za-nami__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=713', 0, 'post', '', 0),
 (718, 1, '2017-09-07 07:22:46', '2017-09-07 05:22:46', '[caption id="" align="alignleft" width="342"]<a href="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/21314326_148801649049674_2526464245457237825_n.jpg?oh=6b4f11bc070508dce936e86d41bbaf73&amp;oe=5A5021A1"><img class="" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/21314326_148801649049674_2526464245457237825_n.jpg?oh=6b4f11bc070508dce936e86d41bbaf73&amp;oe=5A5021A1" width="342" height="192" /></a> facebook.com/lksslesin/[/caption]\n\n<strong>Po emocjonującym meczu w derbarch regionu, które odbyły się wczoraj na ślesińskim stadionie wygrał LKS Ślesin!</strong>\nLks Ślesin - Strażak Licheń 3:2(1:2)\n\n<!--more-->\nBramki strzelili:\nBartek Nowak\nMarcin Marciszak\n\nWielu zawodników grających w Licheniu w poprzednich latach reprezentowało barwy Lks Ślesin. Po raz pierwszy Strażak przystępował w roli faworyta grając w wyższej klasie rozgrywkowej.', 'LKS Ślesin wygrał ze Strażakiem Licheń', '', 'trash', 'open', 'open', '', 'lks-slesin-wygral-ze-strazakiem-lichen__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=718', 0, 'post', '', 0),
 (720, 1, '2017-09-07 22:10:38', '2017-09-07 20:10:38', '[caption id="" align="alignleft" width="291"]<a href="http://www.akademiareissa.pl/uploads/files/APRKarnet.jpg"><img class="" src="http://www.akademiareissa.pl/uploads/files/APRKarnet.jpg" width="291" height="207" /></a> akademiareissa.pl[/caption]\n\n<strong>Kariery i nieudawanego dystansu do siebie może mu pozazdrościć niejeden profesjonalny piłkarz. Spełniając jedną z swych największych pasji, z dnia na dzień realizuje się w dziedzinie, którą kocha od dziecka. Poznajcie jednego z najlepszych reprezentantów Polski i od niedawna patrona własnej Akademii – Sławomira Peszko.  </strong><!--more-->\n\n\n\n<strong>- Wróćmy do początków. Swoją karierę rozpocząłeś w wieku 11 lat, w Nafcie Jedlicze, skąd w 2000 roku przeniosłeś się do Wisły Płock. Czy z własnych doświadczeń potrafisz wskazać na czynniki, które lawinowo przyczyniały się do Twojego sukcesu?</strong>\n\n- Nic nie przychodzi samo. Od kiedy pamiętam, zawsze ciężko pracowałem na to, aby rozegrać mecz z orzełkiem na piersi. Piłka od zawsze była moją pasją. Warto jednak zaznaczyć, że to sport, który wymaga wytrwałości i ciągłej chęci ulepszania własnych umiejętności. Oczywiście konsekwencja i determinizm są niezbędne. Trudno wskazać mi na poszczególne czynniki, które spowodowały, że jestem w tym miejscu, w którym jestem. Na pewno nic nie udałoby się bez profesjonalnej opieki trenerów, na którą mogłem liczyć podczas gry w wielu klubach. Często za sukcesem piłkarzy stoi nie tylko rodzina i najbliżsi, ale szereg ludzi, którzy wkładają mnóstwo pracy w odpowiednią formę i nastawienie zawodników.\n\n[caption id="" align="alignright" width="258"]<a href="http://www.akademiareissa.pl/uploads/images/Peszko.jpg"><img class="" src="http://www.akademiareissa.pl/uploads/images/Peszko.jpg" width="258" height="145" /></a> akademiareissa.pl[/caption]\n\n<strong>- Od niedawna sam prowadzisz własną Akademię. Stworzenie takiego projektu to nie lada wyzwanie. Czy istnieje klub, na którym się wzorowałeś budując własną szkółkę? </strong>\n\n- Śmiało mogę powiedzieć, że nic nie udałoby się bez wsparcia mojego znajomego – Piotra Reissa. To on pomógł mi utworzyć własną Akademię. Od początku działań związanych ze stworzeniem własnej szkółki wzorowałem się na istniejącej już od 7 lat Akademii Piłkarskiej Reissa. W projekcie, któremu patronuje Rejsik, zaimponowała mi nie tylko realizowana metodologia szkolenia, ale i moim zdaniem, świetny pomysł dotyczący struktury organizacyjnej. Dzięki takiemu rozwiązaniu, każdy miłośnik futbolu, niezależnie od miejsca zamieszkania, może realizować własną pasję w profesjonalnej szkółce piłkarskiej.\n\n<strong>- No właśnie. Innowacyjna metodologia szkolenia, rozbudowana struktura organizacyjna. Jakie jeszcze mocne strony dostrzegasz w szkółce Piotra Reissa? </strong>\n\n-  Akademia Piłkarska Reissa to idealne miejsce dla każdego dziecka. Celowo w tym momencie podkreślam słowo „każdego”. Tutaj nie dyskryminuje się dzieci mniej uzdolnionych, nie stawia się na wygraną i nie wprowadza niepotrzebnej presji. To klub, w którym każdy może się sprawdzić. Nieczęsto mamy możliwość zapisania własnych pociech na tego typu zajęcia. Młodzi piłkarze, bo tak należy ich nazwać, są opatrzeni stałym nadzorem i wsparciem ze strony trenerów i asystentów.\n\n<strong>- Jesteś już doświadczonym piłkarzem. Dla wielu poczatkujących miłośników futbolu – idolem. Czy jest coś, o czym chciałbyś powiedzieć swoim młodszym kolegom z boiska? </strong>\n\n- Myślę, że priorytetem w trenowaniu własnego warsztatu piłkarskiego, jest przede wszystkim wiara. To właśnie ona potrafi zdziałać cuda. Wierzę, że odpowiednie nastawienie, zaangażowanie i ciężka praca na treningach, stanowią podwaliny do spełnienia nawet tych najskrytszych marzeń.\n\nRozmawiała: Magdalena Rychlik\n\nŹródło: <strong>Klub Sportowy Akademia Piłkarska Reissa</strong>', 'Sławomir Peszko otwarcie o inspiracji Akademią Piłkarską Reissa', '', 'trash', 'open', 'open', '', 'slawomir-peszko-otwarcie-o-inspiracji-akademia-pilkarska-reissa__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=720', 0, 'post', '', 0),
 (722, 1, '2017-09-07 22:16:31', '2017-09-07 20:16:31', '[caption id="" align="alignleft" width="271"]<a href="https://www.facebook.com/lksslesin/"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/21317494_148946802368492_5690802249652830372_n.jpg?oh=f718f0fc8bb885fa64e6a775494a2844&amp;oe=5A122D6C" width="271" height="152" /></a> facebook.com/lksslesin[/caption]\n\n<strong>Już dziś zapraszamy na spotkanie 3 kolejki A klasy grupy 2 w którym to LKS Ślesin podejmować będzie zespół Orłów Huta Łukomska.</strong>\n\nMecz rozegrany będzie 9 września, tj. sobota, o godzinie 17 w Ślesinie. Wszystkich zainteresowanych oraz chcących wesprzeć popularnych Skicioków zapraszamy do kibicowania.\n\n&nbsp;', 'LKS zagra z Hutą Łukomską', '', 'trash', 'open', 'open', '', 'lks-zagra-z-huta-lukomska__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=722', 0, 'post', '', 0),
 (724, 1, '2017-09-07 22:24:34', '2017-09-07 20:24:34', '<div class="text_full" align="justify">\n\n[caption id="" align="alignleft" width="280"]<a href="http://www.przegladkoninski.pl/PL-H5/3/4699/radni-powiatowi-wsparli-strazakow-ochotnikow-dali-pieniadze-na-okna-i-drzwi.html"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StLS05NTE5MzYtMjAxNzA5MDdfMTIxNzI2LmpwZw==.jpg" width="280" height="157" /></a> przegladkoninski.pl[/caption]\n\n<strong>Starosta Stanisław Bielik poinformował radnych, że zarząd Powiatu Konińskiego w związku z dłuższym zwolnieniem lekarskim obecnej dyrektor Domu Pomocy Społecznej w Ślesinie Joanny Wołyńskiej, powierzył to stanowisko pracownicy tej instytucji – Danucie Kaczmarek.</strong><!--more-->\n\n\n\nDzisiaj radni Powiatu Konińskiego przekazali po 10 tysięcy złotych czterem gminom – Rzgów, Kazimierz Biskupi, Kramsk i Stare Miasto. Te pieniądze podzielą między sobą strażacy-ochotnicy i przeznaczą je na remonty strażnic oraz garaży – wymianę okien, drzwi, ocieplenie ścian. Remonty będą miały miejsce u strażaków w Rzgowie, Zarzewie, Bochlewie, Bielawach, Grąblinie, Główiewie, Janowicach, Karsach i Żychlinie.\n\n<img class="size-medium wp-image-522 alignright" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="300" height="78" />Wszystko wskazuje na to, że przetarg na remont drogi powiatowej Brzeźno-Krzymów zostanie unieważniony. Jak mówił starosta Stanisław Bielik, oferent, który miał wykonać modernizację wycofał się.\n\nPrawdopodobnie Rada Powiatu Konińskiego wesprze też poszkodowaną podczas nawałnic gminę Czerniejewo (powiat gnieźnieński). Jak mówił Stanisław Bielik, już wcześniej kontaktował się z władzami gminy w tej sprawie. W związku z tym, że nie potrafiono jeszcze wtedy określić potrzeb, starosta umówił się na kolejny kontakt.\n\n</div>\n<div class="clearfix"></div>\n<div class="clearfix">Tekst: Milena Fabisiak</div>', 'Radni powiatowi wsparli strażaków-ochotników', '', 'trash', 'open', 'open', '', 'radni-powiatowi-wsparli-strazakow-ochotnikow__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=724', 0, 'post', '', 0),
 (726, 1, '2017-09-07 22:27:07', '2017-09-07 20:27:07', '<div class="text_full" align="justify">\n\n[caption id="" align="alignleft" width="319"]<a href="http://www.przegladkoninski.pl/PL-H5/3/4692/rusza-remont-ulicy-przemyslowej-i-slesinskiej-w-koninie-do-kiedy-beda-utrudnienia.html"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StLS03OTgyNzQtcHJ6ZW15c2xvd2EuSlBH.jpg" width="319" height="211" /></a> przegladkoninski.pl[/caption]\n\n<strong>Można się spodziewać, że w przyszłym tygodniu rozpocznie się remont ponad 400-metrowego odcinka ulicy Ślesińskiej (do wiaduktu w Honoratce, czyli do granicy z gminą Ślesin) oraz prawie kilometra Przemysłowej (na wysokości ulicy Gaj). Kierowcy muszą liczyć się z utrudnieniami w ruchu, bo najprawdopodobniej wprowadzony zostanie tam ruch wahadłowy.</strong>\n<!--more-->\n\n\nPrzetarg wygrała firma Skanska i wykona te prace za około 5,8 miliona złotych (brutto). Dofinansowanie z rządowego programu wynosi prawie 1 milion 600 tysięcy złotych.\n\nPierwszy przetarg nie został rozstrzygnięty. Wtedy oferta z najniższą ceną przewyższała kwotę, jaką ZDM zamierzał przeznaczyć na to zadanie. Były zapowiedzi, że w kolejnym nie zostaną ujęte już ekrany dźwiękochłonne (przy ulicy Ślesińskiej), bo ich koszt to ponad 1 milion 400 tysięcy złotych. Po protestach mieszkańców i radnych tak się nie stało i to zadanie nie zostało „wyrzucone”.\n\n<img class="size-medium wp-image-522 alignright" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="300" height="78" />Najprawdopodobniej prace rozpoczną się w przyszłym tygodniu.\n\n– Została zawarta umowa. Firma już działa, zamawia materiały – mówi Grzegorz Pająk, dyrektor Zarządu Dróg Miejskich w Koninie. Wszystko wskazuje na to, że będzie tam wprowadzony ruch wahadłowy. Termin zakończenia prac to 15 listopada tego roku.\n\n</div>\n<div class="clearfix"></div>\n<div class="clearfix"> Tekst: Marcin Szafrański</div>', 'Rusza remont ulicy Przemysłowej i Ślesińskiej w Koninie', '', 'trash', 'open', 'open', '', 'rusza-remont-ulicy-przemyslowej-i-slesinskiej-w-koninie__trashed', '', '', '2017-10-23 15:48:16', '2017-10-23 15:48:16', '', 0, 'http://gminaslesin.futurehost.pl/?p=726', 0, 'post', '', 0),
 (729, 1, '2017-09-07 22:43:55', '2017-09-07 20:43:55', '[caption id="" align="alignleft" width="363"]<a href="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/21369170_1287120531416004_3562277060570560133_n.jpg?oh=00c66a0774898c6a0764c28f30b0569a&amp;oe=5A52B7B5"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/21369170_1287120531416004_3562277060570560133_n.jpg?oh=00c66a0774898c6a0764c28f30b0569a&amp;oe=5A52B7B5" width="363" height="512" /></a> facebook.com/gminaslesin[/caption]\n\n<strong>W dniu 9. września 2017 r. od godz. 11:00 do godz. 15:00 odbędzie się Dzień Sportu na Orliku.</strong>\n\nZapraszamy do udziału zawodników wraz z rodzicami oraz wszystkich chętnych do aktywnego spędzenia czasu.', 'Dzień Sportu na Orliku', '', 'trash', 'open', 'open', '', 'dzien-sportu-na-orliku__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=729', 0, 'post', '', 0),
 (736, 1, '2017-09-08 15:54:01', '2017-09-08 13:54:01', '[caption id="" align="alignleft" width="204"]<img src="data:image/jpeg;base64,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" alt="" width="204" height="135" /> wielkopolska.tv[/caption]\n\n<strong> Dwadzieścia drużyn wzięło udział w X Powiatowych Zawodach Sportowo – Pożarniczych Ochotniczych Straży Pożarnych. Ocenie podlegały dwie konkurecje: ćwiczenia bojowe oraz sztafeta pożarnicza 7 x 50 metrów z przeszkodami.</strong> <!--more-->\n<iframe src="http://wielkopolska.tv/slesin-walczyli-w-powiatowych-zawodach/?RVPInstanceName=fwduvpPlayer0&amp;RVPPlaylistId=0&amp;RVPVideoId=0#/?playlistId=0&amp;videoId=0" width="779" height="438" frameborder="0" scrolling="no" allowfullscreen="allowfullscreen"></iframe>\nStartujące drużyny mogły również zaprezentować się w konkurencji musztry, która nie podlegała ocenie ogólnej klasyfikacji. Oprócz stratujących 14-tu drużyn męskich, swój udział zanotowało 6 kobiecych. I choć nie wszystkie łączy długa historia współpracy, to wytrwałość i zaangażowanie według Anety Lipińskiej, dowódcy drużyny pożarniczej OSP Patrzyków, są kluczem do odnoszenia sukcesów.\n\n&nbsp;\n\nŹródło: wielkopolska.tv', 'Walczyli w powiatowych zawodach', '', 'trash', 'open', 'open', '', 'walczyli-w-powiatowych-zawodach__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=736', 0, 'post', '', 0),
 (743, 1, '2017-09-10 00:33:38', '2017-09-09 22:33:38', '<strong><img class="alignleft" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/12043165_1487575074877922_1776478986692669327_n.jpg?oh=b9c235ddda4f11efa3384c379a75958b&amp;oe=5A51A601" width="170" height="134" />24 września 2017 r. odbędzie się już po raz IV Jarmark Ochweśnicki. Zapraszamy wszystkich wystawców, rękodzielników oraz pasjonatów kultury ludowej do udziału w wydarzeniu.</strong>\n\nZgłoszenia <span class="ffwd_blog_style_object_description_hide">przyjmowane są pod numerem telefonu 63 2704 011 wew. 11 lub @mail: promocja@slesin.pl\nUdział w wydarzeniu jest bezpłatny.</span>', 'Zaproszenie na  IV Jarmark Ochweśnicki', '', 'trash', 'open', 'open', '', 'zaproszenie-na-iv-jarmark-ochwesnicki__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=743', 0, 'post', '', 1),
 (745, 1, '2017-09-10 00:37:29', '2017-09-09 22:37:29', '[caption id="" align="alignleft" width="283"]<a href="https://www.lm.pl/aktualnosci/informacja/111325/ahoj_przygodo_poplyneli_kajakami_z_mikorzyna_do_konina"><img class="" src="https://m.lm.pl/media/foto/292340_4245_714.JPG" width="283" height="190" /></a> LM.pl[/caption]\n\n<strong>Ponad setka uczestników wzięła udział w sobotnim spływie kajakowym z Mikorzyna do Konina. Kajakarze do pokonania mieli osiemnastokilometrową trasę.</strong>\n\n<!--more-->\n\n,,Wodna przygoda na szlaku Wielkiej Pętli Wielkopolski” rozpoczęła się w sobotni poranek w Mikorzynie. Kajakarze wypłynęli na Jezioro Mikorzyńskie, a następnie wpłynęli na Jezioro Wąsowskie i Jezioro Pątnowskie. Dalej osiemnastokilometrowa trasa wiodła przez kanał Warta-Gopło i dwie śluzy w Pątnowie oraz Morzysławiu. Meta – na konińskim bulwarze – gdzie uczestnicy powinni pojawić się po południu.<img class="size-full wp-image-503 alignright" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/240915_logo_standard.png" alt="" width="175" height="70" />\n\nNa tegoroczny spływ zdecydowała się ponad setka uczestników. Wśród nich m.in. zastępca prezydenta Konina Sławomir Lorek, czy Przewodniczący Rady Miasta Wiesław Steinke. Pogoda amatorom wodnych wrażeń dopisała – po deszczowych i chłodnych dniach w sobotę kajakarzom towarzyszyło słońce.\n\nPo spływie na wszystkich uczestników czekał ciepły posiłek oraz dodatkowe atrakcje – konkursy z nagrodami i zabawa w stylu szanty. Spływ zorganizowano z okazji Światowego Dnia Turystyki.\n\n&nbsp;\n\nŹródło: Bartosz Skonieczny - LM.pl', 'Ahoj przygodo! Popłynęli kajakami z Mikorzyna do Konina', '', 'trash', 'open', 'open', '', 'ahoj-przygodo-poplyneli-kajakami-z-mikorzyna-do-konina__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=745', 0, 'post', '', 1),
 (747, 1, '2017-09-10 00:41:22', '2017-09-09 22:41:22', '<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 name-page">\n<h3>Gospodynie z całej Polski przyjechały do Lichenia. Popisywały się talentami</h3>\n</div>\n<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">\n<div class="homenews1 full_news">\n<div class="row">\n<div class="embed-responsive embed-responsive-16by9"><iframe class="embed-responsive-item" src="https://www.youtube-nocookie.com/embed/P8HqaVTCg78?rel=0" width="300" height="150" allowfullscreen="allowfullscreen" data-mce-fragment="1"></iframe></div>\n<div class="text_full" align="justify">\n\n[caption id="" align="alignright" width="286"]<a href="http://www.przegladkoninski.pl/PL-H5/3/4722/gospodynie-z-calej-polski-przyjechaly-do-lichenia-popisywaly-sie-talentami.html"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StNDcyMi0yMDQ2OTMtRFNDXzAyMzkuSlBH.jpg" width="286" height="191" /></a> przegladkoninski.pl[/caption]\n\n<strong>Jarmarkiem Kulturowym rozpoczął się 9 września w Licheniu VII Ogólnopolski Zjazd Kół Gospodyń Wiejskich i Innych Organizacji Kobiecych z Terenów Wiejskich. Na placu przed jeziorem Licheńskim pojawiło się kilkadziesiąt stoisk, na których gospodynie zaprezentowały swoje popisowe potrawy.</strong> Dużym zainteresowaniem cieszyły się też misternie wykonane prace. Królował haft i rzeźba. Jutro w południe panie będą się modlić w licheńskiej bazylice. <a href="http://www.przegladkoninski.pl/PL-H5/3/4722/gospodynie-z-calej-polski-przyjechaly-do-lichenia-popisywaly-sie-talentami.html" target="_blank" rel="noopener">Zobacz zdjęcia i materiał TV.</a>\n\n<!--more-->\n\nLicheńska plaża przyciągnęła dziś prawdziwe tłumy. Każdy mógł skosztować smakołyków przygotowanych przez gospodynie, a także wziąć udział w konkursach. Śmiałkowie prezentowali swoje umiejętności np. w… dojeniu krowy. Na scenie przed publicznością zaprezentowały się zespoły folklorystyczne.\n\n<img class="alignleft wp-image-522" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="165" height="43" />Niedziela to drugi dzień Zjazdu. Gospodynie przemaszerują w barwnym korowodzie do licheńskiej bazyliki, gdzie będą modlić się podczas mszy świętej o godz. 12.00. Spotkanie zakończy koronka do Miłosierdzia Bożego odmówiona w kaplicy Trójcy Świętej, po której przy pomniku św. Jana Pawła II odśpiewana zostanie „Barka”.\n\nVII Ogólnopolski Zjazd Kół Gospodyń Wiejskich i Innych Organizacji Kobiecych z Terenów Wiejskich organizuje Stowarzyszenie Kobiet na Rzecz Promocji i Rozwoju Gminy Ślesin.\n\n</div>\n</div>\n</div>\n</div>\n&nbsp;', 'Gospodynie z całej Polski przyjechały do Lichenia', '', 'trash', 'open', 'open', '', 'gospodynie-z-calej-polski-przyjechaly-do-lichenia__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=747', 0, 'post', '', 0),
 (751, 1, '2017-09-11 00:09:01', '2017-09-10 22:09:01', '[caption id="" align="alignleft" width="225"]<a href="http://www.przegladkoninski.pl/PL-H5/3/4731/kto-zostal-rolnikiem-roku-a-kto-wykonal-najpiekniejszy-wieniec-dzis-swietuje-gmina-stare-miasto-wraz-z-powiatem-i-diecezja.html"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StLS0zNzAxNDItRFNDXzE4NzAuSlBH.jpg" width="225" height="149" /></a> przegladkoninski.pl[/caption]\n\n<strong>Tegoroczny sezon dożynkowy kończy gmina Stare Miasto. Jej wójt wraz ze starostą konińskim i diecezją włocławską zorganizowali święto plonów dla całego regionu.</strong> Wśród wielu gości - parlamentarzystów, samorządowców, także z gmin partnerskich z Ukrainy i Czech, przedstawicieli organizacji, stowarzyszeń i firm, wręczono nagrody „Zasłużony dla powiatu konińskiego”, przyznano także tytuł Rolnika Roku. Spośród 33 wieńców wybrano najładniejszy.<!--more-->\n\nW tym roku funkcję starostów Diecezjalno-Powiatowo-Gminnych Dożynek w Starym Mieście pełnili: Hanna Przybyłowicz i Tomasz Kwieciński, towarzyszyli im asystenci: Monika Dąbek i Adrian Walczak. To oni przekazali na ręce biskupa, starosty i wójta bochen chleba upieczony z mąki z tegorocznych zbiorów, a gospodarze symbolicznie rozdzielili go wśród zgromadzonych. O oprawę części obrzędowej uroczystości zadbał Zespół Ludowy „Kruszynioki” z powiatu włocławskiego.\n\nWcześniej jednak, podczas liturgii w kościele św. ap. Piotra i Pawła w Starym Mieście, koncelebrowanej przez ordynariusza diecezji włocławskiej bpa Wiesława Meringa, poświęcono 33 wieńce i chleby wypieczone z tegorocznego ziarna.\n\nOficjalną część obchodów przygotowano na placu parafialnym. Tam wręczono dziewięć odznaczeń „Zasłużony dla rolnictwa” oraz dwa tytuły honorowe „Zasłużony dla powiatu konińskiego”. Na dożynkowej scenie zaprezentowali się także wszyscy nominowani do tytułu „Powiatowy Rolnik Roku 2017”. W tym roku statuetki „Żniwiarza” otrzymali: Katarzyna i Waldemar Budni prowadzący 108-hektarowe gospodarstwo w Ladorudzu (gm. Krzymów), <strong>Aleksandra i Włodzimierz Kowalscy posiadający 61,5-hektarowe gospodarstwo w miejscowości Kolebki (gm. Ślesin)</strong>, Agata i Tomasz Rybarczykowie, właściciele 27-hektarowego gospodarstwa w miejscowości Lisewo (gm. Skulsk), Anna i Norbert Sieczkowie prowadzący 70-hektarowe gospodarstwo w miejscowości Kawnice Kolonia (gm. Golina) oraz <strong>Beata i Jacek Woźniakowie z miejscowości Sarnowa (gm. Ślesin)</strong>.\n\n– Jesteśmy wam wdzięczni za trud i za to, że na polskim stole nigdy nie zabraknie chleba. Że możemy się nim dzielić również z innymi. Dziękuję za waszą aktywność, nie tylko w rolnictwie, ale i samorządach. Oby polska ziemia dała wam najobfitsze plony i abyście mieli jak najwięcej korzyści, nie tylko tych materialnych, ale również satysfakcji z trudniej i odpowiedzialnej pracy – zwracał się do rolników starosta Stanisław Bielik.\n\nNagrodę i dyplom za najpiękniejszy z 33 pokazanych dziś wieńców otrzymało sołectwo Wilczyn. W Starym Mieście zabawa potrwa dziś do późnych godzin wieczornych.', 'Kto został Rolnikiem Roku, a kto wykonał najpiękniejszy wieniec? Dożynki powiatowe', '', 'trash', 'open', 'open', '', 'kto-zostal-rolnikiem-roku-a-kto-wykonal-najpiekniejszy-wieniec-dozynki-powiatowe__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=751', 0, 'post', '', 0),
 (753, 1, '2017-09-11 00:12:21', '2017-09-10 22:12:21', '[caption id="" align="alignleft" width="180"]<a href="https://www.facebook.com/lksslesin/"><img class="size-medium" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/19732256_129303017666204_4877538086701564282_n.png?oh=e1a9f776dc6404115b447d888ed584ef&amp;oe=5A1D86F2" width="180" height="180" /></a> facebook.com/lksslesin/[/caption]\n\n<strong>LKS Ślesin wygrał po niełatwym meczu z Orłami Huta Łukomska 4:1. </strong>\n\nOd początku spotkania wiedzielismy, że rywale nie przyjechali do Ślesina, by tylko rozegrać mecz i postawili ciężkie warunki. Mecz stał na wysokim poziomie, czego skutkiem bylo skromne prowadzenie 2:1 do przerwy. Jednak po zmianie stron to drużyna Skicioków dyktowala warunki gry, czego efektem było zdobycie dwóch kolejnych bramek. Oby tak dalej!', 'Wygrana z Hutą Łukomską', '', 'trash', 'open', 'open', '', 'wygrana-z-huta-lukomska__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=753', 0, 'post', '', 0),
 (755, 1, '2017-09-11 23:46:00', '2017-09-11 21:46:00', '<div id="js_ro" class="_5pbx userContent" data-ft="{&quot;tn&quot;:&quot;K&quot;}">\n<div id="id_59b703596a7cf0980313985" class="text_exposed_root text_exposed">\n\n[caption id="" align="alignleft" width="136"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1746299739005453/1746298172338943/?type=3&amp;theater"><img class="" src="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/21462745_1746298172338943_166484630718463813_n.jpg?oh=6fbcde17979a848e70c6ec1428b80fda&amp;oe=5A17F44D" width="136" height="242" /></a> facebook.com/mgokslesin/[/caption]\n\n<strong>Jedenastu zawodników Klubu Szachowego M-GOK Gambit Ślesin wzięło udział w niedzielnym turnieju szachowym i bowlingowym Szach-Strike-Mat w Poznaniu. Turniej odbył się w Centrum Rozrywki MK BOWLING w Galerii MM w Poznaniu.</strong>\n\n<!--more-->\n\nByła to kolejna edycja turnieju łączącego szachy z inną dyscypliną sportową. W ramach turnieju rozegrano dwa indywidualne turnieje: szachowy i bowlingowy z podziałem na kategorie wiekowe turniej A dla d<span class="text_exposed_show">zieci do III klasy szkoły podstawowej, turniej B dla dzieci od IV do VII klasy szkoły podstawowej, turniej C dla dzieci i młodzieży szkół ponadpodstawowych, turniej D dla dorosłych. W turnieju można było zdobywać punkty w szachach jak i w bowlingu, które na zakończenie były sumowane.</span>\n\n<span class="text_exposed_show">Był to pierwszy taki turniej dla naszych szachistów, w którym poradzili sobie bardzo dobrze zdobywając miejsca na podium.</span>\n<div class="text_exposed_show">\n\nW klasyfikacji łącznej obu dyscyplin zajęliśmy następujące miejsca:\n\nAda Chojnacka pierwsze miejsce w turnieju A grupa dziewcząt\nTymoteusz Łachacz drugie miejsce w turnieju A grupa chłopców\nMichał Pawlak drugie miejsce w turnieju B grupa chłopców\nNikola Majdecka pierwsze miejsce w turnieju C grupa dziewcząt\nSebastian Sajniak drugie miejsce w turnieju C grupa chłopców\nArkadiusz Łapot trzecie miejsce w turnieju C grupa chłopców\n\n</div>\n</div>\n</div>\n&nbsp;\n<div class="_3x-2"></div>', 'Sześciu szachistów na podium Szach-Strike-Mat w Poznaniu', '', 'trash', 'open', 'open', '', 'szesciu-szachistow-na-podium-szach-strike-mat-w-poznaniu__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=755', 0, 'post', '', 0),
 (757, 1, '2017-09-12 21:25:17', '2017-09-12 19:25:17', '[caption id="" align="alignleft" width="312"]<a href="https://www.lm.pl/aktualnosci/informacja/111344/kilka_tysiecy_uczestniczek_na_zjezdzie_kol_gospodyn_wiejskich"><img class="" src="https://m.lm.pl/media/foto/292723_3141_714.jpg" width="312" height="208" /></a> Źródło: LM.pl[/caption]\n\n<strong>Kilka tysięcy uczestniczek na ogólnopolskim zjeździe Kół Gospodyń Wiejskich w Licheniu.</strong>\n\n<!--more-->\n\nNajpierw uczestniczki spotkały się na jarmarku kulturowym nad jeziorem Licheńskim, gdzie m.in. odbył się przegląd zespołów folklorystycznych. Smakosze mogli skosztować regionalnych specjałów przygotowanych przez gospodynie specjalnie na tę okazję. Z kolei na boisku sportowym za szkołą podstawową po raz pierwszy zorganizowano turniej piłki nożnej gospodyń.\n\nZdaniem pani Wandy Waleriańczyk, prezes Stowarzyszenia Polska Gospodyni, licheński zjazd jest przede wszystkim okazją do spotkania się kobiet polskiej wsi w celu wymiany doświadczeń kobiet mieszkających w różnych zakątkach kraju.\n\nW niedzielę gospodynie przeszły w tzw. „różańcowym spacerku” z kościoła pw. św. Doroty do miejsca objawień Matki Bożej w lesie grąblińskim. Natomiast o godz. 12.00 uczestniczki zjazdu udały się na mszę w bazylice, której przewodniczył ks. Bogusław Binda MIC, przełożony licheńskiej wspólnoty marianów. Oprawę muzyczną mszy zapewnił zespół „Dębowiacy” z gminy Stupsk Mazowiecki (powiat mławski) oraz Pałac Kultury Zagłębia i Koło Gospodyń „Tucznawa” z Dąbrowy Górniczej. Zwieńczeniem pielgrzymki było wspólne odśpiewanie „Barki” przed pomnikiem św. Jana Pawła II znajdującym się przed licheńską bazyliką.\n\nVII Ogólnopolski Zjazd Kół Gospodyń Wiejskich i Innych Organizacji Kobiecych z Terenów Wiejskich zorganizowało Stowarzyszenie Polska Gospodyni. Patronat honorowy nad wydarzeniem sprawował pan Andrzej Duda, Prezydent Rzeczypospolitej Polskiej.\n\nŹródło: LM.pl', 'Kilka tysięcy uczestniczek na zjeździe Kół Gospodyń Wiejskich', '', 'trash', 'open', 'open', '', 'kilka-tysiecy-uczestniczek-na-zjezdzie-kol-gospodyn-wiejskich__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=757', 0, 'post', '', 0),
 (759, 1, '2017-09-12 21:28:42', '2017-09-12 19:28:42', '[caption id="" align="alignleft" width="264"]<a href="https://www.lm.pl/aktualnosci/informacja/111334/lichen_i_xiv_ogolnopolska_pielgrzymka_honorowych_dawcow_krwi"><img class="" src="https://m.lm.pl/media/foto/292545_5846_350.jpg" width="264" height="148" /></a> LM.pl[/caption]\n\n<strong>Do sanktuarium maryjnego w Licheniu przybyła XIV ogólnopolska pielgrzymka honorowych dawców krwi.</strong>\n\nPodczas uroczystej mszy ks. Mirosław Frankowski, duszpasterz Honorowych Dawców Krwi diecezji włocławskiej, przekazał na ręce ks. Adama Stankiewicza MIC, wicekustosza licheńskiego sanktuarium, akt nadania medalu 30-lecia Klubu Honorowych Dawców Krwi PCK przy Spółdzielni Mieszkaniowej w Swarzędzu dla Sanktuarium Matki Bożej Licheńskiej w Licheniu Starym. Krwiodawcom dziękowano natomiast za postawę godną naśladowania.<img class="size-full wp-image-503 alignright" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/240915_logo_standard.png" alt="" width="175" height="70" />\n\nPielgrzymi udali się jeszcze na plac z trzema dzwonami, gdzie uczestnictwem w Drodze Krzyżowej zakończyli tegoroczne pielgrzymowanie.', 'Licheń i XIV ogólnopolska pielgrzymka honorowych dawców krwi', '', 'trash', 'open', 'open', '', 'lichen-i-xiv-ogolnopolska-pielgrzymka-honorowych-dawcow-krwi__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=759', 0, 'post', '', 0),
 (761, 1, '2017-09-12 21:38:09', '2017-09-12 19:38:09', '<strong><img class="alignleft " src="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/12043165_1487575074877922_1776478986692669327_n.jpg?oh=b9c235ddda4f11efa3384c379a75958b&amp;oe=5A51A601" width="159" height="125" />Seniorzy z Klubu Seniora w dniach 24-30 sierpnia udali się na 7-dniowa wycieczkę do Dziwnowa. Podczas wycieczki seniorzy zwiedzili wystawę sprzętu wojskowego, byli również na festynie Komandosa.</strong>\n\n<!--more-->\n\nNie zabrakło wieczornych spacerów po plaży oraz wieczorków tanecznych. Odbyli także wycieczkę do Międzyzdrojów gdzie zwiedzili Promenadę Gwiazd oraz Muzeum Figur Woskowych. Seniorzy wrócili z wypoczynku zrelaksowani i gotowi do działań w nowym roku kulturalnym 2017/2018. Seniorzy składają podziękowania Panu Burmistrzowi za udostepnienie autobusu, a Zarządowi Banku Spółdzielczego w Ślesinie za ufundowanie biletów do Muzeum Figur Woskowych.', 'Klub Seniora Pogodna Jesień z Miejsko-Gminnego Ośrodka Kultury w Ślesinie na wakacjach', '', 'trash', 'open', 'open', '', 'klub-seniora-pogodna-jesien-z-miejsko-gminnego-osrodka-kultury-w-slesinie-na-wakacjach__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=761', 0, 'post', '', 0),
 (763, 1, '2017-09-12 21:42:20', '2017-09-12 19:42:20', '[caption id="" align="alignleft" width="267"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1746498872318873/1746498552318905/?type=3&amp;theater"><img class="" src="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/21730879_1746498552318905_6669082589883284157_n.jpg?oh=50a1b6f2ec42907e4e1e9a5d1b2fd075&amp;oe=5A13A811" width="267" height="178" /></a> facebook.com/mgokslesin/[/caption]\n\n<strong>„Święto Kapusty” po raz kolejny przyciągnęło wiele osób do Honoratki. W tym Sołectwie już nawet najmłodsze dzieci wiedzą, jak smakuje kapusta. Prześcigają się w pomysłach. W tym roku zorganizowały „PCHLI TARG”, czyli kupię – sprzedam – zamianię, wystawiając swoje dawno nie używane już zabawki.</strong>\n\n<!--more-->\n\nMożna było spotkać także Panie z Kół Gospodyń Wiejskich z Gminy Ślesin, które rywalizowały w konkursach na „Potrawę z Kapusty” oraz w konkursie zręcznościowym, który jednocześnie był pokaz<span class="text_exposed_show">em szatkowania, heblowania i ubijania kapusty dawnymi przedmiotami niezbędnymi w kuchni. Panie raczyły smakoszy potrawami z popularnego warzywa. Nie zabrakło gołąbków, bigosu, kapusty z grochem i fasolą. </span>\n\n<span class="text_exposed_show">Najwięcej emocji wzbudziło deptanie kapusty w którym udział wzięli m.in. sołtys Honoratki - Zbigniew Siupa, radny Sołectwa Honoratki - Paweł Janczewski. Odbyły się także występy solistek Akademii Wokalnej DoReMi z M-GOK w Ślesinie– Mai Bartczak i Wiktorii Długołenckiej, oraz zumba dla najmłodszych . Impreza zakończyła się zabawa taneczną. </span>\n\n<span class="text_exposed_show">Tegoroczne „Święto Kapusty” zorganizowało Koło Gospodyń Wiejskich w Honoratce, Rada Sołecka Sołectwa w Honoratce oraz OSP Honoratka.</span>', 'Święto Kapusty w Honoratce', '', 'trash', 'open', 'open', '', 'swieto-kapusty-w-honoratce-2__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=763', 0, 'post', '', 0),
 (765, 1, '2017-09-12 21:45:07', '2017-09-12 19:45:07', '[caption id="" align="alignleft" width="222"]<img class="" src="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/21751524_1746492838986143_8395721874176759485_n.jpg?oh=29da5ad6473d7c406f220a347a273ac0&amp;oe=5A515E76" width="222" height="148" /> facebook.com/mgokslesin/[/caption]\n\n<strong>W tegorocznych rozgrywkach uczestniczyło 10 drużyn. Poszczególne mecze w rozgrywkach każdy z każdym odbywały się na boiskach ORLIK. Przez dziewięć niedzieli piłkarze walczyli o miano najlepszej drużyny.</strong>\n\n<!--more-->\n\nZwycięzcą Ligi 2017 została drużyna OSIEDLA PÓŁNOC (8 meczy wygranych i jeden remis).\n\nKolejne miejsca to:\n\nII- Piotrkowice,\n\nIII – Osiedle Powstańców Wielkopolskich,\n\nIV -Głębockie/Mikorzyn,\n\nV- Wąsosze,\n\nV<span class="text_exposed_show">I- Szyszyńskie Holendry, </span>\n\n<span class="text_exposed_show">VII- Półwiosek Stary, </span>\n\n<span class="text_exposed_show">VIII- Szyszyn i Ignacewo, </span>\n\n<span class="text_exposed_show">IX- Honoratka. </span>\n\n<span class="text_exposed_show">\nKrólem strzelców został Kornel Broniszewski zdobywając w ciągu trwania całej Ligii aż 27 bramek. </span>\n\n<span class="text_exposed_show">19 goli strzelił Tomasz Staszak, 18- Bartosz Nowak, 17- Mateusz Waleriańczyk. </span>\n\n&nbsp;\n\n<span class="text_exposed_show">Nagrody w postaci bonów na sprzęt sportowy wręczył Burmistrz Miasta i Gminy Ślesin Mariusz Zaborowski. Organizatorzy składają podziękowania dla instruktorów boisk sportowych ORLIK za współpracę w organizację tegorocznej ligi.</span>', 'Sołecka Liga Piłki Nożnej Sołectw i Osiedli Gminy Ślesin 2017 zakończona', '', 'trash', 'open', 'open', '', 'solecka-liga-pilki-noznej-solectwa-i-osiedli-gminy-slesin-2017-zakonczona__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=765', 0, 'post', '', 0),
 (771, 1, '2017-09-14 00:02:53', '2017-09-13 22:02:53', '<strong>Zapraszamy wszystkich do udziału 24.09.2017. Start o godz. 14:00. Będą konkursy, atrakcje, KGW zaprezentują swoje potrawy a zagra zespół Belfast. Szykuje się super impreza.</strong>\n\n[caption id="" align="aligncenter" width="511"]<a href="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/21742856_1293952734066117_5474592675068610360_n.jpg?oh=914038510fe1dd36a1dd3c1191ccf2f6&amp;oe=5A55920E"><img class="" src="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/21742856_1293952734066117_5474592675068610360_n.jpg?oh=914038510fe1dd36a1dd3c1191ccf2f6&amp;oe=5A55920E" width="511" height="720" /></a> facebook.com/gminaslesin/[/caption]', 'Kolejna edycja Jarmarku Ochweśnickiego już wkrótce', '', 'trash', 'open', 'open', '', 'kolejna-edycja-jarmarku-ochwesnickiego-juz-wkrotce__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=771', 0, 'post', '', 0),
 (773, 1, '2017-09-14 00:10:16', '2017-09-13 22:10:16', '[caption id="" align="alignleft" width="275"]<img class="size-medium" src="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/21731050_150546038875235_5198171636594666125_n.jpg?oh=5645f653fbed008d46485b66689ef49e&amp;oe=5A60A8F9" width="275" height="183" /> facebook.com/lksslesin/[/caption]\n\n<strong>Nie lada atrakcje szykują się nam w sobotni dzień na stadionie Miejskim przy ul. Napoleona 1 w Ślesinie.</strong>\n\n<!--more-->Najpierw Juniorzy Starsi w debiucie nowego trenera Marcina Łukowskiego podejmą Górnik Konin. Start tego spotkania o 11:00.\n\nW drugim meczu tego dnia Młodziki Starsze, trenera Bartłomieja Sieka, zmierzą swoje siły z Orłem Grzegorzew o godzinie 13:45.\n<div class="text_exposed_show">\n\nPrzysłowiową wisieńką na torcie bedzie mecz rozgrywany o godzinie 17:00.\nLKS Ślesin vs Piast Grodziec\n\nPodopieczni Macieja Bieniaszczyka będą starali sie zachować zwycieską passę u siebie i wywalczyć komplet punktów.\n\nNa wszystkie te spotkania serdecznie zapraszamy wspierających kibiców. Powodzenia Skicioki!\n\n</div>', 'Sportowa sobota w Ślesinie', '', 'trash', 'open', 'open', '', 'sportowasobota__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=773', 0, 'post', '', 0),
 (775, 1, '2017-09-14 23:09:54', '2017-09-14 21:09:54', '[caption id="" align="alignleft" width="298"]<a href="https://www.lm.pl/aktualnosci/informacja/111392/slesin_nie_udalo_sie_pozyskac_funduszy_mieszkancy_zawiedzeni"><img class="size-medium" src="https://m.lm.pl/media/foto/292961_8322_298.jpg" width="298" height="198" /></a> LM.pl[/caption]\n\n<strong>Ponad 350 mieszkańców gminy Ślesin może odebrać darmową dokumentację techniczną instalacji fotowoltaicznej w swych domach.</strong>\n\n<!--more-->\n\nJednak atmosfera, która towarzyszy tej możliwości, daleka jest od radosnej. Dokumentacja jest pozostałością po wniosku, jaki przygotowywała gmina wraz z firmą Nuvarro. Dotyczył on dofinansowania ogniw fotowoltaicznych. Niestety, w efekcie tych prac burmistrz Mariusz Zaborowski przepraszał mieszkańców gminy.\n\n<img class="size-full wp-image-503 alignright" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/240915_logo_standard.png" alt="" width="175" height="70" />-<em> Przepraszałem, bo narobiłem mieszkańcom i sobie nadziei, że uda się w gminie pobudować u prywatnych osób ogniwa fotowoltaiczne. Niewiele gmin podjęło ryzyko, aby robić to również u mieszkańców, a nie tylko na budynkach użyteczności publicznej. Ryzyko było dość duże, bo możliwości pozyskania funduszy były niewielkie i mówiłem to na początku mieszkańcom - </em>tłumaczył burmistrz podczas spotkania z mieszkańcami.\n\nZ jakiego powodu nie udało się uzyskać funduszy? Przyczyna była dość błaha. Aby w ogóle można było starać się o dofinansowanie, należało przygotować dokumentacje techniczną poszczególnych domostw. W grę wchodziło ponad 350 obiektów, dla których trzeba było przygotować wszystkie niezbędne dane i wyliczenia. Pomimo ogromu włożonej w projekt pracy, wniosku nie udało się złożyć. Firma, która była podwykonawcą zleceniobiorcy nie dopilnowała terminów. Z tego powodu mieszkańcy otrzymają przygotowaną dokumentację, jako pewien rodzaj zadośćuczynienia. Zwrócone zostaną im również pieniądze, które musieli wyłożyć z góry na wykonanie tej usługi. Mowa o kwocie około 300 zł dla każdej osoby. Firma będzie musiała również wypłacić gminie stosowne odszkodowanie.\n\n- <em>Wiele osób liczyło na to, że projekt się powiedzie. Każdy mówił o jednym – o ilości pracy włożonej przez moich pracowników, którzy robili to poza swoimi obowiązkami. Na pewno jednak mnie to nie zniechęci i będziemy próbować ponownie pozyskać takie dofinansowanie, jeżeli będzie taka możliwość</em> – deklarował Mariusz Zaborowski.\n\nJak na sprawę zapatrują się mieszkańcy gminy? Nie kryją rozczarowania, ale zapewniają, że do burmistrza pretensji nie mają.\n\n- <em>Szkoda, że się nie udało, ale nic nie straciliśmy. Natomiast podniesiono naszą świadomość, jak można oszczędzić środowisko. Obiecano również, że będziemy mogli skorzystać z podobnej możliwości za kilka lat </em>– mówili mieszkańcy gminy Ślesin.\n\nŹródło: Monika Marciniak - LM.pl\n\n&nbsp;\n\n__________\n\n&nbsp;\n\n<strong><img class="alignleft size-medium wp-image-522" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="300" height="78" />Wiele godzin przygotowań i setki stron dokumentacji, a wszystko to zostało zepsute. Chodzi o budowę ogniw fotowoltaicznych w ponad 350 gospodarstwach na terenie gminy Ślesin. Dlaczego tak się stało? Wniosku o dofinansowanie na czas nie złożyła firma Nuvarro, która wygrała przetarg na to zadanie. W jej imieniu miał to zrobić podwykonawca.</strong>\n– Ja dzisiaj nie mam nic na wytłumaczenie – tłumaczył prezes Nuvarro Dariusz Kałużny w hali widowiskowo-sportowej w Ślesinie. W spotkaniu wzięło udział wielu mieszkańców, którzy nie kryli rozgoryczenia, że to zadanie nie zostanie zrealizowane.\n\n– Nie mam dobrej informacji – powiedział Mariusz Zaborowski, burmistrz Ślesina. Wniosek o dofinansowanie nie został złożony, a miało to nastąpić do 31 sierpnia do godziny 15.30.\n\nZa przygotowanie studium wykonalności oraz złożenie wniosku dla gminy Ślesin odpowiadała firma Nuvarro, która miała dwóch podwykonawców.\n\n– Nie ma żadnej winy po stronie moich pracowników – powiedział burmistrz Ślesina. Dodając, że wręcz przeciwnie, wykonali oni kawał dobrej roboty, za którą należy im się nagroda, bo robili to poza godzinami pracy. Przygotowali umowy. A tych było naprawdę sporo. Inwestycja obejmowała ponad 350 prywatnych gospodarstw, gdzie miały pojawić się ogniska fotowoltaiczne wytwarzające energię o łącznej mocy 2 megawatów.\n\nMieszkańcy wpłacili po niecałe 300 złotych na wykonanie dokumentacji technicznej. Jak zapowiedział burmistrz, pieniądze będą im zwrócone. Umowa z firmą Nuvarro została zerwana. Musi ona też zapłacić gminie karę w wysokości 28 tysięcy złotych, ma również zobowiązania wobec firmy, która robiła dokumentację. Tutaj mowa jest o dziesiątkach tysięcy złotych. Co prezes Nuvarro powiedział dzisiaj mieszkańcom?\n– Wszelkie konsekwencje biorę na siebie. Jest mi przykro, bo taka sytuacja zdarzyła mi się pierwszy raz. Z programami unijnymi mam do czynienia od 2003 roku, także mógłbym powiedzieć, że to pech – powiedział Dariusz Kałużny. – Ja dzisiaj nie mam nic na wytłumaczenie, bo go nie ma na sytuację, w której wniosek nie zostaje złożony o godzinie 15.30.\n\nJako zadośćuczynienie wszyscy uczestnicy otrzymali za darmo projekty techniczne.\n– Każdemu mogą posłużyć do tego, żeby w przyszłości tę instalację fotowoltaiczną założyć czy też skorzystać z jakiegoś innego źródła – powiedział Dariusz Kałużny.\n\nCzy gdyby ten wniosek, został w porę złożony, miał szansę otrzymać dofinansowanie i być zrealizowany? Pojawiło się podczas spotkania stwierdzenie, że możliwości pozyskania środków były niezbyt duże. Mimo to niesmak pozostanie, że wniosek nie został złożony na czas.\n\n&nbsp;\n\nŹródło: Przegląd Koniński', 'Nie udało się pozyskać funduszy. Mieszkańcy zawiedzeni', '', 'trash', 'open', 'open', '', 'nie-udalo-sie-pozyskac-funduszy-mieszkancy-zawiedzeni__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=775', 0, 'post', '', 0),
 (780, 1, '2017-09-16 10:18:17', '2017-09-16 08:18:17', '[caption id="" align="alignleft" width="208"]<a href="http://www.caoh.cz/img/blog/img13908358635200.jpg"><img class="" src="http://www.caoh.cz/img/blog/img13908358635200.jpg" width="208" height="131" /></a> umig.slesin.pl[/caption]\n\n<strong>W ramach zbiórki odpadów wielkogabarytowych za miesiąc zbierane będą: stoły, szafy, krzesła, sofy, dywany, wózki dziecięce, materace, pierzyny, rowery, zabawki dużych rozmiarów, telewizory, monitory, pralki, radia, drukarki, odkurzacze, lodówki i inne urządzenia elektryczne i elektroniczne (sprzęt RTV i AGD powinien być kompletny). </strong> <a href="http://umig.slesin.pl/userfiles/files/wywoz2017.pdf">Pobierz harmonogram.</a>\n<!--more-->\n\nOdpady należy wystawić bezpośrednio przed swoje posesje tak, aby nie utrudniały ruchu pojazdów i pieszych, najpóźniej do godziny 7.00 w dniu zbiórki.', 'Wywóz odpadów wielkogabarytowych i sprzętu elektrycznego', '', 'trash', 'open', 'open', '', 'wywoz-odpadow-wielkogabarytowych-i-sprzetu-elektrycznego__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=780', 0, 'post', '', 0),
 (784, 1, '2017-09-16 10:21:04', '2017-09-16 08:21:04', '[caption id="" align="alignleft" width="298"]<a href="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/21728367_1295485087246215_8586672356510958578_n.jpg?oh=40cf4c48d3e4313f61efb85b8a1e8dac&amp;oe=5A56D9F4"><img class="" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/21728367_1295485087246215_8586672356510958578_n.jpg?oh=40cf4c48d3e4313f61efb85b8a1e8dac&amp;oe=5A56D9F4" width="298" height="421" /></a> facebook.com/gminaslesin/[/caption]\n\nZapraszamy 18 września 2017 w godzinach od 14:00 - 20:00.\nBilety do nabycia na miejscu.', 'Kino 7D zagości na rynku w Ślesinie', '', 'trash', 'open', 'open', '', 'kino-7d-zagosci-na-rynku-w-slesinie__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=784', 0, 'post', '', 0),
 (788, 1, '2017-09-19 12:01:07', '2017-09-19 10:01:07', '<strong><img class="alignleft size-medium" src="https://s-pt.ppstatic.pl/g/logo_naglowek/gloswielkopolski.svg?14633760" width="185" height="51" />Zapraszamy do głosowania w konkursie MISTRZOWIE AGRO w kategoriach: rolnik roku, gospodyni roku, gospodarstwo agroturystyczne roku, KGW roku. Głosowanie potrwa do dnia 6 października 2017 r. do godz. 21:59:59.</strong>\n\nWśród kandydatów na rolnika roku 2017 kandyduje Michał Śliwiński, Kijowiec, a na najsypatyczniejszą gospodynię Wielkopolski - Magdalena Śliwinska, Kijowiec oraz Wanda Waleriańczyk, Piotrkowice.\n\nWięcej szczegółów <a href="http://www.gloswielkopolski.pl/nasze-akcje/mistrzowie-agro/a/mistrzowie-agro-powiat-koninski-aktualne-wyniki,12482475/">tutaj</a>', 'Mistrzowie AGRO', '', 'trash', 'open', 'open', '', 'mistrzowie-agro__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=788', 0, 'post', '', 0),
 (790, 1, '2017-09-19 12:03:53', '2017-09-19 10:03:53', '[caption id="" align="alignleft" width="272"]<a href="http://www.slesin.naszabiblioteka.com/news/przedpoudnie-z-sherlockiem-holmesem"><img class="" src="http://www.slesin.naszabiblioteka.com/img/upload/images/WP_20170912_11_35_32_Pro.jpg" width="272" height="153" /></a> slesin.naszabiblioteka.com[/caption]\n\n<strong>W ramach biblioterapii w Środowiskowym Domu Samopomocy pracownicy Biblioteki Publicznej Miasta i Gminy Ślesin zostali zaproszeni do udziału w zajęciach. Zostałyśmy przyjęte w niezwykle ciepły sposób za co serdecznie dziękujemy.</strong>\n\n<!--more-->\n\nWraz z podopiecznymi przy słodkim poczęstunku przeczytaliśmy fragmenty książki sir Artura Conana Doyl’a pt. : „Pies Baskervill’ów” oraz wysłuchaliśmy przejmujących wierszy autorstwa jednej z obecnych pań.\n\nPod koniec spotkania zostałyśmy oprowadzone po budynku oraz miałyśmy przyjemność podziwiać efekty pracy artystycznej osób uczęszczających na zajęcia. Następne wspólne czytanie za miesiąc. Do zobaczenia\n\nŹródło: Bilbioteka Publiczna w Ślesinie\n\nZobacz też zdjęcia z akcji Narodowego Czytania "Wesela" - <a href="http://www.slesin.naszabiblioteka.com/news/narodowe-czytanie-wesele">tutaj</a>', 'Przedpołudnie z Sherlockiem Holmesem', '', 'trash', 'open', 'open', '', 'przedpoludnie-z-sherlockiem-holmesem__trashed', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 0, 'http://gminaslesin.futurehost.pl/?p=790', 0, 'post', '', 0),
 (792, 1, '2017-09-19 12:09:27', '2017-09-19 10:09:27', '[caption id="" align="alignleft" width="242"]<a href="https://www.facebook.com/lksslesin/photos/a.131120317484474.1073741829.123946521535187/152039688725870/?type=3&amp;theater"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/l/t1.0-9/21743113_152039688725870_3513430359830549860_n.jpg?oh=076133752f833511cdc2c84a26ba98f7&amp;oe=5A4AD78C" width="242" height="203" /></a> facebook.com/lksslesin/[/caption]\n\n<strong>Wielki klasyk naszego regionu czeka na kibiców piłkarskiego klubu LKS Ślesin w środowe popołudnie. W ramach trzeciej rundy Pucharu Polski na szczeblu OZPN Konin ekipa Skicioków podejmować będzie Górnik Konin.</strong>\n\n<!--more-->\n\nZdecydowany faworyt tego meczu, a więc trzecioligowy Górnik będzie chciał zdominować to spotkanie i szybko awansować do kolejnej rundy.\n\nMy ze swojej strony liczymy na solidny mecz, walkę na każdym centymetrze boiska i sprawienie niespodzianki jaką byłoby wyeliminowanie przeciwnika.\n\nZapraszamy wszystkich chcących wesprzeć nasz zespół w środę o godzinie 17:00.', 'Mecz z Górnikiem Konin', '', 'trash', 'open', 'open', '', 'mecz-z-gornikiem-konin__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=792', 0, 'post', '', 0),
 (795, 1, '2017-09-19 21:05:24', '2017-09-19 19:05:24', '[caption id="" align="alignleft" width="220"]<a href="https://www.lm.pl/aktualnosci/informacja/111445/narazil_pasazerow_sternik_katamaranu_byl_po_spozyciu_alkoholu"><img class="" src="https://m.lm.pl/media/foto/293543_6666_350.jpg" width="220" height="165" /></a> OSP Licheń Stary[/caption]\n\n<strong>Pół promila alkoholu w wydychanym powietrzu miał sternik katamaranu, który przechylił się na jeziorze Licheńskim.</strong>\n\n<!--more-->\n\n<img class="size-full wp-image-503 alignright" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/240915_logo_standard.png" alt="" width="175" height="70" />Do niebezpiecznej sytuacji doszło przedwczoraj w Licheniu. Katamaranem na jezioro wypłynęła grupa ponad 20 osób. Nagle jednostka się przechyliła, a pasażerowie mieli wpaść do wody. Kiedy na miejscu pojawili się wezwani z Konina strażacy, wszyscy uczestnicy pechowej wycieczki byli już w hotelu. Na szczęście nikomu nic się nie stało, ale jak informuje Zbigniew Janusz z konińskiej policji, 48-letni sternik katamaranu był po spożyciu alkoholu. Miał blisko pół promila alkoholu w wydychanym powietrzu. Dodatkowo nie miał uprawnień do sterowania tego typu łodzią.\n\nMężczyźnie za narażenie na bezpośrednie niebezpieczeństwo utraty życia lub ciężkiego uszczerbku na zdrowiu grozi nawet do 3 lat więzienia.\n\n&nbsp;', 'Sternik katamaranu był po spożyciu alkoholu', '', 'trash', 'open', 'open', '', 'sternik-katamaranu-byl-po-spozyciu-alkoholu__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=795', 0, 'post', '', 0),
 (800, 1, '2017-09-20 23:37:48', '2017-09-20 21:37:48', '[caption id="" align="alignleft" width="335"]<a href="http://umig.slesin.pl/userfiles/images/pamietaj.png"><img class="" src="http://umig.slesin.pl/userfiles/images/pamietaj.png" width="335" height="235" /></a> http://umig.slesin.pl[/caption]\n\n<strong>Zbliża się jesień i zima, a to oznacza, że trzeba będzie zacząć ogrzewać mieszkania. Przed rozpoczęciem sezonu grzewczego należy starannie zadbać o właściwy stan przewodów kominowych i urządzeń grzewczych.</strong>\n\n<!--more-->\nPrezes Krajowej Izby Kominiarzy wydał komunikat do właścicieli i zarządców budynków w związku z rozpoczęciem sezonu ogrzewczego.\n\n<a title="https://izbakominiarzy.pl/wp-content/uploads/2016/06/Komunikat-Prezesa-Krajowej-Izby-Kominiarzy-2017.pdf" href="https://izbakominiarzy.pl/wp-content/uploads/2016/06/Komunikat-Prezesa-Krajowej-Izby-Kominiarzy-2017.pdf" target="_blank" rel="noopener">https://izbakominiarzy.pl/wp-content/uploads/2016/06/Komunikat-Prezesa-Krajowej-Izby-Kominiarzy-2017.pdf</a>', 'Zadbaj o bezpieczeństwo', '', 'trash', 'open', 'open', '', 'zadbaj-o-bezpieczenstwo__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=800', 0, 'post', '', 0),
 (802, 1, '2017-09-20 23:47:48', '2017-09-20 21:47:48', '[caption id="" align="alignleft" width="338"]<a href="http://www.przegladkoninski.pl/PL-H5/3/4796/rajd-rowerowy-wokol-jeziora-slesinskiego-uczestnikow-nie-zniechecila-pogoda.html"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StLS04OTI0NjQtRFNDMDM1NzYuSlBH.jpg" width="338" height="190" /></a> przegladkoninski.pl[/caption]\n\n<strong>Na pewno pogoda nie nastrajała w minioną sobotę do eskapad jednośladami. Nie odstraszyło to jednak uczestników szóstego Raju Rowerowego wokół jeziora Ślesińskiego. Wśród nich pojawił się Tomasz Nowak, poseł PO, który to wydarzenie objął swoim patronatem. <a href="http://www.przegladkoninski.pl/PL-H5/3/4796/rajd-rowerowy-wokol-jeziora-slesinskiego-uczestnikow-nie-zniechecila-pogoda.html">Zdjęcia.</a></strong>\n\n<!--more-->\n\n– Jak jechałem z Konina to cały czas tylko lało i lało. Dzisiaj rano usuwałem jeszcze w swoim ogrodzie skutki nawałnicy. Mam nadzieję, że teraz żadna nawałnica nas nie spotka, tylko dobry humor – powiedział poseł Nowak tuż przed startem.\n\n<img class="size-medium wp-image-522 alignright" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="300" height="78" />Rajd wyruszył z Przystani Wodnej w Ślesinie. W tym roku uczestników było mniej niż w poprzednich latach. Wcześniej w imprezie uczestniczyło nawet około 100 osób. Jak mówił organizator, czyli Marek Ejma, ślesiński radny, na pewno ważna jest pogoda. Poprzednie edycje odbywały się w wakacje.\n\nTrasa rajdu to około 15 kilometrów.\n– Jedziemy wokół jeziora. Chodzi o to, żeby integrować społeczność i promować zdrowy tryb życia. Chcemy też pokazać wszystkim fajne miejsca, plaże – mówi Marek Ejma.\n\nNa finał zaplanowano ognisko i wspólne pieczenie kiełbasek.\n\nTekst: Marcin Szafrański', 'Rajd rowerowy wokół jeziora Ślesińskiego', '', 'trash', 'open', 'open', '', 'rajd-rowerowy-wokol-jeziora-slesinskiego__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=802', 0, 'post', '', 0),
 (808, 1, '2017-09-22 15:25:33', '2017-09-22 13:25:33', '[caption id="" align="alignleft" width="277"]<img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/21762165_152823625314143_1559795001543357810_n.jpg?oh=90ed3bd3ca1657648a4cde6c79fae65b&amp;oe=5A4F6464" width="277" height="156" /> facebook.com/lksslesin/[/caption]\n\n<strong>Już w najbliższą sobotę rozegrana zostanie 5 kolejka A-klasy. Tym razem LKS Ślesin czeka wyjazd do Kramska i mecz z tamtejszą Wartą.</strong>\nSpotkanie rozegrane będzie o godzinie 16:00. Wszystkich chcących wesprzeć nasz klub zapraszamy do wyjazdu i kibicowania.', 'LKS jedzie na mecz do Kramska', '', 'trash', 'open', 'open', '', 'lks-jedzie-na-mecz-do-kramska__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=808', 0, 'post', '', 0),
 (810, 1, '2017-09-22 15:26:18', '2017-09-22 13:26:18', '[caption id="" align="aligncenter" width="640"]<a href="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/21761801_153003178629521_6241682915575965195_n.jpg?oh=76b1c942cd6cd083c1ad66a491e6949a&amp;oe=5A5D9F4C"><img class="size-medium" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/21761801_153003178629521_6241682915575965195_n.jpg?oh=76b1c942cd6cd083c1ad66a491e6949a&amp;oe=5A5D9F4C" width="640" height="901" /></a> facebook.com/lksslesin/[/caption]', 'Nabór na treningi piłkarskie', '', 'trash', 'open', 'open', '', 'nabor-na-treningi-pilkarskie__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=810', 0, 'post', '', 0),
 (812, 1, '2017-09-22 15:29:32', '2017-09-22 13:29:32', '<strong> </strong>\n\n<img class="alignleft size-medium wp-image-555" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/IMG_1837-300x198.jpg" alt="" width="300" height="198" />\n\n<strong>Informuję, że w związku z toczącym się opracowaniem Programu Rewitalizacji dla Gminy Ślesin w dniu 26.09.2017 roku o godzinie 14:00 odbędą się konsultacje dot. w/w programu.</strong> Spotkanie odbędzie się na Sali konferencyjnej Urzędu Miasta i Gminy Ślesin.\n<div>Burmistrz Miasta i Gminy\n<em>Mariusz Zaborowski</em></div>\n<div></div>\n<div>Źródło: umig.slesin.pl</div>', 'Konsultacje dotyczące programu rewitalizacji gminy', '', 'trash', 'open', 'open', '', 'konsultacje-dotyczace-programu-rewitalizacji-gminy__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=812', 0, 'post', '', 0),
 (815, 1, '2017-09-27 07:01:27', '2017-09-27 05:01:27', '[caption id="" align="alignleft" width="294"]<a href="http://umig.slesin.pl/userfiles/images/moge-wiecej(2).jpg"><img class="" src="http://umig.slesin.pl/userfiles/images/moge-wiecej(2).jpg" width="294" height="416" /></a> http://umig.slesin.pl[/caption]\n\n<strong>Od września do listopada 2017 Fundacja na Rzecz Rozwoju Dzieci i Młodzieży w Koninie wraz z partnerami: Powiatowym Centrum Pomocy Rodzinie w Koninie, Gminnym Ośrodkiem Pomocy Społecznej w Lądku oraz Gminami: Sompolno, Stare Miasto i Ślesin realizuje projekt „Mogę więcej!” – edycja V skierowany do osób z niepełnosprawnością z powiatów:  konińskiego, kolskiego, tureckiego i słupeckiego oraz miasta Konina.</strong>\n\n<!--more-->\n\nW jego ramach projektu odbywać się będą różne formy rehabilitacji:\n·         alternatywne metody komunikowania się\n·         terapia logopedyczna\n·         fizjoterapia,\n·         terapia taktylna\n·         integracja sensoryczna\n·         hipoterapia\n·         terapia pedagogiczna\n·         terapia psychologiczna\n·         koncerty relaksacyjne\n·         „spotkanie z alpakami”\n\nProjekt współfinansowany jest ze środków PFRON będących w dyspozycji Samorządu Województwa Wielkopolskiego', 'Mogę więcej!', '', 'trash', 'open', 'open', '', 'moge-wiecej__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=815', 0, 'post', '', 0),
 (817, 1, '2017-09-27 07:03:14', '2017-09-27 05:03:14', '<p style="text-align: center;"><strong><img class="alignleft wp-image-555" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/IMG_1837-300x198.jpg" alt="" width="300" height="198" />OBWIESZCZENIE </strong><strong>BURMISTRZA  MIASTA I GMINY ŚLESIN\n</strong><strong>Z  26 WRZEŚNIA  2017 ROKU</strong></p>\n<strong>Informuję, że <u>  29 września  (piątek) 2017  roku  o godz. 10.00  w  sali posiedzeń Urzędu Miasta i Gminy  w Ślesinie odbędzie  się  XXXIII  sesja Rady Miejskiej Gminy Ślesin</u>.</strong>\n\n<!--more-->\n\n&nbsp;\n<div>Burmistrz Miasta i Gminy\n/-/ <em>Mariusz Zaborowski  </em></div>\nNa podstawie art. 20 ust. 1 ustawy z dnia 08 marca 1990 roku o samorządzie gminnym /Dz. U. z 2016 r., poz.446 ze zm./  z w o ł u j ę  <strong><u>XXXIII sesję Rady Miejskiej Gminy Ślesin  na </u></strong> <strong><u>29 wrzesień ( piątek  )  2017 roku na godz. 10.00 w  sali posiedzeń Urzędu Miasta i Gminy w Ślesinie</u></strong>  z następującym porządkiem obrad:\n<ol>\n 	<li>Otwarcie sesji i stwierdzenie quorum.</li>\n 	<li>Przyjęcie  porządku obrad.</li>\n 	<li>Przyjęcie protokołu z XXXII sesji Rady Miejskiej Gminy Ślesin.</li>\n 	<li>Interpelacje i zapytania radnych .</li>\n 	<li>Podjęcie uchwał w sprawach:</li>\n</ol>\n1)      zmian budżetu,\n2)      o zmianie uchwały w sprawie uchwalenia Wieloletniej Prognozy Finansowej Miasta i Gminy Ślesin na lata 2017 – 2036,\n3)      wyrażenia zgody na nieodpłatne nabycie nieruchomości położonej w obrębie Żółwieniec,\n4)      wyrażenia zgody na nieodpłatne nabycie nieruchomości położonej w obrębie Różopole,\n5)      ustanowienia służebności przesyłu na nieruchomości położonej w Ślesinie.\n<ol>\n 	<li value="6">Wolne wnioski.</li>\n 	<li>Zakończenie obrad.</li>\n</ol>\n&nbsp;\n<div>Przewodniczący Rady\n/-/ Stanisław Chrzanowski</div>', 'XXXIII  sesja Rady Miejskiej Gminy Ślesin', '', 'trash', 'open', 'open', '', 'xxxiii-sesja-rady-miejskiej-gminy-slesin__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=817', 0, 'post', '', 0),
 (821, 1, '2017-09-27 07:46:43', '2017-09-27 05:46:43', '<div class="text_full" align="justify">\n\n[caption id="" align="alignleft" width="325"]<a href="http://www.przegladkoninski.pl/data/catalogue/StLS05MzE4OS0zMTgtMTg2MzI0LmpwZw==.jpg"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StLS05MzE4OS0zMTgtMTg2MzI0LmpwZw==.jpg" width="325" height="217" /></a> przegladkoninski.pl[/caption]\n\n<strong>35-letni mieszkaniec powiatu konińskiego, kierujący volkswagenem vento, nie zatrzymał się do policyjnej kontroli i podjął próbę ucieczki. Jak się okazało – miał do tego powody. Był kompletnie pijany. W wydychanym powietrzu miał aż 2,5 promila alkoholu.</strong>\n\n<!--more-->\n\n<img class="size-medium wp-image-522 alignright" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="300" height="78" />W niedzielę, po godzinie 15.00, funkcjonariusze z Komisariatu Policji w Ślesinie zauważyli volkswagena vento, którego kierujący wydał się funkcjonariuszom „podejrzany”. Postanowili go zatrzymać.\n\n– Kierowca nie zwracał uwagi na wydawane znaki i sygnały świetlne oraz dźwiękowe – informuje Zbigniew Janusz, rzecznik prasowy Komendy Miejskiej Policji w Koninie. – Dodatkowo utrudniał zatrzymanie zajeżdżając drogę policyjnemu radiowozowi. Kierujący uciekał tak przez Galiszewo, Łuszczewo, Mielnicę i Goplanę. Został zatrzymany, kiedy wjechał na teren własnej posesji.\n\nUciekinierem okazał się 35-mężczyzna, który w wydmuchiwanym powietrzu miał ponad 2,5 promila alkoholu. Policjanci zatrzymali mężczyźnie prawo jazdy i osadzili w policyjnym areszcie.\n\n– Jeszcze dzisiaj usłyszy zarzuty z art. 178a kk oraz 178 bkk, czyli za jazdę pod wpływem alkoholu ora za niezatrzymanie się do kontroli drogowej na żądanie funkcjonariuszy policji – dodaje rzecznik. – Za swoją brawurową jazdę odpowie przed sądem.\n\n</div>\n&nbsp;\n<div class="clearfix"></div>\n<div class="clearfix"></div>', 'Pijany kierowca uciekał policji', '', 'trash', 'open', 'open', '', 'pijany-kierowca-uciekal-policji__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=821', 0, 'post', '', 0),
 (823, 1, '2017-09-29 01:01:41', '2017-09-28 23:01:41', '[caption id="" align="aligncenter" width="2458"]<a href="http://www.mgok.slesin.pl/asp/pliki/pliki_robocze/spektakl-_lichen.jpg"><img class="size-medium" src="http://www.mgok.slesin.pl/asp/pliki/pliki_robocze/spektakl-_lichen.jpg" width="2458" height="3492" /></a> mgok.slesin.pl[/caption]', 'Spektakl o Objawieniach Licheńskich i Historii Lichenia', '', 'trash', 'open', 'open', '', 'spektakl-o-objawieniach-lichenskich-i-historii-lichenia__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=823', 0, 'post', '', 0),
 (825, 1, '2017-09-29 01:04:03', '2017-09-28 23:04:03', '[caption id="" align="aligncenter" width="668"]<a href="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/22008001_1751796118455815_3937849308996864705_n.jpg?oh=9adb00dc93a6c64bcecfa5ee9dc03a00&amp;oe=5A41F9DE"><img class="size-medium" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/22008001_1751796118455815_3937849308996864705_n.jpg?oh=9adb00dc93a6c64bcecfa5ee9dc03a00&amp;oe=5A41F9DE" width="668" height="960" /></a> facebook.com/mgokslesin/[/caption]', 'Nakręcona gmina', '', 'trash', 'open', 'open', '', 'nakrecona-gmina__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=825', 0, 'post', '', 0),
 (827, 1, '2017-09-29 13:22:36', '2017-09-29 11:22:36', '[caption id="" align="alignleft" width="324"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1751993745102719/1751993165102777/?type=3&amp;theater"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t31.0-0/q81/p180x540/22136882_1751993165102777_8080209208265274684_o.jpg?oh=0f193ba2e9eb6ebab346ce67b5ff203b&amp;oe=5A823234" width="324" height="243" /></a> facebook.com/mgokslesin/[/caption]\n\n<strong>W dniach 22-24 września 2017, dwójka naszych najmłodszych szachistów Ada Chojnacka i Tymoteusz Łachacz po raz pierwszy próbowali swoich sił na Międzywojewódzkich Mistrzostwach Młodzików, które odbywały się w tym roku w Łazach.</strong>\n\nMistrzostwa rozgrywane zostały na dystansie siedmiu rund, tempem 30 minut dla zawodnika plus 30 sekund za wykonany ruch. Oboje nasi reprezentanci uzyskali wynik 3 punkty z siedmiu rund, co dało im miejsca w środku tabeli. W klasyfikacji końcowej Ada Chojnacka zajęła 14 miejsce wśród dziewczynek, a Tymoteusz Łachacz zajął 23 miejsce wśród chłopców.', 'Debiut najmłodszych szachistów na mistrzostwach międzywojewódzkich', '', 'trash', 'open', 'open', '', 'debiut-najmlodszych-szachistow-na-mistrzostwach-miedzywojewodzkich__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=827', 0, 'post', '', 0),
 (830, 1, '2017-09-30 11:35:33', '2017-09-30 09:35:33', '[caption id="" align="alignleft" width="261"]<a href="https://www.facebook.com/lksslesin/photos/a.131120317484474.1073741829.123946521535187/154486135147892/?type=3&amp;theater"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/22050006_154486135147892_5640058828229256407_n.jpg?oh=e9d2fa6273d1d1d09d82c5cf7f780428&amp;oe=5A39D13B" width="261" height="147" /></a> facebook.com/lksslesin/[/caption]\n\n<strong>Już w najbliższą sobotę o godzinie 16. odbędzie się 6 kolejka A-klasy 2 grupy w której LKS podejmować będzie Viktorię ll Wrześnie.</strong>\n\nKibice i wszyscy zainteresowani drużyną Skicioków liczą na ciekawe i pełne zaangażowania spotkanie w wykonaniu naszej drużyny. Mamy nadzieję pozostania na zwycięskim torze, zdobycia kompletu punktów i walki o czołówkę ligowej tabeli.\n\nZapraszamy wszystkich na stadion w Ślesinie i zachęcamy do kibicowania', 'Dziś mecz z Wrześnią', '', 'trash', 'open', 'open', '', 'dzis-mecz-z-wrzesnia__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=830', 0, 'post', '', 0),
 (832, 1, '2017-09-30 11:39:31', '2017-09-30 09:39:31', '[caption id="" align="aligncenter" width="2472"]<a href="http://www.mgok.slesin.pl/asp/pliki/pliki_robocze/pyrczok_2017__1_.jpg"><img class="size-medium" src="http://www.mgok.slesin.pl/asp/pliki/pliki_robocze/pyrczok_2017__1_.jpg" width="2472" height="3392" /></a> facebook.com/gminaslesin/[/caption]', 'XV Święto Pyrczoka', '', 'trash', 'open', 'open', '', 'xv-swieto-pyrczoka__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=832', 0, 'post', '', 0),
 (834, 1, '2017-09-30 21:20:37', '2017-09-30 19:20:37', '[caption id="" align="alignleft" width="294"]<a href="https://www.facebook.com/lksslesin/photos/a.131120317484474.1073741829.123946521535187/155306635065842/?type=3&amp;theater"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t31.0-0/q91/p403x403/22051291_155306635065842_3524450602761349813_o.jpg?oh=502fbb9a997f56bac55031ce3f4cb4c2&amp;oe=5A4686AE" width="294" height="165" /></a> facebook.com/lksslesin/[/caption]\n\n<strong>Wciąż niepokonana jest seniorska ekipa LKS-u Ślesin.  Tym razem na własnym boisku nie pozostawili cienia wątpliwości kto jest lepszą drużyną pewnie pokonując Wiktorię ll Września 3:0.</strong>\n\n<!--more-->\n\nGole zdobywali:\nMarcin Marciszak\nRafał Czapski<span class="text_exposed_show">\nKamil Sobota</span>\n<div class="text_exposed_show">\n\nCieszy także fakt zachowania czystego konta, ale przede wszystkim dominacji przez całe spotkanie. Liczymy na więcej !\n\n</div>', 'LKS Ślesin wciąż niepokonany', '', 'trash', 'open', 'open', '', 'lks-slesin-wciaz-niepokonany__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=834', 0, 'post', '', 0),
 (837, 1, '2017-10-03 10:09:15', '2017-10-03 08:09:15', '[caption id="" align="alignleft" width="155"]<img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/984020_1366146003447326_7529024879014245934_n.png?oh=1ca89f0ff19d38b9bc6f8ea26dfe19da&amp;oe=5A4DD170" width="155" height="155" /> facebook.com/kalejdoskopwielkopolski/[/caption]\n\n<strong>W Ślesinie na tamtejszym rynku po raz czwarty odbył się Jarmark Ochweśnicki. Na straganach pojawiły się lokalne przysmaki, wyroby rękodzieła, oraz sztuka ludowa. Zebranym czas umilały lokalne zespoły muzyczne.</strong>\n\n<!--more-->\n\n[embed]https://www.facebook.com/kalejdoskopwielkopolski/videos/1537337989661459/?hc_ref=ARTO4jiYqqOTv6x6aUImXJl_LEgcCbb4heO2T825YZPZhfqT2VvKFQFoRvTg-MyUgMc&fref=nf[/embed]\n\nZródło: Kalejdoskop Wielkopolski', 'Relacja z Jarmarku Ochweśnickiego', '', 'trash', 'open', 'open', '', 'relacja-z-jarmarku-ochwesnickiego__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=837', 0, 'post', '', 0),
 (841, 1, '2017-10-03 12:09:27', '2017-10-03 10:09:27', '[caption id="" align="alignleft" width="257"]<a href="http://gloskoninski.pl/pechowy-poczatek-tygodnia-dwa-wypadki-w-poniedzialkowy-poranek/"><img class="" src="http://gloskoninski.pl/wp-content/uploads/2017/10/Pechowy-pocz%C4%85tek-tygodnia.-Dwa-wypadki-w-poniedzia%C5%82kowy-poranek-1.jpg" width="257" height="171" /></a> http://gloskoninski.pl/[/caption]\n\n<strong>Do groźnego Wypadku doszło wczoraj rano w Szyszyńskich Holendrach, jedna osoba została ranna i trafiła do szpitala. Kilka godzin później w Mikorzynie doszło do kolejnego wypadku na skutek nieuwagi i wyprzedzania. Kolejna osoba ranna w szpitalu. <a href="http://gloskoninski.pl/pechowy-poczatek-tygodnia-dwa-wypadki-w-poniedzialkowy-poranek/">Zdjęcia.</a></strong>\n\n<!--more-->\n\nOkoło 6:40 rano w miejscowości  na drodze DK20 w kierunku na Bydgoszcz doszło do zderzenia dwóch pojazdów:ciężarówki i samochodu osobowego.\nKierujący Vw Golf 24 letni mężczyzna nieustąpił pierwszeństwa przejazdu na skrzyżowaniu i doprowadził do zderzenia z samochodem ciężarowym Volwo, którym kierował 39 letni mieszkaniec woj. opolskiego. Na skutek zderzenia pasażer Golfa doznał złamania nogi i trafił do szpitala. Obaj kierujący byli trzeźwi.\n24 letni kierowca VW Golfa ma zatrzymane prawo jazdy i odpowie za spowodowanie wypadku. Sprawą zajmą się dochodzeniowcy z Komisariatu Policji w Ślesinie.\n\n<img class="size-medium alignright" src="http://gloskoninski.pl/wp-content/uploads/2017/09/glos-koninski-logo-MEDIUM-1.bmp" width="193" height="87" />Niecałe 3 godziny później w Mikorzynie doszło do kolejnego wypadku, w którym udział wzięły Mercedes kierowany przez 29 letniego mieszkańca pow. konińskiego oraz Renault Master kierowany przez 28 letniego mieszkanca Kalisza.\nDo zdarzenia doszło na prostym odcinku drogi. Kierujący Renault Master nie ustąpił pierwsdzeństwa prawidłowo wyprzedzającemu jadącemu w tym samym kierunku kierowcy Mercedesa i uderzył go w bok co spowodowało zjazd na lewe pobocze i uderzenie Mercedesa w drzewo.\n\nKierujący Mercedesem na skutek zdarzenia doznał złamania nogi i trafił do szpitala, jego życiu nie zagraża niebezpieczeństwo. Kierujący byli trzeźwi.\nSprawą zajmą się dochodzeniwowcy ze Ślesina. W chwili obecnej trwają niezbędne ustalenia zmierzjące do ustalenia przebiegu całego zdarzenia i ustalenia wszsytkich faktów.', 'Dwa wypadki w poniedziałkowy poranek', '', 'trash', 'open', 'open', '', 'dwa-wypadki-w-poniedzialkowy-poranek__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=841', 0, 'post', '', 1),
 (846, 1, '2017-10-06 23:15:33', '2017-10-06 21:15:33', '[caption id="" align="alignleft" width="191"]<a href="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/22196074_156545428275296_674278597870968465_n.jpg?oh=717462dd7f2615147355a7a9eb437c71&amp;oe=5A8721A3"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/22196074_156545428275296_674278597870968465_n.jpg?oh=717462dd7f2615147355a7a9eb437c71&amp;oe=5A8721A3" width="191" height="340" /></a> facebook.com/lksslesin/[/caption]\n\n<strong>Wielkimi krokami zbliża się 8. kolejka ligowa seniorskiej grupy LKS-u Ślesin. </strong>\nTym razem podopieczni Macieja Bieniaszczyka podejmować będą na wyjeżdzie zespół ZKS<span class="text_exposed_show"> Zagórów.\nSpotkanie rozegrane będzie w niedziele o godzinie 15 . Przedłużenie zwycięskiej passy to Nasz jedyny cel po tym meczu.\nSerdecznie zapraszamy wszystkich kibiców do wsparcia!</span>', 'LKS zagra w VIII rundzie z ZKS Zagórów', '', 'trash', 'open', 'open', '', 'lks-zagra-w-viii-rundzie-z-zks-zagorow__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=846', 0, 'post', '', 0),
 (847, 1, '2017-10-06 23:12:42', '2017-10-06 21:12:42', '[caption id="" align="alignleft" width="314"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1754381354863958/1754380108197416/?type=3&amp;theater"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/22281797_1754380108197416_6121342935828417465_n.jpg?oh=8f9fa56838e78265b6da730fdf5989a2&amp;oe=5A8817F4" width="314" height="236" /></a> facebook.com/mgokslesin[/caption]\n\n<strong>4 października w Miejsko-Gminnym Ośrodku Kultury w Ślesinie odbyły się Drużynowe Mistrzostwa Szkół Gminy Ślesin w Szachy. W turnieju uczestniczyło 7 drużyn ze Szkół Podstawowych Gminy Ślesin. Turniej rozegrany został systemem kołowym na dystansie 7 rund tempem 10 minut na zawodnika. Na zakończenie turnieju najlepsze drużyny otrzymały puchary i dyplomy.</strong>\n\n<!--more-->\n\nWyniki końcowe:<span class="text_exposed_show">\n1 miejsce drużyna SP Ślesin I w składzie:\nMichał Pawlak, Kacper Szaszkowski, Aleksandra Zawieruszyńska, Julia Kowalska</span>\n<div class="text_exposed_show">\n\n2 miejsce drużyna SP Szyszyńskie Holendry I w składzie:\nAdam Głąbiak, Inga Turowska, Daniel Lisowski, Paulina Andrzejewska\n\n3 miejsce drużyna SP Ślesin II w składzie:\nAleksandra Nussynblat, Damian Kołodziejczak, Kinga Stelmachowicz, Ada Chojnacka\n\nKolejne miejsce to:\nSP Ostrowąż\nSP Ślesin III\nSP Szyszyńskie Holendry II\nSP Szyszyńskie Holendry III\n\n</div>', 'Drużynowe Mistrzostwa Szkół Gminy Ślesin', '', 'trash', 'open', 'open', '', 'druzynowe-mistrzostwa-szkol-gminy-slesin__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=847', 0, 'post', '', 0),
 (852, 1, '2017-10-06 23:16:37', '2017-10-06 21:16:37', '[caption id="" align="aligncenter" width="676"]<img class="size-medium" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/22221509_1753766074925486_1096206706387321089_n.jpg?oh=ef94376700d91acb1110a0b39e10f4d2&amp;oe=5A80C4E2" width="676" height="960" /> facebook.com/mgokslesin/[/caption]', 'Spektakl o objawieniach licheńskich', '', 'trash', 'open', 'open', '', 'spektakl-o-objawieniach-lichenskich__trashed', '', '', '2017-10-06 23:16:37', '2017-10-06 21:16:37', '', 0, 'http://gminaslesin.futurehost.pl/?p=852', 0, 'post', '', 0),
 (854, 1, '2017-10-06 23:17:38', '2017-10-06 21:17:38', '[caption id="" align="aligncenter" width="698"]<img class="size-medium" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/22228634_1753765888258838_6798066895799644059_n.jpg?oh=63fdd24c6cde8829e5ea9932aa3f663b&amp;oe=5A77C0FC" width="698" height="960" /> facebook.com/mgokslesin/[/caption]', 'Wystawa prac artystów gminy Ślesin', '', 'trash', 'open', 'open', '', 'wystawa-prac-artystow-gminy-slesin__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=854', 0, 'post', '', 0),
 (856, 1, '2017-10-06 20:22:26', '2017-10-06 18:22:26', '<div><img class="alignleft size-medium" src="http://www.slesin.naszabiblioteka.com/img/upload/images/108083479d3fcc16eb5634291f3ffcb1.jpg" width="116" height="116" /><strong>Biblioteka Publiczna Miasta i Gminy Ślesin jest obecnie w trakcie realizacji Programu Biblio</strong>\n\n<strong>teki Narodowej „Zakup nowości wydawniczych do bibliotek”. Dofinansowanie w roku bieżącym wyniosło  11,182 zł. Czas realizacji programu obejmuje okres do końca listopada.</strong>\n\nZapraszamy wszystkich do Biblioteki oraz do zapoznania się z zakupionymi nowościami na naszej stronie internetowej.\n\n<em>"Zrealizowano ze środków finansowych Ministerstwa Kultury i Dziedzictwa Narodowego w  ramach Narodowego Programu Rozwoju Czytelnictwa".</em>\n\n</div>\n&nbsp;', 'Zakup nowości wydawniczych 2017', '', 'trash', 'open', 'open', '', 'zakup-nowosci-wydawniczych-2017__trashed', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 0, 'http://gminaslesin.futurehost.pl/?p=856', 0, 'post', '', 0),
 (858, 1, '2017-10-06 22:40:45', '2017-10-06 20:40:45', '[caption id="" align="alignleft" width="298"]<a href="https://www.lm.pl/aktualnosci/informacja/111743/dzien_kukurydzy_w_firmie_szmidt_dla_rolnikow_i_producentow"><img class="size-medium" src="https://m.lm.pl/media/foto/295936_2844_298.jpg" width="298" height="167" /></a> LM.pl[/caption]\n\n<strong>W gospodarstwie rolnym Jana Szmidta w Biskupiu, w gminie Ślesin, odbył się Dzień Kukurydzy.</strong>\n\n<!--more-->\n\n<img class="size-full wp-image-503 alignright" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/240915_logo_standard.png" alt="" width="175" height="70" />Firma Szmidt z Biskupia zajmuje się skupem zbóż oraz zaopatrywaniem rolników w niezbędne środki do produkcji rolnej. Współpracuje z okolicznymi gospodarstwami w regionie wschodniej Wielkopolski oraz południowej części Kujaw. Funkcjonuje nieprzerwanie od 1992 roku i cały czas się rozwija, dostosowując ofertę do zmiennych się potrzeb rynku.\n\nCo roku Firma Szmidt z Buskupia organizuje dzień kukurydzy. W tegorocznym uczestniczyło ponad 100 osób. Rolników i producentów nie wystraszył nawet deszcz. - <em>Celem takiego spotkania jest porównanie odmian, które sprzedajemy lub chcemy sprzedawać. Po to, by rolnicy uzyskiwali jak najwyższe plony</em> – poinformował Mariusz Kaliszewski, menadżer ds. skupu i kontraktacji zbóż w Firmie Szmidt.\n\nFirma Szmidt jest w posiadaniu suszarni do kukurydzy o przerobie ok. 400 do 500 ton na dobę. -<em>Obecnie trwa przebudowa suszarni więc jej wydajność wzrośnie do ok. 1000 ton na dobę, w sezonie do 100.000 ton – powiedział Mariusz Kaliszewski. - Tej kukurydzy nam potrzeba. Podczas dnia kukurydzy pokazujemy nowe, lepsze odmiany, nowe technologie, nowe maszyny po to, by rolnicy uzyskiwali lepsze plony. Uprawiali coraz więcej. A ponieważ najlepszymi ekspertami od uprawy kukurydzy są firmy produkujące nasiona, chemię, maszyny, więc zaprosiliśmy ekspertów z poszczególnych firm, aby jako specjaliści omówili odmiany, technologie ochrony roślin oraz sprzęt. Mamy dostawców kukurydzy w promieniu 100 km od Konina, a więc z kujawsko - pomorskiego, mazowieckiego, ale także spod Opola, rolnicy wożą nam kukurydzę.</em>\n\nBo, jak mówią organizatorzy, bezpośredni kontakt producentów środków do produkcji rolnej z rolnikami jest najlepszy. I o to chodzi podczas corocznego dnia kukurydzy.', 'Dzień kukurydzy w Firmie Szmidt', '', 'trash', 'open', 'open', '', 'dzien-kukurydzy-w-firmie-szmidt__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=858', 0, 'post', '', 0),
 (860, 1, '2017-10-12 19:24:10', '2017-10-12 17:24:10', '[caption id="" align="alignleft" width="335"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1756254308009996/1756250164677077/?type=3&amp;theater"><img class="" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/22366428_1756250164677077_7508906440037517416_n.jpg?oh=7ed0676703b7532f14a8075e94b49396&amp;oe=5A74D9B7" width="335" height="251" /></a> facebook.com/mgokslesin/[/caption]\n\n<strong>11 października 2017r. w Miejsko-Gminnym Ośrodku Kultury w Ślesinie odbyły się Drużynowe Mistrzostwa Powiatu Konińskiego w Szachach. W tym roku w związku z reformą oświaty Mistrzostwa rozegrane zostały w trzech grupach wiekowych: Powiatowe Igrzyska Dzieci była to grupa dzieci szkół podstawowych klas I-VI, Igrzyska Młodzieży Szkolnej Powiatu Konińskiego była to grupa młodzieży szkoły podstawowej klasy VII oraz II i III klasa</strong><span class="text_exposed_show"><strong>gimnazjum, ostatnia grupa to szkoły ponadgimnazjalne.</strong> </span>\n\n<!--more-->\n\n<span class="text_exposed_show">W Powiatowych Igrzyskach Dzieci grało 9 drużyn szkół podstawowych, w Igrzyska Młodzieży Szkolnej Powiatu Konińskiego grało 6 drużyn i 1 ponadgimnazjalna. Podzielone grupy grały systemem kołowym każdy z każdym, natomiast zawodnicy ze szkoły ponadgimnazjalnej nie mając w swojej grupie rywali zagrali w grupie Młodzieży Szkolnej. W mistrzostwach szkoły walczyły o miejsca pucharowe oraz co ważniejsze o awans do Mistrzostw Wojewódzkich, taki awans uzyskały dwie najlepsze drużyny w każdej grupie.</span>\n<div class="text_exposed_show">\n\nZ naszej gminy aż trzy drużyny uzyskały taki awans – drużyna z Zespołu Szkolno-Przedszkolnego w Ślesinie w składzie: Michał Pawlak, Kacper Szaszkowski, Damian Kołodziejczak, Kinga Stelmachowicz i Ada Chojnacka, drużyna ze Szkoły Podstawowej w Szyszyńskich Holendrach w składzie: Adam Głąbiak, Aleksandra Głąbiak, Alan Ciepliński, Denis Kostański i Paulina Andrzejewska oraz drużyna z Gimnazjum w Ślesinie w składzie: Bartosz Sajniak, Nikola Majdecka, Dominik Długołencki, Natalia Łapot, Julia Kowalska i Weronika Stolarska.\n\nWarto też nadmienić bardzo dobry występ drugiej drużyny ze Szkoły Podstawowej w Szyszyńskich Holendrach która, grając najmłodszym składem w swojej grupie wywalczyła trzecie miejsce.\n\nGratulujemy i życzymy udanego występu na Mistrzostwach Wojewódzkich.\n\nWyniki Powiatowe Igrzyska Dzieci:\n<a href="https://l.facebook.com/l.php?u=http%3A%2F%2Fwww.chessarbiter.com%2Fturnieje%2F2017%2Ftdr_6270%2Fresults.html%3Fl%3Dpl%26tb%3D202_&amp;h=ATOlFt68eTusQEw9xPmBtBjBd6EiKq6OfBuRxGJOo-sqU34VVJDtDOz8joFjtiGahYA8GqnUiwsgh1DfnW3FOf__51av_sJXymjr0sQgj59lGfuZ0l49V6nnDqH45iDTe4p5i0Tq-dQX2Rma0VHkQvG7TR1a8aOk3Xl_7vaVM53VrXclHycSprZAAcTkZO7qGpa_VjPXC75WHECwNawUVUtwzbinBp3huN7KshAHyM1gDD0U7fg9mdcu71i7x18ialTb6q4b9HGlElhTi09NPVkSpf_4Tvjn" target="_blank" rel="noopener" data-ft="{&quot;tn&quot;:&quot;-U&quot;}" data-lynx-mode="async">http://www.chessarbiter.com/turnie…/…/tdr_6270/results.html…</a>\nWyniki Igrzyska Młodzieży Szkolnej Powiatu Konińskiego:\n<a href="http://www.chessarbiter.com/turnieje/2017/tdr_6269/results.html?l=pl&amp;tb=202_" target="_blank" rel="noopener" data-ft="{&quot;tn&quot;:&quot;-U&quot;}" data-lynx-mode="async" data-lynx-uri="https://l.facebook.com/l.php?u=http%3A%2F%2Fwww.chessarbiter.com%2Fturnieje%2F2017%2Ftdr_6269%2Fresults.html%3Fl%3Dpl%26tb%3D202_&amp;h=ATMsg8rygtubjmfbdKmhAnek01ARL2dp3rdd-2Xtgh7WHYTm_ZNtYqwVXwtTvUI9Bu2glqL-tJ0yZ-Be0gNgGrdlyHJhHs9G1JWaOQ89L_XM6tr6Ehk0WqBiwPODF_rETE7qmXxF0K3I5bbZccqLfA0QfZv2hGPIFxENv2GJ9fNaLejT3ZhORSYuVUvN8uX5yC47uci84K_jb88S67uHt9LTNn--zCqoUTKzQ17R7CO62EfQuJ7YXZq4BdWXIogWiqnQHM_nIdXX3_uX-VgRVHCxfnVrNO92">http://www.chessarbiter.com/turnie…/…/tdr_6269/results.html…</a>\n\n</div>', 'Drużynowe Mistrzostwa Powiatu Konińskiego w Szachach', '', 'trash', 'open', 'open', '', 'druzynowe-mistrzostwa-powiatu-koninskiego-w-szachach__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=860', 0, 'post', '', 0),
 (862, 1, '2017-10-12 19:26:00', '2017-10-12 17:26:00', '[caption id="" align="aligncenter" width="960"]<a href="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/22228400_1754776968157730_8416040562577880439_n.jpg?oh=a8e930487e8c086593c640cd40a2961c&amp;oe=5A6F7764"><img class="size-medium" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/22228400_1754776968157730_8416040562577880439_n.jpg?oh=a8e930487e8c086593c640cd40a2961c&amp;oe=5A6F7764" width="960" height="666" /></a> facebook.com/mgokslesin/[/caption]', 'Aerobik', '', 'trash', 'open', 'open', '', 'aerobik__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=862', 0, 'post', '', 0),
 (864, 1, '2017-10-12 19:38:29', '2017-10-12 17:38:29', '[caption id="" align="alignleft" width="264"]<a href="http://www.przegladkoninski.pl/PL-H5/3/5114/prawie-20-malzenstw-z-medalami-od-prezydenta-polski-50-lat-wspolnego-zycia.html"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StLS03ODg4NTAtRFNDMDE4NTAuSlBH.jpg" width="264" height="176" /></a> przegladkoninski.pl[/caption]\n\n<strong>Prawie 20 par małżeńskich świętowało dzisiaj w gminie Ślesin 50 lat wspólnego życia. Zostali odznaczeni medalami od prezydenta RP, które wręczył jubilatom burmistrz Mariusz Zaborowski.</strong>\n\n<a href="http://www.przegladkoninski.pl/PL-H5/3/5114/prawie-20-malzenstw-z-medalami-od-prezydenta-polski-50-lat-wspolnego-zycia.html" target="_blank" rel="noopener">Zdjęcia i film.</a>\n\n<!--more-->\n\n<img class="size-medium wp-image-522 alignright" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="300" height="78" />Burmistrz wszystkim parom złożył życzenia. W swojej wypowiedzi nawiązał też do tego, że sam niedawno się ożenił.\n\n– Od trzech tygodni jestem w nowym związku. Uważam, że każdy chciałby mieć i tworzyć rodzinę, dlatego taką decyzję podjąłem – mówił burmistrz Zaborowski.\n\n– Te wspólne lata to symbol wierności i miłości rodzinnej, to dowód wzajemnego zaufania, zrozumienia i istoty związku małżeńskiego. To wzór i piękny przykład dla młodych pokoleń, które decydują się związać węzłem małżeńskim zakładając rodzinę – mówiła do jubilatów Katarzyna Fryza, kierownik Urzędu Stanu Cywilnego w Ślesinie.\n\nJubileusz 50 lat pożycia małżeńskiego świętowało dzisiaj 18 par. Otrzymały medale od prezydenta Polski oraz pamiątkę od gminy.\n\n– Życzę wielu wspaniałych i radosnych dni spędzonych razem – powiedział Mariusz Zaborowski.', 'Prawie 20 małżeństw z medalami od prezydenta Polski', '', 'trash', 'open', 'open', '', 'prawie-20-malzenstw-z-medalami-od-prezydenta-polski__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=864', 0, 'post', '', 0),
 (866, 1, '2017-10-13 17:16:35', '2017-10-13 15:16:35', '[caption id="" align="aligncenter" width="679"]<a href="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/22519235_1756877101281050_8006585183499415866_n.jpg?oh=dfabef765a8948c3800598b02a4500cd&amp;oe=5A7C72B2"><img class="size-medium" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/22519235_1756877101281050_8006585183499415866_n.jpg?oh=dfabef765a8948c3800598b02a4500cd&amp;oe=5A7C72B2" width="679" height="960" /></a> facebook.com/mgokslesin/[/caption]', 'Turniej Klasyfikacyjny', '', 'trash', 'open', 'open', '', 'turniej-klasyfikacyjny__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=866', 0, 'post', '', 0),
 (868, 1, '2017-10-13 17:27:08', '2017-10-13 15:27:08', '[caption id="" align="aligncenter" width="280"]<img class="size-medium" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/22448257_1317476308380426_7616266778838825447_n.jpg?oh=5ff86c59b6b9b253f706347523fc387c&amp;oe=5A780EE5" width="280" height="395" /> facebook.com/gminaslesin/[/caption]', 'Zlot miłośników aut z PRL-u', '', 'trash', 'open', 'open', '', 'zlot-milosnikow-aut-z-prl-u__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=868', 0, 'post', '', 0),
 (870, 1, '2017-10-13 19:53:57', '2017-10-13 17:53:57', '[caption id="" align="alignleft" width="272"]<img class="" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/22365320_158357844760721_8758123864129528586_n.jpg?oh=098dcd203d639db91ca3a166b4b7830e&amp;oe=5A82C674" width="272" height="174" /> facebook.com/lksslesin/[/caption]\n\n<strong>W weekend odbędzie się 8 kolejka ligowa i znowu wracamy na stadion przy ulicy Napoleona 1 w Ślesinie.</strong> Tym razem podopieczni trenera Macieja Bieniaszczyka podejmować będą ekipe GKS-u Rzgów.\n\nSkicioki niepokonane w lidze chcą szybko rozprawić się z przeciwnikiem i dopisać kolejne trzy punkty do ligowej tabeli. Wszystkich dopingujących zespół LKS-u zapraszamy w sobotę o godzinie 15.', 'LKS zagra ze Rzgowem', '', 'trash', 'open', 'open', '', 'lks-zagra-ze-rzgowem__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=870', 0, 'post', '', 0),
 (872, 1, '2017-10-15 12:00:21', '2017-10-15 10:00:21', '[caption id="" align="alignleft" width="268"]<a href="https://scontent-frt3-2.xx.fbcdn.net/v/t31.0-8/22424499_158906828039156_5046277694526399295_o.jpg?oh=49af52b26e23b4fcf0b4167d20884952&amp;oe=5A3D0E3F"><img class="" src="https://scontent-frt3-2.xx.fbcdn.net/v/t31.0-8/22424499_158906828039156_5046277694526399295_o.jpg?oh=49af52b26e23b4fcf0b4167d20884952&amp;oe=5A3D0E3F" width="268" height="151" /></a> facebook.com/lksslesin/[/caption]\n\n<strong>Perfekcyjne sobotnie popołudnie zafundowali nam Seniorzy LKS-u Ślesin. Nasi zawodnicy unieśli na barkach presje związaną z byciem liderem tabeli A -klasy i pewnie pokonali GKS Rzgów 7:0. Jest to drugi z rzędu taki wynik. </strong>\n\n<!--more-->\nStrzelcami okazali się:\nRafał Czapski\nBartek Nowak\nMarcin Marciszak <span class="text_exposed_show">\nJednego gola dołożyli nam goście notując trafienie samobójcze.\nCieszymy się z równej formy drużyny i czekamy na więcej.</span>', 'Spektakularny sukces ze Rzgowem', '', 'trash', 'open', 'open', '', 'spektakularny-sukces-ze-rzgowem__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=872', 0, 'post', '', 0),
 (874, 1, '2017-10-17 10:49:25', '2017-10-17 08:49:25', '[caption id="" align="alignleft" width="285"]<a href="http://www.przegladkoninski.pl/PL-H5/3/5126/takiego-urzedu-nie-ma-w-calym-powiecie-zmodernizowany-za-5-milionow-zlotych-film.html"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StLS03OTY5OTQtRFNDMDE3OTUuSlBH.jpg" width="285" height="190" /></a> przegladkoninski.pl[/caption]\n\n<strong>W drugiej połowie listopada mają przenieść się pracownicy do zmodernizowanego Urzędu Miasta i Gminy w Ślesinie. Obiekt jest nie do poznania. Remont kosztował blisko 5 milionów złotych.</strong>\n\n<a href="http://www.przegladkoninski.pl/PL-H5/3/5126/takiego-urzedu-nie-ma-w-calym-powiecie-zmodernizowany-za-5-milionow-zlotych-film.html">Zdjęcia i film.</a>\n\n<!--more-->\n\n<img class="size-medium wp-image-522 alignright" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="300" height="78" />\n\n&nbsp;\n\n&nbsp;\n\nBez przepychu, czysto, schludnie, bardzo ładnie, ale bez marmurów – tak o tym, jak wygląda zmodernizowany ślesiński urząd mówi burmistrz Mariusz Zaborowski. Jego gabinet znajdować się będzie na najwyższej kondygnacji. Tutaj też ma nie być luksusów. Na pewno jednak wielu pozazdrości mu widoku. Jedna ściana jest w całości przeszklona.\n\nZapraszamy na spacer po nowym gmachu. Warto obejrzeć film.', 'Takiego urzędu nie ma w całym powiecie', '', 'trash', 'open', 'open', '', 'takiego-urzedu-nie-ma-w-calym-powiecie__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=874', 0, 'post', '', 0),
 (876, 1, '2017-10-17 10:51:36', '2017-10-17 08:51:36', '[caption id="" align="alignleft" width="275"]<a href="http://www.przegladkoninski.pl/PL-H5/3/5139/wypadek-w-honoratce-gdyby-nie-bariera-ochronna-wjechalby-w-dom.html"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StLS0xOTE2NTYtaW1hZ2UwMDAwMDUoMSkuanBn.jpg" width="275" height="155" /></a> przegladkoninski.pl[/caption]\n\n<strong>W sobotę przed godz. 15.00 na drodze krajowej nr 25, w miejscowości Honoratka, doszło do kolizji. Jadący ze Ślesina w stronę Konina kierowca peugeota nie dostosował prędkości i wpadł w poślizg.</strong>\n\n<img class=" wp-image-522 alignright" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="227" height="59" />Uderzył w przydrożne barierki, od których się odbił i zatrzymał się dopiero na płocie posesji. Badanie alkomatem wykazało, że kierujący był trzeźwy. Za spowodowanie kolizji dostał mandat w wysokości 300 zł.', 'Gdyby nie bariera ochronna wjechałby w dom', '', 'trash', 'open', 'open', '', 'gdyby-nie-bariera-ochronna-wjechalby-w-dom__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=876', 0, 'post', '', 0),
 (879, 1, '2017-10-18 22:47:48', '2017-10-18 20:47:48', '<img class="alignleft size-medium wp-image-555" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/IMG_1837-300x198.jpg" alt="" width="300" height="198" />\n\n<strong>W 2016 roku weszła w życie ustawa o zakazie propagowania komunizmu lub innego ustroju totalitarnego przez nazwy budowli, obiektów i urządzeń użyteczności publicznej.</strong>\n\n<!--more-->\nW związku z tym Gmina Ślesin zobowiązana była do podjęcia uchwały o zmianie nazw niektórych ulic. Zanim jednak przygotowano projekt uchwały z propozycjami nazw ulic, Burmistrz wystąpił do Instytutu Pamięci Narodowej z prośbą o wydanie stosownej opinii,\nw odniesieniu do których ulic należy dokonać zmian.\n\nPo uzyskaniu odpowiedzi z IPN, Rada Miejska Gminy Ślesin podjęła uchwałę\nw sprawie zmiany nazw następujących ulic:\n\n<strong>- nazwę ul. XXX-lecia PRL na nazwę ulica Powstańców Wielkopolskich\n- nazwę ul. gen. Karola Świerczewskiego na nazwę ulica Północna\n- nazwę ul. Oskara Langego na nazwę ulica Jana Niedźwiedzińskiego\n- nazwę ul. 20-stycznia na nazwę ulica 20 Stycznia\n- nazwę ul. Aleksandra Zawadzkiego na nazwę ulica Tadeusza Zawadzkiego\n- nazwę ul. Leona Kruczkowskiego na nazwę ulica Fryderyka Chopina.</strong>\n\nMieszkańcy, którzy zamieszkują przy ww. ulicach otrzymali stosowne pisma o zmianie nazw ulic wraz z informacją, że wszelkie zmiany, których należy dokonać w innych dokumentach, są wolne od opłat oraz, że zmiana nazwy dokonana na podstawie tej ustawy nie ma wpływu na ważność dokumentów zawierających nazwę dotychczasową.\n\nŹródło: umig.slesin.pl', 'Nowe nazwy ulic w Ślesinie', '', 'trash', 'open', 'open', '', 'nowe-nazwy-ulic-w-slesinie__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=879', 0, 'post', '', 0),
 (881, 1, '2017-10-18 22:50:13', '2017-10-18 20:50:13', '[caption id="" align="alignleft" width="307"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1756770071291753/1756769874625106/?type=3&amp;theater"><img class="" src="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/22448116_1756769874625106_2971080943201395968_n.jpg?oh=edb80bfd017a5c429eed3fd40be70100&amp;oe=5A6DC45B" width="307" height="205" /></a> facebook.com/mgokslesin[/caption]\n\n<strong>Wielkim sukcesem może pochwalić się Studio Piosenki prowadzone przez Piotra Piechockiego w M-GOK bowiem aż pięć solistek zostało zakwalifikowanych do Finału Ogólnopolskiego Festiwalu "Piosenki na dobre i złe" w Szczecinie.</strong>\n\nSą to: Gabrysia Lityńska - kategoria wiekowa 10-12 lat, Klaudia Hejman, Kinga Żelichowska i Ola Piechocka - kategoria wiekowa 13-15 lat i Julka Marcinkowska w kategorii wiekowej 16-19 lat. Gratulujemy młodym wokalistkom i trzymamy kciuki podczas ich udziału w Finale.', 'Sukces solistek Studia Piosenki', '', 'trash', 'open', 'open', '', 'sukces-solistek-studia-piosenki__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=881', 0, 'post', '', 0),
 (883, 1, '2017-10-18 22:53:24', '2017-10-18 20:53:24', '[caption id="" align="alignleft" width="261"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1758472901121470/1758472727788154/?type=3&amp;theater"><img class="" src="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/22519107_1758472727788154_8521197212812428911_n.jpg?oh=cde09c34ee32a6ee13ccfdd88f1e9d43&amp;oe=5A86B28F" width="261" height="174" /></a> facebook.com/mgokslesin/[/caption]\n\n<strong>Wielki sukces odniosły podopieczne Piotra Piechockiego instruktora w M-GOK Ślesin. W dniach 14-15 października odbył się Finał XXIV-go Ogólnopolskiego Festiwalu "Piosenka na dobre i złe" w Szczecinie.</strong>\n\n<!--more-->\n\nPo przesłuchaniu przesłanych nagrań "demo" komisja artystyczna zakwalifikowała do Finału około 60 osób z całej Polski. W dniu 14-go października były eliminacje "na żywo". Do ścisłego Finału przeszły 23 osoby w tym 3 ze Ślesina. Następnego dnia po Koncercie Galowym jury w składz<span class="text_exposed_show">ie: Iwona Górewicz, Pauline Lemańska i Agata Buczkowska przyznało nagrodę GRAND PRIX Julii Marcinkowskiej ze Studia Wokalnego w M-GOK Ślesin. </span>\n\n<span class="text_exposed_show">Ponadto w kategorii wiekowej 13-15 lat Kinga Żelichowska zajęła PIERWSZE MIEJSCE a Aleksandra Piechocka MIEJSCE TRZECIE! </span>\n\n<span class="text_exposed_show">Gratulujemy naszym znakomitym wokalistkom i ich instruktorowi! Na zdjęciach Julka, Kinga i Ola ze swoim instruktorem oraz dyrektorem Festiwalu i jurorami, a w drodze powrotnej pyszne kremy lodowe.</span>', 'Wielki sukces podopiecznych Piotra Piechockiego', '', 'trash', 'open', 'open', '', 'wielki-sukces-podopiecznych-piotra-piechockiego__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=883', 0, 'post', '', 0),
 (885, 1, '2017-10-18 22:54:14', '2017-10-18 20:54:14', '[caption id="" align="aligncenter" width="679"]<a href="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/22491523_1758500577785369_3742747867775661911_n.jpg?oh=2c3db0ebffcc3a123a613a134e771012&amp;oe=5A83A8A6"><img class="size-medium" src="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/22491523_1758500577785369_3742747867775661911_n.jpg?oh=2c3db0ebffcc3a123a613a134e771012&amp;oe=5A83A8A6" width="679" height="960" /></a> facebook.com/mgokslesin/[/caption]', 'Koncert operetkowy', '', 'trash', 'open', 'open', '', 'koncert-operetkowy__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=885', 0, 'post', '', 0),
 (888, 1, '2017-10-21 16:15:08', '2017-10-21 14:15:08', '[caption id="" align="alignleft" width="329"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1758502474451846/1758501744451919/?type=3&amp;theater"><img class="" src="https://scontent-frt3-2.xx.fbcdn.net/v/t1.0-9/22552301_1758501744451919_397566131509657800_n.jpg?oh=8d267cb79796a16da24b56b1ff4e347b&amp;oe=5A6E0F33" width="329" height="219" /></a> facebook.com/mgokslesin[/caption]\n\n<strong>16 i 17 października br. w Miejsko-Gminnym Ośrodku Kultury w Ślesinie odbyły się warsztaty filmowe i telewizyjne NAKRĘCONA GMINA, w których wzięła udział ślesińska młodzież gimnazjalna.</strong>\n\n<!--more-->\n\n<img class="size-full wp-image-65 alignright" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/mgok.jpg" alt="" width="71" height="51" />Warsztaty były jednym z elementów składowych projektu, którego celem była edukacja artystyczna, wzbudzanie lokalnego patriotyzmu oraz kreowanie aktywnych postaw kulturalnych i społecznych wśród młodzieży gimnazjalnej oraz mieszkańców Ślesina.\n\n<span class="text_exposed_show">\nPomysłodawcami i realizatorami projektu było Stowarzyszenie „Między Ludźmi i jeziorami” oraz Centrum Kultury i Sztuki w Koninie. Projekt otrzymał dofinansowanie ze środków Samorządu Województwa Wielkopolskiego.</span>\n\n<span class="text_exposed_show">\n16 godzinne warsztaty dla 20-osobowej grupy, podczas których młodzi filmowcy poznawali narzędzia i metody pracy, którymi posługują się operatorzy kamer, montażyści, dziennikarze, aktorzy oraz inne osoby zaangażowane przy produkcji filmu, poprowadził właściciel firmy „Good Film” – Michał Baranowski – operator kamery, montażysta, grafik komputerowy, fotograf, producent telewizyjny.\nZdobyta podczas spotkania wiedza dała młodzieży podstawy do wykazania się twórczą aktywnością. Warsztaty zaowocowały kilkoma etiudami filmowymi w tym spotem o gminie Ślesin. Wszystkie zrealizowane filmy zostaną wyemitowane na integracyjnym spotkaniu podsumowującym projekt 28 listopada 2017 r.</span>', 'Warsztaty filmowe i telewizyjne NAKRĘCONA GMINA', '', 'trash', 'open', 'open', '', 'warsztaty-filmowe-i-telewizyjne-nakrecona-gmina__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=888', 0, 'post', '', 0),
 (891, 1, '2017-10-21 16:17:29', '2017-10-21 14:17:29', '[caption id="" align="alignleft" width="279"]<img class="" src="https://scontent-frt3-2.xx.fbcdn.net/v/t1.0-9/22519404_160055354590970_7025332682541113965_n.jpg?oh=4ce49d43c48d97c4bf542433329fd1ec&amp;oe=5A807356" width="279" height="157" /> facebook.com/lksslesin/[/caption]\n\n<strong>Niezwykle interesująco zapowiada się kolejne starcie naszej drużyny w lidze. LKS wybiera się na stadion do Krzymowa ,by zmierzyć się z tamtejszą Wartą.</strong>\n\n<!--more-->\nJest to mecz z gatunku o sześć punktów, ponieważ rywale są blisko Ślesiniaków i będą chcieli jeszcze tą przewagę zniwelować. Nasz cel jest prosty - wybiegać, wywalczyć i wygrać.\nWszystkich zainteresowanych meczami LKS-u Ślesin zapraszamy do wspólnego wyjazdu i kibicowania drużynie już w najbliższą niedziele o 15 .', 'Mecz z Krzymowem', '', 'trash', 'open', 'open', '', 'mecz-z-krzymowem__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=891', 0, 'post', '', 0),
 (893, 1, '2017-10-21 16:29:46', '2017-10-21 14:29:46', '<strong>Z ks. Bogusławem Bindą MIC, nowym przełożonym licheńskiej wspólnoty zakonnej księży marianów w Licheniu rozmawia Robert Adamczyk z biura prasowego Sanktuarium.</strong>\n\n<!--more-->\n\n<img class="size-full wp-image-503 alignright" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/240915_logo_standard.png" alt="" width="175" height="70" />- <strong>Proszę powiedzieć kilka słów o sobie.</strong>\n<div class="skocz_do"></div>\n<div id="dalsza_czesc"></div>\n- Pochodzę z Małopolski, z Beskidu Wyspowego. Urodziłem się 4 kwietnia 1964 roku w Limanowej. Zostałem ochrzczony 3 maja, a więc w święto Matki Bożej Królowej Polski. Pierwsze śluby zakonne złożyłem 8 września 1985 roku - w święto Narodzenia Najświętszej Maryi Panny, a śluby wieczyste 26 sierpnia 1989 roku - w Uroczystość Matki Bożej Częstochowskiej. Dodam jeszcze, że moja rodzinna parafia w małopolskim Tymbarku jest pod wezwaniem Narodzenia Najświętszej Maryi Panny.\n\n- <strong>Co sprawiło, że wybór padł właśnie na Zgromadzenie Księży Marianów?</strong>\n\n- Zostałem wychowany w rodzinie katolickiej, gdzie wartości chrześcijańskie, wiara, tradycja były wpajane od najmłodszych lat. Uczęszczając do szkoły podstawowej i średniej posługiwałem w kościele jako ministrant i lektor. Jednak w tamtym czasie nic nie wskazywało na to, że moja droga życiowa będzie drogą kapłaństwa, a tym bardziej życia zakonnego. Na wybór tej drogi wpływ miało pewne zdarzenie ze szkoły średniej. W tamtym czasie byłem członkiem szkolnego zespołu muzycznego. Pewnego razu zostaliśmy poproszeni o przygotowanie oprawy muzycznej Mszy Świętej prymicyjnej, jaka miała się odbyć w naszej parafii. Okazało się, że owym nowo wyświęconym kapłanem był właśnie marianin. W ramach podziękowania mariański neoprezbiter, dziś już nieżyjący ks. Władysław Duda, zaproponował nam wyjazd do Rzepisk. I tak poznałem to zgromadzenie. Po powrocie, a było to w oktawie Bożego Ciała, zrozumiałem, że pragnę zostać kapłanem i pójść tą drogą. Dostrzegłem, że właśnie tę drogę przygotował dla mnie Bóg. Nie zastanawiałem się zbyt długo nad kwestią rozpoczęcia studiów teologicznych przygotowujących do kapłaństwa, tak jak nie miałem też problemu z wyborem zgromadzenia – wiedziałem, że będą to marianie. Już 15 lipca rozpocząłem miesięczny postulat w Lublinie, a 7 września w Skórcu rozpocząłem nowicjat.\n\n- <strong>Co jest dla księdza najważniejsze w kapłaństwie?</strong>\n\n- Staram się zwracać uwagę na dwie kwestie - posługę przy ołtarzu i w konfesjonale. Uważam, że jeśli będę starał się posługiwać najlepiej jak potrafię, to wszystkie inne kwestie także uda mi się poukładać. Źródłem i szczytem życia każdego chrześcijanina jest Eucharystia. Nie wyobrażam sobie, abym jako kapłan miał w głównej mierze koncentrować się na kwestiach doczesnych. One oczywiście są ważne w kontekście właściwego funkcjonowania w świecie. Jednak wszystko będzie na swoim miejscu, gdy w centrum mojego życia będzie Bóg. Dlatego dla mnie najważniejszym jest, aby skoncentrować się wokół ołtarza słowa Bożego i ołtarza Eucharystii.\n\n- <strong>Proszę powiedzieć, gdzie ksiądz ostatnio pełnił posługę?</strong>\n\n- Zanim przyjechałem do Lichenia pracowałem w parafii pw. Najświętszej Maryi Panny Matki Miłosierdzia na warszawskich Stegnach. Posługiwałem tam w sumie 15 lat, m.in. jako proboszcz i przełożony domu zakonnego.\n\n- <strong>Czy informacja o przenosinach do Lichenia była zaskoczeniem?</strong>\n\n- W ubiegłym roku obchodziłem jubileusz 25-lecia kapłaństwa a, jak już mówiłem, w Warszawie spędziłem z nich lat 15. Ten czas z pewnością zostawił ślad w moim życiu. Wiadomość o tym, że przełożeni zakonni chcą mnie skierować do domu zakonnego i Sanktuarium Matki Bożej Licheńskiej odebrałem jako pełnienie woli Bożej. Moje myśli koncentrowały się na tym, aby doprowadzić do końca wszystkie możliwe sprawy i przekazać obowiązki mojemu następcy. Zacząłem też zastanawiać się, w jaki sposób wyjść naprzeciw obowiązkom, jakie spoczywać będą na moich barkach po przenosinach do nowego miejsca. Zostałem postawiony przed nowym wyzwaniem. Bez wątpienia nowością jest dla mnie tak liczna wspólnota moich współbraci, a co za tym idzie większa różnorodność zarówno pod względem wieku, charakterów, jak i innego spojrzenia na sprawy Kościoła i Zgromadzania. Z częścią współbraci dane mi było spotykać się w przeszłości w innych placówkach mariańskich. Są jednak i tacy, z którymi jest mi dane spotkać się po raz pierwszy.\n\n- <strong>Jak przebiega adaptacja?</strong>\n\n- Bez wątpienia licheńskie Sanktuarium i tutejsza parafia to wyjątkowe miejsce pracy. Po pierwsze, w domu zakonnym w Licheniu mieszka największa liczba księży i braci marianów spośród wszystkich mariańskich domów na świecie. Po drugie, w obsłudze pielgrzymów pracuje wiele osób świeckich. Na ile to możliwe, staram się poznawać tych ludzi. Podchodzę do tego ze spokojem. Powoli buduję sobie ogólny ogląd miejsca. Są kwestie, na rozważenie których, potrzebuję nieco więcej czasu. Ale jestem otwarty na nowe wyzwania, które z całą pewnością będą się pojawiać.\n\n- <strong>Czy zrodziły się już księdzu jakieś pomysły?</strong>\n\n- Od początku mojej posługi bliskie było mi duszpasterstwo. Natomiast objęcie obowiązków przełożonego domu zakonnego oznacza pewne oczekiwania ze strony współbraci, szczególnie na „coś” nowego, z jednoczesną kontynuacją tych działań, które już zostały rozpoczęte. Z pewnością będę zabiegał u przełożonych o skierowanie do licheńskiej wspólnoty zakonnej kapłanów, którzy mogliby pomóc w posłudze duszpasterskiej w Sanktuarium. Licheński dom zakonny w znacznym stopniu zamieszkują księża w podeszłym wieku, a pracy związanej z odprawianiem Mszy Świętych, głoszeniem słowa Bożego czy posługą w konfesjonałach w sezonie pielgrzymkowym jest dużo.\n\n- <strong>W jaki sposób spróbowałby ksiądz opisać dzisiejszą kondycję Zgromadzenia Księży Marianów?</strong>\n\n- Moim zdaniem kondycja naszego Zgromadzenia nie jest zła. Czas, gdy ja wstępowałem do marianów, był czasem wzrostu powołań. Gdy byłem klerykiem w seminarium było nas ponad stu. Dziś w naszym seminarium mamy 20 kleryków. Ja i moi współbracia rówieśnicy należymy do średniego pokolenia. Przed nami są księża, którzy zbliżają się lub już osiągnęli wiek emerytalny, jednak w miarę sił dalej posługują głosząc słowo Boże i posługując w konfesjonałach. Obecnie nie mamy wielu powołań i w tym upatruję problem.\n\n-<strong> W jaki sposób zachęciłby ksiądz młodych ludzi do wybrania życia zakonnego?</strong>\n\n- Bez wątpienia dla każdego z nas fundamentem jest rodzina. I to nie dotyczy tylko życia zakonnego czy kapłańskiego, ale także osób, które w przyszłości pragną iść przez życie ze współmałżonkiem. Jeżeli rodzina jest silna Bogiem i w tym duchu młody człowiek wzrasta, wówczas łatwiej jest podjąć decyzję, co do swojej przyszłości, a potem podążać w raz obranym kierunku.\n\n- <strong>W jaki sposób spędza ksiądz czas wolny?</strong>\n\n- Lubię muzykę. Nie mam jednego ulubionego gatunku - po prostu lubię słuchać dobrej muzyki. Pochodzę z Małopolski i bliski mojemu sercu jest folklor, który towarzyszy mi od wczesnej młodości. Pochodzę z muzykującej rodziny: mój dziadek grał na skrzypcach i klarnecie a tata na akordeonie. W młodości grałem na trąbce w orkiestrze dętej, a w seminarium próbowałem sił na gitarze. Poza tym lubię oglądać mecze piłki nożnej.\n\nDziękuje za rozmowę.\n\nŹródło: LM.pl', 'Przed nowym wyzwaniem', '', 'trash', 'open', 'open', '', 'przed-nowym-wyzwaniem__trashed', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 0, 'http://gminaslesin.futurehost.pl/?p=893', 0, 'post', '', 0),
 (898, 1, '2017-10-23 15:01:31', '2017-10-23 15:01:31', '{\n    "blogname": {\n        "value": "METEOprognoza",\n        "type": "option",\n        "user_id": 1\n    },\n    "blogdescription": {\n        "value": "Pogoda to nasz \\u017cywio\\u0142",\n        "type": "option",\n        "user_id": 1\n    },\n    "mesocolumn::header_logo": {\n        "value": "http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/10/meteoprognoza-logo.png",\n        "type": "theme_mod",\n        "user_id": 1\n    },\n    "site_icon": {\n        "value": 902,\n        "type": "option",\n        "user_id": 1\n    },\n    "mesocolumn::fav_icon": {\n        "value": "http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/10/print-logo2pr.jpg",\n        "type": "theme_mod",\n        "user_id": 1\n    }\n}', '', '', 'trash', 'closed', 'closed', '', '2da75753-4cbe-4ff4-8287-6f0a840f1100', '', '', '2017-10-23 15:01:31', '2017-10-23 15:01:31', '', 0, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=898', 0, 'customize_changeset', '', 0),
 (900, 1, '2017-10-23 15:00:23', '2017-10-23 15:00:23', '', 'meteoprognoza-logo', '', 'inherit', 'open', 'closed', '', 'meteoprognoza-logo', '', '', '2017-10-23 15:00:23', '2017-10-23 15:00:23', '', 0, 'http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/10/meteoprognoza-logo.png', 0, 'attachment', 'image/png', 0),
 (901, 1, '2017-10-23 15:00:57', '2017-10-23 15:00:57', '', 'print-logo2pr', '', 'inherit', 'open', 'closed', '', 'print-logo2pr', '', '', '2017-10-23 15:00:57', '2017-10-23 15:00:57', '', 0, 'http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/10/print-logo2pr.jpg', 0, 'attachment', 'image/jpeg', 0),
 (902, 1, '2017-10-23 15:01:23', '2017-10-23 15:01:23', 'http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/10/cropped-print-logo2pr.jpg', 'cropped-print-logo2pr.jpg', '', 'inherit', 'open', 'closed', '', 'cropped-print-logo2pr-jpg', '', '', '2017-10-23 15:01:23', '2017-10-23 15:01:23', '', 0, 'http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/10/cropped-print-logo2pr.jpg', 0, 'attachment', 'image/jpeg', 0),
 (903, 1, '2017-10-23 15:03:49', '2017-10-23 15:03:49', '{\n    "mesocolumn::feat_img_size": {\n        "value": "medium",\n        "type": "theme_mod",\n        "user_id": 1\n    },\n    "mesocolumn::blogpost_style": {\n        "value": "magazine",\n        "type": "theme_mod",\n        "user_id": 1\n    },\n    "mesocolumn::post_excerpt_moretext": {\n        "value": "czytaj dalej",\n        "type": "theme_mod",\n        "user_id": 1\n    },\n    "mesocolumn::related_on": {\n        "value": "enable",\n        "type": "theme_mod",\n        "user_id": 1\n    }\n}', '', '', 'trash', 'closed', 'closed', '', 'a2ef5d12-c867-4880-a530-259f22d3f2e6', '', '', '2017-10-23 15:03:49', '2017-10-23 15:03:49', '', 0, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=903', 0, 'customize_changeset', '', 0),
 (904, 1, '2017-10-23 15:04:34', '2017-10-23 15:04:34', '{\n    "mesocolumn::slider_on": {\n        "value": "enable",\n        "type": "theme_mod",\n        "user_id": 1\n    },\n    "mesocolumn::feat_cat": {\n        "value": "1",\n        "type": "theme_mod",\n        "user_id": 1\n    },\n    "mesocolumn::feat_cat_count": {\n        "value": "6",\n        "type": "theme_mod",\n        "user_id": 1\n    }\n}', '', '', 'trash', 'closed', 'closed', '', '7967de9a-6c83-45ee-b6d0-498ec9fc83eb', '', '', '2017-10-23 15:04:34', '2017-10-23 15:04:34', '', 0, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=904', 0, 'customize_changeset', '', 0),
 (905, 1, '2017-10-23 15:05:45', '2017-10-23 15:05:45', '{\n    "mesocolumn::footer_credit": {\n        "value": "enable",\n        "type": "theme_mod",\n        "user_id": 1\n    },\n    "mesocolumn::schema_on": {\n        "value": "enable",\n        "type": "theme_mod",\n        "user_id": 1\n    },\n    "mesocolumn::schema_breadcrumb_on": {\n        "value": "enable",\n        "type": "theme_mod",\n        "user_id": 1\n    },\n    "mesocolumn::responsive_mode": {\n        "value": "enable",\n        "type": "theme_mod",\n        "user_id": 1\n    }\n}', '', '', 'trash', 'closed', 'closed', '', '3da6cb15-589e-486b-b4ed-313a749e39d7', '', '', '2017-10-23 15:05:45', '2017-10-23 15:05:45', '', 0, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=905', 0, 'customize_changeset', '', 0),
 (906, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '<strong>Z ks. Bogusławem Bindą MIC, nowym przełożonym licheńskiej wspólnoty zakonnej księży marianów w Licheniu rozmawia Robert Adamczyk z biura prasowego Sanktuarium.</strong>\n\n<!--more-->\n\n<img class="size-full wp-image-503 alignright" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/240915_logo_standard.png" alt="" width="175" height="70" />- <strong>Proszę powiedzieć kilka słów o sobie.</strong>\n<div class="skocz_do"></div>\n<div id="dalsza_czesc"></div>\n- Pochodzę z Małopolski, z Beskidu Wyspowego. Urodziłem się 4 kwietnia 1964 roku w Limanowej. Zostałem ochrzczony 3 maja, a więc w święto Matki Bożej Królowej Polski. Pierwsze śluby zakonne złożyłem 8 września 1985 roku - w święto Narodzenia Najświętszej Maryi Panny, a śluby wieczyste 26 sierpnia 1989 roku - w Uroczystość Matki Bożej Częstochowskiej. Dodam jeszcze, że moja rodzinna parafia w małopolskim Tymbarku jest pod wezwaniem Narodzenia Najświętszej Maryi Panny.\n\n- <strong>Co sprawiło, że wybór padł właśnie na Zgromadzenie Księży Marianów?</strong>\n\n- Zostałem wychowany w rodzinie katolickiej, gdzie wartości chrześcijańskie, wiara, tradycja były wpajane od najmłodszych lat. Uczęszczając do szkoły podstawowej i średniej posługiwałem w kościele jako ministrant i lektor. Jednak w tamtym czasie nic nie wskazywało na to, że moja droga życiowa będzie drogą kapłaństwa, a tym bardziej życia zakonnego. Na wybór tej drogi wpływ miało pewne zdarzenie ze szkoły średniej. W tamtym czasie byłem członkiem szkolnego zespołu muzycznego. Pewnego razu zostaliśmy poproszeni o przygotowanie oprawy muzycznej Mszy Świętej prymicyjnej, jaka miała się odbyć w naszej parafii. Okazało się, że owym nowo wyświęconym kapłanem był właśnie marianin. W ramach podziękowania mariański neoprezbiter, dziś już nieżyjący ks. Władysław Duda, zaproponował nam wyjazd do Rzepisk. I tak poznałem to zgromadzenie. Po powrocie, a było to w oktawie Bożego Ciała, zrozumiałem, że pragnę zostać kapłanem i pójść tą drogą. Dostrzegłem, że właśnie tę drogę przygotował dla mnie Bóg. Nie zastanawiałem się zbyt długo nad kwestią rozpoczęcia studiów teologicznych przygotowujących do kapłaństwa, tak jak nie miałem też problemu z wyborem zgromadzenia – wiedziałem, że będą to marianie. Już 15 lipca rozpocząłem miesięczny postulat w Lublinie, a 7 września w Skórcu rozpocząłem nowicjat.\n\n- <strong>Co jest dla księdza najważniejsze w kapłaństwie?</strong>\n\n- Staram się zwracać uwagę na dwie kwestie - posługę przy ołtarzu i w konfesjonale. Uważam, że jeśli będę starał się posługiwać najlepiej jak potrafię, to wszystkie inne kwestie także uda mi się poukładać. Źródłem i szczytem życia każdego chrześcijanina jest Eucharystia. Nie wyobrażam sobie, abym jako kapłan miał w głównej mierze koncentrować się na kwestiach doczesnych. One oczywiście są ważne w kontekście właściwego funkcjonowania w świecie. Jednak wszystko będzie na swoim miejscu, gdy w centrum mojego życia będzie Bóg. Dlatego dla mnie najważniejszym jest, aby skoncentrować się wokół ołtarza słowa Bożego i ołtarza Eucharystii.\n\n- <strong>Proszę powiedzieć, gdzie ksiądz ostatnio pełnił posługę?</strong>\n\n- Zanim przyjechałem do Lichenia pracowałem w parafii pw. Najświętszej Maryi Panny Matki Miłosierdzia na warszawskich Stegnach. Posługiwałem tam w sumie 15 lat, m.in. jako proboszcz i przełożony domu zakonnego.\n\n- <strong>Czy informacja o przenosinach do Lichenia była zaskoczeniem?</strong>\n\n- W ubiegłym roku obchodziłem jubileusz 25-lecia kapłaństwa a, jak już mówiłem, w Warszawie spędziłem z nich lat 15. Ten czas z pewnością zostawił ślad w moim życiu. Wiadomość o tym, że przełożeni zakonni chcą mnie skierować do domu zakonnego i Sanktuarium Matki Bożej Licheńskiej odebrałem jako pełnienie woli Bożej. Moje myśli koncentrowały się na tym, aby doprowadzić do końca wszystkie możliwe sprawy i przekazać obowiązki mojemu następcy. Zacząłem też zastanawiać się, w jaki sposób wyjść naprzeciw obowiązkom, jakie spoczywać będą na moich barkach po przenosinach do nowego miejsca. Zostałem postawiony przed nowym wyzwaniem. Bez wątpienia nowością jest dla mnie tak liczna wspólnota moich współbraci, a co za tym idzie większa różnorodność zarówno pod względem wieku, charakterów, jak i innego spojrzenia na sprawy Kościoła i Zgromadzania. Z częścią współbraci dane mi było spotykać się w przeszłości w innych placówkach mariańskich. Są jednak i tacy, z którymi jest mi dane spotkać się po raz pierwszy.\n\n- <strong>Jak przebiega adaptacja?</strong>\n\n- Bez wątpienia licheńskie Sanktuarium i tutejsza parafia to wyjątkowe miejsce pracy. Po pierwsze, w domu zakonnym w Licheniu mieszka największa liczba księży i braci marianów spośród wszystkich mariańskich domów na świecie. Po drugie, w obsłudze pielgrzymów pracuje wiele osób świeckich. Na ile to możliwe, staram się poznawać tych ludzi. Podchodzę do tego ze spokojem. Powoli buduję sobie ogólny ogląd miejsca. Są kwestie, na rozważenie których, potrzebuję nieco więcej czasu. Ale jestem otwarty na nowe wyzwania, które z całą pewnością będą się pojawiać.\n\n- <strong>Czy zrodziły się już księdzu jakieś pomysły?</strong>\n\n- Od początku mojej posługi bliskie było mi duszpasterstwo. Natomiast objęcie obowiązków przełożonego domu zakonnego oznacza pewne oczekiwania ze strony współbraci, szczególnie na „coś” nowego, z jednoczesną kontynuacją tych działań, które już zostały rozpoczęte. Z pewnością będę zabiegał u przełożonych o skierowanie do licheńskiej wspólnoty zakonnej kapłanów, którzy mogliby pomóc w posłudze duszpasterskiej w Sanktuarium. Licheński dom zakonny w znacznym stopniu zamieszkują księża w podeszłym wieku, a pracy związanej z odprawianiem Mszy Świętych, głoszeniem słowa Bożego czy posługą w konfesjonałach w sezonie pielgrzymkowym jest dużo.\n\n- <strong>W jaki sposób spróbowałby ksiądz opisać dzisiejszą kondycję Zgromadzenia Księży Marianów?</strong>\n\n- Moim zdaniem kondycja naszego Zgromadzenia nie jest zła. Czas, gdy ja wstępowałem do marianów, był czasem wzrostu powołań. Gdy byłem klerykiem w seminarium było nas ponad stu. Dziś w naszym seminarium mamy 20 kleryków. Ja i moi współbracia rówieśnicy należymy do średniego pokolenia. Przed nami są księża, którzy zbliżają się lub już osiągnęli wiek emerytalny, jednak w miarę sił dalej posługują głosząc słowo Boże i posługując w konfesjonałach. Obecnie nie mamy wielu powołań i w tym upatruję problem.\n\n-<strong> W jaki sposób zachęciłby ksiądz młodych ludzi do wybrania życia zakonnego?</strong>\n\n- Bez wątpienia dla każdego z nas fundamentem jest rodzina. I to nie dotyczy tylko życia zakonnego czy kapłańskiego, ale także osób, które w przyszłości pragną iść przez życie ze współmałżonkiem. Jeżeli rodzina jest silna Bogiem i w tym duchu młody człowiek wzrasta, wówczas łatwiej jest podjąć decyzję, co do swojej przyszłości, a potem podążać w raz obranym kierunku.\n\n- <strong>W jaki sposób spędza ksiądz czas wolny?</strong>\n\n- Lubię muzykę. Nie mam jednego ulubionego gatunku - po prostu lubię słuchać dobrej muzyki. Pochodzę z Małopolski i bliski mojemu sercu jest folklor, który towarzyszy mi od wczesnej młodości. Pochodzę z muzykującej rodziny: mój dziadek grał na skrzypcach i klarnecie a tata na akordeonie. W młodości grałem na trąbce w orkiestrze dętej, a w seminarium próbowałem sił na gitarze. Poza tym lubię oglądać mecze piłki nożnej.\n\nDziękuje za rozmowę.\n\nŹródło: LM.pl', 'Przed nowym wyzwaniem', '', 'inherit', 'closed', 'closed', '', '893-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 893, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=906', 0, 'revision', '', 0),
 (907, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '[caption id="" align="alignleft" width="279"]<img class="" src="https://scontent-frt3-2.xx.fbcdn.net/v/t1.0-9/22519404_160055354590970_7025332682541113965_n.jpg?oh=4ce49d43c48d97c4bf542433329fd1ec&amp;oe=5A807356" width="279" height="157" /> facebook.com/lksslesin/[/caption]\n\n<strong>Niezwykle interesująco zapowiada się kolejne starcie naszej drużyny w lidze. LKS wybiera się na stadion do Krzymowa ,by zmierzyć się z tamtejszą Wartą.</strong>\n\n<!--more-->\nJest to mecz z gatunku o sześć punktów, ponieważ rywale są blisko Ślesiniaków i będą chcieli jeszcze tą przewagę zniwelować. Nasz cel jest prosty - wybiegać, wywalczyć i wygrać.\nWszystkich zainteresowanych meczami LKS-u Ślesin zapraszamy do wspólnego wyjazdu i kibicowania drużynie już w najbliższą niedziele o 15 .', 'Mecz z Krzymowem', '', 'inherit', 'closed', 'closed', '', '891-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 891, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=907', 0, 'revision', '', 0),
 (908, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '[caption id="" align="alignleft" width="329"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1758502474451846/1758501744451919/?type=3&amp;theater"><img class="" src="https://scontent-frt3-2.xx.fbcdn.net/v/t1.0-9/22552301_1758501744451919_397566131509657800_n.jpg?oh=8d267cb79796a16da24b56b1ff4e347b&amp;oe=5A6E0F33" width="329" height="219" /></a> facebook.com/mgokslesin[/caption]\n\n<strong>16 i 17 października br. w Miejsko-Gminnym Ośrodku Kultury w Ślesinie odbyły się warsztaty filmowe i telewizyjne NAKRĘCONA GMINA, w których wzięła udział ślesińska młodzież gimnazjalna.</strong>\n\n<!--more-->\n\n<img class="size-full wp-image-65 alignright" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/07/mgok.jpg" alt="" width="71" height="51" />Warsztaty były jednym z elementów składowych projektu, którego celem była edukacja artystyczna, wzbudzanie lokalnego patriotyzmu oraz kreowanie aktywnych postaw kulturalnych i społecznych wśród młodzieży gimnazjalnej oraz mieszkańców Ślesina.\n\n<span class="text_exposed_show">\nPomysłodawcami i realizatorami projektu było Stowarzyszenie „Między Ludźmi i jeziorami” oraz Centrum Kultury i Sztuki w Koninie. Projekt otrzymał dofinansowanie ze środków Samorządu Województwa Wielkopolskiego.</span>\n\n<span class="text_exposed_show">\n16 godzinne warsztaty dla 20-osobowej grupy, podczas których młodzi filmowcy poznawali narzędzia i metody pracy, którymi posługują się operatorzy kamer, montażyści, dziennikarze, aktorzy oraz inne osoby zaangażowane przy produkcji filmu, poprowadził właściciel firmy „Good Film” – Michał Baranowski – operator kamery, montażysta, grafik komputerowy, fotograf, producent telewizyjny.\nZdobyta podczas spotkania wiedza dała młodzieży podstawy do wykazania się twórczą aktywnością. Warsztaty zaowocowały kilkoma etiudami filmowymi w tym spotem o gminie Ślesin. Wszystkie zrealizowane filmy zostaną wyemitowane na integracyjnym spotkaniu podsumowującym projekt 28 listopada 2017 r.</span>', 'Warsztaty filmowe i telewizyjne NAKRĘCONA GMINA', '', 'inherit', 'closed', 'closed', '', '888-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 888, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=908', 0, 'revision', '', 0),
 (909, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '[caption id="" align="aligncenter" width="679"]<a href="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/22491523_1758500577785369_3742747867775661911_n.jpg?oh=2c3db0ebffcc3a123a613a134e771012&amp;oe=5A83A8A6"><img class="size-medium" src="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/22491523_1758500577785369_3742747867775661911_n.jpg?oh=2c3db0ebffcc3a123a613a134e771012&amp;oe=5A83A8A6" width="679" height="960" /></a> facebook.com/mgokslesin/[/caption]', 'Koncert operetkowy', '', 'inherit', 'closed', 'closed', '', '885-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 885, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=909', 0, 'revision', '', 0),
 (910, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '[caption id="" align="alignleft" width="261"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1758472901121470/1758472727788154/?type=3&amp;theater"><img class="" src="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/22519107_1758472727788154_8521197212812428911_n.jpg?oh=cde09c34ee32a6ee13ccfdd88f1e9d43&amp;oe=5A86B28F" width="261" height="174" /></a> facebook.com/mgokslesin/[/caption]\n\n<strong>Wielki sukces odniosły podopieczne Piotra Piechockiego instruktora w M-GOK Ślesin. W dniach 14-15 października odbył się Finał XXIV-go Ogólnopolskiego Festiwalu "Piosenka na dobre i złe" w Szczecinie.</strong>\n\n<!--more-->\n\nPo przesłuchaniu przesłanych nagrań "demo" komisja artystyczna zakwalifikowała do Finału około 60 osób z całej Polski. W dniu 14-go października były eliminacje "na żywo". Do ścisłego Finału przeszły 23 osoby w tym 3 ze Ślesina. Następnego dnia po Koncercie Galowym jury w składz<span class="text_exposed_show">ie: Iwona Górewicz, Pauline Lemańska i Agata Buczkowska przyznało nagrodę GRAND PRIX Julii Marcinkowskiej ze Studia Wokalnego w M-GOK Ślesin. </span>\n\n<span class="text_exposed_show">Ponadto w kategorii wiekowej 13-15 lat Kinga Żelichowska zajęła PIERWSZE MIEJSCE a Aleksandra Piechocka MIEJSCE TRZECIE! </span>\n\n<span class="text_exposed_show">Gratulujemy naszym znakomitym wokalistkom i ich instruktorowi! Na zdjęciach Julka, Kinga i Ola ze swoim instruktorem oraz dyrektorem Festiwalu i jurorami, a w drodze powrotnej pyszne kremy lodowe.</span>', 'Wielki sukces podopiecznych Piotra Piechockiego', '', 'inherit', 'closed', 'closed', '', '883-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 883, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=910', 0, 'revision', '', 0),
 (911, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '[caption id="" align="alignleft" width="307"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1756770071291753/1756769874625106/?type=3&amp;theater"><img class="" src="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/22448116_1756769874625106_2971080943201395968_n.jpg?oh=edb80bfd017a5c429eed3fd40be70100&amp;oe=5A6DC45B" width="307" height="205" /></a> facebook.com/mgokslesin[/caption]\n\n<strong>Wielkim sukcesem może pochwalić się Studio Piosenki prowadzone przez Piotra Piechockiego w M-GOK bowiem aż pięć solistek zostało zakwalifikowanych do Finału Ogólnopolskiego Festiwalu "Piosenki na dobre i złe" w Szczecinie.</strong>\n\nSą to: Gabrysia Lityńska - kategoria wiekowa 10-12 lat, Klaudia Hejman, Kinga Żelichowska i Ola Piechocka - kategoria wiekowa 13-15 lat i Julka Marcinkowska w kategorii wiekowej 16-19 lat. Gratulujemy młodym wokalistkom i trzymamy kciuki podczas ich udziału w Finale.', 'Sukces solistek Studia Piosenki', '', 'inherit', 'closed', 'closed', '', '881-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 881, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=911', 0, 'revision', '', 0),
 (912, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '<img class="alignleft size-medium wp-image-555" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/IMG_1837-300x198.jpg" alt="" width="300" height="198" />\n\n<strong>W 2016 roku weszła w życie ustawa o zakazie propagowania komunizmu lub innego ustroju totalitarnego przez nazwy budowli, obiektów i urządzeń użyteczności publicznej.</strong>\n\n<!--more-->\nW związku z tym Gmina Ślesin zobowiązana była do podjęcia uchwały o zmianie nazw niektórych ulic. Zanim jednak przygotowano projekt uchwały z propozycjami nazw ulic, Burmistrz wystąpił do Instytutu Pamięci Narodowej z prośbą o wydanie stosownej opinii,\nw odniesieniu do których ulic należy dokonać zmian.\n\nPo uzyskaniu odpowiedzi z IPN, Rada Miejska Gminy Ślesin podjęła uchwałę\nw sprawie zmiany nazw następujących ulic:\n\n<strong>- nazwę ul. XXX-lecia PRL na nazwę ulica Powstańców Wielkopolskich\n- nazwę ul. gen. Karola Świerczewskiego na nazwę ulica Północna\n- nazwę ul. Oskara Langego na nazwę ulica Jana Niedźwiedzińskiego\n- nazwę ul. 20-stycznia na nazwę ulica 20 Stycznia\n- nazwę ul. Aleksandra Zawadzkiego na nazwę ulica Tadeusza Zawadzkiego\n- nazwę ul. Leona Kruczkowskiego na nazwę ulica Fryderyka Chopina.</strong>\n\nMieszkańcy, którzy zamieszkują przy ww. ulicach otrzymali stosowne pisma o zmianie nazw ulic wraz z informacją, że wszelkie zmiany, których należy dokonać w innych dokumentach, są wolne od opłat oraz, że zmiana nazwy dokonana na podstawie tej ustawy nie ma wpływu na ważność dokumentów zawierających nazwę dotychczasową.\n\nŹródło: umig.slesin.pl', 'Nowe nazwy ulic w Ślesinie', '', 'inherit', 'closed', 'closed', '', '879-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 879, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=912', 0, 'revision', '', 0),
 (913, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '[caption id="" align="alignleft" width="275"]<a href="http://www.przegladkoninski.pl/PL-H5/3/5139/wypadek-w-honoratce-gdyby-nie-bariera-ochronna-wjechalby-w-dom.html"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StLS0xOTE2NTYtaW1hZ2UwMDAwMDUoMSkuanBn.jpg" width="275" height="155" /></a> przegladkoninski.pl[/caption]\n\n<strong>W sobotę przed godz. 15.00 na drodze krajowej nr 25, w miejscowości Honoratka, doszło do kolizji. Jadący ze Ślesina w stronę Konina kierowca peugeota nie dostosował prędkości i wpadł w poślizg.</strong>\n\n<img class=" wp-image-522 alignright" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="227" height="59" />Uderzył w przydrożne barierki, od których się odbił i zatrzymał się dopiero na płocie posesji. Badanie alkomatem wykazało, że kierujący był trzeźwy. Za spowodowanie kolizji dostał mandat w wysokości 300 zł.', 'Gdyby nie bariera ochronna wjechałby w dom', '', 'inherit', 'closed', 'closed', '', '876-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 876, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=913', 0, 'revision', '', 0),
 (914, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '[caption id="" align="alignleft" width="285"]<a href="http://www.przegladkoninski.pl/PL-H5/3/5126/takiego-urzedu-nie-ma-w-calym-powiecie-zmodernizowany-za-5-milionow-zlotych-film.html"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StLS03OTY5OTQtRFNDMDE3OTUuSlBH.jpg" width="285" height="190" /></a> przegladkoninski.pl[/caption]\n\n<strong>W drugiej połowie listopada mają przenieść się pracownicy do zmodernizowanego Urzędu Miasta i Gminy w Ślesinie. Obiekt jest nie do poznania. Remont kosztował blisko 5 milionów złotych.</strong>\n\n<a href="http://www.przegladkoninski.pl/PL-H5/3/5126/takiego-urzedu-nie-ma-w-calym-powiecie-zmodernizowany-za-5-milionow-zlotych-film.html">Zdjęcia i film.</a>\n\n<!--more-->\n\n<img class="size-medium wp-image-522 alignright" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="300" height="78" />\n\n&nbsp;\n\n&nbsp;\n\nBez przepychu, czysto, schludnie, bardzo ładnie, ale bez marmurów – tak o tym, jak wygląda zmodernizowany ślesiński urząd mówi burmistrz Mariusz Zaborowski. Jego gabinet znajdować się będzie na najwyższej kondygnacji. Tutaj też ma nie być luksusów. Na pewno jednak wielu pozazdrości mu widoku. Jedna ściana jest w całości przeszklona.\n\nZapraszamy na spacer po nowym gmachu. Warto obejrzeć film.', 'Takiego urzędu nie ma w całym powiecie', '', 'inherit', 'closed', 'closed', '', '874-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 874, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=914', 0, 'revision', '', 0),
 (915, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '[caption id="" align="alignleft" width="268"]<a href="https://scontent-frt3-2.xx.fbcdn.net/v/t31.0-8/22424499_158906828039156_5046277694526399295_o.jpg?oh=49af52b26e23b4fcf0b4167d20884952&amp;oe=5A3D0E3F"><img class="" src="https://scontent-frt3-2.xx.fbcdn.net/v/t31.0-8/22424499_158906828039156_5046277694526399295_o.jpg?oh=49af52b26e23b4fcf0b4167d20884952&amp;oe=5A3D0E3F" width="268" height="151" /></a> facebook.com/lksslesin/[/caption]\n\n<strong>Perfekcyjne sobotnie popołudnie zafundowali nam Seniorzy LKS-u Ślesin. Nasi zawodnicy unieśli na barkach presje związaną z byciem liderem tabeli A -klasy i pewnie pokonali GKS Rzgów 7:0. Jest to drugi z rzędu taki wynik. </strong>\n\n<!--more-->\nStrzelcami okazali się:\nRafał Czapski\nBartek Nowak\nMarcin Marciszak <span class="text_exposed_show">\nJednego gola dołożyli nam goście notując trafienie samobójcze.\nCieszymy się z równej formy drużyny i czekamy na więcej.</span>', 'Spektakularny sukces ze Rzgowem', '', 'inherit', 'closed', 'closed', '', '872-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 872, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=915', 0, 'revision', '', 0),
 (916, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '[caption id="" align="alignleft" width="272"]<img class="" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/22365320_158357844760721_8758123864129528586_n.jpg?oh=098dcd203d639db91ca3a166b4b7830e&amp;oe=5A82C674" width="272" height="174" /> facebook.com/lksslesin/[/caption]\n\n<strong>W weekend odbędzie się 8 kolejka ligowa i znowu wracamy na stadion przy ulicy Napoleona 1 w Ślesinie.</strong> Tym razem podopieczni trenera Macieja Bieniaszczyka podejmować będą ekipe GKS-u Rzgów.\n\nSkicioki niepokonane w lidze chcą szybko rozprawić się z przeciwnikiem i dopisać kolejne trzy punkty do ligowej tabeli. Wszystkich dopingujących zespół LKS-u zapraszamy w sobotę o godzinie 15.', 'LKS zagra ze Rzgowem', '', 'inherit', 'closed', 'closed', '', '870-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 870, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=916', 0, 'revision', '', 0),
 (917, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '[caption id="" align="aligncenter" width="280"]<img class="size-medium" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/22448257_1317476308380426_7616266778838825447_n.jpg?oh=5ff86c59b6b9b253f706347523fc387c&amp;oe=5A780EE5" width="280" height="395" /> facebook.com/gminaslesin/[/caption]', 'Zlot miłośników aut z PRL-u', '', 'inherit', 'closed', 'closed', '', '868-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 868, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=917', 0, 'revision', '', 0),
 (918, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '[caption id="" align="aligncenter" width="679"]<a href="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/22519235_1756877101281050_8006585183499415866_n.jpg?oh=dfabef765a8948c3800598b02a4500cd&amp;oe=5A7C72B2"><img class="size-medium" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/22519235_1756877101281050_8006585183499415866_n.jpg?oh=dfabef765a8948c3800598b02a4500cd&amp;oe=5A7C72B2" width="679" height="960" /></a> facebook.com/mgokslesin/[/caption]', 'Turniej Klasyfikacyjny', '', 'inherit', 'closed', 'closed', '', '866-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 866, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=918', 0, 'revision', '', 0),
 (919, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '[caption id="" align="alignleft" width="264"]<a href="http://www.przegladkoninski.pl/PL-H5/3/5114/prawie-20-malzenstw-z-medalami-od-prezydenta-polski-50-lat-wspolnego-zycia.html"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StLS03ODg4NTAtRFNDMDE4NTAuSlBH.jpg" width="264" height="176" /></a> przegladkoninski.pl[/caption]\n\n<strong>Prawie 20 par małżeńskich świętowało dzisiaj w gminie Ślesin 50 lat wspólnego życia. Zostali odznaczeni medalami od prezydenta RP, które wręczył jubilatom burmistrz Mariusz Zaborowski.</strong>\n\n<a href="http://www.przegladkoninski.pl/PL-H5/3/5114/prawie-20-malzenstw-z-medalami-od-prezydenta-polski-50-lat-wspolnego-zycia.html" target="_blank" rel="noopener">Zdjęcia i film.</a>\n\n<!--more-->\n\n<img class="size-medium wp-image-522 alignright" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="300" height="78" />Burmistrz wszystkim parom złożył życzenia. W swojej wypowiedzi nawiązał też do tego, że sam niedawno się ożenił.\n\n– Od trzech tygodni jestem w nowym związku. Uważam, że każdy chciałby mieć i tworzyć rodzinę, dlatego taką decyzję podjąłem – mówił burmistrz Zaborowski.\n\n– Te wspólne lata to symbol wierności i miłości rodzinnej, to dowód wzajemnego zaufania, zrozumienia i istoty związku małżeńskiego. To wzór i piękny przykład dla młodych pokoleń, które decydują się związać węzłem małżeńskim zakładając rodzinę – mówiła do jubilatów Katarzyna Fryza, kierownik Urzędu Stanu Cywilnego w Ślesinie.\n\nJubileusz 50 lat pożycia małżeńskiego świętowało dzisiaj 18 par. Otrzymały medale od prezydenta Polski oraz pamiątkę od gminy.\n\n– Życzę wielu wspaniałych i radosnych dni spędzonych razem – powiedział Mariusz Zaborowski.', 'Prawie 20 małżeństw z medalami od prezydenta Polski', '', 'inherit', 'closed', 'closed', '', '864-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 864, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=919', 0, 'revision', '', 0),
 (920, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '[caption id="" align="aligncenter" width="960"]<a href="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/22228400_1754776968157730_8416040562577880439_n.jpg?oh=a8e930487e8c086593c640cd40a2961c&amp;oe=5A6F7764"><img class="size-medium" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/22228400_1754776968157730_8416040562577880439_n.jpg?oh=a8e930487e8c086593c640cd40a2961c&amp;oe=5A6F7764" width="960" height="666" /></a> facebook.com/mgokslesin/[/caption]', 'Aerobik', '', 'inherit', 'closed', 'closed', '', '862-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 862, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=920', 0, 'revision', '', 0),
 (921, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '[caption id="" align="alignleft" width="335"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1756254308009996/1756250164677077/?type=3&amp;theater"><img class="" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/22366428_1756250164677077_7508906440037517416_n.jpg?oh=7ed0676703b7532f14a8075e94b49396&amp;oe=5A74D9B7" width="335" height="251" /></a> facebook.com/mgokslesin/[/caption]\n\n<strong>11 października 2017r. w Miejsko-Gminnym Ośrodku Kultury w Ślesinie odbyły się Drużynowe Mistrzostwa Powiatu Konińskiego w Szachach. W tym roku w związku z reformą oświaty Mistrzostwa rozegrane zostały w trzech grupach wiekowych: Powiatowe Igrzyska Dzieci była to grupa dzieci szkół podstawowych klas I-VI, Igrzyska Młodzieży Szkolnej Powiatu Konińskiego była to grupa młodzieży szkoły podstawowej klasy VII oraz II i III klasa</strong><span class="text_exposed_show"><strong>gimnazjum, ostatnia grupa to szkoły ponadgimnazjalne.</strong> </span>\n\n<!--more-->\n\n<span class="text_exposed_show">W Powiatowych Igrzyskach Dzieci grało 9 drużyn szkół podstawowych, w Igrzyska Młodzieży Szkolnej Powiatu Konińskiego grało 6 drużyn i 1 ponadgimnazjalna. Podzielone grupy grały systemem kołowym każdy z każdym, natomiast zawodnicy ze szkoły ponadgimnazjalnej nie mając w swojej grupie rywali zagrali w grupie Młodzieży Szkolnej. W mistrzostwach szkoły walczyły o miejsca pucharowe oraz co ważniejsze o awans do Mistrzostw Wojewódzkich, taki awans uzyskały dwie najlepsze drużyny w każdej grupie.</span>\n<div class="text_exposed_show">\n\nZ naszej gminy aż trzy drużyny uzyskały taki awans – drużyna z Zespołu Szkolno-Przedszkolnego w Ślesinie w składzie: Michał Pawlak, Kacper Szaszkowski, Damian Kołodziejczak, Kinga Stelmachowicz i Ada Chojnacka, drużyna ze Szkoły Podstawowej w Szyszyńskich Holendrach w składzie: Adam Głąbiak, Aleksandra Głąbiak, Alan Ciepliński, Denis Kostański i Paulina Andrzejewska oraz drużyna z Gimnazjum w Ślesinie w składzie: Bartosz Sajniak, Nikola Majdecka, Dominik Długołencki, Natalia Łapot, Julia Kowalska i Weronika Stolarska.\n\nWarto też nadmienić bardzo dobry występ drugiej drużyny ze Szkoły Podstawowej w Szyszyńskich Holendrach która, grając najmłodszym składem w swojej grupie wywalczyła trzecie miejsce.\n\nGratulujemy i życzymy udanego występu na Mistrzostwach Wojewódzkich.\n\nWyniki Powiatowe Igrzyska Dzieci:\n<a href="https://l.facebook.com/l.php?u=http%3A%2F%2Fwww.chessarbiter.com%2Fturnieje%2F2017%2Ftdr_6270%2Fresults.html%3Fl%3Dpl%26tb%3D202_&amp;h=ATOlFt68eTusQEw9xPmBtBjBd6EiKq6OfBuRxGJOo-sqU34VVJDtDOz8joFjtiGahYA8GqnUiwsgh1DfnW3FOf__51av_sJXymjr0sQgj59lGfuZ0l49V6nnDqH45iDTe4p5i0Tq-dQX2Rma0VHkQvG7TR1a8aOk3Xl_7vaVM53VrXclHycSprZAAcTkZO7qGpa_VjPXC75WHECwNawUVUtwzbinBp3huN7KshAHyM1gDD0U7fg9mdcu71i7x18ialTb6q4b9HGlElhTi09NPVkSpf_4Tvjn" target="_blank" rel="noopener" data-ft="{&quot;tn&quot;:&quot;-U&quot;}" data-lynx-mode="async">http://www.chessarbiter.com/turnie…/…/tdr_6270/results.html…</a>\nWyniki Igrzyska Młodzieży Szkolnej Powiatu Konińskiego:\n<a href="http://www.chessarbiter.com/turnieje/2017/tdr_6269/results.html?l=pl&amp;tb=202_" target="_blank" rel="noopener" data-ft="{&quot;tn&quot;:&quot;-U&quot;}" data-lynx-mode="async" data-lynx-uri="https://l.facebook.com/l.php?u=http%3A%2F%2Fwww.chessarbiter.com%2Fturnieje%2F2017%2Ftdr_6269%2Fresults.html%3Fl%3Dpl%26tb%3D202_&amp;h=ATMsg8rygtubjmfbdKmhAnek01ARL2dp3rdd-2Xtgh7WHYTm_ZNtYqwVXwtTvUI9Bu2glqL-tJ0yZ-Be0gNgGrdlyHJhHs9G1JWaOQ89L_XM6tr6Ehk0WqBiwPODF_rETE7qmXxF0K3I5bbZccqLfA0QfZv2hGPIFxENv2GJ9fNaLejT3ZhORSYuVUvN8uX5yC47uci84K_jb88S67uHt9LTNn--zCqoUTKzQ17R7CO62EfQuJ7YXZq4BdWXIogWiqnQHM_nIdXX3_uX-VgRVHCxfnVrNO92">http://www.chessarbiter.com/turnie…/…/tdr_6269/results.html…</a>\n\n</div>', 'Drużynowe Mistrzostwa Powiatu Konińskiego w Szachach', '', 'inherit', 'closed', 'closed', '', '860-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 860, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=921', 0, 'revision', '', 0),
 (922, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '[caption id="" align="aligncenter" width="698"]<img class="size-medium" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/22228634_1753765888258838_6798066895799644059_n.jpg?oh=63fdd24c6cde8829e5ea9932aa3f663b&amp;oe=5A77C0FC" width="698" height="960" /> facebook.com/mgokslesin/[/caption]', 'Wystawa prac artystów gminy Ślesin', '', 'inherit', 'closed', 'closed', '', '854-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 854, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=922', 0, 'revision', '', 0),
 (923, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '[caption id="" align="alignleft" width="191"]<a href="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/22196074_156545428275296_674278597870968465_n.jpg?oh=717462dd7f2615147355a7a9eb437c71&amp;oe=5A8721A3"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/22196074_156545428275296_674278597870968465_n.jpg?oh=717462dd7f2615147355a7a9eb437c71&amp;oe=5A8721A3" width="191" height="340" /></a> facebook.com/lksslesin/[/caption]\n\n<strong>Wielkimi krokami zbliża się 8. kolejka ligowa seniorskiej grupy LKS-u Ślesin. </strong>\nTym razem podopieczni Macieja Bieniaszczyka podejmować będą na wyjeżdzie zespół ZKS<span class="text_exposed_show"> Zagórów.\nSpotkanie rozegrane będzie w niedziele o godzinie 15 . Przedłużenie zwycięskiej passy to Nasz jedyny cel po tym meczu.\nSerdecznie zapraszamy wszystkich kibiców do wsparcia!</span>', 'LKS zagra w VIII rundzie z ZKS Zagórów', '', 'inherit', 'closed', 'closed', '', '846-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 846, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=923', 0, 'revision', '', 0),
 (924, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '[caption id="" align="alignleft" width="314"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1754381354863958/1754380108197416/?type=3&amp;theater"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/22281797_1754380108197416_6121342935828417465_n.jpg?oh=8f9fa56838e78265b6da730fdf5989a2&amp;oe=5A8817F4" width="314" height="236" /></a> facebook.com/mgokslesin[/caption]\n\n<strong>4 października w Miejsko-Gminnym Ośrodku Kultury w Ślesinie odbyły się Drużynowe Mistrzostwa Szkół Gminy Ślesin w Szachy. W turnieju uczestniczyło 7 drużyn ze Szkół Podstawowych Gminy Ślesin. Turniej rozegrany został systemem kołowym na dystansie 7 rund tempem 10 minut na zawodnika. Na zakończenie turnieju najlepsze drużyny otrzymały puchary i dyplomy.</strong>\n\n<!--more-->\n\nWyniki końcowe:<span class="text_exposed_show">\n1 miejsce drużyna SP Ślesin I w składzie:\nMichał Pawlak, Kacper Szaszkowski, Aleksandra Zawieruszyńska, Julia Kowalska</span>\n<div class="text_exposed_show">\n\n2 miejsce drużyna SP Szyszyńskie Holendry I w składzie:\nAdam Głąbiak, Inga Turowska, Daniel Lisowski, Paulina Andrzejewska\n\n3 miejsce drużyna SP Ślesin II w składzie:\nAleksandra Nussynblat, Damian Kołodziejczak, Kinga Stelmachowicz, Ada Chojnacka\n\nKolejne miejsce to:\nSP Ostrowąż\nSP Ślesin III\nSP Szyszyńskie Holendry II\nSP Szyszyńskie Holendry III\n\n</div>', 'Drużynowe Mistrzostwa Szkół Gminy Ślesin', '', 'inherit', 'closed', 'closed', '', '847-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 847, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=924', 0, 'revision', '', 0),
 (925, 1, '2017-10-23 15:40:44', '2017-10-23 15:40:44', '[caption id="" align="alignleft" width="298"]<a href="https://www.lm.pl/aktualnosci/informacja/111743/dzien_kukurydzy_w_firmie_szmidt_dla_rolnikow_i_producentow"><img class="size-medium" src="https://m.lm.pl/media/foto/295936_2844_298.jpg" width="298" height="167" /></a> LM.pl[/caption]\n\n<strong>W gospodarstwie rolnym Jana Szmidta w Biskupiu, w gminie Ślesin, odbył się Dzień Kukurydzy.</strong>\n\n<!--more-->\n\n<img class="size-full wp-image-503 alignright" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/240915_logo_standard.png" alt="" width="175" height="70" />Firma Szmidt z Biskupia zajmuje się skupem zbóż oraz zaopatrywaniem rolników w niezbędne środki do produkcji rolnej. Współpracuje z okolicznymi gospodarstwami w regionie wschodniej Wielkopolski oraz południowej części Kujaw. Funkcjonuje nieprzerwanie od 1992 roku i cały czas się rozwija, dostosowując ofertę do zmiennych się potrzeb rynku.\n\nCo roku Firma Szmidt z Buskupia organizuje dzień kukurydzy. W tegorocznym uczestniczyło ponad 100 osób. Rolników i producentów nie wystraszył nawet deszcz. - <em>Celem takiego spotkania jest porównanie odmian, które sprzedajemy lub chcemy sprzedawać. Po to, by rolnicy uzyskiwali jak najwyższe plony</em> – poinformował Mariusz Kaliszewski, menadżer ds. skupu i kontraktacji zbóż w Firmie Szmidt.\n\nFirma Szmidt jest w posiadaniu suszarni do kukurydzy o przerobie ok. 400 do 500 ton na dobę. -<em>Obecnie trwa przebudowa suszarni więc jej wydajność wzrośnie do ok. 1000 ton na dobę, w sezonie do 100.000 ton – powiedział Mariusz Kaliszewski. - Tej kukurydzy nam potrzeba. Podczas dnia kukurydzy pokazujemy nowe, lepsze odmiany, nowe technologie, nowe maszyny po to, by rolnicy uzyskiwali lepsze plony. Uprawiali coraz więcej. A ponieważ najlepszymi ekspertami od uprawy kukurydzy są firmy produkujące nasiona, chemię, maszyny, więc zaprosiliśmy ekspertów z poszczególnych firm, aby jako specjaliści omówili odmiany, technologie ochrony roślin oraz sprzęt. Mamy dostawców kukurydzy w promieniu 100 km od Konina, a więc z kujawsko - pomorskiego, mazowieckiego, ale także spod Opola, rolnicy wożą nam kukurydzę.</em>\n\nBo, jak mówią organizatorzy, bezpośredni kontakt producentów środków do produkcji rolnej z rolnikami jest najlepszy. I o to chodzi podczas corocznego dnia kukurydzy.', 'Dzień kukurydzy w Firmie Szmidt', '', 'inherit', 'closed', 'closed', '', '858-revision-v1', '', '', '2017-10-23 15:40:44', '2017-10-23 15:40:44', '', 858, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=925', 0, 'revision', '', 0),
 (926, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '<div><img class="alignleft size-medium" src="http://www.slesin.naszabiblioteka.com/img/upload/images/108083479d3fcc16eb5634291f3ffcb1.jpg" width="116" height="116" /><strong>Biblioteka Publiczna Miasta i Gminy Ślesin jest obecnie w trakcie realizacji Programu Biblio</strong>\n\n<strong>teki Narodowej „Zakup nowości wydawniczych do bibliotek”. Dofinansowanie w roku bieżącym wyniosło  11,182 zł. Czas realizacji programu obejmuje okres do końca listopada.</strong>\n\nZapraszamy wszystkich do Biblioteki oraz do zapoznania się z zakupionymi nowościami na naszej stronie internetowej.\n\n<em>"Zrealizowano ze środków finansowych Ministerstwa Kultury i Dziedzictwa Narodowego w  ramach Narodowego Programu Rozwoju Czytelnictwa".</em>\n\n</div>\n&nbsp;', 'Zakup nowości wydawniczych 2017', '', 'inherit', 'closed', 'closed', '', '856-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 856, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=926', 0, 'revision', '', 0),
 (927, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '[caption id="" align="alignleft" width="257"]<a href="http://gloskoninski.pl/pechowy-poczatek-tygodnia-dwa-wypadki-w-poniedzialkowy-poranek/"><img class="" src="http://gloskoninski.pl/wp-content/uploads/2017/10/Pechowy-pocz%C4%85tek-tygodnia.-Dwa-wypadki-w-poniedzia%C5%82kowy-poranek-1.jpg" width="257" height="171" /></a> http://gloskoninski.pl/[/caption]\n\n<strong>Do groźnego Wypadku doszło wczoraj rano w Szyszyńskich Holendrach, jedna osoba została ranna i trafiła do szpitala. Kilka godzin później w Mikorzynie doszło do kolejnego wypadku na skutek nieuwagi i wyprzedzania. Kolejna osoba ranna w szpitalu. <a href="http://gloskoninski.pl/pechowy-poczatek-tygodnia-dwa-wypadki-w-poniedzialkowy-poranek/">Zdjęcia.</a></strong>\n\n<!--more-->\n\nOkoło 6:40 rano w miejscowości  na drodze DK20 w kierunku na Bydgoszcz doszło do zderzenia dwóch pojazdów:ciężarówki i samochodu osobowego.\nKierujący Vw Golf 24 letni mężczyzna nieustąpił pierwszeństwa przejazdu na skrzyżowaniu i doprowadził do zderzenia z samochodem ciężarowym Volwo, którym kierował 39 letni mieszkaniec woj. opolskiego. Na skutek zderzenia pasażer Golfa doznał złamania nogi i trafił do szpitala. Obaj kierujący byli trzeźwi.\n24 letni kierowca VW Golfa ma zatrzymane prawo jazdy i odpowie za spowodowanie wypadku. Sprawą zajmą się dochodzeniowcy z Komisariatu Policji w Ślesinie.\n\n<img class="size-medium alignright" src="http://gloskoninski.pl/wp-content/uploads/2017/09/glos-koninski-logo-MEDIUM-1.bmp" width="193" height="87" />Niecałe 3 godziny później w Mikorzynie doszło do kolejnego wypadku, w którym udział wzięły Mercedes kierowany przez 29 letniego mieszkańca pow. konińskiego oraz Renault Master kierowany przez 28 letniego mieszkanca Kalisza.\nDo zdarzenia doszło na prostym odcinku drogi. Kierujący Renault Master nie ustąpił pierwsdzeństwa prawidłowo wyprzedzającemu jadącemu w tym samym kierunku kierowcy Mercedesa i uderzył go w bok co spowodowało zjazd na lewe pobocze i uderzenie Mercedesa w drzewo.\n\nKierujący Mercedesem na skutek zdarzenia doznał złamania nogi i trafił do szpitala, jego życiu nie zagraża niebezpieczeństwo. Kierujący byli trzeźwi.\nSprawą zajmą się dochodzeniwowcy ze Ślesina. W chwili obecnej trwają niezbędne ustalenia zmierzjące do ustalenia przebiegu całego zdarzenia i ustalenia wszsytkich faktów.', 'Dwa wypadki w poniedziałkowy poranek', '', 'inherit', 'closed', 'closed', '', '841-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 841, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=927', 0, 'revision', '', 0),
 (928, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '[caption id="" align="alignleft" width="155"]<img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/984020_1366146003447326_7529024879014245934_n.png?oh=1ca89f0ff19d38b9bc6f8ea26dfe19da&amp;oe=5A4DD170" width="155" height="155" /> facebook.com/kalejdoskopwielkopolski/[/caption]\n\n<strong>W Ślesinie na tamtejszym rynku po raz czwarty odbył się Jarmark Ochweśnicki. Na straganach pojawiły się lokalne przysmaki, wyroby rękodzieła, oraz sztuka ludowa. Zebranym czas umilały lokalne zespoły muzyczne.</strong>\n\n<!--more-->\n\n[embed]https://www.facebook.com/kalejdoskopwielkopolski/videos/1537337989661459/?hc_ref=ARTO4jiYqqOTv6x6aUImXJl_LEgcCbb4heO2T825YZPZhfqT2VvKFQFoRvTg-MyUgMc&fref=nf[/embed]\n\nZródło: Kalejdoskop Wielkopolski', 'Relacja z Jarmarku Ochweśnickiego', '', 'inherit', 'closed', 'closed', '', '837-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 837, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=928', 0, 'revision', '', 0),
 (929, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '[caption id="" align="alignleft" width="294"]<a href="https://www.facebook.com/lksslesin/photos/a.131120317484474.1073741829.123946521535187/155306635065842/?type=3&amp;theater"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t31.0-0/q91/p403x403/22051291_155306635065842_3524450602761349813_o.jpg?oh=502fbb9a997f56bac55031ce3f4cb4c2&amp;oe=5A4686AE" width="294" height="165" /></a> facebook.com/lksslesin/[/caption]\n\n<strong>Wciąż niepokonana jest seniorska ekipa LKS-u Ślesin.  Tym razem na własnym boisku nie pozostawili cienia wątpliwości kto jest lepszą drużyną pewnie pokonując Wiktorię ll Września 3:0.</strong>\n\n<!--more-->\n\nGole zdobywali:\nMarcin Marciszak\nRafał Czapski<span class="text_exposed_show">\nKamil Sobota</span>\n<div class="text_exposed_show">\n\nCieszy także fakt zachowania czystego konta, ale przede wszystkim dominacji przez całe spotkanie. Liczymy na więcej !\n\n</div>', 'LKS Ślesin wciąż niepokonany', '', 'inherit', 'closed', 'closed', '', '834-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 834, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=929', 0, 'revision', '', 0),
 (930, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '[caption id="" align="aligncenter" width="2472"]<a href="http://www.mgok.slesin.pl/asp/pliki/pliki_robocze/pyrczok_2017__1_.jpg"><img class="size-medium" src="http://www.mgok.slesin.pl/asp/pliki/pliki_robocze/pyrczok_2017__1_.jpg" width="2472" height="3392" /></a> facebook.com/gminaslesin/[/caption]', 'XV Święto Pyrczoka', '', 'inherit', 'closed', 'closed', '', '832-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 832, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=930', 0, 'revision', '', 0),
 (931, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '[caption id="" align="alignleft" width="261"]<a href="https://www.facebook.com/lksslesin/photos/a.131120317484474.1073741829.123946521535187/154486135147892/?type=3&amp;theater"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/22050006_154486135147892_5640058828229256407_n.jpg?oh=e9d2fa6273d1d1d09d82c5cf7f780428&amp;oe=5A39D13B" width="261" height="147" /></a> facebook.com/lksslesin/[/caption]\n\n<strong>Już w najbliższą sobotę o godzinie 16. odbędzie się 6 kolejka A-klasy 2 grupy w której LKS podejmować będzie Viktorię ll Wrześnie.</strong>\n\nKibice i wszyscy zainteresowani drużyną Skicioków liczą na ciekawe i pełne zaangażowania spotkanie w wykonaniu naszej drużyny. Mamy nadzieję pozostania na zwycięskim torze, zdobycia kompletu punktów i walki o czołówkę ligowej tabeli.\n\nZapraszamy wszystkich na stadion w Ślesinie i zachęcamy do kibicowania', 'Dziś mecz z Wrześnią', '', 'inherit', 'closed', 'closed', '', '830-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 830, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=931', 0, 'revision', '', 0),
 (932, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '[caption id="" align="alignleft" width="324"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1751993745102719/1751993165102777/?type=3&amp;theater"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t31.0-0/q81/p180x540/22136882_1751993165102777_8080209208265274684_o.jpg?oh=0f193ba2e9eb6ebab346ce67b5ff203b&amp;oe=5A823234" width="324" height="243" /></a> facebook.com/mgokslesin/[/caption]\n\n<strong>W dniach 22-24 września 2017, dwójka naszych najmłodszych szachistów Ada Chojnacka i Tymoteusz Łachacz po raz pierwszy próbowali swoich sił na Międzywojewódzkich Mistrzostwach Młodzików, które odbywały się w tym roku w Łazach.</strong>\n\nMistrzostwa rozgrywane zostały na dystansie siedmiu rund, tempem 30 minut dla zawodnika plus 30 sekund za wykonany ruch. Oboje nasi reprezentanci uzyskali wynik 3 punkty z siedmiu rund, co dało im miejsca w środku tabeli. W klasyfikacji końcowej Ada Chojnacka zajęła 14 miejsce wśród dziewczynek, a Tymoteusz Łachacz zajął 23 miejsce wśród chłopców.', 'Debiut najmłodszych szachistów na mistrzostwach międzywojewódzkich', '', 'inherit', 'closed', 'closed', '', '827-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 827, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=932', 0, 'revision', '', 0),
 (933, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '[caption id="" align="aligncenter" width="668"]<a href="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/22008001_1751796118455815_3937849308996864705_n.jpg?oh=9adb00dc93a6c64bcecfa5ee9dc03a00&amp;oe=5A41F9DE"><img class="size-medium" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/22008001_1751796118455815_3937849308996864705_n.jpg?oh=9adb00dc93a6c64bcecfa5ee9dc03a00&amp;oe=5A41F9DE" width="668" height="960" /></a> facebook.com/mgokslesin/[/caption]', 'Nakręcona gmina', '', 'inherit', 'closed', 'closed', '', '825-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 825, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=933', 0, 'revision', '', 0),
 (934, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '[caption id="" align="aligncenter" width="2458"]<a href="http://www.mgok.slesin.pl/asp/pliki/pliki_robocze/spektakl-_lichen.jpg"><img class="size-medium" src="http://www.mgok.slesin.pl/asp/pliki/pliki_robocze/spektakl-_lichen.jpg" width="2458" height="3492" /></a> mgok.slesin.pl[/caption]', 'Spektakl o Objawieniach Licheńskich i Historii Lichenia', '', 'inherit', 'closed', 'closed', '', '823-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 823, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=934', 0, 'revision', '', 0),
 (935, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '<div class="text_full" align="justify">\n\n[caption id="" align="alignleft" width="325"]<a href="http://www.przegladkoninski.pl/data/catalogue/StLS05MzE4OS0zMTgtMTg2MzI0LmpwZw==.jpg"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StLS05MzE4OS0zMTgtMTg2MzI0LmpwZw==.jpg" width="325" height="217" /></a> przegladkoninski.pl[/caption]\n\n<strong>35-letni mieszkaniec powiatu konińskiego, kierujący volkswagenem vento, nie zatrzymał się do policyjnej kontroli i podjął próbę ucieczki. Jak się okazało – miał do tego powody. Był kompletnie pijany. W wydychanym powietrzu miał aż 2,5 promila alkoholu.</strong>\n\n<!--more-->\n\n<img class="size-medium wp-image-522 alignright" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="300" height="78" />W niedzielę, po godzinie 15.00, funkcjonariusze z Komisariatu Policji w Ślesinie zauważyli volkswagena vento, którego kierujący wydał się funkcjonariuszom „podejrzany”. Postanowili go zatrzymać.\n\n– Kierowca nie zwracał uwagi na wydawane znaki i sygnały świetlne oraz dźwiękowe – informuje Zbigniew Janusz, rzecznik prasowy Komendy Miejskiej Policji w Koninie. – Dodatkowo utrudniał zatrzymanie zajeżdżając drogę policyjnemu radiowozowi. Kierujący uciekał tak przez Galiszewo, Łuszczewo, Mielnicę i Goplanę. Został zatrzymany, kiedy wjechał na teren własnej posesji.\n\nUciekinierem okazał się 35-mężczyzna, który w wydmuchiwanym powietrzu miał ponad 2,5 promila alkoholu. Policjanci zatrzymali mężczyźnie prawo jazdy i osadzili w policyjnym areszcie.\n\n– Jeszcze dzisiaj usłyszy zarzuty z art. 178a kk oraz 178 bkk, czyli za jazdę pod wpływem alkoholu ora za niezatrzymanie się do kontroli drogowej na żądanie funkcjonariuszy policji – dodaje rzecznik. – Za swoją brawurową jazdę odpowie przed sądem.\n\n</div>\n&nbsp;\n<div class="clearfix"></div>\n<div class="clearfix"></div>', 'Pijany kierowca uciekał policji', '', 'inherit', 'closed', 'closed', '', '821-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 821, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=935', 0, 'revision', '', 0),
 (936, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '<p style="text-align: center;"><strong><img class="alignleft wp-image-555" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/IMG_1837-300x198.jpg" alt="" width="300" height="198" />OBWIESZCZENIE </strong><strong>BURMISTRZA  MIASTA I GMINY ŚLESIN\n</strong><strong>Z  26 WRZEŚNIA  2017 ROKU</strong></p>\n<strong>Informuję, że <u>  29 września  (piątek) 2017  roku  o godz. 10.00  w  sali posiedzeń Urzędu Miasta i Gminy  w Ślesinie odbędzie  się  XXXIII  sesja Rady Miejskiej Gminy Ślesin</u>.</strong>\n\n<!--more-->\n\n&nbsp;\n<div>Burmistrz Miasta i Gminy\n/-/ <em>Mariusz Zaborowski  </em></div>\nNa podstawie art. 20 ust. 1 ustawy z dnia 08 marca 1990 roku o samorządzie gminnym /Dz. U. z 2016 r., poz.446 ze zm./  z w o ł u j ę  <strong><u>XXXIII sesję Rady Miejskiej Gminy Ślesin  na </u></strong> <strong><u>29 wrzesień ( piątek  )  2017 roku na godz. 10.00 w  sali posiedzeń Urzędu Miasta i Gminy w Ślesinie</u></strong>  z następującym porządkiem obrad:\n<ol>\n 	<li>Otwarcie sesji i stwierdzenie quorum.</li>\n 	<li>Przyjęcie  porządku obrad.</li>\n 	<li>Przyjęcie protokołu z XXXII sesji Rady Miejskiej Gminy Ślesin.</li>\n 	<li>Interpelacje i zapytania radnych .</li>\n 	<li>Podjęcie uchwał w sprawach:</li>\n</ol>\n1)      zmian budżetu,\n2)      o zmianie uchwały w sprawie uchwalenia Wieloletniej Prognozy Finansowej Miasta i Gminy Ślesin na lata 2017 – 2036,\n3)      wyrażenia zgody na nieodpłatne nabycie nieruchomości położonej w obrębie Żółwieniec,\n4)      wyrażenia zgody na nieodpłatne nabycie nieruchomości położonej w obrębie Różopole,\n5)      ustanowienia służebności przesyłu na nieruchomości położonej w Ślesinie.\n<ol>\n 	<li value="6">Wolne wnioski.</li>\n 	<li>Zakończenie obrad.</li>\n</ol>\n&nbsp;\n<div>Przewodniczący Rady\n/-/ Stanisław Chrzanowski</div>', 'XXXIII  sesja Rady Miejskiej Gminy Ślesin', '', 'inherit', 'closed', 'closed', '', '817-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 817, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=936', 0, 'revision', '', 0),
 (937, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '[caption id="" align="alignleft" width="294"]<a href="http://umig.slesin.pl/userfiles/images/moge-wiecej(2).jpg"><img class="" src="http://umig.slesin.pl/userfiles/images/moge-wiecej(2).jpg" width="294" height="416" /></a> http://umig.slesin.pl[/caption]\n\n<strong>Od września do listopada 2017 Fundacja na Rzecz Rozwoju Dzieci i Młodzieży w Koninie wraz z partnerami: Powiatowym Centrum Pomocy Rodzinie w Koninie, Gminnym Ośrodkiem Pomocy Społecznej w Lądku oraz Gminami: Sompolno, Stare Miasto i Ślesin realizuje projekt „Mogę więcej!” – edycja V skierowany do osób z niepełnosprawnością z powiatów:  konińskiego, kolskiego, tureckiego i słupeckiego oraz miasta Konina.</strong>\n\n<!--more-->\n\nW jego ramach projektu odbywać się będą różne formy rehabilitacji:\n·         alternatywne metody komunikowania się\n·         terapia logopedyczna\n·         fizjoterapia,\n·         terapia taktylna\n·         integracja sensoryczna\n·         hipoterapia\n·         terapia pedagogiczna\n·         terapia psychologiczna\n·         koncerty relaksacyjne\n·         „spotkanie z alpakami”\n\nProjekt współfinansowany jest ze środków PFRON będących w dyspozycji Samorządu Województwa Wielkopolskiego', 'Mogę więcej!', '', 'inherit', 'closed', 'closed', '', '815-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 815, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=937', 0, 'revision', '', 0),
 (938, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '<strong> </strong>\n\n<img class="alignleft size-medium wp-image-555" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/IMG_1837-300x198.jpg" alt="" width="300" height="198" />\n\n<strong>Informuję, że w związku z toczącym się opracowaniem Programu Rewitalizacji dla Gminy Ślesin w dniu 26.09.2017 roku o godzinie 14:00 odbędą się konsultacje dot. w/w programu.</strong> Spotkanie odbędzie się na Sali konferencyjnej Urzędu Miasta i Gminy Ślesin.\n<div>Burmistrz Miasta i Gminy\n<em>Mariusz Zaborowski</em></div>\n<div></div>\n<div>Źródło: umig.slesin.pl</div>', 'Konsultacje dotyczące programu rewitalizacji gminy', '', 'inherit', 'closed', 'closed', '', '812-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 812, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=938', 0, 'revision', '', 0),
 (939, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '[caption id="" align="aligncenter" width="640"]<a href="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/21761801_153003178629521_6241682915575965195_n.jpg?oh=76b1c942cd6cd083c1ad66a491e6949a&amp;oe=5A5D9F4C"><img class="size-medium" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/21761801_153003178629521_6241682915575965195_n.jpg?oh=76b1c942cd6cd083c1ad66a491e6949a&amp;oe=5A5D9F4C" width="640" height="901" /></a> facebook.com/lksslesin/[/caption]', 'Nabór na treningi piłkarskie', '', 'inherit', 'closed', 'closed', '', '810-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 810, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=939', 0, 'revision', '', 0),
 (940, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '[caption id="" align="alignleft" width="277"]<img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/21762165_152823625314143_1559795001543357810_n.jpg?oh=90ed3bd3ca1657648a4cde6c79fae65b&amp;oe=5A4F6464" width="277" height="156" /> facebook.com/lksslesin/[/caption]\n\n<strong>Już w najbliższą sobotę rozegrana zostanie 5 kolejka A-klasy. Tym razem LKS Ślesin czeka wyjazd do Kramska i mecz z tamtejszą Wartą.</strong>\nSpotkanie rozegrane będzie o godzinie 16:00. Wszystkich chcących wesprzeć nasz klub zapraszamy do wyjazdu i kibicowania.', 'LKS jedzie na mecz do Kramska', '', 'inherit', 'closed', 'closed', '', '808-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 808, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=940', 0, 'revision', '', 0),
 (941, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '[caption id="" align="alignleft" width="338"]<a href="http://www.przegladkoninski.pl/PL-H5/3/4796/rajd-rowerowy-wokol-jeziora-slesinskiego-uczestnikow-nie-zniechecila-pogoda.html"><img class="" src="http://www.przegladkoninski.pl/data/catalogue/StLS04OTI0NjQtRFNDMDM1NzYuSlBH.jpg" width="338" height="190" /></a> przegladkoninski.pl[/caption]\n\n<strong>Na pewno pogoda nie nastrajała w minioną sobotę do eskapad jednośladami. Nie odstraszyło to jednak uczestników szóstego Raju Rowerowego wokół jeziora Ślesińskiego. Wśród nich pojawił się Tomasz Nowak, poseł PO, który to wydarzenie objął swoim patronatem. <a href="http://www.przegladkoninski.pl/PL-H5/3/4796/rajd-rowerowy-wokol-jeziora-slesinskiego-uczestnikow-nie-zniechecila-pogoda.html">Zdjęcia.</a></strong>\n\n<!--more-->\n\n– Jak jechałem z Konina to cały czas tylko lało i lało. Dzisiaj rano usuwałem jeszcze w swoim ogrodzie skutki nawałnicy. Mam nadzieję, że teraz żadna nawałnica nas nie spotka, tylko dobry humor – powiedział poseł Nowak tuż przed startem.\n\n<img class="size-medium wp-image-522 alignright" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="300" height="78" />Rajd wyruszył z Przystani Wodnej w Ślesinie. W tym roku uczestników było mniej niż w poprzednich latach. Wcześniej w imprezie uczestniczyło nawet około 100 osób. Jak mówił organizator, czyli Marek Ejma, ślesiński radny, na pewno ważna jest pogoda. Poprzednie edycje odbywały się w wakacje.\n\nTrasa rajdu to około 15 kilometrów.\n– Jedziemy wokół jeziora. Chodzi o to, żeby integrować społeczność i promować zdrowy tryb życia. Chcemy też pokazać wszystkim fajne miejsca, plaże – mówi Marek Ejma.\n\nNa finał zaplanowano ognisko i wspólne pieczenie kiełbasek.\n\nTekst: Marcin Szafrański', 'Rajd rowerowy wokół jeziora Ślesińskiego', '', 'inherit', 'closed', 'closed', '', '802-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 802, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=941', 0, 'revision', '', 0),
 (942, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '[caption id="" align="alignleft" width="335"]<a href="http://umig.slesin.pl/userfiles/images/pamietaj.png"><img class="" src="http://umig.slesin.pl/userfiles/images/pamietaj.png" width="335" height="235" /></a> http://umig.slesin.pl[/caption]\n\n<strong>Zbliża się jesień i zima, a to oznacza, że trzeba będzie zacząć ogrzewać mieszkania. Przed rozpoczęciem sezonu grzewczego należy starannie zadbać o właściwy stan przewodów kominowych i urządzeń grzewczych.</strong>\n\n<!--more-->\nPrezes Krajowej Izby Kominiarzy wydał komunikat do właścicieli i zarządców budynków w związku z rozpoczęciem sezonu ogrzewczego.\n\n<a title="https://izbakominiarzy.pl/wp-content/uploads/2016/06/Komunikat-Prezesa-Krajowej-Izby-Kominiarzy-2017.pdf" href="https://izbakominiarzy.pl/wp-content/uploads/2016/06/Komunikat-Prezesa-Krajowej-Izby-Kominiarzy-2017.pdf" target="_blank" rel="noopener">https://izbakominiarzy.pl/wp-content/uploads/2016/06/Komunikat-Prezesa-Krajowej-Izby-Kominiarzy-2017.pdf</a>', 'Zadbaj o bezpieczeństwo', '', 'inherit', 'closed', 'closed', '', '800-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 800, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=942', 0, 'revision', '', 0),
 (943, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '[caption id="" align="aligncenter" width="684"]<a href="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/21743392_1748983282070432_8699405484316105951_n.jpg?oh=a153edd67ff28e571ef87a5d3e3b2242&amp;oe=5A5A5DDE"><img class="size-medium" src="https://scontent-bru2-1.xx.fbcdn.net/v/t1.0-9/21743392_1748983282070432_8699405484316105951_n.jpg?oh=a153edd67ff28e571ef87a5d3e3b2242&amp;oe=5A5A5DDE" width="684" height="960" /></a> facebook.com/mgokslesin/[/caption]', 'XI Rajd Rowerowy "Bursztynowym szlakiem"', '', 'inherit', 'closed', 'closed', '', '634-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 634, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=943', 0, 'revision', '', 0),
 (944, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '[caption id="" align="alignleft" width="220"]<a href="https://www.lm.pl/aktualnosci/informacja/111445/narazil_pasazerow_sternik_katamaranu_byl_po_spozyciu_alkoholu"><img class="" src="https://m.lm.pl/media/foto/293543_6666_350.jpg" width="220" height="165" /></a> OSP Licheń Stary[/caption]\n\n<strong>Pół promila alkoholu w wydychanym powietrzu miał sternik katamaranu, który przechylił się na jeziorze Licheńskim.</strong>\n\n<!--more-->\n\n<img class="size-full wp-image-503 alignright" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/240915_logo_standard.png" alt="" width="175" height="70" />Do niebezpiecznej sytuacji doszło przedwczoraj w Licheniu. Katamaranem na jezioro wypłynęła grupa ponad 20 osób. Nagle jednostka się przechyliła, a pasażerowie mieli wpaść do wody. Kiedy na miejscu pojawili się wezwani z Konina strażacy, wszyscy uczestnicy pechowej wycieczki byli już w hotelu. Na szczęście nikomu nic się nie stało, ale jak informuje Zbigniew Janusz z konińskiej policji, 48-letni sternik katamaranu był po spożyciu alkoholu. Miał blisko pół promila alkoholu w wydychanym powietrzu. Dodatkowo nie miał uprawnień do sterowania tego typu łodzią.\n\nMężczyźnie za narażenie na bezpośrednie niebezpieczeństwo utraty życia lub ciężkiego uszczerbku na zdrowiu grozi nawet do 3 lat więzienia.\n\n&nbsp;', 'Sternik katamaranu był po spożyciu alkoholu', '', 'inherit', 'closed', 'closed', '', '795-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 795, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=944', 0, 'revision', '', 0),
 (945, 1, '2017-10-23 15:47:46', '2017-10-23 15:47:46', '[caption id="" align="alignleft" width="242"]<a href="https://www.facebook.com/lksslesin/photos/a.131120317484474.1073741829.123946521535187/152039688725870/?type=3&amp;theater"><img class="" src="https://scontent-bru2-1.xx.fbcdn.net/v/l/t1.0-9/21743113_152039688725870_3513430359830549860_n.jpg?oh=076133752f833511cdc2c84a26ba98f7&amp;oe=5A4AD78C" width="242" height="203" /></a> facebook.com/lksslesin/[/caption]\n\n<strong>Wielki klasyk naszego regionu czeka na kibiców piłkarskiego klubu LKS Ślesin w środowe popołudnie. W ramach trzeciej rundy Pucharu Polski na szczeblu OZPN Konin ekipa Skicioków podejmować będzie Górnik Konin.</strong>\n\n<!--more-->\n\nZdecydowany faworyt tego meczu, a więc trzecioligowy Górnik będzie chciał zdominować to spotkanie i szybko awansować do kolejnej rundy.\n\nMy ze swojej strony liczymy na solidny mecz, walkę na każdym centymetrze boiska i sprawienie niespodzianki jaką byłoby wyeliminowanie przeciwnika.\n\nZapraszamy wszystkich chcących wesprzeć nasz zespół w środę o godzinie 17:00.', 'Mecz z Górnikiem Konin', '', 'inherit', 'closed', 'closed', '', '792-revision-v1', '', '', '2017-10-23 15:47:46', '2017-10-23 15:47:46', '', 792, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=945', 0, 'revision', '', 0),
 (946, 1, '2017-10-23 15:48:03', '2017-10-23 15:48:03', '[caption id="" align="alignleft" width="272"]<a href="http://www.slesin.naszabiblioteka.com/news/przedpoudnie-z-sherlockiem-holmesem"><img class="" src="http://www.slesin.naszabiblioteka.com/img/upload/images/WP_20170912_11_35_32_Pro.jpg" width="272" height="153" /></a> slesin.naszabiblioteka.com[/caption]\n\n<strong>W ramach biblioterapii w Środowiskowym Domu Samopomocy pracownicy Biblioteki Publicznej Miasta i Gminy Ślesin zostali zaproszeni do udziału w zajęciach. Zostałyśmy przyjęte w niezwykle ciepły sposób za co serdecznie dziękujemy.</strong>\n\n<!--more-->\n\nWraz z podopiecznymi przy słodkim poczęstunku przeczytaliśmy fragmenty książki sir Artura Conana Doyl’a pt. : „Pies Baskervill’ów” oraz wysłuchaliśmy przejmujących wierszy autorstwa jednej z obecnych pań.\n\nPod koniec spotkania zostałyśmy oprowadzone po budynku oraz miałyśmy przyjemność podziwiać efekty pracy artystycznej osób uczęszczających na zajęcia. Następne wspólne czytanie za miesiąc. Do zobaczenia\n\nŹródło: Bilbioteka Publiczna w Ślesinie\n\nZobacz też zdjęcia z akcji Narodowego Czytania "Wesela" - <a href="http://www.slesin.naszabiblioteka.com/news/narodowe-czytanie-wesele">tutaj</a>', 'Przedpołudnie z Sherlockiem Holmesem', '', 'inherit', 'closed', 'closed', '', '790-revision-v1', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 790, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=946', 0, 'revision', '', 0),
 (947, 1, '2017-10-23 15:48:03', '2017-10-23 15:48:03', '<strong><img class="alignleft size-medium" src="https://s-pt.ppstatic.pl/g/logo_naglowek/gloswielkopolski.svg?14633760" width="185" height="51" />Zapraszamy do głosowania w konkursie MISTRZOWIE AGRO w kategoriach: rolnik roku, gospodyni roku, gospodarstwo agroturystyczne roku, KGW roku. Głosowanie potrwa do dnia 6 października 2017 r. do godz. 21:59:59.</strong>\n\nWśród kandydatów na rolnika roku 2017 kandyduje Michał Śliwiński, Kijowiec, a na najsypatyczniejszą gospodynię Wielkopolski - Magdalena Śliwinska, Kijowiec oraz Wanda Waleriańczyk, Piotrkowice.\n\nWięcej szczegółów <a href="http://www.gloswielkopolski.pl/nasze-akcje/mistrzowie-agro/a/mistrzowie-agro-powiat-koninski-aktualne-wyniki,12482475/">tutaj</a>', 'Mistrzowie AGRO', '', 'inherit', 'closed', 'closed', '', '788-revision-v1', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 788, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=947', 0, 'revision', '', 0),
 (948, 1, '2017-10-23 15:48:03', '2017-10-23 15:48:03', '[caption id="" align="alignleft" width="298"]<a href="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/21728367_1295485087246215_8586672356510958578_n.jpg?oh=40cf4c48d3e4313f61efb85b8a1e8dac&amp;oe=5A56D9F4"><img class="" src="https://scontent-waw1-1.xx.fbcdn.net/v/t1.0-9/21728367_1295485087246215_8586672356510958578_n.jpg?oh=40cf4c48d3e4313f61efb85b8a1e8dac&amp;oe=5A56D9F4" width="298" height="421" /></a> facebook.com/gminaslesin/[/caption]\n\nZapraszamy 18 września 2017 w godzinach od 14:00 - 20:00.\nBilety do nabycia na miejscu.', 'Kino 7D zagości na rynku w Ślesinie', '', 'inherit', 'closed', 'closed', '', '784-revision-v1', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 784, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=948', 0, 'revision', '', 0),
 (949, 1, '2017-10-23 15:48:03', '2017-10-23 15:48:03', '[caption id="" align="alignleft" width="208"]<a href="http://www.caoh.cz/img/blog/img13908358635200.jpg"><img class="" src="http://www.caoh.cz/img/blog/img13908358635200.jpg" width="208" height="131" /></a> umig.slesin.pl[/caption]\n\n<strong>W ramach zbiórki odpadów wielkogabarytowych za miesiąc zbierane będą: stoły, szafy, krzesła, sofy, dywany, wózki dziecięce, materace, pierzyny, rowery, zabawki dużych rozmiarów, telewizory, monitory, pralki, radia, drukarki, odkurzacze, lodówki i inne urządzenia elektryczne i elektroniczne (sprzęt RTV i AGD powinien być kompletny). </strong> <a href="http://umig.slesin.pl/userfiles/files/wywoz2017.pdf">Pobierz harmonogram.</a>\n<!--more-->\n\nOdpady należy wystawić bezpośrednio przed swoje posesje tak, aby nie utrudniały ruchu pojazdów i pieszych, najpóźniej do godziny 7.00 w dniu zbiórki.', 'Wywóz odpadów wielkogabarytowych i sprzętu elektrycznego', '', 'inherit', 'closed', 'closed', '', '780-revision-v1', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 780, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=949', 0, 'revision', '', 0),
 (950, 1, '2017-10-23 15:48:03', '2017-10-23 15:48:03', '[caption id="" align="alignleft" width="298"]<a href="https://www.lm.pl/aktualnosci/informacja/111392/slesin_nie_udalo_sie_pozyskac_funduszy_mieszkancy_zawiedzeni"><img class="size-medium" src="https://m.lm.pl/media/foto/292961_8322_298.jpg" width="298" height="198" /></a> LM.pl[/caption]\n\n<strong>Ponad 350 mieszkańców gminy Ślesin może odebrać darmową dokumentację techniczną instalacji fotowoltaicznej w swych domach.</strong>\n\n<!--more-->\n\nJednak atmosfera, która towarzyszy tej możliwości, daleka jest od radosnej. Dokumentacja jest pozostałością po wniosku, jaki przygotowywała gmina wraz z firmą Nuvarro. Dotyczył on dofinansowania ogniw fotowoltaicznych. Niestety, w efekcie tych prac burmistrz Mariusz Zaborowski przepraszał mieszkańców gminy.\n\n<img class="size-full wp-image-503 alignright" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/240915_logo_standard.png" alt="" width="175" height="70" />-<em> Przepraszałem, bo narobiłem mieszkańcom i sobie nadziei, że uda się w gminie pobudować u prywatnych osób ogniwa fotowoltaiczne. Niewiele gmin podjęło ryzyko, aby robić to również u mieszkańców, a nie tylko na budynkach użyteczności publicznej. Ryzyko było dość duże, bo możliwości pozyskania funduszy były niewielkie i mówiłem to na początku mieszkańcom - </em>tłumaczył burmistrz podczas spotkania z mieszkańcami.\n\nZ jakiego powodu nie udało się uzyskać funduszy? Przyczyna była dość błaha. Aby w ogóle można było starać się o dofinansowanie, należało przygotować dokumentacje techniczną poszczególnych domostw. W grę wchodziło ponad 350 obiektów, dla których trzeba było przygotować wszystkie niezbędne dane i wyliczenia. Pomimo ogromu włożonej w projekt pracy, wniosku nie udało się złożyć. Firma, która była podwykonawcą zleceniobiorcy nie dopilnowała terminów. Z tego powodu mieszkańcy otrzymają przygotowaną dokumentację, jako pewien rodzaj zadośćuczynienia. Zwrócone zostaną im również pieniądze, które musieli wyłożyć z góry na wykonanie tej usługi. Mowa o kwocie około 300 zł dla każdej osoby. Firma będzie musiała również wypłacić gminie stosowne odszkodowanie.\n\n- <em>Wiele osób liczyło na to, że projekt się powiedzie. Każdy mówił o jednym – o ilości pracy włożonej przez moich pracowników, którzy robili to poza swoimi obowiązkami. Na pewno jednak mnie to nie zniechęci i będziemy próbować ponownie pozyskać takie dofinansowanie, jeżeli będzie taka możliwość</em> – deklarował Mariusz Zaborowski.\n\nJak na sprawę zapatrują się mieszkańcy gminy? Nie kryją rozczarowania, ale zapewniają, że do burmistrza pretensji nie mają.\n\n- <em>Szkoda, że się nie udało, ale nic nie straciliśmy. Natomiast podniesiono naszą świadomość, jak można oszczędzić środowisko. Obiecano również, że będziemy mogli skorzystać z podobnej możliwości za kilka lat </em>– mówili mieszkańcy gminy Ślesin.\n\nŹródło: Monika Marciniak - LM.pl\n\n&nbsp;\n\n__________\n\n&nbsp;\n\n<strong><img class="alignleft size-medium wp-image-522" src="http://gminaslesin.futurehost.pl/wp-content/uploads/2017/08/przegladkoninski3_03-300x78.png" alt="" width="300" height="78" />Wiele godzin przygotowań i setki stron dokumentacji, a wszystko to zostało zepsute. Chodzi o budowę ogniw fotowoltaicznych w ponad 350 gospodarstwach na terenie gminy Ślesin. Dlaczego tak się stało? Wniosku o dofinansowanie na czas nie złożyła firma Nuvarro, która wygrała przetarg na to zadanie. W jej imieniu miał to zrobić podwykonawca.</strong>\n– Ja dzisiaj nie mam nic na wytłumaczenie – tłumaczył prezes Nuvarro Dariusz Kałużny w hali widowiskowo-sportowej w Ślesinie. W spotkaniu wzięło udział wielu mieszkańców, którzy nie kryli rozgoryczenia, że to zadanie nie zostanie zrealizowane.\n\n– Nie mam dobrej informacji – powiedział Mariusz Zaborowski, burmistrz Ślesina. Wniosek o dofinansowanie nie został złożony, a miało to nastąpić do 31 sierpnia do godziny 15.30.\n\nZa przygotowanie studium wykonalności oraz złożenie wniosku dla gminy Ślesin odpowiadała firma Nuvarro, która miała dwóch podwykonawców.\n\n– Nie ma żadnej winy po stronie moich pracowników – powiedział burmistrz Ślesina. Dodając, że wręcz przeciwnie, wykonali oni kawał dobrej roboty, za którą należy im się nagroda, bo robili to poza godzinami pracy. Przygotowali umowy. A tych było naprawdę sporo. Inwestycja obejmowała ponad 350 prywatnych gospodarstw, gdzie miały pojawić się ogniska fotowoltaiczne wytwarzające energię o łącznej mocy 2 megawatów.\n\nMieszkańcy wpłacili po niecałe 300 złotych na wykonanie dokumentacji technicznej. Jak zapowiedział burmistrz, pieniądze będą im zwrócone. Umowa z firmą Nuvarro została zerwana. Musi ona też zapłacić gminie karę w wysokości 28 tysięcy złotych, ma również zobowiązania wobec firmy, która robiła dokumentację. Tutaj mowa jest o dziesiątkach tysięcy złotych. Co prezes Nuvarro powiedział dzisiaj mieszkańcom?\n– Wszelkie konsekwencje biorę na siebie. Jest mi przykro, bo taka sytuacja zdarzyła mi się pierwszy raz. Z programami unijnymi mam do czynienia od 2003 roku, także mógłbym powiedzieć, że to pech – powiedział Dariusz Kałużny. – Ja dzisiaj nie mam nic na wytłumaczenie, bo go nie ma na sytuację, w której wniosek nie zostaje złożony o godzinie 15.30.\n\nJako zadośćuczynienie wszyscy uczestnicy otrzymali za darmo projekty techniczne.\n– Każdemu mogą posłużyć do tego, żeby w przyszłości tę instalację fotowoltaiczną założyć czy też skorzystać z jakiegoś innego źródła – powiedział Dariusz Kałużny.\n\nCzy gdyby ten wniosek, został w porę złożony, miał szansę otrzymać dofinansowanie i być zrealizowany? Pojawiło się podczas spotkania stwierdzenie, że możliwości pozyskania środków były niezbyt duże. Mimo to niesmak pozostanie, że wniosek nie został złożony na czas.\n\n&nbsp;\n\nŹródło: Przegląd Koniński', 'Nie udało się pozyskać funduszy. Mieszkańcy zawiedzeni', '', 'inherit', 'closed', 'closed', '', '775-revision-v1', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 775, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=950', 0, 'revision', '', 0),
 (951, 1, '2017-10-23 15:48:03', '2017-10-23 15:48:03', '[caption id="" align="alignleft" width="275"]<img class="size-medium" src="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/21731050_150546038875235_5198171636594666125_n.jpg?oh=5645f653fbed008d46485b66689ef49e&amp;oe=5A60A8F9" width="275" height="183" /> facebook.com/lksslesin/[/caption]\n\n<strong>Nie lada atrakcje szykują się nam w sobotni dzień na stadionie Miejskim przy ul. Napoleona 1 w Ślesinie.</strong>\n\n<!--more-->Najpierw Juniorzy Starsi w debiucie nowego trenera Marcina Łukowskiego podejmą Górnik Konin. Start tego spotkania o 11:00.\n\nW drugim meczu tego dnia Młodziki Starsze, trenera Bartłomieja Sieka, zmierzą swoje siły z Orłem Grzegorzew o godzinie 13:45.\n<div class="text_exposed_show">\n\nPrzysłowiową wisieńką na torcie bedzie mecz rozgrywany o godzinie 17:00.\nLKS Ślesin vs Piast Grodziec\n\nPodopieczni Macieja Bieniaszczyka będą starali sie zachować zwycieską passę u siebie i wywalczyć komplet punktów.\n\nNa wszystkie te spotkania serdecznie zapraszamy wspierających kibiców. Powodzenia Skicioki!\n\n</div>', 'Sportowa sobota w Ślesinie', '', 'inherit', 'closed', 'closed', '', '773-revision-v1', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 773, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=951', 0, 'revision', '', 0),
 (952, 1, '2017-10-23 15:48:03', '2017-10-23 15:48:03', '<strong>Zapraszamy wszystkich do udziału 24.09.2017. Start o godz. 14:00. Będą konkursy, atrakcje, KGW zaprezentują swoje potrawy a zagra zespół Belfast. Szykuje się super impreza.</strong>\n\n[caption id="" align="aligncenter" width="511"]<a href="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/21742856_1293952734066117_5474592675068610360_n.jpg?oh=914038510fe1dd36a1dd3c1191ccf2f6&amp;oe=5A55920E"><img class="" src="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/21742856_1293952734066117_5474592675068610360_n.jpg?oh=914038510fe1dd36a1dd3c1191ccf2f6&amp;oe=5A55920E" width="511" height="720" /></a> facebook.com/gminaslesin/[/caption]', 'Kolejna edycja Jarmarku Ochweśnickiego już wkrótce', '', 'inherit', 'closed', 'closed', '', '771-revision-v1', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 771, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=952', 0, 'revision', '', 0),
 (953, 1, '2017-10-23 15:48:03', '2017-10-23 15:48:03', '[caption id="" align="alignleft" width="222"]<img class="" src="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/21751524_1746492838986143_8395721874176759485_n.jpg?oh=29da5ad6473d7c406f220a347a273ac0&amp;oe=5A515E76" width="222" height="148" /> facebook.com/mgokslesin/[/caption]\n\n<strong>W tegorocznych rozgrywkach uczestniczyło 10 drużyn. Poszczególne mecze w rozgrywkach każdy z każdym odbywały się na boiskach ORLIK. Przez dziewięć niedzieli piłkarze walczyli o miano najlepszej drużyny.</strong>\n\n<!--more-->\n\nZwycięzcą Ligi 2017 została drużyna OSIEDLA PÓŁNOC (8 meczy wygranych i jeden remis).\n\nKolejne miejsca to:\n\nII- Piotrkowice,\n\nIII – Osiedle Powstańców Wielkopolskich,\n\nIV -Głębockie/Mikorzyn,\n\nV- Wąsosze,\n\nV<span class="text_exposed_show">I- Szyszyńskie Holendry, </span>\n\n<span class="text_exposed_show">VII- Półwiosek Stary, </span>\n\n<span class="text_exposed_show">VIII- Szyszyn i Ignacewo, </span>\n\n<span class="text_exposed_show">IX- Honoratka. </span>\n\n<span class="text_exposed_show">\nKrólem strzelców został Kornel Broniszewski zdobywając w ciągu trwania całej Ligii aż 27 bramek. </span>\n\n<span class="text_exposed_show">19 goli strzelił Tomasz Staszak, 18- Bartosz Nowak, 17- Mateusz Waleriańczyk. </span>\n\n&nbsp;\n\n<span class="text_exposed_show">Nagrody w postaci bonów na sprzęt sportowy wręczył Burmistrz Miasta i Gminy Ślesin Mariusz Zaborowski. Organizatorzy składają podziękowania dla instruktorów boisk sportowych ORLIK za współpracę w organizację tegorocznej ligi.</span>', 'Sołecka Liga Piłki Nożnej Sołectw i Osiedli Gminy Ślesin 2017 zakończona', '', 'inherit', 'closed', 'closed', '', '765-revision-v1', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 765, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=953', 0, 'revision', '', 0),
 (954, 1, '2017-10-23 15:48:03', '2017-10-23 15:48:03', '[caption id="" align="alignleft" width="267"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1746498872318873/1746498552318905/?type=3&amp;theater"><img class="" src="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/21730879_1746498552318905_6669082589883284157_n.jpg?oh=50a1b6f2ec42907e4e1e9a5d1b2fd075&amp;oe=5A13A811" width="267" height="178" /></a> facebook.com/mgokslesin/[/caption]\n\n<strong>„Święto Kapusty” po raz kolejny przyciągnęło wiele osób do Honoratki. W tym Sołectwie już nawet najmłodsze dzieci wiedzą, jak smakuje kapusta. Prześcigają się w pomysłach. W tym roku zorganizowały „PCHLI TARG”, czyli kupię – sprzedam – zamianię, wystawiając swoje dawno nie używane już zabawki.</strong>\n\n<!--more-->\n\nMożna było spotkać także Panie z Kół Gospodyń Wiejskich z Gminy Ślesin, które rywalizowały w konkursach na „Potrawę z Kapusty” oraz w konkursie zręcznościowym, który jednocześnie był pokaz<span class="text_exposed_show">em szatkowania, heblowania i ubijania kapusty dawnymi przedmiotami niezbędnymi w kuchni. Panie raczyły smakoszy potrawami z popularnego warzywa. Nie zabrakło gołąbków, bigosu, kapusty z grochem i fasolą. </span>\n\n<span class="text_exposed_show">Najwięcej emocji wzbudziło deptanie kapusty w którym udział wzięli m.in. sołtys Honoratki - Zbigniew Siupa, radny Sołectwa Honoratki - Paweł Janczewski. Odbyły się także występy solistek Akademii Wokalnej DoReMi z M-GOK w Ślesinie– Mai Bartczak i Wiktorii Długołenckiej, oraz zumba dla najmłodszych . Impreza zakończyła się zabawa taneczną. </span>\n\n<span class="text_exposed_show">Tegoroczne „Święto Kapusty” zorganizowało Koło Gospodyń Wiejskich w Honoratce, Rada Sołecka Sołectwa w Honoratce oraz OSP Honoratka.</span>', 'Święto Kapusty w Honoratce', '', 'inherit', 'closed', 'closed', '', '763-revision-v1', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 763, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=954', 0, 'revision', '', 0),
 (955, 1, '2017-10-23 15:48:03', '2017-10-23 15:48:03', '<strong><img class="alignleft " src="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/12043165_1487575074877922_1776478986692669327_n.jpg?oh=b9c235ddda4f11efa3384c379a75958b&amp;oe=5A51A601" width="159" height="125" />Seniorzy z Klubu Seniora w dniach 24-30 sierpnia udali się na 7-dniowa wycieczkę do Dziwnowa. Podczas wycieczki seniorzy zwiedzili wystawę sprzętu wojskowego, byli również na festynie Komandosa.</strong>\n\n<!--more-->\n\nNie zabrakło wieczornych spacerów po plaży oraz wieczorków tanecznych. Odbyli także wycieczkę do Międzyzdrojów gdzie zwiedzili Promenadę Gwiazd oraz Muzeum Figur Woskowych. Seniorzy wrócili z wypoczynku zrelaksowani i gotowi do działań w nowym roku kulturalnym 2017/2018. Seniorzy składają podziękowania Panu Burmistrzowi za udostepnienie autobusu, a Zarządowi Banku Spółdzielczego w Ślesinie za ufundowanie biletów do Muzeum Figur Woskowych.', 'Klub Seniora Pogodna Jesień z Miejsko-Gminnego Ośrodka Kultury w Ślesinie na wakacjach', '', 'inherit', 'closed', 'closed', '', '761-revision-v1', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 761, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=955', 0, 'revision', '', 0),
 (956, 1, '2017-10-23 15:48:03', '2017-10-23 15:48:03', '[caption id="" align="alignleft" width="264"]<a href="https://www.lm.pl/aktualnosci/informacja/111334/lichen_i_xiv_ogolnopolska_pielgrzymka_honorowych_dawcow_krwi"><img class="" src="https://m.lm.pl/media/foto/292545_5846_350.jpg" width="264" height="148" /></a> LM.pl[/caption]\n\n<strong>Do sanktuarium maryjnego w Licheniu przybyła XIV ogólnopolska pielgrzymka honorowych dawców krwi.</strong>\n\nPodczas uroczystej mszy ks. Mirosław Frankowski, duszpasterz Honorowych Dawców Krwi diecezji włocławskiej, przekazał na ręce ks. Adama Stankiewicza MIC, wicekustosza licheńskiego sanktuarium, akt nadania medalu 30-lecia Klubu Honorowych Dawców Krwi PCK przy Spółdzielni Mieszkaniowej w Swarzędzu dla Sanktuarium Matki Bożej Licheńskiej w Licheniu Starym. Krwiodawcom dziękowano natomiast za postawę godną naśladowania.<img class="size-full wp-image-503 alignright" src="http://serwer1761710.home.pl/autoinstalator/wordpress/wp-content/uploads/2017/08/240915_logo_standard.png" alt="" width="175" height="70" />\n\nPielgrzymi udali się jeszcze na plac z trzema dzwonami, gdzie uczestnictwem w Drodze Krzyżowej zakończyli tegoroczne pielgrzymowanie.', 'Licheń i XIV ogólnopolska pielgrzymka honorowych dawców krwi', '', 'inherit', 'closed', 'closed', '', '759-revision-v1', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 759, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=956', 0, 'revision', '', 0),
 (957, 1, '2017-10-23 15:48:03', '2017-10-23 15:48:03', '[caption id="" align="alignleft" width="312"]<a href="https://www.lm.pl/aktualnosci/informacja/111344/kilka_tysiecy_uczestniczek_na_zjezdzie_kol_gospodyn_wiejskich"><img class="" src="https://m.lm.pl/media/foto/292723_3141_714.jpg" width="312" height="208" /></a> Źródło: LM.pl[/caption]\n\n<strong>Kilka tysięcy uczestniczek na ogólnopolskim zjeździe Kół Gospodyń Wiejskich w Licheniu.</strong>\n\n<!--more-->\n\nNajpierw uczestniczki spotkały się na jarmarku kulturowym nad jeziorem Licheńskim, gdzie m.in. odbył się przegląd zespołów folklorystycznych. Smakosze mogli skosztować regionalnych specjałów przygotowanych przez gospodynie specjalnie na tę okazję. Z kolei na boisku sportowym za szkołą podstawową po raz pierwszy zorganizowano turniej piłki nożnej gospodyń.\n\nZdaniem pani Wandy Waleriańczyk, prezes Stowarzyszenia Polska Gospodyni, licheński zjazd jest przede wszystkim okazją do spotkania się kobiet polskiej wsi w celu wymiany doświadczeń kobiet mieszkających w różnych zakątkach kraju.\n\nW niedzielę gospodynie przeszły w tzw. „różańcowym spacerku” z kościoła pw. św. Doroty do miejsca objawień Matki Bożej w lesie grąblińskim. Natomiast o godz. 12.00 uczestniczki zjazdu udały się na mszę w bazylice, której przewodniczył ks. Bogusław Binda MIC, przełożony licheńskiej wspólnoty marianów. Oprawę muzyczną mszy zapewnił zespół „Dębowiacy” z gminy Stupsk Mazowiecki (powiat mławski) oraz Pałac Kultury Zagłębia i Koło Gospodyń „Tucznawa” z Dąbrowy Górniczej. Zwieńczeniem pielgrzymki było wspólne odśpiewanie „Barki” przed pomnikiem św. Jana Pawła II znajdującym się przed licheńską bazyliką.\n\nVII Ogólnopolski Zjazd Kół Gospodyń Wiejskich i Innych Organizacji Kobiecych z Terenów Wiejskich zorganizowało Stowarzyszenie Polska Gospodyni. Patronat honorowy nad wydarzeniem sprawował pan Andrzej Duda, Prezydent Rzeczypospolitej Polskiej.\n\nŹródło: LM.pl', 'Kilka tysięcy uczestniczek na zjeździe Kół Gospodyń Wiejskich', '', 'inherit', 'closed', 'closed', '', '757-revision-v1', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 757, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=957', 0, 'revision', '', 0),
 (958, 1, '2017-10-23 15:48:03', '2017-10-23 15:48:03', '<div id="js_ro" class="_5pbx userContent" data-ft="{&quot;tn&quot;:&quot;K&quot;}">\n<div id="id_59b703596a7cf0980313985" class="text_exposed_root text_exposed">\n\n[caption id="" align="alignleft" width="136"]<a href="https://www.facebook.com/mgokslesin/photos/pcb.1746299739005453/1746298172338943/?type=3&amp;theater"><img class="" src="https://scontent-frx5-1.xx.fbcdn.net/v/t1.0-9/21462745_1746298172338943_166484630718463813_n.jpg?oh=6fbcde17979a848e70c6ec1428b80fda&amp;oe=5A17F44D" width="136" height="242" /></a> facebook.com/mgokslesin/[/caption]\n\n<strong>Jedenastu zawodników Klubu Szachowego M-GOK Gambit Ślesin wzięło udział w niedzielnym turnieju szachowym i bowlingowym Szach-Strike-Mat w Poznaniu. Turniej odbył się w Centrum Rozrywki MK BOWLING w Galerii MM w Poznaniu.</strong>\n\n<!--more-->\n\nByła to kolejna edycja turnieju łączącego szachy z inną dyscypliną sportową. W ramach turnieju rozegrano dwa indywidualne turnieje: szachowy i bowlingowy z podziałem na kategorie wiekowe turniej A dla d<span class="text_exposed_show">zieci do III klasy szkoły podstawowej, turniej B dla dzieci od IV do VII klasy szkoły podstawowej, turniej C dla dzieci i młodzieży szkół ponadpodstawowych, turniej D dla dorosłych. W turnieju można było zdobywać punkty w szachach jak i w bowlingu, które na zakończenie były sumowane.</span>\n\n<span class="text_exposed_show">Był to pierwszy taki turniej dla naszych szachistów, w którym poradzili sobie bardzo dobrze zdobywając miejsca na podium.</span>\n<div class="text_exposed_show">\n\nW klasyfikacji łącznej obu dyscyplin zajęliśmy następujące miejsca:\n\nAda Chojnacka pierwsze miejsce w turnieju A grupa dziewcząt\nTymoteusz Łachacz drugie miejsce w turnieju A grupa chłopców\nMichał Pawlak drugie miejsce w turnieju B grupa chłopców\nNikola Majdecka pierwsze miejsce w turnieju C grupa dziewcząt\nSebastian Sajniak drugie miejsce w turnieju C grupa chłopców\nArkadiusz Łapot trzecie miejsce w turnieju C grupa chłopców\n\n</div>\n</div>\n</div>\n&nbsp;\n<div class="_3x-2"></div>', 'Sześciu szachistów na podium Szach-Strike-Mat w Poznaniu', '', 'inherit', 'closed', 'closed', '', '755-revision-v1', '', '', '2017-10-23 15:48:03', '2017-10-23 15:48:03', '', 755, 'http://serwer1761710.home.pl/autoinstalator/wordpress/?p=958', 0, 'revision', '', 0),
 (959, 1, '2017-10-23 15:48:03', '2017-10-23 15:48:03', '[caption id="" align="alignleft" width="1